/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.base;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.plugin.base.PluginAdapterBase;
import com.vaadin.flow.plugin.base.PluginAdapterBuild;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.CvdlProducts;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendToolsSettings;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.NodeTasks;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.scanner.ReflectionsClassFinder;
import com.vaadin.flow.utils.FlowFileUtils;
import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.Product;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.InvalidExitValueException;
import org.zeroturnaround.exec.ProcessExecutor;

public class BuildFrontendUtil {
    private BuildFrontendUtil() {
    }

    public static ClassFinder getClassFinder(List<String> classpathElements) {
        URL[] urls = (URL[])classpathElements.stream().distinct().map(File::new).map(FlowFileUtils::convertToUrl).toArray(URL[]::new);
        return new ReflectionsClassFinder(urls);
    }

    public static File getTokenFile(PluginAdapterBase adapter) {
        return new File(adapter.servletResourceOutputDirectory(), "config/flow-build-info.json");
    }

    public static void prepareFrontend(PluginAdapterBase adapter) throws IOException, ExecutionFailedException, URISyntaxException {
        URI nodeDownloadRootURI = adapter.nodeDownloadRoot();
        FrontendToolsSettings settings = BuildFrontendUtil.getFrontendToolsSettings(adapter);
        FrontendTools tools = new FrontendTools(settings);
        tools.validateNodeAndNpmVersion();
        try {
            FileUtils.forceMkdir((File)adapter.generatedFolder());
        }
        catch (IOException e) {
            throw new IOException("Failed to create folder '" + adapter.generatedFolder() + "'. Verify that you may write to path.", e);
        }
        File flowResourcesFolder = new File(adapter.npmFolder(), Paths.get(adapter.buildFolder(), "flow-frontend").toString());
        ClassFinder classFinder = adapter.getClassFinder();
        Lookup lookup = adapter.createLookup(classFinder);
        NodeTasks.Builder builder = new NodeTasks.Builder(lookup, adapter.npmFolder(), adapter.generatedFolder(), adapter.frontendDirectory(), adapter.buildFolder()).useV14Bootstrap(adapter.isUseDeprecatedV14Bootstrapping()).withFlowResourcesFolder(flowResourcesFolder).createMissingPackageJson(true).enableImportsUpdate(false).enablePackagesUpdate(false).runNpmInstall(false).withFrontendGeneratedFolder(adapter.generatedTsFolder()).withNodeVersion(adapter.nodeVersion()).withNodeDownloadRoot(nodeDownloadRootURI).setNodeAutoUpdate(adapter.nodeAutoUpdate()).withHomeNodeExecRequired(adapter.requireHomeNodeExec()).setJavaResourceFolder(adapter.javaResourceFolder()).withProductionMode(adapter.productionMode());
        builder.copyResources(adapter.getJarFiles());
        try {
            builder.build().execute();
        }
        catch (ExecutionFailedException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new ExecutionFailedException("Error occured during goal execution: " + throwable.getMessage() + "\n\nPlease run Maven with the -e switch (or Gradle with the --stacktrace switch), to learn the full stack trace.", throwable);
        }
    }

    private static FrontendToolsSettings getFrontendToolsSettings(PluginAdapterBase adapter) throws URISyntaxException {
        FrontendToolsSettings settings = new FrontendToolsSettings(adapter.npmFolder().getAbsolutePath(), (SerializableSupplier & Serializable)() -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath());
        settings.setNodeDownloadRoot(adapter.nodeDownloadRoot());
        settings.setNodeVersion(adapter.nodeVersion());
        settings.setAutoUpdate(adapter.nodeAutoUpdate());
        settings.setUseGlobalPnpm(adapter.useGlobalPnpm());
        settings.setForceAlternativeNode(adapter.requireHomeNodeExec());
        return settings;
    }

    public static File propagateBuildInfo(PluginAdapterBase adapter) {
        File token = new File(adapter.servletResourceOutputDirectory(), "config/flow-build-info.json");
        JsonObject buildInfo = Json.createObject();
        buildInfo.put("productionMode", adapter.productionMode());
        buildInfo.put("useDeprecatedV14Bootstrapping", adapter.isUseDeprecatedV14Bootstrapping());
        buildInfo.put("eagerServerLoad", adapter.eagerServerLoad());
        buildInfo.put("npmFolder", adapter.npmFolder().getAbsolutePath());
        buildInfo.put("node.version", adapter.nodeVersion());
        try {
            buildInfo.put("node.download.root", adapter.nodeDownloadRoot().toString());
        }
        catch (URISyntaxException e) {
            LoggerFactory.getLogger((String)"BuildInfo").error("Configuration 'nodeDownloadRoot'  (property 'node.download.root') is defined incorrectly", (Throwable)e);
        }
        buildInfo.put("generatedFolder", adapter.generatedFolder().getAbsolutePath());
        buildInfo.put("frontendFolder", adapter.frontendDirectory().getAbsolutePath());
        buildInfo.put("connect.javaSourceFolder", adapter.javaSourceFolder().getAbsolutePath());
        buildInfo.put("javaResourceFolder", adapter.javaResourceFolder().getAbsolutePath());
        buildInfo.put("connect.applicationProperties", adapter.applicationProperties().getAbsolutePath());
        buildInfo.put("connect.openApiFile", adapter.openApiJsonFile().getAbsolutePath());
        buildInfo.put("project.frontend.generated", adapter.generatedTsFolder().getAbsolutePath());
        buildInfo.put("pnpm.enable", adapter.pnpmEnable());
        buildInfo.put("require.home.node", adapter.requireHomeNodeExec());
        buildInfo.put("build.folder", adapter.buildFolder());
        try {
            FileUtils.forceMkdir((File)token.getParentFile());
            FileUtils.write((File)token, (CharSequence)(JsonUtil.stringify((JsonValue)buildInfo, (int)2) + "\n"), (String)StandardCharsets.UTF_8.name());
            if (adapter.isDebugEnabled()) {
                adapter.logDebug(String.format("%n>>> Running prepare-frontend%nSystem.properties:%n productionMode: %s%n webpackPort: %s%n project.basedir: %s%nGoal parameters:%n productionMode: %s%n npmFolder: %s%nToken file: %s%nToken content: %s%n", adapter.productionMode(), System.getProperty("vaadin.devmode.webpack.running-port"), adapter.projectBaseDirectory(), adapter.productionMode(), adapter.npmFolder(), token.getAbsolutePath(), buildInfo.toJson()));
            }
            return token;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void runNodeUpdater(PluginAdapterBuild adapter) throws ExecutionFailedException, URISyntaxException {
        Set<File> jarFiles = adapter.getJarFiles();
        File flowResourcesFolder = new File(adapter.npmFolder(), Paths.get(adapter.buildFolder(), "flow-frontend").toString());
        URI nodeDownloadRootURI = adapter.nodeDownloadRoot();
        ClassFinder classFinder = adapter.getClassFinder();
        Lookup lookup = adapter.createLookup(classFinder);
        try {
            new NodeTasks.Builder(lookup, adapter.npmFolder(), adapter.generatedFolder(), adapter.frontendDirectory(), adapter.buildFolder()).runNpmInstall(adapter.runNpmInstall()).withWebpack(adapter.webpackOutputDirectory(), adapter.servletResourceOutputDirectory()).useV14Bootstrap(adapter.isUseDeprecatedV14Bootstrapping()).enablePackagesUpdate(true).useByteCodeScanner(adapter.optimizeBundle()).withFlowResourcesFolder(flowResourcesFolder).copyResources(jarFiles).copyTemplates(true).copyLocalResources(adapter.frontendResourcesDirectory()).enableImportsUpdate(true).withEmbeddableWebComponents(adapter.generateEmbeddableWebComponents()).withTokenFile(BuildFrontendUtil.getTokenFile(adapter)).enablePnpm(adapter.pnpmEnable()).useGlobalPnpm(adapter.useGlobalPnpm()).withApplicationProperties(adapter.applicationProperties()).withEndpointSourceFolder(adapter.javaSourceFolder()).withEndpointGeneratedOpenAPIFile(adapter.openApiJsonFile()).withFrontendGeneratedFolder(adapter.generatedTsFolder()).withHomeNodeExecRequired(adapter.requireHomeNodeExec()).withNodeVersion(adapter.nodeVersion()).withNodeDownloadRoot(nodeDownloadRootURI).setNodeAutoUpdate(adapter.nodeAutoUpdate()).setJavaResourceFolder(adapter.javaResourceFolder()).withPostinstallPackages(adapter.postinstallPackages()).build().execute();
        }
        catch (ExecutionFailedException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new ExecutionFailedException("Error occured during goal execution: " + throwable.getMessage() + "Please run Maven with the -e switch (or Gradle with the --stacktrace switch), to learn the full stack trace.", throwable);
        }
    }

    public static void runFrontendBuild(PluginAdapterBase adapter) throws TimeoutException, URISyntaxException {
        FeatureFlags featureFlags = BuildFrontendUtil.getFeatureFlags(adapter);
        if (featureFlags.isEnabled(FeatureFlags.NEW_LICENSE_CHECKER)) {
            LicenseChecker.setStrictOffline((boolean)true);
        }
        FrontendToolsSettings settings = BuildFrontendUtil.getFrontendToolsSettings(adapter);
        FrontendTools tools = new FrontendTools(settings);
        tools.validateNodeAndNpmVersion();
        if (featureFlags.isEnabled(FeatureFlags.VITE)) {
            BuildFrontendUtil.runVite(adapter, tools);
        } else {
            BuildFrontendUtil.runWebpack(adapter, tools);
        }
    }

    public static void runWebpack(PluginAdapterBase adapter, FrontendTools frontendTools) throws TimeoutException, URISyntaxException {
        BuildFrontendUtil.runFrontendBuildTool(adapter, frontendTools, "Webpack", "webpack/bin/webpack.js", frontendTools.getWebpackNodeEnvironment(), new String[0]);
    }

    public static void runVite(PluginAdapterBase adapter, FrontendTools frontendTools) throws TimeoutException, URISyntaxException {
        BuildFrontendUtil.runFrontendBuildTool(adapter, frontendTools, "Vite", "vite/bin/vite.js", Collections.emptyMap(), "build");
    }

    private static void runFrontendBuildTool(PluginAdapterBase adapter, FrontendTools frontendTools, String toolName, String executable, Map<String, String> environment, String ... params) throws TimeoutException, URISyntaxException {
        File buildExecutable = new File(adapter.npmFolder(), "node_modules/" + executable);
        if (!buildExecutable.isFile()) {
            throw new IllegalStateException(String.format("Unable to locate %s executable by path '%s'. Double check that the plugin is executed correctly", toolName, buildExecutable.getAbsolutePath()));
        }
        String nodePath = adapter.requireHomeNodeExec() ? frontendTools.forceAlternativeNodeExecutable() : frontendTools.getNodeExecutable();
        ArrayList<String> command = new ArrayList<String>();
        command.add(nodePath);
        command.add(buildExecutable.getAbsolutePath());
        command.addAll(Arrays.asList(params));
        ProcessBuilder builder = FrontendUtils.createProcessBuilder(command);
        ProcessExecutor processExecutor = new ProcessExecutor().command(builder.command()).environment(builder.environment()).environment(environment).directory(adapter.projectBaseDirectory().toFile());
        adapter.logInfo("Running " + toolName + " ...");
        if (adapter.isDebugEnabled()) {
            adapter.logDebug(FrontendUtils.commandToString((String)adapter.npmFolder().getAbsolutePath(), command));
        }
        try {
            processExecutor.exitValueNormal().readOutput(true).destroyOnExit().execute();
        }
        catch (InvalidExitValueException e) {
            throw new IllegalStateException(String.format("%s process exited with non-zero exit code.%nStderr: '%s'", toolName, e.getResult().outputUTF8()), e);
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException(String.format("Failed to run %s due to an error", toolName), e);
        }
        BuildFrontendUtil.validateLicenses(adapter);
    }

    private static void validateLicenses(PluginAdapterBase adapter) {
        File nodeModulesFolder = new File(adapter.npmFolder(), "node_modules/");
        FeatureFlags featureFlags = BuildFrontendUtil.getFeatureFlags(adapter);
        if (!featureFlags.isEnabled(FeatureFlags.NEW_LICENSE_CHECKER)) {
            return;
        }
        File outputFolder = adapter.webpackOutputDirectory();
        File statsFile = new File(adapter.servletResourceOutputDirectory(), "config//stats.json");
        if (!statsFile.exists()) {
            throw new RuntimeException("Stats file " + statsFile + " does not exist");
        }
        List<Product> commercialComponents = BuildFrontendUtil.findCommercialComponents(nodeModulesFolder, statsFile);
        for (Product component : commercialComponents) {
            try {
                LicenseChecker.checkLicense((String)component.getName(), (String)component.getVersion(), (BuildType)BuildType.PRODUCTION);
            }
            catch (Exception e) {
                try {
                    BuildFrontendUtil.getLogger().debug("License check for {} failed. Invalidating output", (Object)component);
                    FileUtils.deleteDirectory((File)outputFolder);
                }
                catch (IOException e1) {
                    BuildFrontendUtil.getLogger().debug("Failed to remove {}", (Object)outputFolder);
                }
                throw e;
            }
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(BuildFrontendUtil.class);
    }

    private static List<Product> findCommercialComponents(File nodeModulesFolder, File statsFile) {
        ArrayList<Product> arrayList;
        ArrayList<Product> components = new ArrayList<Product>();
        FileInputStream in = new FileInputStream(statsFile);
        try {
            String contents = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            JsonArray npmModules = Json.parse((String)contents).getArray("npmModules");
            for (int i = 0; i < npmModules.length(); ++i) {
                String npmModule = npmModules.getString(i);
                Product product = CvdlProducts.getProductIfCvdl((File)nodeModulesFolder, (String)npmModule);
                if (product == null) continue;
                components.add(product);
            }
            arrayList = components;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Error reading file " + statsFile, e);
            }
        }
        ((InputStream)in).close();
        return arrayList;
    }

    private static FeatureFlags getFeatureFlags(PluginAdapterBase adapter) {
        ClassFinder classFinder = adapter.getClassFinder();
        Lookup lookup = adapter.createLookup(classFinder);
        FeatureFlags featureFlags = new FeatureFlags(lookup);
        featureFlags.setPropertiesLocation(adapter.javaResourceFolder());
        return featureFlags;
    }

    public static void updateBuildFile(PluginAdapterBuild adapter) {
        File tokenFile = BuildFrontendUtil.getTokenFile(adapter);
        if (!tokenFile.exists()) {
            adapter.logWarn("Couldn't update devMode token due to missing token file.");
            return;
        }
        try {
            String json = FileUtils.readFileToString((File)tokenFile, (String)StandardCharsets.UTF_8.name());
            JsonObject buildInfo = (JsonObject)JsonUtil.parse((String)json);
            buildInfo.remove("npmFolder");
            buildInfo.remove("node.version");
            buildInfo.remove("node.download.root");
            buildInfo.remove("generatedFolder");
            buildInfo.remove("frontendFolder");
            buildInfo.remove("pnpm.enable");
            buildInfo.remove("require.home.node");
            buildInfo.remove("devmode.optimizeBundle");
            buildInfo.remove("connect.javaSourceFolder");
            buildInfo.remove("javaResourceFolder");
            buildInfo.remove("connect.applicationProperties");
            buildInfo.remove("connect.openApiFile");
            buildInfo.remove("project.frontend.generated");
            buildInfo.remove("build.folder");
            buildInfo.put("enableDevServer", false);
            FileUtils.write((File)tokenFile, (CharSequence)(JsonUtil.stringify((JsonValue)buildInfo, (int)2) + "\n"), (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            adapter.logWarn("Unable to read token file", e);
        }
    }
}

