/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.base;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.plugin.base.PluginAdapterBase;
import com.vaadin.flow.plugin.base.PluginAdapterBuild;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.BundleValidationUtil;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendToolsSettings;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.NodeTasks;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.server.scanner.ReflectionsClassFinder;
import com.vaadin.flow.utils.FlowFileUtils;
import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.Product;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.InvalidExitValueException;
import org.zeroturnaround.exec.ProcessExecutor;

public class BuildFrontendUtil {
    private BuildFrontendUtil() {
    }

    public static ClassFinder getClassFinder(List<String> classpathElements) {
        URL[] urls = (URL[])classpathElements.stream().distinct().map(File::new).map(FlowFileUtils::convertToUrl).toArray(URL[]::new);
        return new ReflectionsClassFinder(urls);
    }

    public static File getTokenFile(PluginAdapterBase adapter) {
        return new File(adapter.servletResourceOutputDirectory(), "config/flow-build-info.json");
    }

    public static void prepareFrontend(PluginAdapterBase adapter) throws IOException, ExecutionFailedException, URISyntaxException {
        URI nodeDownloadRootURI = adapter.nodeDownloadRoot();
        FrontendToolsSettings settings = BuildFrontendUtil.getFrontendToolsSettings(adapter);
        FrontendTools tools = new FrontendTools(settings);
        tools.validateNodeAndNpmVersion();
        ClassFinder classFinder = adapter.getClassFinder();
        Lookup lookup = adapter.createLookup(classFinder);
        Options options = new Options(lookup, adapter.npmFolder()).withFrontendDirectory(adapter.frontendDirectory()).withBuildDirectory(adapter.buildFolder()).withJarFrontendResourcesFolder(BuildFrontendUtil.getJarFrontendResourcesFolder(adapter)).createMissingPackageJson(new File(adapter.npmFolder(), "package.json").exists()).enableImportsUpdate(false).enablePackagesUpdate(false).withRunNpmInstall(false).withFrontendGeneratedFolder(adapter.generatedTsFolder()).withNodeVersion(adapter.nodeVersion()).withNodeDownloadRoot(nodeDownloadRootURI).setNodeAutoUpdate(adapter.nodeAutoUpdate()).withHomeNodeExecRequired(adapter.requireHomeNodeExec()).setJavaResourceFolder(adapter.javaResourceFolder()).withProductionMode(false);
        options.copyResources(adapter.getJarFiles());
        try {
            new NodeTasks(options).execute();
        }
        catch (ExecutionFailedException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new ExecutionFailedException("Error occured during goal execution: " + throwable.getMessage() + "\n\nPlease run Maven with the -e switch (or Gradle with the --stacktrace switch), to learn the full stack trace.", throwable);
        }
    }

    private static File getJarFrontendResourcesFolder(PluginAdapterBase adapter) {
        return new File(new File(adapter.frontendDirectory(), "generated/"), "jar-resources");
    }

    private static FrontendToolsSettings getFrontendToolsSettings(PluginAdapterBase adapter) throws URISyntaxException {
        FrontendToolsSettings settings = new FrontendToolsSettings(adapter.npmFolder().getAbsolutePath(), (SerializableSupplier & Serializable)() -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath());
        settings.setNodeDownloadRoot(adapter.nodeDownloadRoot());
        settings.setNodeVersion(adapter.nodeVersion());
        settings.setAutoUpdate(adapter.nodeAutoUpdate());
        settings.setUseGlobalPnpm(adapter.useGlobalPnpm());
        settings.setForceAlternativeNode(adapter.requireHomeNodeExec());
        return settings;
    }

    public static File propagateBuildInfo(PluginAdapterBase adapter) {
        File token = new File(adapter.servletResourceOutputDirectory(), "config/flow-build-info.json");
        JsonObject buildInfo = Json.createObject();
        buildInfo.put("productionMode", false);
        buildInfo.put("eagerServerLoad", adapter.eagerServerLoad());
        buildInfo.put("npmFolder", adapter.npmFolder().getAbsolutePath());
        buildInfo.put("node.version", adapter.nodeVersion());
        if (adapter.isFrontendHotdeploy()) {
            buildInfo.put("frontend.hotdeploy", adapter.isFrontendHotdeploy());
        }
        try {
            buildInfo.put("node.download.root", adapter.nodeDownloadRoot().toString());
        }
        catch (URISyntaxException e) {
            LoggerFactory.getLogger((String)"BuildInfo").error("Configuration 'nodeDownloadRoot'  (property 'node.download.root') is defined incorrectly", (Throwable)e);
        }
        buildInfo.put("frontendFolder", adapter.frontendDirectory().getAbsolutePath());
        buildInfo.put("connect.javaSourceFolder", adapter.javaSourceFolder().getAbsolutePath());
        buildInfo.put("javaResourceFolder", adapter.javaResourceFolder().getAbsolutePath());
        buildInfo.put("connect.applicationProperties", adapter.applicationProperties().getAbsolutePath());
        buildInfo.put("connect.openApiFile", adapter.openApiJsonFile().getAbsolutePath());
        buildInfo.put("project.frontend.generated", adapter.generatedTsFolder().getAbsolutePath());
        buildInfo.put("pnpm.enable", adapter.pnpmEnable());
        buildInfo.put("require.home.node", adapter.requireHomeNodeExec());
        buildInfo.put("build.folder", adapter.buildFolder());
        try {
            FileUtils.forceMkdir((File)token.getParentFile());
            FileUtils.write((File)token, (CharSequence)(JsonUtil.stringify((JsonValue)buildInfo, (int)2) + "\n"), (String)StandardCharsets.UTF_8.name());
            if (adapter.isDebugEnabled()) {
                adapter.logDebug(String.format("%n>>> Running prepare-frontend%nSystem.properties:%n project.basedir: %s%nGoal parameters:%n npmFolder: %s%nToken file: %s%nToken content: %s%n", adapter.projectBaseDirectory(), adapter.npmFolder(), token.getAbsolutePath(), buildInfo.toJson()));
            }
            return token;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void runNodeUpdater(PluginAdapterBuild adapter) throws ExecutionFailedException, URISyntaxException {
        Set<File> jarFiles = adapter.getJarFiles();
        URI nodeDownloadRootURI = adapter.nodeDownloadRoot();
        ClassFinder classFinder = adapter.getClassFinder();
        Lookup lookup = adapter.createLookup(classFinder);
        try {
            Options options = new Options(lookup, adapter.npmFolder()).withFrontendDirectory(adapter.frontendDirectory()).withBuildDirectory(adapter.buildFolder()).withRunNpmInstall(adapter.runNpmInstall()).withWebpack(adapter.webpackOutputDirectory(), adapter.servletResourceOutputDirectory()).enablePackagesUpdate(true).useByteCodeScanner(adapter.optimizeBundle()).withJarFrontendResourcesFolder(BuildFrontendUtil.getJarFrontendResourcesFolder(adapter)).copyResources(jarFiles).withCopyTemplates(true).copyLocalResources(adapter.frontendResourcesDirectory()).enableImportsUpdate(true).withEmbeddableWebComponents(adapter.generateEmbeddableWebComponents()).withTokenFile(BuildFrontendUtil.getTokenFile(adapter)).withEnablePnpm(adapter.pnpmEnable()).useGlobalPnpm(adapter.useGlobalPnpm()).withFrontendGeneratedFolder(adapter.generatedTsFolder()).withHomeNodeExecRequired(adapter.requireHomeNodeExec()).withNodeVersion(adapter.nodeVersion()).withNodeDownloadRoot(nodeDownloadRootURI).setNodeAutoUpdate(adapter.nodeAutoUpdate()).setJavaResourceFolder(adapter.javaResourceFolder()).withPostinstallPackages(adapter.postinstallPackages()).withCiBuild(adapter.ciBuild()).withForceProductionBuild(adapter.forceProductionBuild());
            new NodeTasks(options).execute();
        }
        catch (ExecutionFailedException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new ExecutionFailedException("Error occured during goal execution: " + throwable.getMessage() + "Please run Maven with the -e switch (or Gradle with the --stacktrace switch), to learn the full stack trace.", throwable);
        }
    }

    public static void runDevBuildNodeUpdater(PluginAdapterBuild adapter) throws ExecutionFailedException, URISyntaxException, IOException {
        Set<File> jarFiles = adapter.getJarFiles();
        URI nodeDownloadRootURI = adapter.nodeDownloadRoot();
        ClassFinder classFinder = adapter.getClassFinder();
        Lookup lookup = adapter.createLookup(classFinder);
        try {
            Options options = new Options(lookup, adapter.npmFolder()).withProductionMode(false).withFrontendDirectory(adapter.frontendDirectory()).withBuildDirectory(adapter.buildFolder()).withRunNpmInstall(adapter.runNpmInstall()).withWebpack(adapter.webpackOutputDirectory(), adapter.servletResourceOutputDirectory()).enablePackagesUpdate(true).useByteCodeScanner(false).withJarFrontendResourcesFolder(BuildFrontendUtil.getJarFrontendResourcesFolder(adapter)).copyResources(jarFiles).withCopyTemplates(true).copyLocalResources(adapter.frontendResourcesDirectory()).enableImportsUpdate(true).withEmbeddableWebComponents(adapter.generateEmbeddableWebComponents()).withTokenFile(BuildFrontendUtil.getTokenFile(adapter)).withEnablePnpm(adapter.pnpmEnable()).useGlobalPnpm(adapter.useGlobalPnpm()).withFrontendGeneratedFolder(adapter.generatedTsFolder()).withHomeNodeExecRequired(adapter.requireHomeNodeExec()).withNodeVersion(adapter.nodeVersion()).withNodeDownloadRoot(nodeDownloadRootURI).setNodeAutoUpdate(adapter.nodeAutoUpdate()).setJavaResourceFolder(adapter.javaResourceFolder()).withPostinstallPackages(adapter.postinstallPackages()).withBundleBuild(true).skipDevBundleBuild(adapter.skipDevBundleBuild());
            new NodeTasks(options).execute();
        }
        catch (ExecutionFailedException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new ExecutionFailedException("Error occured during goal execution: " + throwable.getMessage() + "Please run Maven with the -e switch (or Gradle with the --stacktrace switch), to learn the full stack trace.", throwable);
        }
    }

    public static void runFrontendBuild(PluginAdapterBase adapter) throws TimeoutException, URISyntaxException {
        LicenseChecker.setStrictOffline((boolean)true);
        FrontendToolsSettings settings = BuildFrontendUtil.getFrontendToolsSettings(adapter);
        FrontendTools tools = new FrontendTools(settings);
        tools.validateNodeAndNpmVersion();
        BuildFrontendUtil.runVite(adapter, tools);
    }

    public static void runVite(PluginAdapterBase adapter, FrontendTools frontendTools) throws TimeoutException {
        BuildFrontendUtil.runFrontendBuildTool(adapter, frontendTools, "Vite", "vite/bin/vite.js", Collections.emptyMap(), "build");
    }

    private static void runFrontendBuildTool(PluginAdapterBase adapter, FrontendTools frontendTools, String toolName, String executable, Map<String, String> environment, String ... params) throws TimeoutException {
        File buildExecutable = new File(adapter.npmFolder(), "node_modules/" + executable);
        if (!buildExecutable.isFile()) {
            throw new IllegalStateException(String.format("Unable to locate %s executable by path '%s'. Double check that the plugin is executed correctly", toolName, buildExecutable.getAbsolutePath()));
        }
        String nodePath = adapter.requireHomeNodeExec() ? frontendTools.forceAlternativeNodeExecutable() : frontendTools.getNodeExecutable();
        ArrayList<String> command = new ArrayList<String>();
        command.add(nodePath);
        command.add(buildExecutable.getAbsolutePath());
        command.addAll(Arrays.asList(params));
        ProcessBuilder builder = FrontendUtils.createProcessBuilder(command);
        ProcessExecutor processExecutor = new ProcessExecutor().command(builder.command()).environment(builder.environment()).environment(environment).directory(adapter.projectBaseDirectory().toFile());
        adapter.logInfo("Running " + toolName + " ...");
        if (adapter.isDebugEnabled()) {
            adapter.logDebug(FrontendUtils.commandToString((String)adapter.npmFolder().getAbsolutePath(), command));
        }
        try {
            processExecutor.exitValueNormal().readOutput(true).destroyOnExit().execute();
        }
        catch (InvalidExitValueException e) {
            throw new IllegalStateException(String.format("%s process exited with non-zero exit code.%nStderr: '%s'", toolName, e.getResult().outputUTF8()), e);
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException(String.format("Failed to run %s due to an error", toolName), e);
        }
    }

    public static void validateLicenses(PluginAdapterBase adapter) {
        File outputFolder = adapter.webpackOutputDirectory();
        String statsJsonContent = null;
        try {
            File statsFile = new File(adapter.servletResourceOutputDirectory(), "config//stats.json");
            statsJsonContent = !statsFile.exists() ? BundleValidationUtil.findProdBundleStatsJson((ClassFinder)adapter.getClassFinder()) : IOUtils.toString((URL)statsFile.toURI().toURL(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (statsJsonContent == null) {
            BuildFrontendUtil.getLogger().debug("No production bundle stats.json available for licenses validation.");
            statsJsonContent = "{}";
        }
        FrontendDependenciesScanner scanner = new FrontendDependenciesScanner.FrontendDependenciesScannerFactory().createScanner(false, adapter.getClassFinder(), true, null);
        List<Product> commercialComponents = BuildFrontendUtil.findCommercialFrontendComponents(scanner, statsJsonContent);
        commercialComponents.addAll(BuildFrontendUtil.findCommercialJavaComponents(adapter));
        for (Product component : commercialComponents) {
            try {
                LicenseChecker.checkLicense((String)component.getName(), (String)component.getVersion(), (BuildType)BuildType.PRODUCTION);
            }
            catch (Exception e) {
                try {
                    BuildFrontendUtil.getLogger().debug("License check for {} failed. Invalidating output", (Object)component);
                    FileUtils.deleteDirectory((File)outputFolder);
                }
                catch (IOException e1) {
                    BuildFrontendUtil.getLogger().debug("Failed to remove {}", (Object)outputFolder);
                }
                throw e;
            }
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(BuildFrontendUtil.class);
    }

    static List<Product> findCommercialFrontendComponents(FrontendDependenciesScanner scanner, String statsJsonContent) {
        ArrayList<Product> components = new ArrayList<Product>();
        JsonObject statsJson = Json.parse((String)statsJsonContent);
        Set<String> usedPackages = BuildFrontendUtil.getUsedPackages(scanner);
        if (statsJson.hasKey("cvdlModules")) {
            JsonObject cvdlModules = statsJson.getObject("cvdlModules");
            for (String key : cvdlModules.keys()) {
                if (!usedPackages.contains(key)) continue;
                JsonObject cvdlModule = cvdlModules.getObject(key);
                components.add(new Product(cvdlModule.getString("name"), cvdlModule.getString("version")));
            }
        }
        return components;
    }

    private static Set<String> getUsedPackages(FrontendDependenciesScanner scanner) {
        HashSet<String> usedPackages = new HashSet<String>();
        Set npmPackages = scanner.getPackages().keySet();
        HashSet jsAndCssImports = new HashSet();
        for (List modules : scanner.getModules().values()) {
            jsAndCssImports.addAll(modules);
        }
        for (List scripts : scanner.getScripts().values()) {
            jsAndCssImports.addAll(scripts);
        }
        for (String importPath : jsAndCssImports) {
            if (importPath.startsWith(".") || !importPath.contains("/")) continue;
            String[] parts = importPath.split("/");
            String potentialBasicPackage = parts[0];
            String potentialOrgPackage = parts[0] + "/" + parts[1];
            if (npmPackages.contains(potentialOrgPackage)) {
                usedPackages.add(potentialOrgPackage);
                continue;
            }
            if (npmPackages.contains(potentialBasicPackage)) {
                usedPackages.add(potentialBasicPackage);
                continue;
            }
            BuildFrontendUtil.getLogger().debug("Import from an unknown package: " + importPath);
        }
        return usedPackages;
    }

    static List<Product> findCommercialJavaComponents(PluginAdapterBase adapter) {
        ArrayList<Product> components = new ArrayList<Product>();
        for (File f : adapter.getJarFiles()) {
            try (JarFile jarFile = new JarFile(f);){
                String cvdlName;
                Attributes attributes;
                Manifest manifest = jarFile.getManifest();
                if (manifest == null || (attributes = manifest.getMainAttributes()) == null || (cvdlName = attributes.getValue("CvdlName")) == null) continue;
                String version = attributes.getValue("Implementation-Version");
                if (version == null) {
                    version = attributes.getValue("Bundle-Version");
                }
                Product p = new Product(cvdlName, version);
                components.add(p);
            }
            catch (IOException e) {
                BuildFrontendUtil.getLogger().debug("Error reading manifest for jar " + f, (Throwable)e);
            }
        }
        return components;
    }

    public static void updateBuildFile(PluginAdapterBuild adapter) {
        File tokenFile = BuildFrontendUtil.getTokenFile(adapter);
        if (!tokenFile.exists()) {
            adapter.logWarn("Couldn't update devMode token due to missing token file.");
            return;
        }
        try {
            String json = FileUtils.readFileToString((File)tokenFile, (String)StandardCharsets.UTF_8.name());
            JsonObject buildInfo = (JsonObject)JsonUtil.parse((String)json);
            buildInfo.remove("npmFolder");
            buildInfo.remove("node.version");
            buildInfo.remove("node.download.root");
            buildInfo.remove("frontendFolder");
            buildInfo.remove("frontend.hotdeploy");
            buildInfo.remove("pnpm.enable");
            buildInfo.remove("vaadin.ci.build");
            buildInfo.remove("require.home.node");
            buildInfo.remove("devmode.optimizeBundle");
            buildInfo.remove("connect.javaSourceFolder");
            buildInfo.remove("javaResourceFolder");
            buildInfo.remove("connect.applicationProperties");
            buildInfo.remove("connect.openApiFile");
            buildInfo.remove("project.frontend.generated");
            buildInfo.remove("build.folder");
            buildInfo.put("productionMode", true);
            FileUtils.write((File)tokenFile, (CharSequence)(JsonUtil.stringify((JsonValue)buildInfo, (int)2) + "\n"), (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            adapter.logWarn("Unable to read token file", e);
        }
    }

    public static void removeBuildFile(PluginAdapterBuild adapter) throws IOException {
        File tokenFile = BuildFrontendUtil.getTokenFile(adapter);
        if (tokenFile.exists()) {
            FileUtils.delete((File)tokenFile);
        }
    }
}

