/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.utils;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.utils.ResourceProviderImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class LookupImpl
implements Lookup {
    private ClassFinder classFinder;

    public LookupImpl(ClassFinder classFinder) {
        this.classFinder = classFinder;
    }

    public <T> T lookup(Class<T> serviceClass) {
        if (ResourceProvider.class.isAssignableFrom(serviceClass)) {
            return serviceClass.cast(new ResourceProviderImpl());
        }
        return this.lookupAll((Class)serviceClass).stream().findFirst().orElse(null);
    }

    public <T> List<T> lookupAll(Class<T> serviceClass) {
        Set subTypes = this.classFinder.getSubTypesOf(serviceClass);
        ArrayList<Object> result = new ArrayList<Object>(subTypes.size());
        for (Class clazz : subTypes) {
            if (!ReflectTools.isInstantiableService((Class)clazz)) continue;
            result.add(ReflectTools.createInstance((Class)clazz));
        }
        return result;
    }
}

