/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.base;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.plugin.base.PluginAdapterBase;
import com.vaadin.flow.plugin.base.PluginAdapterBuild;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.NodeTasks;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.scanner.ReflectionsClassFinder;
import com.vaadin.flow.utils.FlowFileUtils;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.zeroturnaround.exec.InvalidExitValueException;
import org.zeroturnaround.exec.ProcessExecutor;

public class BuildFrontendUtil {
    private BuildFrontendUtil() {
    }

    public static ClassFinder getClassFinder(List<String> classpathElements) {
        URL[] urls = (URL[])classpathElements.stream().distinct().map(File::new).map(FlowFileUtils::convertToUrl).toArray(URL[]::new);
        return new ReflectionsClassFinder(urls);
    }

    public static File getTokenFile(PluginAdapterBase adapter) {
        return new File(adapter.servletResourceOutputDirectory(), "config/flow-build-info.json");
    }

    public static void prepareFrontend(PluginAdapterBase adapter) throws IOException, ExecutionFailedException, URISyntaxException {
        URI nodeDownloadRootURI = adapter.nodeDownloadRoot();
        FrontendTools tools = new FrontendTools(adapter.npmFolder().getAbsolutePath(), () -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath(), adapter.nodeVersion(), nodeDownloadRootURI);
        tools.validateNodeAndNpmVersion();
        try {
            FileUtils.forceMkdir((File)adapter.generatedFolder());
        }
        catch (IOException e) {
            throw new IOException("Failed to create folder '" + adapter.generatedFolder() + "'. Verify that you may write to path.", e);
        }
        File flowResourcesFolder = new File(adapter.npmFolder(), Paths.get(adapter.buildFolder(), "flow-frontend").toString());
        ClassFinder classFinder = adapter.getClassFinder();
        Lookup lookup = adapter.createLookup(classFinder);
        NodeTasks.Builder builder = new NodeTasks.Builder(lookup, adapter.npmFolder(), adapter.generatedFolder(), adapter.frontendDirectory(), adapter.buildFolder()).useV14Bootstrap(adapter.isUseDeprecatedV14Bootstrapping()).withFlowResourcesFolder(flowResourcesFolder).createMissingPackageJson(true).enableImportsUpdate(false).enablePackagesUpdate(false).runNpmInstall(false).withNodeVersion(adapter.nodeVersion()).withNodeDownloadRoot(nodeDownloadRootURI).withHomeNodeExecRequired(adapter.requireHomeNodeExec());
        if (adapter.isJarProject()) {
            builder.copyResources(adapter.getJarFiles());
        }
        try {
            builder.build().execute();
        }
        catch (ExecutionFailedException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new ExecutionFailedException("Error occured during goal execution: " + throwable.getMessage() + "Please run Maven with the -e switch (or Gradle with the --stacktrace switch), to learn the full stack trace.", throwable);
        }
    }

    public static File propagateBuildInfo(PluginAdapterBase adapter) {
        File token = new File(adapter.servletResourceOutputDirectory(), "config/flow-build-info.json");
        JsonObject buildInfo = Json.createObject();
        buildInfo.put("productionMode", adapter.productionMode());
        buildInfo.put("useDeprecatedV14Bootstrapping", adapter.isUseDeprecatedV14Bootstrapping());
        buildInfo.put("eagerServerLoad", adapter.eagerServerLoad());
        buildInfo.put("npmFolder", adapter.npmFolder().getAbsolutePath());
        buildInfo.put("generatedFolder", adapter.generatedFolder().getAbsolutePath());
        buildInfo.put("frontendFolder", adapter.frontendDirectory().getAbsolutePath());
        buildInfo.put("connect.javaSourceFolder", adapter.javaSourceFolder().getAbsolutePath());
        buildInfo.put("connect.applicationProperties", adapter.applicationProperties().getAbsolutePath());
        buildInfo.put("connect.openApiFile", adapter.openApiJsonFile().getAbsolutePath());
        buildInfo.put("project.frontend.generated", adapter.generatedTsFolder().getAbsolutePath());
        buildInfo.put("pnpm.enable", adapter.pnpmEnable());
        buildInfo.put("require.home.node", adapter.requireHomeNodeExec());
        buildInfo.put("build.folder", adapter.buildFolder());
        try {
            FileUtils.forceMkdir((File)token.getParentFile());
            FileUtils.write((File)token, (CharSequence)(JsonUtil.stringify((JsonValue)buildInfo, (int)2) + "\n"), (String)StandardCharsets.UTF_8.name());
            if (adapter.isDebugEnabled()) {
                adapter.logDebug(String.format("%n>>> Running prepare-frontend%nSystem.properties:%n productionMode: %s%n webpackPort: %s%n project.basedir: %s%nGoal parameters:%n productionMode: %s%n npmFolder: %s%nToken file: %s%nToken content: %s%n", adapter.productionMode(), System.getProperty("vaadin.devmode.webpack.running-port"), adapter.projectBaseDirectory(), adapter.productionMode(), adapter.npmFolder(), token.getAbsolutePath(), buildInfo.toJson()));
            }
            return token;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void runNodeUpdater(PluginAdapterBuild adapter) throws ExecutionFailedException, URISyntaxException {
        Set<File> jarFiles = adapter.getJarFiles();
        File flowResourcesFolder = new File(adapter.npmFolder(), Paths.get(adapter.buildFolder(), "flow-frontend").toString());
        URI nodeDownloadRootURI = adapter.nodeDownloadRoot();
        ClassFinder classFinder = adapter.getClassFinder();
        Lookup lookup = adapter.createLookup(classFinder);
        try {
            new NodeTasks.Builder(lookup, adapter.npmFolder(), adapter.generatedFolder(), adapter.frontendDirectory(), adapter.buildFolder()).runNpmInstall(adapter.runNpmInstall()).withWebpack(adapter.webpackOutputDirectory(), adapter.servletResourceOutputDirectory(), adapter.webpackTemplate(), adapter.webpackGeneratedTemplate()).useV14Bootstrap(adapter.isUseDeprecatedV14Bootstrapping()).enablePackagesUpdate(true).useByteCodeScanner(adapter.optimizeBundle()).withFlowResourcesFolder(flowResourcesFolder).copyResources(jarFiles).copyLocalResources(adapter.frontendResourcesDirectory()).enableImportsUpdate(true).withEmbeddableWebComponents(adapter.generateEmbeddableWebComponents()).withTokenFile(BuildFrontendUtil.getTokenFile(adapter)).enablePnpm(adapter.pnpmEnable()).withFusionApplicationProperties(adapter.applicationProperties()).withFusionJavaSourceFolder(adapter.javaSourceFolder()).withFusionGeneratedOpenAPIJson(adapter.openApiJsonFile()).withFusionClientAPIFolder(adapter.generatedTsFolder()).withHomeNodeExecRequired(adapter.requireHomeNodeExec()).withNodeVersion(adapter.nodeVersion()).withNodeDownloadRoot(nodeDownloadRootURI).build().execute();
        }
        catch (ExecutionFailedException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new ExecutionFailedException("Error occured during goal execution: " + throwable.getMessage() + "Please run Maven with the -e switch (or Gradle with the --stacktrace switch), to learn the full stack trace.", throwable);
        }
    }

    public static void runWebpack(PluginAdapterBase adapter) throws IOException, InterruptedException, TimeoutException, URISyntaxException {
        String webpackCommand = "webpack/bin/webpack.js";
        File webpackExecutable = new File(adapter.npmFolder(), "node_modules/" + webpackCommand);
        if (!webpackExecutable.isFile()) {
            throw new IllegalStateException(String.format("Unable to locate webpack executable by path '%s'. Double check that the plugin is executed correctly", webpackExecutable.getAbsolutePath()));
        }
        URI nodeDownloadRootURI = adapter.nodeDownloadRoot();
        FrontendTools tools = new FrontendTools(adapter.npmFolder().getAbsolutePath(), () -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath(), adapter.nodeVersion(), nodeDownloadRootURI);
        String nodePath = adapter.requireHomeNodeExec() ? tools.forceAlternativeNodeExecutable() : tools.getNodeExecutable();
        List<String> command = Arrays.asList(nodePath, webpackExecutable.getAbsolutePath());
        ProcessBuilder builder = FrontendUtils.createProcessBuilder(command);
        ProcessExecutor processExecutor = new ProcessExecutor().command(builder.command()).environment(builder.environment()).directory(adapter.projectBaseDirectory().toFile());
        adapter.logInfo("Running webpack ...");
        if (adapter.isDebugEnabled()) {
            adapter.logDebug(FrontendUtils.commandToString((String)adapter.npmFolder().getAbsolutePath(), command));
        }
        try {
            processExecutor.exitValueNormal().readOutput(true).destroyOnExit().execute();
        }
        catch (InvalidExitValueException e) {
            throw new IllegalStateException(String.format("Webpack process exited with non-zero exit code.%nStderr: '%s'", e.getResult().outputUTF8()), e);
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException("Failed to run webpack due to an error", e);
        }
    }

    public static void updateBuildFile(PluginAdapterBuild adapter) {
        File tokenFile = BuildFrontendUtil.getTokenFile(adapter);
        if (!tokenFile.exists()) {
            adapter.logWarn("Couldn't update devMode token due to missing token file.");
            return;
        }
        try {
            String json = FileUtils.readFileToString((File)tokenFile, (String)StandardCharsets.UTF_8.name());
            JsonObject buildInfo = (JsonObject)JsonUtil.parse((String)json);
            buildInfo.remove("npmFolder");
            buildInfo.remove("generatedFolder");
            buildInfo.remove("frontendFolder");
            buildInfo.remove("pnpm.enable");
            buildInfo.remove("require.home.node");
            buildInfo.remove("devmode.optimizeBundle");
            buildInfo.remove("connect.javaSourceFolder");
            buildInfo.remove("connect.applicationProperties");
            buildInfo.remove("connect.javaSourceFolder");
            buildInfo.remove("connect.openApiFile");
            buildInfo.remove("project.frontend.generated");
            buildInfo.remove("build.folder");
            buildInfo.put("enableDevServer", false);
            FileUtils.write((File)tokenFile, (CharSequence)(JsonUtil.stringify((JsonValue)buildInfo, (int)2) + "\n"), (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            adapter.logWarn("Unable to read token file", e);
        }
    }
}

