/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.templatemodel;

import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.ReflectionCache;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.templatemodel.BeanModelType;
import com.vaadin.flow.templatemodel.InvalidTemplateModelException;
import com.vaadin.flow.templatemodel.ModelType;
import com.vaadin.flow.templatemodel.PropertyFilter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;

@Deprecated
public class TemplateModelProxyHandler
implements Serializable {
    private static final ReflectionCache<Object, BiFunction<StateNode, BeanModelType<?>, Object>> proxyConstructors = new ReflectionCache(TemplateModelProxyHandler::createProxyConstructor);
    private static final TemplateModelProxyHandler proxyHandler = new TemplateModelProxyHandler();

    private TemplateModelProxyHandler() {
    }

    @RuntimeType
    public Object intercept(@This Object target, @Origin Method method, @AllArguments Object[] args) {
        String propertyName = ReflectTools.getPropertyName((Method)method);
        BeanModelType<?> modelType = TemplateModelProxyHandler.getModelTypeForProxy(target);
        if (!modelType.hasProperty(propertyName)) {
            throw new InvalidTemplateModelException(modelType.getProxyType().getName() + " has no property named " + propertyName + " (or it has been excluded)");
        }
        ModelType propertyType = modelType.getPropertyType(propertyName);
        ElementPropertyMap modelMap = ElementPropertyMap.getModel((StateNode)TemplateModelProxyHandler.getStateNodeForProxy(target));
        if (ReflectTools.isGetter((Method)method)) {
            return TemplateModelProxyHandler.handleGetter(modelMap, propertyName, propertyType);
        }
        if (ReflectTools.isSetter((Method)method)) {
            Object value = args[0];
            TemplateModelProxyHandler.handleSetter(modelMap, propertyName, propertyType, value);
            return null;
        }
        throw new InvalidTemplateModelException(TemplateModelProxyHandler.getUnsupportedMethodMessage(method, args));
    }

    public static <T> T createModelProxy(StateNode stateNode, BeanModelType<T> modelType) {
        assert (stateNode != null);
        assert (modelType != null);
        Class<T> proxyType = modelType.getProxyType();
        Object proxy = ((BiFunction)proxyConstructors.get(proxyType)).apply(stateNode, modelType);
        return proxyType.cast(proxy);
    }

    private static BiFunction<StateNode, BeanModelType<?>, Object> createProxyConstructor(Class<?> type) {
        if (type.isInterface()) {
            return TemplateModelProxyHandler.createInterfaceConstructor(type);
        }
        return TemplateModelProxyHandler.createClassConstructor(type);
    }

    private static BiFunction<StateNode, BeanModelType<?>, Object> createInterfaceConstructor(Class<?> modelType) {
        DynamicType.Builder.MethodDefinition.ImplementationDefinition.Optional builder = new ByteBuddy().subclass(InterfaceProxy.class).implement(new Type[]{modelType});
        return TemplateModelProxyHandler.createProxyConstructor(modelType.getClassLoader(), builder, modelType.getCanonicalName());
    }

    private static BiFunction<StateNode, BeanModelType<?>, Object> createClassConstructor(Class<?> modelType) {
        DynamicType.Builder.MethodDefinition.ImplementationDefinition.Optional builder = new ByteBuddy().subclass(modelType).implement(new Type[]{ModelProxy.class});
        return TemplateModelProxyHandler.createProxyConstructor(modelType.getClassLoader(), builder, modelType.getCanonicalName());
    }

    private static BiFunction<StateNode, BeanModelType<?>, Object> createProxyConstructor(ClassLoader classLoader, DynamicType.Builder<?> proxyBuilder, String classFqn) {
        String proxyClassName = TemplateModelProxyHandler.generateProxyClassName(classFqn, classLoader);
        Class proxyType = proxyBuilder.method(method -> TemplateModelProxyHandler.isAccessor(method) || method.isAbstract()).intercept((Implementation)MethodDelegation.to((Object)proxyHandler)).defineField("$stateNode", StateNode.class, new ModifierContributor.ForField[0]).method(method -> "$stateNode".equals(method.getName())).intercept((Implementation)FieldAccessor.ofField((String)"$stateNode")).defineField("$modelType", BeanModelType.class, new ModifierContributor.ForField[0]).method(method -> "$modelType".equals(method.getName())).intercept((Implementation)FieldAccessor.ofField((String)"$modelType")).name(proxyClassName).make().load(classLoader, (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded();
        return (node, modelType) -> {
            Object instance = ReflectTools.createProxyInstance((Class)proxyType, modelType.getProxyType());
            ModelProxy modelProxy = (ModelProxy)instance;
            modelProxy.$stateNode((StateNode)node);
            modelProxy.$modelType((BeanModelType<?>)modelType);
            modelType.createInitialValues((StateNode)node);
            return instance;
        };
    }

    private static String generateProxyClassName(String classFqn, ClassLoader classLoader) {
        StringBuilder fqnBuilder = new StringBuilder(classFqn);
        boolean classExists = true;
        do {
            fqnBuilder.append('$');
            try {
                Class.forName(fqnBuilder.toString(), false, classLoader);
            }
            catch (ClassNotFoundException exception) {
                classExists = false;
            }
        } while (classExists);
        return fqnBuilder.toString();
    }

    private static boolean isAccessor(MethodDescription method) {
        if (method.getDeclaringType().represents(Object.class)) {
            return false;
        }
        String methodName = method.getName();
        TypeDescription.Generic returnType = method.getReturnType();
        ParameterList args = method.getParameters();
        boolean isSetter = TypeDescription.Generic.VOID.equals(returnType) && args.size() == 1 && ReflectTools.isSetterName((String)methodName);
        boolean isGetter = !TypeDescription.Generic.VOID.equals(returnType) && args.isEmpty() && ReflectTools.isGetterName((String)methodName, (boolean)returnType.represents(Boolean.TYPE));
        return isSetter || isGetter;
    }

    private static String getUnsupportedMethodMessage(Method unsupportedMethod, Object[] args) {
        return "Template Model does not support: " + unsupportedMethod.getName() + " with return type: " + unsupportedMethod.getReturnType().getName() + (args == null ? " and no parameters" : " with parameters: " + Stream.of(args).map(Object::getClass).map(Class::getName).collect(Collectors.joining(", ")));
    }

    private static Object handleGetter(ElementPropertyMap modelMap, String propertyName, ModelType propertyType) {
        Serializable modelValue = modelMap.getProperty(propertyName);
        try {
            return propertyType.modelToApplication(modelValue);
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalArgumentException(String.format("Model property '%s' has an unexpected stored value: %s", propertyName, exception.getMessage()), exception);
        }
    }

    private static void handleSetter(ElementPropertyMap modelMap, String propertyName, ModelType propertyType, Object value) {
        Serializable modelValue = propertyType.applicationToModel(value, PropertyFilter.ACCEPT_ALL);
        modelMap.setProperty(propertyName, modelValue);
    }

    public static StateNode getStateNodeForProxy(Object proxy) {
        return TemplateModelProxyHandler.assertIsProxy(proxy).$stateNode();
    }

    public static BeanModelType<?> getModelTypeForProxy(Object proxy) {
        return TemplateModelProxyHandler.assertIsProxy(proxy).$modelType();
    }

    private static ModelProxy assertIsProxy(Object maybeProxy) {
        if (!TemplateModelProxyHandler.isProxy(maybeProxy)) {
            throw new IllegalArgumentException(maybeProxy + " is not a template model proxy");
        }
        return (ModelProxy)maybeProxy;
    }

    public static boolean isProxy(Object proxy) {
        return proxy instanceof ModelProxy;
    }

    public static abstract class InterfaceProxy
    implements ModelProxy {
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof InterfaceProxy) {
                InterfaceProxy that = (InterfaceProxy)obj;
                return this.$stateNode().equals(that.$stateNode()) && this.$modelType().equals(that.$modelType());
            }
            return false;
        }

        public String toString() {
            return "Template Model for a state node with id " + this.$stateNode().getId();
        }

        public int hashCode() {
            return Objects.hash(this.$stateNode(), this.$modelType());
        }
    }

    protected static interface ModelProxy
    extends Serializable {
        public StateNode $stateNode();

        public void $stateNode(StateNode var1);

        public BeanModelType<?> $modelType();

        public void $modelType(BeanModelType<?> var1);
    }
}

