#!/usr/bin/env node
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));

// node_modules/acorn/dist/acorn.js
var require_acorn = __commonJS({
  "node_modules/acorn/dist/acorn.js"(exports, module2) {
    (function(global2, factory) {
      typeof exports === "object" && typeof module2 !== "undefined" ? factory(exports) : typeof define === "function" && define.amd ? define(["exports"], factory) : (global2 = global2 || self, factory(global2.acorn = {}));
    })(exports, function(exports2) {
      "use strict";
      var reservedWords = {
        3: "abstract boolean byte char class double enum export extends final float goto implements import int interface long native package private protected public short static super synchronized throws transient volatile",
        5: "class enum extends super const export import",
        6: "enum",
        strict: "implements interface let package private protected public static yield",
        strictBind: "eval arguments"
      };
      var ecma5AndLessKeywords = "break case catch continue debugger default do else finally for function if return switch throw try var while with null true false instanceof typeof void delete new in this";
      var keywords = {
        5: ecma5AndLessKeywords,
        "5module": ecma5AndLessKeywords + " export import",
        6: ecma5AndLessKeywords + " const class extends export import super"
      };
      var keywordRelationalOperator = /^in(stanceof)?$/;
      var nonASCIIidentifierStartChars = "\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0560-\u0588\u05D0-\u05EA\u05EF-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u0860-\u086A\u08A0-\u08B4\u08B6-\u08C7\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u09FC\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C60\u0C61\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D04-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E86-\u0E8A\u0E8C-\u0EA3\u0EA5\u0EA7-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1878\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1C80-\u1C88\u1C90-\u1CBA\u1CBD-\u1CBF\u1CE9-\u1CEC\u1CEE-\u1CF3\u1CF5\u1CF6\u1CFA\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2118-\u211D\u2124\u2126\u2128\u212A-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309B-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312F\u3131-\u318E\u31A0-\u31BF\u31F0-\u31FF\u3400-\u4DBF\u4E00-\u9FFC\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA7BF\uA7C2-\uA7CA\uA7F5-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA8FE\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB69\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC";
      var nonASCIIidentifierChars = "\u200C\u200D\xB7\u0300-\u036F\u0387\u0483-\u0487\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u0669\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u06F0-\u06F9\u0711\u0730-\u074A\u07A6-\u07B0\u07C0-\u07C9\u07EB-\u07F3\u07FD\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u08D3-\u08E1\u08E3-\u0903\u093A-\u093C\u093E-\u094F\u0951-\u0957\u0962\u0963\u0966-\u096F\u0981-\u0983\u09BC\u09BE-\u09C4\u09C7\u09C8\u09CB-\u09CD\u09D7\u09E2\u09E3\u09E6-\u09EF\u09FE\u0A01-\u0A03\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A66-\u0A71\u0A75\u0A81-\u0A83\u0ABC\u0ABE-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AE2\u0AE3\u0AE6-\u0AEF\u0AFA-\u0AFF\u0B01-\u0B03\u0B3C\u0B3E-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B55-\u0B57\u0B62\u0B63\u0B66-\u0B6F\u0B82\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD7\u0BE6-\u0BEF\u0C00-\u0C04\u0C3E-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C66-\u0C6F\u0C81-\u0C83\u0CBC\u0CBE-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CE2\u0CE3\u0CE6-\u0CEF\u0D00-\u0D03\u0D3B\u0D3C\u0D3E-\u0D44\u0D46-\u0D48\u0D4A-\u0D4D\u0D57\u0D62\u0D63\u0D66-\u0D6F\u0D81-\u0D83\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2\u0DF3\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0E50-\u0E59\u0EB1\u0EB4-\u0EBC\u0EC8-\u0ECD\u0ED0-\u0ED9\u0F18\u0F19\u0F20-\u0F29\u0F35\u0F37\u0F39\u0F3E\u0F3F\u0F71-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102B-\u103E\u1040-\u1049\u1056-\u1059\u105E-\u1060\u1062-\u1064\u1067-\u106D\u1071-\u1074\u1082-\u108D\u108F-\u109D\u135D-\u135F\u1369-\u1371\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4-\u17D3\u17DD\u17E0-\u17E9\u180B-\u180D\u1810-\u1819\u18A9\u1920-\u192B\u1930-\u193B\u1946-\u194F\u19D0-\u19DA\u1A17-\u1A1B\u1A55-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AB0-\u1ABD\u1ABF\u1AC0\u1B00-\u1B04\u1B34-\u1B44\u1B50-\u1B59\u1B6B-\u1B73\u1B80-\u1B82\u1BA1-\u1BAD\u1BB0-\u1BB9\u1BE6-\u1BF3\u1C24-\u1C37\u1C40-\u1C49\u1C50-\u1C59\u1CD0-\u1CD2\u1CD4-\u1CE8\u1CED\u1CF4\u1CF7-\u1CF9\u1DC0-\u1DF9\u1DFB-\u1DFF\u203F\u2040\u2054\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\uA620-\uA629\uA66F\uA674-\uA67D\uA69E\uA69F\uA6F0\uA6F1\uA802\uA806\uA80B\uA823-\uA827\uA82C\uA880\uA881\uA8B4-\uA8C5\uA8D0-\uA8D9\uA8E0-\uA8F1\uA8FF-\uA909\uA926-\uA92D\uA947-\uA953\uA980-\uA983\uA9B3-\uA9C0\uA9D0-\uA9D9\uA9E5\uA9F0-\uA9F9\uAA29-\uAA36\uAA43\uAA4C\uAA4D\uAA50-\uAA59\uAA7B-\uAA7D\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEB-\uAAEF\uAAF5\uAAF6\uABE3-\uABEA\uABEC\uABED\uABF0-\uABF9\uFB1E\uFE00-\uFE0F\uFE20-\uFE2F\uFE33\uFE34\uFE4D-\uFE4F\uFF10-\uFF19\uFF3F";
      var nonASCIIidentifierStart = new RegExp("[" + nonASCIIidentifierStartChars + "]");
      var nonASCIIidentifier = new RegExp("[" + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "]");
      nonASCIIidentifierStartChars = nonASCIIidentifierChars = null;
      var astralIdentifierStartCodes = [0, 11, 2, 25, 2, 18, 2, 1, 2, 14, 3, 13, 35, 122, 70, 52, 268, 28, 4, 48, 48, 31, 14, 29, 6, 37, 11, 29, 3, 35, 5, 7, 2, 4, 43, 157, 19, 35, 5, 35, 5, 39, 9, 51, 157, 310, 10, 21, 11, 7, 153, 5, 3, 0, 2, 43, 2, 1, 4, 0, 3, 22, 11, 22, 10, 30, 66, 18, 2, 1, 11, 21, 11, 25, 71, 55, 7, 1, 65, 0, 16, 3, 2, 2, 2, 28, 43, 28, 4, 28, 36, 7, 2, 27, 28, 53, 11, 21, 11, 18, 14, 17, 111, 72, 56, 50, 14, 50, 14, 35, 349, 41, 7, 1, 79, 28, 11, 0, 9, 21, 107, 20, 28, 22, 13, 52, 76, 44, 33, 24, 27, 35, 30, 0, 3, 0, 9, 34, 4, 0, 13, 47, 15, 3, 22, 0, 2, 0, 36, 17, 2, 24, 85, 6, 2, 0, 2, 3, 2, 14, 2, 9, 8, 46, 39, 7, 3, 1, 3, 21, 2, 6, 2, 1, 2, 4, 4, 0, 19, 0, 13, 4, 159, 52, 19, 3, 21, 2, 31, 47, 21, 1, 2, 0, 185, 46, 42, 3, 37, 47, 21, 0, 60, 42, 14, 0, 72, 26, 230, 43, 117, 63, 32, 7, 3, 0, 3, 7, 2, 1, 2, 23, 16, 0, 2, 0, 95, 7, 3, 38, 17, 0, 2, 0, 29, 0, 11, 39, 8, 0, 22, 0, 12, 45, 20, 0, 35, 56, 264, 8, 2, 36, 18, 0, 50, 29, 113, 6, 2, 1, 2, 37, 22, 0, 26, 5, 2, 1, 2, 31, 15, 0, 328, 18, 190, 0, 80, 921, 103, 110, 18, 195, 2749, 1070, 4050, 582, 8634, 568, 8, 30, 114, 29, 19, 47, 17, 3, 32, 20, 6, 18, 689, 63, 129, 74, 6, 0, 67, 12, 65, 1, 2, 0, 29, 6135, 9, 1237, 43, 8, 8952, 286, 50, 2, 18, 3, 9, 395, 2309, 106, 6, 12, 4, 8, 8, 9, 5991, 84, 2, 70, 2, 1, 3, 0, 3, 1, 3, 3, 2, 11, 2, 0, 2, 6, 2, 64, 2, 3, 3, 7, 2, 6, 2, 27, 2, 3, 2, 4, 2, 0, 4, 6, 2, 339, 3, 24, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 7, 2357, 44, 11, 6, 17, 0, 370, 43, 1301, 196, 60, 67, 8, 0, 1205, 3, 2, 26, 2, 1, 2, 0, 3, 0, 2, 9, 2, 3, 2, 0, 2, 0, 7, 0, 5, 0, 2, 0, 2, 0, 2, 2, 2, 1, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 1, 2, 0, 3, 3, 2, 6, 2, 3, 2, 3, 2, 0, 2, 9, 2, 16, 6, 2, 2, 4, 2, 16, 4421, 42717, 35, 4148, 12, 221, 3, 5761, 15, 7472, 3104, 541, 1507, 4938];
      var astralIdentifierCodes = [509, 0, 227, 0, 150, 4, 294, 9, 1368, 2, 2, 1, 6, 3, 41, 2, 5, 0, 166, 1, 574, 3, 9, 9, 370, 1, 154, 10, 176, 2, 54, 14, 32, 9, 16, 3, 46, 10, 54, 9, 7, 2, 37, 13, 2, 9, 6, 1, 45, 0, 13, 2, 49, 13, 9, 3, 2, 11, 83, 11, 7, 0, 161, 11, 6, 9, 7, 3, 56, 1, 2, 6, 3, 1, 3, 2, 10, 0, 11, 1, 3, 6, 4, 4, 193, 17, 10, 9, 5, 0, 82, 19, 13, 9, 214, 6, 3, 8, 28, 1, 83, 16, 16, 9, 82, 12, 9, 9, 84, 14, 5, 9, 243, 14, 166, 9, 71, 5, 2, 1, 3, 3, 2, 0, 2, 1, 13, 9, 120, 6, 3, 6, 4, 0, 29, 9, 41, 6, 2, 3, 9, 0, 10, 10, 47, 15, 406, 7, 2, 7, 17, 9, 57, 21, 2, 13, 123, 5, 4, 0, 2, 1, 2, 6, 2, 0, 9, 9, 49, 4, 2, 1, 2, 4, 9, 9, 330, 3, 19306, 9, 135, 4, 60, 6, 26, 9, 1014, 0, 2, 54, 8, 3, 82, 0, 12, 1, 19628, 1, 5319, 4, 4, 5, 9, 7, 3, 6, 31, 3, 149, 2, 1418, 49, 513, 54, 5, 49, 9, 0, 15, 0, 23, 4, 2, 14, 1361, 6, 2, 16, 3, 6, 2, 1, 2, 4, 262, 6, 10, 9, 419, 13, 1495, 6, 110, 6, 6, 9, 4759, 9, 787719, 239];
      function isInAstralSet(code, set) {
        var pos = 65536;
        for (var i = 0; i < set.length; i += 2) {
          pos += set[i];
          if (pos > code) {
            return false;
          }
          pos += set[i + 1];
          if (pos >= code) {
            return true;
          }
        }
      }
      function isIdentifierStart(code, astral) {
        if (code < 65) {
          return code === 36;
        }
        if (code < 91) {
          return true;
        }
        if (code < 97) {
          return code === 95;
        }
        if (code < 123) {
          return true;
        }
        if (code <= 65535) {
          return code >= 170 && nonASCIIidentifierStart.test(String.fromCharCode(code));
        }
        if (astral === false) {
          return false;
        }
        return isInAstralSet(code, astralIdentifierStartCodes);
      }
      function isIdentifierChar(code, astral) {
        if (code < 48) {
          return code === 36;
        }
        if (code < 58) {
          return true;
        }
        if (code < 65) {
          return false;
        }
        if (code < 91) {
          return true;
        }
        if (code < 97) {
          return code === 95;
        }
        if (code < 123) {
          return true;
        }
        if (code <= 65535) {
          return code >= 170 && nonASCIIidentifier.test(String.fromCharCode(code));
        }
        if (astral === false) {
          return false;
        }
        return isInAstralSet(code, astralIdentifierStartCodes) || isInAstralSet(code, astralIdentifierCodes);
      }
      var TokenType = function TokenType2(label, conf) {
        if (conf === void 0)
          conf = {};
        this.label = label;
        this.keyword = conf.keyword;
        this.beforeExpr = !!conf.beforeExpr;
        this.startsExpr = !!conf.startsExpr;
        this.isLoop = !!conf.isLoop;
        this.isAssign = !!conf.isAssign;
        this.prefix = !!conf.prefix;
        this.postfix = !!conf.postfix;
        this.binop = conf.binop || null;
        this.updateContext = null;
      };
      function binop(name, prec) {
        return new TokenType(name, { beforeExpr: true, binop: prec });
      }
      var beforeExpr = { beforeExpr: true }, startsExpr = { startsExpr: true };
      var keywords$1 = {};
      function kw(name, options) {
        if (options === void 0)
          options = {};
        options.keyword = name;
        return keywords$1[name] = new TokenType(name, options);
      }
      var types = {
        num: new TokenType("num", startsExpr),
        regexp: new TokenType("regexp", startsExpr),
        string: new TokenType("string", startsExpr),
        name: new TokenType("name", startsExpr),
        eof: new TokenType("eof"),
        bracketL: new TokenType("[", { beforeExpr: true, startsExpr: true }),
        bracketR: new TokenType("]"),
        braceL: new TokenType("{", { beforeExpr: true, startsExpr: true }),
        braceR: new TokenType("}"),
        parenL: new TokenType("(", { beforeExpr: true, startsExpr: true }),
        parenR: new TokenType(")"),
        comma: new TokenType(",", beforeExpr),
        semi: new TokenType(";", beforeExpr),
        colon: new TokenType(":", beforeExpr),
        dot: new TokenType("."),
        question: new TokenType("?", beforeExpr),
        questionDot: new TokenType("?."),
        arrow: new TokenType("=>", beforeExpr),
        template: new TokenType("template"),
        invalidTemplate: new TokenType("invalidTemplate"),
        ellipsis: new TokenType("...", beforeExpr),
        backQuote: new TokenType("`", startsExpr),
        dollarBraceL: new TokenType("${", { beforeExpr: true, startsExpr: true }),
        eq: new TokenType("=", { beforeExpr: true, isAssign: true }),
        assign: new TokenType("_=", { beforeExpr: true, isAssign: true }),
        incDec: new TokenType("++/--", { prefix: true, postfix: true, startsExpr: true }),
        prefix: new TokenType("!/~", { beforeExpr: true, prefix: true, startsExpr: true }),
        logicalOR: binop("||", 1),
        logicalAND: binop("&&", 2),
        bitwiseOR: binop("|", 3),
        bitwiseXOR: binop("^", 4),
        bitwiseAND: binop("&", 5),
        equality: binop("==/!=/===/!==", 6),
        relational: binop("</>/<=/>=", 7),
        bitShift: binop("<</>>/>>>", 8),
        plusMin: new TokenType("+/-", { beforeExpr: true, binop: 9, prefix: true, startsExpr: true }),
        modulo: binop("%", 10),
        star: binop("*", 10),
        slash: binop("/", 10),
        starstar: new TokenType("**", { beforeExpr: true }),
        coalesce: binop("??", 1),
        _break: kw("break"),
        _case: kw("case", beforeExpr),
        _catch: kw("catch"),
        _continue: kw("continue"),
        _debugger: kw("debugger"),
        _default: kw("default", beforeExpr),
        _do: kw("do", { isLoop: true, beforeExpr: true }),
        _else: kw("else", beforeExpr),
        _finally: kw("finally"),
        _for: kw("for", { isLoop: true }),
        _function: kw("function", startsExpr),
        _if: kw("if"),
        _return: kw("return", beforeExpr),
        _switch: kw("switch"),
        _throw: kw("throw", beforeExpr),
        _try: kw("try"),
        _var: kw("var"),
        _const: kw("const"),
        _while: kw("while", { isLoop: true }),
        _with: kw("with"),
        _new: kw("new", { beforeExpr: true, startsExpr: true }),
        _this: kw("this", startsExpr),
        _super: kw("super", startsExpr),
        _class: kw("class", startsExpr),
        _extends: kw("extends", beforeExpr),
        _export: kw("export"),
        _import: kw("import", startsExpr),
        _null: kw("null", startsExpr),
        _true: kw("true", startsExpr),
        _false: kw("false", startsExpr),
        _in: kw("in", { beforeExpr: true, binop: 7 }),
        _instanceof: kw("instanceof", { beforeExpr: true, binop: 7 }),
        _typeof: kw("typeof", { beforeExpr: true, prefix: true, startsExpr: true }),
        _void: kw("void", { beforeExpr: true, prefix: true, startsExpr: true }),
        _delete: kw("delete", { beforeExpr: true, prefix: true, startsExpr: true })
      };
      var lineBreak = /\r\n?|\n|\u2028|\u2029/;
      var lineBreakG = new RegExp(lineBreak.source, "g");
      function isNewLine(code, ecma2019String) {
        return code === 10 || code === 13 || !ecma2019String && (code === 8232 || code === 8233);
      }
      var nonASCIIwhitespace = /[\u1680\u2000-\u200a\u202f\u205f\u3000\ufeff]/;
      var skipWhiteSpace = /(?:\s|\/\/.*|\/\*[^]*?\*\/)*/g;
      var ref = Object.prototype;
      var hasOwnProperty = ref.hasOwnProperty;
      var toString2 = ref.toString;
      function has(obj, propName) {
        return hasOwnProperty.call(obj, propName);
      }
      var isArray = Array.isArray || function(obj) {
        return toString2.call(obj) === "[object Array]";
      };
      function wordsRegexp(words) {
        return new RegExp("^(?:" + words.replace(/ /g, "|") + ")$");
      }
      var Position = function Position2(line, col) {
        this.line = line;
        this.column = col;
      };
      Position.prototype.offset = function offset(n2) {
        return new Position(this.line, this.column + n2);
      };
      var SourceLocation = function SourceLocation2(p, start, end) {
        this.start = start;
        this.end = end;
        if (p.sourceFile !== null) {
          this.source = p.sourceFile;
        }
      };
      function getLineInfo2(input, offset) {
        for (var line = 1, cur = 0; ; ) {
          lineBreakG.lastIndex = cur;
          var match = lineBreakG.exec(input);
          if (match && match.index < offset) {
            ++line;
            cur = match.index + match[0].length;
          } else {
            return new Position(line, offset - cur);
          }
        }
      }
      var defaultOptions = {
        ecmaVersion: 10,
        sourceType: "script",
        onInsertedSemicolon: null,
        onTrailingComma: null,
        allowReserved: null,
        allowReturnOutsideFunction: false,
        allowImportExportEverywhere: false,
        allowAwaitOutsideFunction: false,
        allowHashBang: false,
        locations: false,
        onToken: null,
        onComment: null,
        ranges: false,
        program: null,
        sourceFile: null,
        directSourceFile: null,
        preserveParens: false
      };
      function getOptions(opts) {
        var options = {};
        for (var opt in defaultOptions) {
          options[opt] = opts && has(opts, opt) ? opts[opt] : defaultOptions[opt];
        }
        if (options.ecmaVersion >= 2015) {
          options.ecmaVersion -= 2009;
        }
        if (options.allowReserved == null) {
          options.allowReserved = options.ecmaVersion < 5;
        }
        if (isArray(options.onToken)) {
          var tokens = options.onToken;
          options.onToken = function(token) {
            return tokens.push(token);
          };
        }
        if (isArray(options.onComment)) {
          options.onComment = pushComment(options, options.onComment);
        }
        return options;
      }
      function pushComment(options, array) {
        return function(block, text, start, end, startLoc, endLoc) {
          var comment = {
            type: block ? "Block" : "Line",
            value: text,
            start,
            end
          };
          if (options.locations) {
            comment.loc = new SourceLocation(this, startLoc, endLoc);
          }
          if (options.ranges) {
            comment.range = [start, end];
          }
          array.push(comment);
        };
      }
      var SCOPE_TOP = 1, SCOPE_FUNCTION = 2, SCOPE_VAR = SCOPE_TOP | SCOPE_FUNCTION, SCOPE_ASYNC = 4, SCOPE_GENERATOR = 8, SCOPE_ARROW = 16, SCOPE_SIMPLE_CATCH = 32, SCOPE_SUPER = 64, SCOPE_DIRECT_SUPER = 128;
      function functionFlags(async, generator) {
        return SCOPE_FUNCTION | (async ? SCOPE_ASYNC : 0) | (generator ? SCOPE_GENERATOR : 0);
      }
      var BIND_NONE = 0, BIND_VAR = 1, BIND_LEXICAL = 2, BIND_FUNCTION = 3, BIND_SIMPLE_CATCH = 4, BIND_OUTSIDE = 5;
      var Parser = function Parser2(options, input, startPos) {
        this.options = options = getOptions(options);
        this.sourceFile = options.sourceFile;
        this.keywords = wordsRegexp(keywords[options.ecmaVersion >= 6 ? 6 : options.sourceType === "module" ? "5module" : 5]);
        var reserved = "";
        if (options.allowReserved !== true) {
          for (var v = options.ecmaVersion; ; v--) {
            if (reserved = reservedWords[v]) {
              break;
            }
          }
          if (options.sourceType === "module") {
            reserved += " await";
          }
        }
        this.reservedWords = wordsRegexp(reserved);
        var reservedStrict = (reserved ? reserved + " " : "") + reservedWords.strict;
        this.reservedWordsStrict = wordsRegexp(reservedStrict);
        this.reservedWordsStrictBind = wordsRegexp(reservedStrict + " " + reservedWords.strictBind);
        this.input = String(input);
        this.containsEsc = false;
        if (startPos) {
          this.pos = startPos;
          this.lineStart = this.input.lastIndexOf("\n", startPos - 1) + 1;
          this.curLine = this.input.slice(0, this.lineStart).split(lineBreak).length;
        } else {
          this.pos = this.lineStart = 0;
          this.curLine = 1;
        }
        this.type = types.eof;
        this.value = null;
        this.start = this.end = this.pos;
        this.startLoc = this.endLoc = this.curPosition();
        this.lastTokEndLoc = this.lastTokStartLoc = null;
        this.lastTokStart = this.lastTokEnd = this.pos;
        this.context = this.initialContext();
        this.exprAllowed = true;
        this.inModule = options.sourceType === "module";
        this.strict = this.inModule || this.strictDirective(this.pos);
        this.potentialArrowAt = -1;
        this.yieldPos = this.awaitPos = this.awaitIdentPos = 0;
        this.labels = [];
        this.undefinedExports = {};
        if (this.pos === 0 && options.allowHashBang && this.input.slice(0, 2) === "#!") {
          this.skipLineComment(2);
        }
        this.scopeStack = [];
        this.enterScope(SCOPE_TOP);
        this.regexpState = null;
      };
      var prototypeAccessors = { inFunction: { configurable: true }, inGenerator: { configurable: true }, inAsync: { configurable: true }, allowSuper: { configurable: true }, allowDirectSuper: { configurable: true }, treatFunctionsAsVar: { configurable: true } };
      Parser.prototype.parse = function parse3() {
        var node = this.options.program || this.startNode();
        this.nextToken();
        return this.parseTopLevel(node);
      };
      prototypeAccessors.inFunction.get = function() {
        return (this.currentVarScope().flags & SCOPE_FUNCTION) > 0;
      };
      prototypeAccessors.inGenerator.get = function() {
        return (this.currentVarScope().flags & SCOPE_GENERATOR) > 0;
      };
      prototypeAccessors.inAsync.get = function() {
        return (this.currentVarScope().flags & SCOPE_ASYNC) > 0;
      };
      prototypeAccessors.allowSuper.get = function() {
        return (this.currentThisScope().flags & SCOPE_SUPER) > 0;
      };
      prototypeAccessors.allowDirectSuper.get = function() {
        return (this.currentThisScope().flags & SCOPE_DIRECT_SUPER) > 0;
      };
      prototypeAccessors.treatFunctionsAsVar.get = function() {
        return this.treatFunctionsAsVarInScope(this.currentScope());
      };
      Parser.prototype.inNonArrowFunction = function inNonArrowFunction() {
        return (this.currentThisScope().flags & SCOPE_FUNCTION) > 0;
      };
      Parser.extend = function extend() {
        var plugins = [], len = arguments.length;
        while (len--)
          plugins[len] = arguments[len];
        var cls = this;
        for (var i = 0; i < plugins.length; i++) {
          cls = plugins[i](cls);
        }
        return cls;
      };
      Parser.parse = function parse3(input, options) {
        return new this(options, input).parse();
      };
      Parser.parseExpressionAt = function parseExpressionAt2(input, pos, options) {
        var parser = new this(options, input, pos);
        parser.nextToken();
        return parser.parseExpression();
      };
      Parser.tokenizer = function tokenizer2(input, options) {
        return new this(options, input);
      };
      Object.defineProperties(Parser.prototype, prototypeAccessors);
      var pp = Parser.prototype;
      var literal = /^(?:'((?:\\.|[^'\\])*?)'|"((?:\\.|[^"\\])*?)")/;
      pp.strictDirective = function(start) {
        for (; ; ) {
          skipWhiteSpace.lastIndex = start;
          start += skipWhiteSpace.exec(this.input)[0].length;
          var match = literal.exec(this.input.slice(start));
          if (!match) {
            return false;
          }
          if ((match[1] || match[2]) === "use strict") {
            skipWhiteSpace.lastIndex = start + match[0].length;
            var spaceAfter = skipWhiteSpace.exec(this.input), end = spaceAfter.index + spaceAfter[0].length;
            var next = this.input.charAt(end);
            return next === ";" || next === "}" || lineBreak.test(spaceAfter[0]) && !(/[(`.[+\-/*%<>=,?^&]/.test(next) || next === "!" && this.input.charAt(end + 1) === "=");
          }
          start += match[0].length;
          skipWhiteSpace.lastIndex = start;
          start += skipWhiteSpace.exec(this.input)[0].length;
          if (this.input[start] === ";") {
            start++;
          }
        }
      };
      pp.eat = function(type) {
        if (this.type === type) {
          this.next();
          return true;
        } else {
          return false;
        }
      };
      pp.isContextual = function(name) {
        return this.type === types.name && this.value === name && !this.containsEsc;
      };
      pp.eatContextual = function(name) {
        if (!this.isContextual(name)) {
          return false;
        }
        this.next();
        return true;
      };
      pp.expectContextual = function(name) {
        if (!this.eatContextual(name)) {
          this.unexpected();
        }
      };
      pp.canInsertSemicolon = function() {
        return this.type === types.eof || this.type === types.braceR || lineBreak.test(this.input.slice(this.lastTokEnd, this.start));
      };
      pp.insertSemicolon = function() {
        if (this.canInsertSemicolon()) {
          if (this.options.onInsertedSemicolon) {
            this.options.onInsertedSemicolon(this.lastTokEnd, this.lastTokEndLoc);
          }
          return true;
        }
      };
      pp.semicolon = function() {
        if (!this.eat(types.semi) && !this.insertSemicolon()) {
          this.unexpected();
        }
      };
      pp.afterTrailingComma = function(tokType, notNext) {
        if (this.type === tokType) {
          if (this.options.onTrailingComma) {
            this.options.onTrailingComma(this.lastTokStart, this.lastTokStartLoc);
          }
          if (!notNext) {
            this.next();
          }
          return true;
        }
      };
      pp.expect = function(type) {
        this.eat(type) || this.unexpected();
      };
      pp.unexpected = function(pos) {
        this.raise(pos != null ? pos : this.start, "Unexpected token");
      };
      function DestructuringErrors() {
        this.shorthandAssign = this.trailingComma = this.parenthesizedAssign = this.parenthesizedBind = this.doubleProto = -1;
      }
      pp.checkPatternErrors = function(refDestructuringErrors, isAssign) {
        if (!refDestructuringErrors) {
          return;
        }
        if (refDestructuringErrors.trailingComma > -1) {
          this.raiseRecoverable(refDestructuringErrors.trailingComma, "Comma is not permitted after the rest element");
        }
        var parens = isAssign ? refDestructuringErrors.parenthesizedAssign : refDestructuringErrors.parenthesizedBind;
        if (parens > -1) {
          this.raiseRecoverable(parens, "Parenthesized pattern");
        }
      };
      pp.checkExpressionErrors = function(refDestructuringErrors, andThrow) {
        if (!refDestructuringErrors) {
          return false;
        }
        var shorthandAssign = refDestructuringErrors.shorthandAssign;
        var doubleProto = refDestructuringErrors.doubleProto;
        if (!andThrow) {
          return shorthandAssign >= 0 || doubleProto >= 0;
        }
        if (shorthandAssign >= 0) {
          this.raise(shorthandAssign, "Shorthand property assignments are valid only in destructuring patterns");
        }
        if (doubleProto >= 0) {
          this.raiseRecoverable(doubleProto, "Redefinition of __proto__ property");
        }
      };
      pp.checkYieldAwaitInDefaultParams = function() {
        if (this.yieldPos && (!this.awaitPos || this.yieldPos < this.awaitPos)) {
          this.raise(this.yieldPos, "Yield expression cannot be a default value");
        }
        if (this.awaitPos) {
          this.raise(this.awaitPos, "Await expression cannot be a default value");
        }
      };
      pp.isSimpleAssignTarget = function(expr) {
        if (expr.type === "ParenthesizedExpression") {
          return this.isSimpleAssignTarget(expr.expression);
        }
        return expr.type === "Identifier" || expr.type === "MemberExpression";
      };
      var pp$1 = Parser.prototype;
      pp$1.parseTopLevel = function(node) {
        var exports3 = {};
        if (!node.body) {
          node.body = [];
        }
        while (this.type !== types.eof) {
          var stmt = this.parseStatement(null, true, exports3);
          node.body.push(stmt);
        }
        if (this.inModule) {
          for (var i = 0, list = Object.keys(this.undefinedExports); i < list.length; i += 1) {
            var name = list[i];
            this.raiseRecoverable(this.undefinedExports[name].start, "Export '" + name + "' is not defined");
          }
        }
        this.adaptDirectivePrologue(node.body);
        this.next();
        node.sourceType = this.options.sourceType;
        return this.finishNode(node, "Program");
      };
      var loopLabel = { kind: "loop" }, switchLabel = { kind: "switch" };
      pp$1.isLet = function(context) {
        if (this.options.ecmaVersion < 6 || !this.isContextual("let")) {
          return false;
        }
        skipWhiteSpace.lastIndex = this.pos;
        var skip = skipWhiteSpace.exec(this.input);
        var next = this.pos + skip[0].length, nextCh = this.input.charCodeAt(next);
        if (nextCh === 91) {
          return true;
        }
        if (context) {
          return false;
        }
        if (nextCh === 123) {
          return true;
        }
        if (isIdentifierStart(nextCh, true)) {
          var pos = next + 1;
          while (isIdentifierChar(this.input.charCodeAt(pos), true)) {
            ++pos;
          }
          var ident = this.input.slice(next, pos);
          if (!keywordRelationalOperator.test(ident)) {
            return true;
          }
        }
        return false;
      };
      pp$1.isAsyncFunction = function() {
        if (this.options.ecmaVersion < 8 || !this.isContextual("async")) {
          return false;
        }
        skipWhiteSpace.lastIndex = this.pos;
        var skip = skipWhiteSpace.exec(this.input);
        var next = this.pos + skip[0].length;
        return !lineBreak.test(this.input.slice(this.pos, next)) && this.input.slice(next, next + 8) === "function" && (next + 8 === this.input.length || !isIdentifierChar(this.input.charAt(next + 8)));
      };
      pp$1.parseStatement = function(context, topLevel, exports3) {
        var starttype = this.type, node = this.startNode(), kind;
        if (this.isLet(context)) {
          starttype = types._var;
          kind = "let";
        }
        switch (starttype) {
          case types._break:
          case types._continue:
            return this.parseBreakContinueStatement(node, starttype.keyword);
          case types._debugger:
            return this.parseDebuggerStatement(node);
          case types._do:
            return this.parseDoStatement(node);
          case types._for:
            return this.parseForStatement(node);
          case types._function:
            if (context && (this.strict || context !== "if" && context !== "label") && this.options.ecmaVersion >= 6) {
              this.unexpected();
            }
            return this.parseFunctionStatement(node, false, !context);
          case types._class:
            if (context) {
              this.unexpected();
            }
            return this.parseClass(node, true);
          case types._if:
            return this.parseIfStatement(node);
          case types._return:
            return this.parseReturnStatement(node);
          case types._switch:
            return this.parseSwitchStatement(node);
          case types._throw:
            return this.parseThrowStatement(node);
          case types._try:
            return this.parseTryStatement(node);
          case types._const:
          case types._var:
            kind = kind || this.value;
            if (context && kind !== "var") {
              this.unexpected();
            }
            return this.parseVarStatement(node, kind);
          case types._while:
            return this.parseWhileStatement(node);
          case types._with:
            return this.parseWithStatement(node);
          case types.braceL:
            return this.parseBlock(true, node);
          case types.semi:
            return this.parseEmptyStatement(node);
          case types._export:
          case types._import:
            if (this.options.ecmaVersion > 10 && starttype === types._import) {
              skipWhiteSpace.lastIndex = this.pos;
              var skip = skipWhiteSpace.exec(this.input);
              var next = this.pos + skip[0].length, nextCh = this.input.charCodeAt(next);
              if (nextCh === 40 || nextCh === 46) {
                return this.parseExpressionStatement(node, this.parseExpression());
              }
            }
            if (!this.options.allowImportExportEverywhere) {
              if (!topLevel) {
                this.raise(this.start, "'import' and 'export' may only appear at the top level");
              }
              if (!this.inModule) {
                this.raise(this.start, "'import' and 'export' may appear only with 'sourceType: module'");
              }
            }
            return starttype === types._import ? this.parseImport(node) : this.parseExport(node, exports3);
          default:
            if (this.isAsyncFunction()) {
              if (context) {
                this.unexpected();
              }
              this.next();
              return this.parseFunctionStatement(node, true, !context);
            }
            var maybeName = this.value, expr = this.parseExpression();
            if (starttype === types.name && expr.type === "Identifier" && this.eat(types.colon)) {
              return this.parseLabeledStatement(node, maybeName, expr, context);
            } else {
              return this.parseExpressionStatement(node, expr);
            }
        }
      };
      pp$1.parseBreakContinueStatement = function(node, keyword) {
        var isBreak = keyword === "break";
        this.next();
        if (this.eat(types.semi) || this.insertSemicolon()) {
          node.label = null;
        } else if (this.type !== types.name) {
          this.unexpected();
        } else {
          node.label = this.parseIdent();
          this.semicolon();
        }
        var i = 0;
        for (; i < this.labels.length; ++i) {
          var lab = this.labels[i];
          if (node.label == null || lab.name === node.label.name) {
            if (lab.kind != null && (isBreak || lab.kind === "loop")) {
              break;
            }
            if (node.label && isBreak) {
              break;
            }
          }
        }
        if (i === this.labels.length) {
          this.raise(node.start, "Unsyntactic " + keyword);
        }
        return this.finishNode(node, isBreak ? "BreakStatement" : "ContinueStatement");
      };
      pp$1.parseDebuggerStatement = function(node) {
        this.next();
        this.semicolon();
        return this.finishNode(node, "DebuggerStatement");
      };
      pp$1.parseDoStatement = function(node) {
        this.next();
        this.labels.push(loopLabel);
        node.body = this.parseStatement("do");
        this.labels.pop();
        this.expect(types._while);
        node.test = this.parseParenExpression();
        if (this.options.ecmaVersion >= 6) {
          this.eat(types.semi);
        } else {
          this.semicolon();
        }
        return this.finishNode(node, "DoWhileStatement");
      };
      pp$1.parseForStatement = function(node) {
        this.next();
        var awaitAt = this.options.ecmaVersion >= 9 && (this.inAsync || !this.inFunction && this.options.allowAwaitOutsideFunction) && this.eatContextual("await") ? this.lastTokStart : -1;
        this.labels.push(loopLabel);
        this.enterScope(0);
        this.expect(types.parenL);
        if (this.type === types.semi) {
          if (awaitAt > -1) {
            this.unexpected(awaitAt);
          }
          return this.parseFor(node, null);
        }
        var isLet = this.isLet();
        if (this.type === types._var || this.type === types._const || isLet) {
          var init$1 = this.startNode(), kind = isLet ? "let" : this.value;
          this.next();
          this.parseVar(init$1, true, kind);
          this.finishNode(init$1, "VariableDeclaration");
          if ((this.type === types._in || this.options.ecmaVersion >= 6 && this.isContextual("of")) && init$1.declarations.length === 1) {
            if (this.options.ecmaVersion >= 9) {
              if (this.type === types._in) {
                if (awaitAt > -1) {
                  this.unexpected(awaitAt);
                }
              } else {
                node.await = awaitAt > -1;
              }
            }
            return this.parseForIn(node, init$1);
          }
          if (awaitAt > -1) {
            this.unexpected(awaitAt);
          }
          return this.parseFor(node, init$1);
        }
        var refDestructuringErrors = new DestructuringErrors();
        var init = this.parseExpression(true, refDestructuringErrors);
        if (this.type === types._in || this.options.ecmaVersion >= 6 && this.isContextual("of")) {
          if (this.options.ecmaVersion >= 9) {
            if (this.type === types._in) {
              if (awaitAt > -1) {
                this.unexpected(awaitAt);
              }
            } else {
              node.await = awaitAt > -1;
            }
          }
          this.toAssignable(init, false, refDestructuringErrors);
          this.checkLVal(init);
          return this.parseForIn(node, init);
        } else {
          this.checkExpressionErrors(refDestructuringErrors, true);
        }
        if (awaitAt > -1) {
          this.unexpected(awaitAt);
        }
        return this.parseFor(node, init);
      };
      pp$1.parseFunctionStatement = function(node, isAsync, declarationPosition) {
        this.next();
        return this.parseFunction(node, FUNC_STATEMENT | (declarationPosition ? 0 : FUNC_HANGING_STATEMENT), false, isAsync);
      };
      pp$1.parseIfStatement = function(node) {
        this.next();
        node.test = this.parseParenExpression();
        node.consequent = this.parseStatement("if");
        node.alternate = this.eat(types._else) ? this.parseStatement("if") : null;
        return this.finishNode(node, "IfStatement");
      };
      pp$1.parseReturnStatement = function(node) {
        if (!this.inFunction && !this.options.allowReturnOutsideFunction) {
          this.raise(this.start, "'return' outside of function");
        }
        this.next();
        if (this.eat(types.semi) || this.insertSemicolon()) {
          node.argument = null;
        } else {
          node.argument = this.parseExpression();
          this.semicolon();
        }
        return this.finishNode(node, "ReturnStatement");
      };
      pp$1.parseSwitchStatement = function(node) {
        this.next();
        node.discriminant = this.parseParenExpression();
        node.cases = [];
        this.expect(types.braceL);
        this.labels.push(switchLabel);
        this.enterScope(0);
        var cur;
        for (var sawDefault = false; this.type !== types.braceR; ) {
          if (this.type === types._case || this.type === types._default) {
            var isCase = this.type === types._case;
            if (cur) {
              this.finishNode(cur, "SwitchCase");
            }
            node.cases.push(cur = this.startNode());
            cur.consequent = [];
            this.next();
            if (isCase) {
              cur.test = this.parseExpression();
            } else {
              if (sawDefault) {
                this.raiseRecoverable(this.lastTokStart, "Multiple default clauses");
              }
              sawDefault = true;
              cur.test = null;
            }
            this.expect(types.colon);
          } else {
            if (!cur) {
              this.unexpected();
            }
            cur.consequent.push(this.parseStatement(null));
          }
        }
        this.exitScope();
        if (cur) {
          this.finishNode(cur, "SwitchCase");
        }
        this.next();
        this.labels.pop();
        return this.finishNode(node, "SwitchStatement");
      };
      pp$1.parseThrowStatement = function(node) {
        this.next();
        if (lineBreak.test(this.input.slice(this.lastTokEnd, this.start))) {
          this.raise(this.lastTokEnd, "Illegal newline after throw");
        }
        node.argument = this.parseExpression();
        this.semicolon();
        return this.finishNode(node, "ThrowStatement");
      };
      var empty = [];
      pp$1.parseTryStatement = function(node) {
        this.next();
        node.block = this.parseBlock();
        node.handler = null;
        if (this.type === types._catch) {
          var clause = this.startNode();
          this.next();
          if (this.eat(types.parenL)) {
            clause.param = this.parseBindingAtom();
            var simple = clause.param.type === "Identifier";
            this.enterScope(simple ? SCOPE_SIMPLE_CATCH : 0);
            this.checkLVal(clause.param, simple ? BIND_SIMPLE_CATCH : BIND_LEXICAL);
            this.expect(types.parenR);
          } else {
            if (this.options.ecmaVersion < 10) {
              this.unexpected();
            }
            clause.param = null;
            this.enterScope(0);
          }
          clause.body = this.parseBlock(false);
          this.exitScope();
          node.handler = this.finishNode(clause, "CatchClause");
        }
        node.finalizer = this.eat(types._finally) ? this.parseBlock() : null;
        if (!node.handler && !node.finalizer) {
          this.raise(node.start, "Missing catch or finally clause");
        }
        return this.finishNode(node, "TryStatement");
      };
      pp$1.parseVarStatement = function(node, kind) {
        this.next();
        this.parseVar(node, false, kind);
        this.semicolon();
        return this.finishNode(node, "VariableDeclaration");
      };
      pp$1.parseWhileStatement = function(node) {
        this.next();
        node.test = this.parseParenExpression();
        this.labels.push(loopLabel);
        node.body = this.parseStatement("while");
        this.labels.pop();
        return this.finishNode(node, "WhileStatement");
      };
      pp$1.parseWithStatement = function(node) {
        if (this.strict) {
          this.raise(this.start, "'with' in strict mode");
        }
        this.next();
        node.object = this.parseParenExpression();
        node.body = this.parseStatement("with");
        return this.finishNode(node, "WithStatement");
      };
      pp$1.parseEmptyStatement = function(node) {
        this.next();
        return this.finishNode(node, "EmptyStatement");
      };
      pp$1.parseLabeledStatement = function(node, maybeName, expr, context) {
        for (var i$1 = 0, list = this.labels; i$1 < list.length; i$1 += 1) {
          var label = list[i$1];
          if (label.name === maybeName) {
            this.raise(expr.start, "Label '" + maybeName + "' is already declared");
          }
        }
        var kind = this.type.isLoop ? "loop" : this.type === types._switch ? "switch" : null;
        for (var i = this.labels.length - 1; i >= 0; i--) {
          var label$1 = this.labels[i];
          if (label$1.statementStart === node.start) {
            label$1.statementStart = this.start;
            label$1.kind = kind;
          } else {
            break;
          }
        }
        this.labels.push({ name: maybeName, kind, statementStart: this.start });
        node.body = this.parseStatement(context ? context.indexOf("label") === -1 ? context + "label" : context : "label");
        this.labels.pop();
        node.label = expr;
        return this.finishNode(node, "LabeledStatement");
      };
      pp$1.parseExpressionStatement = function(node, expr) {
        node.expression = expr;
        this.semicolon();
        return this.finishNode(node, "ExpressionStatement");
      };
      pp$1.parseBlock = function(createNewLexicalScope, node, exitStrict) {
        if (createNewLexicalScope === void 0)
          createNewLexicalScope = true;
        if (node === void 0)
          node = this.startNode();
        node.body = [];
        this.expect(types.braceL);
        if (createNewLexicalScope) {
          this.enterScope(0);
        }
        while (this.type !== types.braceR) {
          var stmt = this.parseStatement(null);
          node.body.push(stmt);
        }
        if (exitStrict) {
          this.strict = false;
        }
        this.next();
        if (createNewLexicalScope) {
          this.exitScope();
        }
        return this.finishNode(node, "BlockStatement");
      };
      pp$1.parseFor = function(node, init) {
        node.init = init;
        this.expect(types.semi);
        node.test = this.type === types.semi ? null : this.parseExpression();
        this.expect(types.semi);
        node.update = this.type === types.parenR ? null : this.parseExpression();
        this.expect(types.parenR);
        node.body = this.parseStatement("for");
        this.exitScope();
        this.labels.pop();
        return this.finishNode(node, "ForStatement");
      };
      pp$1.parseForIn = function(node, init) {
        var isForIn = this.type === types._in;
        this.next();
        if (init.type === "VariableDeclaration" && init.declarations[0].init != null && (!isForIn || this.options.ecmaVersion < 8 || this.strict || init.kind !== "var" || init.declarations[0].id.type !== "Identifier")) {
          this.raise(
            init.start,
            (isForIn ? "for-in" : "for-of") + " loop variable declaration may not have an initializer"
          );
        } else if (init.type === "AssignmentPattern") {
          this.raise(init.start, "Invalid left-hand side in for-loop");
        }
        node.left = init;
        node.right = isForIn ? this.parseExpression() : this.parseMaybeAssign();
        this.expect(types.parenR);
        node.body = this.parseStatement("for");
        this.exitScope();
        this.labels.pop();
        return this.finishNode(node, isForIn ? "ForInStatement" : "ForOfStatement");
      };
      pp$1.parseVar = function(node, isFor, kind) {
        node.declarations = [];
        node.kind = kind;
        for (; ; ) {
          var decl = this.startNode();
          this.parseVarId(decl, kind);
          if (this.eat(types.eq)) {
            decl.init = this.parseMaybeAssign(isFor);
          } else if (kind === "const" && !(this.type === types._in || this.options.ecmaVersion >= 6 && this.isContextual("of"))) {
            this.unexpected();
          } else if (decl.id.type !== "Identifier" && !(isFor && (this.type === types._in || this.isContextual("of")))) {
            this.raise(this.lastTokEnd, "Complex binding patterns require an initialization value");
          } else {
            decl.init = null;
          }
          node.declarations.push(this.finishNode(decl, "VariableDeclarator"));
          if (!this.eat(types.comma)) {
            break;
          }
        }
        return node;
      };
      pp$1.parseVarId = function(decl, kind) {
        decl.id = this.parseBindingAtom();
        this.checkLVal(decl.id, kind === "var" ? BIND_VAR : BIND_LEXICAL, false);
      };
      var FUNC_STATEMENT = 1, FUNC_HANGING_STATEMENT = 2, FUNC_NULLABLE_ID = 4;
      pp$1.parseFunction = function(node, statement, allowExpressionBody, isAsync) {
        this.initFunction(node);
        if (this.options.ecmaVersion >= 9 || this.options.ecmaVersion >= 6 && !isAsync) {
          if (this.type === types.star && statement & FUNC_HANGING_STATEMENT) {
            this.unexpected();
          }
          node.generator = this.eat(types.star);
        }
        if (this.options.ecmaVersion >= 8) {
          node.async = !!isAsync;
        }
        if (statement & FUNC_STATEMENT) {
          node.id = statement & FUNC_NULLABLE_ID && this.type !== types.name ? null : this.parseIdent();
          if (node.id && !(statement & FUNC_HANGING_STATEMENT)) {
            this.checkLVal(node.id, this.strict || node.generator || node.async ? this.treatFunctionsAsVar ? BIND_VAR : BIND_LEXICAL : BIND_FUNCTION);
          }
        }
        var oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
        this.yieldPos = 0;
        this.awaitPos = 0;
        this.awaitIdentPos = 0;
        this.enterScope(functionFlags(node.async, node.generator));
        if (!(statement & FUNC_STATEMENT)) {
          node.id = this.type === types.name ? this.parseIdent() : null;
        }
        this.parseFunctionParams(node);
        this.parseFunctionBody(node, allowExpressionBody, false);
        this.yieldPos = oldYieldPos;
        this.awaitPos = oldAwaitPos;
        this.awaitIdentPos = oldAwaitIdentPos;
        return this.finishNode(node, statement & FUNC_STATEMENT ? "FunctionDeclaration" : "FunctionExpression");
      };
      pp$1.parseFunctionParams = function(node) {
        this.expect(types.parenL);
        node.params = this.parseBindingList(types.parenR, false, this.options.ecmaVersion >= 8);
        this.checkYieldAwaitInDefaultParams();
      };
      pp$1.parseClass = function(node, isStatement) {
        this.next();
        var oldStrict = this.strict;
        this.strict = true;
        this.parseClassId(node, isStatement);
        this.parseClassSuper(node);
        var classBody = this.startNode();
        var hadConstructor = false;
        classBody.body = [];
        this.expect(types.braceL);
        while (this.type !== types.braceR) {
          var element = this.parseClassElement(node.superClass !== null);
          if (element) {
            classBody.body.push(element);
            if (element.type === "MethodDefinition" && element.kind === "constructor") {
              if (hadConstructor) {
                this.raise(element.start, "Duplicate constructor in the same class");
              }
              hadConstructor = true;
            }
          }
        }
        this.strict = oldStrict;
        this.next();
        node.body = this.finishNode(classBody, "ClassBody");
        return this.finishNode(node, isStatement ? "ClassDeclaration" : "ClassExpression");
      };
      pp$1.parseClassElement = function(constructorAllowsSuper) {
        var this$1 = this;
        if (this.eat(types.semi)) {
          return null;
        }
        var method = this.startNode();
        var tryContextual = function(k, noLineBreak) {
          if (noLineBreak === void 0)
            noLineBreak = false;
          var start = this$1.start, startLoc = this$1.startLoc;
          if (!this$1.eatContextual(k)) {
            return false;
          }
          if (this$1.type !== types.parenL && (!noLineBreak || !this$1.canInsertSemicolon())) {
            return true;
          }
          if (method.key) {
            this$1.unexpected();
          }
          method.computed = false;
          method.key = this$1.startNodeAt(start, startLoc);
          method.key.name = k;
          this$1.finishNode(method.key, "Identifier");
          return false;
        };
        method.kind = "method";
        method.static = tryContextual("static");
        var isGenerator = this.eat(types.star);
        var isAsync = false;
        if (!isGenerator) {
          if (this.options.ecmaVersion >= 8 && tryContextual("async", true)) {
            isAsync = true;
            isGenerator = this.options.ecmaVersion >= 9 && this.eat(types.star);
          } else if (tryContextual("get")) {
            method.kind = "get";
          } else if (tryContextual("set")) {
            method.kind = "set";
          }
        }
        if (!method.key) {
          this.parsePropertyName(method);
        }
        var key = method.key;
        var allowsDirectSuper = false;
        if (!method.computed && !method.static && (key.type === "Identifier" && key.name === "constructor" || key.type === "Literal" && key.value === "constructor")) {
          if (method.kind !== "method") {
            this.raise(key.start, "Constructor can't have get/set modifier");
          }
          if (isGenerator) {
            this.raise(key.start, "Constructor can't be a generator");
          }
          if (isAsync) {
            this.raise(key.start, "Constructor can't be an async method");
          }
          method.kind = "constructor";
          allowsDirectSuper = constructorAllowsSuper;
        } else if (method.static && key.type === "Identifier" && key.name === "prototype") {
          this.raise(key.start, "Classes may not have a static property named prototype");
        }
        this.parseClassMethod(method, isGenerator, isAsync, allowsDirectSuper);
        if (method.kind === "get" && method.value.params.length !== 0) {
          this.raiseRecoverable(method.value.start, "getter should have no params");
        }
        if (method.kind === "set" && method.value.params.length !== 1) {
          this.raiseRecoverable(method.value.start, "setter should have exactly one param");
        }
        if (method.kind === "set" && method.value.params[0].type === "RestElement") {
          this.raiseRecoverable(method.value.params[0].start, "Setter cannot use rest params");
        }
        return method;
      };
      pp$1.parseClassMethod = function(method, isGenerator, isAsync, allowsDirectSuper) {
        method.value = this.parseMethod(isGenerator, isAsync, allowsDirectSuper);
        return this.finishNode(method, "MethodDefinition");
      };
      pp$1.parseClassId = function(node, isStatement) {
        if (this.type === types.name) {
          node.id = this.parseIdent();
          if (isStatement) {
            this.checkLVal(node.id, BIND_LEXICAL, false);
          }
        } else {
          if (isStatement === true) {
            this.unexpected();
          }
          node.id = null;
        }
      };
      pp$1.parseClassSuper = function(node) {
        node.superClass = this.eat(types._extends) ? this.parseExprSubscripts() : null;
      };
      pp$1.parseExport = function(node, exports3) {
        this.next();
        if (this.eat(types.star)) {
          if (this.options.ecmaVersion >= 11) {
            if (this.eatContextual("as")) {
              node.exported = this.parseIdent(true);
              this.checkExport(exports3, node.exported.name, this.lastTokStart);
            } else {
              node.exported = null;
            }
          }
          this.expectContextual("from");
          if (this.type !== types.string) {
            this.unexpected();
          }
          node.source = this.parseExprAtom();
          this.semicolon();
          return this.finishNode(node, "ExportAllDeclaration");
        }
        if (this.eat(types._default)) {
          this.checkExport(exports3, "default", this.lastTokStart);
          var isAsync;
          if (this.type === types._function || (isAsync = this.isAsyncFunction())) {
            var fNode = this.startNode();
            this.next();
            if (isAsync) {
              this.next();
            }
            node.declaration = this.parseFunction(fNode, FUNC_STATEMENT | FUNC_NULLABLE_ID, false, isAsync);
          } else if (this.type === types._class) {
            var cNode = this.startNode();
            node.declaration = this.parseClass(cNode, "nullableID");
          } else {
            node.declaration = this.parseMaybeAssign();
            this.semicolon();
          }
          return this.finishNode(node, "ExportDefaultDeclaration");
        }
        if (this.shouldParseExportStatement()) {
          node.declaration = this.parseStatement(null);
          if (node.declaration.type === "VariableDeclaration") {
            this.checkVariableExport(exports3, node.declaration.declarations);
          } else {
            this.checkExport(exports3, node.declaration.id.name, node.declaration.id.start);
          }
          node.specifiers = [];
          node.source = null;
        } else {
          node.declaration = null;
          node.specifiers = this.parseExportSpecifiers(exports3);
          if (this.eatContextual("from")) {
            if (this.type !== types.string) {
              this.unexpected();
            }
            node.source = this.parseExprAtom();
          } else {
            for (var i = 0, list = node.specifiers; i < list.length; i += 1) {
              var spec = list[i];
              this.checkUnreserved(spec.local);
              this.checkLocalExport(spec.local);
            }
            node.source = null;
          }
          this.semicolon();
        }
        return this.finishNode(node, "ExportNamedDeclaration");
      };
      pp$1.checkExport = function(exports3, name, pos) {
        if (!exports3) {
          return;
        }
        if (has(exports3, name)) {
          this.raiseRecoverable(pos, "Duplicate export '" + name + "'");
        }
        exports3[name] = true;
      };
      pp$1.checkPatternExport = function(exports3, pat) {
        var type = pat.type;
        if (type === "Identifier") {
          this.checkExport(exports3, pat.name, pat.start);
        } else if (type === "ObjectPattern") {
          for (var i = 0, list = pat.properties; i < list.length; i += 1) {
            var prop = list[i];
            this.checkPatternExport(exports3, prop);
          }
        } else if (type === "ArrayPattern") {
          for (var i$1 = 0, list$1 = pat.elements; i$1 < list$1.length; i$1 += 1) {
            var elt = list$1[i$1];
            if (elt) {
              this.checkPatternExport(exports3, elt);
            }
          }
        } else if (type === "Property") {
          this.checkPatternExport(exports3, pat.value);
        } else if (type === "AssignmentPattern") {
          this.checkPatternExport(exports3, pat.left);
        } else if (type === "RestElement") {
          this.checkPatternExport(exports3, pat.argument);
        } else if (type === "ParenthesizedExpression") {
          this.checkPatternExport(exports3, pat.expression);
        }
      };
      pp$1.checkVariableExport = function(exports3, decls) {
        if (!exports3) {
          return;
        }
        for (var i = 0, list = decls; i < list.length; i += 1) {
          var decl = list[i];
          this.checkPatternExport(exports3, decl.id);
        }
      };
      pp$1.shouldParseExportStatement = function() {
        return this.type.keyword === "var" || this.type.keyword === "const" || this.type.keyword === "class" || this.type.keyword === "function" || this.isLet() || this.isAsyncFunction();
      };
      pp$1.parseExportSpecifiers = function(exports3) {
        var nodes = [], first = true;
        this.expect(types.braceL);
        while (!this.eat(types.braceR)) {
          if (!first) {
            this.expect(types.comma);
            if (this.afterTrailingComma(types.braceR)) {
              break;
            }
          } else {
            first = false;
          }
          var node = this.startNode();
          node.local = this.parseIdent(true);
          node.exported = this.eatContextual("as") ? this.parseIdent(true) : node.local;
          this.checkExport(exports3, node.exported.name, node.exported.start);
          nodes.push(this.finishNode(node, "ExportSpecifier"));
        }
        return nodes;
      };
      pp$1.parseImport = function(node) {
        this.next();
        if (this.type === types.string) {
          node.specifiers = empty;
          node.source = this.parseExprAtom();
        } else {
          node.specifiers = this.parseImportSpecifiers();
          this.expectContextual("from");
          node.source = this.type === types.string ? this.parseExprAtom() : this.unexpected();
        }
        this.semicolon();
        return this.finishNode(node, "ImportDeclaration");
      };
      pp$1.parseImportSpecifiers = function() {
        var nodes = [], first = true;
        if (this.type === types.name) {
          var node = this.startNode();
          node.local = this.parseIdent();
          this.checkLVal(node.local, BIND_LEXICAL);
          nodes.push(this.finishNode(node, "ImportDefaultSpecifier"));
          if (!this.eat(types.comma)) {
            return nodes;
          }
        }
        if (this.type === types.star) {
          var node$1 = this.startNode();
          this.next();
          this.expectContextual("as");
          node$1.local = this.parseIdent();
          this.checkLVal(node$1.local, BIND_LEXICAL);
          nodes.push(this.finishNode(node$1, "ImportNamespaceSpecifier"));
          return nodes;
        }
        this.expect(types.braceL);
        while (!this.eat(types.braceR)) {
          if (!first) {
            this.expect(types.comma);
            if (this.afterTrailingComma(types.braceR)) {
              break;
            }
          } else {
            first = false;
          }
          var node$2 = this.startNode();
          node$2.imported = this.parseIdent(true);
          if (this.eatContextual("as")) {
            node$2.local = this.parseIdent();
          } else {
            this.checkUnreserved(node$2.imported);
            node$2.local = node$2.imported;
          }
          this.checkLVal(node$2.local, BIND_LEXICAL);
          nodes.push(this.finishNode(node$2, "ImportSpecifier"));
        }
        return nodes;
      };
      pp$1.adaptDirectivePrologue = function(statements) {
        for (var i = 0; i < statements.length && this.isDirectiveCandidate(statements[i]); ++i) {
          statements[i].directive = statements[i].expression.raw.slice(1, -1);
        }
      };
      pp$1.isDirectiveCandidate = function(statement) {
        return statement.type === "ExpressionStatement" && statement.expression.type === "Literal" && typeof statement.expression.value === "string" && (this.input[statement.start] === '"' || this.input[statement.start] === "'");
      };
      var pp$2 = Parser.prototype;
      pp$2.toAssignable = function(node, isBinding, refDestructuringErrors) {
        if (this.options.ecmaVersion >= 6 && node) {
          switch (node.type) {
            case "Identifier":
              if (this.inAsync && node.name === "await") {
                this.raise(node.start, "Cannot use 'await' as identifier inside an async function");
              }
              break;
            case "ObjectPattern":
            case "ArrayPattern":
            case "RestElement":
              break;
            case "ObjectExpression":
              node.type = "ObjectPattern";
              if (refDestructuringErrors) {
                this.checkPatternErrors(refDestructuringErrors, true);
              }
              for (var i = 0, list = node.properties; i < list.length; i += 1) {
                var prop = list[i];
                this.toAssignable(prop, isBinding);
                if (prop.type === "RestElement" && (prop.argument.type === "ArrayPattern" || prop.argument.type === "ObjectPattern")) {
                  this.raise(prop.argument.start, "Unexpected token");
                }
              }
              break;
            case "Property":
              if (node.kind !== "init") {
                this.raise(node.key.start, "Object pattern can't contain getter or setter");
              }
              this.toAssignable(node.value, isBinding);
              break;
            case "ArrayExpression":
              node.type = "ArrayPattern";
              if (refDestructuringErrors) {
                this.checkPatternErrors(refDestructuringErrors, true);
              }
              this.toAssignableList(node.elements, isBinding);
              break;
            case "SpreadElement":
              node.type = "RestElement";
              this.toAssignable(node.argument, isBinding);
              if (node.argument.type === "AssignmentPattern") {
                this.raise(node.argument.start, "Rest elements cannot have a default value");
              }
              break;
            case "AssignmentExpression":
              if (node.operator !== "=") {
                this.raise(node.left.end, "Only '=' operator can be used for specifying default value.");
              }
              node.type = "AssignmentPattern";
              delete node.operator;
              this.toAssignable(node.left, isBinding);
            case "AssignmentPattern":
              break;
            case "ParenthesizedExpression":
              this.toAssignable(node.expression, isBinding, refDestructuringErrors);
              break;
            case "ChainExpression":
              this.raiseRecoverable(node.start, "Optional chaining cannot appear in left-hand side");
              break;
            case "MemberExpression":
              if (!isBinding) {
                break;
              }
            default:
              this.raise(node.start, "Assigning to rvalue");
          }
        } else if (refDestructuringErrors) {
          this.checkPatternErrors(refDestructuringErrors, true);
        }
        return node;
      };
      pp$2.toAssignableList = function(exprList, isBinding) {
        var end = exprList.length;
        for (var i = 0; i < end; i++) {
          var elt = exprList[i];
          if (elt) {
            this.toAssignable(elt, isBinding);
          }
        }
        if (end) {
          var last = exprList[end - 1];
          if (this.options.ecmaVersion === 6 && isBinding && last && last.type === "RestElement" && last.argument.type !== "Identifier") {
            this.unexpected(last.argument.start);
          }
        }
        return exprList;
      };
      pp$2.parseSpread = function(refDestructuringErrors) {
        var node = this.startNode();
        this.next();
        node.argument = this.parseMaybeAssign(false, refDestructuringErrors);
        return this.finishNode(node, "SpreadElement");
      };
      pp$2.parseRestBinding = function() {
        var node = this.startNode();
        this.next();
        if (this.options.ecmaVersion === 6 && this.type !== types.name) {
          this.unexpected();
        }
        node.argument = this.parseBindingAtom();
        return this.finishNode(node, "RestElement");
      };
      pp$2.parseBindingAtom = function() {
        if (this.options.ecmaVersion >= 6) {
          switch (this.type) {
            case types.bracketL:
              var node = this.startNode();
              this.next();
              node.elements = this.parseBindingList(types.bracketR, true, true);
              return this.finishNode(node, "ArrayPattern");
            case types.braceL:
              return this.parseObj(true);
          }
        }
        return this.parseIdent();
      };
      pp$2.parseBindingList = function(close, allowEmpty, allowTrailingComma) {
        var elts = [], first = true;
        while (!this.eat(close)) {
          if (first) {
            first = false;
          } else {
            this.expect(types.comma);
          }
          if (allowEmpty && this.type === types.comma) {
            elts.push(null);
          } else if (allowTrailingComma && this.afterTrailingComma(close)) {
            break;
          } else if (this.type === types.ellipsis) {
            var rest = this.parseRestBinding();
            this.parseBindingListItem(rest);
            elts.push(rest);
            if (this.type === types.comma) {
              this.raise(this.start, "Comma is not permitted after the rest element");
            }
            this.expect(close);
            break;
          } else {
            var elem = this.parseMaybeDefault(this.start, this.startLoc);
            this.parseBindingListItem(elem);
            elts.push(elem);
          }
        }
        return elts;
      };
      pp$2.parseBindingListItem = function(param) {
        return param;
      };
      pp$2.parseMaybeDefault = function(startPos, startLoc, left) {
        left = left || this.parseBindingAtom();
        if (this.options.ecmaVersion < 6 || !this.eat(types.eq)) {
          return left;
        }
        var node = this.startNodeAt(startPos, startLoc);
        node.left = left;
        node.right = this.parseMaybeAssign();
        return this.finishNode(node, "AssignmentPattern");
      };
      pp$2.checkLVal = function(expr, bindingType, checkClashes) {
        if (bindingType === void 0)
          bindingType = BIND_NONE;
        switch (expr.type) {
          case "Identifier":
            if (bindingType === BIND_LEXICAL && expr.name === "let") {
              this.raiseRecoverable(expr.start, "let is disallowed as a lexically bound name");
            }
            if (this.strict && this.reservedWordsStrictBind.test(expr.name)) {
              this.raiseRecoverable(expr.start, (bindingType ? "Binding " : "Assigning to ") + expr.name + " in strict mode");
            }
            if (checkClashes) {
              if (has(checkClashes, expr.name)) {
                this.raiseRecoverable(expr.start, "Argument name clash");
              }
              checkClashes[expr.name] = true;
            }
            if (bindingType !== BIND_NONE && bindingType !== BIND_OUTSIDE) {
              this.declareName(expr.name, bindingType, expr.start);
            }
            break;
          case "ChainExpression":
            this.raiseRecoverable(expr.start, "Optional chaining cannot appear in left-hand side");
            break;
          case "MemberExpression":
            if (bindingType) {
              this.raiseRecoverable(expr.start, "Binding member expression");
            }
            break;
          case "ObjectPattern":
            for (var i = 0, list = expr.properties; i < list.length; i += 1) {
              var prop = list[i];
              this.checkLVal(prop, bindingType, checkClashes);
            }
            break;
          case "Property":
            this.checkLVal(expr.value, bindingType, checkClashes);
            break;
          case "ArrayPattern":
            for (var i$1 = 0, list$1 = expr.elements; i$1 < list$1.length; i$1 += 1) {
              var elem = list$1[i$1];
              if (elem) {
                this.checkLVal(elem, bindingType, checkClashes);
              }
            }
            break;
          case "AssignmentPattern":
            this.checkLVal(expr.left, bindingType, checkClashes);
            break;
          case "RestElement":
            this.checkLVal(expr.argument, bindingType, checkClashes);
            break;
          case "ParenthesizedExpression":
            this.checkLVal(expr.expression, bindingType, checkClashes);
            break;
          default:
            this.raise(expr.start, (bindingType ? "Binding" : "Assigning to") + " rvalue");
        }
      };
      var pp$3 = Parser.prototype;
      pp$3.checkPropClash = function(prop, propHash, refDestructuringErrors) {
        if (this.options.ecmaVersion >= 9 && prop.type === "SpreadElement") {
          return;
        }
        if (this.options.ecmaVersion >= 6 && (prop.computed || prop.method || prop.shorthand)) {
          return;
        }
        var key = prop.key;
        var name;
        switch (key.type) {
          case "Identifier":
            name = key.name;
            break;
          case "Literal":
            name = String(key.value);
            break;
          default:
            return;
        }
        var kind = prop.kind;
        if (this.options.ecmaVersion >= 6) {
          if (name === "__proto__" && kind === "init") {
            if (propHash.proto) {
              if (refDestructuringErrors) {
                if (refDestructuringErrors.doubleProto < 0) {
                  refDestructuringErrors.doubleProto = key.start;
                }
              } else {
                this.raiseRecoverable(key.start, "Redefinition of __proto__ property");
              }
            }
            propHash.proto = true;
          }
          return;
        }
        name = "$" + name;
        var other = propHash[name];
        if (other) {
          var redefinition;
          if (kind === "init") {
            redefinition = this.strict && other.init || other.get || other.set;
          } else {
            redefinition = other.init || other[kind];
          }
          if (redefinition) {
            this.raiseRecoverable(key.start, "Redefinition of property");
          }
        } else {
          other = propHash[name] = {
            init: false,
            get: false,
            set: false
          };
        }
        other[kind] = true;
      };
      pp$3.parseExpression = function(noIn, refDestructuringErrors) {
        var startPos = this.start, startLoc = this.startLoc;
        var expr = this.parseMaybeAssign(noIn, refDestructuringErrors);
        if (this.type === types.comma) {
          var node = this.startNodeAt(startPos, startLoc);
          node.expressions = [expr];
          while (this.eat(types.comma)) {
            node.expressions.push(this.parseMaybeAssign(noIn, refDestructuringErrors));
          }
          return this.finishNode(node, "SequenceExpression");
        }
        return expr;
      };
      pp$3.parseMaybeAssign = function(noIn, refDestructuringErrors, afterLeftParse) {
        if (this.isContextual("yield")) {
          if (this.inGenerator) {
            return this.parseYield(noIn);
          } else {
            this.exprAllowed = false;
          }
        }
        var ownDestructuringErrors = false, oldParenAssign = -1, oldTrailingComma = -1;
        if (refDestructuringErrors) {
          oldParenAssign = refDestructuringErrors.parenthesizedAssign;
          oldTrailingComma = refDestructuringErrors.trailingComma;
          refDestructuringErrors.parenthesizedAssign = refDestructuringErrors.trailingComma = -1;
        } else {
          refDestructuringErrors = new DestructuringErrors();
          ownDestructuringErrors = true;
        }
        var startPos = this.start, startLoc = this.startLoc;
        if (this.type === types.parenL || this.type === types.name) {
          this.potentialArrowAt = this.start;
        }
        var left = this.parseMaybeConditional(noIn, refDestructuringErrors);
        if (afterLeftParse) {
          left = afterLeftParse.call(this, left, startPos, startLoc);
        }
        if (this.type.isAssign) {
          var node = this.startNodeAt(startPos, startLoc);
          node.operator = this.value;
          node.left = this.type === types.eq ? this.toAssignable(left, false, refDestructuringErrors) : left;
          if (!ownDestructuringErrors) {
            refDestructuringErrors.parenthesizedAssign = refDestructuringErrors.trailingComma = refDestructuringErrors.doubleProto = -1;
          }
          if (refDestructuringErrors.shorthandAssign >= node.left.start) {
            refDestructuringErrors.shorthandAssign = -1;
          }
          this.checkLVal(left);
          this.next();
          node.right = this.parseMaybeAssign(noIn);
          return this.finishNode(node, "AssignmentExpression");
        } else {
          if (ownDestructuringErrors) {
            this.checkExpressionErrors(refDestructuringErrors, true);
          }
        }
        if (oldParenAssign > -1) {
          refDestructuringErrors.parenthesizedAssign = oldParenAssign;
        }
        if (oldTrailingComma > -1) {
          refDestructuringErrors.trailingComma = oldTrailingComma;
        }
        return left;
      };
      pp$3.parseMaybeConditional = function(noIn, refDestructuringErrors) {
        var startPos = this.start, startLoc = this.startLoc;
        var expr = this.parseExprOps(noIn, refDestructuringErrors);
        if (this.checkExpressionErrors(refDestructuringErrors)) {
          return expr;
        }
        if (this.eat(types.question)) {
          var node = this.startNodeAt(startPos, startLoc);
          node.test = expr;
          node.consequent = this.parseMaybeAssign();
          this.expect(types.colon);
          node.alternate = this.parseMaybeAssign(noIn);
          return this.finishNode(node, "ConditionalExpression");
        }
        return expr;
      };
      pp$3.parseExprOps = function(noIn, refDestructuringErrors) {
        var startPos = this.start, startLoc = this.startLoc;
        var expr = this.parseMaybeUnary(refDestructuringErrors, false);
        if (this.checkExpressionErrors(refDestructuringErrors)) {
          return expr;
        }
        return expr.start === startPos && expr.type === "ArrowFunctionExpression" ? expr : this.parseExprOp(expr, startPos, startLoc, -1, noIn);
      };
      pp$3.parseExprOp = function(left, leftStartPos, leftStartLoc, minPrec, noIn) {
        var prec = this.type.binop;
        if (prec != null && (!noIn || this.type !== types._in)) {
          if (prec > minPrec) {
            var logical = this.type === types.logicalOR || this.type === types.logicalAND;
            var coalesce = this.type === types.coalesce;
            if (coalesce) {
              prec = types.logicalAND.binop;
            }
            var op = this.value;
            this.next();
            var startPos = this.start, startLoc = this.startLoc;
            var right = this.parseExprOp(this.parseMaybeUnary(null, false), startPos, startLoc, prec, noIn);
            var node = this.buildBinary(leftStartPos, leftStartLoc, left, right, op, logical || coalesce);
            if (logical && this.type === types.coalesce || coalesce && (this.type === types.logicalOR || this.type === types.logicalAND)) {
              this.raiseRecoverable(this.start, "Logical expressions and coalesce expressions cannot be mixed. Wrap either by parentheses");
            }
            return this.parseExprOp(node, leftStartPos, leftStartLoc, minPrec, noIn);
          }
        }
        return left;
      };
      pp$3.buildBinary = function(startPos, startLoc, left, right, op, logical) {
        var node = this.startNodeAt(startPos, startLoc);
        node.left = left;
        node.operator = op;
        node.right = right;
        return this.finishNode(node, logical ? "LogicalExpression" : "BinaryExpression");
      };
      pp$3.parseMaybeUnary = function(refDestructuringErrors, sawUnary) {
        var startPos = this.start, startLoc = this.startLoc, expr;
        if (this.isContextual("await") && (this.inAsync || !this.inFunction && this.options.allowAwaitOutsideFunction)) {
          expr = this.parseAwait();
          sawUnary = true;
        } else if (this.type.prefix) {
          var node = this.startNode(), update = this.type === types.incDec;
          node.operator = this.value;
          node.prefix = true;
          this.next();
          node.argument = this.parseMaybeUnary(null, true);
          this.checkExpressionErrors(refDestructuringErrors, true);
          if (update) {
            this.checkLVal(node.argument);
          } else if (this.strict && node.operator === "delete" && node.argument.type === "Identifier") {
            this.raiseRecoverable(node.start, "Deleting local variable in strict mode");
          } else {
            sawUnary = true;
          }
          expr = this.finishNode(node, update ? "UpdateExpression" : "UnaryExpression");
        } else {
          expr = this.parseExprSubscripts(refDestructuringErrors);
          if (this.checkExpressionErrors(refDestructuringErrors)) {
            return expr;
          }
          while (this.type.postfix && !this.canInsertSemicolon()) {
            var node$1 = this.startNodeAt(startPos, startLoc);
            node$1.operator = this.value;
            node$1.prefix = false;
            node$1.argument = expr;
            this.checkLVal(expr);
            this.next();
            expr = this.finishNode(node$1, "UpdateExpression");
          }
        }
        if (!sawUnary && this.eat(types.starstar)) {
          return this.buildBinary(startPos, startLoc, expr, this.parseMaybeUnary(null, false), "**", false);
        } else {
          return expr;
        }
      };
      pp$3.parseExprSubscripts = function(refDestructuringErrors) {
        var startPos = this.start, startLoc = this.startLoc;
        var expr = this.parseExprAtom(refDestructuringErrors);
        if (expr.type === "ArrowFunctionExpression" && this.input.slice(this.lastTokStart, this.lastTokEnd) !== ")") {
          return expr;
        }
        var result = this.parseSubscripts(expr, startPos, startLoc);
        if (refDestructuringErrors && result.type === "MemberExpression") {
          if (refDestructuringErrors.parenthesizedAssign >= result.start) {
            refDestructuringErrors.parenthesizedAssign = -1;
          }
          if (refDestructuringErrors.parenthesizedBind >= result.start) {
            refDestructuringErrors.parenthesizedBind = -1;
          }
        }
        return result;
      };
      pp$3.parseSubscripts = function(base, startPos, startLoc, noCalls) {
        var maybeAsyncArrow = this.options.ecmaVersion >= 8 && base.type === "Identifier" && base.name === "async" && this.lastTokEnd === base.end && !this.canInsertSemicolon() && base.end - base.start === 5 && this.potentialArrowAt === base.start;
        var optionalChained = false;
        while (true) {
          var element = this.parseSubscript(base, startPos, startLoc, noCalls, maybeAsyncArrow, optionalChained);
          if (element.optional) {
            optionalChained = true;
          }
          if (element === base || element.type === "ArrowFunctionExpression") {
            if (optionalChained) {
              var chainNode = this.startNodeAt(startPos, startLoc);
              chainNode.expression = element;
              element = this.finishNode(chainNode, "ChainExpression");
            }
            return element;
          }
          base = element;
        }
      };
      pp$3.parseSubscript = function(base, startPos, startLoc, noCalls, maybeAsyncArrow, optionalChained) {
        var optionalSupported = this.options.ecmaVersion >= 11;
        var optional = optionalSupported && this.eat(types.questionDot);
        if (noCalls && optional) {
          this.raise(this.lastTokStart, "Optional chaining cannot appear in the callee of new expressions");
        }
        var computed = this.eat(types.bracketL);
        if (computed || optional && this.type !== types.parenL && this.type !== types.backQuote || this.eat(types.dot)) {
          var node = this.startNodeAt(startPos, startLoc);
          node.object = base;
          node.property = computed ? this.parseExpression() : this.parseIdent(this.options.allowReserved !== "never");
          node.computed = !!computed;
          if (computed) {
            this.expect(types.bracketR);
          }
          if (optionalSupported) {
            node.optional = optional;
          }
          base = this.finishNode(node, "MemberExpression");
        } else if (!noCalls && this.eat(types.parenL)) {
          var refDestructuringErrors = new DestructuringErrors(), oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
          this.yieldPos = 0;
          this.awaitPos = 0;
          this.awaitIdentPos = 0;
          var exprList = this.parseExprList(types.parenR, this.options.ecmaVersion >= 8, false, refDestructuringErrors);
          if (maybeAsyncArrow && !optional && !this.canInsertSemicolon() && this.eat(types.arrow)) {
            this.checkPatternErrors(refDestructuringErrors, false);
            this.checkYieldAwaitInDefaultParams();
            if (this.awaitIdentPos > 0) {
              this.raise(this.awaitIdentPos, "Cannot use 'await' as identifier inside an async function");
            }
            this.yieldPos = oldYieldPos;
            this.awaitPos = oldAwaitPos;
            this.awaitIdentPos = oldAwaitIdentPos;
            return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), exprList, true);
          }
          this.checkExpressionErrors(refDestructuringErrors, true);
          this.yieldPos = oldYieldPos || this.yieldPos;
          this.awaitPos = oldAwaitPos || this.awaitPos;
          this.awaitIdentPos = oldAwaitIdentPos || this.awaitIdentPos;
          var node$1 = this.startNodeAt(startPos, startLoc);
          node$1.callee = base;
          node$1.arguments = exprList;
          if (optionalSupported) {
            node$1.optional = optional;
          }
          base = this.finishNode(node$1, "CallExpression");
        } else if (this.type === types.backQuote) {
          if (optional || optionalChained) {
            this.raise(this.start, "Optional chaining cannot appear in the tag of tagged template expressions");
          }
          var node$2 = this.startNodeAt(startPos, startLoc);
          node$2.tag = base;
          node$2.quasi = this.parseTemplate({ isTagged: true });
          base = this.finishNode(node$2, "TaggedTemplateExpression");
        }
        return base;
      };
      pp$3.parseExprAtom = function(refDestructuringErrors) {
        if (this.type === types.slash) {
          this.readRegexp();
        }
        var node, canBeArrow = this.potentialArrowAt === this.start;
        switch (this.type) {
          case types._super:
            if (!this.allowSuper) {
              this.raise(this.start, "'super' keyword outside a method");
            }
            node = this.startNode();
            this.next();
            if (this.type === types.parenL && !this.allowDirectSuper) {
              this.raise(node.start, "super() call outside constructor of a subclass");
            }
            if (this.type !== types.dot && this.type !== types.bracketL && this.type !== types.parenL) {
              this.unexpected();
            }
            return this.finishNode(node, "Super");
          case types._this:
            node = this.startNode();
            this.next();
            return this.finishNode(node, "ThisExpression");
          case types.name:
            var startPos = this.start, startLoc = this.startLoc, containsEsc = this.containsEsc;
            var id = this.parseIdent(false);
            if (this.options.ecmaVersion >= 8 && !containsEsc && id.name === "async" && !this.canInsertSemicolon() && this.eat(types._function)) {
              return this.parseFunction(this.startNodeAt(startPos, startLoc), 0, false, true);
            }
            if (canBeArrow && !this.canInsertSemicolon()) {
              if (this.eat(types.arrow)) {
                return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), [id], false);
              }
              if (this.options.ecmaVersion >= 8 && id.name === "async" && this.type === types.name && !containsEsc) {
                id = this.parseIdent(false);
                if (this.canInsertSemicolon() || !this.eat(types.arrow)) {
                  this.unexpected();
                }
                return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), [id], true);
              }
            }
            return id;
          case types.regexp:
            var value = this.value;
            node = this.parseLiteral(value.value);
            node.regex = { pattern: value.pattern, flags: value.flags };
            return node;
          case types.num:
          case types.string:
            return this.parseLiteral(this.value);
          case types._null:
          case types._true:
          case types._false:
            node = this.startNode();
            node.value = this.type === types._null ? null : this.type === types._true;
            node.raw = this.type.keyword;
            this.next();
            return this.finishNode(node, "Literal");
          case types.parenL:
            var start = this.start, expr = this.parseParenAndDistinguishExpression(canBeArrow);
            if (refDestructuringErrors) {
              if (refDestructuringErrors.parenthesizedAssign < 0 && !this.isSimpleAssignTarget(expr)) {
                refDestructuringErrors.parenthesizedAssign = start;
              }
              if (refDestructuringErrors.parenthesizedBind < 0) {
                refDestructuringErrors.parenthesizedBind = start;
              }
            }
            return expr;
          case types.bracketL:
            node = this.startNode();
            this.next();
            node.elements = this.parseExprList(types.bracketR, true, true, refDestructuringErrors);
            return this.finishNode(node, "ArrayExpression");
          case types.braceL:
            return this.parseObj(false, refDestructuringErrors);
          case types._function:
            node = this.startNode();
            this.next();
            return this.parseFunction(node, 0);
          case types._class:
            return this.parseClass(this.startNode(), false);
          case types._new:
            return this.parseNew();
          case types.backQuote:
            return this.parseTemplate();
          case types._import:
            if (this.options.ecmaVersion >= 11) {
              return this.parseExprImport();
            } else {
              return this.unexpected();
            }
          default:
            this.unexpected();
        }
      };
      pp$3.parseExprImport = function() {
        var node = this.startNode();
        if (this.containsEsc) {
          this.raiseRecoverable(this.start, "Escape sequence in keyword import");
        }
        var meta = this.parseIdent(true);
        switch (this.type) {
          case types.parenL:
            return this.parseDynamicImport(node);
          case types.dot:
            node.meta = meta;
            return this.parseImportMeta(node);
          default:
            this.unexpected();
        }
      };
      pp$3.parseDynamicImport = function(node) {
        this.next();
        node.source = this.parseMaybeAssign();
        if (!this.eat(types.parenR)) {
          var errorPos = this.start;
          if (this.eat(types.comma) && this.eat(types.parenR)) {
            this.raiseRecoverable(errorPos, "Trailing comma is not allowed in import()");
          } else {
            this.unexpected(errorPos);
          }
        }
        return this.finishNode(node, "ImportExpression");
      };
      pp$3.parseImportMeta = function(node) {
        this.next();
        var containsEsc = this.containsEsc;
        node.property = this.parseIdent(true);
        if (node.property.name !== "meta") {
          this.raiseRecoverable(node.property.start, "The only valid meta property for import is 'import.meta'");
        }
        if (containsEsc) {
          this.raiseRecoverable(node.start, "'import.meta' must not contain escaped characters");
        }
        if (this.options.sourceType !== "module") {
          this.raiseRecoverable(node.start, "Cannot use 'import.meta' outside a module");
        }
        return this.finishNode(node, "MetaProperty");
      };
      pp$3.parseLiteral = function(value) {
        var node = this.startNode();
        node.value = value;
        node.raw = this.input.slice(this.start, this.end);
        if (node.raw.charCodeAt(node.raw.length - 1) === 110) {
          node.bigint = node.raw.slice(0, -1).replace(/_/g, "");
        }
        this.next();
        return this.finishNode(node, "Literal");
      };
      pp$3.parseParenExpression = function() {
        this.expect(types.parenL);
        var val = this.parseExpression();
        this.expect(types.parenR);
        return val;
      };
      pp$3.parseParenAndDistinguishExpression = function(canBeArrow) {
        var startPos = this.start, startLoc = this.startLoc, val, allowTrailingComma = this.options.ecmaVersion >= 8;
        if (this.options.ecmaVersion >= 6) {
          this.next();
          var innerStartPos = this.start, innerStartLoc = this.startLoc;
          var exprList = [], first = true, lastIsComma = false;
          var refDestructuringErrors = new DestructuringErrors(), oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, spreadStart;
          this.yieldPos = 0;
          this.awaitPos = 0;
          while (this.type !== types.parenR) {
            first ? first = false : this.expect(types.comma);
            if (allowTrailingComma && this.afterTrailingComma(types.parenR, true)) {
              lastIsComma = true;
              break;
            } else if (this.type === types.ellipsis) {
              spreadStart = this.start;
              exprList.push(this.parseParenItem(this.parseRestBinding()));
              if (this.type === types.comma) {
                this.raise(this.start, "Comma is not permitted after the rest element");
              }
              break;
            } else {
              exprList.push(this.parseMaybeAssign(false, refDestructuringErrors, this.parseParenItem));
            }
          }
          var innerEndPos = this.start, innerEndLoc = this.startLoc;
          this.expect(types.parenR);
          if (canBeArrow && !this.canInsertSemicolon() && this.eat(types.arrow)) {
            this.checkPatternErrors(refDestructuringErrors, false);
            this.checkYieldAwaitInDefaultParams();
            this.yieldPos = oldYieldPos;
            this.awaitPos = oldAwaitPos;
            return this.parseParenArrowList(startPos, startLoc, exprList);
          }
          if (!exprList.length || lastIsComma) {
            this.unexpected(this.lastTokStart);
          }
          if (spreadStart) {
            this.unexpected(spreadStart);
          }
          this.checkExpressionErrors(refDestructuringErrors, true);
          this.yieldPos = oldYieldPos || this.yieldPos;
          this.awaitPos = oldAwaitPos || this.awaitPos;
          if (exprList.length > 1) {
            val = this.startNodeAt(innerStartPos, innerStartLoc);
            val.expressions = exprList;
            this.finishNodeAt(val, "SequenceExpression", innerEndPos, innerEndLoc);
          } else {
            val = exprList[0];
          }
        } else {
          val = this.parseParenExpression();
        }
        if (this.options.preserveParens) {
          var par = this.startNodeAt(startPos, startLoc);
          par.expression = val;
          return this.finishNode(par, "ParenthesizedExpression");
        } else {
          return val;
        }
      };
      pp$3.parseParenItem = function(item) {
        return item;
      };
      pp$3.parseParenArrowList = function(startPos, startLoc, exprList) {
        return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), exprList);
      };
      var empty$1 = [];
      pp$3.parseNew = function() {
        if (this.containsEsc) {
          this.raiseRecoverable(this.start, "Escape sequence in keyword new");
        }
        var node = this.startNode();
        var meta = this.parseIdent(true);
        if (this.options.ecmaVersion >= 6 && this.eat(types.dot)) {
          node.meta = meta;
          var containsEsc = this.containsEsc;
          node.property = this.parseIdent(true);
          if (node.property.name !== "target") {
            this.raiseRecoverable(node.property.start, "The only valid meta property for new is 'new.target'");
          }
          if (containsEsc) {
            this.raiseRecoverable(node.start, "'new.target' must not contain escaped characters");
          }
          if (!this.inNonArrowFunction()) {
            this.raiseRecoverable(node.start, "'new.target' can only be used in functions");
          }
          return this.finishNode(node, "MetaProperty");
        }
        var startPos = this.start, startLoc = this.startLoc, isImport = this.type === types._import;
        node.callee = this.parseSubscripts(this.parseExprAtom(), startPos, startLoc, true);
        if (isImport && node.callee.type === "ImportExpression") {
          this.raise(startPos, "Cannot use new with import()");
        }
        if (this.eat(types.parenL)) {
          node.arguments = this.parseExprList(types.parenR, this.options.ecmaVersion >= 8, false);
        } else {
          node.arguments = empty$1;
        }
        return this.finishNode(node, "NewExpression");
      };
      pp$3.parseTemplateElement = function(ref2) {
        var isTagged = ref2.isTagged;
        var elem = this.startNode();
        if (this.type === types.invalidTemplate) {
          if (!isTagged) {
            this.raiseRecoverable(this.start, "Bad escape sequence in untagged template literal");
          }
          elem.value = {
            raw: this.value,
            cooked: null
          };
        } else {
          elem.value = {
            raw: this.input.slice(this.start, this.end).replace(/\r\n?/g, "\n"),
            cooked: this.value
          };
        }
        this.next();
        elem.tail = this.type === types.backQuote;
        return this.finishNode(elem, "TemplateElement");
      };
      pp$3.parseTemplate = function(ref2) {
        if (ref2 === void 0)
          ref2 = {};
        var isTagged = ref2.isTagged;
        if (isTagged === void 0)
          isTagged = false;
        var node = this.startNode();
        this.next();
        node.expressions = [];
        var curElt = this.parseTemplateElement({ isTagged });
        node.quasis = [curElt];
        while (!curElt.tail) {
          if (this.type === types.eof) {
            this.raise(this.pos, "Unterminated template literal");
          }
          this.expect(types.dollarBraceL);
          node.expressions.push(this.parseExpression());
          this.expect(types.braceR);
          node.quasis.push(curElt = this.parseTemplateElement({ isTagged }));
        }
        this.next();
        return this.finishNode(node, "TemplateLiteral");
      };
      pp$3.isAsyncProp = function(prop) {
        return !prop.computed && prop.key.type === "Identifier" && prop.key.name === "async" && (this.type === types.name || this.type === types.num || this.type === types.string || this.type === types.bracketL || this.type.keyword || this.options.ecmaVersion >= 9 && this.type === types.star) && !lineBreak.test(this.input.slice(this.lastTokEnd, this.start));
      };
      pp$3.parseObj = function(isPattern, refDestructuringErrors) {
        var node = this.startNode(), first = true, propHash = {};
        node.properties = [];
        this.next();
        while (!this.eat(types.braceR)) {
          if (!first) {
            this.expect(types.comma);
            if (this.options.ecmaVersion >= 5 && this.afterTrailingComma(types.braceR)) {
              break;
            }
          } else {
            first = false;
          }
          var prop = this.parseProperty(isPattern, refDestructuringErrors);
          if (!isPattern) {
            this.checkPropClash(prop, propHash, refDestructuringErrors);
          }
          node.properties.push(prop);
        }
        return this.finishNode(node, isPattern ? "ObjectPattern" : "ObjectExpression");
      };
      pp$3.parseProperty = function(isPattern, refDestructuringErrors) {
        var prop = this.startNode(), isGenerator, isAsync, startPos, startLoc;
        if (this.options.ecmaVersion >= 9 && this.eat(types.ellipsis)) {
          if (isPattern) {
            prop.argument = this.parseIdent(false);
            if (this.type === types.comma) {
              this.raise(this.start, "Comma is not permitted after the rest element");
            }
            return this.finishNode(prop, "RestElement");
          }
          if (this.type === types.parenL && refDestructuringErrors) {
            if (refDestructuringErrors.parenthesizedAssign < 0) {
              refDestructuringErrors.parenthesizedAssign = this.start;
            }
            if (refDestructuringErrors.parenthesizedBind < 0) {
              refDestructuringErrors.parenthesizedBind = this.start;
            }
          }
          prop.argument = this.parseMaybeAssign(false, refDestructuringErrors);
          if (this.type === types.comma && refDestructuringErrors && refDestructuringErrors.trailingComma < 0) {
            refDestructuringErrors.trailingComma = this.start;
          }
          return this.finishNode(prop, "SpreadElement");
        }
        if (this.options.ecmaVersion >= 6) {
          prop.method = false;
          prop.shorthand = false;
          if (isPattern || refDestructuringErrors) {
            startPos = this.start;
            startLoc = this.startLoc;
          }
          if (!isPattern) {
            isGenerator = this.eat(types.star);
          }
        }
        var containsEsc = this.containsEsc;
        this.parsePropertyName(prop);
        if (!isPattern && !containsEsc && this.options.ecmaVersion >= 8 && !isGenerator && this.isAsyncProp(prop)) {
          isAsync = true;
          isGenerator = this.options.ecmaVersion >= 9 && this.eat(types.star);
          this.parsePropertyName(prop, refDestructuringErrors);
        } else {
          isAsync = false;
        }
        this.parsePropertyValue(prop, isPattern, isGenerator, isAsync, startPos, startLoc, refDestructuringErrors, containsEsc);
        return this.finishNode(prop, "Property");
      };
      pp$3.parsePropertyValue = function(prop, isPattern, isGenerator, isAsync, startPos, startLoc, refDestructuringErrors, containsEsc) {
        if ((isGenerator || isAsync) && this.type === types.colon) {
          this.unexpected();
        }
        if (this.eat(types.colon)) {
          prop.value = isPattern ? this.parseMaybeDefault(this.start, this.startLoc) : this.parseMaybeAssign(false, refDestructuringErrors);
          prop.kind = "init";
        } else if (this.options.ecmaVersion >= 6 && this.type === types.parenL) {
          if (isPattern) {
            this.unexpected();
          }
          prop.kind = "init";
          prop.method = true;
          prop.value = this.parseMethod(isGenerator, isAsync);
        } else if (!isPattern && !containsEsc && this.options.ecmaVersion >= 5 && !prop.computed && prop.key.type === "Identifier" && (prop.key.name === "get" || prop.key.name === "set") && (this.type !== types.comma && this.type !== types.braceR && this.type !== types.eq)) {
          if (isGenerator || isAsync) {
            this.unexpected();
          }
          prop.kind = prop.key.name;
          this.parsePropertyName(prop);
          prop.value = this.parseMethod(false);
          var paramCount = prop.kind === "get" ? 0 : 1;
          if (prop.value.params.length !== paramCount) {
            var start = prop.value.start;
            if (prop.kind === "get") {
              this.raiseRecoverable(start, "getter should have no params");
            } else {
              this.raiseRecoverable(start, "setter should have exactly one param");
            }
          } else {
            if (prop.kind === "set" && prop.value.params[0].type === "RestElement") {
              this.raiseRecoverable(prop.value.params[0].start, "Setter cannot use rest params");
            }
          }
        } else if (this.options.ecmaVersion >= 6 && !prop.computed && prop.key.type === "Identifier") {
          if (isGenerator || isAsync) {
            this.unexpected();
          }
          this.checkUnreserved(prop.key);
          if (prop.key.name === "await" && !this.awaitIdentPos) {
            this.awaitIdentPos = startPos;
          }
          prop.kind = "init";
          if (isPattern) {
            prop.value = this.parseMaybeDefault(startPos, startLoc, prop.key);
          } else if (this.type === types.eq && refDestructuringErrors) {
            if (refDestructuringErrors.shorthandAssign < 0) {
              refDestructuringErrors.shorthandAssign = this.start;
            }
            prop.value = this.parseMaybeDefault(startPos, startLoc, prop.key);
          } else {
            prop.value = prop.key;
          }
          prop.shorthand = true;
        } else {
          this.unexpected();
        }
      };
      pp$3.parsePropertyName = function(prop) {
        if (this.options.ecmaVersion >= 6) {
          if (this.eat(types.bracketL)) {
            prop.computed = true;
            prop.key = this.parseMaybeAssign();
            this.expect(types.bracketR);
            return prop.key;
          } else {
            prop.computed = false;
          }
        }
        return prop.key = this.type === types.num || this.type === types.string ? this.parseExprAtom() : this.parseIdent(this.options.allowReserved !== "never");
      };
      pp$3.initFunction = function(node) {
        node.id = null;
        if (this.options.ecmaVersion >= 6) {
          node.generator = node.expression = false;
        }
        if (this.options.ecmaVersion >= 8) {
          node.async = false;
        }
      };
      pp$3.parseMethod = function(isGenerator, isAsync, allowDirectSuper) {
        var node = this.startNode(), oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
        this.initFunction(node);
        if (this.options.ecmaVersion >= 6) {
          node.generator = isGenerator;
        }
        if (this.options.ecmaVersion >= 8) {
          node.async = !!isAsync;
        }
        this.yieldPos = 0;
        this.awaitPos = 0;
        this.awaitIdentPos = 0;
        this.enterScope(functionFlags(isAsync, node.generator) | SCOPE_SUPER | (allowDirectSuper ? SCOPE_DIRECT_SUPER : 0));
        this.expect(types.parenL);
        node.params = this.parseBindingList(types.parenR, false, this.options.ecmaVersion >= 8);
        this.checkYieldAwaitInDefaultParams();
        this.parseFunctionBody(node, false, true);
        this.yieldPos = oldYieldPos;
        this.awaitPos = oldAwaitPos;
        this.awaitIdentPos = oldAwaitIdentPos;
        return this.finishNode(node, "FunctionExpression");
      };
      pp$3.parseArrowExpression = function(node, params, isAsync) {
        var oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
        this.enterScope(functionFlags(isAsync, false) | SCOPE_ARROW);
        this.initFunction(node);
        if (this.options.ecmaVersion >= 8) {
          node.async = !!isAsync;
        }
        this.yieldPos = 0;
        this.awaitPos = 0;
        this.awaitIdentPos = 0;
        node.params = this.toAssignableList(params, true);
        this.parseFunctionBody(node, true, false);
        this.yieldPos = oldYieldPos;
        this.awaitPos = oldAwaitPos;
        this.awaitIdentPos = oldAwaitIdentPos;
        return this.finishNode(node, "ArrowFunctionExpression");
      };
      pp$3.parseFunctionBody = function(node, isArrowFunction, isMethod) {
        var isExpression = isArrowFunction && this.type !== types.braceL;
        var oldStrict = this.strict, useStrict = false;
        if (isExpression) {
          node.body = this.parseMaybeAssign();
          node.expression = true;
          this.checkParams(node, false);
        } else {
          var nonSimple = this.options.ecmaVersion >= 7 && !this.isSimpleParamList(node.params);
          if (!oldStrict || nonSimple) {
            useStrict = this.strictDirective(this.end);
            if (useStrict && nonSimple) {
              this.raiseRecoverable(node.start, "Illegal 'use strict' directive in function with non-simple parameter list");
            }
          }
          var oldLabels = this.labels;
          this.labels = [];
          if (useStrict) {
            this.strict = true;
          }
          this.checkParams(node, !oldStrict && !useStrict && !isArrowFunction && !isMethod && this.isSimpleParamList(node.params));
          if (this.strict && node.id) {
            this.checkLVal(node.id, BIND_OUTSIDE);
          }
          node.body = this.parseBlock(false, void 0, useStrict && !oldStrict);
          node.expression = false;
          this.adaptDirectivePrologue(node.body.body);
          this.labels = oldLabels;
        }
        this.exitScope();
      };
      pp$3.isSimpleParamList = function(params) {
        for (var i = 0, list = params; i < list.length; i += 1) {
          var param = list[i];
          if (param.type !== "Identifier") {
            return false;
          }
        }
        return true;
      };
      pp$3.checkParams = function(node, allowDuplicates) {
        var nameHash = {};
        for (var i = 0, list = node.params; i < list.length; i += 1) {
          var param = list[i];
          this.checkLVal(param, BIND_VAR, allowDuplicates ? null : nameHash);
        }
      };
      pp$3.parseExprList = function(close, allowTrailingComma, allowEmpty, refDestructuringErrors) {
        var elts = [], first = true;
        while (!this.eat(close)) {
          if (!first) {
            this.expect(types.comma);
            if (allowTrailingComma && this.afterTrailingComma(close)) {
              break;
            }
          } else {
            first = false;
          }
          var elt = void 0;
          if (allowEmpty && this.type === types.comma) {
            elt = null;
          } else if (this.type === types.ellipsis) {
            elt = this.parseSpread(refDestructuringErrors);
            if (refDestructuringErrors && this.type === types.comma && refDestructuringErrors.trailingComma < 0) {
              refDestructuringErrors.trailingComma = this.start;
            }
          } else {
            elt = this.parseMaybeAssign(false, refDestructuringErrors);
          }
          elts.push(elt);
        }
        return elts;
      };
      pp$3.checkUnreserved = function(ref2) {
        var start = ref2.start;
        var end = ref2.end;
        var name = ref2.name;
        if (this.inGenerator && name === "yield") {
          this.raiseRecoverable(start, "Cannot use 'yield' as identifier inside a generator");
        }
        if (this.inAsync && name === "await") {
          this.raiseRecoverable(start, "Cannot use 'await' as identifier inside an async function");
        }
        if (this.keywords.test(name)) {
          this.raise(start, "Unexpected keyword '" + name + "'");
        }
        if (this.options.ecmaVersion < 6 && this.input.slice(start, end).indexOf("\\") !== -1) {
          return;
        }
        var re = this.strict ? this.reservedWordsStrict : this.reservedWords;
        if (re.test(name)) {
          if (!this.inAsync && name === "await") {
            this.raiseRecoverable(start, "Cannot use keyword 'await' outside an async function");
          }
          this.raiseRecoverable(start, "The keyword '" + name + "' is reserved");
        }
      };
      pp$3.parseIdent = function(liberal, isBinding) {
        var node = this.startNode();
        if (this.type === types.name) {
          node.name = this.value;
        } else if (this.type.keyword) {
          node.name = this.type.keyword;
          if ((node.name === "class" || node.name === "function") && (this.lastTokEnd !== this.lastTokStart + 1 || this.input.charCodeAt(this.lastTokStart) !== 46)) {
            this.context.pop();
          }
        } else {
          this.unexpected();
        }
        this.next(!!liberal);
        this.finishNode(node, "Identifier");
        if (!liberal) {
          this.checkUnreserved(node);
          if (node.name === "await" && !this.awaitIdentPos) {
            this.awaitIdentPos = node.start;
          }
        }
        return node;
      };
      pp$3.parseYield = function(noIn) {
        if (!this.yieldPos) {
          this.yieldPos = this.start;
        }
        var node = this.startNode();
        this.next();
        if (this.type === types.semi || this.canInsertSemicolon() || this.type !== types.star && !this.type.startsExpr) {
          node.delegate = false;
          node.argument = null;
        } else {
          node.delegate = this.eat(types.star);
          node.argument = this.parseMaybeAssign(noIn);
        }
        return this.finishNode(node, "YieldExpression");
      };
      pp$3.parseAwait = function() {
        if (!this.awaitPos) {
          this.awaitPos = this.start;
        }
        var node = this.startNode();
        this.next();
        node.argument = this.parseMaybeUnary(null, false);
        return this.finishNode(node, "AwaitExpression");
      };
      var pp$4 = Parser.prototype;
      pp$4.raise = function(pos, message) {
        var loc = getLineInfo2(this.input, pos);
        message += " (" + loc.line + ":" + loc.column + ")";
        var err = new SyntaxError(message);
        err.pos = pos;
        err.loc = loc;
        err.raisedAt = this.pos;
        throw err;
      };
      pp$4.raiseRecoverable = pp$4.raise;
      pp$4.curPosition = function() {
        if (this.options.locations) {
          return new Position(this.curLine, this.pos - this.lineStart);
        }
      };
      var pp$5 = Parser.prototype;
      var Scope = function Scope2(flags) {
        this.flags = flags;
        this.var = [];
        this.lexical = [];
        this.functions = [];
      };
      pp$5.enterScope = function(flags) {
        this.scopeStack.push(new Scope(flags));
      };
      pp$5.exitScope = function() {
        this.scopeStack.pop();
      };
      pp$5.treatFunctionsAsVarInScope = function(scope) {
        return scope.flags & SCOPE_FUNCTION || !this.inModule && scope.flags & SCOPE_TOP;
      };
      pp$5.declareName = function(name, bindingType, pos) {
        var redeclared = false;
        if (bindingType === BIND_LEXICAL) {
          var scope = this.currentScope();
          redeclared = scope.lexical.indexOf(name) > -1 || scope.functions.indexOf(name) > -1 || scope.var.indexOf(name) > -1;
          scope.lexical.push(name);
          if (this.inModule && scope.flags & SCOPE_TOP) {
            delete this.undefinedExports[name];
          }
        } else if (bindingType === BIND_SIMPLE_CATCH) {
          var scope$1 = this.currentScope();
          scope$1.lexical.push(name);
        } else if (bindingType === BIND_FUNCTION) {
          var scope$2 = this.currentScope();
          if (this.treatFunctionsAsVar) {
            redeclared = scope$2.lexical.indexOf(name) > -1;
          } else {
            redeclared = scope$2.lexical.indexOf(name) > -1 || scope$2.var.indexOf(name) > -1;
          }
          scope$2.functions.push(name);
        } else {
          for (var i = this.scopeStack.length - 1; i >= 0; --i) {
            var scope$3 = this.scopeStack[i];
            if (scope$3.lexical.indexOf(name) > -1 && !(scope$3.flags & SCOPE_SIMPLE_CATCH && scope$3.lexical[0] === name) || !this.treatFunctionsAsVarInScope(scope$3) && scope$3.functions.indexOf(name) > -1) {
              redeclared = true;
              break;
            }
            scope$3.var.push(name);
            if (this.inModule && scope$3.flags & SCOPE_TOP) {
              delete this.undefinedExports[name];
            }
            if (scope$3.flags & SCOPE_VAR) {
              break;
            }
          }
        }
        if (redeclared) {
          this.raiseRecoverable(pos, "Identifier '" + name + "' has already been declared");
        }
      };
      pp$5.checkLocalExport = function(id) {
        if (this.scopeStack[0].lexical.indexOf(id.name) === -1 && this.scopeStack[0].var.indexOf(id.name) === -1) {
          this.undefinedExports[id.name] = id;
        }
      };
      pp$5.currentScope = function() {
        return this.scopeStack[this.scopeStack.length - 1];
      };
      pp$5.currentVarScope = function() {
        for (var i = this.scopeStack.length - 1; ; i--) {
          var scope = this.scopeStack[i];
          if (scope.flags & SCOPE_VAR) {
            return scope;
          }
        }
      };
      pp$5.currentThisScope = function() {
        for (var i = this.scopeStack.length - 1; ; i--) {
          var scope = this.scopeStack[i];
          if (scope.flags & SCOPE_VAR && !(scope.flags & SCOPE_ARROW)) {
            return scope;
          }
        }
      };
      var Node = function Node2(parser, pos, loc) {
        this.type = "";
        this.start = pos;
        this.end = 0;
        if (parser.options.locations) {
          this.loc = new SourceLocation(parser, loc);
        }
        if (parser.options.directSourceFile) {
          this.sourceFile = parser.options.directSourceFile;
        }
        if (parser.options.ranges) {
          this.range = [pos, 0];
        }
      };
      var pp$6 = Parser.prototype;
      pp$6.startNode = function() {
        return new Node(this, this.start, this.startLoc);
      };
      pp$6.startNodeAt = function(pos, loc) {
        return new Node(this, pos, loc);
      };
      function finishNodeAt(node, type, pos, loc) {
        node.type = type;
        node.end = pos;
        if (this.options.locations) {
          node.loc.end = loc;
        }
        if (this.options.ranges) {
          node.range[1] = pos;
        }
        return node;
      }
      pp$6.finishNode = function(node, type) {
        return finishNodeAt.call(this, node, type, this.lastTokEnd, this.lastTokEndLoc);
      };
      pp$6.finishNodeAt = function(node, type, pos, loc) {
        return finishNodeAt.call(this, node, type, pos, loc);
      };
      var TokContext = function TokContext2(token, isExpr, preserveSpace, override, generator) {
        this.token = token;
        this.isExpr = !!isExpr;
        this.preserveSpace = !!preserveSpace;
        this.override = override;
        this.generator = !!generator;
      };
      var types$1 = {
        b_stat: new TokContext("{", false),
        b_expr: new TokContext("{", true),
        b_tmpl: new TokContext("${", false),
        p_stat: new TokContext("(", false),
        p_expr: new TokContext("(", true),
        q_tmpl: new TokContext("`", true, true, function(p) {
          return p.tryReadTemplateToken();
        }),
        f_stat: new TokContext("function", false),
        f_expr: new TokContext("function", true),
        f_expr_gen: new TokContext("function", true, false, null, true),
        f_gen: new TokContext("function", false, false, null, true)
      };
      var pp$7 = Parser.prototype;
      pp$7.initialContext = function() {
        return [types$1.b_stat];
      };
      pp$7.braceIsBlock = function(prevType) {
        var parent = this.curContext();
        if (parent === types$1.f_expr || parent === types$1.f_stat) {
          return true;
        }
        if (prevType === types.colon && (parent === types$1.b_stat || parent === types$1.b_expr)) {
          return !parent.isExpr;
        }
        if (prevType === types._return || prevType === types.name && this.exprAllowed) {
          return lineBreak.test(this.input.slice(this.lastTokEnd, this.start));
        }
        if (prevType === types._else || prevType === types.semi || prevType === types.eof || prevType === types.parenR || prevType === types.arrow) {
          return true;
        }
        if (prevType === types.braceL) {
          return parent === types$1.b_stat;
        }
        if (prevType === types._var || prevType === types._const || prevType === types.name) {
          return false;
        }
        return !this.exprAllowed;
      };
      pp$7.inGeneratorContext = function() {
        for (var i = this.context.length - 1; i >= 1; i--) {
          var context = this.context[i];
          if (context.token === "function") {
            return context.generator;
          }
        }
        return false;
      };
      pp$7.updateContext = function(prevType) {
        var update, type = this.type;
        if (type.keyword && prevType === types.dot) {
          this.exprAllowed = false;
        } else if (update = type.updateContext) {
          update.call(this, prevType);
        } else {
          this.exprAllowed = type.beforeExpr;
        }
      };
      types.parenR.updateContext = types.braceR.updateContext = function() {
        if (this.context.length === 1) {
          this.exprAllowed = true;
          return;
        }
        var out = this.context.pop();
        if (out === types$1.b_stat && this.curContext().token === "function") {
          out = this.context.pop();
        }
        this.exprAllowed = !out.isExpr;
      };
      types.braceL.updateContext = function(prevType) {
        this.context.push(this.braceIsBlock(prevType) ? types$1.b_stat : types$1.b_expr);
        this.exprAllowed = true;
      };
      types.dollarBraceL.updateContext = function() {
        this.context.push(types$1.b_tmpl);
        this.exprAllowed = true;
      };
      types.parenL.updateContext = function(prevType) {
        var statementParens = prevType === types._if || prevType === types._for || prevType === types._with || prevType === types._while;
        this.context.push(statementParens ? types$1.p_stat : types$1.p_expr);
        this.exprAllowed = true;
      };
      types.incDec.updateContext = function() {
      };
      types._function.updateContext = types._class.updateContext = function(prevType) {
        if (prevType.beforeExpr && prevType !== types.semi && prevType !== types._else && !(prevType === types._return && lineBreak.test(this.input.slice(this.lastTokEnd, this.start))) && !((prevType === types.colon || prevType === types.braceL) && this.curContext() === types$1.b_stat)) {
          this.context.push(types$1.f_expr);
        } else {
          this.context.push(types$1.f_stat);
        }
        this.exprAllowed = false;
      };
      types.backQuote.updateContext = function() {
        if (this.curContext() === types$1.q_tmpl) {
          this.context.pop();
        } else {
          this.context.push(types$1.q_tmpl);
        }
        this.exprAllowed = false;
      };
      types.star.updateContext = function(prevType) {
        if (prevType === types._function) {
          var index = this.context.length - 1;
          if (this.context[index] === types$1.f_expr) {
            this.context[index] = types$1.f_expr_gen;
          } else {
            this.context[index] = types$1.f_gen;
          }
        }
        this.exprAllowed = true;
      };
      types.name.updateContext = function(prevType) {
        var allowed = false;
        if (this.options.ecmaVersion >= 6 && prevType !== types.dot) {
          if (this.value === "of" && !this.exprAllowed || this.value === "yield" && this.inGeneratorContext()) {
            allowed = true;
          }
        }
        this.exprAllowed = allowed;
      };
      var ecma9BinaryProperties = "ASCII ASCII_Hex_Digit AHex Alphabetic Alpha Any Assigned Bidi_Control Bidi_C Bidi_Mirrored Bidi_M Case_Ignorable CI Cased Changes_When_Casefolded CWCF Changes_When_Casemapped CWCM Changes_When_Lowercased CWL Changes_When_NFKC_Casefolded CWKCF Changes_When_Titlecased CWT Changes_When_Uppercased CWU Dash Default_Ignorable_Code_Point DI Deprecated Dep Diacritic Dia Emoji Emoji_Component Emoji_Modifier Emoji_Modifier_Base Emoji_Presentation Extender Ext Grapheme_Base Gr_Base Grapheme_Extend Gr_Ext Hex_Digit Hex IDS_Binary_Operator IDSB IDS_Trinary_Operator IDST ID_Continue IDC ID_Start IDS Ideographic Ideo Join_Control Join_C Logical_Order_Exception LOE Lowercase Lower Math Noncharacter_Code_Point NChar Pattern_Syntax Pat_Syn Pattern_White_Space Pat_WS Quotation_Mark QMark Radical Regional_Indicator RI Sentence_Terminal STerm Soft_Dotted SD Terminal_Punctuation Term Unified_Ideograph UIdeo Uppercase Upper Variation_Selector VS White_Space space XID_Continue XIDC XID_Start XIDS";
      var ecma10BinaryProperties = ecma9BinaryProperties + " Extended_Pictographic";
      var ecma11BinaryProperties = ecma10BinaryProperties;
      var unicodeBinaryProperties = {
        9: ecma9BinaryProperties,
        10: ecma10BinaryProperties,
        11: ecma11BinaryProperties
      };
      var unicodeGeneralCategoryValues = "Cased_Letter LC Close_Punctuation Pe Connector_Punctuation Pc Control Cc cntrl Currency_Symbol Sc Dash_Punctuation Pd Decimal_Number Nd digit Enclosing_Mark Me Final_Punctuation Pf Format Cf Initial_Punctuation Pi Letter L Letter_Number Nl Line_Separator Zl Lowercase_Letter Ll Mark M Combining_Mark Math_Symbol Sm Modifier_Letter Lm Modifier_Symbol Sk Nonspacing_Mark Mn Number N Open_Punctuation Ps Other C Other_Letter Lo Other_Number No Other_Punctuation Po Other_Symbol So Paragraph_Separator Zp Private_Use Co Punctuation P punct Separator Z Space_Separator Zs Spacing_Mark Mc Surrogate Cs Symbol S Titlecase_Letter Lt Unassigned Cn Uppercase_Letter Lu";
      var ecma9ScriptValues = "Adlam Adlm Ahom Ahom Anatolian_Hieroglyphs Hluw Arabic Arab Armenian Armn Avestan Avst Balinese Bali Bamum Bamu Bassa_Vah Bass Batak Batk Bengali Beng Bhaiksuki Bhks Bopomofo Bopo Brahmi Brah Braille Brai Buginese Bugi Buhid Buhd Canadian_Aboriginal Cans Carian Cari Caucasian_Albanian Aghb Chakma Cakm Cham Cham Cherokee Cher Common Zyyy Coptic Copt Qaac Cuneiform Xsux Cypriot Cprt Cyrillic Cyrl Deseret Dsrt Devanagari Deva Duployan Dupl Egyptian_Hieroglyphs Egyp Elbasan Elba Ethiopic Ethi Georgian Geor Glagolitic Glag Gothic Goth Grantha Gran Greek Grek Gujarati Gujr Gurmukhi Guru Han Hani Hangul Hang Hanunoo Hano Hatran Hatr Hebrew Hebr Hiragana Hira Imperial_Aramaic Armi Inherited Zinh Qaai Inscriptional_Pahlavi Phli Inscriptional_Parthian Prti Javanese Java Kaithi Kthi Kannada Knda Katakana Kana Kayah_Li Kali Kharoshthi Khar Khmer Khmr Khojki Khoj Khudawadi Sind Lao Laoo Latin Latn Lepcha Lepc Limbu Limb Linear_A Lina Linear_B Linb Lisu Lisu Lycian Lyci Lydian Lydi Mahajani Mahj Malayalam Mlym Mandaic Mand Manichaean Mani Marchen Marc Masaram_Gondi Gonm Meetei_Mayek Mtei Mende_Kikakui Mend Meroitic_Cursive Merc Meroitic_Hieroglyphs Mero Miao Plrd Modi Modi Mongolian Mong Mro Mroo Multani Mult Myanmar Mymr Nabataean Nbat New_Tai_Lue Talu Newa Newa Nko Nkoo Nushu Nshu Ogham Ogam Ol_Chiki Olck Old_Hungarian Hung Old_Italic Ital Old_North_Arabian Narb Old_Permic Perm Old_Persian Xpeo Old_South_Arabian Sarb Old_Turkic Orkh Oriya Orya Osage Osge Osmanya Osma Pahawh_Hmong Hmng Palmyrene Palm Pau_Cin_Hau Pauc Phags_Pa Phag Phoenician Phnx Psalter_Pahlavi Phlp Rejang Rjng Runic Runr Samaritan Samr Saurashtra Saur Sharada Shrd Shavian Shaw Siddham Sidd SignWriting Sgnw Sinhala Sinh Sora_Sompeng Sora Soyombo Soyo Sundanese Sund Syloti_Nagri Sylo Syriac Syrc Tagalog Tglg Tagbanwa Tagb Tai_Le Tale Tai_Tham Lana Tai_Viet Tavt Takri Takr Tamil Taml Tangut Tang Telugu Telu Thaana Thaa Thai Thai Tibetan Tibt Tifinagh Tfng Tirhuta Tirh Ugaritic Ugar Vai Vaii Warang_Citi Wara Yi Yiii Zanabazar_Square Zanb";
      var ecma10ScriptValues = ecma9ScriptValues + " Dogra Dogr Gunjala_Gondi Gong Hanifi_Rohingya Rohg Makasar Maka Medefaidrin Medf Old_Sogdian Sogo Sogdian Sogd";
      var ecma11ScriptValues = ecma10ScriptValues + " Elymaic Elym Nandinagari Nand Nyiakeng_Puachue_Hmong Hmnp Wancho Wcho";
      var unicodeScriptValues = {
        9: ecma9ScriptValues,
        10: ecma10ScriptValues,
        11: ecma11ScriptValues
      };
      var data = {};
      function buildUnicodeData(ecmaVersion) {
        var d = data[ecmaVersion] = {
          binary: wordsRegexp(unicodeBinaryProperties[ecmaVersion] + " " + unicodeGeneralCategoryValues),
          nonBinary: {
            General_Category: wordsRegexp(unicodeGeneralCategoryValues),
            Script: wordsRegexp(unicodeScriptValues[ecmaVersion])
          }
        };
        d.nonBinary.Script_Extensions = d.nonBinary.Script;
        d.nonBinary.gc = d.nonBinary.General_Category;
        d.nonBinary.sc = d.nonBinary.Script;
        d.nonBinary.scx = d.nonBinary.Script_Extensions;
      }
      buildUnicodeData(9);
      buildUnicodeData(10);
      buildUnicodeData(11);
      var pp$8 = Parser.prototype;
      var RegExpValidationState = function RegExpValidationState2(parser) {
        this.parser = parser;
        this.validFlags = "gim" + (parser.options.ecmaVersion >= 6 ? "uy" : "") + (parser.options.ecmaVersion >= 9 ? "s" : "");
        this.unicodeProperties = data[parser.options.ecmaVersion >= 11 ? 11 : parser.options.ecmaVersion];
        this.source = "";
        this.flags = "";
        this.start = 0;
        this.switchU = false;
        this.switchN = false;
        this.pos = 0;
        this.lastIntValue = 0;
        this.lastStringValue = "";
        this.lastAssertionIsQuantifiable = false;
        this.numCapturingParens = 0;
        this.maxBackReference = 0;
        this.groupNames = [];
        this.backReferenceNames = [];
      };
      RegExpValidationState.prototype.reset = function reset(start, pattern, flags) {
        var unicode = flags.indexOf("u") !== -1;
        this.start = start | 0;
        this.source = pattern + "";
        this.flags = flags;
        this.switchU = unicode && this.parser.options.ecmaVersion >= 6;
        this.switchN = unicode && this.parser.options.ecmaVersion >= 9;
      };
      RegExpValidationState.prototype.raise = function raise(message) {
        this.parser.raiseRecoverable(this.start, "Invalid regular expression: /" + this.source + "/: " + message);
      };
      RegExpValidationState.prototype.at = function at(i, forceU) {
        if (forceU === void 0)
          forceU = false;
        var s = this.source;
        var l = s.length;
        if (i >= l) {
          return -1;
        }
        var c = s.charCodeAt(i);
        if (!(forceU || this.switchU) || c <= 55295 || c >= 57344 || i + 1 >= l) {
          return c;
        }
        var next = s.charCodeAt(i + 1);
        return next >= 56320 && next <= 57343 ? (c << 10) + next - 56613888 : c;
      };
      RegExpValidationState.prototype.nextIndex = function nextIndex(i, forceU) {
        if (forceU === void 0)
          forceU = false;
        var s = this.source;
        var l = s.length;
        if (i >= l) {
          return l;
        }
        var c = s.charCodeAt(i), next;
        if (!(forceU || this.switchU) || c <= 55295 || c >= 57344 || i + 1 >= l || (next = s.charCodeAt(i + 1)) < 56320 || next > 57343) {
          return i + 1;
        }
        return i + 2;
      };
      RegExpValidationState.prototype.current = function current(forceU) {
        if (forceU === void 0)
          forceU = false;
        return this.at(this.pos, forceU);
      };
      RegExpValidationState.prototype.lookahead = function lookahead(forceU) {
        if (forceU === void 0)
          forceU = false;
        return this.at(this.nextIndex(this.pos, forceU), forceU);
      };
      RegExpValidationState.prototype.advance = function advance(forceU) {
        if (forceU === void 0)
          forceU = false;
        this.pos = this.nextIndex(this.pos, forceU);
      };
      RegExpValidationState.prototype.eat = function eat(ch, forceU) {
        if (forceU === void 0)
          forceU = false;
        if (this.current(forceU) === ch) {
          this.advance(forceU);
          return true;
        }
        return false;
      };
      function codePointToString(ch) {
        if (ch <= 65535) {
          return String.fromCharCode(ch);
        }
        ch -= 65536;
        return String.fromCharCode((ch >> 10) + 55296, (ch & 1023) + 56320);
      }
      pp$8.validateRegExpFlags = function(state) {
        var validFlags = state.validFlags;
        var flags = state.flags;
        for (var i = 0; i < flags.length; i++) {
          var flag = flags.charAt(i);
          if (validFlags.indexOf(flag) === -1) {
            this.raise(state.start, "Invalid regular expression flag");
          }
          if (flags.indexOf(flag, i + 1) > -1) {
            this.raise(state.start, "Duplicate regular expression flag");
          }
        }
      };
      pp$8.validateRegExpPattern = function(state) {
        this.regexp_pattern(state);
        if (!state.switchN && this.options.ecmaVersion >= 9 && state.groupNames.length > 0) {
          state.switchN = true;
          this.regexp_pattern(state);
        }
      };
      pp$8.regexp_pattern = function(state) {
        state.pos = 0;
        state.lastIntValue = 0;
        state.lastStringValue = "";
        state.lastAssertionIsQuantifiable = false;
        state.numCapturingParens = 0;
        state.maxBackReference = 0;
        state.groupNames.length = 0;
        state.backReferenceNames.length = 0;
        this.regexp_disjunction(state);
        if (state.pos !== state.source.length) {
          if (state.eat(41)) {
            state.raise("Unmatched ')'");
          }
          if (state.eat(93) || state.eat(125)) {
            state.raise("Lone quantifier brackets");
          }
        }
        if (state.maxBackReference > state.numCapturingParens) {
          state.raise("Invalid escape");
        }
        for (var i = 0, list = state.backReferenceNames; i < list.length; i += 1) {
          var name = list[i];
          if (state.groupNames.indexOf(name) === -1) {
            state.raise("Invalid named capture referenced");
          }
        }
      };
      pp$8.regexp_disjunction = function(state) {
        this.regexp_alternative(state);
        while (state.eat(124)) {
          this.regexp_alternative(state);
        }
        if (this.regexp_eatQuantifier(state, true)) {
          state.raise("Nothing to repeat");
        }
        if (state.eat(123)) {
          state.raise("Lone quantifier brackets");
        }
      };
      pp$8.regexp_alternative = function(state) {
        while (state.pos < state.source.length && this.regexp_eatTerm(state)) {
        }
      };
      pp$8.regexp_eatTerm = function(state) {
        if (this.regexp_eatAssertion(state)) {
          if (state.lastAssertionIsQuantifiable && this.regexp_eatQuantifier(state)) {
            if (state.switchU) {
              state.raise("Invalid quantifier");
            }
          }
          return true;
        }
        if (state.switchU ? this.regexp_eatAtom(state) : this.regexp_eatExtendedAtom(state)) {
          this.regexp_eatQuantifier(state);
          return true;
        }
        return false;
      };
      pp$8.regexp_eatAssertion = function(state) {
        var start = state.pos;
        state.lastAssertionIsQuantifiable = false;
        if (state.eat(94) || state.eat(36)) {
          return true;
        }
        if (state.eat(92)) {
          if (state.eat(66) || state.eat(98)) {
            return true;
          }
          state.pos = start;
        }
        if (state.eat(40) && state.eat(63)) {
          var lookbehind = false;
          if (this.options.ecmaVersion >= 9) {
            lookbehind = state.eat(60);
          }
          if (state.eat(61) || state.eat(33)) {
            this.regexp_disjunction(state);
            if (!state.eat(41)) {
              state.raise("Unterminated group");
            }
            state.lastAssertionIsQuantifiable = !lookbehind;
            return true;
          }
        }
        state.pos = start;
        return false;
      };
      pp$8.regexp_eatQuantifier = function(state, noError) {
        if (noError === void 0)
          noError = false;
        if (this.regexp_eatQuantifierPrefix(state, noError)) {
          state.eat(63);
          return true;
        }
        return false;
      };
      pp$8.regexp_eatQuantifierPrefix = function(state, noError) {
        return state.eat(42) || state.eat(43) || state.eat(63) || this.regexp_eatBracedQuantifier(state, noError);
      };
      pp$8.regexp_eatBracedQuantifier = function(state, noError) {
        var start = state.pos;
        if (state.eat(123)) {
          var min = 0, max = -1;
          if (this.regexp_eatDecimalDigits(state)) {
            min = state.lastIntValue;
            if (state.eat(44) && this.regexp_eatDecimalDigits(state)) {
              max = state.lastIntValue;
            }
            if (state.eat(125)) {
              if (max !== -1 && max < min && !noError) {
                state.raise("numbers out of order in {} quantifier");
              }
              return true;
            }
          }
          if (state.switchU && !noError) {
            state.raise("Incomplete quantifier");
          }
          state.pos = start;
        }
        return false;
      };
      pp$8.regexp_eatAtom = function(state) {
        return this.regexp_eatPatternCharacters(state) || state.eat(46) || this.regexp_eatReverseSolidusAtomEscape(state) || this.regexp_eatCharacterClass(state) || this.regexp_eatUncapturingGroup(state) || this.regexp_eatCapturingGroup(state);
      };
      pp$8.regexp_eatReverseSolidusAtomEscape = function(state) {
        var start = state.pos;
        if (state.eat(92)) {
          if (this.regexp_eatAtomEscape(state)) {
            return true;
          }
          state.pos = start;
        }
        return false;
      };
      pp$8.regexp_eatUncapturingGroup = function(state) {
        var start = state.pos;
        if (state.eat(40)) {
          if (state.eat(63) && state.eat(58)) {
            this.regexp_disjunction(state);
            if (state.eat(41)) {
              return true;
            }
            state.raise("Unterminated group");
          }
          state.pos = start;
        }
        return false;
      };
      pp$8.regexp_eatCapturingGroup = function(state) {
        if (state.eat(40)) {
          if (this.options.ecmaVersion >= 9) {
            this.regexp_groupSpecifier(state);
          } else if (state.current() === 63) {
            state.raise("Invalid group");
          }
          this.regexp_disjunction(state);
          if (state.eat(41)) {
            state.numCapturingParens += 1;
            return true;
          }
          state.raise("Unterminated group");
        }
        return false;
      };
      pp$8.regexp_eatExtendedAtom = function(state) {
        return state.eat(46) || this.regexp_eatReverseSolidusAtomEscape(state) || this.regexp_eatCharacterClass(state) || this.regexp_eatUncapturingGroup(state) || this.regexp_eatCapturingGroup(state) || this.regexp_eatInvalidBracedQuantifier(state) || this.regexp_eatExtendedPatternCharacter(state);
      };
      pp$8.regexp_eatInvalidBracedQuantifier = function(state) {
        if (this.regexp_eatBracedQuantifier(state, true)) {
          state.raise("Nothing to repeat");
        }
        return false;
      };
      pp$8.regexp_eatSyntaxCharacter = function(state) {
        var ch = state.current();
        if (isSyntaxCharacter(ch)) {
          state.lastIntValue = ch;
          state.advance();
          return true;
        }
        return false;
      };
      function isSyntaxCharacter(ch) {
        return ch === 36 || ch >= 40 && ch <= 43 || ch === 46 || ch === 63 || ch >= 91 && ch <= 94 || ch >= 123 && ch <= 125;
      }
      pp$8.regexp_eatPatternCharacters = function(state) {
        var start = state.pos;
        var ch = 0;
        while ((ch = state.current()) !== -1 && !isSyntaxCharacter(ch)) {
          state.advance();
        }
        return state.pos !== start;
      };
      pp$8.regexp_eatExtendedPatternCharacter = function(state) {
        var ch = state.current();
        if (ch !== -1 && ch !== 36 && !(ch >= 40 && ch <= 43) && ch !== 46 && ch !== 63 && ch !== 91 && ch !== 94 && ch !== 124) {
          state.advance();
          return true;
        }
        return false;
      };
      pp$8.regexp_groupSpecifier = function(state) {
        if (state.eat(63)) {
          if (this.regexp_eatGroupName(state)) {
            if (state.groupNames.indexOf(state.lastStringValue) !== -1) {
              state.raise("Duplicate capture group name");
            }
            state.groupNames.push(state.lastStringValue);
            return;
          }
          state.raise("Invalid group");
        }
      };
      pp$8.regexp_eatGroupName = function(state) {
        state.lastStringValue = "";
        if (state.eat(60)) {
          if (this.regexp_eatRegExpIdentifierName(state) && state.eat(62)) {
            return true;
          }
          state.raise("Invalid capture group name");
        }
        return false;
      };
      pp$8.regexp_eatRegExpIdentifierName = function(state) {
        state.lastStringValue = "";
        if (this.regexp_eatRegExpIdentifierStart(state)) {
          state.lastStringValue += codePointToString(state.lastIntValue);
          while (this.regexp_eatRegExpIdentifierPart(state)) {
            state.lastStringValue += codePointToString(state.lastIntValue);
          }
          return true;
        }
        return false;
      };
      pp$8.regexp_eatRegExpIdentifierStart = function(state) {
        var start = state.pos;
        var forceU = this.options.ecmaVersion >= 11;
        var ch = state.current(forceU);
        state.advance(forceU);
        if (ch === 92 && this.regexp_eatRegExpUnicodeEscapeSequence(state, forceU)) {
          ch = state.lastIntValue;
        }
        if (isRegExpIdentifierStart(ch)) {
          state.lastIntValue = ch;
          return true;
        }
        state.pos = start;
        return false;
      };
      function isRegExpIdentifierStart(ch) {
        return isIdentifierStart(ch, true) || ch === 36 || ch === 95;
      }
      pp$8.regexp_eatRegExpIdentifierPart = function(state) {
        var start = state.pos;
        var forceU = this.options.ecmaVersion >= 11;
        var ch = state.current(forceU);
        state.advance(forceU);
        if (ch === 92 && this.regexp_eatRegExpUnicodeEscapeSequence(state, forceU)) {
          ch = state.lastIntValue;
        }
        if (isRegExpIdentifierPart(ch)) {
          state.lastIntValue = ch;
          return true;
        }
        state.pos = start;
        return false;
      };
      function isRegExpIdentifierPart(ch) {
        return isIdentifierChar(ch, true) || ch === 36 || ch === 95 || ch === 8204 || ch === 8205;
      }
      pp$8.regexp_eatAtomEscape = function(state) {
        if (this.regexp_eatBackReference(state) || this.regexp_eatCharacterClassEscape(state) || this.regexp_eatCharacterEscape(state) || state.switchN && this.regexp_eatKGroupName(state)) {
          return true;
        }
        if (state.switchU) {
          if (state.current() === 99) {
            state.raise("Invalid unicode escape");
          }
          state.raise("Invalid escape");
        }
        return false;
      };
      pp$8.regexp_eatBackReference = function(state) {
        var start = state.pos;
        if (this.regexp_eatDecimalEscape(state)) {
          var n2 = state.lastIntValue;
          if (state.switchU) {
            if (n2 > state.maxBackReference) {
              state.maxBackReference = n2;
            }
            return true;
          }
          if (n2 <= state.numCapturingParens) {
            return true;
          }
          state.pos = start;
        }
        return false;
      };
      pp$8.regexp_eatKGroupName = function(state) {
        if (state.eat(107)) {
          if (this.regexp_eatGroupName(state)) {
            state.backReferenceNames.push(state.lastStringValue);
            return true;
          }
          state.raise("Invalid named reference");
        }
        return false;
      };
      pp$8.regexp_eatCharacterEscape = function(state) {
        return this.regexp_eatControlEscape(state) || this.regexp_eatCControlLetter(state) || this.regexp_eatZero(state) || this.regexp_eatHexEscapeSequence(state) || this.regexp_eatRegExpUnicodeEscapeSequence(state, false) || !state.switchU && this.regexp_eatLegacyOctalEscapeSequence(state) || this.regexp_eatIdentityEscape(state);
      };
      pp$8.regexp_eatCControlLetter = function(state) {
        var start = state.pos;
        if (state.eat(99)) {
          if (this.regexp_eatControlLetter(state)) {
            return true;
          }
          state.pos = start;
        }
        return false;
      };
      pp$8.regexp_eatZero = function(state) {
        if (state.current() === 48 && !isDecimalDigit(state.lookahead())) {
          state.lastIntValue = 0;
          state.advance();
          return true;
        }
        return false;
      };
      pp$8.regexp_eatControlEscape = function(state) {
        var ch = state.current();
        if (ch === 116) {
          state.lastIntValue = 9;
          state.advance();
          return true;
        }
        if (ch === 110) {
          state.lastIntValue = 10;
          state.advance();
          return true;
        }
        if (ch === 118) {
          state.lastIntValue = 11;
          state.advance();
          return true;
        }
        if (ch === 102) {
          state.lastIntValue = 12;
          state.advance();
          return true;
        }
        if (ch === 114) {
          state.lastIntValue = 13;
          state.advance();
          return true;
        }
        return false;
      };
      pp$8.regexp_eatControlLetter = function(state) {
        var ch = state.current();
        if (isControlLetter(ch)) {
          state.lastIntValue = ch % 32;
          state.advance();
          return true;
        }
        return false;
      };
      function isControlLetter(ch) {
        return ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122;
      }
      pp$8.regexp_eatRegExpUnicodeEscapeSequence = function(state, forceU) {
        if (forceU === void 0)
          forceU = false;
        var start = state.pos;
        var switchU = forceU || state.switchU;
        if (state.eat(117)) {
          if (this.regexp_eatFixedHexDigits(state, 4)) {
            var lead = state.lastIntValue;
            if (switchU && lead >= 55296 && lead <= 56319) {
              var leadSurrogateEnd = state.pos;
              if (state.eat(92) && state.eat(117) && this.regexp_eatFixedHexDigits(state, 4)) {
                var trail = state.lastIntValue;
                if (trail >= 56320 && trail <= 57343) {
                  state.lastIntValue = (lead - 55296) * 1024 + (trail - 56320) + 65536;
                  return true;
                }
              }
              state.pos = leadSurrogateEnd;
              state.lastIntValue = lead;
            }
            return true;
          }
          if (switchU && state.eat(123) && this.regexp_eatHexDigits(state) && state.eat(125) && isValidUnicode(state.lastIntValue)) {
            return true;
          }
          if (switchU) {
            state.raise("Invalid unicode escape");
          }
          state.pos = start;
        }
        return false;
      };
      function isValidUnicode(ch) {
        return ch >= 0 && ch <= 1114111;
      }
      pp$8.regexp_eatIdentityEscape = function(state) {
        if (state.switchU) {
          if (this.regexp_eatSyntaxCharacter(state)) {
            return true;
          }
          if (state.eat(47)) {
            state.lastIntValue = 47;
            return true;
          }
          return false;
        }
        var ch = state.current();
        if (ch !== 99 && (!state.switchN || ch !== 107)) {
          state.lastIntValue = ch;
          state.advance();
          return true;
        }
        return false;
      };
      pp$8.regexp_eatDecimalEscape = function(state) {
        state.lastIntValue = 0;
        var ch = state.current();
        if (ch >= 49 && ch <= 57) {
          do {
            state.lastIntValue = 10 * state.lastIntValue + (ch - 48);
            state.advance();
          } while ((ch = state.current()) >= 48 && ch <= 57);
          return true;
        }
        return false;
      };
      pp$8.regexp_eatCharacterClassEscape = function(state) {
        var ch = state.current();
        if (isCharacterClassEscape(ch)) {
          state.lastIntValue = -1;
          state.advance();
          return true;
        }
        if (state.switchU && this.options.ecmaVersion >= 9 && (ch === 80 || ch === 112)) {
          state.lastIntValue = -1;
          state.advance();
          if (state.eat(123) && this.regexp_eatUnicodePropertyValueExpression(state) && state.eat(125)) {
            return true;
          }
          state.raise("Invalid property name");
        }
        return false;
      };
      function isCharacterClassEscape(ch) {
        return ch === 100 || ch === 68 || ch === 115 || ch === 83 || ch === 119 || ch === 87;
      }
      pp$8.regexp_eatUnicodePropertyValueExpression = function(state) {
        var start = state.pos;
        if (this.regexp_eatUnicodePropertyName(state) && state.eat(61)) {
          var name = state.lastStringValue;
          if (this.regexp_eatUnicodePropertyValue(state)) {
            var value = state.lastStringValue;
            this.regexp_validateUnicodePropertyNameAndValue(state, name, value);
            return true;
          }
        }
        state.pos = start;
        if (this.regexp_eatLoneUnicodePropertyNameOrValue(state)) {
          var nameOrValue = state.lastStringValue;
          this.regexp_validateUnicodePropertyNameOrValue(state, nameOrValue);
          return true;
        }
        return false;
      };
      pp$8.regexp_validateUnicodePropertyNameAndValue = function(state, name, value) {
        if (!has(state.unicodeProperties.nonBinary, name)) {
          state.raise("Invalid property name");
        }
        if (!state.unicodeProperties.nonBinary[name].test(value)) {
          state.raise("Invalid property value");
        }
      };
      pp$8.regexp_validateUnicodePropertyNameOrValue = function(state, nameOrValue) {
        if (!state.unicodeProperties.binary.test(nameOrValue)) {
          state.raise("Invalid property name");
        }
      };
      pp$8.regexp_eatUnicodePropertyName = function(state) {
        var ch = 0;
        state.lastStringValue = "";
        while (isUnicodePropertyNameCharacter(ch = state.current())) {
          state.lastStringValue += codePointToString(ch);
          state.advance();
        }
        return state.lastStringValue !== "";
      };
      function isUnicodePropertyNameCharacter(ch) {
        return isControlLetter(ch) || ch === 95;
      }
      pp$8.regexp_eatUnicodePropertyValue = function(state) {
        var ch = 0;
        state.lastStringValue = "";
        while (isUnicodePropertyValueCharacter(ch = state.current())) {
          state.lastStringValue += codePointToString(ch);
          state.advance();
        }
        return state.lastStringValue !== "";
      };
      function isUnicodePropertyValueCharacter(ch) {
        return isUnicodePropertyNameCharacter(ch) || isDecimalDigit(ch);
      }
      pp$8.regexp_eatLoneUnicodePropertyNameOrValue = function(state) {
        return this.regexp_eatUnicodePropertyValue(state);
      };
      pp$8.regexp_eatCharacterClass = function(state) {
        if (state.eat(91)) {
          state.eat(94);
          this.regexp_classRanges(state);
          if (state.eat(93)) {
            return true;
          }
          state.raise("Unterminated character class");
        }
        return false;
      };
      pp$8.regexp_classRanges = function(state) {
        while (this.regexp_eatClassAtom(state)) {
          var left = state.lastIntValue;
          if (state.eat(45) && this.regexp_eatClassAtom(state)) {
            var right = state.lastIntValue;
            if (state.switchU && (left === -1 || right === -1)) {
              state.raise("Invalid character class");
            }
            if (left !== -1 && right !== -1 && left > right) {
              state.raise("Range out of order in character class");
            }
          }
        }
      };
      pp$8.regexp_eatClassAtom = function(state) {
        var start = state.pos;
        if (state.eat(92)) {
          if (this.regexp_eatClassEscape(state)) {
            return true;
          }
          if (state.switchU) {
            var ch$1 = state.current();
            if (ch$1 === 99 || isOctalDigit(ch$1)) {
              state.raise("Invalid class escape");
            }
            state.raise("Invalid escape");
          }
          state.pos = start;
        }
        var ch = state.current();
        if (ch !== 93) {
          state.lastIntValue = ch;
          state.advance();
          return true;
        }
        return false;
      };
      pp$8.regexp_eatClassEscape = function(state) {
        var start = state.pos;
        if (state.eat(98)) {
          state.lastIntValue = 8;
          return true;
        }
        if (state.switchU && state.eat(45)) {
          state.lastIntValue = 45;
          return true;
        }
        if (!state.switchU && state.eat(99)) {
          if (this.regexp_eatClassControlLetter(state)) {
            return true;
          }
          state.pos = start;
        }
        return this.regexp_eatCharacterClassEscape(state) || this.regexp_eatCharacterEscape(state);
      };
      pp$8.regexp_eatClassControlLetter = function(state) {
        var ch = state.current();
        if (isDecimalDigit(ch) || ch === 95) {
          state.lastIntValue = ch % 32;
          state.advance();
          return true;
        }
        return false;
      };
      pp$8.regexp_eatHexEscapeSequence = function(state) {
        var start = state.pos;
        if (state.eat(120)) {
          if (this.regexp_eatFixedHexDigits(state, 2)) {
            return true;
          }
          if (state.switchU) {
            state.raise("Invalid escape");
          }
          state.pos = start;
        }
        return false;
      };
      pp$8.regexp_eatDecimalDigits = function(state) {
        var start = state.pos;
        var ch = 0;
        state.lastIntValue = 0;
        while (isDecimalDigit(ch = state.current())) {
          state.lastIntValue = 10 * state.lastIntValue + (ch - 48);
          state.advance();
        }
        return state.pos !== start;
      };
      function isDecimalDigit(ch) {
        return ch >= 48 && ch <= 57;
      }
      pp$8.regexp_eatHexDigits = function(state) {
        var start = state.pos;
        var ch = 0;
        state.lastIntValue = 0;
        while (isHexDigit(ch = state.current())) {
          state.lastIntValue = 16 * state.lastIntValue + hexToInt(ch);
          state.advance();
        }
        return state.pos !== start;
      };
      function isHexDigit(ch) {
        return ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102;
      }
      function hexToInt(ch) {
        if (ch >= 65 && ch <= 70) {
          return 10 + (ch - 65);
        }
        if (ch >= 97 && ch <= 102) {
          return 10 + (ch - 97);
        }
        return ch - 48;
      }
      pp$8.regexp_eatLegacyOctalEscapeSequence = function(state) {
        if (this.regexp_eatOctalDigit(state)) {
          var n1 = state.lastIntValue;
          if (this.regexp_eatOctalDigit(state)) {
            var n2 = state.lastIntValue;
            if (n1 <= 3 && this.regexp_eatOctalDigit(state)) {
              state.lastIntValue = n1 * 64 + n2 * 8 + state.lastIntValue;
            } else {
              state.lastIntValue = n1 * 8 + n2;
            }
          } else {
            state.lastIntValue = n1;
          }
          return true;
        }
        return false;
      };
      pp$8.regexp_eatOctalDigit = function(state) {
        var ch = state.current();
        if (isOctalDigit(ch)) {
          state.lastIntValue = ch - 48;
          state.advance();
          return true;
        }
        state.lastIntValue = 0;
        return false;
      };
      function isOctalDigit(ch) {
        return ch >= 48 && ch <= 55;
      }
      pp$8.regexp_eatFixedHexDigits = function(state, length) {
        var start = state.pos;
        state.lastIntValue = 0;
        for (var i = 0; i < length; ++i) {
          var ch = state.current();
          if (!isHexDigit(ch)) {
            state.pos = start;
            return false;
          }
          state.lastIntValue = 16 * state.lastIntValue + hexToInt(ch);
          state.advance();
        }
        return true;
      };
      var Token = function Token2(p) {
        this.type = p.type;
        this.value = p.value;
        this.start = p.start;
        this.end = p.end;
        if (p.options.locations) {
          this.loc = new SourceLocation(p, p.startLoc, p.endLoc);
        }
        if (p.options.ranges) {
          this.range = [p.start, p.end];
        }
      };
      var pp$9 = Parser.prototype;
      pp$9.next = function(ignoreEscapeSequenceInKeyword) {
        if (!ignoreEscapeSequenceInKeyword && this.type.keyword && this.containsEsc) {
          this.raiseRecoverable(this.start, "Escape sequence in keyword " + this.type.keyword);
        }
        if (this.options.onToken) {
          this.options.onToken(new Token(this));
        }
        this.lastTokEnd = this.end;
        this.lastTokStart = this.start;
        this.lastTokEndLoc = this.endLoc;
        this.lastTokStartLoc = this.startLoc;
        this.nextToken();
      };
      pp$9.getToken = function() {
        this.next();
        return new Token(this);
      };
      if (typeof Symbol !== "undefined") {
        pp$9[Symbol.iterator] = function() {
          var this$1 = this;
          return {
            next: function() {
              var token = this$1.getToken();
              return {
                done: token.type === types.eof,
                value: token
              };
            }
          };
        };
      }
      pp$9.curContext = function() {
        return this.context[this.context.length - 1];
      };
      pp$9.nextToken = function() {
        var curContext = this.curContext();
        if (!curContext || !curContext.preserveSpace) {
          this.skipSpace();
        }
        this.start = this.pos;
        if (this.options.locations) {
          this.startLoc = this.curPosition();
        }
        if (this.pos >= this.input.length) {
          return this.finishToken(types.eof);
        }
        if (curContext.override) {
          return curContext.override(this);
        } else {
          this.readToken(this.fullCharCodeAtPos());
        }
      };
      pp$9.readToken = function(code) {
        if (isIdentifierStart(code, this.options.ecmaVersion >= 6) || code === 92) {
          return this.readWord();
        }
        return this.getTokenFromCode(code);
      };
      pp$9.fullCharCodeAtPos = function() {
        var code = this.input.charCodeAt(this.pos);
        if (code <= 55295 || code >= 57344) {
          return code;
        }
        var next = this.input.charCodeAt(this.pos + 1);
        return (code << 10) + next - 56613888;
      };
      pp$9.skipBlockComment = function() {
        var startLoc = this.options.onComment && this.curPosition();
        var start = this.pos, end = this.input.indexOf("*/", this.pos += 2);
        if (end === -1) {
          this.raise(this.pos - 2, "Unterminated comment");
        }
        this.pos = end + 2;
        if (this.options.locations) {
          lineBreakG.lastIndex = start;
          var match;
          while ((match = lineBreakG.exec(this.input)) && match.index < this.pos) {
            ++this.curLine;
            this.lineStart = match.index + match[0].length;
          }
        }
        if (this.options.onComment) {
          this.options.onComment(
            true,
            this.input.slice(start + 2, end),
            start,
            this.pos,
            startLoc,
            this.curPosition()
          );
        }
      };
      pp$9.skipLineComment = function(startSkip) {
        var start = this.pos;
        var startLoc = this.options.onComment && this.curPosition();
        var ch = this.input.charCodeAt(this.pos += startSkip);
        while (this.pos < this.input.length && !isNewLine(ch)) {
          ch = this.input.charCodeAt(++this.pos);
        }
        if (this.options.onComment) {
          this.options.onComment(
            false,
            this.input.slice(start + startSkip, this.pos),
            start,
            this.pos,
            startLoc,
            this.curPosition()
          );
        }
      };
      pp$9.skipSpace = function() {
        loop:
          while (this.pos < this.input.length) {
            var ch = this.input.charCodeAt(this.pos);
            switch (ch) {
              case 32:
              case 160:
                ++this.pos;
                break;
              case 13:
                if (this.input.charCodeAt(this.pos + 1) === 10) {
                  ++this.pos;
                }
              case 10:
              case 8232:
              case 8233:
                ++this.pos;
                if (this.options.locations) {
                  ++this.curLine;
                  this.lineStart = this.pos;
                }
                break;
              case 47:
                switch (this.input.charCodeAt(this.pos + 1)) {
                  case 42:
                    this.skipBlockComment();
                    break;
                  case 47:
                    this.skipLineComment(2);
                    break;
                  default:
                    break loop;
                }
                break;
              default:
                if (ch > 8 && ch < 14 || ch >= 5760 && nonASCIIwhitespace.test(String.fromCharCode(ch))) {
                  ++this.pos;
                } else {
                  break loop;
                }
            }
          }
      };
      pp$9.finishToken = function(type, val) {
        this.end = this.pos;
        if (this.options.locations) {
          this.endLoc = this.curPosition();
        }
        var prevType = this.type;
        this.type = type;
        this.value = val;
        this.updateContext(prevType);
      };
      pp$9.readToken_dot = function() {
        var next = this.input.charCodeAt(this.pos + 1);
        if (next >= 48 && next <= 57) {
          return this.readNumber(true);
        }
        var next2 = this.input.charCodeAt(this.pos + 2);
        if (this.options.ecmaVersion >= 6 && next === 46 && next2 === 46) {
          this.pos += 3;
          return this.finishToken(types.ellipsis);
        } else {
          ++this.pos;
          return this.finishToken(types.dot);
        }
      };
      pp$9.readToken_slash = function() {
        var next = this.input.charCodeAt(this.pos + 1);
        if (this.exprAllowed) {
          ++this.pos;
          return this.readRegexp();
        }
        if (next === 61) {
          return this.finishOp(types.assign, 2);
        }
        return this.finishOp(types.slash, 1);
      };
      pp$9.readToken_mult_modulo_exp = function(code) {
        var next = this.input.charCodeAt(this.pos + 1);
        var size = 1;
        var tokentype = code === 42 ? types.star : types.modulo;
        if (this.options.ecmaVersion >= 7 && code === 42 && next === 42) {
          ++size;
          tokentype = types.starstar;
          next = this.input.charCodeAt(this.pos + 2);
        }
        if (next === 61) {
          return this.finishOp(types.assign, size + 1);
        }
        return this.finishOp(tokentype, size);
      };
      pp$9.readToken_pipe_amp = function(code) {
        var next = this.input.charCodeAt(this.pos + 1);
        if (next === code) {
          if (this.options.ecmaVersion >= 12) {
            var next2 = this.input.charCodeAt(this.pos + 2);
            if (next2 === 61) {
              return this.finishOp(types.assign, 3);
            }
          }
          return this.finishOp(code === 124 ? types.logicalOR : types.logicalAND, 2);
        }
        if (next === 61) {
          return this.finishOp(types.assign, 2);
        }
        return this.finishOp(code === 124 ? types.bitwiseOR : types.bitwiseAND, 1);
      };
      pp$9.readToken_caret = function() {
        var next = this.input.charCodeAt(this.pos + 1);
        if (next === 61) {
          return this.finishOp(types.assign, 2);
        }
        return this.finishOp(types.bitwiseXOR, 1);
      };
      pp$9.readToken_plus_min = function(code) {
        var next = this.input.charCodeAt(this.pos + 1);
        if (next === code) {
          if (next === 45 && !this.inModule && this.input.charCodeAt(this.pos + 2) === 62 && (this.lastTokEnd === 0 || lineBreak.test(this.input.slice(this.lastTokEnd, this.pos)))) {
            this.skipLineComment(3);
            this.skipSpace();
            return this.nextToken();
          }
          return this.finishOp(types.incDec, 2);
        }
        if (next === 61) {
          return this.finishOp(types.assign, 2);
        }
        return this.finishOp(types.plusMin, 1);
      };
      pp$9.readToken_lt_gt = function(code) {
        var next = this.input.charCodeAt(this.pos + 1);
        var size = 1;
        if (next === code) {
          size = code === 62 && this.input.charCodeAt(this.pos + 2) === 62 ? 3 : 2;
          if (this.input.charCodeAt(this.pos + size) === 61) {
            return this.finishOp(types.assign, size + 1);
          }
          return this.finishOp(types.bitShift, size);
        }
        if (next === 33 && code === 60 && !this.inModule && this.input.charCodeAt(this.pos + 2) === 45 && this.input.charCodeAt(this.pos + 3) === 45) {
          this.skipLineComment(4);
          this.skipSpace();
          return this.nextToken();
        }
        if (next === 61) {
          size = 2;
        }
        return this.finishOp(types.relational, size);
      };
      pp$9.readToken_eq_excl = function(code) {
        var next = this.input.charCodeAt(this.pos + 1);
        if (next === 61) {
          return this.finishOp(types.equality, this.input.charCodeAt(this.pos + 2) === 61 ? 3 : 2);
        }
        if (code === 61 && next === 62 && this.options.ecmaVersion >= 6) {
          this.pos += 2;
          return this.finishToken(types.arrow);
        }
        return this.finishOp(code === 61 ? types.eq : types.prefix, 1);
      };
      pp$9.readToken_question = function() {
        var ecmaVersion = this.options.ecmaVersion;
        if (ecmaVersion >= 11) {
          var next = this.input.charCodeAt(this.pos + 1);
          if (next === 46) {
            var next2 = this.input.charCodeAt(this.pos + 2);
            if (next2 < 48 || next2 > 57) {
              return this.finishOp(types.questionDot, 2);
            }
          }
          if (next === 63) {
            if (ecmaVersion >= 12) {
              var next2$1 = this.input.charCodeAt(this.pos + 2);
              if (next2$1 === 61) {
                return this.finishOp(types.assign, 3);
              }
            }
            return this.finishOp(types.coalesce, 2);
          }
        }
        return this.finishOp(types.question, 1);
      };
      pp$9.getTokenFromCode = function(code) {
        switch (code) {
          case 46:
            return this.readToken_dot();
          case 40:
            ++this.pos;
            return this.finishToken(types.parenL);
          case 41:
            ++this.pos;
            return this.finishToken(types.parenR);
          case 59:
            ++this.pos;
            return this.finishToken(types.semi);
          case 44:
            ++this.pos;
            return this.finishToken(types.comma);
          case 91:
            ++this.pos;
            return this.finishToken(types.bracketL);
          case 93:
            ++this.pos;
            return this.finishToken(types.bracketR);
          case 123:
            ++this.pos;
            return this.finishToken(types.braceL);
          case 125:
            ++this.pos;
            return this.finishToken(types.braceR);
          case 58:
            ++this.pos;
            return this.finishToken(types.colon);
          case 96:
            if (this.options.ecmaVersion < 6) {
              break;
            }
            ++this.pos;
            return this.finishToken(types.backQuote);
          case 48:
            var next = this.input.charCodeAt(this.pos + 1);
            if (next === 120 || next === 88) {
              return this.readRadixNumber(16);
            }
            if (this.options.ecmaVersion >= 6) {
              if (next === 111 || next === 79) {
                return this.readRadixNumber(8);
              }
              if (next === 98 || next === 66) {
                return this.readRadixNumber(2);
              }
            }
          case 49:
          case 50:
          case 51:
          case 52:
          case 53:
          case 54:
          case 55:
          case 56:
          case 57:
            return this.readNumber(false);
          case 34:
          case 39:
            return this.readString(code);
          case 47:
            return this.readToken_slash();
          case 37:
          case 42:
            return this.readToken_mult_modulo_exp(code);
          case 124:
          case 38:
            return this.readToken_pipe_amp(code);
          case 94:
            return this.readToken_caret();
          case 43:
          case 45:
            return this.readToken_plus_min(code);
          case 60:
          case 62:
            return this.readToken_lt_gt(code);
          case 61:
          case 33:
            return this.readToken_eq_excl(code);
          case 63:
            return this.readToken_question();
          case 126:
            return this.finishOp(types.prefix, 1);
        }
        this.raise(this.pos, "Unexpected character '" + codePointToString$1(code) + "'");
      };
      pp$9.finishOp = function(type, size) {
        var str = this.input.slice(this.pos, this.pos + size);
        this.pos += size;
        return this.finishToken(type, str);
      };
      pp$9.readRegexp = function() {
        var escaped, inClass, start = this.pos;
        for (; ; ) {
          if (this.pos >= this.input.length) {
            this.raise(start, "Unterminated regular expression");
          }
          var ch = this.input.charAt(this.pos);
          if (lineBreak.test(ch)) {
            this.raise(start, "Unterminated regular expression");
          }
          if (!escaped) {
            if (ch === "[") {
              inClass = true;
            } else if (ch === "]" && inClass) {
              inClass = false;
            } else if (ch === "/" && !inClass) {
              break;
            }
            escaped = ch === "\\";
          } else {
            escaped = false;
          }
          ++this.pos;
        }
        var pattern = this.input.slice(start, this.pos);
        ++this.pos;
        var flagsStart = this.pos;
        var flags = this.readWord1();
        if (this.containsEsc) {
          this.unexpected(flagsStart);
        }
        var state = this.regexpState || (this.regexpState = new RegExpValidationState(this));
        state.reset(start, pattern, flags);
        this.validateRegExpFlags(state);
        this.validateRegExpPattern(state);
        var value = null;
        try {
          value = new RegExp(pattern, flags);
        } catch (e) {
        }
        return this.finishToken(types.regexp, { pattern, flags, value });
      };
      pp$9.readInt = function(radix, len, maybeLegacyOctalNumericLiteral) {
        var allowSeparators = this.options.ecmaVersion >= 12 && len === void 0;
        var isLegacyOctalNumericLiteral = maybeLegacyOctalNumericLiteral && this.input.charCodeAt(this.pos) === 48;
        var start = this.pos, total = 0, lastCode = 0;
        for (var i = 0, e = len == null ? Infinity : len; i < e; ++i, ++this.pos) {
          var code = this.input.charCodeAt(this.pos), val = void 0;
          if (allowSeparators && code === 95) {
            if (isLegacyOctalNumericLiteral) {
              this.raiseRecoverable(this.pos, "Numeric separator is not allowed in legacy octal numeric literals");
            }
            if (lastCode === 95) {
              this.raiseRecoverable(this.pos, "Numeric separator must be exactly one underscore");
            }
            if (i === 0) {
              this.raiseRecoverable(this.pos, "Numeric separator is not allowed at the first of digits");
            }
            lastCode = code;
            continue;
          }
          if (code >= 97) {
            val = code - 97 + 10;
          } else if (code >= 65) {
            val = code - 65 + 10;
          } else if (code >= 48 && code <= 57) {
            val = code - 48;
          } else {
            val = Infinity;
          }
          if (val >= radix) {
            break;
          }
          lastCode = code;
          total = total * radix + val;
        }
        if (allowSeparators && lastCode === 95) {
          this.raiseRecoverable(this.pos - 1, "Numeric separator is not allowed at the last of digits");
        }
        if (this.pos === start || len != null && this.pos - start !== len) {
          return null;
        }
        return total;
      };
      function stringToNumber(str, isLegacyOctalNumericLiteral) {
        if (isLegacyOctalNumericLiteral) {
          return parseInt(str, 8);
        }
        return parseFloat(str.replace(/_/g, ""));
      }
      function stringToBigInt(str) {
        if (typeof BigInt !== "function") {
          return null;
        }
        return BigInt(str.replace(/_/g, ""));
      }
      pp$9.readRadixNumber = function(radix) {
        var start = this.pos;
        this.pos += 2;
        var val = this.readInt(radix);
        if (val == null) {
          this.raise(this.start + 2, "Expected number in radix " + radix);
        }
        if (this.options.ecmaVersion >= 11 && this.input.charCodeAt(this.pos) === 110) {
          val = stringToBigInt(this.input.slice(start, this.pos));
          ++this.pos;
        } else if (isIdentifierStart(this.fullCharCodeAtPos())) {
          this.raise(this.pos, "Identifier directly after number");
        }
        return this.finishToken(types.num, val);
      };
      pp$9.readNumber = function(startsWithDot) {
        var start = this.pos;
        if (!startsWithDot && this.readInt(10, void 0, true) === null) {
          this.raise(start, "Invalid number");
        }
        var octal = this.pos - start >= 2 && this.input.charCodeAt(start) === 48;
        if (octal && this.strict) {
          this.raise(start, "Invalid number");
        }
        var next = this.input.charCodeAt(this.pos);
        if (!octal && !startsWithDot && this.options.ecmaVersion >= 11 && next === 110) {
          var val$1 = stringToBigInt(this.input.slice(start, this.pos));
          ++this.pos;
          if (isIdentifierStart(this.fullCharCodeAtPos())) {
            this.raise(this.pos, "Identifier directly after number");
          }
          return this.finishToken(types.num, val$1);
        }
        if (octal && /[89]/.test(this.input.slice(start, this.pos))) {
          octal = false;
        }
        if (next === 46 && !octal) {
          ++this.pos;
          this.readInt(10);
          next = this.input.charCodeAt(this.pos);
        }
        if ((next === 69 || next === 101) && !octal) {
          next = this.input.charCodeAt(++this.pos);
          if (next === 43 || next === 45) {
            ++this.pos;
          }
          if (this.readInt(10) === null) {
            this.raise(start, "Invalid number");
          }
        }
        if (isIdentifierStart(this.fullCharCodeAtPos())) {
          this.raise(this.pos, "Identifier directly after number");
        }
        var val = stringToNumber(this.input.slice(start, this.pos), octal);
        return this.finishToken(types.num, val);
      };
      pp$9.readCodePoint = function() {
        var ch = this.input.charCodeAt(this.pos), code;
        if (ch === 123) {
          if (this.options.ecmaVersion < 6) {
            this.unexpected();
          }
          var codePos = ++this.pos;
          code = this.readHexChar(this.input.indexOf("}", this.pos) - this.pos);
          ++this.pos;
          if (code > 1114111) {
            this.invalidStringToken(codePos, "Code point out of bounds");
          }
        } else {
          code = this.readHexChar(4);
        }
        return code;
      };
      function codePointToString$1(code) {
        if (code <= 65535) {
          return String.fromCharCode(code);
        }
        code -= 65536;
        return String.fromCharCode((code >> 10) + 55296, (code & 1023) + 56320);
      }
      pp$9.readString = function(quote2) {
        var out = "", chunkStart = ++this.pos;
        for (; ; ) {
          if (this.pos >= this.input.length) {
            this.raise(this.start, "Unterminated string constant");
          }
          var ch = this.input.charCodeAt(this.pos);
          if (ch === quote2) {
            break;
          }
          if (ch === 92) {
            out += this.input.slice(chunkStart, this.pos);
            out += this.readEscapedChar(false);
            chunkStart = this.pos;
          } else {
            if (isNewLine(ch, this.options.ecmaVersion >= 10)) {
              this.raise(this.start, "Unterminated string constant");
            }
            ++this.pos;
          }
        }
        out += this.input.slice(chunkStart, this.pos++);
        return this.finishToken(types.string, out);
      };
      var INVALID_TEMPLATE_ESCAPE_ERROR = {};
      pp$9.tryReadTemplateToken = function() {
        this.inTemplateElement = true;
        try {
          this.readTmplToken();
        } catch (err) {
          if (err === INVALID_TEMPLATE_ESCAPE_ERROR) {
            this.readInvalidTemplateToken();
          } else {
            throw err;
          }
        }
        this.inTemplateElement = false;
      };
      pp$9.invalidStringToken = function(position, message) {
        if (this.inTemplateElement && this.options.ecmaVersion >= 9) {
          throw INVALID_TEMPLATE_ESCAPE_ERROR;
        } else {
          this.raise(position, message);
        }
      };
      pp$9.readTmplToken = function() {
        var out = "", chunkStart = this.pos;
        for (; ; ) {
          if (this.pos >= this.input.length) {
            this.raise(this.start, "Unterminated template");
          }
          var ch = this.input.charCodeAt(this.pos);
          if (ch === 96 || ch === 36 && this.input.charCodeAt(this.pos + 1) === 123) {
            if (this.pos === this.start && (this.type === types.template || this.type === types.invalidTemplate)) {
              if (ch === 36) {
                this.pos += 2;
                return this.finishToken(types.dollarBraceL);
              } else {
                ++this.pos;
                return this.finishToken(types.backQuote);
              }
            }
            out += this.input.slice(chunkStart, this.pos);
            return this.finishToken(types.template, out);
          }
          if (ch === 92) {
            out += this.input.slice(chunkStart, this.pos);
            out += this.readEscapedChar(true);
            chunkStart = this.pos;
          } else if (isNewLine(ch)) {
            out += this.input.slice(chunkStart, this.pos);
            ++this.pos;
            switch (ch) {
              case 13:
                if (this.input.charCodeAt(this.pos) === 10) {
                  ++this.pos;
                }
              case 10:
                out += "\n";
                break;
              default:
                out += String.fromCharCode(ch);
                break;
            }
            if (this.options.locations) {
              ++this.curLine;
              this.lineStart = this.pos;
            }
            chunkStart = this.pos;
          } else {
            ++this.pos;
          }
        }
      };
      pp$9.readInvalidTemplateToken = function() {
        for (; this.pos < this.input.length; this.pos++) {
          switch (this.input[this.pos]) {
            case "\\":
              ++this.pos;
              break;
            case "$":
              if (this.input[this.pos + 1] !== "{") {
                break;
              }
            case "`":
              return this.finishToken(types.invalidTemplate, this.input.slice(this.start, this.pos));
          }
        }
        this.raise(this.start, "Unterminated template");
      };
      pp$9.readEscapedChar = function(inTemplate) {
        var ch = this.input.charCodeAt(++this.pos);
        ++this.pos;
        switch (ch) {
          case 110:
            return "\n";
          case 114:
            return "\r";
          case 120:
            return String.fromCharCode(this.readHexChar(2));
          case 117:
            return codePointToString$1(this.readCodePoint());
          case 116:
            return "	";
          case 98:
            return "\b";
          case 118:
            return "\v";
          case 102:
            return "\f";
          case 13:
            if (this.input.charCodeAt(this.pos) === 10) {
              ++this.pos;
            }
          case 10:
            if (this.options.locations) {
              this.lineStart = this.pos;
              ++this.curLine;
            }
            return "";
          case 56:
          case 57:
            if (inTemplate) {
              var codePos = this.pos - 1;
              this.invalidStringToken(
                codePos,
                "Invalid escape sequence in template string"
              );
              return null;
            }
          default:
            if (ch >= 48 && ch <= 55) {
              var octalStr = this.input.substr(this.pos - 1, 3).match(/^[0-7]+/)[0];
              var octal = parseInt(octalStr, 8);
              if (octal > 255) {
                octalStr = octalStr.slice(0, -1);
                octal = parseInt(octalStr, 8);
              }
              this.pos += octalStr.length - 1;
              ch = this.input.charCodeAt(this.pos);
              if ((octalStr !== "0" || ch === 56 || ch === 57) && (this.strict || inTemplate)) {
                this.invalidStringToken(
                  this.pos - 1 - octalStr.length,
                  inTemplate ? "Octal literal in template string" : "Octal literal in strict mode"
                );
              }
              return String.fromCharCode(octal);
            }
            if (isNewLine(ch)) {
              return "";
            }
            return String.fromCharCode(ch);
        }
      };
      pp$9.readHexChar = function(len) {
        var codePos = this.pos;
        var n2 = this.readInt(16, len);
        if (n2 === null) {
          this.invalidStringToken(codePos, "Bad character escape sequence");
        }
        return n2;
      };
      pp$9.readWord1 = function() {
        this.containsEsc = false;
        var word = "", first = true, chunkStart = this.pos;
        var astral = this.options.ecmaVersion >= 6;
        while (this.pos < this.input.length) {
          var ch = this.fullCharCodeAtPos();
          if (isIdentifierChar(ch, astral)) {
            this.pos += ch <= 65535 ? 1 : 2;
          } else if (ch === 92) {
            this.containsEsc = true;
            word += this.input.slice(chunkStart, this.pos);
            var escStart = this.pos;
            if (this.input.charCodeAt(++this.pos) !== 117) {
              this.invalidStringToken(this.pos, "Expecting Unicode escape sequence \\uXXXX");
            }
            ++this.pos;
            var esc = this.readCodePoint();
            if (!(first ? isIdentifierStart : isIdentifierChar)(esc, astral)) {
              this.invalidStringToken(escStart, "Invalid Unicode escape");
            }
            word += codePointToString$1(esc);
            chunkStart = this.pos;
          } else {
            break;
          }
          first = false;
        }
        return word + this.input.slice(chunkStart, this.pos);
      };
      pp$9.readWord = function() {
        var word = this.readWord1();
        var type = types.name;
        if (this.keywords.test(word)) {
          type = keywords$1[word];
        }
        return this.finishToken(type, word);
      };
      var version = "7.4.1";
      Parser.acorn = {
        Parser,
        version,
        defaultOptions,
        Position,
        SourceLocation,
        getLineInfo: getLineInfo2,
        Node,
        TokenType,
        tokTypes: types,
        keywordTypes: keywords$1,
        TokContext,
        tokContexts: types$1,
        isIdentifierChar,
        isIdentifierStart,
        Token,
        isNewLine,
        lineBreak,
        lineBreakG,
        nonASCIIwhitespace
      };
      function parse2(input, options) {
        return Parser.parse(input, options);
      }
      function parseExpressionAt(input, pos, options) {
        return Parser.parseExpressionAt(input, pos, options);
      }
      function tokenizer(input, options) {
        return Parser.tokenizer(input, options);
      }
      exports2.Node = Node;
      exports2.Parser = Parser;
      exports2.Position = Position;
      exports2.SourceLocation = SourceLocation;
      exports2.TokContext = TokContext;
      exports2.Token = Token;
      exports2.TokenType = TokenType;
      exports2.defaultOptions = defaultOptions;
      exports2.getLineInfo = getLineInfo2;
      exports2.isIdentifierChar = isIdentifierChar;
      exports2.isIdentifierStart = isIdentifierStart;
      exports2.isNewLine = isNewLine;
      exports2.keywordTypes = keywords$1;
      exports2.lineBreak = lineBreak;
      exports2.lineBreakG = lineBreakG;
      exports2.nonASCIIwhitespace = nonASCIIwhitespace;
      exports2.parse = parse2;
      exports2.parseExpressionAt = parseExpressionAt;
      exports2.tokContexts = types$1;
      exports2.tokTypes = types;
      exports2.tokenizer = tokenizer;
      exports2.version = version;
      Object.defineProperty(exports2, "__esModule", { value: true });
    });
  }
});

// node_modules/sourcemap-codec/dist/sourcemap-codec.umd.js
var require_sourcemap_codec_umd = __commonJS({
  "node_modules/sourcemap-codec/dist/sourcemap-codec.umd.js"(exports, module2) {
    (function(global2, factory) {
      typeof exports === "object" && typeof module2 !== "undefined" ? factory(exports) : typeof define === "function" && define.amd ? define(["exports"], factory) : (global2 = global2 || self, factory(global2.sourcemapCodec = {}));
    })(exports, function(exports2) {
      "use strict";
      var charToInteger = {};
      var chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
      for (var i = 0; i < chars.length; i++) {
        charToInteger[chars.charCodeAt(i)] = i;
      }
      function decode(mappings) {
        var decoded = [];
        var line = [];
        var segment = [
          0,
          0,
          0,
          0,
          0
        ];
        var j = 0;
        for (var i2 = 0, shift = 0, value = 0; i2 < mappings.length; i2++) {
          var c = mappings.charCodeAt(i2);
          if (c === 44) {
            segmentify(line, segment, j);
            j = 0;
          } else if (c === 59) {
            segmentify(line, segment, j);
            j = 0;
            decoded.push(line);
            line = [];
            segment[0] = 0;
          } else {
            var integer = charToInteger[c];
            if (integer === void 0) {
              throw new Error("Invalid character (" + String.fromCharCode(c) + ")");
            }
            var hasContinuationBit = integer & 32;
            integer &= 31;
            value += integer << shift;
            if (hasContinuationBit) {
              shift += 5;
            } else {
              var shouldNegate = value & 1;
              value >>>= 1;
              if (shouldNegate) {
                value = value === 0 ? -2147483648 : -value;
              }
              segment[j] += value;
              j++;
              value = shift = 0;
            }
          }
        }
        segmentify(line, segment, j);
        decoded.push(line);
        return decoded;
      }
      function segmentify(line, segment, j) {
        if (j === 4)
          line.push([segment[0], segment[1], segment[2], segment[3]]);
        else if (j === 5)
          line.push([segment[0], segment[1], segment[2], segment[3], segment[4]]);
        else if (j === 1)
          line.push([segment[0]]);
      }
      function encode2(decoded) {
        var sourceFileIndex = 0;
        var sourceCodeLine = 0;
        var sourceCodeColumn = 0;
        var nameIndex = 0;
        var mappings = "";
        for (var i2 = 0; i2 < decoded.length; i2++) {
          var line = decoded[i2];
          if (i2 > 0)
            mappings += ";";
          if (line.length === 0)
            continue;
          var generatedCodeColumn = 0;
          var lineMappings = [];
          for (var _i = 0, line_1 = line; _i < line_1.length; _i++) {
            var segment = line_1[_i];
            var segmentMappings = encodeInteger(segment[0] - generatedCodeColumn);
            generatedCodeColumn = segment[0];
            if (segment.length > 1) {
              segmentMappings += encodeInteger(segment[1] - sourceFileIndex) + encodeInteger(segment[2] - sourceCodeLine) + encodeInteger(segment[3] - sourceCodeColumn);
              sourceFileIndex = segment[1];
              sourceCodeLine = segment[2];
              sourceCodeColumn = segment[3];
            }
            if (segment.length === 5) {
              segmentMappings += encodeInteger(segment[4] - nameIndex);
              nameIndex = segment[4];
            }
            lineMappings.push(segmentMappings);
          }
          mappings += lineMappings.join(",");
        }
        return mappings;
      }
      function encodeInteger(num) {
        var result = "";
        num = num < 0 ? -num << 1 | 1 : num << 1;
        do {
          var clamped = num & 31;
          num >>>= 5;
          if (num > 0) {
            clamped |= 32;
          }
          result += chars[clamped];
        } while (num > 0);
        return result;
      }
      exports2.decode = decode;
      exports2.encode = encode2;
      Object.defineProperty(exports2, "__esModule", { value: true });
    });
  }
});

// node_modules/prettier/package.json
var require_package = __commonJS({
  "node_modules/prettier/package.json"(exports, module2) {
    module2.exports = {
      name: "prettier",
      version: "2.8.7",
      description: "Prettier is an opinionated code formatter",
      bin: "./bin-prettier.js",
      repository: "prettier/prettier",
      funding: "https://github.com/prettier/prettier?sponsor=1",
      homepage: "https://prettier.io",
      author: "James Long",
      license: "MIT",
      main: "./index.js",
      browser: "./standalone.js",
      unpkg: "./standalone.js",
      engines: {
        node: ">=10.13.0"
      },
      files: [
        "*.js",
        "esm/*.mjs"
      ]
    };
  }
});

// node_modules/prettier/doc.js
var require_doc = __commonJS({
  "node_modules/prettier/doc.js"(exports, module2) {
    (function(factory) {
      if (typeof exports === "object" && typeof module2 === "object") {
        module2.exports = factory();
      } else if (typeof define === "function" && define.amd) {
        define(factory);
      } else {
        var root = typeof globalThis !== "undefined" ? globalThis : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : this || {};
        root.doc = factory();
      }
    })(function() {
      "use strict";
      var __getOwnPropNames2 = Object.getOwnPropertyNames;
      var __commonJS2 = (cb, mod) => function __require() {
        return mod || (0, cb[__getOwnPropNames2(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
      };
      var require_doc_js_umd = __commonJS2({
        "dist/_doc.js.umd.js"(exports2, module3) {
          var __create2 = Object.create;
          var __defProp2 = Object.defineProperty;
          var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
          var __getOwnPropNames22 = Object.getOwnPropertyNames;
          var __getProtoOf2 = Object.getPrototypeOf;
          var __hasOwnProp2 = Object.prototype.hasOwnProperty;
          var __esm = (fn, res) => function __init() {
            return fn && (res = (0, fn[__getOwnPropNames22(fn)[0]])(fn = 0)), res;
          };
          var __commonJS22 = (cb, mod) => function __require() {
            return mod || (0, cb[__getOwnPropNames22(cb)[0]])((mod = {
              exports: {}
            }).exports, mod), mod.exports;
          };
          var __export = (target, all) => {
            for (var name in all)
              __defProp2(target, name, {
                get: all[name],
                enumerable: true
              });
          };
          var __copyProps2 = (to, from, except, desc) => {
            if (from && typeof from === "object" || typeof from === "function") {
              for (let key of __getOwnPropNames22(from))
                if (!__hasOwnProp2.call(to, key) && key !== except)
                  __defProp2(to, key, {
                    get: () => from[key],
                    enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable
                  });
            }
            return to;
          };
          var __toESM2 = (mod, isNodeMode, target) => (target = mod != null ? __create2(__getProtoOf2(mod)) : {}, __copyProps2(isNodeMode || !mod || !mod.__esModule ? __defProp2(target, "default", {
            value: mod,
            enumerable: true
          }) : target, mod));
          var __toCommonJS = (mod) => __copyProps2(__defProp2({}, "__esModule", {
            value: true
          }), mod);
          var init_define_process = __esm({
            "<define:process>"() {
            }
          });
          var require_doc_builders = __commonJS22({
            "src/document/doc-builders.js"(exports22, module22) {
              "use strict";
              init_define_process();
              function concat(parts) {
                if (false) {
                  for (const part of parts) {
                    assertDoc(part);
                  }
                }
                return {
                  type: "concat",
                  parts
                };
              }
              function indent(contents) {
                if (false) {
                  assertDoc(contents);
                }
                return {
                  type: "indent",
                  contents
                };
              }
              function align(widthOrString, contents) {
                if (false) {
                  assertDoc(contents);
                }
                return {
                  type: "align",
                  contents,
                  n: widthOrString
                };
              }
              function group(contents) {
                let opts = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
                if (false) {
                  assertDoc(contents);
                }
                return {
                  type: "group",
                  id: opts.id,
                  contents,
                  break: Boolean(opts.shouldBreak),
                  expandedStates: opts.expandedStates
                };
              }
              function dedentToRoot(contents) {
                return align(Number.NEGATIVE_INFINITY, contents);
              }
              function markAsRoot(contents) {
                return align({
                  type: "root"
                }, contents);
              }
              function dedent(contents) {
                return align(-1, contents);
              }
              function conditionalGroup(states, opts) {
                return group(states[0], Object.assign(Object.assign({}, opts), {}, {
                  expandedStates: states
                }));
              }
              function fill(parts) {
                if (false) {
                  for (const part of parts) {
                    assertDoc(part);
                  }
                }
                return {
                  type: "fill",
                  parts
                };
              }
              function ifBreak(breakContents, flatContents) {
                let opts = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
                if (false) {
                  if (breakContents) {
                    assertDoc(breakContents);
                  }
                  if (flatContents) {
                    assertDoc(flatContents);
                  }
                }
                return {
                  type: "if-break",
                  breakContents,
                  flatContents,
                  groupId: opts.groupId
                };
              }
              function indentIfBreak(contents, opts) {
                return {
                  type: "indent-if-break",
                  contents,
                  groupId: opts.groupId,
                  negate: opts.negate
                };
              }
              function lineSuffix(contents) {
                if (false) {
                  assertDoc(contents);
                }
                return {
                  type: "line-suffix",
                  contents
                };
              }
              var lineSuffixBoundary = {
                type: "line-suffix-boundary"
              };
              var breakParent = {
                type: "break-parent"
              };
              var trim = {
                type: "trim"
              };
              var hardlineWithoutBreakParent = {
                type: "line",
                hard: true
              };
              var literallineWithoutBreakParent = {
                type: "line",
                hard: true,
                literal: true
              };
              var line = {
                type: "line"
              };
              var softline = {
                type: "line",
                soft: true
              };
              var hardline = concat([hardlineWithoutBreakParent, breakParent]);
              var literalline = concat([literallineWithoutBreakParent, breakParent]);
              var cursor = {
                type: "cursor",
                placeholder: Symbol("cursor")
              };
              function join(sep, arr) {
                const res = [];
                for (let i = 0; i < arr.length; i++) {
                  if (i !== 0) {
                    res.push(sep);
                  }
                  res.push(arr[i]);
                }
                return concat(res);
              }
              function addAlignmentToDoc(doc, size, tabWidth) {
                let aligned = doc;
                if (size > 0) {
                  for (let i = 0; i < Math.floor(size / tabWidth); ++i) {
                    aligned = indent(aligned);
                  }
                  aligned = align(size % tabWidth, aligned);
                  aligned = align(Number.NEGATIVE_INFINITY, aligned);
                }
                return aligned;
              }
              function label(label2, contents) {
                return {
                  type: "label",
                  label: label2,
                  contents
                };
              }
              module22.exports = {
                concat,
                join,
                line,
                softline,
                hardline,
                literalline,
                group,
                conditionalGroup,
                fill,
                lineSuffix,
                lineSuffixBoundary,
                cursor,
                breakParent,
                ifBreak,
                trim,
                indent,
                indentIfBreak,
                align,
                addAlignmentToDoc,
                markAsRoot,
                dedentToRoot,
                dedent,
                hardlineWithoutBreakParent,
                literallineWithoutBreakParent,
                label
              };
            }
          });
          var require_end_of_line = __commonJS22({
            "src/common/end-of-line.js"(exports22, module22) {
              "use strict";
              init_define_process();
              function guessEndOfLine(text) {
                const index = text.indexOf("\r");
                if (index >= 0) {
                  return text.charAt(index + 1) === "\n" ? "crlf" : "cr";
                }
                return "lf";
              }
              function convertEndOfLineToChars(value) {
                switch (value) {
                  case "cr":
                    return "\r";
                  case "crlf":
                    return "\r\n";
                  default:
                    return "\n";
                }
              }
              function countEndOfLineChars(text, eol) {
                let regex;
                switch (eol) {
                  case "\n":
                    regex = /\n/g;
                    break;
                  case "\r":
                    regex = /\r/g;
                    break;
                  case "\r\n":
                    regex = /\r\n/g;
                    break;
                  default:
                    throw new Error(`Unexpected "eol" ${JSON.stringify(eol)}.`);
                }
                const endOfLines = text.match(regex);
                return endOfLines ? endOfLines.length : 0;
              }
              function normalizeEndOfLine(text) {
                return text.replace(/\r\n?/g, "\n");
              }
              module22.exports = {
                guessEndOfLine,
                convertEndOfLineToChars,
                countEndOfLineChars,
                normalizeEndOfLine
              };
            }
          });
          var require_get_last = __commonJS22({
            "src/utils/get-last.js"(exports22, module22) {
              "use strict";
              init_define_process();
              var getLast = (arr) => arr[arr.length - 1];
              module22.exports = getLast;
            }
          });
          function ansiRegex() {
            let {
              onlyFirst = false
            } = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
            const pattern = ["[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]+)*|[a-zA-Z\\d]+(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?\\u0007)", "(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PR-TZcf-ntqry=><~]))"].join("|");
            return new RegExp(pattern, onlyFirst ? void 0 : "g");
          }
          var init_ansi_regex = __esm({
            "node_modules/strip-ansi/node_modules/ansi-regex/index.js"() {
              init_define_process();
            }
          });
          function stripAnsi(string) {
            if (typeof string !== "string") {
              throw new TypeError(`Expected a \`string\`, got \`${typeof string}\``);
            }
            return string.replace(ansiRegex(), "");
          }
          var init_strip_ansi = __esm({
            "node_modules/strip-ansi/index.js"() {
              init_define_process();
              init_ansi_regex();
            }
          });
          function isFullwidthCodePoint(codePoint) {
            if (!Number.isInteger(codePoint)) {
              return false;
            }
            return codePoint >= 4352 && (codePoint <= 4447 || codePoint === 9001 || codePoint === 9002 || 11904 <= codePoint && codePoint <= 12871 && codePoint !== 12351 || 12880 <= codePoint && codePoint <= 19903 || 19968 <= codePoint && codePoint <= 42182 || 43360 <= codePoint && codePoint <= 43388 || 44032 <= codePoint && codePoint <= 55203 || 63744 <= codePoint && codePoint <= 64255 || 65040 <= codePoint && codePoint <= 65049 || 65072 <= codePoint && codePoint <= 65131 || 65281 <= codePoint && codePoint <= 65376 || 65504 <= codePoint && codePoint <= 65510 || 110592 <= codePoint && codePoint <= 110593 || 127488 <= codePoint && codePoint <= 127569 || 131072 <= codePoint && codePoint <= 262141);
          }
          var init_is_fullwidth_code_point = __esm({
            "node_modules/is-fullwidth-code-point/index.js"() {
              init_define_process();
            }
          });
          var require_emoji_regex = __commonJS22({
            "node_modules/emoji-regex/index.js"(exports22, module22) {
              "use strict";
              init_define_process();
              module22.exports = function() {
                return /\uD83C\uDFF4\uDB40\uDC67\uDB40\uDC62(?:\uDB40\uDC77\uDB40\uDC6C\uDB40\uDC73|\uDB40\uDC73\uDB40\uDC63\uDB40\uDC74|\uDB40\uDC65\uDB40\uDC6E\uDB40\uDC67)\uDB40\uDC7F|(?:\uD83E\uDDD1\uD83C\uDFFF\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D(?:\uD83D[\uDC68\uDC69]))(?:\uD83C[\uDFFB-\uDFFE])|(?:\uD83E\uDDD1\uD83C\uDFFE\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D(?:\uD83D[\uDC68\uDC69]))(?:\uD83C[\uDFFB-\uDFFD\uDFFF])|(?:\uD83E\uDDD1\uD83C\uDFFD\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D(?:\uD83D[\uDC68\uDC69]))(?:\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])|(?:\uD83E\uDDD1\uD83C\uDFFC\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D(?:\uD83D[\uDC68\uDC69]))(?:\uD83C[\uDFFB\uDFFD-\uDFFF])|(?:\uD83E\uDDD1\uD83C\uDFFB\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D(?:\uD83D[\uDC68\uDC69]))(?:\uD83C[\uDFFC-\uDFFF])|\uD83D\uDC68(?:\uD83C\uDFFB(?:\u200D(?:\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFF])|\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFF]))|\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFC-\uDFFF])|[\u2695\u2696\u2708]\uFE0F|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD]))?|(?:\uD83C[\uDFFC-\uDFFF])\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFF])|\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFF]))|\u200D(?:\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83D\uDC68|(?:\uD83D[\uDC68\uDC69])\u200D(?:\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67]))|\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFF\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFE])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFE\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFD\uDFFF])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFD\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFC\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB\uDFFD-\uDFFF])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|(?:\uD83C\uDFFF\u200D[\u2695\u2696\u2708]|\uD83C\uDFFE\u200D[\u2695\u2696\u2708]|\uD83C\uDFFD\u200D[\u2695\u2696\u2708]|\uD83C\uDFFC\u200D[\u2695\u2696\u2708]|\u200D[\u2695\u2696\u2708])\uFE0F|\u200D(?:(?:\uD83D[\uDC68\uDC69])\u200D(?:\uD83D[\uDC66\uDC67])|\uD83D[\uDC66\uDC67])|\uD83C\uDFFF|\uD83C\uDFFE|\uD83C\uDFFD|\uD83C\uDFFC)?|(?:\uD83D\uDC69(?:\uD83C\uDFFB\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D(?:\uD83D[\uDC68\uDC69])|\uD83D[\uDC68\uDC69])|(?:\uD83C[\uDFFC-\uDFFF])\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D(?:\uD83D[\uDC68\uDC69])|\uD83D[\uDC68\uDC69]))|\uD83E\uDDD1(?:\uD83C[\uDFFB-\uDFFF])\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1)(?:\uD83C[\uDFFB-\uDFFF])|\uD83D\uDC69\u200D\uD83D\uDC69\u200D(?:\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67]))|\uD83D\uDC69(?:\u200D(?:\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D(?:\uD83D[\uDC68\uDC69])|\uD83D[\uDC68\uDC69])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFF\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFE\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFD\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFC\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFB\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD]))|\uD83E\uDDD1(?:\u200D(?:\uD83E\uDD1D\u200D\uD83E\uDDD1|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFF\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFE\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFD\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFC\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFB\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD]))|\uD83D\uDC69\u200D\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC69\u200D\uD83D\uDC69\u200D(?:\uD83D[\uDC66\uDC67])|\uD83D\uDC69\u200D\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67])|(?:\uD83D\uDC41\uFE0F\u200D\uD83D\uDDE8|\uD83E\uDDD1(?:\uD83C\uDFFF\u200D[\u2695\u2696\u2708]|\uD83C\uDFFE\u200D[\u2695\u2696\u2708]|\uD83C\uDFFD\u200D[\u2695\u2696\u2708]|\uD83C\uDFFC\u200D[\u2695\u2696\u2708]|\uD83C\uDFFB\u200D[\u2695\u2696\u2708]|\u200D[\u2695\u2696\u2708])|\uD83D\uDC69(?:\uD83C\uDFFF\u200D[\u2695\u2696\u2708]|\uD83C\uDFFE\u200D[\u2695\u2696\u2708]|\uD83C\uDFFD\u200D[\u2695\u2696\u2708]|\uD83C\uDFFC\u200D[\u2695\u2696\u2708]|\uD83C\uDFFB\u200D[\u2695\u2696\u2708]|\u200D[\u2695\u2696\u2708])|\uD83D\uDE36\u200D\uD83C\uDF2B|\uD83C\uDFF3\uFE0F\u200D\u26A7|\uD83D\uDC3B\u200D\u2744|(?:(?:\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC70\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD35\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD4\uDDD6-\uDDDD])(?:\uD83C[\uDFFB-\uDFFF])|\uD83D\uDC6F|\uD83E[\uDD3C\uDDDE\uDDDF])\u200D[\u2640\u2642]|(?:\u26F9|\uD83C[\uDFCB\uDFCC]|\uD83D\uDD75)(?:\uFE0F|\uD83C[\uDFFB-\uDFFF])\u200D[\u2640\u2642]|\uD83C\uDFF4\u200D\u2620|(?:\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC70\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD35\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD4\uDDD6-\uDDDD])\u200D[\u2640\u2642]|[\xA9\xAE\u203C\u2049\u2122\u2139\u2194-\u2199\u21A9\u21AA\u2328\u23CF\u23ED-\u23EF\u23F1\u23F2\u23F8-\u23FA\u24C2\u25AA\u25AB\u25B6\u25C0\u25FB\u25FC\u2600-\u2604\u260E\u2611\u2618\u2620\u2622\u2623\u2626\u262A\u262E\u262F\u2638-\u263A\u2640\u2642\u265F\u2660\u2663\u2665\u2666\u2668\u267B\u267E\u2692\u2694-\u2697\u2699\u269B\u269C\u26A0\u26A7\u26B0\u26B1\u26C8\u26CF\u26D1\u26D3\u26E9\u26F0\u26F1\u26F4\u26F7\u26F8\u2702\u2708\u2709\u270F\u2712\u2714\u2716\u271D\u2721\u2733\u2734\u2744\u2747\u2763\u27A1\u2934\u2935\u2B05-\u2B07\u3030\u303D\u3297\u3299]|\uD83C[\uDD70\uDD71\uDD7E\uDD7F\uDE02\uDE37\uDF21\uDF24-\uDF2C\uDF36\uDF7D\uDF96\uDF97\uDF99-\uDF9B\uDF9E\uDF9F\uDFCD\uDFCE\uDFD4-\uDFDF\uDFF5\uDFF7]|\uD83D[\uDC3F\uDCFD\uDD49\uDD4A\uDD6F\uDD70\uDD73\uDD76-\uDD79\uDD87\uDD8A-\uDD8D\uDDA5\uDDA8\uDDB1\uDDB2\uDDBC\uDDC2-\uDDC4\uDDD1-\uDDD3\uDDDC-\uDDDE\uDDE1\uDDE3\uDDE8\uDDEF\uDDF3\uDDFA\uDECB\uDECD-\uDECF\uDEE0-\uDEE5\uDEE9\uDEF0\uDEF3])\uFE0F|\uD83C\uDFF3\uFE0F\u200D\uD83C\uDF08|\uD83D\uDC69\u200D\uD83D\uDC67|\uD83D\uDC69\u200D\uD83D\uDC66|\uD83D\uDE35\u200D\uD83D\uDCAB|\uD83D\uDE2E\u200D\uD83D\uDCA8|\uD83D\uDC15\u200D\uD83E\uDDBA|\uD83E\uDDD1(?:\uD83C\uDFFF|\uD83C\uDFFE|\uD83C\uDFFD|\uD83C\uDFFC|\uD83C\uDFFB)?|\uD83D\uDC69(?:\uD83C\uDFFF|\uD83C\uDFFE|\uD83C\uDFFD|\uD83C\uDFFC|\uD83C\uDFFB)?|\uD83C\uDDFD\uD83C\uDDF0|\uD83C\uDDF6\uD83C\uDDE6|\uD83C\uDDF4\uD83C\uDDF2|\uD83D\uDC08\u200D\u2B1B|\u2764\uFE0F\u200D(?:\uD83D\uDD25|\uD83E\uDE79)|\uD83D\uDC41\uFE0F|\uD83C\uDFF3\uFE0F|\uD83C\uDDFF(?:\uD83C[\uDDE6\uDDF2\uDDFC])|\uD83C\uDDFE(?:\uD83C[\uDDEA\uDDF9])|\uD83C\uDDFC(?:\uD83C[\uDDEB\uDDF8])|\uD83C\uDDFB(?:\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDEE\uDDF3\uDDFA])|\uD83C\uDDFA(?:\uD83C[\uDDE6\uDDEC\uDDF2\uDDF3\uDDF8\uDDFE\uDDFF])|\uD83C\uDDF9(?:\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDED\uDDEF-\uDDF4\uDDF7\uDDF9\uDDFB\uDDFC\uDDFF])|\uD83C\uDDF8(?:\uD83C[\uDDE6-\uDDEA\uDDEC-\uDDF4\uDDF7-\uDDF9\uDDFB\uDDFD-\uDDFF])|\uD83C\uDDF7(?:\uD83C[\uDDEA\uDDF4\uDDF8\uDDFA\uDDFC])|\uD83C\uDDF5(?:\uD83C[\uDDE6\uDDEA-\uDDED\uDDF0-\uDDF3\uDDF7-\uDDF9\uDDFC\uDDFE])|\uD83C\uDDF3(?:\uD83C[\uDDE6\uDDE8\uDDEA-\uDDEC\uDDEE\uDDF1\uDDF4\uDDF5\uDDF7\uDDFA\uDDFF])|\uD83C\uDDF2(?:\uD83C[\uDDE6\uDDE8-\uDDED\uDDF0-\uDDFF])|\uD83C\uDDF1(?:\uD83C[\uDDE6-\uDDE8\uDDEE\uDDF0\uDDF7-\uDDFB\uDDFE])|\uD83C\uDDF0(?:\uD83C[\uDDEA\uDDEC-\uDDEE\uDDF2\uDDF3\uDDF5\uDDF7\uDDFC\uDDFE\uDDFF])|\uD83C\uDDEF(?:\uD83C[\uDDEA\uDDF2\uDDF4\uDDF5])|\uD83C\uDDEE(?:\uD83C[\uDDE8-\uDDEA\uDDF1-\uDDF4\uDDF6-\uDDF9])|\uD83C\uDDED(?:\uD83C[\uDDF0\uDDF2\uDDF3\uDDF7\uDDF9\uDDFA])|\uD83C\uDDEC(?:\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEE\uDDF1-\uDDF3\uDDF5-\uDDFA\uDDFC\uDDFE])|\uD83C\uDDEB(?:\uD83C[\uDDEE-\uDDF0\uDDF2\uDDF4\uDDF7])|\uD83C\uDDEA(?:\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDED\uDDF7-\uDDFA])|\uD83C\uDDE9(?:\uD83C[\uDDEA\uDDEC\uDDEF\uDDF0\uDDF2\uDDF4\uDDFF])|\uD83C\uDDE8(?:\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDEE\uDDF0-\uDDF5\uDDF7\uDDFA-\uDDFF])|\uD83C\uDDE7(?:\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEF\uDDF1-\uDDF4\uDDF6-\uDDF9\uDDFB\uDDFC\uDDFE\uDDFF])|\uD83C\uDDE6(?:\uD83C[\uDDE8-\uDDEC\uDDEE\uDDF1\uDDF2\uDDF4\uDDF6-\uDDFA\uDDFC\uDDFD\uDDFF])|[#\*0-9]\uFE0F\u20E3|\u2764\uFE0F|(?:\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC70\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD35\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD4\uDDD6-\uDDDD])(?:\uD83C[\uDFFB-\uDFFF])|(?:\u26F9|\uD83C[\uDFCB\uDFCC]|\uD83D\uDD75)(?:\uFE0F|\uD83C[\uDFFB-\uDFFF])|\uD83C\uDFF4|(?:[\u270A\u270B]|\uD83C[\uDF85\uDFC2\uDFC7]|\uD83D[\uDC42\uDC43\uDC46-\uDC50\uDC66\uDC67\uDC6B-\uDC6D\uDC72\uDC74-\uDC76\uDC78\uDC7C\uDC83\uDC85\uDC8F\uDC91\uDCAA\uDD7A\uDD95\uDD96\uDE4C\uDE4F\uDEC0\uDECC]|\uD83E[\uDD0C\uDD0F\uDD18-\uDD1C\uDD1E\uDD1F\uDD30-\uDD34\uDD36\uDD77\uDDB5\uDDB6\uDDBB\uDDD2\uDDD3\uDDD5])(?:\uD83C[\uDFFB-\uDFFF])|(?:[\u261D\u270C\u270D]|\uD83D[\uDD74\uDD90])(?:\uFE0F|\uD83C[\uDFFB-\uDFFF])|[\u270A\u270B]|\uD83C[\uDF85\uDFC2\uDFC7]|\uD83D[\uDC08\uDC15\uDC3B\uDC42\uDC43\uDC46-\uDC50\uDC66\uDC67\uDC6B-\uDC6D\uDC72\uDC74-\uDC76\uDC78\uDC7C\uDC83\uDC85\uDC8F\uDC91\uDCAA\uDD7A\uDD95\uDD96\uDE2E\uDE35\uDE36\uDE4C\uDE4F\uDEC0\uDECC]|\uD83E[\uDD0C\uDD0F\uDD18-\uDD1C\uDD1E\uDD1F\uDD30-\uDD34\uDD36\uDD77\uDDB5\uDDB6\uDDBB\uDDD2\uDDD3\uDDD5]|\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC70\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD35\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD4\uDDD6-\uDDDD]|\uD83D\uDC6F|\uD83E[\uDD3C\uDDDE\uDDDF]|[\u231A\u231B\u23E9-\u23EC\u23F0\u23F3\u25FD\u25FE\u2614\u2615\u2648-\u2653\u267F\u2693\u26A1\u26AA\u26AB\u26BD\u26BE\u26C4\u26C5\u26CE\u26D4\u26EA\u26F2\u26F3\u26F5\u26FA\u26FD\u2705\u2728\u274C\u274E\u2753-\u2755\u2757\u2795-\u2797\u27B0\u27BF\u2B1B\u2B1C\u2B50\u2B55]|\uD83C[\uDC04\uDCCF\uDD8E\uDD91-\uDD9A\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF7C\uDF7E-\uDF84\uDF86-\uDF93\uDFA0-\uDFC1\uDFC5\uDFC6\uDFC8\uDFC9\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF8-\uDFFF]|\uD83D[\uDC00-\uDC07\uDC09-\uDC14\uDC16-\uDC3A\uDC3C-\uDC3E\uDC40\uDC44\uDC45\uDC51-\uDC65\uDC6A\uDC79-\uDC7B\uDC7D-\uDC80\uDC84\uDC88-\uDC8E\uDC90\uDC92-\uDCA9\uDCAB-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDDA4\uDDFB-\uDE2D\uDE2F-\uDE34\uDE37-\uDE44\uDE48-\uDE4A\uDE80-\uDEA2\uDEA4-\uDEB3\uDEB7-\uDEBF\uDEC1-\uDEC5\uDED0-\uDED2\uDED5-\uDED7\uDEEB\uDEEC\uDEF4-\uDEFC\uDFE0-\uDFEB]|\uD83E[\uDD0D\uDD0E\uDD10-\uDD17\uDD1D\uDD20-\uDD25\uDD27-\uDD2F\uDD3A\uDD3F-\uDD45\uDD47-\uDD76\uDD78\uDD7A-\uDDB4\uDDB7\uDDBA\uDDBC-\uDDCB\uDDD0\uDDE0-\uDDFF\uDE70-\uDE74\uDE78-\uDE7A\uDE80-\uDE86\uDE90-\uDEA8\uDEB0-\uDEB6\uDEC0-\uDEC2\uDED0-\uDED6]|(?:[\u231A\u231B\u23E9-\u23EC\u23F0\u23F3\u25FD\u25FE\u2614\u2615\u2648-\u2653\u267F\u2693\u26A1\u26AA\u26AB\u26BD\u26BE\u26C4\u26C5\u26CE\u26D4\u26EA\u26F2\u26F3\u26F5\u26FA\u26FD\u2705\u270A\u270B\u2728\u274C\u274E\u2753-\u2755\u2757\u2795-\u2797\u27B0\u27BF\u2B1B\u2B1C\u2B50\u2B55]|\uD83C[\uDC04\uDCCF\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF7C\uDF7E-\uDF93\uDFA0-\uDFCA\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF4\uDFF8-\uDFFF]|\uD83D[\uDC00-\uDC3E\uDC40\uDC42-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDD7A\uDD95\uDD96\uDDA4\uDDFB-\uDE4F\uDE80-\uDEC5\uDECC\uDED0-\uDED2\uDED5-\uDED7\uDEEB\uDEEC\uDEF4-\uDEFC\uDFE0-\uDFEB]|\uD83E[\uDD0C-\uDD3A\uDD3C-\uDD45\uDD47-\uDD78\uDD7A-\uDDCB\uDDCD-\uDDFF\uDE70-\uDE74\uDE78-\uDE7A\uDE80-\uDE86\uDE90-\uDEA8\uDEB0-\uDEB6\uDEC0-\uDEC2\uDED0-\uDED6])|(?:[#\*0-9\xA9\xAE\u203C\u2049\u2122\u2139\u2194-\u2199\u21A9\u21AA\u231A\u231B\u2328\u23CF\u23E9-\u23F3\u23F8-\u23FA\u24C2\u25AA\u25AB\u25B6\u25C0\u25FB-\u25FE\u2600-\u2604\u260E\u2611\u2614\u2615\u2618\u261D\u2620\u2622\u2623\u2626\u262A\u262E\u262F\u2638-\u263A\u2640\u2642\u2648-\u2653\u265F\u2660\u2663\u2665\u2666\u2668\u267B\u267E\u267F\u2692-\u2697\u2699\u269B\u269C\u26A0\u26A1\u26A7\u26AA\u26AB\u26B0\u26B1\u26BD\u26BE\u26C4\u26C5\u26C8\u26CE\u26CF\u26D1\u26D3\u26D4\u26E9\u26EA\u26F0-\u26F5\u26F7-\u26FA\u26FD\u2702\u2705\u2708-\u270D\u270F\u2712\u2714\u2716\u271D\u2721\u2728\u2733\u2734\u2744\u2747\u274C\u274E\u2753-\u2755\u2757\u2763\u2764\u2795-\u2797\u27A1\u27B0\u27BF\u2934\u2935\u2B05-\u2B07\u2B1B\u2B1C\u2B50\u2B55\u3030\u303D\u3297\u3299]|\uD83C[\uDC04\uDCCF\uDD70\uDD71\uDD7E\uDD7F\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE02\uDE1A\uDE2F\uDE32-\uDE3A\uDE50\uDE51\uDF00-\uDF21\uDF24-\uDF93\uDF96\uDF97\uDF99-\uDF9B\uDF9E-\uDFF0\uDFF3-\uDFF5\uDFF7-\uDFFF]|\uD83D[\uDC00-\uDCFD\uDCFF-\uDD3D\uDD49-\uDD4E\uDD50-\uDD67\uDD6F\uDD70\uDD73-\uDD7A\uDD87\uDD8A-\uDD8D\uDD90\uDD95\uDD96\uDDA4\uDDA5\uDDA8\uDDB1\uDDB2\uDDBC\uDDC2-\uDDC4\uDDD1-\uDDD3\uDDDC-\uDDDE\uDDE1\uDDE3\uDDE8\uDDEF\uDDF3\uDDFA-\uDE4F\uDE80-\uDEC5\uDECB-\uDED2\uDED5-\uDED7\uDEE0-\uDEE5\uDEE9\uDEEB\uDEEC\uDEF0\uDEF3-\uDEFC\uDFE0-\uDFEB]|\uD83E[\uDD0C-\uDD3A\uDD3C-\uDD45\uDD47-\uDD78\uDD7A-\uDDCB\uDDCD-\uDDFF\uDE70-\uDE74\uDE78-\uDE7A\uDE80-\uDE86\uDE90-\uDEA8\uDEB0-\uDEB6\uDEC0-\uDEC2\uDED0-\uDED6])\uFE0F|(?:[\u261D\u26F9\u270A-\u270D]|\uD83C[\uDF85\uDFC2-\uDFC4\uDFC7\uDFCA-\uDFCC]|\uD83D[\uDC42\uDC43\uDC46-\uDC50\uDC66-\uDC78\uDC7C\uDC81-\uDC83\uDC85-\uDC87\uDC8F\uDC91\uDCAA\uDD74\uDD75\uDD7A\uDD90\uDD95\uDD96\uDE45-\uDE47\uDE4B-\uDE4F\uDEA3\uDEB4-\uDEB6\uDEC0\uDECC]|\uD83E[\uDD0C\uDD0F\uDD18-\uDD1F\uDD26\uDD30-\uDD39\uDD3C-\uDD3E\uDD77\uDDB5\uDDB6\uDDB8\uDDB9\uDDBB\uDDCD-\uDDCF\uDDD1-\uDDDD])/g;
              };
            }
          });
          var string_width_exports = {};
          __export(string_width_exports, {
            default: () => stringWidth
          });
          function stringWidth(string) {
            if (typeof string !== "string" || string.length === 0) {
              return 0;
            }
            string = stripAnsi(string);
            if (string.length === 0) {
              return 0;
            }
            string = string.replace((0, import_emoji_regex.default)(), "  ");
            let width = 0;
            for (let index = 0; index < string.length; index++) {
              const codePoint = string.codePointAt(index);
              if (codePoint <= 31 || codePoint >= 127 && codePoint <= 159) {
                continue;
              }
              if (codePoint >= 768 && codePoint <= 879) {
                continue;
              }
              if (codePoint > 65535) {
                index++;
              }
              width += isFullwidthCodePoint(codePoint) ? 2 : 1;
            }
            return width;
          }
          var import_emoji_regex;
          var init_string_width = __esm({
            "node_modules/string-width/index.js"() {
              init_define_process();
              init_strip_ansi();
              init_is_fullwidth_code_point();
              import_emoji_regex = __toESM2(require_emoji_regex());
            }
          });
          var require_get_string_width = __commonJS22({
            "src/utils/get-string-width.js"(exports22, module22) {
              "use strict";
              init_define_process();
              var stringWidth2 = (init_string_width(), __toCommonJS(string_width_exports)).default;
              var notAsciiRegex = /[^\x20-\x7F]/;
              function getStringWidth(text) {
                if (!text) {
                  return 0;
                }
                if (!notAsciiRegex.test(text)) {
                  return text.length;
                }
                return stringWidth2(text);
              }
              module22.exports = getStringWidth;
            }
          });
          var require_doc_utils = __commonJS22({
            "src/document/doc-utils.js"(exports22, module22) {
              "use strict";
              init_define_process();
              var getLast = require_get_last();
              var {
                literalline,
                join
              } = require_doc_builders();
              var isConcat = (doc) => Array.isArray(doc) || doc && doc.type === "concat";
              var getDocParts = (doc) => {
                if (Array.isArray(doc)) {
                  return doc;
                }
                if (doc.type !== "concat" && doc.type !== "fill") {
                  throw new Error("Expect doc type to be `concat` or `fill`.");
                }
                return doc.parts;
              };
              var traverseDocOnExitStackMarker = {};
              function traverseDoc(doc, onEnter, onExit, shouldTraverseConditionalGroups) {
                const docsStack = [doc];
                while (docsStack.length > 0) {
                  const doc2 = docsStack.pop();
                  if (doc2 === traverseDocOnExitStackMarker) {
                    onExit(docsStack.pop());
                    continue;
                  }
                  if (onExit) {
                    docsStack.push(doc2, traverseDocOnExitStackMarker);
                  }
                  if (!onEnter || onEnter(doc2) !== false) {
                    if (isConcat(doc2) || doc2.type === "fill") {
                      const parts = getDocParts(doc2);
                      for (let ic = parts.length, i = ic - 1; i >= 0; --i) {
                        docsStack.push(parts[i]);
                      }
                    } else if (doc2.type === "if-break") {
                      if (doc2.flatContents) {
                        docsStack.push(doc2.flatContents);
                      }
                      if (doc2.breakContents) {
                        docsStack.push(doc2.breakContents);
                      }
                    } else if (doc2.type === "group" && doc2.expandedStates) {
                      if (shouldTraverseConditionalGroups) {
                        for (let ic = doc2.expandedStates.length, i = ic - 1; i >= 0; --i) {
                          docsStack.push(doc2.expandedStates[i]);
                        }
                      } else {
                        docsStack.push(doc2.contents);
                      }
                    } else if (doc2.contents) {
                      docsStack.push(doc2.contents);
                    }
                  }
                }
              }
              function mapDoc(doc, cb) {
                const mapped = /* @__PURE__ */ new Map();
                return rec(doc);
                function rec(doc2) {
                  if (mapped.has(doc2)) {
                    return mapped.get(doc2);
                  }
                  const result = process2(doc2);
                  mapped.set(doc2, result);
                  return result;
                }
                function process2(doc2) {
                  if (Array.isArray(doc2)) {
                    return cb(doc2.map(rec));
                  }
                  if (doc2.type === "concat" || doc2.type === "fill") {
                    const parts = doc2.parts.map(rec);
                    return cb(Object.assign(Object.assign({}, doc2), {}, {
                      parts
                    }));
                  }
                  if (doc2.type === "if-break") {
                    const breakContents = doc2.breakContents && rec(doc2.breakContents);
                    const flatContents = doc2.flatContents && rec(doc2.flatContents);
                    return cb(Object.assign(Object.assign({}, doc2), {}, {
                      breakContents,
                      flatContents
                    }));
                  }
                  if (doc2.type === "group" && doc2.expandedStates) {
                    const expandedStates = doc2.expandedStates.map(rec);
                    const contents = expandedStates[0];
                    return cb(Object.assign(Object.assign({}, doc2), {}, {
                      contents,
                      expandedStates
                    }));
                  }
                  if (doc2.contents) {
                    const contents = rec(doc2.contents);
                    return cb(Object.assign(Object.assign({}, doc2), {}, {
                      contents
                    }));
                  }
                  return cb(doc2);
                }
              }
              function findInDoc(doc, fn, defaultValue) {
                let result = defaultValue;
                let hasStopped = false;
                function findInDocOnEnterFn(doc2) {
                  const maybeResult = fn(doc2);
                  if (maybeResult !== void 0) {
                    hasStopped = true;
                    result = maybeResult;
                  }
                  if (hasStopped) {
                    return false;
                  }
                }
                traverseDoc(doc, findInDocOnEnterFn);
                return result;
              }
              function willBreakFn(doc) {
                if (doc.type === "group" && doc.break) {
                  return true;
                }
                if (doc.type === "line" && doc.hard) {
                  return true;
                }
                if (doc.type === "break-parent") {
                  return true;
                }
              }
              function willBreak(doc) {
                return findInDoc(doc, willBreakFn, false);
              }
              function breakParentGroup(groupStack) {
                if (groupStack.length > 0) {
                  const parentGroup = getLast(groupStack);
                  if (!parentGroup.expandedStates && !parentGroup.break) {
                    parentGroup.break = "propagated";
                  }
                }
                return null;
              }
              function propagateBreaks(doc) {
                const alreadyVisitedSet = /* @__PURE__ */ new Set();
                const groupStack = [];
                function propagateBreaksOnEnterFn(doc2) {
                  if (doc2.type === "break-parent") {
                    breakParentGroup(groupStack);
                  }
                  if (doc2.type === "group") {
                    groupStack.push(doc2);
                    if (alreadyVisitedSet.has(doc2)) {
                      return false;
                    }
                    alreadyVisitedSet.add(doc2);
                  }
                }
                function propagateBreaksOnExitFn(doc2) {
                  if (doc2.type === "group") {
                    const group = groupStack.pop();
                    if (group.break) {
                      breakParentGroup(groupStack);
                    }
                  }
                }
                traverseDoc(doc, propagateBreaksOnEnterFn, propagateBreaksOnExitFn, true);
              }
              function removeLinesFn(doc) {
                if (doc.type === "line" && !doc.hard) {
                  return doc.soft ? "" : " ";
                }
                if (doc.type === "if-break") {
                  return doc.flatContents || "";
                }
                return doc;
              }
              function removeLines(doc) {
                return mapDoc(doc, removeLinesFn);
              }
              var isHardline = (doc, nextDoc) => doc && doc.type === "line" && doc.hard && nextDoc && nextDoc.type === "break-parent";
              function stripDocTrailingHardlineFromDoc(doc) {
                if (!doc) {
                  return doc;
                }
                if (isConcat(doc) || doc.type === "fill") {
                  const parts = getDocParts(doc);
                  while (parts.length > 1 && isHardline(...parts.slice(-2))) {
                    parts.length -= 2;
                  }
                  if (parts.length > 0) {
                    const lastPart = stripDocTrailingHardlineFromDoc(getLast(parts));
                    parts[parts.length - 1] = lastPart;
                  }
                  return Array.isArray(doc) ? parts : Object.assign(Object.assign({}, doc), {}, {
                    parts
                  });
                }
                switch (doc.type) {
                  case "align":
                  case "indent":
                  case "indent-if-break":
                  case "group":
                  case "line-suffix":
                  case "label": {
                    const contents = stripDocTrailingHardlineFromDoc(doc.contents);
                    return Object.assign(Object.assign({}, doc), {}, {
                      contents
                    });
                  }
                  case "if-break": {
                    const breakContents = stripDocTrailingHardlineFromDoc(doc.breakContents);
                    const flatContents = stripDocTrailingHardlineFromDoc(doc.flatContents);
                    return Object.assign(Object.assign({}, doc), {}, {
                      breakContents,
                      flatContents
                    });
                  }
                }
                return doc;
              }
              function stripTrailingHardline(doc) {
                return stripDocTrailingHardlineFromDoc(cleanDoc(doc));
              }
              function cleanDocFn(doc) {
                switch (doc.type) {
                  case "fill":
                    if (doc.parts.every((part) => part === "")) {
                      return "";
                    }
                    break;
                  case "group":
                    if (!doc.contents && !doc.id && !doc.break && !doc.expandedStates) {
                      return "";
                    }
                    if (doc.contents.type === "group" && doc.contents.id === doc.id && doc.contents.break === doc.break && doc.contents.expandedStates === doc.expandedStates) {
                      return doc.contents;
                    }
                    break;
                  case "align":
                  case "indent":
                  case "indent-if-break":
                  case "line-suffix":
                    if (!doc.contents) {
                      return "";
                    }
                    break;
                  case "if-break":
                    if (!doc.flatContents && !doc.breakContents) {
                      return "";
                    }
                    break;
                }
                if (!isConcat(doc)) {
                  return doc;
                }
                const parts = [];
                for (const part of getDocParts(doc)) {
                  if (!part) {
                    continue;
                  }
                  const [currentPart, ...restParts] = isConcat(part) ? getDocParts(part) : [part];
                  if (typeof currentPart === "string" && typeof getLast(parts) === "string") {
                    parts[parts.length - 1] += currentPart;
                  } else {
                    parts.push(currentPart);
                  }
                  parts.push(...restParts);
                }
                if (parts.length === 0) {
                  return "";
                }
                if (parts.length === 1) {
                  return parts[0];
                }
                return Array.isArray(doc) ? parts : Object.assign(Object.assign({}, doc), {}, {
                  parts
                });
              }
              function cleanDoc(doc) {
                return mapDoc(doc, (currentDoc) => cleanDocFn(currentDoc));
              }
              function normalizeParts(parts) {
                const newParts = [];
                const restParts = parts.filter(Boolean);
                while (restParts.length > 0) {
                  const part = restParts.shift();
                  if (!part) {
                    continue;
                  }
                  if (isConcat(part)) {
                    restParts.unshift(...getDocParts(part));
                    continue;
                  }
                  if (newParts.length > 0 && typeof getLast(newParts) === "string" && typeof part === "string") {
                    newParts[newParts.length - 1] += part;
                    continue;
                  }
                  newParts.push(part);
                }
                return newParts;
              }
              function normalizeDoc(doc) {
                return mapDoc(doc, (currentDoc) => {
                  if (Array.isArray(currentDoc)) {
                    return normalizeParts(currentDoc);
                  }
                  if (!currentDoc.parts) {
                    return currentDoc;
                  }
                  return Object.assign(Object.assign({}, currentDoc), {}, {
                    parts: normalizeParts(currentDoc.parts)
                  });
                });
              }
              function replaceEndOfLine(doc) {
                return mapDoc(doc, (currentDoc) => typeof currentDoc === "string" && currentDoc.includes("\n") ? replaceTextEndOfLine(currentDoc) : currentDoc);
              }
              function replaceTextEndOfLine(text) {
                let replacement = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : literalline;
                return join(replacement, text.split("\n")).parts;
              }
              function canBreakFn(doc) {
                if (doc.type === "line") {
                  return true;
                }
              }
              function canBreak(doc) {
                return findInDoc(doc, canBreakFn, false);
              }
              module22.exports = {
                isConcat,
                getDocParts,
                willBreak,
                traverseDoc,
                findInDoc,
                mapDoc,
                propagateBreaks,
                removeLines,
                stripTrailingHardline,
                normalizeParts,
                normalizeDoc,
                cleanDoc,
                replaceTextEndOfLine,
                replaceEndOfLine,
                canBreak
              };
            }
          });
          var require_doc_printer = __commonJS22({
            "src/document/doc-printer.js"(exports22, module22) {
              "use strict";
              init_define_process();
              var {
                convertEndOfLineToChars
              } = require_end_of_line();
              var getLast = require_get_last();
              var getStringWidth = require_get_string_width();
              var {
                fill,
                cursor,
                indent
              } = require_doc_builders();
              var {
                isConcat,
                getDocParts
              } = require_doc_utils();
              var groupModeMap;
              var MODE_BREAK = 1;
              var MODE_FLAT = 2;
              function rootIndent() {
                return {
                  value: "",
                  length: 0,
                  queue: []
                };
              }
              function makeIndent(ind, options) {
                return generateInd(ind, {
                  type: "indent"
                }, options);
              }
              function makeAlign(indent2, widthOrDoc, options) {
                if (widthOrDoc === Number.NEGATIVE_INFINITY) {
                  return indent2.root || rootIndent();
                }
                if (widthOrDoc < 0) {
                  return generateInd(indent2, {
                    type: "dedent"
                  }, options);
                }
                if (!widthOrDoc) {
                  return indent2;
                }
                if (widthOrDoc.type === "root") {
                  return Object.assign(Object.assign({}, indent2), {}, {
                    root: indent2
                  });
                }
                const alignType = typeof widthOrDoc === "string" ? "stringAlign" : "numberAlign";
                return generateInd(indent2, {
                  type: alignType,
                  n: widthOrDoc
                }, options);
              }
              function generateInd(ind, newPart, options) {
                const queue = newPart.type === "dedent" ? ind.queue.slice(0, -1) : [...ind.queue, newPart];
                let value = "";
                let length = 0;
                let lastTabs = 0;
                let lastSpaces = 0;
                for (const part of queue) {
                  switch (part.type) {
                    case "indent":
                      flush();
                      if (options.useTabs) {
                        addTabs(1);
                      } else {
                        addSpaces(options.tabWidth);
                      }
                      break;
                    case "stringAlign":
                      flush();
                      value += part.n;
                      length += part.n.length;
                      break;
                    case "numberAlign":
                      lastTabs += 1;
                      lastSpaces += part.n;
                      break;
                    default:
                      throw new Error(`Unexpected type '${part.type}'`);
                  }
                }
                flushSpaces();
                return Object.assign(Object.assign({}, ind), {}, {
                  value,
                  length,
                  queue
                });
                function addTabs(count) {
                  value += "	".repeat(count);
                  length += options.tabWidth * count;
                }
                function addSpaces(count) {
                  value += " ".repeat(count);
                  length += count;
                }
                function flush() {
                  if (options.useTabs) {
                    flushTabs();
                  } else {
                    flushSpaces();
                  }
                }
                function flushTabs() {
                  if (lastTabs > 0) {
                    addTabs(lastTabs);
                  }
                  resetLast();
                }
                function flushSpaces() {
                  if (lastSpaces > 0) {
                    addSpaces(lastSpaces);
                  }
                  resetLast();
                }
                function resetLast() {
                  lastTabs = 0;
                  lastSpaces = 0;
                }
              }
              function trim(out) {
                if (out.length === 0) {
                  return 0;
                }
                let trimCount = 0;
                while (out.length > 0 && typeof getLast(out) === "string" && /^[\t ]*$/.test(getLast(out))) {
                  trimCount += out.pop().length;
                }
                if (out.length > 0 && typeof getLast(out) === "string") {
                  const trimmed = getLast(out).replace(/[\t ]*$/, "");
                  trimCount += getLast(out).length - trimmed.length;
                  out[out.length - 1] = trimmed;
                }
                return trimCount;
              }
              function fits(next, restCommands, width, hasLineSuffix, mustBeFlat) {
                let restIdx = restCommands.length;
                const cmds = [next];
                const out = [];
                while (width >= 0) {
                  if (cmds.length === 0) {
                    if (restIdx === 0) {
                      return true;
                    }
                    cmds.push(restCommands[--restIdx]);
                    continue;
                  }
                  const {
                    mode,
                    doc
                  } = cmds.pop();
                  if (typeof doc === "string") {
                    out.push(doc);
                    width -= getStringWidth(doc);
                  } else if (isConcat(doc) || doc.type === "fill") {
                    const parts = getDocParts(doc);
                    for (let i = parts.length - 1; i >= 0; i--) {
                      cmds.push({
                        mode,
                        doc: parts[i]
                      });
                    }
                  } else {
                    switch (doc.type) {
                      case "indent":
                      case "align":
                      case "indent-if-break":
                      case "label":
                        cmds.push({
                          mode,
                          doc: doc.contents
                        });
                        break;
                      case "trim":
                        width += trim(out);
                        break;
                      case "group": {
                        if (mustBeFlat && doc.break) {
                          return false;
                        }
                        const groupMode = doc.break ? MODE_BREAK : mode;
                        const contents = doc.expandedStates && groupMode === MODE_BREAK ? getLast(doc.expandedStates) : doc.contents;
                        cmds.push({
                          mode: groupMode,
                          doc: contents
                        });
                        break;
                      }
                      case "if-break": {
                        const groupMode = doc.groupId ? groupModeMap[doc.groupId] || MODE_FLAT : mode;
                        const contents = groupMode === MODE_BREAK ? doc.breakContents : doc.flatContents;
                        if (contents) {
                          cmds.push({
                            mode,
                            doc: contents
                          });
                        }
                        break;
                      }
                      case "line":
                        if (mode === MODE_BREAK || doc.hard) {
                          return true;
                        }
                        if (!doc.soft) {
                          out.push(" ");
                          width--;
                        }
                        break;
                      case "line-suffix":
                        hasLineSuffix = true;
                        break;
                      case "line-suffix-boundary":
                        if (hasLineSuffix) {
                          return false;
                        }
                        break;
                    }
                  }
                }
                return false;
              }
              function printDocToString(doc, options) {
                groupModeMap = {};
                const width = options.printWidth;
                const newLine = convertEndOfLineToChars(options.endOfLine);
                let pos = 0;
                const cmds = [{
                  ind: rootIndent(),
                  mode: MODE_BREAK,
                  doc
                }];
                const out = [];
                let shouldRemeasure = false;
                const lineSuffix = [];
                while (cmds.length > 0) {
                  const {
                    ind,
                    mode,
                    doc: doc2
                  } = cmds.pop();
                  if (typeof doc2 === "string") {
                    const formatted = newLine !== "\n" ? doc2.replace(/\n/g, newLine) : doc2;
                    out.push(formatted);
                    pos += getStringWidth(formatted);
                  } else if (isConcat(doc2)) {
                    const parts = getDocParts(doc2);
                    for (let i = parts.length - 1; i >= 0; i--) {
                      cmds.push({
                        ind,
                        mode,
                        doc: parts[i]
                      });
                    }
                  } else {
                    switch (doc2.type) {
                      case "cursor":
                        out.push(cursor.placeholder);
                        break;
                      case "indent":
                        cmds.push({
                          ind: makeIndent(ind, options),
                          mode,
                          doc: doc2.contents
                        });
                        break;
                      case "align":
                        cmds.push({
                          ind: makeAlign(ind, doc2.n, options),
                          mode,
                          doc: doc2.contents
                        });
                        break;
                      case "trim":
                        pos -= trim(out);
                        break;
                      case "group":
                        switch (mode) {
                          case MODE_FLAT:
                            if (!shouldRemeasure) {
                              cmds.push({
                                ind,
                                mode: doc2.break ? MODE_BREAK : MODE_FLAT,
                                doc: doc2.contents
                              });
                              break;
                            }
                          case MODE_BREAK: {
                            shouldRemeasure = false;
                            const next = {
                              ind,
                              mode: MODE_FLAT,
                              doc: doc2.contents
                            };
                            const rem = width - pos;
                            const hasLineSuffix = lineSuffix.length > 0;
                            if (!doc2.break && fits(next, cmds, rem, hasLineSuffix)) {
                              cmds.push(next);
                            } else {
                              if (doc2.expandedStates) {
                                const mostExpanded = getLast(doc2.expandedStates);
                                if (doc2.break) {
                                  cmds.push({
                                    ind,
                                    mode: MODE_BREAK,
                                    doc: mostExpanded
                                  });
                                  break;
                                } else {
                                  for (let i = 1; i < doc2.expandedStates.length + 1; i++) {
                                    if (i >= doc2.expandedStates.length) {
                                      cmds.push({
                                        ind,
                                        mode: MODE_BREAK,
                                        doc: mostExpanded
                                      });
                                      break;
                                    } else {
                                      const state = doc2.expandedStates[i];
                                      const cmd = {
                                        ind,
                                        mode: MODE_FLAT,
                                        doc: state
                                      };
                                      if (fits(cmd, cmds, rem, hasLineSuffix)) {
                                        cmds.push(cmd);
                                        break;
                                      }
                                    }
                                  }
                                }
                              } else {
                                cmds.push({
                                  ind,
                                  mode: MODE_BREAK,
                                  doc: doc2.contents
                                });
                              }
                            }
                            break;
                          }
                        }
                        if (doc2.id) {
                          groupModeMap[doc2.id] = getLast(cmds).mode;
                        }
                        break;
                      case "fill": {
                        const rem = width - pos;
                        const {
                          parts
                        } = doc2;
                        if (parts.length === 0) {
                          break;
                        }
                        const [content, whitespace] = parts;
                        const contentFlatCmd = {
                          ind,
                          mode: MODE_FLAT,
                          doc: content
                        };
                        const contentBreakCmd = {
                          ind,
                          mode: MODE_BREAK,
                          doc: content
                        };
                        const contentFits = fits(contentFlatCmd, [], rem, lineSuffix.length > 0, true);
                        if (parts.length === 1) {
                          if (contentFits) {
                            cmds.push(contentFlatCmd);
                          } else {
                            cmds.push(contentBreakCmd);
                          }
                          break;
                        }
                        const whitespaceFlatCmd = {
                          ind,
                          mode: MODE_FLAT,
                          doc: whitespace
                        };
                        const whitespaceBreakCmd = {
                          ind,
                          mode: MODE_BREAK,
                          doc: whitespace
                        };
                        if (parts.length === 2) {
                          if (contentFits) {
                            cmds.push(whitespaceFlatCmd, contentFlatCmd);
                          } else {
                            cmds.push(whitespaceBreakCmd, contentBreakCmd);
                          }
                          break;
                        }
                        parts.splice(0, 2);
                        const remainingCmd = {
                          ind,
                          mode,
                          doc: fill(parts)
                        };
                        const secondContent = parts[0];
                        const firstAndSecondContentFlatCmd = {
                          ind,
                          mode: MODE_FLAT,
                          doc: [content, whitespace, secondContent]
                        };
                        const firstAndSecondContentFits = fits(firstAndSecondContentFlatCmd, [], rem, lineSuffix.length > 0, true);
                        if (firstAndSecondContentFits) {
                          cmds.push(remainingCmd, whitespaceFlatCmd, contentFlatCmd);
                        } else if (contentFits) {
                          cmds.push(remainingCmd, whitespaceBreakCmd, contentFlatCmd);
                        } else {
                          cmds.push(remainingCmd, whitespaceBreakCmd, contentBreakCmd);
                        }
                        break;
                      }
                      case "if-break":
                      case "indent-if-break": {
                        const groupMode = doc2.groupId ? groupModeMap[doc2.groupId] : mode;
                        if (groupMode === MODE_BREAK) {
                          const breakContents = doc2.type === "if-break" ? doc2.breakContents : doc2.negate ? doc2.contents : indent(doc2.contents);
                          if (breakContents) {
                            cmds.push({
                              ind,
                              mode,
                              doc: breakContents
                            });
                          }
                        }
                        if (groupMode === MODE_FLAT) {
                          const flatContents = doc2.type === "if-break" ? doc2.flatContents : doc2.negate ? indent(doc2.contents) : doc2.contents;
                          if (flatContents) {
                            cmds.push({
                              ind,
                              mode,
                              doc: flatContents
                            });
                          }
                        }
                        break;
                      }
                      case "line-suffix":
                        lineSuffix.push({
                          ind,
                          mode,
                          doc: doc2.contents
                        });
                        break;
                      case "line-suffix-boundary":
                        if (lineSuffix.length > 0) {
                          cmds.push({
                            ind,
                            mode,
                            doc: {
                              type: "line",
                              hard: true
                            }
                          });
                        }
                        break;
                      case "line":
                        switch (mode) {
                          case MODE_FLAT:
                            if (!doc2.hard) {
                              if (!doc2.soft) {
                                out.push(" ");
                                pos += 1;
                              }
                              break;
                            } else {
                              shouldRemeasure = true;
                            }
                          case MODE_BREAK:
                            if (lineSuffix.length > 0) {
                              cmds.push({
                                ind,
                                mode,
                                doc: doc2
                              }, ...lineSuffix.reverse());
                              lineSuffix.length = 0;
                              break;
                            }
                            if (doc2.literal) {
                              if (ind.root) {
                                out.push(newLine, ind.root.value);
                                pos = ind.root.length;
                              } else {
                                out.push(newLine);
                                pos = 0;
                              }
                            } else {
                              pos -= trim(out);
                              out.push(newLine + ind.value);
                              pos = ind.length;
                            }
                            break;
                        }
                        break;
                      case "label":
                        cmds.push({
                          ind,
                          mode,
                          doc: doc2.contents
                        });
                        break;
                      default:
                    }
                  }
                  if (cmds.length === 0 && lineSuffix.length > 0) {
                    cmds.push(...lineSuffix.reverse());
                    lineSuffix.length = 0;
                  }
                }
                const cursorPlaceholderIndex = out.indexOf(cursor.placeholder);
                if (cursorPlaceholderIndex !== -1) {
                  const otherCursorPlaceholderIndex = out.indexOf(cursor.placeholder, cursorPlaceholderIndex + 1);
                  const beforeCursor = out.slice(0, cursorPlaceholderIndex).join("");
                  const aroundCursor = out.slice(cursorPlaceholderIndex + 1, otherCursorPlaceholderIndex).join("");
                  const afterCursor = out.slice(otherCursorPlaceholderIndex + 1).join("");
                  return {
                    formatted: beforeCursor + aroundCursor + afterCursor,
                    cursorNodeStart: beforeCursor.length,
                    cursorNodeText: aroundCursor
                  };
                }
                return {
                  formatted: out.join("")
                };
              }
              module22.exports = {
                printDocToString
              };
            }
          });
          var require_doc_debug = __commonJS22({
            "src/document/doc-debug.js"(exports22, module22) {
              "use strict";
              init_define_process();
              var {
                isConcat,
                getDocParts
              } = require_doc_utils();
              function flattenDoc(doc) {
                if (!doc) {
                  return "";
                }
                if (isConcat(doc)) {
                  const res = [];
                  for (const part of getDocParts(doc)) {
                    if (isConcat(part)) {
                      res.push(...flattenDoc(part).parts);
                    } else {
                      const flattened = flattenDoc(part);
                      if (flattened !== "") {
                        res.push(flattened);
                      }
                    }
                  }
                  return {
                    type: "concat",
                    parts: res
                  };
                }
                if (doc.type === "if-break") {
                  return Object.assign(Object.assign({}, doc), {}, {
                    breakContents: flattenDoc(doc.breakContents),
                    flatContents: flattenDoc(doc.flatContents)
                  });
                }
                if (doc.type === "group") {
                  return Object.assign(Object.assign({}, doc), {}, {
                    contents: flattenDoc(doc.contents),
                    expandedStates: doc.expandedStates && doc.expandedStates.map(flattenDoc)
                  });
                }
                if (doc.type === "fill") {
                  return {
                    type: "fill",
                    parts: doc.parts.map(flattenDoc)
                  };
                }
                if (doc.contents) {
                  return Object.assign(Object.assign({}, doc), {}, {
                    contents: flattenDoc(doc.contents)
                  });
                }
                return doc;
              }
              function printDocToDebug(doc) {
                const printedSymbols = /* @__PURE__ */ Object.create(null);
                const usedKeysForSymbols = /* @__PURE__ */ new Set();
                return printDoc(flattenDoc(doc));
                function printDoc(doc2, index, parentParts) {
                  if (typeof doc2 === "string") {
                    return JSON.stringify(doc2);
                  }
                  if (isConcat(doc2)) {
                    const printed = getDocParts(doc2).map(printDoc).filter(Boolean);
                    return printed.length === 1 ? printed[0] : `[${printed.join(", ")}]`;
                  }
                  if (doc2.type === "line") {
                    const withBreakParent = Array.isArray(parentParts) && parentParts[index + 1] && parentParts[index + 1].type === "break-parent";
                    if (doc2.literal) {
                      return withBreakParent ? "literalline" : "literallineWithoutBreakParent";
                    }
                    if (doc2.hard) {
                      return withBreakParent ? "hardline" : "hardlineWithoutBreakParent";
                    }
                    if (doc2.soft) {
                      return "softline";
                    }
                    return "line";
                  }
                  if (doc2.type === "break-parent") {
                    const afterHardline = Array.isArray(parentParts) && parentParts[index - 1] && parentParts[index - 1].type === "line" && parentParts[index - 1].hard;
                    return afterHardline ? void 0 : "breakParent";
                  }
                  if (doc2.type === "trim") {
                    return "trim";
                  }
                  if (doc2.type === "indent") {
                    return "indent(" + printDoc(doc2.contents) + ")";
                  }
                  if (doc2.type === "align") {
                    return doc2.n === Number.NEGATIVE_INFINITY ? "dedentToRoot(" + printDoc(doc2.contents) + ")" : doc2.n < 0 ? "dedent(" + printDoc(doc2.contents) + ")" : doc2.n.type === "root" ? "markAsRoot(" + printDoc(doc2.contents) + ")" : "align(" + JSON.stringify(doc2.n) + ", " + printDoc(doc2.contents) + ")";
                  }
                  if (doc2.type === "if-break") {
                    return "ifBreak(" + printDoc(doc2.breakContents) + (doc2.flatContents ? ", " + printDoc(doc2.flatContents) : "") + (doc2.groupId ? (!doc2.flatContents ? ', ""' : "") + `, { groupId: ${printGroupId(doc2.groupId)} }` : "") + ")";
                  }
                  if (doc2.type === "indent-if-break") {
                    const optionsParts = [];
                    if (doc2.negate) {
                      optionsParts.push("negate: true");
                    }
                    if (doc2.groupId) {
                      optionsParts.push(`groupId: ${printGroupId(doc2.groupId)}`);
                    }
                    const options = optionsParts.length > 0 ? `, { ${optionsParts.join(", ")} }` : "";
                    return `indentIfBreak(${printDoc(doc2.contents)}${options})`;
                  }
                  if (doc2.type === "group") {
                    const optionsParts = [];
                    if (doc2.break && doc2.break !== "propagated") {
                      optionsParts.push("shouldBreak: true");
                    }
                    if (doc2.id) {
                      optionsParts.push(`id: ${printGroupId(doc2.id)}`);
                    }
                    const options = optionsParts.length > 0 ? `, { ${optionsParts.join(", ")} }` : "";
                    if (doc2.expandedStates) {
                      return `conditionalGroup([${doc2.expandedStates.map((part) => printDoc(part)).join(",")}]${options})`;
                    }
                    return `group(${printDoc(doc2.contents)}${options})`;
                  }
                  if (doc2.type === "fill") {
                    return `fill([${doc2.parts.map((part) => printDoc(part)).join(", ")}])`;
                  }
                  if (doc2.type === "line-suffix") {
                    return "lineSuffix(" + printDoc(doc2.contents) + ")";
                  }
                  if (doc2.type === "line-suffix-boundary") {
                    return "lineSuffixBoundary";
                  }
                  if (doc2.type === "label") {
                    return `label(${JSON.stringify(doc2.label)}, ${printDoc(doc2.contents)})`;
                  }
                  throw new Error("Unknown doc type " + doc2.type);
                }
                function printGroupId(id) {
                  if (typeof id !== "symbol") {
                    return JSON.stringify(String(id));
                  }
                  if (id in printedSymbols) {
                    return printedSymbols[id];
                  }
                  const prefix = String(id).slice(7, -1) || "symbol";
                  for (let counter = 0; ; counter++) {
                    const key = prefix + (counter > 0 ? ` #${counter}` : "");
                    if (!usedKeysForSymbols.has(key)) {
                      usedKeysForSymbols.add(key);
                      return printedSymbols[id] = `Symbol.for(${JSON.stringify(key)})`;
                    }
                  }
                }
              }
              module22.exports = {
                printDocToDebug
              };
            }
          });
          init_define_process();
          module3.exports = {
            builders: require_doc_builders(),
            printer: require_doc_printer(),
            utils: require_doc_utils(),
            debug: require_doc_debug()
          };
        }
      });
      return require_doc_js_umd();
    });
  }
});

// node_modules/prettier/third-party.js
var require_third_party = __commonJS({
  "node_modules/prettier/third-party.js"(exports, module2) {
    "use strict";
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __commonJS2 = (cb, mod) => function __require() {
      return mod || (0, cb[__getOwnPropNames2(cb)[0]])((mod = {
        exports: {}
      }).exports, mod), mod.exports;
    };
    var require_resolve_from = __commonJS2({
      "node_modules/import-fresh/node_modules/resolve-from/index.js"(exports2, module22) {
        "use strict";
        var path = require("path");
        var Module = require("module");
        var fs2 = require("fs");
        var resolveFrom = (fromDir, moduleId, silent) => {
          if (typeof fromDir !== "string") {
            throw new TypeError(`Expected \`fromDir\` to be of type \`string\`, got \`${typeof fromDir}\``);
          }
          if (typeof moduleId !== "string") {
            throw new TypeError(`Expected \`moduleId\` to be of type \`string\`, got \`${typeof moduleId}\``);
          }
          try {
            fromDir = fs2.realpathSync(fromDir);
          } catch (err) {
            if (err.code === "ENOENT") {
              fromDir = path.resolve(fromDir);
            } else if (silent) {
              return null;
            } else {
              throw err;
            }
          }
          const fromFile = path.join(fromDir, "noop.js");
          const resolveFileName = () => Module._resolveFilename(moduleId, {
            id: fromFile,
            filename: fromFile,
            paths: Module._nodeModulePaths(fromDir)
          });
          if (silent) {
            try {
              return resolveFileName();
            } catch (err) {
              return null;
            }
          }
          return resolveFileName();
        };
        module22.exports = (fromDir, moduleId) => resolveFrom(fromDir, moduleId);
        module22.exports.silent = (fromDir, moduleId) => resolveFrom(fromDir, moduleId, true);
      }
    });
    var require_parent_module = __commonJS2({
      "scripts/build/shims/parent-module.cjs"(exports2, module22) {
        "use strict";
        module22.exports = (file) => file;
      }
    });
    var require_import_fresh = __commonJS2({
      "node_modules/import-fresh/index.js"(exports2, module22) {
        "use strict";
        var path = require("path");
        var resolveFrom = require_resolve_from();
        var parentModule = require_parent_module();
        module22.exports = (moduleId) => {
          if (typeof moduleId !== "string") {
            throw new TypeError("Expected a string");
          }
          const parentPath = parentModule(__filename);
          const cwd = parentPath ? path.dirname(parentPath) : __dirname;
          const filePath2 = resolveFrom(cwd, moduleId);
          const oldModule = require.cache[filePath2];
          if (oldModule && oldModule.parent) {
            let i = oldModule.parent.children.length;
            while (i--) {
              if (oldModule.parent.children[i].id === filePath2) {
                oldModule.parent.children.splice(i, 1);
              }
            }
          }
          delete require.cache[filePath2];
          const parent = require.cache[parentPath];
          return parent === void 0 ? require(filePath2) : parent.require(filePath2);
        };
      }
    });
    var require_is_arrayish = __commonJS2({
      "node_modules/is-arrayish/index.js"(exports2, module22) {
        "use strict";
        module22.exports = function isArrayish(obj) {
          if (!obj) {
            return false;
          }
          return obj instanceof Array || Array.isArray(obj) || obj.length >= 0 && obj.splice instanceof Function;
        };
      }
    });
    var require_error_ex = __commonJS2({
      "node_modules/error-ex/index.js"(exports2, module22) {
        "use strict";
        var util = require("util");
        var isArrayish = require_is_arrayish();
        var errorEx = function errorEx2(name, properties) {
          if (!name || name.constructor !== String) {
            properties = name || {};
            name = Error.name;
          }
          var errorExError = function ErrorEXError(message) {
            if (!this) {
              return new ErrorEXError(message);
            }
            message = message instanceof Error ? message.message : message || this.message;
            Error.call(this, message);
            Error.captureStackTrace(this, errorExError);
            this.name = name;
            Object.defineProperty(this, "message", {
              configurable: true,
              enumerable: false,
              get: function() {
                var newMessage = message.split(/\r?\n/g);
                for (var key in properties) {
                  if (!properties.hasOwnProperty(key)) {
                    continue;
                  }
                  var modifier = properties[key];
                  if ("message" in modifier) {
                    newMessage = modifier.message(this[key], newMessage) || newMessage;
                    if (!isArrayish(newMessage)) {
                      newMessage = [newMessage];
                    }
                  }
                }
                return newMessage.join("\n");
              },
              set: function(v) {
                message = v;
              }
            });
            var overwrittenStack = null;
            var stackDescriptor = Object.getOwnPropertyDescriptor(this, "stack");
            var stackGetter = stackDescriptor.get;
            var stackValue = stackDescriptor.value;
            delete stackDescriptor.value;
            delete stackDescriptor.writable;
            stackDescriptor.set = function(newstack) {
              overwrittenStack = newstack;
            };
            stackDescriptor.get = function() {
              var stack = (overwrittenStack || (stackGetter ? stackGetter.call(this) : stackValue)).split(/\r?\n+/g);
              if (!overwrittenStack) {
                stack[0] = this.name + ": " + this.message;
              }
              var lineCount = 1;
              for (var key in properties) {
                if (!properties.hasOwnProperty(key)) {
                  continue;
                }
                var modifier = properties[key];
                if ("line" in modifier) {
                  var line = modifier.line(this[key]);
                  if (line) {
                    stack.splice(lineCount++, 0, "    " + line);
                  }
                }
                if ("stack" in modifier) {
                  modifier.stack(this[key], stack);
                }
              }
              return stack.join("\n");
            };
            Object.defineProperty(this, "stack", stackDescriptor);
          };
          if (Object.setPrototypeOf) {
            Object.setPrototypeOf(errorExError.prototype, Error.prototype);
            Object.setPrototypeOf(errorExError, Error);
          } else {
            util.inherits(errorExError, Error);
          }
          return errorExError;
        };
        errorEx.append = function(str, def) {
          return {
            message: function(v, message) {
              v = v || def;
              if (v) {
                message[0] += " " + str.replace("%s", v.toString());
              }
              return message;
            }
          };
        };
        errorEx.line = function(str, def) {
          return {
            line: function(v) {
              v = v || def;
              if (v) {
                return str.replace("%s", v.toString());
              }
              return null;
            }
          };
        };
        module22.exports = errorEx;
      }
    });
    var require_json_parse_even_better_errors = __commonJS2({
      "node_modules/json-parse-even-better-errors/index.js"(exports2, module22) {
        "use strict";
        var hexify = (char2) => {
          const h = char2.charCodeAt(0).toString(16).toUpperCase();
          return "0x" + (h.length % 2 ? "0" : "") + h;
        };
        var parseError = (e, txt, context) => {
          if (!txt) {
            return {
              message: e.message + " while parsing empty string",
              position: 0
            };
          }
          const badToken = e.message.match(/^Unexpected token (.) .*position\s+(\d+)/i);
          const errIdx = badToken ? +badToken[2] : e.message.match(/^Unexpected end of JSON.*/i) ? txt.length - 1 : null;
          const msg = badToken ? e.message.replace(/^Unexpected token ./, `Unexpected token ${JSON.stringify(badToken[1])} (${hexify(badToken[1])})`) : e.message;
          if (errIdx !== null && errIdx !== void 0) {
            const start = errIdx <= context ? 0 : errIdx - context;
            const end = errIdx + context >= txt.length ? txt.length : errIdx + context;
            const slice = (start === 0 ? "" : "...") + txt.slice(start, end) + (end === txt.length ? "" : "...");
            const near = txt === slice ? "" : "near ";
            return {
              message: msg + ` while parsing ${near}${JSON.stringify(slice)}`,
              position: errIdx
            };
          } else {
            return {
              message: msg + ` while parsing '${txt.slice(0, context * 2)}'`,
              position: 0
            };
          }
        };
        var JSONParseError = class extends SyntaxError {
          constructor(er, txt, context, caller) {
            context = context || 20;
            const metadata = parseError(er, txt, context);
            super(metadata.message);
            Object.assign(this, metadata);
            this.code = "EJSONPARSE";
            this.systemError = er;
            Error.captureStackTrace(this, caller || this.constructor);
          }
          get name() {
            return this.constructor.name;
          }
          set name(n2) {
          }
          get [Symbol.toStringTag]() {
            return this.constructor.name;
          }
        };
        var kIndent = Symbol.for("indent");
        var kNewline = Symbol.for("newline");
        var formatRE = /^\s*[{\[]((?:\r?\n)+)([\s\t]*)/;
        var emptyRE = /^(?:\{\}|\[\])((?:\r?\n)+)?$/;
        var parseJson = (txt, reviver, context) => {
          const parseText = stripBOM(txt);
          context = context || 20;
          try {
            const [, newline = "\n", indent = "  "] = parseText.match(emptyRE) || parseText.match(formatRE) || [, "", ""];
            const result = JSON.parse(parseText, reviver);
            if (result && typeof result === "object") {
              result[kNewline] = newline;
              result[kIndent] = indent;
            }
            return result;
          } catch (e) {
            if (typeof txt !== "string" && !Buffer.isBuffer(txt)) {
              const isEmptyArray = Array.isArray(txt) && txt.length === 0;
              throw Object.assign(new TypeError(`Cannot parse ${isEmptyArray ? "an empty array" : String(txt)}`), {
                code: "EJSONPARSE",
                systemError: e
              });
            }
            throw new JSONParseError(e, parseText, context, parseJson);
          }
        };
        var stripBOM = (txt) => String(txt).replace(/^\uFEFF/, "");
        module22.exports = parseJson;
        parseJson.JSONParseError = JSONParseError;
        parseJson.noExceptions = (txt, reviver) => {
          try {
            return JSON.parse(stripBOM(txt), reviver);
          } catch (e) {
          }
        };
      }
    });
    var require_build = __commonJS2({
      "node_modules/parse-json/node_modules/lines-and-columns/build/index.js"(exports2) {
        "use strict";
        exports2.__esModule = true;
        exports2.LinesAndColumns = void 0;
        var LF = "\n";
        var CR = "\r";
        var LinesAndColumns = function() {
          function LinesAndColumns2(string) {
            this.string = string;
            var offsets = [0];
            for (var offset = 0; offset < string.length; ) {
              switch (string[offset]) {
                case LF:
                  offset += LF.length;
                  offsets.push(offset);
                  break;
                case CR:
                  offset += CR.length;
                  if (string[offset] === LF) {
                    offset += LF.length;
                  }
                  offsets.push(offset);
                  break;
                default:
                  offset++;
                  break;
              }
            }
            this.offsets = offsets;
          }
          LinesAndColumns2.prototype.locationForIndex = function(index) {
            if (index < 0 || index > this.string.length) {
              return null;
            }
            var line = 0;
            var offsets = this.offsets;
            while (offsets[line + 1] <= index) {
              line++;
            }
            var column = index - offsets[line];
            return {
              line,
              column
            };
          };
          LinesAndColumns2.prototype.indexForLocation = function(location) {
            var line = location.line, column = location.column;
            if (line < 0 || line >= this.offsets.length) {
              return null;
            }
            if (column < 0 || column > this.lengthOfLine(line)) {
              return null;
            }
            return this.offsets[line] + column;
          };
          LinesAndColumns2.prototype.lengthOfLine = function(line) {
            var offset = this.offsets[line];
            var nextOffset = line === this.offsets.length - 1 ? this.string.length : this.offsets[line + 1];
            return nextOffset - offset;
          };
          return LinesAndColumns2;
        }();
        exports2.LinesAndColumns = LinesAndColumns;
        exports2["default"] = LinesAndColumns;
      }
    });
    var require_js_tokens = __commonJS2({
      "node_modules/js-tokens/index.js"(exports2) {
        Object.defineProperty(exports2, "__esModule", {
          value: true
        });
        exports2.default = /((['"])(?:(?!\2|\\).|\\(?:\r\n|[\s\S]))*(\2)?|`(?:[^`\\$]|\\[\s\S]|\$(?!\{)|\$\{(?:[^{}]|\{[^}]*\}?)*\}?)*(`)?)|(\/\/.*)|(\/\*(?:[^*]|\*(?!\/))*(\*\/)?)|(\/(?!\*)(?:\[(?:(?![\]\\]).|\\.)*\]|(?![\/\]\\]).|\\.)+\/(?:(?!\s*(?:\b|[\u0080-\uFFFF$\\'"~({]|[+\-!](?!=)|\.?\d))|[gmiyus]{1,6}\b(?![\u0080-\uFFFF$\\]|\s*(?:[+\-*%&|^<>!=?({]|\/(?![\/*])))))|(0[xX][\da-fA-F]+|0[oO][0-7]+|0[bB][01]+|(?:\d*\.\d+|\d+\.?)(?:[eE][+-]?\d+)?)|((?!\d)(?:(?!\s)[$\w\u0080-\uFFFF]|\\u[\da-fA-F]{4}|\\u\{[\da-fA-F]+\})+)|(--|\+\+|&&|\|\||=>|\.{3}|(?:[+\-\/%&|^]|\*{1,2}|<{1,2}|>{1,3}|!=?|={1,2})=?|[?~.,:;[\](){}])|(\s+)|(^$|[\s\S])/g;
        exports2.matchToToken = function(match) {
          var token = {
            type: "invalid",
            value: match[0],
            closed: void 0
          };
          if (match[1])
            token.type = "string", token.closed = !!(match[3] || match[4]);
          else if (match[5])
            token.type = "comment";
          else if (match[6])
            token.type = "comment", token.closed = !!match[7];
          else if (match[8])
            token.type = "regex";
          else if (match[9])
            token.type = "number";
          else if (match[10])
            token.type = "name";
          else if (match[11])
            token.type = "punctuator";
          else if (match[12])
            token.type = "whitespace";
          return token;
        };
      }
    });
    var require_identifier = __commonJS2({
      "node_modules/@babel/helper-validator-identifier/lib/identifier.js"(exports2) {
        "use strict";
        Object.defineProperty(exports2, "__esModule", {
          value: true
        });
        exports2.isIdentifierChar = isIdentifierChar;
        exports2.isIdentifierName = isIdentifierName;
        exports2.isIdentifierStart = isIdentifierStart;
        var nonASCIIidentifierStartChars = "\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0560-\u0588\u05D0-\u05EA\u05EF-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u0860-\u086A\u0870-\u0887\u0889-\u088E\u08A0-\u08C9\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u09FC\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C5D\u0C60\u0C61\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D04-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E86-\u0E8A\u0E8C-\u0EA3\u0EA5\u0EA7-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u1711\u171F-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1878\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4C\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1C80-\u1C88\u1C90-\u1CBA\u1CBD-\u1CBF\u1CE9-\u1CEC\u1CEE-\u1CF3\u1CF5\u1CF6\u1CFA\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2118-\u211D\u2124\u2126\u2128\u212A-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309B-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312F\u3131-\u318E\u31A0-\u31BF\u31F0-\u31FF\u3400-\u4DBF\u4E00-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA7CA\uA7D0\uA7D1\uA7D3\uA7D5-\uA7D9\uA7F2-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA8FE\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB69\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC";
        var nonASCIIidentifierChars = "\u200C\u200D\xB7\u0300-\u036F\u0387\u0483-\u0487\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u0669\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u06F0-\u06F9\u0711\u0730-\u074A\u07A6-\u07B0\u07C0-\u07C9\u07EB-\u07F3\u07FD\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u0898-\u089F\u08CA-\u08E1\u08E3-\u0903\u093A-\u093C\u093E-\u094F\u0951-\u0957\u0962\u0963\u0966-\u096F\u0981-\u0983\u09BC\u09BE-\u09C4\u09C7\u09C8\u09CB-\u09CD\u09D7\u09E2\u09E3\u09E6-\u09EF\u09FE\u0A01-\u0A03\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A66-\u0A71\u0A75\u0A81-\u0A83\u0ABC\u0ABE-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AE2\u0AE3\u0AE6-\u0AEF\u0AFA-\u0AFF\u0B01-\u0B03\u0B3C\u0B3E-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B55-\u0B57\u0B62\u0B63\u0B66-\u0B6F\u0B82\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD7\u0BE6-\u0BEF\u0C00-\u0C04\u0C3C\u0C3E-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C66-\u0C6F\u0C81-\u0C83\u0CBC\u0CBE-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CE2\u0CE3\u0CE6-\u0CEF\u0CF3\u0D00-\u0D03\u0D3B\u0D3C\u0D3E-\u0D44\u0D46-\u0D48\u0D4A-\u0D4D\u0D57\u0D62\u0D63\u0D66-\u0D6F\u0D81-\u0D83\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2\u0DF3\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0E50-\u0E59\u0EB1\u0EB4-\u0EBC\u0EC8-\u0ECE\u0ED0-\u0ED9\u0F18\u0F19\u0F20-\u0F29\u0F35\u0F37\u0F39\u0F3E\u0F3F\u0F71-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102B-\u103E\u1040-\u1049\u1056-\u1059\u105E-\u1060\u1062-\u1064\u1067-\u106D\u1071-\u1074\u1082-\u108D\u108F-\u109D\u135D-\u135F\u1369-\u1371\u1712-\u1715\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4-\u17D3\u17DD\u17E0-\u17E9\u180B-\u180D\u180F-\u1819\u18A9\u1920-\u192B\u1930-\u193B\u1946-\u194F\u19D0-\u19DA\u1A17-\u1A1B\u1A55-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AB0-\u1ABD\u1ABF-\u1ACE\u1B00-\u1B04\u1B34-\u1B44\u1B50-\u1B59\u1B6B-\u1B73\u1B80-\u1B82\u1BA1-\u1BAD\u1BB0-\u1BB9\u1BE6-\u1BF3\u1C24-\u1C37\u1C40-\u1C49\u1C50-\u1C59\u1CD0-\u1CD2\u1CD4-\u1CE8\u1CED\u1CF4\u1CF7-\u1CF9\u1DC0-\u1DFF\u203F\u2040\u2054\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\uA620-\uA629\uA66F\uA674-\uA67D\uA69E\uA69F\uA6F0\uA6F1\uA802\uA806\uA80B\uA823-\uA827\uA82C\uA880\uA881\uA8B4-\uA8C5\uA8D0-\uA8D9\uA8E0-\uA8F1\uA8FF-\uA909\uA926-\uA92D\uA947-\uA953\uA980-\uA983\uA9B3-\uA9C0\uA9D0-\uA9D9\uA9E5\uA9F0-\uA9F9\uAA29-\uAA36\uAA43\uAA4C\uAA4D\uAA50-\uAA59\uAA7B-\uAA7D\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEB-\uAAEF\uAAF5\uAAF6\uABE3-\uABEA\uABEC\uABED\uABF0-\uABF9\uFB1E\uFE00-\uFE0F\uFE20-\uFE2F\uFE33\uFE34\uFE4D-\uFE4F\uFF10-\uFF19\uFF3F";
        var nonASCIIidentifierStart = new RegExp("[" + nonASCIIidentifierStartChars + "]");
        var nonASCIIidentifier = new RegExp("[" + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "]");
        nonASCIIidentifierStartChars = nonASCIIidentifierChars = null;
        var astralIdentifierStartCodes = [0, 11, 2, 25, 2, 18, 2, 1, 2, 14, 3, 13, 35, 122, 70, 52, 268, 28, 4, 48, 48, 31, 14, 29, 6, 37, 11, 29, 3, 35, 5, 7, 2, 4, 43, 157, 19, 35, 5, 35, 5, 39, 9, 51, 13, 10, 2, 14, 2, 6, 2, 1, 2, 10, 2, 14, 2, 6, 2, 1, 68, 310, 10, 21, 11, 7, 25, 5, 2, 41, 2, 8, 70, 5, 3, 0, 2, 43, 2, 1, 4, 0, 3, 22, 11, 22, 10, 30, 66, 18, 2, 1, 11, 21, 11, 25, 71, 55, 7, 1, 65, 0, 16, 3, 2, 2, 2, 28, 43, 28, 4, 28, 36, 7, 2, 27, 28, 53, 11, 21, 11, 18, 14, 17, 111, 72, 56, 50, 14, 50, 14, 35, 349, 41, 7, 1, 79, 28, 11, 0, 9, 21, 43, 17, 47, 20, 28, 22, 13, 52, 58, 1, 3, 0, 14, 44, 33, 24, 27, 35, 30, 0, 3, 0, 9, 34, 4, 0, 13, 47, 15, 3, 22, 0, 2, 0, 36, 17, 2, 24, 20, 1, 64, 6, 2, 0, 2, 3, 2, 14, 2, 9, 8, 46, 39, 7, 3, 1, 3, 21, 2, 6, 2, 1, 2, 4, 4, 0, 19, 0, 13, 4, 159, 52, 19, 3, 21, 2, 31, 47, 21, 1, 2, 0, 185, 46, 42, 3, 37, 47, 21, 0, 60, 42, 14, 0, 72, 26, 38, 6, 186, 43, 117, 63, 32, 7, 3, 0, 3, 7, 2, 1, 2, 23, 16, 0, 2, 0, 95, 7, 3, 38, 17, 0, 2, 0, 29, 0, 11, 39, 8, 0, 22, 0, 12, 45, 20, 0, 19, 72, 264, 8, 2, 36, 18, 0, 50, 29, 113, 6, 2, 1, 2, 37, 22, 0, 26, 5, 2, 1, 2, 31, 15, 0, 328, 18, 16, 0, 2, 12, 2, 33, 125, 0, 80, 921, 103, 110, 18, 195, 2637, 96, 16, 1071, 18, 5, 4026, 582, 8634, 568, 8, 30, 18, 78, 18, 29, 19, 47, 17, 3, 32, 20, 6, 18, 689, 63, 129, 74, 6, 0, 67, 12, 65, 1, 2, 0, 29, 6135, 9, 1237, 43, 8, 8936, 3, 2, 6, 2, 1, 2, 290, 16, 0, 30, 2, 3, 0, 15, 3, 9, 395, 2309, 106, 6, 12, 4, 8, 8, 9, 5991, 84, 2, 70, 2, 1, 3, 0, 3, 1, 3, 3, 2, 11, 2, 0, 2, 6, 2, 64, 2, 3, 3, 7, 2, 6, 2, 27, 2, 3, 2, 4, 2, 0, 4, 6, 2, 339, 3, 24, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 7, 1845, 30, 7, 5, 262, 61, 147, 44, 11, 6, 17, 0, 322, 29, 19, 43, 485, 27, 757, 6, 2, 3, 2, 1, 2, 14, 2, 196, 60, 67, 8, 0, 1205, 3, 2, 26, 2, 1, 2, 0, 3, 0, 2, 9, 2, 3, 2, 0, 2, 0, 7, 0, 5, 0, 2, 0, 2, 0, 2, 2, 2, 1, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 1, 2, 0, 3, 3, 2, 6, 2, 3, 2, 3, 2, 0, 2, 9, 2, 16, 6, 2, 2, 4, 2, 16, 4421, 42719, 33, 4153, 7, 221, 3, 5761, 15, 7472, 3104, 541, 1507, 4938, 6, 4191];
        var astralIdentifierCodes = [509, 0, 227, 0, 150, 4, 294, 9, 1368, 2, 2, 1, 6, 3, 41, 2, 5, 0, 166, 1, 574, 3, 9, 9, 370, 1, 81, 2, 71, 10, 50, 3, 123, 2, 54, 14, 32, 10, 3, 1, 11, 3, 46, 10, 8, 0, 46, 9, 7, 2, 37, 13, 2, 9, 6, 1, 45, 0, 13, 2, 49, 13, 9, 3, 2, 11, 83, 11, 7, 0, 3, 0, 158, 11, 6, 9, 7, 3, 56, 1, 2, 6, 3, 1, 3, 2, 10, 0, 11, 1, 3, 6, 4, 4, 193, 17, 10, 9, 5, 0, 82, 19, 13, 9, 214, 6, 3, 8, 28, 1, 83, 16, 16, 9, 82, 12, 9, 9, 84, 14, 5, 9, 243, 14, 166, 9, 71, 5, 2, 1, 3, 3, 2, 0, 2, 1, 13, 9, 120, 6, 3, 6, 4, 0, 29, 9, 41, 6, 2, 3, 9, 0, 10, 10, 47, 15, 406, 7, 2, 7, 17, 9, 57, 21, 2, 13, 123, 5, 4, 0, 2, 1, 2, 6, 2, 0, 9, 9, 49, 4, 2, 1, 2, 4, 9, 9, 330, 3, 10, 1, 2, 0, 49, 6, 4, 4, 14, 9, 5351, 0, 7, 14, 13835, 9, 87, 9, 39, 4, 60, 6, 26, 9, 1014, 0, 2, 54, 8, 3, 82, 0, 12, 1, 19628, 1, 4706, 45, 3, 22, 543, 4, 4, 5, 9, 7, 3, 6, 31, 3, 149, 2, 1418, 49, 513, 54, 5, 49, 9, 0, 15, 0, 23, 4, 2, 14, 1361, 6, 2, 16, 3, 6, 2, 1, 2, 4, 101, 0, 161, 6, 10, 9, 357, 0, 62, 13, 499, 13, 983, 6, 110, 6, 6, 9, 4759, 9, 787719, 239];
        function isInAstralSet(code, set) {
          let pos = 65536;
          for (let i = 0, length = set.length; i < length; i += 2) {
            pos += set[i];
            if (pos > code)
              return false;
            pos += set[i + 1];
            if (pos >= code)
              return true;
          }
          return false;
        }
        function isIdentifierStart(code) {
          if (code < 65)
            return code === 36;
          if (code <= 90)
            return true;
          if (code < 97)
            return code === 95;
          if (code <= 122)
            return true;
          if (code <= 65535) {
            return code >= 170 && nonASCIIidentifierStart.test(String.fromCharCode(code));
          }
          return isInAstralSet(code, astralIdentifierStartCodes);
        }
        function isIdentifierChar(code) {
          if (code < 48)
            return code === 36;
          if (code < 58)
            return true;
          if (code < 65)
            return false;
          if (code <= 90)
            return true;
          if (code < 97)
            return code === 95;
          if (code <= 122)
            return true;
          if (code <= 65535) {
            return code >= 170 && nonASCIIidentifier.test(String.fromCharCode(code));
          }
          return isInAstralSet(code, astralIdentifierStartCodes) || isInAstralSet(code, astralIdentifierCodes);
        }
        function isIdentifierName(name) {
          let isFirst = true;
          for (let i = 0; i < name.length; i++) {
            let cp = name.charCodeAt(i);
            if ((cp & 64512) === 55296 && i + 1 < name.length) {
              const trail = name.charCodeAt(++i);
              if ((trail & 64512) === 56320) {
                cp = 65536 + ((cp & 1023) << 10) + (trail & 1023);
              }
            }
            if (isFirst) {
              isFirst = false;
              if (!isIdentifierStart(cp)) {
                return false;
              }
            } else if (!isIdentifierChar(cp)) {
              return false;
            }
          }
          return !isFirst;
        }
      }
    });
    var require_keyword = __commonJS2({
      "node_modules/@babel/helper-validator-identifier/lib/keyword.js"(exports2) {
        "use strict";
        Object.defineProperty(exports2, "__esModule", {
          value: true
        });
        exports2.isKeyword = isKeyword;
        exports2.isReservedWord = isReservedWord;
        exports2.isStrictBindOnlyReservedWord = isStrictBindOnlyReservedWord;
        exports2.isStrictBindReservedWord = isStrictBindReservedWord;
        exports2.isStrictReservedWord = isStrictReservedWord;
        var reservedWords = {
          keyword: ["break", "case", "catch", "continue", "debugger", "default", "do", "else", "finally", "for", "function", "if", "return", "switch", "throw", "try", "var", "const", "while", "with", "new", "this", "super", "class", "extends", "export", "import", "null", "true", "false", "in", "instanceof", "typeof", "void", "delete"],
          strict: ["implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"],
          strictBind: ["eval", "arguments"]
        };
        var keywords = new Set(reservedWords.keyword);
        var reservedWordsStrictSet = new Set(reservedWords.strict);
        var reservedWordsStrictBindSet = new Set(reservedWords.strictBind);
        function isReservedWord(word, inModule) {
          return inModule && word === "await" || word === "enum";
        }
        function isStrictReservedWord(word, inModule) {
          return isReservedWord(word, inModule) || reservedWordsStrictSet.has(word);
        }
        function isStrictBindOnlyReservedWord(word) {
          return reservedWordsStrictBindSet.has(word);
        }
        function isStrictBindReservedWord(word, inModule) {
          return isStrictReservedWord(word, inModule) || isStrictBindOnlyReservedWord(word);
        }
        function isKeyword(word) {
          return keywords.has(word);
        }
      }
    });
    var require_lib8 = __commonJS2({
      "node_modules/@babel/helper-validator-identifier/lib/index.js"(exports2) {
        "use strict";
        Object.defineProperty(exports2, "__esModule", {
          value: true
        });
        Object.defineProperty(exports2, "isIdentifierChar", {
          enumerable: true,
          get: function() {
            return _identifier.isIdentifierChar;
          }
        });
        Object.defineProperty(exports2, "isIdentifierName", {
          enumerable: true,
          get: function() {
            return _identifier.isIdentifierName;
          }
        });
        Object.defineProperty(exports2, "isIdentifierStart", {
          enumerable: true,
          get: function() {
            return _identifier.isIdentifierStart;
          }
        });
        Object.defineProperty(exports2, "isKeyword", {
          enumerable: true,
          get: function() {
            return _keyword.isKeyword;
          }
        });
        Object.defineProperty(exports2, "isReservedWord", {
          enumerable: true,
          get: function() {
            return _keyword.isReservedWord;
          }
        });
        Object.defineProperty(exports2, "isStrictBindOnlyReservedWord", {
          enumerable: true,
          get: function() {
            return _keyword.isStrictBindOnlyReservedWord;
          }
        });
        Object.defineProperty(exports2, "isStrictBindReservedWord", {
          enumerable: true,
          get: function() {
            return _keyword.isStrictBindReservedWord;
          }
        });
        Object.defineProperty(exports2, "isStrictReservedWord", {
          enumerable: true,
          get: function() {
            return _keyword.isStrictReservedWord;
          }
        });
        var _identifier = require_identifier();
        var _keyword = require_keyword();
      }
    });
    var require_escape_string_regexp = __commonJS2({
      "node_modules/@babel/highlight/node_modules/escape-string-regexp/index.js"(exports2, module22) {
        "use strict";
        var matchOperatorsRe = /[|\\{}()[\]^$+*?.]/g;
        module22.exports = function(str) {
          if (typeof str !== "string") {
            throw new TypeError("Expected a string");
          }
          return str.replace(matchOperatorsRe, "\\$&");
        };
      }
    });
    var require_color_name = __commonJS2({
      "node_modules/color-name/index.js"(exports2, module22) {
        "use strict";
        module22.exports = {
          "aliceblue": [240, 248, 255],
          "antiquewhite": [250, 235, 215],
          "aqua": [0, 255, 255],
          "aquamarine": [127, 255, 212],
          "azure": [240, 255, 255],
          "beige": [245, 245, 220],
          "bisque": [255, 228, 196],
          "black": [0, 0, 0],
          "blanchedalmond": [255, 235, 205],
          "blue": [0, 0, 255],
          "blueviolet": [138, 43, 226],
          "brown": [165, 42, 42],
          "burlywood": [222, 184, 135],
          "cadetblue": [95, 158, 160],
          "chartreuse": [127, 255, 0],
          "chocolate": [210, 105, 30],
          "coral": [255, 127, 80],
          "cornflowerblue": [100, 149, 237],
          "cornsilk": [255, 248, 220],
          "crimson": [220, 20, 60],
          "cyan": [0, 255, 255],
          "darkblue": [0, 0, 139],
          "darkcyan": [0, 139, 139],
          "darkgoldenrod": [184, 134, 11],
          "darkgray": [169, 169, 169],
          "darkgreen": [0, 100, 0],
          "darkgrey": [169, 169, 169],
          "darkkhaki": [189, 183, 107],
          "darkmagenta": [139, 0, 139],
          "darkolivegreen": [85, 107, 47],
          "darkorange": [255, 140, 0],
          "darkorchid": [153, 50, 204],
          "darkred": [139, 0, 0],
          "darksalmon": [233, 150, 122],
          "darkseagreen": [143, 188, 143],
          "darkslateblue": [72, 61, 139],
          "darkslategray": [47, 79, 79],
          "darkslategrey": [47, 79, 79],
          "darkturquoise": [0, 206, 209],
          "darkviolet": [148, 0, 211],
          "deeppink": [255, 20, 147],
          "deepskyblue": [0, 191, 255],
          "dimgray": [105, 105, 105],
          "dimgrey": [105, 105, 105],
          "dodgerblue": [30, 144, 255],
          "firebrick": [178, 34, 34],
          "floralwhite": [255, 250, 240],
          "forestgreen": [34, 139, 34],
          "fuchsia": [255, 0, 255],
          "gainsboro": [220, 220, 220],
          "ghostwhite": [248, 248, 255],
          "gold": [255, 215, 0],
          "goldenrod": [218, 165, 32],
          "gray": [128, 128, 128],
          "green": [0, 128, 0],
          "greenyellow": [173, 255, 47],
          "grey": [128, 128, 128],
          "honeydew": [240, 255, 240],
          "hotpink": [255, 105, 180],
          "indianred": [205, 92, 92],
          "indigo": [75, 0, 130],
          "ivory": [255, 255, 240],
          "khaki": [240, 230, 140],
          "lavender": [230, 230, 250],
          "lavenderblush": [255, 240, 245],
          "lawngreen": [124, 252, 0],
          "lemonchiffon": [255, 250, 205],
          "lightblue": [173, 216, 230],
          "lightcoral": [240, 128, 128],
          "lightcyan": [224, 255, 255],
          "lightgoldenrodyellow": [250, 250, 210],
          "lightgray": [211, 211, 211],
          "lightgreen": [144, 238, 144],
          "lightgrey": [211, 211, 211],
          "lightpink": [255, 182, 193],
          "lightsalmon": [255, 160, 122],
          "lightseagreen": [32, 178, 170],
          "lightskyblue": [135, 206, 250],
          "lightslategray": [119, 136, 153],
          "lightslategrey": [119, 136, 153],
          "lightsteelblue": [176, 196, 222],
          "lightyellow": [255, 255, 224],
          "lime": [0, 255, 0],
          "limegreen": [50, 205, 50],
          "linen": [250, 240, 230],
          "magenta": [255, 0, 255],
          "maroon": [128, 0, 0],
          "mediumaquamarine": [102, 205, 170],
          "mediumblue": [0, 0, 205],
          "mediumorchid": [186, 85, 211],
          "mediumpurple": [147, 112, 219],
          "mediumseagreen": [60, 179, 113],
          "mediumslateblue": [123, 104, 238],
          "mediumspringgreen": [0, 250, 154],
          "mediumturquoise": [72, 209, 204],
          "mediumvioletred": [199, 21, 133],
          "midnightblue": [25, 25, 112],
          "mintcream": [245, 255, 250],
          "mistyrose": [255, 228, 225],
          "moccasin": [255, 228, 181],
          "navajowhite": [255, 222, 173],
          "navy": [0, 0, 128],
          "oldlace": [253, 245, 230],
          "olive": [128, 128, 0],
          "olivedrab": [107, 142, 35],
          "orange": [255, 165, 0],
          "orangered": [255, 69, 0],
          "orchid": [218, 112, 214],
          "palegoldenrod": [238, 232, 170],
          "palegreen": [152, 251, 152],
          "paleturquoise": [175, 238, 238],
          "palevioletred": [219, 112, 147],
          "papayawhip": [255, 239, 213],
          "peachpuff": [255, 218, 185],
          "peru": [205, 133, 63],
          "pink": [255, 192, 203],
          "plum": [221, 160, 221],
          "powderblue": [176, 224, 230],
          "purple": [128, 0, 128],
          "rebeccapurple": [102, 51, 153],
          "red": [255, 0, 0],
          "rosybrown": [188, 143, 143],
          "royalblue": [65, 105, 225],
          "saddlebrown": [139, 69, 19],
          "salmon": [250, 128, 114],
          "sandybrown": [244, 164, 96],
          "seagreen": [46, 139, 87],
          "seashell": [255, 245, 238],
          "sienna": [160, 82, 45],
          "silver": [192, 192, 192],
          "skyblue": [135, 206, 235],
          "slateblue": [106, 90, 205],
          "slategray": [112, 128, 144],
          "slategrey": [112, 128, 144],
          "snow": [255, 250, 250],
          "springgreen": [0, 255, 127],
          "steelblue": [70, 130, 180],
          "tan": [210, 180, 140],
          "teal": [0, 128, 128],
          "thistle": [216, 191, 216],
          "tomato": [255, 99, 71],
          "turquoise": [64, 224, 208],
          "violet": [238, 130, 238],
          "wheat": [245, 222, 179],
          "white": [255, 255, 255],
          "whitesmoke": [245, 245, 245],
          "yellow": [255, 255, 0],
          "yellowgreen": [154, 205, 50]
        };
      }
    });
    var require_conversions = __commonJS2({
      "node_modules/color-convert/conversions.js"(exports2, module22) {
        var cssKeywords = require_color_name();
        var reverseKeywords = {};
        for (key in cssKeywords) {
          if (cssKeywords.hasOwnProperty(key)) {
            reverseKeywords[cssKeywords[key]] = key;
          }
        }
        var key;
        var convert = module22.exports = {
          rgb: {
            channels: 3,
            labels: "rgb"
          },
          hsl: {
            channels: 3,
            labels: "hsl"
          },
          hsv: {
            channels: 3,
            labels: "hsv"
          },
          hwb: {
            channels: 3,
            labels: "hwb"
          },
          cmyk: {
            channels: 4,
            labels: "cmyk"
          },
          xyz: {
            channels: 3,
            labels: "xyz"
          },
          lab: {
            channels: 3,
            labels: "lab"
          },
          lch: {
            channels: 3,
            labels: "lch"
          },
          hex: {
            channels: 1,
            labels: ["hex"]
          },
          keyword: {
            channels: 1,
            labels: ["keyword"]
          },
          ansi16: {
            channels: 1,
            labels: ["ansi16"]
          },
          ansi256: {
            channels: 1,
            labels: ["ansi256"]
          },
          hcg: {
            channels: 3,
            labels: ["h", "c", "g"]
          },
          apple: {
            channels: 3,
            labels: ["r16", "g16", "b16"]
          },
          gray: {
            channels: 1,
            labels: ["gray"]
          }
        };
        for (model in convert) {
          if (convert.hasOwnProperty(model)) {
            if (!("channels" in convert[model])) {
              throw new Error("missing channels property: " + model);
            }
            if (!("labels" in convert[model])) {
              throw new Error("missing channel labels property: " + model);
            }
            if (convert[model].labels.length !== convert[model].channels) {
              throw new Error("channel and label counts mismatch: " + model);
            }
            channels = convert[model].channels;
            labels = convert[model].labels;
            delete convert[model].channels;
            delete convert[model].labels;
            Object.defineProperty(convert[model], "channels", {
              value: channels
            });
            Object.defineProperty(convert[model], "labels", {
              value: labels
            });
          }
        }
        var channels;
        var labels;
        var model;
        convert.rgb.hsl = function(rgb) {
          var r = rgb[0] / 255;
          var g = rgb[1] / 255;
          var b = rgb[2] / 255;
          var min = Math.min(r, g, b);
          var max = Math.max(r, g, b);
          var delta = max - min;
          var h;
          var s;
          var l;
          if (max === min) {
            h = 0;
          } else if (r === max) {
            h = (g - b) / delta;
          } else if (g === max) {
            h = 2 + (b - r) / delta;
          } else if (b === max) {
            h = 4 + (r - g) / delta;
          }
          h = Math.min(h * 60, 360);
          if (h < 0) {
            h += 360;
          }
          l = (min + max) / 2;
          if (max === min) {
            s = 0;
          } else if (l <= 0.5) {
            s = delta / (max + min);
          } else {
            s = delta / (2 - max - min);
          }
          return [h, s * 100, l * 100];
        };
        convert.rgb.hsv = function(rgb) {
          var rdif;
          var gdif;
          var bdif;
          var h;
          var s;
          var r = rgb[0] / 255;
          var g = rgb[1] / 255;
          var b = rgb[2] / 255;
          var v = Math.max(r, g, b);
          var diff = v - Math.min(r, g, b);
          var diffc = function(c) {
            return (v - c) / 6 / diff + 1 / 2;
          };
          if (diff === 0) {
            h = s = 0;
          } else {
            s = diff / v;
            rdif = diffc(r);
            gdif = diffc(g);
            bdif = diffc(b);
            if (r === v) {
              h = bdif - gdif;
            } else if (g === v) {
              h = 1 / 3 + rdif - bdif;
            } else if (b === v) {
              h = 2 / 3 + gdif - rdif;
            }
            if (h < 0) {
              h += 1;
            } else if (h > 1) {
              h -= 1;
            }
          }
          return [h * 360, s * 100, v * 100];
        };
        convert.rgb.hwb = function(rgb) {
          var r = rgb[0];
          var g = rgb[1];
          var b = rgb[2];
          var h = convert.rgb.hsl(rgb)[0];
          var w = 1 / 255 * Math.min(r, Math.min(g, b));
          b = 1 - 1 / 255 * Math.max(r, Math.max(g, b));
          return [h, w * 100, b * 100];
        };
        convert.rgb.cmyk = function(rgb) {
          var r = rgb[0] / 255;
          var g = rgb[1] / 255;
          var b = rgb[2] / 255;
          var c;
          var m;
          var y;
          var k;
          k = Math.min(1 - r, 1 - g, 1 - b);
          c = (1 - r - k) / (1 - k) || 0;
          m = (1 - g - k) / (1 - k) || 0;
          y = (1 - b - k) / (1 - k) || 0;
          return [c * 100, m * 100, y * 100, k * 100];
        };
        function comparativeDistance(x, y) {
          return Math.pow(x[0] - y[0], 2) + Math.pow(x[1] - y[1], 2) + Math.pow(x[2] - y[2], 2);
        }
        convert.rgb.keyword = function(rgb) {
          var reversed = reverseKeywords[rgb];
          if (reversed) {
            return reversed;
          }
          var currentClosestDistance = Infinity;
          var currentClosestKeyword;
          for (var keyword in cssKeywords) {
            if (cssKeywords.hasOwnProperty(keyword)) {
              var value = cssKeywords[keyword];
              var distance = comparativeDistance(rgb, value);
              if (distance < currentClosestDistance) {
                currentClosestDistance = distance;
                currentClosestKeyword = keyword;
              }
            }
          }
          return currentClosestKeyword;
        };
        convert.keyword.rgb = function(keyword) {
          return cssKeywords[keyword];
        };
        convert.rgb.xyz = function(rgb) {
          var r = rgb[0] / 255;
          var g = rgb[1] / 255;
          var b = rgb[2] / 255;
          r = r > 0.04045 ? Math.pow((r + 0.055) / 1.055, 2.4) : r / 12.92;
          g = g > 0.04045 ? Math.pow((g + 0.055) / 1.055, 2.4) : g / 12.92;
          b = b > 0.04045 ? Math.pow((b + 0.055) / 1.055, 2.4) : b / 12.92;
          var x = r * 0.4124 + g * 0.3576 + b * 0.1805;
          var y = r * 0.2126 + g * 0.7152 + b * 0.0722;
          var z = r * 0.0193 + g * 0.1192 + b * 0.9505;
          return [x * 100, y * 100, z * 100];
        };
        convert.rgb.lab = function(rgb) {
          var xyz = convert.rgb.xyz(rgb);
          var x = xyz[0];
          var y = xyz[1];
          var z = xyz[2];
          var l;
          var a;
          var b;
          x /= 95.047;
          y /= 100;
          z /= 108.883;
          x = x > 8856e-6 ? Math.pow(x, 1 / 3) : 7.787 * x + 16 / 116;
          y = y > 8856e-6 ? Math.pow(y, 1 / 3) : 7.787 * y + 16 / 116;
          z = z > 8856e-6 ? Math.pow(z, 1 / 3) : 7.787 * z + 16 / 116;
          l = 116 * y - 16;
          a = 500 * (x - y);
          b = 200 * (y - z);
          return [l, a, b];
        };
        convert.hsl.rgb = function(hsl) {
          var h = hsl[0] / 360;
          var s = hsl[1] / 100;
          var l = hsl[2] / 100;
          var t1;
          var t2;
          var t3;
          var rgb;
          var val;
          if (s === 0) {
            val = l * 255;
            return [val, val, val];
          }
          if (l < 0.5) {
            t2 = l * (1 + s);
          } else {
            t2 = l + s - l * s;
          }
          t1 = 2 * l - t2;
          rgb = [0, 0, 0];
          for (var i = 0; i < 3; i++) {
            t3 = h + 1 / 3 * -(i - 1);
            if (t3 < 0) {
              t3++;
            }
            if (t3 > 1) {
              t3--;
            }
            if (6 * t3 < 1) {
              val = t1 + (t2 - t1) * 6 * t3;
            } else if (2 * t3 < 1) {
              val = t2;
            } else if (3 * t3 < 2) {
              val = t1 + (t2 - t1) * (2 / 3 - t3) * 6;
            } else {
              val = t1;
            }
            rgb[i] = val * 255;
          }
          return rgb;
        };
        convert.hsl.hsv = function(hsl) {
          var h = hsl[0];
          var s = hsl[1] / 100;
          var l = hsl[2] / 100;
          var smin = s;
          var lmin = Math.max(l, 0.01);
          var sv;
          var v;
          l *= 2;
          s *= l <= 1 ? l : 2 - l;
          smin *= lmin <= 1 ? lmin : 2 - lmin;
          v = (l + s) / 2;
          sv = l === 0 ? 2 * smin / (lmin + smin) : 2 * s / (l + s);
          return [h, sv * 100, v * 100];
        };
        convert.hsv.rgb = function(hsv) {
          var h = hsv[0] / 60;
          var s = hsv[1] / 100;
          var v = hsv[2] / 100;
          var hi = Math.floor(h) % 6;
          var f = h - Math.floor(h);
          var p = 255 * v * (1 - s);
          var q = 255 * v * (1 - s * f);
          var t = 255 * v * (1 - s * (1 - f));
          v *= 255;
          switch (hi) {
            case 0:
              return [v, t, p];
            case 1:
              return [q, v, p];
            case 2:
              return [p, v, t];
            case 3:
              return [p, q, v];
            case 4:
              return [t, p, v];
            case 5:
              return [v, p, q];
          }
        };
        convert.hsv.hsl = function(hsv) {
          var h = hsv[0];
          var s = hsv[1] / 100;
          var v = hsv[2] / 100;
          var vmin = Math.max(v, 0.01);
          var lmin;
          var sl;
          var l;
          l = (2 - s) * v;
          lmin = (2 - s) * vmin;
          sl = s * vmin;
          sl /= lmin <= 1 ? lmin : 2 - lmin;
          sl = sl || 0;
          l /= 2;
          return [h, sl * 100, l * 100];
        };
        convert.hwb.rgb = function(hwb) {
          var h = hwb[0] / 360;
          var wh = hwb[1] / 100;
          var bl = hwb[2] / 100;
          var ratio = wh + bl;
          var i;
          var v;
          var f;
          var n2;
          if (ratio > 1) {
            wh /= ratio;
            bl /= ratio;
          }
          i = Math.floor(6 * h);
          v = 1 - bl;
          f = 6 * h - i;
          if ((i & 1) !== 0) {
            f = 1 - f;
          }
          n2 = wh + f * (v - wh);
          var r;
          var g;
          var b;
          switch (i) {
            default:
            case 6:
            case 0:
              r = v;
              g = n2;
              b = wh;
              break;
            case 1:
              r = n2;
              g = v;
              b = wh;
              break;
            case 2:
              r = wh;
              g = v;
              b = n2;
              break;
            case 3:
              r = wh;
              g = n2;
              b = v;
              break;
            case 4:
              r = n2;
              g = wh;
              b = v;
              break;
            case 5:
              r = v;
              g = wh;
              b = n2;
              break;
          }
          return [r * 255, g * 255, b * 255];
        };
        convert.cmyk.rgb = function(cmyk) {
          var c = cmyk[0] / 100;
          var m = cmyk[1] / 100;
          var y = cmyk[2] / 100;
          var k = cmyk[3] / 100;
          var r;
          var g;
          var b;
          r = 1 - Math.min(1, c * (1 - k) + k);
          g = 1 - Math.min(1, m * (1 - k) + k);
          b = 1 - Math.min(1, y * (1 - k) + k);
          return [r * 255, g * 255, b * 255];
        };
        convert.xyz.rgb = function(xyz) {
          var x = xyz[0] / 100;
          var y = xyz[1] / 100;
          var z = xyz[2] / 100;
          var r;
          var g;
          var b;
          r = x * 3.2406 + y * -1.5372 + z * -0.4986;
          g = x * -0.9689 + y * 1.8758 + z * 0.0415;
          b = x * 0.0557 + y * -0.204 + z * 1.057;
          r = r > 31308e-7 ? 1.055 * Math.pow(r, 1 / 2.4) - 0.055 : r * 12.92;
          g = g > 31308e-7 ? 1.055 * Math.pow(g, 1 / 2.4) - 0.055 : g * 12.92;
          b = b > 31308e-7 ? 1.055 * Math.pow(b, 1 / 2.4) - 0.055 : b * 12.92;
          r = Math.min(Math.max(0, r), 1);
          g = Math.min(Math.max(0, g), 1);
          b = Math.min(Math.max(0, b), 1);
          return [r * 255, g * 255, b * 255];
        };
        convert.xyz.lab = function(xyz) {
          var x = xyz[0];
          var y = xyz[1];
          var z = xyz[2];
          var l;
          var a;
          var b;
          x /= 95.047;
          y /= 100;
          z /= 108.883;
          x = x > 8856e-6 ? Math.pow(x, 1 / 3) : 7.787 * x + 16 / 116;
          y = y > 8856e-6 ? Math.pow(y, 1 / 3) : 7.787 * y + 16 / 116;
          z = z > 8856e-6 ? Math.pow(z, 1 / 3) : 7.787 * z + 16 / 116;
          l = 116 * y - 16;
          a = 500 * (x - y);
          b = 200 * (y - z);
          return [l, a, b];
        };
        convert.lab.xyz = function(lab) {
          var l = lab[0];
          var a = lab[1];
          var b = lab[2];
          var x;
          var y;
          var z;
          y = (l + 16) / 116;
          x = a / 500 + y;
          z = y - b / 200;
          var y2 = Math.pow(y, 3);
          var x2 = Math.pow(x, 3);
          var z2 = Math.pow(z, 3);
          y = y2 > 8856e-6 ? y2 : (y - 16 / 116) / 7.787;
          x = x2 > 8856e-6 ? x2 : (x - 16 / 116) / 7.787;
          z = z2 > 8856e-6 ? z2 : (z - 16 / 116) / 7.787;
          x *= 95.047;
          y *= 100;
          z *= 108.883;
          return [x, y, z];
        };
        convert.lab.lch = function(lab) {
          var l = lab[0];
          var a = lab[1];
          var b = lab[2];
          var hr;
          var h;
          var c;
          hr = Math.atan2(b, a);
          h = hr * 360 / 2 / Math.PI;
          if (h < 0) {
            h += 360;
          }
          c = Math.sqrt(a * a + b * b);
          return [l, c, h];
        };
        convert.lch.lab = function(lch) {
          var l = lch[0];
          var c = lch[1];
          var h = lch[2];
          var a;
          var b;
          var hr;
          hr = h / 360 * 2 * Math.PI;
          a = c * Math.cos(hr);
          b = c * Math.sin(hr);
          return [l, a, b];
        };
        convert.rgb.ansi16 = function(args) {
          var r = args[0];
          var g = args[1];
          var b = args[2];
          var value = 1 in arguments ? arguments[1] : convert.rgb.hsv(args)[2];
          value = Math.round(value / 50);
          if (value === 0) {
            return 30;
          }
          var ansi = 30 + (Math.round(b / 255) << 2 | Math.round(g / 255) << 1 | Math.round(r / 255));
          if (value === 2) {
            ansi += 60;
          }
          return ansi;
        };
        convert.hsv.ansi16 = function(args) {
          return convert.rgb.ansi16(convert.hsv.rgb(args), args[2]);
        };
        convert.rgb.ansi256 = function(args) {
          var r = args[0];
          var g = args[1];
          var b = args[2];
          if (r === g && g === b) {
            if (r < 8) {
              return 16;
            }
            if (r > 248) {
              return 231;
            }
            return Math.round((r - 8) / 247 * 24) + 232;
          }
          var ansi = 16 + 36 * Math.round(r / 255 * 5) + 6 * Math.round(g / 255 * 5) + Math.round(b / 255 * 5);
          return ansi;
        };
        convert.ansi16.rgb = function(args) {
          var color = args % 10;
          if (color === 0 || color === 7) {
            if (args > 50) {
              color += 3.5;
            }
            color = color / 10.5 * 255;
            return [color, color, color];
          }
          var mult = (~~(args > 50) + 1) * 0.5;
          var r = (color & 1) * mult * 255;
          var g = (color >> 1 & 1) * mult * 255;
          var b = (color >> 2 & 1) * mult * 255;
          return [r, g, b];
        };
        convert.ansi256.rgb = function(args) {
          if (args >= 232) {
            var c = (args - 232) * 10 + 8;
            return [c, c, c];
          }
          args -= 16;
          var rem;
          var r = Math.floor(args / 36) / 5 * 255;
          var g = Math.floor((rem = args % 36) / 6) / 5 * 255;
          var b = rem % 6 / 5 * 255;
          return [r, g, b];
        };
        convert.rgb.hex = function(args) {
          var integer = ((Math.round(args[0]) & 255) << 16) + ((Math.round(args[1]) & 255) << 8) + (Math.round(args[2]) & 255);
          var string = integer.toString(16).toUpperCase();
          return "000000".substring(string.length) + string;
        };
        convert.hex.rgb = function(args) {
          var match = args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);
          if (!match) {
            return [0, 0, 0];
          }
          var colorString = match[0];
          if (match[0].length === 3) {
            colorString = colorString.split("").map(function(char2) {
              return char2 + char2;
            }).join("");
          }
          var integer = parseInt(colorString, 16);
          var r = integer >> 16 & 255;
          var g = integer >> 8 & 255;
          var b = integer & 255;
          return [r, g, b];
        };
        convert.rgb.hcg = function(rgb) {
          var r = rgb[0] / 255;
          var g = rgb[1] / 255;
          var b = rgb[2] / 255;
          var max = Math.max(Math.max(r, g), b);
          var min = Math.min(Math.min(r, g), b);
          var chroma = max - min;
          var grayscale;
          var hue;
          if (chroma < 1) {
            grayscale = min / (1 - chroma);
          } else {
            grayscale = 0;
          }
          if (chroma <= 0) {
            hue = 0;
          } else if (max === r) {
            hue = (g - b) / chroma % 6;
          } else if (max === g) {
            hue = 2 + (b - r) / chroma;
          } else {
            hue = 4 + (r - g) / chroma + 4;
          }
          hue /= 6;
          hue %= 1;
          return [hue * 360, chroma * 100, grayscale * 100];
        };
        convert.hsl.hcg = function(hsl) {
          var s = hsl[1] / 100;
          var l = hsl[2] / 100;
          var c = 1;
          var f = 0;
          if (l < 0.5) {
            c = 2 * s * l;
          } else {
            c = 2 * s * (1 - l);
          }
          if (c < 1) {
            f = (l - 0.5 * c) / (1 - c);
          }
          return [hsl[0], c * 100, f * 100];
        };
        convert.hsv.hcg = function(hsv) {
          var s = hsv[1] / 100;
          var v = hsv[2] / 100;
          var c = s * v;
          var f = 0;
          if (c < 1) {
            f = (v - c) / (1 - c);
          }
          return [hsv[0], c * 100, f * 100];
        };
        convert.hcg.rgb = function(hcg) {
          var h = hcg[0] / 360;
          var c = hcg[1] / 100;
          var g = hcg[2] / 100;
          if (c === 0) {
            return [g * 255, g * 255, g * 255];
          }
          var pure = [0, 0, 0];
          var hi = h % 1 * 6;
          var v = hi % 1;
          var w = 1 - v;
          var mg = 0;
          switch (Math.floor(hi)) {
            case 0:
              pure[0] = 1;
              pure[1] = v;
              pure[2] = 0;
              break;
            case 1:
              pure[0] = w;
              pure[1] = 1;
              pure[2] = 0;
              break;
            case 2:
              pure[0] = 0;
              pure[1] = 1;
              pure[2] = v;
              break;
            case 3:
              pure[0] = 0;
              pure[1] = w;
              pure[2] = 1;
              break;
            case 4:
              pure[0] = v;
              pure[1] = 0;
              pure[2] = 1;
              break;
            default:
              pure[0] = 1;
              pure[1] = 0;
              pure[2] = w;
          }
          mg = (1 - c) * g;
          return [(c * pure[0] + mg) * 255, (c * pure[1] + mg) * 255, (c * pure[2] + mg) * 255];
        };
        convert.hcg.hsv = function(hcg) {
          var c = hcg[1] / 100;
          var g = hcg[2] / 100;
          var v = c + g * (1 - c);
          var f = 0;
          if (v > 0) {
            f = c / v;
          }
          return [hcg[0], f * 100, v * 100];
        };
        convert.hcg.hsl = function(hcg) {
          var c = hcg[1] / 100;
          var g = hcg[2] / 100;
          var l = g * (1 - c) + 0.5 * c;
          var s = 0;
          if (l > 0 && l < 0.5) {
            s = c / (2 * l);
          } else if (l >= 0.5 && l < 1) {
            s = c / (2 * (1 - l));
          }
          return [hcg[0], s * 100, l * 100];
        };
        convert.hcg.hwb = function(hcg) {
          var c = hcg[1] / 100;
          var g = hcg[2] / 100;
          var v = c + g * (1 - c);
          return [hcg[0], (v - c) * 100, (1 - v) * 100];
        };
        convert.hwb.hcg = function(hwb) {
          var w = hwb[1] / 100;
          var b = hwb[2] / 100;
          var v = 1 - b;
          var c = v - w;
          var g = 0;
          if (c < 1) {
            g = (v - c) / (1 - c);
          }
          return [hwb[0], c * 100, g * 100];
        };
        convert.apple.rgb = function(apple) {
          return [apple[0] / 65535 * 255, apple[1] / 65535 * 255, apple[2] / 65535 * 255];
        };
        convert.rgb.apple = function(rgb) {
          return [rgb[0] / 255 * 65535, rgb[1] / 255 * 65535, rgb[2] / 255 * 65535];
        };
        convert.gray.rgb = function(args) {
          return [args[0] / 100 * 255, args[0] / 100 * 255, args[0] / 100 * 255];
        };
        convert.gray.hsl = convert.gray.hsv = function(args) {
          return [0, 0, args[0]];
        };
        convert.gray.hwb = function(gray) {
          return [0, 100, gray[0]];
        };
        convert.gray.cmyk = function(gray) {
          return [0, 0, 0, gray[0]];
        };
        convert.gray.lab = function(gray) {
          return [gray[0], 0, 0];
        };
        convert.gray.hex = function(gray) {
          var val = Math.round(gray[0] / 100 * 255) & 255;
          var integer = (val << 16) + (val << 8) + val;
          var string = integer.toString(16).toUpperCase();
          return "000000".substring(string.length) + string;
        };
        convert.rgb.gray = function(rgb) {
          var val = (rgb[0] + rgb[1] + rgb[2]) / 3;
          return [val / 255 * 100];
        };
      }
    });
    var require_route = __commonJS2({
      "node_modules/color-convert/route.js"(exports2, module22) {
        var conversions = require_conversions();
        function buildGraph() {
          var graph = {};
          var models = Object.keys(conversions);
          for (var len = models.length, i = 0; i < len; i++) {
            graph[models[i]] = {
              distance: -1,
              parent: null
            };
          }
          return graph;
        }
        function deriveBFS(fromModel) {
          var graph = buildGraph();
          var queue = [fromModel];
          graph[fromModel].distance = 0;
          while (queue.length) {
            var current = queue.pop();
            var adjacents = Object.keys(conversions[current]);
            for (var len = adjacents.length, i = 0; i < len; i++) {
              var adjacent = adjacents[i];
              var node = graph[adjacent];
              if (node.distance === -1) {
                node.distance = graph[current].distance + 1;
                node.parent = current;
                queue.unshift(adjacent);
              }
            }
          }
          return graph;
        }
        function link(from, to) {
          return function(args) {
            return to(from(args));
          };
        }
        function wrapConversion(toModel, graph) {
          var path = [graph[toModel].parent, toModel];
          var fn = conversions[graph[toModel].parent][toModel];
          var cur = graph[toModel].parent;
          while (graph[cur].parent) {
            path.unshift(graph[cur].parent);
            fn = link(conversions[graph[cur].parent][cur], fn);
            cur = graph[cur].parent;
          }
          fn.conversion = path;
          return fn;
        }
        module22.exports = function(fromModel) {
          var graph = deriveBFS(fromModel);
          var conversion = {};
          var models = Object.keys(graph);
          for (var len = models.length, i = 0; i < len; i++) {
            var toModel = models[i];
            var node = graph[toModel];
            if (node.parent === null) {
              continue;
            }
            conversion[toModel] = wrapConversion(toModel, graph);
          }
          return conversion;
        };
      }
    });
    var require_color_convert = __commonJS2({
      "node_modules/color-convert/index.js"(exports2, module22) {
        var conversions = require_conversions();
        var route = require_route();
        var convert = {};
        var models = Object.keys(conversions);
        function wrapRaw(fn) {
          var wrappedFn = function(args) {
            if (args === void 0 || args === null) {
              return args;
            }
            if (arguments.length > 1) {
              args = Array.prototype.slice.call(arguments);
            }
            return fn(args);
          };
          if ("conversion" in fn) {
            wrappedFn.conversion = fn.conversion;
          }
          return wrappedFn;
        }
        function wrapRounded(fn) {
          var wrappedFn = function(args) {
            if (args === void 0 || args === null) {
              return args;
            }
            if (arguments.length > 1) {
              args = Array.prototype.slice.call(arguments);
            }
            var result = fn(args);
            if (typeof result === "object") {
              for (var len = result.length, i = 0; i < len; i++) {
                result[i] = Math.round(result[i]);
              }
            }
            return result;
          };
          if ("conversion" in fn) {
            wrappedFn.conversion = fn.conversion;
          }
          return wrappedFn;
        }
        models.forEach(function(fromModel) {
          convert[fromModel] = {};
          Object.defineProperty(convert[fromModel], "channels", {
            value: conversions[fromModel].channels
          });
          Object.defineProperty(convert[fromModel], "labels", {
            value: conversions[fromModel].labels
          });
          var routes = route(fromModel);
          var routeModels = Object.keys(routes);
          routeModels.forEach(function(toModel) {
            var fn = routes[toModel];
            convert[fromModel][toModel] = wrapRounded(fn);
            convert[fromModel][toModel].raw = wrapRaw(fn);
          });
        });
        module22.exports = convert;
      }
    });
    var require_ansi_styles = __commonJS2({
      "node_modules/ansi-styles/index.js"(exports2, module22) {
        "use strict";
        var colorConvert = require_color_convert();
        var wrapAnsi16 = (fn, offset) => function() {
          const code = fn.apply(colorConvert, arguments);
          return `\x1B[${code + offset}m`;
        };
        var wrapAnsi256 = (fn, offset) => function() {
          const code = fn.apply(colorConvert, arguments);
          return `\x1B[${38 + offset};5;${code}m`;
        };
        var wrapAnsi16m = (fn, offset) => function() {
          const rgb = fn.apply(colorConvert, arguments);
          return `\x1B[${38 + offset};2;${rgb[0]};${rgb[1]};${rgb[2]}m`;
        };
        function assembleStyles() {
          const codes = /* @__PURE__ */ new Map();
          const styles = {
            modifier: {
              reset: [0, 0],
              bold: [1, 22],
              dim: [2, 22],
              italic: [3, 23],
              underline: [4, 24],
              inverse: [7, 27],
              hidden: [8, 28],
              strikethrough: [9, 29]
            },
            color: {
              black: [30, 39],
              red: [31, 39],
              green: [32, 39],
              yellow: [33, 39],
              blue: [34, 39],
              magenta: [35, 39],
              cyan: [36, 39],
              white: [37, 39],
              gray: [90, 39],
              redBright: [91, 39],
              greenBright: [92, 39],
              yellowBright: [93, 39],
              blueBright: [94, 39],
              magentaBright: [95, 39],
              cyanBright: [96, 39],
              whiteBright: [97, 39]
            },
            bgColor: {
              bgBlack: [40, 49],
              bgRed: [41, 49],
              bgGreen: [42, 49],
              bgYellow: [43, 49],
              bgBlue: [44, 49],
              bgMagenta: [45, 49],
              bgCyan: [46, 49],
              bgWhite: [47, 49],
              bgBlackBright: [100, 49],
              bgRedBright: [101, 49],
              bgGreenBright: [102, 49],
              bgYellowBright: [103, 49],
              bgBlueBright: [104, 49],
              bgMagentaBright: [105, 49],
              bgCyanBright: [106, 49],
              bgWhiteBright: [107, 49]
            }
          };
          styles.color.grey = styles.color.gray;
          for (const groupName of Object.keys(styles)) {
            const group = styles[groupName];
            for (const styleName of Object.keys(group)) {
              const style = group[styleName];
              styles[styleName] = {
                open: `\x1B[${style[0]}m`,
                close: `\x1B[${style[1]}m`
              };
              group[styleName] = styles[styleName];
              codes.set(style[0], style[1]);
            }
            Object.defineProperty(styles, groupName, {
              value: group,
              enumerable: false
            });
            Object.defineProperty(styles, "codes", {
              value: codes,
              enumerable: false
            });
          }
          const ansi2ansi = (n2) => n2;
          const rgb2rgb = (r, g, b) => [r, g, b];
          styles.color.close = "\x1B[39m";
          styles.bgColor.close = "\x1B[49m";
          styles.color.ansi = {
            ansi: wrapAnsi16(ansi2ansi, 0)
          };
          styles.color.ansi256 = {
            ansi256: wrapAnsi256(ansi2ansi, 0)
          };
          styles.color.ansi16m = {
            rgb: wrapAnsi16m(rgb2rgb, 0)
          };
          styles.bgColor.ansi = {
            ansi: wrapAnsi16(ansi2ansi, 10)
          };
          styles.bgColor.ansi256 = {
            ansi256: wrapAnsi256(ansi2ansi, 10)
          };
          styles.bgColor.ansi16m = {
            rgb: wrapAnsi16m(rgb2rgb, 10)
          };
          for (let key of Object.keys(colorConvert)) {
            if (typeof colorConvert[key] !== "object") {
              continue;
            }
            const suite = colorConvert[key];
            if (key === "ansi16") {
              key = "ansi";
            }
            if ("ansi16" in suite) {
              styles.color.ansi[key] = wrapAnsi16(suite.ansi16, 0);
              styles.bgColor.ansi[key] = wrapAnsi16(suite.ansi16, 10);
            }
            if ("ansi256" in suite) {
              styles.color.ansi256[key] = wrapAnsi256(suite.ansi256, 0);
              styles.bgColor.ansi256[key] = wrapAnsi256(suite.ansi256, 10);
            }
            if ("rgb" in suite) {
              styles.color.ansi16m[key] = wrapAnsi16m(suite.rgb, 0);
              styles.bgColor.ansi16m[key] = wrapAnsi16m(suite.rgb, 10);
            }
          }
          return styles;
        }
        Object.defineProperty(module22, "exports", {
          enumerable: true,
          get: assembleStyles
        });
      }
    });
    var require_has_flag = __commonJS2({
      "node_modules/@babel/highlight/node_modules/has-flag/index.js"(exports2, module22) {
        "use strict";
        module22.exports = (flag, argv) => {
          argv = argv || process.argv;
          const prefix = flag.startsWith("-") ? "" : flag.length === 1 ? "-" : "--";
          const pos = argv.indexOf(prefix + flag);
          const terminatorPos = argv.indexOf("--");
          return pos !== -1 && (terminatorPos === -1 ? true : pos < terminatorPos);
        };
      }
    });
    var require_supports_color = __commonJS2({
      "node_modules/@babel/highlight/node_modules/supports-color/index.js"(exports2, module22) {
        "use strict";
        var os = require("os");
        var hasFlag = require_has_flag();
        var env = process.env;
        var forceColor;
        if (hasFlag("no-color") || hasFlag("no-colors") || hasFlag("color=false")) {
          forceColor = false;
        } else if (hasFlag("color") || hasFlag("colors") || hasFlag("color=true") || hasFlag("color=always")) {
          forceColor = true;
        }
        if ("FORCE_COLOR" in env) {
          forceColor = env.FORCE_COLOR.length === 0 || parseInt(env.FORCE_COLOR, 10) !== 0;
        }
        function translateLevel(level) {
          if (level === 0) {
            return false;
          }
          return {
            level,
            hasBasic: true,
            has256: level >= 2,
            has16m: level >= 3
          };
        }
        function supportsColor(stream) {
          if (forceColor === false) {
            return 0;
          }
          if (hasFlag("color=16m") || hasFlag("color=full") || hasFlag("color=truecolor")) {
            return 3;
          }
          if (hasFlag("color=256")) {
            return 2;
          }
          if (stream && !stream.isTTY && forceColor !== true) {
            return 0;
          }
          const min = forceColor ? 1 : 0;
          if (process.platform === "win32") {
            const osRelease = os.release().split(".");
            if (Number(process.versions.node.split(".")[0]) >= 8 && Number(osRelease[0]) >= 10 && Number(osRelease[2]) >= 10586) {
              return Number(osRelease[2]) >= 14931 ? 3 : 2;
            }
            return 1;
          }
          if ("CI" in env) {
            if (["TRAVIS", "CIRCLECI", "APPVEYOR", "GITLAB_CI"].some((sign) => sign in env) || env.CI_NAME === "codeship") {
              return 1;
            }
            return min;
          }
          if ("TEAMCITY_VERSION" in env) {
            return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env.TEAMCITY_VERSION) ? 1 : 0;
          }
          if (env.COLORTERM === "truecolor") {
            return 3;
          }
          if ("TERM_PROGRAM" in env) {
            const version = parseInt((env.TERM_PROGRAM_VERSION || "").split(".")[0], 10);
            switch (env.TERM_PROGRAM) {
              case "iTerm.app":
                return version >= 3 ? 3 : 2;
              case "Apple_Terminal":
                return 2;
            }
          }
          if (/-256(color)?$/i.test(env.TERM)) {
            return 2;
          }
          if (/^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(env.TERM)) {
            return 1;
          }
          if ("COLORTERM" in env) {
            return 1;
          }
          if (env.TERM === "dumb") {
            return min;
          }
          return min;
        }
        function getSupportLevel(stream) {
          const level = supportsColor(stream);
          return translateLevel(level);
        }
        module22.exports = {
          supportsColor: getSupportLevel,
          stdout: getSupportLevel(process.stdout),
          stderr: getSupportLevel(process.stderr)
        };
      }
    });
    var require_templates = __commonJS2({
      "node_modules/@babel/highlight/node_modules/chalk/templates.js"(exports2, module22) {
        "use strict";
        var TEMPLATE_REGEX = /(?:\\(u[a-f\d]{4}|x[a-f\d]{2}|.))|(?:\{(~)?(\w+(?:\([^)]*\))?(?:\.\w+(?:\([^)]*\))?)*)(?:[ \t]|(?=\r?\n)))|(\})|((?:.|[\r\n\f])+?)/gi;
        var STYLE_REGEX = /(?:^|\.)(\w+)(?:\(([^)]*)\))?/g;
        var STRING_REGEX = /^(['"])((?:\\.|(?!\1)[^\\])*)\1$/;
        var ESCAPE_REGEX = /\\(u[a-f\d]{4}|x[a-f\d]{2}|.)|([^\\])/gi;
        var ESCAPES = /* @__PURE__ */ new Map([["n", "\n"], ["r", "\r"], ["t", "	"], ["b", "\b"], ["f", "\f"], ["v", "\v"], ["0", "\0"], ["\\", "\\"], ["e", "\x1B"], ["a", "\x07"]]);
        function unescape2(c) {
          if (c[0] === "u" && c.length === 5 || c[0] === "x" && c.length === 3) {
            return String.fromCharCode(parseInt(c.slice(1), 16));
          }
          return ESCAPES.get(c) || c;
        }
        function parseArguments(name, args) {
          const results = [];
          const chunks = args.trim().split(/\s*,\s*/g);
          let matches;
          for (const chunk of chunks) {
            if (!isNaN(chunk)) {
              results.push(Number(chunk));
            } else if (matches = chunk.match(STRING_REGEX)) {
              results.push(matches[2].replace(ESCAPE_REGEX, (m, escape, chr) => escape ? unescape2(escape) : chr));
            } else {
              throw new Error(`Invalid Chalk template style argument: ${chunk} (in style '${name}')`);
            }
          }
          return results;
        }
        function parseStyle(style) {
          STYLE_REGEX.lastIndex = 0;
          const results = [];
          let matches;
          while ((matches = STYLE_REGEX.exec(style)) !== null) {
            const name = matches[1];
            if (matches[2]) {
              const args = parseArguments(name, matches[2]);
              results.push([name].concat(args));
            } else {
              results.push([name]);
            }
          }
          return results;
        }
        function buildStyle(chalk, styles) {
          const enabled = {};
          for (const layer of styles) {
            for (const style of layer.styles) {
              enabled[style[0]] = layer.inverse ? null : style.slice(1);
            }
          }
          let current = chalk;
          for (const styleName of Object.keys(enabled)) {
            if (Array.isArray(enabled[styleName])) {
              if (!(styleName in current)) {
                throw new Error(`Unknown Chalk style: ${styleName}`);
              }
              if (enabled[styleName].length > 0) {
                current = current[styleName].apply(current, enabled[styleName]);
              } else {
                current = current[styleName];
              }
            }
          }
          return current;
        }
        module22.exports = (chalk, tmp) => {
          const styles = [];
          const chunks = [];
          let chunk = [];
          tmp.replace(TEMPLATE_REGEX, (m, escapeChar, inverse, style, close, chr) => {
            if (escapeChar) {
              chunk.push(unescape2(escapeChar));
            } else if (style) {
              const str = chunk.join("");
              chunk = [];
              chunks.push(styles.length === 0 ? str : buildStyle(chalk, styles)(str));
              styles.push({
                inverse,
                styles: parseStyle(style)
              });
            } else if (close) {
              if (styles.length === 0) {
                throw new Error("Found extraneous } in Chalk template literal");
              }
              chunks.push(buildStyle(chalk, styles)(chunk.join("")));
              chunk = [];
              styles.pop();
            } else {
              chunk.push(chr);
            }
          });
          chunks.push(chunk.join(""));
          if (styles.length > 0) {
            const errMsg = `Chalk template literal is missing ${styles.length} closing bracket${styles.length === 1 ? "" : "s"} (\`}\`)`;
            throw new Error(errMsg);
          }
          return chunks.join("");
        };
      }
    });
    var require_chalk = __commonJS2({
      "node_modules/@babel/highlight/node_modules/chalk/index.js"(exports2, module22) {
        "use strict";
        var escapeStringRegexp = require_escape_string_regexp();
        var ansiStyles = require_ansi_styles();
        var stdoutColor = require_supports_color().stdout;
        var template = require_templates();
        var isSimpleWindowsTerm = process.platform === "win32" && !(process.env.TERM || "").toLowerCase().startsWith("xterm");
        var levelMapping = ["ansi", "ansi", "ansi256", "ansi16m"];
        var skipModels = /* @__PURE__ */ new Set(["gray"]);
        var styles = /* @__PURE__ */ Object.create(null);
        function applyOptions(obj, options) {
          options = options || {};
          const scLevel = stdoutColor ? stdoutColor.level : 0;
          obj.level = options.level === void 0 ? scLevel : options.level;
          obj.enabled = "enabled" in options ? options.enabled : obj.level > 0;
        }
        function Chalk(options) {
          if (!this || !(this instanceof Chalk) || this.template) {
            const chalk = {};
            applyOptions(chalk, options);
            chalk.template = function() {
              const args = [].slice.call(arguments);
              return chalkTag.apply(null, [chalk.template].concat(args));
            };
            Object.setPrototypeOf(chalk, Chalk.prototype);
            Object.setPrototypeOf(chalk.template, chalk);
            chalk.template.constructor = Chalk;
            return chalk.template;
          }
          applyOptions(this, options);
        }
        if (isSimpleWindowsTerm) {
          ansiStyles.blue.open = "\x1B[94m";
        }
        for (const key of Object.keys(ansiStyles)) {
          ansiStyles[key].closeRe = new RegExp(escapeStringRegexp(ansiStyles[key].close), "g");
          styles[key] = {
            get() {
              const codes = ansiStyles[key];
              return build.call(this, this._styles ? this._styles.concat(codes) : [codes], this._empty, key);
            }
          };
        }
        styles.visible = {
          get() {
            return build.call(this, this._styles || [], true, "visible");
          }
        };
        ansiStyles.color.closeRe = new RegExp(escapeStringRegexp(ansiStyles.color.close), "g");
        for (const model of Object.keys(ansiStyles.color.ansi)) {
          if (skipModels.has(model)) {
            continue;
          }
          styles[model] = {
            get() {
              const level = this.level;
              return function() {
                const open = ansiStyles.color[levelMapping[level]][model].apply(null, arguments);
                const codes = {
                  open,
                  close: ansiStyles.color.close,
                  closeRe: ansiStyles.color.closeRe
                };
                return build.call(this, this._styles ? this._styles.concat(codes) : [codes], this._empty, model);
              };
            }
          };
        }
        ansiStyles.bgColor.closeRe = new RegExp(escapeStringRegexp(ansiStyles.bgColor.close), "g");
        for (const model of Object.keys(ansiStyles.bgColor.ansi)) {
          if (skipModels.has(model)) {
            continue;
          }
          const bgModel = "bg" + model[0].toUpperCase() + model.slice(1);
          styles[bgModel] = {
            get() {
              const level = this.level;
              return function() {
                const open = ansiStyles.bgColor[levelMapping[level]][model].apply(null, arguments);
                const codes = {
                  open,
                  close: ansiStyles.bgColor.close,
                  closeRe: ansiStyles.bgColor.closeRe
                };
                return build.call(this, this._styles ? this._styles.concat(codes) : [codes], this._empty, model);
              };
            }
          };
        }
        var proto = Object.defineProperties(() => {
        }, styles);
        function build(_styles, _empty, key) {
          const builder = function() {
            return applyStyle.apply(builder, arguments);
          };
          builder._styles = _styles;
          builder._empty = _empty;
          const self2 = this;
          Object.defineProperty(builder, "level", {
            enumerable: true,
            get() {
              return self2.level;
            },
            set(level) {
              self2.level = level;
            }
          });
          Object.defineProperty(builder, "enabled", {
            enumerable: true,
            get() {
              return self2.enabled;
            },
            set(enabled) {
              self2.enabled = enabled;
            }
          });
          builder.hasGrey = this.hasGrey || key === "gray" || key === "grey";
          builder.__proto__ = proto;
          return builder;
        }
        function applyStyle() {
          const args = arguments;
          const argsLen = args.length;
          let str = String(arguments[0]);
          if (argsLen === 0) {
            return "";
          }
          if (argsLen > 1) {
            for (let a = 1; a < argsLen; a++) {
              str += " " + args[a];
            }
          }
          if (!this.enabled || this.level <= 0 || !str) {
            return this._empty ? "" : str;
          }
          const originalDim = ansiStyles.dim.open;
          if (isSimpleWindowsTerm && this.hasGrey) {
            ansiStyles.dim.open = "";
          }
          for (const code of this._styles.slice().reverse()) {
            str = code.open + str.replace(code.closeRe, code.open) + code.close;
            str = str.replace(/\r?\n/g, `${code.close}$&${code.open}`);
          }
          ansiStyles.dim.open = originalDim;
          return str;
        }
        function chalkTag(chalk, strings) {
          if (!Array.isArray(strings)) {
            return [].slice.call(arguments, 1).join(" ");
          }
          const args = [].slice.call(arguments, 2);
          const parts = [strings.raw[0]];
          for (let i = 1; i < strings.length; i++) {
            parts.push(String(args[i - 1]).replace(/[{}\\]/g, "\\$&"));
            parts.push(String(strings.raw[i]));
          }
          return template(chalk, parts.join(""));
        }
        Object.defineProperties(Chalk.prototype, styles);
        module22.exports = Chalk();
        module22.exports.supportsColor = stdoutColor;
        module22.exports.default = module22.exports;
      }
    });
    var require_lib22 = __commonJS2({
      "node_modules/@babel/highlight/lib/index.js"(exports2) {
        "use strict";
        Object.defineProperty(exports2, "__esModule", {
          value: true
        });
        exports2.default = highlight;
        exports2.getChalk = getChalk;
        exports2.shouldHighlight = shouldHighlight;
        var _jsTokens = require_js_tokens();
        var _helperValidatorIdentifier = require_lib8();
        var _chalk = require_chalk();
        var sometimesKeywords = /* @__PURE__ */ new Set(["as", "async", "from", "get", "of", "set"]);
        function getDefs(chalk) {
          return {
            keyword: chalk.cyan,
            capitalized: chalk.yellow,
            jsxIdentifier: chalk.yellow,
            punctuator: chalk.yellow,
            number: chalk.magenta,
            string: chalk.green,
            regex: chalk.magenta,
            comment: chalk.grey,
            invalid: chalk.white.bgRed.bold
          };
        }
        var NEWLINE = /\r\n|[\n\r\u2028\u2029]/;
        var BRACKET = /^[()[\]{}]$/;
        var tokenize;
        {
          const JSX_TAG = /^[a-z][\w-]*$/i;
          const getTokenType = function(token, offset, text) {
            if (token.type === "name") {
              if ((0, _helperValidatorIdentifier.isKeyword)(token.value) || (0, _helperValidatorIdentifier.isStrictReservedWord)(token.value, true) || sometimesKeywords.has(token.value)) {
                return "keyword";
              }
              if (JSX_TAG.test(token.value) && (text[offset - 1] === "<" || text.slice(offset - 2, offset) == "</")) {
                return "jsxIdentifier";
              }
              if (token.value[0] !== token.value[0].toLowerCase()) {
                return "capitalized";
              }
            }
            if (token.type === "punctuator" && BRACKET.test(token.value)) {
              return "bracket";
            }
            if (token.type === "invalid" && (token.value === "@" || token.value === "#")) {
              return "punctuator";
            }
            return token.type;
          };
          tokenize = function* (text) {
            let match;
            while (match = _jsTokens.default.exec(text)) {
              const token = _jsTokens.matchToToken(match);
              yield {
                type: getTokenType(token, match.index, text),
                value: token.value
              };
            }
          };
        }
        function highlightTokens(defs, text) {
          let highlighted = "";
          for (const {
            type,
            value
          } of tokenize(text)) {
            const colorize = defs[type];
            if (colorize) {
              highlighted += value.split(NEWLINE).map((str) => colorize(str)).join("\n");
            } else {
              highlighted += value;
            }
          }
          return highlighted;
        }
        function shouldHighlight(options) {
          return !!_chalk.supportsColor || options.forceColor;
        }
        function getChalk(options) {
          return options.forceColor ? new _chalk.constructor({
            enabled: true,
            level: 1
          }) : _chalk;
        }
        function highlight(code, options = {}) {
          if (code !== "" && shouldHighlight(options)) {
            const chalk = getChalk(options);
            const defs = getDefs(chalk);
            return highlightTokens(defs, code);
          } else {
            return code;
          }
        }
      }
    });
    var require_lib32 = __commonJS2({
      "node_modules/@babel/code-frame/lib/index.js"(exports2) {
        "use strict";
        Object.defineProperty(exports2, "__esModule", {
          value: true
        });
        exports2.codeFrameColumns = codeFrameColumns;
        exports2.default = _default;
        var _highlight = require_lib22();
        var deprecationWarningShown = false;
        function getDefs(chalk) {
          return {
            gutter: chalk.grey,
            marker: chalk.red.bold,
            message: chalk.red.bold
          };
        }
        var NEWLINE = /\r\n|[\n\r\u2028\u2029]/;
        function getMarkerLines(loc, source, opts) {
          const startLoc = Object.assign({
            column: 0,
            line: -1
          }, loc.start);
          const endLoc = Object.assign({}, startLoc, loc.end);
          const {
            linesAbove = 2,
            linesBelow = 3
          } = opts || {};
          const startLine = startLoc.line;
          const startColumn = startLoc.column;
          const endLine = endLoc.line;
          const endColumn = endLoc.column;
          let start = Math.max(startLine - (linesAbove + 1), 0);
          let end = Math.min(source.length, endLine + linesBelow);
          if (startLine === -1) {
            start = 0;
          }
          if (endLine === -1) {
            end = source.length;
          }
          const lineDiff = endLine - startLine;
          const markerLines = {};
          if (lineDiff) {
            for (let i = 0; i <= lineDiff; i++) {
              const lineNumber = i + startLine;
              if (!startColumn) {
                markerLines[lineNumber] = true;
              } else if (i === 0) {
                const sourceLength = source[lineNumber - 1].length;
                markerLines[lineNumber] = [startColumn, sourceLength - startColumn + 1];
              } else if (i === lineDiff) {
                markerLines[lineNumber] = [0, endColumn];
              } else {
                const sourceLength = source[lineNumber - i].length;
                markerLines[lineNumber] = [0, sourceLength];
              }
            }
          } else {
            if (startColumn === endColumn) {
              if (startColumn) {
                markerLines[startLine] = [startColumn, 0];
              } else {
                markerLines[startLine] = true;
              }
            } else {
              markerLines[startLine] = [startColumn, endColumn - startColumn];
            }
          }
          return {
            start,
            end,
            markerLines
          };
        }
        function codeFrameColumns(rawLines, loc, opts = {}) {
          const highlighted = (opts.highlightCode || opts.forceColor) && (0, _highlight.shouldHighlight)(opts);
          const chalk = (0, _highlight.getChalk)(opts);
          const defs = getDefs(chalk);
          const maybeHighlight = (chalkFn, string) => {
            return highlighted ? chalkFn(string) : string;
          };
          const lines = rawLines.split(NEWLINE);
          const {
            start,
            end,
            markerLines
          } = getMarkerLines(loc, lines, opts);
          const hasColumns = loc.start && typeof loc.start.column === "number";
          const numberMaxWidth = String(end).length;
          const highlightedLines = highlighted ? (0, _highlight.default)(rawLines, opts) : rawLines;
          let frame = highlightedLines.split(NEWLINE, end).slice(start, end).map((line, index) => {
            const number = start + 1 + index;
            const paddedNumber = ` ${number}`.slice(-numberMaxWidth);
            const gutter = ` ${paddedNumber} |`;
            const hasMarker = markerLines[number];
            const lastMarkerLine = !markerLines[number + 1];
            if (hasMarker) {
              let markerLine = "";
              if (Array.isArray(hasMarker)) {
                const markerSpacing = line.slice(0, Math.max(hasMarker[0] - 1, 0)).replace(/[^\t]/g, " ");
                const numberOfMarkers = hasMarker[1] || 1;
                markerLine = ["\n ", maybeHighlight(defs.gutter, gutter.replace(/\d/g, " ")), " ", markerSpacing, maybeHighlight(defs.marker, "^").repeat(numberOfMarkers)].join("");
                if (lastMarkerLine && opts.message) {
                  markerLine += " " + maybeHighlight(defs.message, opts.message);
                }
              }
              return [maybeHighlight(defs.marker, ">"), maybeHighlight(defs.gutter, gutter), line.length > 0 ? ` ${line}` : "", markerLine].join("");
            } else {
              return ` ${maybeHighlight(defs.gutter, gutter)}${line.length > 0 ? ` ${line}` : ""}`;
            }
          }).join("\n");
          if (opts.message && !hasColumns) {
            frame = `${" ".repeat(numberMaxWidth + 1)}${opts.message}
${frame}`;
          }
          if (highlighted) {
            return chalk.reset(frame);
          } else {
            return frame;
          }
        }
        function _default(rawLines, lineNumber, colNumber, opts = {}) {
          if (!deprecationWarningShown) {
            deprecationWarningShown = true;
            const message = "Passing lineNumber and colNumber is deprecated to @babel/code-frame. Please use `codeFrameColumns`.";
            if (process.emitWarning) {
              process.emitWarning(message, "DeprecationWarning");
            } else {
              const deprecationError = new Error(message);
              deprecationError.name = "DeprecationWarning";
              console.warn(new Error(message));
            }
          }
          colNumber = Math.max(colNumber, 0);
          const location = {
            start: {
              column: colNumber,
              line: lineNumber
            }
          };
          return codeFrameColumns(rawLines, location, opts);
        }
      }
    });
    var require_parse_json = __commonJS2({
      "node_modules/parse-json/index.js"(exports2, module22) {
        "use strict";
        var errorEx = require_error_ex();
        var fallback = require_json_parse_even_better_errors();
        var {
          default: LinesAndColumns
        } = require_build();
        var {
          codeFrameColumns
        } = require_lib32();
        var JSONError = errorEx("JSONError", {
          fileName: errorEx.append("in %s"),
          codeFrame: errorEx.append("\n\n%s\n")
        });
        var parseJson = (string, reviver, filename) => {
          if (typeof reviver === "string") {
            filename = reviver;
            reviver = null;
          }
          try {
            try {
              return JSON.parse(string, reviver);
            } catch (error) {
              fallback(string, reviver);
              throw error;
            }
          } catch (error) {
            error.message = error.message.replace(/\n/g, "");
            const indexMatch = error.message.match(/in JSON at position (\d+) while parsing/);
            const jsonError = new JSONError(error);
            if (filename) {
              jsonError.fileName = filename;
            }
            if (indexMatch && indexMatch.length > 0) {
              const lines = new LinesAndColumns(string);
              const index = Number(indexMatch[1]);
              const location = lines.locationForIndex(index);
              const codeFrame = codeFrameColumns(string, {
                start: {
                  line: location.line + 1,
                  column: location.column + 1
                }
              }, {
                highlightCode: true
              });
              jsonError.codeFrame = codeFrame;
            }
            throw jsonError;
          }
        };
        parseJson.JSONError = JSONError;
        module22.exports = parseJson;
      }
    });
    var require_PlainValue_ec8e588e = __commonJS2({
      "node_modules/yaml/dist/PlainValue-ec8e588e.js"(exports2) {
        "use strict";
        var Char = {
          ANCHOR: "&",
          COMMENT: "#",
          TAG: "!",
          DIRECTIVES_END: "-",
          DOCUMENT_END: "."
        };
        var Type = {
          ALIAS: "ALIAS",
          BLANK_LINE: "BLANK_LINE",
          BLOCK_FOLDED: "BLOCK_FOLDED",
          BLOCK_LITERAL: "BLOCK_LITERAL",
          COMMENT: "COMMENT",
          DIRECTIVE: "DIRECTIVE",
          DOCUMENT: "DOCUMENT",
          FLOW_MAP: "FLOW_MAP",
          FLOW_SEQ: "FLOW_SEQ",
          MAP: "MAP",
          MAP_KEY: "MAP_KEY",
          MAP_VALUE: "MAP_VALUE",
          PLAIN: "PLAIN",
          QUOTE_DOUBLE: "QUOTE_DOUBLE",
          QUOTE_SINGLE: "QUOTE_SINGLE",
          SEQ: "SEQ",
          SEQ_ITEM: "SEQ_ITEM"
        };
        var defaultTagPrefix = "tag:yaml.org,2002:";
        var defaultTags = {
          MAP: "tag:yaml.org,2002:map",
          SEQ: "tag:yaml.org,2002:seq",
          STR: "tag:yaml.org,2002:str"
        };
        function findLineStarts(src) {
          const ls = [0];
          let offset = src.indexOf("\n");
          while (offset !== -1) {
            offset += 1;
            ls.push(offset);
            offset = src.indexOf("\n", offset);
          }
          return ls;
        }
        function getSrcInfo(cst) {
          let lineStarts, src;
          if (typeof cst === "string") {
            lineStarts = findLineStarts(cst);
            src = cst;
          } else {
            if (Array.isArray(cst))
              cst = cst[0];
            if (cst && cst.context) {
              if (!cst.lineStarts)
                cst.lineStarts = findLineStarts(cst.context.src);
              lineStarts = cst.lineStarts;
              src = cst.context.src;
            }
          }
          return {
            lineStarts,
            src
          };
        }
        function getLinePos(offset, cst) {
          if (typeof offset !== "number" || offset < 0)
            return null;
          const {
            lineStarts,
            src
          } = getSrcInfo(cst);
          if (!lineStarts || !src || offset > src.length)
            return null;
          for (let i = 0; i < lineStarts.length; ++i) {
            const start = lineStarts[i];
            if (offset < start) {
              return {
                line: i,
                col: offset - lineStarts[i - 1] + 1
              };
            }
            if (offset === start)
              return {
                line: i + 1,
                col: 1
              };
          }
          const line = lineStarts.length;
          return {
            line,
            col: offset - lineStarts[line - 1] + 1
          };
        }
        function getLine(line, cst) {
          const {
            lineStarts,
            src
          } = getSrcInfo(cst);
          if (!lineStarts || !(line >= 1) || line > lineStarts.length)
            return null;
          const start = lineStarts[line - 1];
          let end = lineStarts[line];
          while (end && end > start && src[end - 1] === "\n")
            --end;
          return src.slice(start, end);
        }
        function getPrettyContext({
          start,
          end
        }, cst, maxWidth = 80) {
          let src = getLine(start.line, cst);
          if (!src)
            return null;
          let {
            col
          } = start;
          if (src.length > maxWidth) {
            if (col <= maxWidth - 10) {
              src = src.substr(0, maxWidth - 1) + "\u2026";
            } else {
              const halfWidth = Math.round(maxWidth / 2);
              if (src.length > col + halfWidth)
                src = src.substr(0, col + halfWidth - 1) + "\u2026";
              col -= src.length - maxWidth;
              src = "\u2026" + src.substr(1 - maxWidth);
            }
          }
          let errLen = 1;
          let errEnd = "";
          if (end) {
            if (end.line === start.line && col + (end.col - start.col) <= maxWidth + 1) {
              errLen = end.col - start.col;
            } else {
              errLen = Math.min(src.length + 1, maxWidth) - col;
              errEnd = "\u2026";
            }
          }
          const offset = col > 1 ? " ".repeat(col - 1) : "";
          const err = "^".repeat(errLen);
          return `${src}
${offset}${err}${errEnd}`;
        }
        var Range = class {
          static copy(orig) {
            return new Range(orig.start, orig.end);
          }
          constructor(start, end) {
            this.start = start;
            this.end = end || start;
          }
          isEmpty() {
            return typeof this.start !== "number" || !this.end || this.end <= this.start;
          }
          setOrigRange(cr, offset) {
            const {
              start,
              end
            } = this;
            if (cr.length === 0 || end <= cr[0]) {
              this.origStart = start;
              this.origEnd = end;
              return offset;
            }
            let i = offset;
            while (i < cr.length) {
              if (cr[i] > start)
                break;
              else
                ++i;
            }
            this.origStart = start + i;
            const nextOffset = i;
            while (i < cr.length) {
              if (cr[i] >= end)
                break;
              else
                ++i;
            }
            this.origEnd = end + i;
            return nextOffset;
          }
        };
        var Node = class {
          static addStringTerminator(src, offset, str) {
            if (str[str.length - 1] === "\n")
              return str;
            const next = Node.endOfWhiteSpace(src, offset);
            return next >= src.length || src[next] === "\n" ? str + "\n" : str;
          }
          static atDocumentBoundary(src, offset, sep) {
            const ch0 = src[offset];
            if (!ch0)
              return true;
            const prev = src[offset - 1];
            if (prev && prev !== "\n")
              return false;
            if (sep) {
              if (ch0 !== sep)
                return false;
            } else {
              if (ch0 !== Char.DIRECTIVES_END && ch0 !== Char.DOCUMENT_END)
                return false;
            }
            const ch1 = src[offset + 1];
            const ch2 = src[offset + 2];
            if (ch1 !== ch0 || ch2 !== ch0)
              return false;
            const ch3 = src[offset + 3];
            return !ch3 || ch3 === "\n" || ch3 === "	" || ch3 === " ";
          }
          static endOfIdentifier(src, offset) {
            let ch = src[offset];
            const isVerbatim = ch === "<";
            const notOk = isVerbatim ? ["\n", "	", " ", ">"] : ["\n", "	", " ", "[", "]", "{", "}", ","];
            while (ch && notOk.indexOf(ch) === -1)
              ch = src[offset += 1];
            if (isVerbatim && ch === ">")
              offset += 1;
            return offset;
          }
          static endOfIndent(src, offset) {
            let ch = src[offset];
            while (ch === " ")
              ch = src[offset += 1];
            return offset;
          }
          static endOfLine(src, offset) {
            let ch = src[offset];
            while (ch && ch !== "\n")
              ch = src[offset += 1];
            return offset;
          }
          static endOfWhiteSpace(src, offset) {
            let ch = src[offset];
            while (ch === "	" || ch === " ")
              ch = src[offset += 1];
            return offset;
          }
          static startOfLine(src, offset) {
            let ch = src[offset - 1];
            if (ch === "\n")
              return offset;
            while (ch && ch !== "\n")
              ch = src[offset -= 1];
            return offset + 1;
          }
          static endOfBlockIndent(src, indent, lineStart) {
            const inEnd = Node.endOfIndent(src, lineStart);
            if (inEnd > lineStart + indent) {
              return inEnd;
            } else {
              const wsEnd = Node.endOfWhiteSpace(src, inEnd);
              const ch = src[wsEnd];
              if (!ch || ch === "\n")
                return wsEnd;
            }
            return null;
          }
          static atBlank(src, offset, endAsBlank) {
            const ch = src[offset];
            return ch === "\n" || ch === "	" || ch === " " || endAsBlank && !ch;
          }
          static nextNodeIsIndented(ch, indentDiff, indicatorAsIndent) {
            if (!ch || indentDiff < 0)
              return false;
            if (indentDiff > 0)
              return true;
            return indicatorAsIndent && ch === "-";
          }
          static normalizeOffset(src, offset) {
            const ch = src[offset];
            return !ch ? offset : ch !== "\n" && src[offset - 1] === "\n" ? offset - 1 : Node.endOfWhiteSpace(src, offset);
          }
          static foldNewline(src, offset, indent) {
            let inCount = 0;
            let error = false;
            let fold = "";
            let ch = src[offset + 1];
            while (ch === " " || ch === "	" || ch === "\n") {
              switch (ch) {
                case "\n":
                  inCount = 0;
                  offset += 1;
                  fold += "\n";
                  break;
                case "	":
                  if (inCount <= indent)
                    error = true;
                  offset = Node.endOfWhiteSpace(src, offset + 2) - 1;
                  break;
                case " ":
                  inCount += 1;
                  offset += 1;
                  break;
              }
              ch = src[offset + 1];
            }
            if (!fold)
              fold = " ";
            if (ch && inCount <= indent)
              error = true;
            return {
              fold,
              offset,
              error
            };
          }
          constructor(type, props, context) {
            Object.defineProperty(this, "context", {
              value: context || null,
              writable: true
            });
            this.error = null;
            this.range = null;
            this.valueRange = null;
            this.props = props || [];
            this.type = type;
            this.value = null;
          }
          getPropValue(idx, key, skipKey) {
            if (!this.context)
              return null;
            const {
              src
            } = this.context;
            const prop = this.props[idx];
            return prop && src[prop.start] === key ? src.slice(prop.start + (skipKey ? 1 : 0), prop.end) : null;
          }
          get anchor() {
            for (let i = 0; i < this.props.length; ++i) {
              const anchor = this.getPropValue(i, Char.ANCHOR, true);
              if (anchor != null)
                return anchor;
            }
            return null;
          }
          get comment() {
            const comments = [];
            for (let i = 0; i < this.props.length; ++i) {
              const comment = this.getPropValue(i, Char.COMMENT, true);
              if (comment != null)
                comments.push(comment);
            }
            return comments.length > 0 ? comments.join("\n") : null;
          }
          commentHasRequiredWhitespace(start) {
            const {
              src
            } = this.context;
            if (this.header && start === this.header.end)
              return false;
            if (!this.valueRange)
              return false;
            const {
              end
            } = this.valueRange;
            return start !== end || Node.atBlank(src, end - 1);
          }
          get hasComment() {
            if (this.context) {
              const {
                src
              } = this.context;
              for (let i = 0; i < this.props.length; ++i) {
                if (src[this.props[i].start] === Char.COMMENT)
                  return true;
              }
            }
            return false;
          }
          get hasProps() {
            if (this.context) {
              const {
                src
              } = this.context;
              for (let i = 0; i < this.props.length; ++i) {
                if (src[this.props[i].start] !== Char.COMMENT)
                  return true;
              }
            }
            return false;
          }
          get includesTrailingLines() {
            return false;
          }
          get jsonLike() {
            const jsonLikeTypes = [Type.FLOW_MAP, Type.FLOW_SEQ, Type.QUOTE_DOUBLE, Type.QUOTE_SINGLE];
            return jsonLikeTypes.indexOf(this.type) !== -1;
          }
          get rangeAsLinePos() {
            if (!this.range || !this.context)
              return void 0;
            const start = getLinePos(this.range.start, this.context.root);
            if (!start)
              return void 0;
            const end = getLinePos(this.range.end, this.context.root);
            return {
              start,
              end
            };
          }
          get rawValue() {
            if (!this.valueRange || !this.context)
              return null;
            const {
              start,
              end
            } = this.valueRange;
            return this.context.src.slice(start, end);
          }
          get tag() {
            for (let i = 0; i < this.props.length; ++i) {
              const tag = this.getPropValue(i, Char.TAG, false);
              if (tag != null) {
                if (tag[1] === "<") {
                  return {
                    verbatim: tag.slice(2, -1)
                  };
                } else {
                  const [_, handle, suffix] = tag.match(/^(.*!)([^!]*)$/);
                  return {
                    handle,
                    suffix
                  };
                }
              }
            }
            return null;
          }
          get valueRangeContainsNewline() {
            if (!this.valueRange || !this.context)
              return false;
            const {
              start,
              end
            } = this.valueRange;
            const {
              src
            } = this.context;
            for (let i = start; i < end; ++i) {
              if (src[i] === "\n")
                return true;
            }
            return false;
          }
          parseComment(start) {
            const {
              src
            } = this.context;
            if (src[start] === Char.COMMENT) {
              const end = Node.endOfLine(src, start + 1);
              const commentRange = new Range(start, end);
              this.props.push(commentRange);
              return end;
            }
            return start;
          }
          setOrigRanges(cr, offset) {
            if (this.range)
              offset = this.range.setOrigRange(cr, offset);
            if (this.valueRange)
              this.valueRange.setOrigRange(cr, offset);
            this.props.forEach((prop) => prop.setOrigRange(cr, offset));
            return offset;
          }
          toString() {
            const {
              context: {
                src
              },
              range,
              value
            } = this;
            if (value != null)
              return value;
            const str = src.slice(range.start, range.end);
            return Node.addStringTerminator(src, range.end, str);
          }
        };
        var YAMLError = class extends Error {
          constructor(name, source, message) {
            if (!message || !(source instanceof Node))
              throw new Error(`Invalid arguments for new ${name}`);
            super();
            this.name = name;
            this.message = message;
            this.source = source;
          }
          makePretty() {
            if (!this.source)
              return;
            this.nodeType = this.source.type;
            const cst = this.source.context && this.source.context.root;
            if (typeof this.offset === "number") {
              this.range = new Range(this.offset, this.offset + 1);
              const start = cst && getLinePos(this.offset, cst);
              if (start) {
                const end = {
                  line: start.line,
                  col: start.col + 1
                };
                this.linePos = {
                  start,
                  end
                };
              }
              delete this.offset;
            } else {
              this.range = this.source.range;
              this.linePos = this.source.rangeAsLinePos;
            }
            if (this.linePos) {
              const {
                line,
                col
              } = this.linePos.start;
              this.message += ` at line ${line}, column ${col}`;
              const ctx = cst && getPrettyContext(this.linePos, cst);
              if (ctx)
                this.message += `:

${ctx}
`;
            }
            delete this.source;
          }
        };
        var YAMLReferenceError = class extends YAMLError {
          constructor(source, message) {
            super("YAMLReferenceError", source, message);
          }
        };
        var YAMLSemanticError = class extends YAMLError {
          constructor(source, message) {
            super("YAMLSemanticError", source, message);
          }
        };
        var YAMLSyntaxError = class extends YAMLError {
          constructor(source, message) {
            super("YAMLSyntaxError", source, message);
          }
        };
        var YAMLWarning = class extends YAMLError {
          constructor(source, message) {
            super("YAMLWarning", source, message);
          }
        };
        function _defineProperty(obj, key, value) {
          if (key in obj) {
            Object.defineProperty(obj, key, {
              value,
              enumerable: true,
              configurable: true,
              writable: true
            });
          } else {
            obj[key] = value;
          }
          return obj;
        }
        var PlainValue = class extends Node {
          static endOfLine(src, start, inFlow) {
            let ch = src[start];
            let offset = start;
            while (ch && ch !== "\n") {
              if (inFlow && (ch === "[" || ch === "]" || ch === "{" || ch === "}" || ch === ","))
                break;
              const next = src[offset + 1];
              if (ch === ":" && (!next || next === "\n" || next === "	" || next === " " || inFlow && next === ","))
                break;
              if ((ch === " " || ch === "	") && next === "#")
                break;
              offset += 1;
              ch = next;
            }
            return offset;
          }
          get strValue() {
            if (!this.valueRange || !this.context)
              return null;
            let {
              start,
              end
            } = this.valueRange;
            const {
              src
            } = this.context;
            let ch = src[end - 1];
            while (start < end && (ch === "\n" || ch === "	" || ch === " "))
              ch = src[--end - 1];
            let str = "";
            for (let i = start; i < end; ++i) {
              const ch2 = src[i];
              if (ch2 === "\n") {
                const {
                  fold,
                  offset
                } = Node.foldNewline(src, i, -1);
                str += fold;
                i = offset;
              } else if (ch2 === " " || ch2 === "	") {
                const wsStart = i;
                let next = src[i + 1];
                while (i < end && (next === " " || next === "	")) {
                  i += 1;
                  next = src[i + 1];
                }
                if (next !== "\n")
                  str += i > wsStart ? src.slice(wsStart, i + 1) : ch2;
              } else {
                str += ch2;
              }
            }
            const ch0 = src[start];
            switch (ch0) {
              case "	": {
                const msg = "Plain value cannot start with a tab character";
                const errors = [new YAMLSemanticError(this, msg)];
                return {
                  errors,
                  str
                };
              }
              case "@":
              case "`": {
                const msg = `Plain value cannot start with reserved character ${ch0}`;
                const errors = [new YAMLSemanticError(this, msg)];
                return {
                  errors,
                  str
                };
              }
              default:
                return str;
            }
          }
          parseBlockValue(start) {
            const {
              indent,
              inFlow,
              src
            } = this.context;
            let offset = start;
            let valueEnd = start;
            for (let ch = src[offset]; ch === "\n"; ch = src[offset]) {
              if (Node.atDocumentBoundary(src, offset + 1))
                break;
              const end = Node.endOfBlockIndent(src, indent, offset + 1);
              if (end === null || src[end] === "#")
                break;
              if (src[end] === "\n") {
                offset = end;
              } else {
                valueEnd = PlainValue.endOfLine(src, end, inFlow);
                offset = valueEnd;
              }
            }
            if (this.valueRange.isEmpty())
              this.valueRange.start = start;
            this.valueRange.end = valueEnd;
            return valueEnd;
          }
          parse(context, start) {
            this.context = context;
            const {
              inFlow,
              src
            } = context;
            let offset = start;
            const ch = src[offset];
            if (ch && ch !== "#" && ch !== "\n") {
              offset = PlainValue.endOfLine(src, start, inFlow);
            }
            this.valueRange = new Range(start, offset);
            offset = Node.endOfWhiteSpace(src, offset);
            offset = this.parseComment(offset);
            if (!this.hasComment || this.valueRange.isEmpty()) {
              offset = this.parseBlockValue(offset);
            }
            return offset;
          }
        };
        exports2.Char = Char;
        exports2.Node = Node;
        exports2.PlainValue = PlainValue;
        exports2.Range = Range;
        exports2.Type = Type;
        exports2.YAMLError = YAMLError;
        exports2.YAMLReferenceError = YAMLReferenceError;
        exports2.YAMLSemanticError = YAMLSemanticError;
        exports2.YAMLSyntaxError = YAMLSyntaxError;
        exports2.YAMLWarning = YAMLWarning;
        exports2._defineProperty = _defineProperty;
        exports2.defaultTagPrefix = defaultTagPrefix;
        exports2.defaultTags = defaultTags;
      }
    });
    var require_parse_cst = __commonJS2({
      "node_modules/yaml/dist/parse-cst.js"(exports2) {
        "use strict";
        var PlainValue = require_PlainValue_ec8e588e();
        var BlankLine = class extends PlainValue.Node {
          constructor() {
            super(PlainValue.Type.BLANK_LINE);
          }
          get includesTrailingLines() {
            return true;
          }
          parse(context, start) {
            this.context = context;
            this.range = new PlainValue.Range(start, start + 1);
            return start + 1;
          }
        };
        var CollectionItem = class extends PlainValue.Node {
          constructor(type, props) {
            super(type, props);
            this.node = null;
          }
          get includesTrailingLines() {
            return !!this.node && this.node.includesTrailingLines;
          }
          parse(context, start) {
            this.context = context;
            const {
              parseNode,
              src
            } = context;
            let {
              atLineStart,
              lineStart
            } = context;
            if (!atLineStart && this.type === PlainValue.Type.SEQ_ITEM)
              this.error = new PlainValue.YAMLSemanticError(this, "Sequence items must not have preceding content on the same line");
            const indent = atLineStart ? start - lineStart : context.indent;
            let offset = PlainValue.Node.endOfWhiteSpace(src, start + 1);
            let ch = src[offset];
            const inlineComment = ch === "#";
            const comments = [];
            let blankLine = null;
            while (ch === "\n" || ch === "#") {
              if (ch === "#") {
                const end2 = PlainValue.Node.endOfLine(src, offset + 1);
                comments.push(new PlainValue.Range(offset, end2));
                offset = end2;
              } else {
                atLineStart = true;
                lineStart = offset + 1;
                const wsEnd = PlainValue.Node.endOfWhiteSpace(src, lineStart);
                if (src[wsEnd] === "\n" && comments.length === 0) {
                  blankLine = new BlankLine();
                  lineStart = blankLine.parse({
                    src
                  }, lineStart);
                }
                offset = PlainValue.Node.endOfIndent(src, lineStart);
              }
              ch = src[offset];
            }
            if (PlainValue.Node.nextNodeIsIndented(ch, offset - (lineStart + indent), this.type !== PlainValue.Type.SEQ_ITEM)) {
              this.node = parseNode({
                atLineStart,
                inCollection: false,
                indent,
                lineStart,
                parent: this
              }, offset);
            } else if (ch && lineStart > start + 1) {
              offset = lineStart - 1;
            }
            if (this.node) {
              if (blankLine) {
                const items = context.parent.items || context.parent.contents;
                if (items)
                  items.push(blankLine);
              }
              if (comments.length)
                Array.prototype.push.apply(this.props, comments);
              offset = this.node.range.end;
            } else {
              if (inlineComment) {
                const c = comments[0];
                this.props.push(c);
                offset = c.end;
              } else {
                offset = PlainValue.Node.endOfLine(src, start + 1);
              }
            }
            const end = this.node ? this.node.valueRange.end : offset;
            this.valueRange = new PlainValue.Range(start, end);
            return offset;
          }
          setOrigRanges(cr, offset) {
            offset = super.setOrigRanges(cr, offset);
            return this.node ? this.node.setOrigRanges(cr, offset) : offset;
          }
          toString() {
            const {
              context: {
                src
              },
              node,
              range,
              value
            } = this;
            if (value != null)
              return value;
            const str = node ? src.slice(range.start, node.range.start) + String(node) : src.slice(range.start, range.end);
            return PlainValue.Node.addStringTerminator(src, range.end, str);
          }
        };
        var Comment = class extends PlainValue.Node {
          constructor() {
            super(PlainValue.Type.COMMENT);
          }
          parse(context, start) {
            this.context = context;
            const offset = this.parseComment(start);
            this.range = new PlainValue.Range(start, offset);
            return offset;
          }
        };
        function grabCollectionEndComments(node) {
          let cnode = node;
          while (cnode instanceof CollectionItem)
            cnode = cnode.node;
          if (!(cnode instanceof Collection))
            return null;
          const len = cnode.items.length;
          let ci = -1;
          for (let i = len - 1; i >= 0; --i) {
            const n2 = cnode.items[i];
            if (n2.type === PlainValue.Type.COMMENT) {
              const {
                indent,
                lineStart
              } = n2.context;
              if (indent > 0 && n2.range.start >= lineStart + indent)
                break;
              ci = i;
            } else if (n2.type === PlainValue.Type.BLANK_LINE)
              ci = i;
            else
              break;
          }
          if (ci === -1)
            return null;
          const ca = cnode.items.splice(ci, len - ci);
          const prevEnd = ca[0].range.start;
          while (true) {
            cnode.range.end = prevEnd;
            if (cnode.valueRange && cnode.valueRange.end > prevEnd)
              cnode.valueRange.end = prevEnd;
            if (cnode === node)
              break;
            cnode = cnode.context.parent;
          }
          return ca;
        }
        var Collection = class extends PlainValue.Node {
          static nextContentHasIndent(src, offset, indent) {
            const lineStart = PlainValue.Node.endOfLine(src, offset) + 1;
            offset = PlainValue.Node.endOfWhiteSpace(src, lineStart);
            const ch = src[offset];
            if (!ch)
              return false;
            if (offset >= lineStart + indent)
              return true;
            if (ch !== "#" && ch !== "\n")
              return false;
            return Collection.nextContentHasIndent(src, offset, indent);
          }
          constructor(firstItem) {
            super(firstItem.type === PlainValue.Type.SEQ_ITEM ? PlainValue.Type.SEQ : PlainValue.Type.MAP);
            for (let i = firstItem.props.length - 1; i >= 0; --i) {
              if (firstItem.props[i].start < firstItem.context.lineStart) {
                this.props = firstItem.props.slice(0, i + 1);
                firstItem.props = firstItem.props.slice(i + 1);
                const itemRange = firstItem.props[0] || firstItem.valueRange;
                firstItem.range.start = itemRange.start;
                break;
              }
            }
            this.items = [firstItem];
            const ec = grabCollectionEndComments(firstItem);
            if (ec)
              Array.prototype.push.apply(this.items, ec);
          }
          get includesTrailingLines() {
            return this.items.length > 0;
          }
          parse(context, start) {
            this.context = context;
            const {
              parseNode,
              src
            } = context;
            let lineStart = PlainValue.Node.startOfLine(src, start);
            const firstItem = this.items[0];
            firstItem.context.parent = this;
            this.valueRange = PlainValue.Range.copy(firstItem.valueRange);
            const indent = firstItem.range.start - firstItem.context.lineStart;
            let offset = start;
            offset = PlainValue.Node.normalizeOffset(src, offset);
            let ch = src[offset];
            let atLineStart = PlainValue.Node.endOfWhiteSpace(src, lineStart) === offset;
            let prevIncludesTrailingLines = false;
            while (ch) {
              while (ch === "\n" || ch === "#") {
                if (atLineStart && ch === "\n" && !prevIncludesTrailingLines) {
                  const blankLine = new BlankLine();
                  offset = blankLine.parse({
                    src
                  }, offset);
                  this.valueRange.end = offset;
                  if (offset >= src.length) {
                    ch = null;
                    break;
                  }
                  this.items.push(blankLine);
                  offset -= 1;
                } else if (ch === "#") {
                  if (offset < lineStart + indent && !Collection.nextContentHasIndent(src, offset, indent)) {
                    return offset;
                  }
                  const comment = new Comment();
                  offset = comment.parse({
                    indent,
                    lineStart,
                    src
                  }, offset);
                  this.items.push(comment);
                  this.valueRange.end = offset;
                  if (offset >= src.length) {
                    ch = null;
                    break;
                  }
                }
                lineStart = offset + 1;
                offset = PlainValue.Node.endOfIndent(src, lineStart);
                if (PlainValue.Node.atBlank(src, offset)) {
                  const wsEnd = PlainValue.Node.endOfWhiteSpace(src, offset);
                  const next = src[wsEnd];
                  if (!next || next === "\n" || next === "#") {
                    offset = wsEnd;
                  }
                }
                ch = src[offset];
                atLineStart = true;
              }
              if (!ch) {
                break;
              }
              if (offset !== lineStart + indent && (atLineStart || ch !== ":")) {
                if (offset < lineStart + indent) {
                  if (lineStart > start)
                    offset = lineStart;
                  break;
                } else if (!this.error) {
                  const msg = "All collection items must start at the same column";
                  this.error = new PlainValue.YAMLSyntaxError(this, msg);
                }
              }
              if (firstItem.type === PlainValue.Type.SEQ_ITEM) {
                if (ch !== "-") {
                  if (lineStart > start)
                    offset = lineStart;
                  break;
                }
              } else if (ch === "-" && !this.error) {
                const next = src[offset + 1];
                if (!next || next === "\n" || next === "	" || next === " ") {
                  const msg = "A collection cannot be both a mapping and a sequence";
                  this.error = new PlainValue.YAMLSyntaxError(this, msg);
                }
              }
              const node = parseNode({
                atLineStart,
                inCollection: true,
                indent,
                lineStart,
                parent: this
              }, offset);
              if (!node)
                return offset;
              this.items.push(node);
              this.valueRange.end = node.valueRange.end;
              offset = PlainValue.Node.normalizeOffset(src, node.range.end);
              ch = src[offset];
              atLineStart = false;
              prevIncludesTrailingLines = node.includesTrailingLines;
              if (ch) {
                let ls = offset - 1;
                let prev = src[ls];
                while (prev === " " || prev === "	")
                  prev = src[--ls];
                if (prev === "\n") {
                  lineStart = ls + 1;
                  atLineStart = true;
                }
              }
              const ec = grabCollectionEndComments(node);
              if (ec)
                Array.prototype.push.apply(this.items, ec);
            }
            return offset;
          }
          setOrigRanges(cr, offset) {
            offset = super.setOrigRanges(cr, offset);
            this.items.forEach((node) => {
              offset = node.setOrigRanges(cr, offset);
            });
            return offset;
          }
          toString() {
            const {
              context: {
                src
              },
              items,
              range,
              value
            } = this;
            if (value != null)
              return value;
            let str = src.slice(range.start, items[0].range.start) + String(items[0]);
            for (let i = 1; i < items.length; ++i) {
              const item = items[i];
              const {
                atLineStart,
                indent
              } = item.context;
              if (atLineStart)
                for (let i2 = 0; i2 < indent; ++i2)
                  str += " ";
              str += String(item);
            }
            return PlainValue.Node.addStringTerminator(src, range.end, str);
          }
        };
        var Directive = class extends PlainValue.Node {
          constructor() {
            super(PlainValue.Type.DIRECTIVE);
            this.name = null;
          }
          get parameters() {
            const raw = this.rawValue;
            return raw ? raw.trim().split(/[ \t]+/) : [];
          }
          parseName(start) {
            const {
              src
            } = this.context;
            let offset = start;
            let ch = src[offset];
            while (ch && ch !== "\n" && ch !== "	" && ch !== " ")
              ch = src[offset += 1];
            this.name = src.slice(start, offset);
            return offset;
          }
          parseParameters(start) {
            const {
              src
            } = this.context;
            let offset = start;
            let ch = src[offset];
            while (ch && ch !== "\n" && ch !== "#")
              ch = src[offset += 1];
            this.valueRange = new PlainValue.Range(start, offset);
            return offset;
          }
          parse(context, start) {
            this.context = context;
            let offset = this.parseName(start + 1);
            offset = this.parseParameters(offset);
            offset = this.parseComment(offset);
            this.range = new PlainValue.Range(start, offset);
            return offset;
          }
        };
        var Document = class extends PlainValue.Node {
          static startCommentOrEndBlankLine(src, start) {
            const offset = PlainValue.Node.endOfWhiteSpace(src, start);
            const ch = src[offset];
            return ch === "#" || ch === "\n" ? offset : start;
          }
          constructor() {
            super(PlainValue.Type.DOCUMENT);
            this.directives = null;
            this.contents = null;
            this.directivesEndMarker = null;
            this.documentEndMarker = null;
          }
          parseDirectives(start) {
            const {
              src
            } = this.context;
            this.directives = [];
            let atLineStart = true;
            let hasDirectives = false;
            let offset = start;
            while (!PlainValue.Node.atDocumentBoundary(src, offset, PlainValue.Char.DIRECTIVES_END)) {
              offset = Document.startCommentOrEndBlankLine(src, offset);
              switch (src[offset]) {
                case "\n":
                  if (atLineStart) {
                    const blankLine = new BlankLine();
                    offset = blankLine.parse({
                      src
                    }, offset);
                    if (offset < src.length) {
                      this.directives.push(blankLine);
                    }
                  } else {
                    offset += 1;
                    atLineStart = true;
                  }
                  break;
                case "#":
                  {
                    const comment = new Comment();
                    offset = comment.parse({
                      src
                    }, offset);
                    this.directives.push(comment);
                    atLineStart = false;
                  }
                  break;
                case "%":
                  {
                    const directive = new Directive();
                    offset = directive.parse({
                      parent: this,
                      src
                    }, offset);
                    this.directives.push(directive);
                    hasDirectives = true;
                    atLineStart = false;
                  }
                  break;
                default:
                  if (hasDirectives) {
                    this.error = new PlainValue.YAMLSemanticError(this, "Missing directives-end indicator line");
                  } else if (this.directives.length > 0) {
                    this.contents = this.directives;
                    this.directives = [];
                  }
                  return offset;
              }
            }
            if (src[offset]) {
              this.directivesEndMarker = new PlainValue.Range(offset, offset + 3);
              return offset + 3;
            }
            if (hasDirectives) {
              this.error = new PlainValue.YAMLSemanticError(this, "Missing directives-end indicator line");
            } else if (this.directives.length > 0) {
              this.contents = this.directives;
              this.directives = [];
            }
            return offset;
          }
          parseContents(start) {
            const {
              parseNode,
              src
            } = this.context;
            if (!this.contents)
              this.contents = [];
            let lineStart = start;
            while (src[lineStart - 1] === "-")
              lineStart -= 1;
            let offset = PlainValue.Node.endOfWhiteSpace(src, start);
            let atLineStart = lineStart === start;
            this.valueRange = new PlainValue.Range(offset);
            while (!PlainValue.Node.atDocumentBoundary(src, offset, PlainValue.Char.DOCUMENT_END)) {
              switch (src[offset]) {
                case "\n":
                  if (atLineStart) {
                    const blankLine = new BlankLine();
                    offset = blankLine.parse({
                      src
                    }, offset);
                    if (offset < src.length) {
                      this.contents.push(blankLine);
                    }
                  } else {
                    offset += 1;
                    atLineStart = true;
                  }
                  lineStart = offset;
                  break;
                case "#":
                  {
                    const comment = new Comment();
                    offset = comment.parse({
                      src
                    }, offset);
                    this.contents.push(comment);
                    atLineStart = false;
                  }
                  break;
                default: {
                  const iEnd = PlainValue.Node.endOfIndent(src, offset);
                  const context = {
                    atLineStart,
                    indent: -1,
                    inFlow: false,
                    inCollection: false,
                    lineStart,
                    parent: this
                  };
                  const node = parseNode(context, iEnd);
                  if (!node)
                    return this.valueRange.end = iEnd;
                  this.contents.push(node);
                  offset = node.range.end;
                  atLineStart = false;
                  const ec = grabCollectionEndComments(node);
                  if (ec)
                    Array.prototype.push.apply(this.contents, ec);
                }
              }
              offset = Document.startCommentOrEndBlankLine(src, offset);
            }
            this.valueRange.end = offset;
            if (src[offset]) {
              this.documentEndMarker = new PlainValue.Range(offset, offset + 3);
              offset += 3;
              if (src[offset]) {
                offset = PlainValue.Node.endOfWhiteSpace(src, offset);
                if (src[offset] === "#") {
                  const comment = new Comment();
                  offset = comment.parse({
                    src
                  }, offset);
                  this.contents.push(comment);
                }
                switch (src[offset]) {
                  case "\n":
                    offset += 1;
                    break;
                  case void 0:
                    break;
                  default:
                    this.error = new PlainValue.YAMLSyntaxError(this, "Document end marker line cannot have a non-comment suffix");
                }
              }
            }
            return offset;
          }
          parse(context, start) {
            context.root = this;
            this.context = context;
            const {
              src
            } = context;
            let offset = src.charCodeAt(start) === 65279 ? start + 1 : start;
            offset = this.parseDirectives(offset);
            offset = this.parseContents(offset);
            return offset;
          }
          setOrigRanges(cr, offset) {
            offset = super.setOrigRanges(cr, offset);
            this.directives.forEach((node) => {
              offset = node.setOrigRanges(cr, offset);
            });
            if (this.directivesEndMarker)
              offset = this.directivesEndMarker.setOrigRange(cr, offset);
            this.contents.forEach((node) => {
              offset = node.setOrigRanges(cr, offset);
            });
            if (this.documentEndMarker)
              offset = this.documentEndMarker.setOrigRange(cr, offset);
            return offset;
          }
          toString() {
            const {
              contents,
              directives,
              value
            } = this;
            if (value != null)
              return value;
            let str = directives.join("");
            if (contents.length > 0) {
              if (directives.length > 0 || contents[0].type === PlainValue.Type.COMMENT)
                str += "---\n";
              str += contents.join("");
            }
            if (str[str.length - 1] !== "\n")
              str += "\n";
            return str;
          }
        };
        var Alias = class extends PlainValue.Node {
          parse(context, start) {
            this.context = context;
            const {
              src
            } = context;
            let offset = PlainValue.Node.endOfIdentifier(src, start + 1);
            this.valueRange = new PlainValue.Range(start + 1, offset);
            offset = PlainValue.Node.endOfWhiteSpace(src, offset);
            offset = this.parseComment(offset);
            return offset;
          }
        };
        var Chomp = {
          CLIP: "CLIP",
          KEEP: "KEEP",
          STRIP: "STRIP"
        };
        var BlockValue = class extends PlainValue.Node {
          constructor(type, props) {
            super(type, props);
            this.blockIndent = null;
            this.chomping = Chomp.CLIP;
            this.header = null;
          }
          get includesTrailingLines() {
            return this.chomping === Chomp.KEEP;
          }
          get strValue() {
            if (!this.valueRange || !this.context)
              return null;
            let {
              start,
              end
            } = this.valueRange;
            const {
              indent,
              src
            } = this.context;
            if (this.valueRange.isEmpty())
              return "";
            let lastNewLine = null;
            let ch = src[end - 1];
            while (ch === "\n" || ch === "	" || ch === " ") {
              end -= 1;
              if (end <= start) {
                if (this.chomping === Chomp.KEEP)
                  break;
                else
                  return "";
              }
              if (ch === "\n")
                lastNewLine = end;
              ch = src[end - 1];
            }
            let keepStart = end + 1;
            if (lastNewLine) {
              if (this.chomping === Chomp.KEEP) {
                keepStart = lastNewLine;
                end = this.valueRange.end;
              } else {
                end = lastNewLine;
              }
            }
            const bi = indent + this.blockIndent;
            const folded = this.type === PlainValue.Type.BLOCK_FOLDED;
            let atStart = true;
            let str = "";
            let sep = "";
            let prevMoreIndented = false;
            for (let i = start; i < end; ++i) {
              for (let j = 0; j < bi; ++j) {
                if (src[i] !== " ")
                  break;
                i += 1;
              }
              const ch2 = src[i];
              if (ch2 === "\n") {
                if (sep === "\n")
                  str += "\n";
                else
                  sep = "\n";
              } else {
                const lineEnd = PlainValue.Node.endOfLine(src, i);
                const line = src.slice(i, lineEnd);
                i = lineEnd;
                if (folded && (ch2 === " " || ch2 === "	") && i < keepStart) {
                  if (sep === " ")
                    sep = "\n";
                  else if (!prevMoreIndented && !atStart && sep === "\n")
                    sep = "\n\n";
                  str += sep + line;
                  sep = lineEnd < end && src[lineEnd] || "";
                  prevMoreIndented = true;
                } else {
                  str += sep + line;
                  sep = folded && i < keepStart ? " " : "\n";
                  prevMoreIndented = false;
                }
                if (atStart && line !== "")
                  atStart = false;
              }
            }
            return this.chomping === Chomp.STRIP ? str : str + "\n";
          }
          parseBlockHeader(start) {
            const {
              src
            } = this.context;
            let offset = start + 1;
            let bi = "";
            while (true) {
              const ch = src[offset];
              switch (ch) {
                case "-":
                  this.chomping = Chomp.STRIP;
                  break;
                case "+":
                  this.chomping = Chomp.KEEP;
                  break;
                case "0":
                case "1":
                case "2":
                case "3":
                case "4":
                case "5":
                case "6":
                case "7":
                case "8":
                case "9":
                  bi += ch;
                  break;
                default:
                  this.blockIndent = Number(bi) || null;
                  this.header = new PlainValue.Range(start, offset);
                  return offset;
              }
              offset += 1;
            }
          }
          parseBlockValue(start) {
            const {
              indent,
              src
            } = this.context;
            const explicit = !!this.blockIndent;
            let offset = start;
            let valueEnd = start;
            let minBlockIndent = 1;
            for (let ch = src[offset]; ch === "\n"; ch = src[offset]) {
              offset += 1;
              if (PlainValue.Node.atDocumentBoundary(src, offset))
                break;
              const end = PlainValue.Node.endOfBlockIndent(src, indent, offset);
              if (end === null)
                break;
              const ch2 = src[end];
              const lineIndent = end - (offset + indent);
              if (!this.blockIndent) {
                if (src[end] !== "\n") {
                  if (lineIndent < minBlockIndent) {
                    const msg = "Block scalars with more-indented leading empty lines must use an explicit indentation indicator";
                    this.error = new PlainValue.YAMLSemanticError(this, msg);
                  }
                  this.blockIndent = lineIndent;
                } else if (lineIndent > minBlockIndent) {
                  minBlockIndent = lineIndent;
                }
              } else if (ch2 && ch2 !== "\n" && lineIndent < this.blockIndent) {
                if (src[end] === "#")
                  break;
                if (!this.error) {
                  const src2 = explicit ? "explicit indentation indicator" : "first line";
                  const msg = `Block scalars must not be less indented than their ${src2}`;
                  this.error = new PlainValue.YAMLSemanticError(this, msg);
                }
              }
              if (src[end] === "\n") {
                offset = end;
              } else {
                offset = valueEnd = PlainValue.Node.endOfLine(src, end);
              }
            }
            if (this.chomping !== Chomp.KEEP) {
              offset = src[valueEnd] ? valueEnd + 1 : valueEnd;
            }
            this.valueRange = new PlainValue.Range(start + 1, offset);
            return offset;
          }
          parse(context, start) {
            this.context = context;
            const {
              src
            } = context;
            let offset = this.parseBlockHeader(start);
            offset = PlainValue.Node.endOfWhiteSpace(src, offset);
            offset = this.parseComment(offset);
            offset = this.parseBlockValue(offset);
            return offset;
          }
          setOrigRanges(cr, offset) {
            offset = super.setOrigRanges(cr, offset);
            return this.header ? this.header.setOrigRange(cr, offset) : offset;
          }
        };
        var FlowCollection = class extends PlainValue.Node {
          constructor(type, props) {
            super(type, props);
            this.items = null;
          }
          prevNodeIsJsonLike(idx = this.items.length) {
            const node = this.items[idx - 1];
            return !!node && (node.jsonLike || node.type === PlainValue.Type.COMMENT && this.prevNodeIsJsonLike(idx - 1));
          }
          parse(context, start) {
            this.context = context;
            const {
              parseNode,
              src
            } = context;
            let {
              indent,
              lineStart
            } = context;
            let char2 = src[start];
            this.items = [{
              char: char2,
              offset: start
            }];
            let offset = PlainValue.Node.endOfWhiteSpace(src, start + 1);
            char2 = src[offset];
            while (char2 && char2 !== "]" && char2 !== "}") {
              switch (char2) {
                case "\n":
                  {
                    lineStart = offset + 1;
                    const wsEnd = PlainValue.Node.endOfWhiteSpace(src, lineStart);
                    if (src[wsEnd] === "\n") {
                      const blankLine = new BlankLine();
                      lineStart = blankLine.parse({
                        src
                      }, lineStart);
                      this.items.push(blankLine);
                    }
                    offset = PlainValue.Node.endOfIndent(src, lineStart);
                    if (offset <= lineStart + indent) {
                      char2 = src[offset];
                      if (offset < lineStart + indent || char2 !== "]" && char2 !== "}") {
                        const msg = "Insufficient indentation in flow collection";
                        this.error = new PlainValue.YAMLSemanticError(this, msg);
                      }
                    }
                  }
                  break;
                case ",":
                  {
                    this.items.push({
                      char: char2,
                      offset
                    });
                    offset += 1;
                  }
                  break;
                case "#":
                  {
                    const comment = new Comment();
                    offset = comment.parse({
                      src
                    }, offset);
                    this.items.push(comment);
                  }
                  break;
                case "?":
                case ":": {
                  const next = src[offset + 1];
                  if (next === "\n" || next === "	" || next === " " || next === "," || char2 === ":" && this.prevNodeIsJsonLike()) {
                    this.items.push({
                      char: char2,
                      offset
                    });
                    offset += 1;
                    break;
                  }
                }
                default: {
                  const node = parseNode({
                    atLineStart: false,
                    inCollection: false,
                    inFlow: true,
                    indent: -1,
                    lineStart,
                    parent: this
                  }, offset);
                  if (!node) {
                    this.valueRange = new PlainValue.Range(start, offset);
                    return offset;
                  }
                  this.items.push(node);
                  offset = PlainValue.Node.normalizeOffset(src, node.range.end);
                }
              }
              offset = PlainValue.Node.endOfWhiteSpace(src, offset);
              char2 = src[offset];
            }
            this.valueRange = new PlainValue.Range(start, offset + 1);
            if (char2) {
              this.items.push({
                char: char2,
                offset
              });
              offset = PlainValue.Node.endOfWhiteSpace(src, offset + 1);
              offset = this.parseComment(offset);
            }
            return offset;
          }
          setOrigRanges(cr, offset) {
            offset = super.setOrigRanges(cr, offset);
            this.items.forEach((node) => {
              if (node instanceof PlainValue.Node) {
                offset = node.setOrigRanges(cr, offset);
              } else if (cr.length === 0) {
                node.origOffset = node.offset;
              } else {
                let i = offset;
                while (i < cr.length) {
                  if (cr[i] > node.offset)
                    break;
                  else
                    ++i;
                }
                node.origOffset = node.offset + i;
                offset = i;
              }
            });
            return offset;
          }
          toString() {
            const {
              context: {
                src
              },
              items,
              range,
              value
            } = this;
            if (value != null)
              return value;
            const nodes = items.filter((item) => item instanceof PlainValue.Node);
            let str = "";
            let prevEnd = range.start;
            nodes.forEach((node) => {
              const prefix = src.slice(prevEnd, node.range.start);
              prevEnd = node.range.end;
              str += prefix + String(node);
              if (str[str.length - 1] === "\n" && src[prevEnd - 1] !== "\n" && src[prevEnd] === "\n") {
                prevEnd += 1;
              }
            });
            str += src.slice(prevEnd, range.end);
            return PlainValue.Node.addStringTerminator(src, range.end, str);
          }
        };
        var QuoteDouble = class extends PlainValue.Node {
          static endOfQuote(src, offset) {
            let ch = src[offset];
            while (ch && ch !== '"') {
              offset += ch === "\\" ? 2 : 1;
              ch = src[offset];
            }
            return offset + 1;
          }
          get strValue() {
            if (!this.valueRange || !this.context)
              return null;
            const errors = [];
            const {
              start,
              end
            } = this.valueRange;
            const {
              indent,
              src
            } = this.context;
            if (src[end - 1] !== '"')
              errors.push(new PlainValue.YAMLSyntaxError(this, 'Missing closing "quote'));
            let str = "";
            for (let i = start + 1; i < end - 1; ++i) {
              const ch = src[i];
              if (ch === "\n") {
                if (PlainValue.Node.atDocumentBoundary(src, i + 1))
                  errors.push(new PlainValue.YAMLSemanticError(this, "Document boundary indicators are not allowed within string values"));
                const {
                  fold,
                  offset,
                  error
                } = PlainValue.Node.foldNewline(src, i, indent);
                str += fold;
                i = offset;
                if (error)
                  errors.push(new PlainValue.YAMLSemanticError(this, "Multi-line double-quoted string needs to be sufficiently indented"));
              } else if (ch === "\\") {
                i += 1;
                switch (src[i]) {
                  case "0":
                    str += "\0";
                    break;
                  case "a":
                    str += "\x07";
                    break;
                  case "b":
                    str += "\b";
                    break;
                  case "e":
                    str += "\x1B";
                    break;
                  case "f":
                    str += "\f";
                    break;
                  case "n":
                    str += "\n";
                    break;
                  case "r":
                    str += "\r";
                    break;
                  case "t":
                    str += "	";
                    break;
                  case "v":
                    str += "\v";
                    break;
                  case "N":
                    str += "\x85";
                    break;
                  case "_":
                    str += "\xA0";
                    break;
                  case "L":
                    str += "\u2028";
                    break;
                  case "P":
                    str += "\u2029";
                    break;
                  case " ":
                    str += " ";
                    break;
                  case '"':
                    str += '"';
                    break;
                  case "/":
                    str += "/";
                    break;
                  case "\\":
                    str += "\\";
                    break;
                  case "	":
                    str += "	";
                    break;
                  case "x":
                    str += this.parseCharCode(i + 1, 2, errors);
                    i += 2;
                    break;
                  case "u":
                    str += this.parseCharCode(i + 1, 4, errors);
                    i += 4;
                    break;
                  case "U":
                    str += this.parseCharCode(i + 1, 8, errors);
                    i += 8;
                    break;
                  case "\n":
                    while (src[i + 1] === " " || src[i + 1] === "	")
                      i += 1;
                    break;
                  default:
                    errors.push(new PlainValue.YAMLSyntaxError(this, `Invalid escape sequence ${src.substr(i - 1, 2)}`));
                    str += "\\" + src[i];
                }
              } else if (ch === " " || ch === "	") {
                const wsStart = i;
                let next = src[i + 1];
                while (next === " " || next === "	") {
                  i += 1;
                  next = src[i + 1];
                }
                if (next !== "\n")
                  str += i > wsStart ? src.slice(wsStart, i + 1) : ch;
              } else {
                str += ch;
              }
            }
            return errors.length > 0 ? {
              errors,
              str
            } : str;
          }
          parseCharCode(offset, length, errors) {
            const {
              src
            } = this.context;
            const cc = src.substr(offset, length);
            const ok = cc.length === length && /^[0-9a-fA-F]+$/.test(cc);
            const code = ok ? parseInt(cc, 16) : NaN;
            if (isNaN(code)) {
              errors.push(new PlainValue.YAMLSyntaxError(this, `Invalid escape sequence ${src.substr(offset - 2, length + 2)}`));
              return src.substr(offset - 2, length + 2);
            }
            return String.fromCodePoint(code);
          }
          parse(context, start) {
            this.context = context;
            const {
              src
            } = context;
            let offset = QuoteDouble.endOfQuote(src, start + 1);
            this.valueRange = new PlainValue.Range(start, offset);
            offset = PlainValue.Node.endOfWhiteSpace(src, offset);
            offset = this.parseComment(offset);
            return offset;
          }
        };
        var QuoteSingle = class extends PlainValue.Node {
          static endOfQuote(src, offset) {
            let ch = src[offset];
            while (ch) {
              if (ch === "'") {
                if (src[offset + 1] !== "'")
                  break;
                ch = src[offset += 2];
              } else {
                ch = src[offset += 1];
              }
            }
            return offset + 1;
          }
          get strValue() {
            if (!this.valueRange || !this.context)
              return null;
            const errors = [];
            const {
              start,
              end
            } = this.valueRange;
            const {
              indent,
              src
            } = this.context;
            if (src[end - 1] !== "'")
              errors.push(new PlainValue.YAMLSyntaxError(this, "Missing closing 'quote"));
            let str = "";
            for (let i = start + 1; i < end - 1; ++i) {
              const ch = src[i];
              if (ch === "\n") {
                if (PlainValue.Node.atDocumentBoundary(src, i + 1))
                  errors.push(new PlainValue.YAMLSemanticError(this, "Document boundary indicators are not allowed within string values"));
                const {
                  fold,
                  offset,
                  error
                } = PlainValue.Node.foldNewline(src, i, indent);
                str += fold;
                i = offset;
                if (error)
                  errors.push(new PlainValue.YAMLSemanticError(this, "Multi-line single-quoted string needs to be sufficiently indented"));
              } else if (ch === "'") {
                str += ch;
                i += 1;
                if (src[i] !== "'")
                  errors.push(new PlainValue.YAMLSyntaxError(this, "Unescaped single quote? This should not happen."));
              } else if (ch === " " || ch === "	") {
                const wsStart = i;
                let next = src[i + 1];
                while (next === " " || next === "	") {
                  i += 1;
                  next = src[i + 1];
                }
                if (next !== "\n")
                  str += i > wsStart ? src.slice(wsStart, i + 1) : ch;
              } else {
                str += ch;
              }
            }
            return errors.length > 0 ? {
              errors,
              str
            } : str;
          }
          parse(context, start) {
            this.context = context;
            const {
              src
            } = context;
            let offset = QuoteSingle.endOfQuote(src, start + 1);
            this.valueRange = new PlainValue.Range(start, offset);
            offset = PlainValue.Node.endOfWhiteSpace(src, offset);
            offset = this.parseComment(offset);
            return offset;
          }
        };
        function createNewNode(type, props) {
          switch (type) {
            case PlainValue.Type.ALIAS:
              return new Alias(type, props);
            case PlainValue.Type.BLOCK_FOLDED:
            case PlainValue.Type.BLOCK_LITERAL:
              return new BlockValue(type, props);
            case PlainValue.Type.FLOW_MAP:
            case PlainValue.Type.FLOW_SEQ:
              return new FlowCollection(type, props);
            case PlainValue.Type.MAP_KEY:
            case PlainValue.Type.MAP_VALUE:
            case PlainValue.Type.SEQ_ITEM:
              return new CollectionItem(type, props);
            case PlainValue.Type.COMMENT:
            case PlainValue.Type.PLAIN:
              return new PlainValue.PlainValue(type, props);
            case PlainValue.Type.QUOTE_DOUBLE:
              return new QuoteDouble(type, props);
            case PlainValue.Type.QUOTE_SINGLE:
              return new QuoteSingle(type, props);
            default:
              return null;
          }
        }
        var ParseContext = class {
          static parseType(src, offset, inFlow) {
            switch (src[offset]) {
              case "*":
                return PlainValue.Type.ALIAS;
              case ">":
                return PlainValue.Type.BLOCK_FOLDED;
              case "|":
                return PlainValue.Type.BLOCK_LITERAL;
              case "{":
                return PlainValue.Type.FLOW_MAP;
              case "[":
                return PlainValue.Type.FLOW_SEQ;
              case "?":
                return !inFlow && PlainValue.Node.atBlank(src, offset + 1, true) ? PlainValue.Type.MAP_KEY : PlainValue.Type.PLAIN;
              case ":":
                return !inFlow && PlainValue.Node.atBlank(src, offset + 1, true) ? PlainValue.Type.MAP_VALUE : PlainValue.Type.PLAIN;
              case "-":
                return !inFlow && PlainValue.Node.atBlank(src, offset + 1, true) ? PlainValue.Type.SEQ_ITEM : PlainValue.Type.PLAIN;
              case '"':
                return PlainValue.Type.QUOTE_DOUBLE;
              case "'":
                return PlainValue.Type.QUOTE_SINGLE;
              default:
                return PlainValue.Type.PLAIN;
            }
          }
          constructor(orig = {}, {
            atLineStart,
            inCollection,
            inFlow,
            indent,
            lineStart,
            parent
          } = {}) {
            PlainValue._defineProperty(this, "parseNode", (overlay, start) => {
              if (PlainValue.Node.atDocumentBoundary(this.src, start))
                return null;
              const context = new ParseContext(this, overlay);
              const {
                props,
                type,
                valueStart
              } = context.parseProps(start);
              const node = createNewNode(type, props);
              let offset = node.parse(context, valueStart);
              node.range = new PlainValue.Range(start, offset);
              if (offset <= start) {
                node.error = new Error(`Node#parse consumed no characters`);
                node.error.parseEnd = offset;
                node.error.source = node;
                node.range.end = start + 1;
              }
              if (context.nodeStartsCollection(node)) {
                if (!node.error && !context.atLineStart && context.parent.type === PlainValue.Type.DOCUMENT) {
                  node.error = new PlainValue.YAMLSyntaxError(node, "Block collection must not have preceding content here (e.g. directives-end indicator)");
                }
                const collection = new Collection(node);
                offset = collection.parse(new ParseContext(context), offset);
                collection.range = new PlainValue.Range(start, offset);
                return collection;
              }
              return node;
            });
            this.atLineStart = atLineStart != null ? atLineStart : orig.atLineStart || false;
            this.inCollection = inCollection != null ? inCollection : orig.inCollection || false;
            this.inFlow = inFlow != null ? inFlow : orig.inFlow || false;
            this.indent = indent != null ? indent : orig.indent;
            this.lineStart = lineStart != null ? lineStart : orig.lineStart;
            this.parent = parent != null ? parent : orig.parent || {};
            this.root = orig.root;
            this.src = orig.src;
          }
          nodeStartsCollection(node) {
            const {
              inCollection,
              inFlow,
              src
            } = this;
            if (inCollection || inFlow)
              return false;
            if (node instanceof CollectionItem)
              return true;
            let offset = node.range.end;
            if (src[offset] === "\n" || src[offset - 1] === "\n")
              return false;
            offset = PlainValue.Node.endOfWhiteSpace(src, offset);
            return src[offset] === ":";
          }
          parseProps(offset) {
            const {
              inFlow,
              parent,
              src
            } = this;
            const props = [];
            let lineHasProps = false;
            offset = this.atLineStart ? PlainValue.Node.endOfIndent(src, offset) : PlainValue.Node.endOfWhiteSpace(src, offset);
            let ch = src[offset];
            while (ch === PlainValue.Char.ANCHOR || ch === PlainValue.Char.COMMENT || ch === PlainValue.Char.TAG || ch === "\n") {
              if (ch === "\n") {
                let inEnd = offset;
                let lineStart;
                do {
                  lineStart = inEnd + 1;
                  inEnd = PlainValue.Node.endOfIndent(src, lineStart);
                } while (src[inEnd] === "\n");
                const indentDiff = inEnd - (lineStart + this.indent);
                const noIndicatorAsIndent = parent.type === PlainValue.Type.SEQ_ITEM && parent.context.atLineStart;
                if (src[inEnd] !== "#" && !PlainValue.Node.nextNodeIsIndented(src[inEnd], indentDiff, !noIndicatorAsIndent))
                  break;
                this.atLineStart = true;
                this.lineStart = lineStart;
                lineHasProps = false;
                offset = inEnd;
              } else if (ch === PlainValue.Char.COMMENT) {
                const end = PlainValue.Node.endOfLine(src, offset + 1);
                props.push(new PlainValue.Range(offset, end));
                offset = end;
              } else {
                let end = PlainValue.Node.endOfIdentifier(src, offset + 1);
                if (ch === PlainValue.Char.TAG && src[end] === "," && /^[a-zA-Z0-9-]+\.[a-zA-Z0-9-]+,\d\d\d\d(-\d\d){0,2}\/\S/.test(src.slice(offset + 1, end + 13))) {
                  end = PlainValue.Node.endOfIdentifier(src, end + 5);
                }
                props.push(new PlainValue.Range(offset, end));
                lineHasProps = true;
                offset = PlainValue.Node.endOfWhiteSpace(src, end);
              }
              ch = src[offset];
            }
            if (lineHasProps && ch === ":" && PlainValue.Node.atBlank(src, offset + 1, true))
              offset -= 1;
            const type = ParseContext.parseType(src, offset, inFlow);
            return {
              props,
              type,
              valueStart: offset
            };
          }
        };
        function parse2(src) {
          const cr = [];
          if (src.indexOf("\r") !== -1) {
            src = src.replace(/\r\n?/g, (match, offset2) => {
              if (match.length > 1)
                cr.push(offset2);
              return "\n";
            });
          }
          const documents = [];
          let offset = 0;
          do {
            const doc = new Document();
            const context = new ParseContext({
              src
            });
            offset = doc.parse(context, offset);
            documents.push(doc);
          } while (offset < src.length);
          documents.setOrigRanges = () => {
            if (cr.length === 0)
              return false;
            for (let i = 1; i < cr.length; ++i)
              cr[i] -= i;
            let crOffset = 0;
            for (let i = 0; i < documents.length; ++i) {
              crOffset = documents[i].setOrigRanges(cr, crOffset);
            }
            cr.splice(0, cr.length);
            return true;
          };
          documents.toString = () => documents.join("...\n");
          return documents;
        }
        exports2.parse = parse2;
      }
    });
    var require_resolveSeq_d03cb037 = __commonJS2({
      "node_modules/yaml/dist/resolveSeq-d03cb037.js"(exports2) {
        "use strict";
        var PlainValue = require_PlainValue_ec8e588e();
        function addCommentBefore(str, indent, comment) {
          if (!comment)
            return str;
          const cc = comment.replace(/[\s\S]^/gm, `$&${indent}#`);
          return `#${cc}
${indent}${str}`;
        }
        function addComment(str, indent, comment) {
          return !comment ? str : comment.indexOf("\n") === -1 ? `${str} #${comment}` : `${str}
` + comment.replace(/^/gm, `${indent || ""}#`);
        }
        var Node = class {
        };
        function toJSON(value, arg, ctx) {
          if (Array.isArray(value))
            return value.map((v, i) => toJSON(v, String(i), ctx));
          if (value && typeof value.toJSON === "function") {
            const anchor = ctx && ctx.anchors && ctx.anchors.get(value);
            if (anchor)
              ctx.onCreate = (res2) => {
                anchor.res = res2;
                delete ctx.onCreate;
              };
            const res = value.toJSON(arg, ctx);
            if (anchor && ctx.onCreate)
              ctx.onCreate(res);
            return res;
          }
          if ((!ctx || !ctx.keep) && typeof value === "bigint")
            return Number(value);
          return value;
        }
        var Scalar = class extends Node {
          constructor(value) {
            super();
            this.value = value;
          }
          toJSON(arg, ctx) {
            return ctx && ctx.keep ? this.value : toJSON(this.value, arg, ctx);
          }
          toString() {
            return String(this.value);
          }
        };
        function collectionFromPath(schema, path, value) {
          let v = value;
          for (let i = path.length - 1; i >= 0; --i) {
            const k = path[i];
            if (Number.isInteger(k) && k >= 0) {
              const a = [];
              a[k] = v;
              v = a;
            } else {
              const o = {};
              Object.defineProperty(o, k, {
                value: v,
                writable: true,
                enumerable: true,
                configurable: true
              });
              v = o;
            }
          }
          return schema.createNode(v, false);
        }
        var isEmptyPath = (path) => path == null || typeof path === "object" && path[Symbol.iterator]().next().done;
        var Collection = class extends Node {
          constructor(schema) {
            super();
            PlainValue._defineProperty(this, "items", []);
            this.schema = schema;
          }
          addIn(path, value) {
            if (isEmptyPath(path))
              this.add(value);
            else {
              const [key, ...rest] = path;
              const node = this.get(key, true);
              if (node instanceof Collection)
                node.addIn(rest, value);
              else if (node === void 0 && this.schema)
                this.set(key, collectionFromPath(this.schema, rest, value));
              else
                throw new Error(`Expected YAML collection at ${key}. Remaining path: ${rest}`);
            }
          }
          deleteIn([key, ...rest]) {
            if (rest.length === 0)
              return this.delete(key);
            const node = this.get(key, true);
            if (node instanceof Collection)
              return node.deleteIn(rest);
            else
              throw new Error(`Expected YAML collection at ${key}. Remaining path: ${rest}`);
          }
          getIn([key, ...rest], keepScalar) {
            const node = this.get(key, true);
            if (rest.length === 0)
              return !keepScalar && node instanceof Scalar ? node.value : node;
            else
              return node instanceof Collection ? node.getIn(rest, keepScalar) : void 0;
          }
          hasAllNullValues() {
            return this.items.every((node) => {
              if (!node || node.type !== "PAIR")
                return false;
              const n2 = node.value;
              return n2 == null || n2 instanceof Scalar && n2.value == null && !n2.commentBefore && !n2.comment && !n2.tag;
            });
          }
          hasIn([key, ...rest]) {
            if (rest.length === 0)
              return this.has(key);
            const node = this.get(key, true);
            return node instanceof Collection ? node.hasIn(rest) : false;
          }
          setIn([key, ...rest], value) {
            if (rest.length === 0) {
              this.set(key, value);
            } else {
              const node = this.get(key, true);
              if (node instanceof Collection)
                node.setIn(rest, value);
              else if (node === void 0 && this.schema)
                this.set(key, collectionFromPath(this.schema, rest, value));
              else
                throw new Error(`Expected YAML collection at ${key}. Remaining path: ${rest}`);
            }
          }
          toJSON() {
            return null;
          }
          toString(ctx, {
            blockItem,
            flowChars,
            isMap,
            itemIndent
          }, onComment, onChompKeep) {
            const {
              indent,
              indentStep,
              stringify
            } = ctx;
            const inFlow = this.type === PlainValue.Type.FLOW_MAP || this.type === PlainValue.Type.FLOW_SEQ || ctx.inFlow;
            if (inFlow)
              itemIndent += indentStep;
            const allNullValues = isMap && this.hasAllNullValues();
            ctx = Object.assign({}, ctx, {
              allNullValues,
              indent: itemIndent,
              inFlow,
              type: null
            });
            let chompKeep = false;
            let hasItemWithNewLine = false;
            const nodes = this.items.reduce((nodes2, item, i) => {
              let comment;
              if (item) {
                if (!chompKeep && item.spaceBefore)
                  nodes2.push({
                    type: "comment",
                    str: ""
                  });
                if (item.commentBefore)
                  item.commentBefore.match(/^.*$/gm).forEach((line) => {
                    nodes2.push({
                      type: "comment",
                      str: `#${line}`
                    });
                  });
                if (item.comment)
                  comment = item.comment;
                if (inFlow && (!chompKeep && item.spaceBefore || item.commentBefore || item.comment || item.key && (item.key.commentBefore || item.key.comment) || item.value && (item.value.commentBefore || item.value.comment)))
                  hasItemWithNewLine = true;
              }
              chompKeep = false;
              let str2 = stringify(item, ctx, () => comment = null, () => chompKeep = true);
              if (inFlow && !hasItemWithNewLine && str2.includes("\n"))
                hasItemWithNewLine = true;
              if (inFlow && i < this.items.length - 1)
                str2 += ",";
              str2 = addComment(str2, itemIndent, comment);
              if (chompKeep && (comment || inFlow))
                chompKeep = false;
              nodes2.push({
                type: "item",
                str: str2
              });
              return nodes2;
            }, []);
            let str;
            if (nodes.length === 0) {
              str = flowChars.start + flowChars.end;
            } else if (inFlow) {
              const {
                start,
                end
              } = flowChars;
              const strings = nodes.map((n2) => n2.str);
              if (hasItemWithNewLine || strings.reduce((sum, str2) => sum + str2.length + 2, 2) > Collection.maxFlowStringSingleLineLength) {
                str = start;
                for (const s of strings) {
                  str += s ? `
${indentStep}${indent}${s}` : "\n";
                }
                str += `
${indent}${end}`;
              } else {
                str = `${start} ${strings.join(" ")} ${end}`;
              }
            } else {
              const strings = nodes.map(blockItem);
              str = strings.shift();
              for (const s of strings)
                str += s ? `
${indent}${s}` : "\n";
            }
            if (this.comment) {
              str += "\n" + this.comment.replace(/^/gm, `${indent}#`);
              if (onComment)
                onComment();
            } else if (chompKeep && onChompKeep)
              onChompKeep();
            return str;
          }
        };
        PlainValue._defineProperty(Collection, "maxFlowStringSingleLineLength", 60);
        function asItemIndex(key) {
          let idx = key instanceof Scalar ? key.value : key;
          if (idx && typeof idx === "string")
            idx = Number(idx);
          return Number.isInteger(idx) && idx >= 0 ? idx : null;
        }
        var YAMLSeq = class extends Collection {
          add(value) {
            this.items.push(value);
          }
          delete(key) {
            const idx = asItemIndex(key);
            if (typeof idx !== "number")
              return false;
            const del = this.items.splice(idx, 1);
            return del.length > 0;
          }
          get(key, keepScalar) {
            const idx = asItemIndex(key);
            if (typeof idx !== "number")
              return void 0;
            const it = this.items[idx];
            return !keepScalar && it instanceof Scalar ? it.value : it;
          }
          has(key) {
            const idx = asItemIndex(key);
            return typeof idx === "number" && idx < this.items.length;
          }
          set(key, value) {
            const idx = asItemIndex(key);
            if (typeof idx !== "number")
              throw new Error(`Expected a valid index, not ${key}.`);
            this.items[idx] = value;
          }
          toJSON(_, ctx) {
            const seq = [];
            if (ctx && ctx.onCreate)
              ctx.onCreate(seq);
            let i = 0;
            for (const item of this.items)
              seq.push(toJSON(item, String(i++), ctx));
            return seq;
          }
          toString(ctx, onComment, onChompKeep) {
            if (!ctx)
              return JSON.stringify(this);
            return super.toString(ctx, {
              blockItem: (n2) => n2.type === "comment" ? n2.str : `- ${n2.str}`,
              flowChars: {
                start: "[",
                end: "]"
              },
              isMap: false,
              itemIndent: (ctx.indent || "") + "  "
            }, onComment, onChompKeep);
          }
        };
        var stringifyKey = (key, jsKey, ctx) => {
          if (jsKey === null)
            return "";
          if (typeof jsKey !== "object")
            return String(jsKey);
          if (key instanceof Node && ctx && ctx.doc)
            return key.toString({
              anchors: /* @__PURE__ */ Object.create(null),
              doc: ctx.doc,
              indent: "",
              indentStep: ctx.indentStep,
              inFlow: true,
              inStringifyKey: true,
              stringify: ctx.stringify
            });
          return JSON.stringify(jsKey);
        };
        var Pair = class extends Node {
          constructor(key, value = null) {
            super();
            this.key = key;
            this.value = value;
            this.type = Pair.Type.PAIR;
          }
          get commentBefore() {
            return this.key instanceof Node ? this.key.commentBefore : void 0;
          }
          set commentBefore(cb) {
            if (this.key == null)
              this.key = new Scalar(null);
            if (this.key instanceof Node)
              this.key.commentBefore = cb;
            else {
              const msg = "Pair.commentBefore is an alias for Pair.key.commentBefore. To set it, the key must be a Node.";
              throw new Error(msg);
            }
          }
          addToJSMap(ctx, map) {
            const key = toJSON(this.key, "", ctx);
            if (map instanceof Map) {
              const value = toJSON(this.value, key, ctx);
              map.set(key, value);
            } else if (map instanceof Set) {
              map.add(key);
            } else {
              const stringKey = stringifyKey(this.key, key, ctx);
              const value = toJSON(this.value, stringKey, ctx);
              if (stringKey in map)
                Object.defineProperty(map, stringKey, {
                  value,
                  writable: true,
                  enumerable: true,
                  configurable: true
                });
              else
                map[stringKey] = value;
            }
            return map;
          }
          toJSON(_, ctx) {
            const pair = ctx && ctx.mapAsMap ? /* @__PURE__ */ new Map() : {};
            return this.addToJSMap(ctx, pair);
          }
          toString(ctx, onComment, onChompKeep) {
            if (!ctx || !ctx.doc)
              return JSON.stringify(this);
            const {
              indent: indentSize,
              indentSeq,
              simpleKeys
            } = ctx.doc.options;
            let {
              key,
              value
            } = this;
            let keyComment = key instanceof Node && key.comment;
            if (simpleKeys) {
              if (keyComment) {
                throw new Error("With simple keys, key nodes cannot have comments");
              }
              if (key instanceof Collection) {
                const msg = "With simple keys, collection cannot be used as a key value";
                throw new Error(msg);
              }
            }
            let explicitKey = !simpleKeys && (!key || keyComment || (key instanceof Node ? key instanceof Collection || key.type === PlainValue.Type.BLOCK_FOLDED || key.type === PlainValue.Type.BLOCK_LITERAL : typeof key === "object"));
            const {
              doc,
              indent,
              indentStep,
              stringify
            } = ctx;
            ctx = Object.assign({}, ctx, {
              implicitKey: !explicitKey,
              indent: indent + indentStep
            });
            let chompKeep = false;
            let str = stringify(key, ctx, () => keyComment = null, () => chompKeep = true);
            str = addComment(str, ctx.indent, keyComment);
            if (!explicitKey && str.length > 1024) {
              if (simpleKeys)
                throw new Error("With simple keys, single line scalar must not span more than 1024 characters");
              explicitKey = true;
            }
            if (ctx.allNullValues && !simpleKeys) {
              if (this.comment) {
                str = addComment(str, ctx.indent, this.comment);
                if (onComment)
                  onComment();
              } else if (chompKeep && !keyComment && onChompKeep)
                onChompKeep();
              return ctx.inFlow && !explicitKey ? str : `? ${str}`;
            }
            str = explicitKey ? `? ${str}
${indent}:` : `${str}:`;
            if (this.comment) {
              str = addComment(str, ctx.indent, this.comment);
              if (onComment)
                onComment();
            }
            let vcb = "";
            let valueComment = null;
            if (value instanceof Node) {
              if (value.spaceBefore)
                vcb = "\n";
              if (value.commentBefore) {
                const cs = value.commentBefore.replace(/^/gm, `${ctx.indent}#`);
                vcb += `
${cs}`;
              }
              valueComment = value.comment;
            } else if (value && typeof value === "object") {
              value = doc.schema.createNode(value, true);
            }
            ctx.implicitKey = false;
            if (!explicitKey && !this.comment && value instanceof Scalar)
              ctx.indentAtStart = str.length + 1;
            chompKeep = false;
            if (!indentSeq && indentSize >= 2 && !ctx.inFlow && !explicitKey && value instanceof YAMLSeq && value.type !== PlainValue.Type.FLOW_SEQ && !value.tag && !doc.anchors.getName(value)) {
              ctx.indent = ctx.indent.substr(2);
            }
            const valueStr = stringify(value, ctx, () => valueComment = null, () => chompKeep = true);
            let ws = " ";
            if (vcb || this.comment) {
              ws = `${vcb}
${ctx.indent}`;
            } else if (!explicitKey && value instanceof Collection) {
              const flow = valueStr[0] === "[" || valueStr[0] === "{";
              if (!flow || valueStr.includes("\n"))
                ws = `
${ctx.indent}`;
            } else if (valueStr[0] === "\n")
              ws = "";
            if (chompKeep && !valueComment && onChompKeep)
              onChompKeep();
            return addComment(str + ws + valueStr, ctx.indent, valueComment);
          }
        };
        PlainValue._defineProperty(Pair, "Type", {
          PAIR: "PAIR",
          MERGE_PAIR: "MERGE_PAIR"
        });
        var getAliasCount = (node, anchors) => {
          if (node instanceof Alias) {
            const anchor = anchors.get(node.source);
            return anchor.count * anchor.aliasCount;
          } else if (node instanceof Collection) {
            let count = 0;
            for (const item of node.items) {
              const c = getAliasCount(item, anchors);
              if (c > count)
                count = c;
            }
            return count;
          } else if (node instanceof Pair) {
            const kc = getAliasCount(node.key, anchors);
            const vc = getAliasCount(node.value, anchors);
            return Math.max(kc, vc);
          }
          return 1;
        };
        var Alias = class extends Node {
          static stringify({
            range,
            source
          }, {
            anchors,
            doc,
            implicitKey,
            inStringifyKey
          }) {
            let anchor = Object.keys(anchors).find((a) => anchors[a] === source);
            if (!anchor && inStringifyKey)
              anchor = doc.anchors.getName(source) || doc.anchors.newName();
            if (anchor)
              return `*${anchor}${implicitKey ? " " : ""}`;
            const msg = doc.anchors.getName(source) ? "Alias node must be after source node" : "Source node not found for alias node";
            throw new Error(`${msg} [${range}]`);
          }
          constructor(source) {
            super();
            this.source = source;
            this.type = PlainValue.Type.ALIAS;
          }
          set tag(t) {
            throw new Error("Alias nodes cannot have tags");
          }
          toJSON(arg, ctx) {
            if (!ctx)
              return toJSON(this.source, arg, ctx);
            const {
              anchors,
              maxAliasCount
            } = ctx;
            const anchor = anchors.get(this.source);
            if (!anchor || anchor.res === void 0) {
              const msg = "This should not happen: Alias anchor was not resolved?";
              if (this.cstNode)
                throw new PlainValue.YAMLReferenceError(this.cstNode, msg);
              else
                throw new ReferenceError(msg);
            }
            if (maxAliasCount >= 0) {
              anchor.count += 1;
              if (anchor.aliasCount === 0)
                anchor.aliasCount = getAliasCount(this.source, anchors);
              if (anchor.count * anchor.aliasCount > maxAliasCount) {
                const msg = "Excessive alias count indicates a resource exhaustion attack";
                if (this.cstNode)
                  throw new PlainValue.YAMLReferenceError(this.cstNode, msg);
                else
                  throw new ReferenceError(msg);
              }
            }
            return anchor.res;
          }
          toString(ctx) {
            return Alias.stringify(this, ctx);
          }
        };
        PlainValue._defineProperty(Alias, "default", true);
        function findPair(items, key) {
          const k = key instanceof Scalar ? key.value : key;
          for (const it of items) {
            if (it instanceof Pair) {
              if (it.key === key || it.key === k)
                return it;
              if (it.key && it.key.value === k)
                return it;
            }
          }
          return void 0;
        }
        var YAMLMap = class extends Collection {
          add(pair, overwrite) {
            if (!pair)
              pair = new Pair(pair);
            else if (!(pair instanceof Pair))
              pair = new Pair(pair.key || pair, pair.value);
            const prev = findPair(this.items, pair.key);
            const sortEntries = this.schema && this.schema.sortMapEntries;
            if (prev) {
              if (overwrite)
                prev.value = pair.value;
              else
                throw new Error(`Key ${pair.key} already set`);
            } else if (sortEntries) {
              const i = this.items.findIndex((item) => sortEntries(pair, item) < 0);
              if (i === -1)
                this.items.push(pair);
              else
                this.items.splice(i, 0, pair);
            } else {
              this.items.push(pair);
            }
          }
          delete(key) {
            const it = findPair(this.items, key);
            if (!it)
              return false;
            const del = this.items.splice(this.items.indexOf(it), 1);
            return del.length > 0;
          }
          get(key, keepScalar) {
            const it = findPair(this.items, key);
            const node = it && it.value;
            return !keepScalar && node instanceof Scalar ? node.value : node;
          }
          has(key) {
            return !!findPair(this.items, key);
          }
          set(key, value) {
            this.add(new Pair(key, value), true);
          }
          toJSON(_, ctx, Type) {
            const map = Type ? new Type() : ctx && ctx.mapAsMap ? /* @__PURE__ */ new Map() : {};
            if (ctx && ctx.onCreate)
              ctx.onCreate(map);
            for (const item of this.items)
              item.addToJSMap(ctx, map);
            return map;
          }
          toString(ctx, onComment, onChompKeep) {
            if (!ctx)
              return JSON.stringify(this);
            for (const item of this.items) {
              if (!(item instanceof Pair))
                throw new Error(`Map items must all be pairs; found ${JSON.stringify(item)} instead`);
            }
            return super.toString(ctx, {
              blockItem: (n2) => n2.str,
              flowChars: {
                start: "{",
                end: "}"
              },
              isMap: true,
              itemIndent: ctx.indent || ""
            }, onComment, onChompKeep);
          }
        };
        var MERGE_KEY = "<<";
        var Merge = class extends Pair {
          constructor(pair) {
            if (pair instanceof Pair) {
              let seq = pair.value;
              if (!(seq instanceof YAMLSeq)) {
                seq = new YAMLSeq();
                seq.items.push(pair.value);
                seq.range = pair.value.range;
              }
              super(pair.key, seq);
              this.range = pair.range;
            } else {
              super(new Scalar(MERGE_KEY), new YAMLSeq());
            }
            this.type = Pair.Type.MERGE_PAIR;
          }
          addToJSMap(ctx, map) {
            for (const {
              source
            } of this.value.items) {
              if (!(source instanceof YAMLMap))
                throw new Error("Merge sources must be maps");
              const srcMap = source.toJSON(null, ctx, Map);
              for (const [key, value] of srcMap) {
                if (map instanceof Map) {
                  if (!map.has(key))
                    map.set(key, value);
                } else if (map instanceof Set) {
                  map.add(key);
                } else if (!Object.prototype.hasOwnProperty.call(map, key)) {
                  Object.defineProperty(map, key, {
                    value,
                    writable: true,
                    enumerable: true,
                    configurable: true
                  });
                }
              }
            }
            return map;
          }
          toString(ctx, onComment) {
            const seq = this.value;
            if (seq.items.length > 1)
              return super.toString(ctx, onComment);
            this.value = seq.items[0];
            const str = super.toString(ctx, onComment);
            this.value = seq;
            return str;
          }
        };
        var binaryOptions = {
          defaultType: PlainValue.Type.BLOCK_LITERAL,
          lineWidth: 76
        };
        var boolOptions = {
          trueStr: "true",
          falseStr: "false"
        };
        var intOptions = {
          asBigInt: false
        };
        var nullOptions = {
          nullStr: "null"
        };
        var strOptions = {
          defaultType: PlainValue.Type.PLAIN,
          doubleQuoted: {
            jsonEncoding: false,
            minMultiLineLength: 40
          },
          fold: {
            lineWidth: 80,
            minContentWidth: 20
          }
        };
        function resolveScalar(str, tags, scalarFallback) {
          for (const {
            format: format2,
            test,
            resolve
          } of tags) {
            if (test) {
              const match = str.match(test);
              if (match) {
                let res = resolve.apply(null, match);
                if (!(res instanceof Scalar))
                  res = new Scalar(res);
                if (format2)
                  res.format = format2;
                return res;
              }
            }
          }
          if (scalarFallback)
            str = scalarFallback(str);
          return new Scalar(str);
        }
        var FOLD_FLOW = "flow";
        var FOLD_BLOCK = "block";
        var FOLD_QUOTED = "quoted";
        var consumeMoreIndentedLines = (text, i) => {
          let ch = text[i + 1];
          while (ch === " " || ch === "	") {
            do {
              ch = text[i += 1];
            } while (ch && ch !== "\n");
            ch = text[i + 1];
          }
          return i;
        };
        function foldFlowLines(text, indent, mode, {
          indentAtStart,
          lineWidth = 80,
          minContentWidth = 20,
          onFold,
          onOverflow
        }) {
          if (!lineWidth || lineWidth < 0)
            return text;
          const endStep = Math.max(1 + minContentWidth, 1 + lineWidth - indent.length);
          if (text.length <= endStep)
            return text;
          const folds = [];
          const escapedFolds = {};
          let end = lineWidth - indent.length;
          if (typeof indentAtStart === "number") {
            if (indentAtStart > lineWidth - Math.max(2, minContentWidth))
              folds.push(0);
            else
              end = lineWidth - indentAtStart;
          }
          let split = void 0;
          let prev = void 0;
          let overflow = false;
          let i = -1;
          let escStart = -1;
          let escEnd = -1;
          if (mode === FOLD_BLOCK) {
            i = consumeMoreIndentedLines(text, i);
            if (i !== -1)
              end = i + endStep;
          }
          for (let ch; ch = text[i += 1]; ) {
            if (mode === FOLD_QUOTED && ch === "\\") {
              escStart = i;
              switch (text[i + 1]) {
                case "x":
                  i += 3;
                  break;
                case "u":
                  i += 5;
                  break;
                case "U":
                  i += 9;
                  break;
                default:
                  i += 1;
              }
              escEnd = i;
            }
            if (ch === "\n") {
              if (mode === FOLD_BLOCK)
                i = consumeMoreIndentedLines(text, i);
              end = i + endStep;
              split = void 0;
            } else {
              if (ch === " " && prev && prev !== " " && prev !== "\n" && prev !== "	") {
                const next = text[i + 1];
                if (next && next !== " " && next !== "\n" && next !== "	")
                  split = i;
              }
              if (i >= end) {
                if (split) {
                  folds.push(split);
                  end = split + endStep;
                  split = void 0;
                } else if (mode === FOLD_QUOTED) {
                  while (prev === " " || prev === "	") {
                    prev = ch;
                    ch = text[i += 1];
                    overflow = true;
                  }
                  const j = i > escEnd + 1 ? i - 2 : escStart - 1;
                  if (escapedFolds[j])
                    return text;
                  folds.push(j);
                  escapedFolds[j] = true;
                  end = j + endStep;
                  split = void 0;
                } else {
                  overflow = true;
                }
              }
            }
            prev = ch;
          }
          if (overflow && onOverflow)
            onOverflow();
          if (folds.length === 0)
            return text;
          if (onFold)
            onFold();
          let res = text.slice(0, folds[0]);
          for (let i2 = 0; i2 < folds.length; ++i2) {
            const fold = folds[i2];
            const end2 = folds[i2 + 1] || text.length;
            if (fold === 0)
              res = `
${indent}${text.slice(0, end2)}`;
            else {
              if (mode === FOLD_QUOTED && escapedFolds[fold])
                res += `${text[fold]}\\`;
              res += `
${indent}${text.slice(fold + 1, end2)}`;
            }
          }
          return res;
        }
        var getFoldOptions = ({
          indentAtStart
        }) => indentAtStart ? Object.assign({
          indentAtStart
        }, strOptions.fold) : strOptions.fold;
        var containsDocumentMarker = (str) => /^(%|---|\.\.\.)/m.test(str);
        function lineLengthOverLimit(str, lineWidth, indentLength) {
          if (!lineWidth || lineWidth < 0)
            return false;
          const limit = lineWidth - indentLength;
          const strLen = str.length;
          if (strLen <= limit)
            return false;
          for (let i = 0, start = 0; i < strLen; ++i) {
            if (str[i] === "\n") {
              if (i - start > limit)
                return true;
              start = i + 1;
              if (strLen - start <= limit)
                return false;
            }
          }
          return true;
        }
        function doubleQuotedString(value, ctx) {
          const {
            implicitKey
          } = ctx;
          const {
            jsonEncoding,
            minMultiLineLength
          } = strOptions.doubleQuoted;
          const json = JSON.stringify(value);
          if (jsonEncoding)
            return json;
          const indent = ctx.indent || (containsDocumentMarker(value) ? "  " : "");
          let str = "";
          let start = 0;
          for (let i = 0, ch = json[i]; ch; ch = json[++i]) {
            if (ch === " " && json[i + 1] === "\\" && json[i + 2] === "n") {
              str += json.slice(start, i) + "\\ ";
              i += 1;
              start = i;
              ch = "\\";
            }
            if (ch === "\\")
              switch (json[i + 1]) {
                case "u":
                  {
                    str += json.slice(start, i);
                    const code = json.substr(i + 2, 4);
                    switch (code) {
                      case "0000":
                        str += "\\0";
                        break;
                      case "0007":
                        str += "\\a";
                        break;
                      case "000b":
                        str += "\\v";
                        break;
                      case "001b":
                        str += "\\e";
                        break;
                      case "0085":
                        str += "\\N";
                        break;
                      case "00a0":
                        str += "\\_";
                        break;
                      case "2028":
                        str += "\\L";
                        break;
                      case "2029":
                        str += "\\P";
                        break;
                      default:
                        if (code.substr(0, 2) === "00")
                          str += "\\x" + code.substr(2);
                        else
                          str += json.substr(i, 6);
                    }
                    i += 5;
                    start = i + 1;
                  }
                  break;
                case "n":
                  if (implicitKey || json[i + 2] === '"' || json.length < minMultiLineLength) {
                    i += 1;
                  } else {
                    str += json.slice(start, i) + "\n\n";
                    while (json[i + 2] === "\\" && json[i + 3] === "n" && json[i + 4] !== '"') {
                      str += "\n";
                      i += 2;
                    }
                    str += indent;
                    if (json[i + 2] === " ")
                      str += "\\";
                    i += 1;
                    start = i + 1;
                  }
                  break;
                default:
                  i += 1;
              }
          }
          str = start ? str + json.slice(start) : json;
          return implicitKey ? str : foldFlowLines(str, indent, FOLD_QUOTED, getFoldOptions(ctx));
        }
        function singleQuotedString(value, ctx) {
          if (ctx.implicitKey) {
            if (/\n/.test(value))
              return doubleQuotedString(value, ctx);
          } else {
            if (/[ \t]\n|\n[ \t]/.test(value))
              return doubleQuotedString(value, ctx);
          }
          const indent = ctx.indent || (containsDocumentMarker(value) ? "  " : "");
          const res = "'" + value.replace(/'/g, "''").replace(/\n+/g, `$&
${indent}`) + "'";
          return ctx.implicitKey ? res : foldFlowLines(res, indent, FOLD_FLOW, getFoldOptions(ctx));
        }
        function blockString({
          comment,
          type,
          value
        }, ctx, onComment, onChompKeep) {
          if (/\n[\t ]+$/.test(value) || /^\s*$/.test(value)) {
            return doubleQuotedString(value, ctx);
          }
          const indent = ctx.indent || (ctx.forceBlockIndent || containsDocumentMarker(value) ? "  " : "");
          const indentSize = indent ? "2" : "1";
          const literal = type === PlainValue.Type.BLOCK_FOLDED ? false : type === PlainValue.Type.BLOCK_LITERAL ? true : !lineLengthOverLimit(value, strOptions.fold.lineWidth, indent.length);
          let header = literal ? "|" : ">";
          if (!value)
            return header + "\n";
          let wsStart = "";
          let wsEnd = "";
          value = value.replace(/[\n\t ]*$/, (ws) => {
            const n2 = ws.indexOf("\n");
            if (n2 === -1) {
              header += "-";
            } else if (value === ws || n2 !== ws.length - 1) {
              header += "+";
              if (onChompKeep)
                onChompKeep();
            }
            wsEnd = ws.replace(/\n$/, "");
            return "";
          }).replace(/^[\n ]*/, (ws) => {
            if (ws.indexOf(" ") !== -1)
              header += indentSize;
            const m = ws.match(/ +$/);
            if (m) {
              wsStart = ws.slice(0, -m[0].length);
              return m[0];
            } else {
              wsStart = ws;
              return "";
            }
          });
          if (wsEnd)
            wsEnd = wsEnd.replace(/\n+(?!\n|$)/g, `$&${indent}`);
          if (wsStart)
            wsStart = wsStart.replace(/\n+/g, `$&${indent}`);
          if (comment) {
            header += " #" + comment.replace(/ ?[\r\n]+/g, " ");
            if (onComment)
              onComment();
          }
          if (!value)
            return `${header}${indentSize}
${indent}${wsEnd}`;
          if (literal) {
            value = value.replace(/\n+/g, `$&${indent}`);
            return `${header}
${indent}${wsStart}${value}${wsEnd}`;
          }
          value = value.replace(/\n+/g, "\n$&").replace(/(?:^|\n)([\t ].*)(?:([\n\t ]*)\n(?![\n\t ]))?/g, "$1$2").replace(/\n+/g, `$&${indent}`);
          const body = foldFlowLines(`${wsStart}${value}${wsEnd}`, indent, FOLD_BLOCK, strOptions.fold);
          return `${header}
${indent}${body}`;
        }
        function plainString(item, ctx, onComment, onChompKeep) {
          const {
            comment,
            type,
            value
          } = item;
          const {
            actualString,
            implicitKey,
            indent,
            inFlow
          } = ctx;
          if (implicitKey && /[\n[\]{},]/.test(value) || inFlow && /[[\]{},]/.test(value)) {
            return doubleQuotedString(value, ctx);
          }
          if (!value || /^[\n\t ,[\]{}#&*!|>'"%@`]|^[?-]$|^[?-][ \t]|[\n:][ \t]|[ \t]\n|[\n\t ]#|[\n\t :]$/.test(value)) {
            return implicitKey || inFlow || value.indexOf("\n") === -1 ? value.indexOf('"') !== -1 && value.indexOf("'") === -1 ? singleQuotedString(value, ctx) : doubleQuotedString(value, ctx) : blockString(item, ctx, onComment, onChompKeep);
          }
          if (!implicitKey && !inFlow && type !== PlainValue.Type.PLAIN && value.indexOf("\n") !== -1) {
            return blockString(item, ctx, onComment, onChompKeep);
          }
          if (indent === "" && containsDocumentMarker(value)) {
            ctx.forceBlockIndent = true;
            return blockString(item, ctx, onComment, onChompKeep);
          }
          const str = value.replace(/\n+/g, `$&
${indent}`);
          if (actualString) {
            const {
              tags
            } = ctx.doc.schema;
            const resolved = resolveScalar(str, tags, tags.scalarFallback).value;
            if (typeof resolved !== "string")
              return doubleQuotedString(value, ctx);
          }
          const body = implicitKey ? str : foldFlowLines(str, indent, FOLD_FLOW, getFoldOptions(ctx));
          if (comment && !inFlow && (body.indexOf("\n") !== -1 || comment.indexOf("\n") !== -1)) {
            if (onComment)
              onComment();
            return addCommentBefore(body, indent, comment);
          }
          return body;
        }
        function stringifyString(item, ctx, onComment, onChompKeep) {
          const {
            defaultType
          } = strOptions;
          const {
            implicitKey,
            inFlow
          } = ctx;
          let {
            type,
            value
          } = item;
          if (typeof value !== "string") {
            value = String(value);
            item = Object.assign({}, item, {
              value
            });
          }
          const _stringify = (_type) => {
            switch (_type) {
              case PlainValue.Type.BLOCK_FOLDED:
              case PlainValue.Type.BLOCK_LITERAL:
                return blockString(item, ctx, onComment, onChompKeep);
              case PlainValue.Type.QUOTE_DOUBLE:
                return doubleQuotedString(value, ctx);
              case PlainValue.Type.QUOTE_SINGLE:
                return singleQuotedString(value, ctx);
              case PlainValue.Type.PLAIN:
                return plainString(item, ctx, onComment, onChompKeep);
              default:
                return null;
            }
          };
          if (type !== PlainValue.Type.QUOTE_DOUBLE && /[\x00-\x08\x0b-\x1f\x7f-\x9f]/.test(value)) {
            type = PlainValue.Type.QUOTE_DOUBLE;
          } else if ((implicitKey || inFlow) && (type === PlainValue.Type.BLOCK_FOLDED || type === PlainValue.Type.BLOCK_LITERAL)) {
            type = PlainValue.Type.QUOTE_DOUBLE;
          }
          let res = _stringify(type);
          if (res === null) {
            res = _stringify(defaultType);
            if (res === null)
              throw new Error(`Unsupported default string type ${defaultType}`);
          }
          return res;
        }
        function stringifyNumber({
          format: format2,
          minFractionDigits,
          tag,
          value
        }) {
          if (typeof value === "bigint")
            return String(value);
          if (!isFinite(value))
            return isNaN(value) ? ".nan" : value < 0 ? "-.inf" : ".inf";
          let n2 = JSON.stringify(value);
          if (!format2 && minFractionDigits && (!tag || tag === "tag:yaml.org,2002:float") && /^\d/.test(n2)) {
            let i = n2.indexOf(".");
            if (i < 0) {
              i = n2.length;
              n2 += ".";
            }
            let d = minFractionDigits - (n2.length - i - 1);
            while (d-- > 0)
              n2 += "0";
          }
          return n2;
        }
        function checkFlowCollectionEnd(errors, cst) {
          let char2, name;
          switch (cst.type) {
            case PlainValue.Type.FLOW_MAP:
              char2 = "}";
              name = "flow map";
              break;
            case PlainValue.Type.FLOW_SEQ:
              char2 = "]";
              name = "flow sequence";
              break;
            default:
              errors.push(new PlainValue.YAMLSemanticError(cst, "Not a flow collection!?"));
              return;
          }
          let lastItem;
          for (let i = cst.items.length - 1; i >= 0; --i) {
            const item = cst.items[i];
            if (!item || item.type !== PlainValue.Type.COMMENT) {
              lastItem = item;
              break;
            }
          }
          if (lastItem && lastItem.char !== char2) {
            const msg = `Expected ${name} to end with ${char2}`;
            let err;
            if (typeof lastItem.offset === "number") {
              err = new PlainValue.YAMLSemanticError(cst, msg);
              err.offset = lastItem.offset + 1;
            } else {
              err = new PlainValue.YAMLSemanticError(lastItem, msg);
              if (lastItem.range && lastItem.range.end)
                err.offset = lastItem.range.end - lastItem.range.start;
            }
            errors.push(err);
          }
        }
        function checkFlowCommentSpace(errors, comment) {
          const prev = comment.context.src[comment.range.start - 1];
          if (prev !== "\n" && prev !== "	" && prev !== " ") {
            const msg = "Comments must be separated from other tokens by white space characters";
            errors.push(new PlainValue.YAMLSemanticError(comment, msg));
          }
        }
        function getLongKeyError(source, key) {
          const sk = String(key);
          const k = sk.substr(0, 8) + "..." + sk.substr(-8);
          return new PlainValue.YAMLSemanticError(source, `The "${k}" key is too long`);
        }
        function resolveComments(collection, comments) {
          for (const {
            afterKey,
            before,
            comment
          } of comments) {
            let item = collection.items[before];
            if (!item) {
              if (comment !== void 0) {
                if (collection.comment)
                  collection.comment += "\n" + comment;
                else
                  collection.comment = comment;
              }
            } else {
              if (afterKey && item.value)
                item = item.value;
              if (comment === void 0) {
                if (afterKey || !item.commentBefore)
                  item.spaceBefore = true;
              } else {
                if (item.commentBefore)
                  item.commentBefore += "\n" + comment;
                else
                  item.commentBefore = comment;
              }
            }
          }
        }
        function resolveString(doc, node) {
          const res = node.strValue;
          if (!res)
            return "";
          if (typeof res === "string")
            return res;
          res.errors.forEach((error) => {
            if (!error.source)
              error.source = node;
            doc.errors.push(error);
          });
          return res.str;
        }
        function resolveTagHandle(doc, node) {
          const {
            handle,
            suffix
          } = node.tag;
          let prefix = doc.tagPrefixes.find((p) => p.handle === handle);
          if (!prefix) {
            const dtp = doc.getDefaults().tagPrefixes;
            if (dtp)
              prefix = dtp.find((p) => p.handle === handle);
            if (!prefix)
              throw new PlainValue.YAMLSemanticError(node, `The ${handle} tag handle is non-default and was not declared.`);
          }
          if (!suffix)
            throw new PlainValue.YAMLSemanticError(node, `The ${handle} tag has no suffix.`);
          if (handle === "!" && (doc.version || doc.options.version) === "1.0") {
            if (suffix[0] === "^") {
              doc.warnings.push(new PlainValue.YAMLWarning(node, "YAML 1.0 ^ tag expansion is not supported"));
              return suffix;
            }
            if (/[:/]/.test(suffix)) {
              const vocab = suffix.match(/^([a-z0-9-]+)\/(.*)/i);
              return vocab ? `tag:${vocab[1]}.yaml.org,2002:${vocab[2]}` : `tag:${suffix}`;
            }
          }
          return prefix.prefix + decodeURIComponent(suffix);
        }
        function resolveTagName(doc, node) {
          const {
            tag,
            type
          } = node;
          let nonSpecific = false;
          if (tag) {
            const {
              handle,
              suffix,
              verbatim
            } = tag;
            if (verbatim) {
              if (verbatim !== "!" && verbatim !== "!!")
                return verbatim;
              const msg = `Verbatim tags aren't resolved, so ${verbatim} is invalid.`;
              doc.errors.push(new PlainValue.YAMLSemanticError(node, msg));
            } else if (handle === "!" && !suffix) {
              nonSpecific = true;
            } else {
              try {
                return resolveTagHandle(doc, node);
              } catch (error) {
                doc.errors.push(error);
              }
            }
          }
          switch (type) {
            case PlainValue.Type.BLOCK_FOLDED:
            case PlainValue.Type.BLOCK_LITERAL:
            case PlainValue.Type.QUOTE_DOUBLE:
            case PlainValue.Type.QUOTE_SINGLE:
              return PlainValue.defaultTags.STR;
            case PlainValue.Type.FLOW_MAP:
            case PlainValue.Type.MAP:
              return PlainValue.defaultTags.MAP;
            case PlainValue.Type.FLOW_SEQ:
            case PlainValue.Type.SEQ:
              return PlainValue.defaultTags.SEQ;
            case PlainValue.Type.PLAIN:
              return nonSpecific ? PlainValue.defaultTags.STR : null;
            default:
              return null;
          }
        }
        function resolveByTagName(doc, node, tagName) {
          const {
            tags
          } = doc.schema;
          const matchWithTest = [];
          for (const tag of tags) {
            if (tag.tag === tagName) {
              if (tag.test)
                matchWithTest.push(tag);
              else {
                const res = tag.resolve(doc, node);
                return res instanceof Collection ? res : new Scalar(res);
              }
            }
          }
          const str = resolveString(doc, node);
          if (typeof str === "string" && matchWithTest.length > 0)
            return resolveScalar(str, matchWithTest, tags.scalarFallback);
          return null;
        }
        function getFallbackTagName({
          type
        }) {
          switch (type) {
            case PlainValue.Type.FLOW_MAP:
            case PlainValue.Type.MAP:
              return PlainValue.defaultTags.MAP;
            case PlainValue.Type.FLOW_SEQ:
            case PlainValue.Type.SEQ:
              return PlainValue.defaultTags.SEQ;
            default:
              return PlainValue.defaultTags.STR;
          }
        }
        function resolveTag(doc, node, tagName) {
          try {
            const res = resolveByTagName(doc, node, tagName);
            if (res) {
              if (tagName && node.tag)
                res.tag = tagName;
              return res;
            }
          } catch (error) {
            if (!error.source)
              error.source = node;
            doc.errors.push(error);
            return null;
          }
          try {
            const fallback = getFallbackTagName(node);
            if (!fallback)
              throw new Error(`The tag ${tagName} is unavailable`);
            const msg = `The tag ${tagName} is unavailable, falling back to ${fallback}`;
            doc.warnings.push(new PlainValue.YAMLWarning(node, msg));
            const res = resolveByTagName(doc, node, fallback);
            res.tag = tagName;
            return res;
          } catch (error) {
            const refError = new PlainValue.YAMLReferenceError(node, error.message);
            refError.stack = error.stack;
            doc.errors.push(refError);
            return null;
          }
        }
        var isCollectionItem = (node) => {
          if (!node)
            return false;
          const {
            type
          } = node;
          return type === PlainValue.Type.MAP_KEY || type === PlainValue.Type.MAP_VALUE || type === PlainValue.Type.SEQ_ITEM;
        };
        function resolveNodeProps(errors, node) {
          const comments = {
            before: [],
            after: []
          };
          let hasAnchor = false;
          let hasTag = false;
          const props = isCollectionItem(node.context.parent) ? node.context.parent.props.concat(node.props) : node.props;
          for (const {
            start,
            end
          } of props) {
            switch (node.context.src[start]) {
              case PlainValue.Char.COMMENT: {
                if (!node.commentHasRequiredWhitespace(start)) {
                  const msg = "Comments must be separated from other tokens by white space characters";
                  errors.push(new PlainValue.YAMLSemanticError(node, msg));
                }
                const {
                  header,
                  valueRange
                } = node;
                const cc = valueRange && (start > valueRange.start || header && start > header.start) ? comments.after : comments.before;
                cc.push(node.context.src.slice(start + 1, end));
                break;
              }
              case PlainValue.Char.ANCHOR:
                if (hasAnchor) {
                  const msg = "A node can have at most one anchor";
                  errors.push(new PlainValue.YAMLSemanticError(node, msg));
                }
                hasAnchor = true;
                break;
              case PlainValue.Char.TAG:
                if (hasTag) {
                  const msg = "A node can have at most one tag";
                  errors.push(new PlainValue.YAMLSemanticError(node, msg));
                }
                hasTag = true;
                break;
            }
          }
          return {
            comments,
            hasAnchor,
            hasTag
          };
        }
        function resolveNodeValue(doc, node) {
          const {
            anchors,
            errors,
            schema
          } = doc;
          if (node.type === PlainValue.Type.ALIAS) {
            const name = node.rawValue;
            const src = anchors.getNode(name);
            if (!src) {
              const msg = `Aliased anchor not found: ${name}`;
              errors.push(new PlainValue.YAMLReferenceError(node, msg));
              return null;
            }
            const res = new Alias(src);
            anchors._cstAliases.push(res);
            return res;
          }
          const tagName = resolveTagName(doc, node);
          if (tagName)
            return resolveTag(doc, node, tagName);
          if (node.type !== PlainValue.Type.PLAIN) {
            const msg = `Failed to resolve ${node.type} node here`;
            errors.push(new PlainValue.YAMLSyntaxError(node, msg));
            return null;
          }
          try {
            const str = resolveString(doc, node);
            return resolveScalar(str, schema.tags, schema.tags.scalarFallback);
          } catch (error) {
            if (!error.source)
              error.source = node;
            errors.push(error);
            return null;
          }
        }
        function resolveNode(doc, node) {
          if (!node)
            return null;
          if (node.error)
            doc.errors.push(node.error);
          const {
            comments,
            hasAnchor,
            hasTag
          } = resolveNodeProps(doc.errors, node);
          if (hasAnchor) {
            const {
              anchors
            } = doc;
            const name = node.anchor;
            const prev = anchors.getNode(name);
            if (prev)
              anchors.map[anchors.newName(name)] = prev;
            anchors.map[name] = node;
          }
          if (node.type === PlainValue.Type.ALIAS && (hasAnchor || hasTag)) {
            const msg = "An alias node must not specify any properties";
            doc.errors.push(new PlainValue.YAMLSemanticError(node, msg));
          }
          const res = resolveNodeValue(doc, node);
          if (res) {
            res.range = [node.range.start, node.range.end];
            if (doc.options.keepCstNodes)
              res.cstNode = node;
            if (doc.options.keepNodeTypes)
              res.type = node.type;
            const cb = comments.before.join("\n");
            if (cb) {
              res.commentBefore = res.commentBefore ? `${res.commentBefore}
${cb}` : cb;
            }
            const ca = comments.after.join("\n");
            if (ca)
              res.comment = res.comment ? `${res.comment}
${ca}` : ca;
          }
          return node.resolved = res;
        }
        function resolveMap(doc, cst) {
          if (cst.type !== PlainValue.Type.MAP && cst.type !== PlainValue.Type.FLOW_MAP) {
            const msg = `A ${cst.type} node cannot be resolved as a mapping`;
            doc.errors.push(new PlainValue.YAMLSyntaxError(cst, msg));
            return null;
          }
          const {
            comments,
            items
          } = cst.type === PlainValue.Type.FLOW_MAP ? resolveFlowMapItems(doc, cst) : resolveBlockMapItems(doc, cst);
          const map = new YAMLMap();
          map.items = items;
          resolveComments(map, comments);
          let hasCollectionKey = false;
          for (let i = 0; i < items.length; ++i) {
            const {
              key: iKey
            } = items[i];
            if (iKey instanceof Collection)
              hasCollectionKey = true;
            if (doc.schema.merge && iKey && iKey.value === MERGE_KEY) {
              items[i] = new Merge(items[i]);
              const sources = items[i].value.items;
              let error = null;
              sources.some((node) => {
                if (node instanceof Alias) {
                  const {
                    type
                  } = node.source;
                  if (type === PlainValue.Type.MAP || type === PlainValue.Type.FLOW_MAP)
                    return false;
                  return error = "Merge nodes aliases can only point to maps";
                }
                return error = "Merge nodes can only have Alias nodes as values";
              });
              if (error)
                doc.errors.push(new PlainValue.YAMLSemanticError(cst, error));
            } else {
              for (let j = i + 1; j < items.length; ++j) {
                const {
                  key: jKey
                } = items[j];
                if (iKey === jKey || iKey && jKey && Object.prototype.hasOwnProperty.call(iKey, "value") && iKey.value === jKey.value) {
                  const msg = `Map keys must be unique; "${iKey}" is repeated`;
                  doc.errors.push(new PlainValue.YAMLSemanticError(cst, msg));
                  break;
                }
              }
            }
          }
          if (hasCollectionKey && !doc.options.mapAsMap) {
            const warn = "Keys with collection values will be stringified as YAML due to JS Object restrictions. Use mapAsMap: true to avoid this.";
            doc.warnings.push(new PlainValue.YAMLWarning(cst, warn));
          }
          cst.resolved = map;
          return map;
        }
        var valueHasPairComment = ({
          context: {
            lineStart,
            node,
            src
          },
          props
        }) => {
          if (props.length === 0)
            return false;
          const {
            start
          } = props[0];
          if (node && start > node.valueRange.start)
            return false;
          if (src[start] !== PlainValue.Char.COMMENT)
            return false;
          for (let i = lineStart; i < start; ++i)
            if (src[i] === "\n")
              return false;
          return true;
        };
        function resolvePairComment(item, pair) {
          if (!valueHasPairComment(item))
            return;
          const comment = item.getPropValue(0, PlainValue.Char.COMMENT, true);
          let found = false;
          const cb = pair.value.commentBefore;
          if (cb && cb.startsWith(comment)) {
            pair.value.commentBefore = cb.substr(comment.length + 1);
            found = true;
          } else {
            const cc = pair.value.comment;
            if (!item.node && cc && cc.startsWith(comment)) {
              pair.value.comment = cc.substr(comment.length + 1);
              found = true;
            }
          }
          if (found)
            pair.comment = comment;
        }
        function resolveBlockMapItems(doc, cst) {
          const comments = [];
          const items = [];
          let key = void 0;
          let keyStart = null;
          for (let i = 0; i < cst.items.length; ++i) {
            const item = cst.items[i];
            switch (item.type) {
              case PlainValue.Type.BLANK_LINE:
                comments.push({
                  afterKey: !!key,
                  before: items.length
                });
                break;
              case PlainValue.Type.COMMENT:
                comments.push({
                  afterKey: !!key,
                  before: items.length,
                  comment: item.comment
                });
                break;
              case PlainValue.Type.MAP_KEY:
                if (key !== void 0)
                  items.push(new Pair(key));
                if (item.error)
                  doc.errors.push(item.error);
                key = resolveNode(doc, item.node);
                keyStart = null;
                break;
              case PlainValue.Type.MAP_VALUE:
                {
                  if (key === void 0)
                    key = null;
                  if (item.error)
                    doc.errors.push(item.error);
                  if (!item.context.atLineStart && item.node && item.node.type === PlainValue.Type.MAP && !item.node.context.atLineStart) {
                    const msg = "Nested mappings are not allowed in compact mappings";
                    doc.errors.push(new PlainValue.YAMLSemanticError(item.node, msg));
                  }
                  let valueNode = item.node;
                  if (!valueNode && item.props.length > 0) {
                    valueNode = new PlainValue.PlainValue(PlainValue.Type.PLAIN, []);
                    valueNode.context = {
                      parent: item,
                      src: item.context.src
                    };
                    const pos = item.range.start + 1;
                    valueNode.range = {
                      start: pos,
                      end: pos
                    };
                    valueNode.valueRange = {
                      start: pos,
                      end: pos
                    };
                    if (typeof item.range.origStart === "number") {
                      const origPos = item.range.origStart + 1;
                      valueNode.range.origStart = valueNode.range.origEnd = origPos;
                      valueNode.valueRange.origStart = valueNode.valueRange.origEnd = origPos;
                    }
                  }
                  const pair = new Pair(key, resolveNode(doc, valueNode));
                  resolvePairComment(item, pair);
                  items.push(pair);
                  if (key && typeof keyStart === "number") {
                    if (item.range.start > keyStart + 1024)
                      doc.errors.push(getLongKeyError(cst, key));
                  }
                  key = void 0;
                  keyStart = null;
                }
                break;
              default:
                if (key !== void 0)
                  items.push(new Pair(key));
                key = resolveNode(doc, item);
                keyStart = item.range.start;
                if (item.error)
                  doc.errors.push(item.error);
                next:
                  for (let j = i + 1; ; ++j) {
                    const nextItem = cst.items[j];
                    switch (nextItem && nextItem.type) {
                      case PlainValue.Type.BLANK_LINE:
                      case PlainValue.Type.COMMENT:
                        continue next;
                      case PlainValue.Type.MAP_VALUE:
                        break next;
                      default: {
                        const msg = "Implicit map keys need to be followed by map values";
                        doc.errors.push(new PlainValue.YAMLSemanticError(item, msg));
                        break next;
                      }
                    }
                  }
                if (item.valueRangeContainsNewline) {
                  const msg = "Implicit map keys need to be on a single line";
                  doc.errors.push(new PlainValue.YAMLSemanticError(item, msg));
                }
            }
          }
          if (key !== void 0)
            items.push(new Pair(key));
          return {
            comments,
            items
          };
        }
        function resolveFlowMapItems(doc, cst) {
          const comments = [];
          const items = [];
          let key = void 0;
          let explicitKey = false;
          let next = "{";
          for (let i = 0; i < cst.items.length; ++i) {
            const item = cst.items[i];
            if (typeof item.char === "string") {
              const {
                char: char2,
                offset
              } = item;
              if (char2 === "?" && key === void 0 && !explicitKey) {
                explicitKey = true;
                next = ":";
                continue;
              }
              if (char2 === ":") {
                if (key === void 0)
                  key = null;
                if (next === ":") {
                  next = ",";
                  continue;
                }
              } else {
                if (explicitKey) {
                  if (key === void 0 && char2 !== ",")
                    key = null;
                  explicitKey = false;
                }
                if (key !== void 0) {
                  items.push(new Pair(key));
                  key = void 0;
                  if (char2 === ",") {
                    next = ":";
                    continue;
                  }
                }
              }
              if (char2 === "}") {
                if (i === cst.items.length - 1)
                  continue;
              } else if (char2 === next) {
                next = ":";
                continue;
              }
              const msg = `Flow map contains an unexpected ${char2}`;
              const err = new PlainValue.YAMLSyntaxError(cst, msg);
              err.offset = offset;
              doc.errors.push(err);
            } else if (item.type === PlainValue.Type.BLANK_LINE) {
              comments.push({
                afterKey: !!key,
                before: items.length
              });
            } else if (item.type === PlainValue.Type.COMMENT) {
              checkFlowCommentSpace(doc.errors, item);
              comments.push({
                afterKey: !!key,
                before: items.length,
                comment: item.comment
              });
            } else if (key === void 0) {
              if (next === ",")
                doc.errors.push(new PlainValue.YAMLSemanticError(item, "Separator , missing in flow map"));
              key = resolveNode(doc, item);
            } else {
              if (next !== ",")
                doc.errors.push(new PlainValue.YAMLSemanticError(item, "Indicator : missing in flow map entry"));
              items.push(new Pair(key, resolveNode(doc, item)));
              key = void 0;
              explicitKey = false;
            }
          }
          checkFlowCollectionEnd(doc.errors, cst);
          if (key !== void 0)
            items.push(new Pair(key));
          return {
            comments,
            items
          };
        }
        function resolveSeq(doc, cst) {
          if (cst.type !== PlainValue.Type.SEQ && cst.type !== PlainValue.Type.FLOW_SEQ) {
            const msg = `A ${cst.type} node cannot be resolved as a sequence`;
            doc.errors.push(new PlainValue.YAMLSyntaxError(cst, msg));
            return null;
          }
          const {
            comments,
            items
          } = cst.type === PlainValue.Type.FLOW_SEQ ? resolveFlowSeqItems(doc, cst) : resolveBlockSeqItems(doc, cst);
          const seq = new YAMLSeq();
          seq.items = items;
          resolveComments(seq, comments);
          if (!doc.options.mapAsMap && items.some((it) => it instanceof Pair && it.key instanceof Collection)) {
            const warn = "Keys with collection values will be stringified as YAML due to JS Object restrictions. Use mapAsMap: true to avoid this.";
            doc.warnings.push(new PlainValue.YAMLWarning(cst, warn));
          }
          cst.resolved = seq;
          return seq;
        }
        function resolveBlockSeqItems(doc, cst) {
          const comments = [];
          const items = [];
          for (let i = 0; i < cst.items.length; ++i) {
            const item = cst.items[i];
            switch (item.type) {
              case PlainValue.Type.BLANK_LINE:
                comments.push({
                  before: items.length
                });
                break;
              case PlainValue.Type.COMMENT:
                comments.push({
                  comment: item.comment,
                  before: items.length
                });
                break;
              case PlainValue.Type.SEQ_ITEM:
                if (item.error)
                  doc.errors.push(item.error);
                items.push(resolveNode(doc, item.node));
                if (item.hasProps) {
                  const msg = "Sequence items cannot have tags or anchors before the - indicator";
                  doc.errors.push(new PlainValue.YAMLSemanticError(item, msg));
                }
                break;
              default:
                if (item.error)
                  doc.errors.push(item.error);
                doc.errors.push(new PlainValue.YAMLSyntaxError(item, `Unexpected ${item.type} node in sequence`));
            }
          }
          return {
            comments,
            items
          };
        }
        function resolveFlowSeqItems(doc, cst) {
          const comments = [];
          const items = [];
          let explicitKey = false;
          let key = void 0;
          let keyStart = null;
          let next = "[";
          let prevItem = null;
          for (let i = 0; i < cst.items.length; ++i) {
            const item = cst.items[i];
            if (typeof item.char === "string") {
              const {
                char: char2,
                offset
              } = item;
              if (char2 !== ":" && (explicitKey || key !== void 0)) {
                if (explicitKey && key === void 0)
                  key = next ? items.pop() : null;
                items.push(new Pair(key));
                explicitKey = false;
                key = void 0;
                keyStart = null;
              }
              if (char2 === next) {
                next = null;
              } else if (!next && char2 === "?") {
                explicitKey = true;
              } else if (next !== "[" && char2 === ":" && key === void 0) {
                if (next === ",") {
                  key = items.pop();
                  if (key instanceof Pair) {
                    const msg = "Chaining flow sequence pairs is invalid";
                    const err = new PlainValue.YAMLSemanticError(cst, msg);
                    err.offset = offset;
                    doc.errors.push(err);
                  }
                  if (!explicitKey && typeof keyStart === "number") {
                    const keyEnd = item.range ? item.range.start : item.offset;
                    if (keyEnd > keyStart + 1024)
                      doc.errors.push(getLongKeyError(cst, key));
                    const {
                      src
                    } = prevItem.context;
                    for (let i2 = keyStart; i2 < keyEnd; ++i2)
                      if (src[i2] === "\n") {
                        const msg = "Implicit keys of flow sequence pairs need to be on a single line";
                        doc.errors.push(new PlainValue.YAMLSemanticError(prevItem, msg));
                        break;
                      }
                  }
                } else {
                  key = null;
                }
                keyStart = null;
                explicitKey = false;
                next = null;
              } else if (next === "[" || char2 !== "]" || i < cst.items.length - 1) {
                const msg = `Flow sequence contains an unexpected ${char2}`;
                const err = new PlainValue.YAMLSyntaxError(cst, msg);
                err.offset = offset;
                doc.errors.push(err);
              }
            } else if (item.type === PlainValue.Type.BLANK_LINE) {
              comments.push({
                before: items.length
              });
            } else if (item.type === PlainValue.Type.COMMENT) {
              checkFlowCommentSpace(doc.errors, item);
              comments.push({
                comment: item.comment,
                before: items.length
              });
            } else {
              if (next) {
                const msg = `Expected a ${next} in flow sequence`;
                doc.errors.push(new PlainValue.YAMLSemanticError(item, msg));
              }
              const value = resolveNode(doc, item);
              if (key === void 0) {
                items.push(value);
                prevItem = item;
              } else {
                items.push(new Pair(key, value));
                key = void 0;
              }
              keyStart = item.range.start;
              next = ",";
            }
          }
          checkFlowCollectionEnd(doc.errors, cst);
          if (key !== void 0)
            items.push(new Pair(key));
          return {
            comments,
            items
          };
        }
        exports2.Alias = Alias;
        exports2.Collection = Collection;
        exports2.Merge = Merge;
        exports2.Node = Node;
        exports2.Pair = Pair;
        exports2.Scalar = Scalar;
        exports2.YAMLMap = YAMLMap;
        exports2.YAMLSeq = YAMLSeq;
        exports2.addComment = addComment;
        exports2.binaryOptions = binaryOptions;
        exports2.boolOptions = boolOptions;
        exports2.findPair = findPair;
        exports2.intOptions = intOptions;
        exports2.isEmptyPath = isEmptyPath;
        exports2.nullOptions = nullOptions;
        exports2.resolveMap = resolveMap;
        exports2.resolveNode = resolveNode;
        exports2.resolveSeq = resolveSeq;
        exports2.resolveString = resolveString;
        exports2.strOptions = strOptions;
        exports2.stringifyNumber = stringifyNumber;
        exports2.stringifyString = stringifyString;
        exports2.toJSON = toJSON;
      }
    });
    var require_warnings_1000a372 = __commonJS2({
      "node_modules/yaml/dist/warnings-1000a372.js"(exports2) {
        "use strict";
        var PlainValue = require_PlainValue_ec8e588e();
        var resolveSeq = require_resolveSeq_d03cb037();
        var binary = {
          identify: (value) => value instanceof Uint8Array,
          default: false,
          tag: "tag:yaml.org,2002:binary",
          resolve: (doc, node) => {
            const src = resolveSeq.resolveString(doc, node);
            if (typeof Buffer === "function") {
              return Buffer.from(src, "base64");
            } else if (typeof atob === "function") {
              const str = atob(src.replace(/[\n\r]/g, ""));
              const buffer = new Uint8Array(str.length);
              for (let i = 0; i < str.length; ++i)
                buffer[i] = str.charCodeAt(i);
              return buffer;
            } else {
              const msg = "This environment does not support reading binary tags; either Buffer or atob is required";
              doc.errors.push(new PlainValue.YAMLReferenceError(node, msg));
              return null;
            }
          },
          options: resolveSeq.binaryOptions,
          stringify: ({
            comment,
            type,
            value
          }, ctx, onComment, onChompKeep) => {
            let src;
            if (typeof Buffer === "function") {
              src = value instanceof Buffer ? value.toString("base64") : Buffer.from(value.buffer).toString("base64");
            } else if (typeof btoa === "function") {
              let s = "";
              for (let i = 0; i < value.length; ++i)
                s += String.fromCharCode(value[i]);
              src = btoa(s);
            } else {
              throw new Error("This environment does not support writing binary tags; either Buffer or btoa is required");
            }
            if (!type)
              type = resolveSeq.binaryOptions.defaultType;
            if (type === PlainValue.Type.QUOTE_DOUBLE) {
              value = src;
            } else {
              const {
                lineWidth
              } = resolveSeq.binaryOptions;
              const n2 = Math.ceil(src.length / lineWidth);
              const lines = new Array(n2);
              for (let i = 0, o = 0; i < n2; ++i, o += lineWidth) {
                lines[i] = src.substr(o, lineWidth);
              }
              value = lines.join(type === PlainValue.Type.BLOCK_LITERAL ? "\n" : " ");
            }
            return resolveSeq.stringifyString({
              comment,
              type,
              value
            }, ctx, onComment, onChompKeep);
          }
        };
        function parsePairs(doc, cst) {
          const seq = resolveSeq.resolveSeq(doc, cst);
          for (let i = 0; i < seq.items.length; ++i) {
            let item = seq.items[i];
            if (item instanceof resolveSeq.Pair)
              continue;
            else if (item instanceof resolveSeq.YAMLMap) {
              if (item.items.length > 1) {
                const msg = "Each pair must have its own sequence indicator";
                throw new PlainValue.YAMLSemanticError(cst, msg);
              }
              const pair = item.items[0] || new resolveSeq.Pair();
              if (item.commentBefore)
                pair.commentBefore = pair.commentBefore ? `${item.commentBefore}
${pair.commentBefore}` : item.commentBefore;
              if (item.comment)
                pair.comment = pair.comment ? `${item.comment}
${pair.comment}` : item.comment;
              item = pair;
            }
            seq.items[i] = item instanceof resolveSeq.Pair ? item : new resolveSeq.Pair(item);
          }
          return seq;
        }
        function createPairs(schema, iterable, ctx) {
          const pairs2 = new resolveSeq.YAMLSeq(schema);
          pairs2.tag = "tag:yaml.org,2002:pairs";
          for (const it of iterable) {
            let key, value;
            if (Array.isArray(it)) {
              if (it.length === 2) {
                key = it[0];
                value = it[1];
              } else
                throw new TypeError(`Expected [key, value] tuple: ${it}`);
            } else if (it && it instanceof Object) {
              const keys = Object.keys(it);
              if (keys.length === 1) {
                key = keys[0];
                value = it[key];
              } else
                throw new TypeError(`Expected { key: value } tuple: ${it}`);
            } else {
              key = it;
            }
            const pair = schema.createPair(key, value, ctx);
            pairs2.items.push(pair);
          }
          return pairs2;
        }
        var pairs = {
          default: false,
          tag: "tag:yaml.org,2002:pairs",
          resolve: parsePairs,
          createNode: createPairs
        };
        var YAMLOMap = class extends resolveSeq.YAMLSeq {
          constructor() {
            super();
            PlainValue._defineProperty(this, "add", resolveSeq.YAMLMap.prototype.add.bind(this));
            PlainValue._defineProperty(this, "delete", resolveSeq.YAMLMap.prototype.delete.bind(this));
            PlainValue._defineProperty(this, "get", resolveSeq.YAMLMap.prototype.get.bind(this));
            PlainValue._defineProperty(this, "has", resolveSeq.YAMLMap.prototype.has.bind(this));
            PlainValue._defineProperty(this, "set", resolveSeq.YAMLMap.prototype.set.bind(this));
            this.tag = YAMLOMap.tag;
          }
          toJSON(_, ctx) {
            const map = /* @__PURE__ */ new Map();
            if (ctx && ctx.onCreate)
              ctx.onCreate(map);
            for (const pair of this.items) {
              let key, value;
              if (pair instanceof resolveSeq.Pair) {
                key = resolveSeq.toJSON(pair.key, "", ctx);
                value = resolveSeq.toJSON(pair.value, key, ctx);
              } else {
                key = resolveSeq.toJSON(pair, "", ctx);
              }
              if (map.has(key))
                throw new Error("Ordered maps must not include duplicate keys");
              map.set(key, value);
            }
            return map;
          }
        };
        PlainValue._defineProperty(YAMLOMap, "tag", "tag:yaml.org,2002:omap");
        function parseOMap(doc, cst) {
          const pairs2 = parsePairs(doc, cst);
          const seenKeys = [];
          for (const {
            key
          } of pairs2.items) {
            if (key instanceof resolveSeq.Scalar) {
              if (seenKeys.includes(key.value)) {
                const msg = "Ordered maps must not include duplicate keys";
                throw new PlainValue.YAMLSemanticError(cst, msg);
              } else {
                seenKeys.push(key.value);
              }
            }
          }
          return Object.assign(new YAMLOMap(), pairs2);
        }
        function createOMap(schema, iterable, ctx) {
          const pairs2 = createPairs(schema, iterable, ctx);
          const omap2 = new YAMLOMap();
          omap2.items = pairs2.items;
          return omap2;
        }
        var omap = {
          identify: (value) => value instanceof Map,
          nodeClass: YAMLOMap,
          default: false,
          tag: "tag:yaml.org,2002:omap",
          resolve: parseOMap,
          createNode: createOMap
        };
        var YAMLSet = class extends resolveSeq.YAMLMap {
          constructor() {
            super();
            this.tag = YAMLSet.tag;
          }
          add(key) {
            const pair = key instanceof resolveSeq.Pair ? key : new resolveSeq.Pair(key);
            const prev = resolveSeq.findPair(this.items, pair.key);
            if (!prev)
              this.items.push(pair);
          }
          get(key, keepPair) {
            const pair = resolveSeq.findPair(this.items, key);
            return !keepPair && pair instanceof resolveSeq.Pair ? pair.key instanceof resolveSeq.Scalar ? pair.key.value : pair.key : pair;
          }
          set(key, value) {
            if (typeof value !== "boolean")
              throw new Error(`Expected boolean value for set(key, value) in a YAML set, not ${typeof value}`);
            const prev = resolveSeq.findPair(this.items, key);
            if (prev && !value) {
              this.items.splice(this.items.indexOf(prev), 1);
            } else if (!prev && value) {
              this.items.push(new resolveSeq.Pair(key));
            }
          }
          toJSON(_, ctx) {
            return super.toJSON(_, ctx, Set);
          }
          toString(ctx, onComment, onChompKeep) {
            if (!ctx)
              return JSON.stringify(this);
            if (this.hasAllNullValues())
              return super.toString(ctx, onComment, onChompKeep);
            else
              throw new Error("Set items must all have null values");
          }
        };
        PlainValue._defineProperty(YAMLSet, "tag", "tag:yaml.org,2002:set");
        function parseSet(doc, cst) {
          const map = resolveSeq.resolveMap(doc, cst);
          if (!map.hasAllNullValues())
            throw new PlainValue.YAMLSemanticError(cst, "Set items must all have null values");
          return Object.assign(new YAMLSet(), map);
        }
        function createSet(schema, iterable, ctx) {
          const set2 = new YAMLSet();
          for (const value of iterable)
            set2.items.push(schema.createPair(value, null, ctx));
          return set2;
        }
        var set = {
          identify: (value) => value instanceof Set,
          nodeClass: YAMLSet,
          default: false,
          tag: "tag:yaml.org,2002:set",
          resolve: parseSet,
          createNode: createSet
        };
        var parseSexagesimal = (sign, parts) => {
          const n2 = parts.split(":").reduce((n22, p) => n22 * 60 + Number(p), 0);
          return sign === "-" ? -n2 : n2;
        };
        var stringifySexagesimal = ({
          value
        }) => {
          if (isNaN(value) || !isFinite(value))
            return resolveSeq.stringifyNumber(value);
          let sign = "";
          if (value < 0) {
            sign = "-";
            value = Math.abs(value);
          }
          const parts = [value % 60];
          if (value < 60) {
            parts.unshift(0);
          } else {
            value = Math.round((value - parts[0]) / 60);
            parts.unshift(value % 60);
            if (value >= 60) {
              value = Math.round((value - parts[0]) / 60);
              parts.unshift(value);
            }
          }
          return sign + parts.map((n2) => n2 < 10 ? "0" + String(n2) : String(n2)).join(":").replace(/000000\d*$/, "");
        };
        var intTime = {
          identify: (value) => typeof value === "number",
          default: true,
          tag: "tag:yaml.org,2002:int",
          format: "TIME",
          test: /^([-+]?)([0-9][0-9_]*(?::[0-5]?[0-9])+)$/,
          resolve: (str, sign, parts) => parseSexagesimal(sign, parts.replace(/_/g, "")),
          stringify: stringifySexagesimal
        };
        var floatTime = {
          identify: (value) => typeof value === "number",
          default: true,
          tag: "tag:yaml.org,2002:float",
          format: "TIME",
          test: /^([-+]?)([0-9][0-9_]*(?::[0-5]?[0-9])+\.[0-9_]*)$/,
          resolve: (str, sign, parts) => parseSexagesimal(sign, parts.replace(/_/g, "")),
          stringify: stringifySexagesimal
        };
        var timestamp = {
          identify: (value) => value instanceof Date,
          default: true,
          tag: "tag:yaml.org,2002:timestamp",
          test: RegExp("^(?:([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})(?:(?:t|T|[ \\t]+)([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2}(\\.[0-9]+)?)(?:[ \\t]*(Z|[-+][012]?[0-9](?::[0-9]{2})?))?)?)$"),
          resolve: (str, year, month, day, hour, minute, second, millisec, tz) => {
            if (millisec)
              millisec = (millisec + "00").substr(1, 3);
            let date = Date.UTC(year, month - 1, day, hour || 0, minute || 0, second || 0, millisec || 0);
            if (tz && tz !== "Z") {
              let d = parseSexagesimal(tz[0], tz.slice(1));
              if (Math.abs(d) < 30)
                d *= 60;
              date -= 6e4 * d;
            }
            return new Date(date);
          },
          stringify: ({
            value
          }) => value.toISOString().replace(/((T00:00)?:00)?\.000Z$/, "")
        };
        function shouldWarn(deprecation) {
          const env = typeof process !== "undefined" && process.env || {};
          if (deprecation) {
            if (typeof YAML_SILENCE_DEPRECATION_WARNINGS !== "undefined")
              return !YAML_SILENCE_DEPRECATION_WARNINGS;
            return !env.YAML_SILENCE_DEPRECATION_WARNINGS;
          }
          if (typeof YAML_SILENCE_WARNINGS !== "undefined")
            return !YAML_SILENCE_WARNINGS;
          return !env.YAML_SILENCE_WARNINGS;
        }
        function warn(warning, type) {
          if (shouldWarn(false)) {
            const emit = typeof process !== "undefined" && process.emitWarning;
            if (emit)
              emit(warning, type);
            else {
              console.warn(type ? `${type}: ${warning}` : warning);
            }
          }
        }
        function warnFileDeprecation(filename) {
          if (shouldWarn(true)) {
            const path = filename.replace(/.*yaml[/\\]/i, "").replace(/\.js$/, "").replace(/\\/g, "/");
            warn(`The endpoint 'yaml/${path}' will be removed in a future release.`, "DeprecationWarning");
          }
        }
        var warned2 = {};
        function warnOptionDeprecation(name, alternative) {
          if (!warned2[name] && shouldWarn(true)) {
            warned2[name] = true;
            let msg = `The option '${name}' will be removed in a future release`;
            msg += alternative ? `, use '${alternative}' instead.` : ".";
            warn(msg, "DeprecationWarning");
          }
        }
        exports2.binary = binary;
        exports2.floatTime = floatTime;
        exports2.intTime = intTime;
        exports2.omap = omap;
        exports2.pairs = pairs;
        exports2.set = set;
        exports2.timestamp = timestamp;
        exports2.warn = warn;
        exports2.warnFileDeprecation = warnFileDeprecation;
        exports2.warnOptionDeprecation = warnOptionDeprecation;
      }
    });
    var require_Schema_88e323a7 = __commonJS2({
      "node_modules/yaml/dist/Schema-88e323a7.js"(exports2) {
        "use strict";
        var PlainValue = require_PlainValue_ec8e588e();
        var resolveSeq = require_resolveSeq_d03cb037();
        var warnings = require_warnings_1000a372();
        function createMap(schema, obj, ctx) {
          const map2 = new resolveSeq.YAMLMap(schema);
          if (obj instanceof Map) {
            for (const [key, value] of obj)
              map2.items.push(schema.createPair(key, value, ctx));
          } else if (obj && typeof obj === "object") {
            for (const key of Object.keys(obj))
              map2.items.push(schema.createPair(key, obj[key], ctx));
          }
          if (typeof schema.sortMapEntries === "function") {
            map2.items.sort(schema.sortMapEntries);
          }
          return map2;
        }
        var map = {
          createNode: createMap,
          default: true,
          nodeClass: resolveSeq.YAMLMap,
          tag: "tag:yaml.org,2002:map",
          resolve: resolveSeq.resolveMap
        };
        function createSeq(schema, obj, ctx) {
          const seq2 = new resolveSeq.YAMLSeq(schema);
          if (obj && obj[Symbol.iterator]) {
            for (const it of obj) {
              const v = schema.createNode(it, ctx.wrapScalars, null, ctx);
              seq2.items.push(v);
            }
          }
          return seq2;
        }
        var seq = {
          createNode: createSeq,
          default: true,
          nodeClass: resolveSeq.YAMLSeq,
          tag: "tag:yaml.org,2002:seq",
          resolve: resolveSeq.resolveSeq
        };
        var string = {
          identify: (value) => typeof value === "string",
          default: true,
          tag: "tag:yaml.org,2002:str",
          resolve: resolveSeq.resolveString,
          stringify(item, ctx, onComment, onChompKeep) {
            ctx = Object.assign({
              actualString: true
            }, ctx);
            return resolveSeq.stringifyString(item, ctx, onComment, onChompKeep);
          },
          options: resolveSeq.strOptions
        };
        var failsafe = [map, seq, string];
        var intIdentify$2 = (value) => typeof value === "bigint" || Number.isInteger(value);
        var intResolve$1 = (src, part, radix) => resolveSeq.intOptions.asBigInt ? BigInt(src) : parseInt(part, radix);
        function intStringify$1(node, radix, prefix) {
          const {
            value
          } = node;
          if (intIdentify$2(value) && value >= 0)
            return prefix + value.toString(radix);
          return resolveSeq.stringifyNumber(node);
        }
        var nullObj = {
          identify: (value) => value == null,
          createNode: (schema, value, ctx) => ctx.wrapScalars ? new resolveSeq.Scalar(null) : null,
          default: true,
          tag: "tag:yaml.org,2002:null",
          test: /^(?:~|[Nn]ull|NULL)?$/,
          resolve: () => null,
          options: resolveSeq.nullOptions,
          stringify: () => resolveSeq.nullOptions.nullStr
        };
        var boolObj = {
          identify: (value) => typeof value === "boolean",
          default: true,
          tag: "tag:yaml.org,2002:bool",
          test: /^(?:[Tt]rue|TRUE|[Ff]alse|FALSE)$/,
          resolve: (str) => str[0] === "t" || str[0] === "T",
          options: resolveSeq.boolOptions,
          stringify: ({
            value
          }) => value ? resolveSeq.boolOptions.trueStr : resolveSeq.boolOptions.falseStr
        };
        var octObj = {
          identify: (value) => intIdentify$2(value) && value >= 0,
          default: true,
          tag: "tag:yaml.org,2002:int",
          format: "OCT",
          test: /^0o([0-7]+)$/,
          resolve: (str, oct) => intResolve$1(str, oct, 8),
          options: resolveSeq.intOptions,
          stringify: (node) => intStringify$1(node, 8, "0o")
        };
        var intObj = {
          identify: intIdentify$2,
          default: true,
          tag: "tag:yaml.org,2002:int",
          test: /^[-+]?[0-9]+$/,
          resolve: (str) => intResolve$1(str, str, 10),
          options: resolveSeq.intOptions,
          stringify: resolveSeq.stringifyNumber
        };
        var hexObj = {
          identify: (value) => intIdentify$2(value) && value >= 0,
          default: true,
          tag: "tag:yaml.org,2002:int",
          format: "HEX",
          test: /^0x([0-9a-fA-F]+)$/,
          resolve: (str, hex) => intResolve$1(str, hex, 16),
          options: resolveSeq.intOptions,
          stringify: (node) => intStringify$1(node, 16, "0x")
        };
        var nanObj = {
          identify: (value) => typeof value === "number",
          default: true,
          tag: "tag:yaml.org,2002:float",
          test: /^(?:[-+]?\.inf|(\.nan))$/i,
          resolve: (str, nan) => nan ? NaN : str[0] === "-" ? Number.NEGATIVE_INFINITY : Number.POSITIVE_INFINITY,
          stringify: resolveSeq.stringifyNumber
        };
        var expObj = {
          identify: (value) => typeof value === "number",
          default: true,
          tag: "tag:yaml.org,2002:float",
          format: "EXP",
          test: /^[-+]?(?:\.[0-9]+|[0-9]+(?:\.[0-9]*)?)[eE][-+]?[0-9]+$/,
          resolve: (str) => parseFloat(str),
          stringify: ({
            value
          }) => Number(value).toExponential()
        };
        var floatObj = {
          identify: (value) => typeof value === "number",
          default: true,
          tag: "tag:yaml.org,2002:float",
          test: /^[-+]?(?:\.([0-9]+)|[0-9]+\.([0-9]*))$/,
          resolve(str, frac1, frac2) {
            const frac = frac1 || frac2;
            const node = new resolveSeq.Scalar(parseFloat(str));
            if (frac && frac[frac.length - 1] === "0")
              node.minFractionDigits = frac.length;
            return node;
          },
          stringify: resolveSeq.stringifyNumber
        };
        var core = failsafe.concat([nullObj, boolObj, octObj, intObj, hexObj, nanObj, expObj, floatObj]);
        var intIdentify$1 = (value) => typeof value === "bigint" || Number.isInteger(value);
        var stringifyJSON = ({
          value
        }) => JSON.stringify(value);
        var json = [map, seq, {
          identify: (value) => typeof value === "string",
          default: true,
          tag: "tag:yaml.org,2002:str",
          resolve: resolveSeq.resolveString,
          stringify: stringifyJSON
        }, {
          identify: (value) => value == null,
          createNode: (schema, value, ctx) => ctx.wrapScalars ? new resolveSeq.Scalar(null) : null,
          default: true,
          tag: "tag:yaml.org,2002:null",
          test: /^null$/,
          resolve: () => null,
          stringify: stringifyJSON
        }, {
          identify: (value) => typeof value === "boolean",
          default: true,
          tag: "tag:yaml.org,2002:bool",
          test: /^true|false$/,
          resolve: (str) => str === "true",
          stringify: stringifyJSON
        }, {
          identify: intIdentify$1,
          default: true,
          tag: "tag:yaml.org,2002:int",
          test: /^-?(?:0|[1-9][0-9]*)$/,
          resolve: (str) => resolveSeq.intOptions.asBigInt ? BigInt(str) : parseInt(str, 10),
          stringify: ({
            value
          }) => intIdentify$1(value) ? value.toString() : JSON.stringify(value)
        }, {
          identify: (value) => typeof value === "number",
          default: true,
          tag: "tag:yaml.org,2002:float",
          test: /^-?(?:0|[1-9][0-9]*)(?:\.[0-9]*)?(?:[eE][-+]?[0-9]+)?$/,
          resolve: (str) => parseFloat(str),
          stringify: stringifyJSON
        }];
        json.scalarFallback = (str) => {
          throw new SyntaxError(`Unresolved plain scalar ${JSON.stringify(str)}`);
        };
        var boolStringify = ({
          value
        }) => value ? resolveSeq.boolOptions.trueStr : resolveSeq.boolOptions.falseStr;
        var intIdentify = (value) => typeof value === "bigint" || Number.isInteger(value);
        function intResolve(sign, src, radix) {
          let str = src.replace(/_/g, "");
          if (resolveSeq.intOptions.asBigInt) {
            switch (radix) {
              case 2:
                str = `0b${str}`;
                break;
              case 8:
                str = `0o${str}`;
                break;
              case 16:
                str = `0x${str}`;
                break;
            }
            const n22 = BigInt(str);
            return sign === "-" ? BigInt(-1) * n22 : n22;
          }
          const n2 = parseInt(str, radix);
          return sign === "-" ? -1 * n2 : n2;
        }
        function intStringify(node, radix, prefix) {
          const {
            value
          } = node;
          if (intIdentify(value)) {
            const str = value.toString(radix);
            return value < 0 ? "-" + prefix + str.substr(1) : prefix + str;
          }
          return resolveSeq.stringifyNumber(node);
        }
        var yaml11 = failsafe.concat([{
          identify: (value) => value == null,
          createNode: (schema, value, ctx) => ctx.wrapScalars ? new resolveSeq.Scalar(null) : null,
          default: true,
          tag: "tag:yaml.org,2002:null",
          test: /^(?:~|[Nn]ull|NULL)?$/,
          resolve: () => null,
          options: resolveSeq.nullOptions,
          stringify: () => resolveSeq.nullOptions.nullStr
        }, {
          identify: (value) => typeof value === "boolean",
          default: true,
          tag: "tag:yaml.org,2002:bool",
          test: /^(?:Y|y|[Yy]es|YES|[Tt]rue|TRUE|[Oo]n|ON)$/,
          resolve: () => true,
          options: resolveSeq.boolOptions,
          stringify: boolStringify
        }, {
          identify: (value) => typeof value === "boolean",
          default: true,
          tag: "tag:yaml.org,2002:bool",
          test: /^(?:N|n|[Nn]o|NO|[Ff]alse|FALSE|[Oo]ff|OFF)$/i,
          resolve: () => false,
          options: resolveSeq.boolOptions,
          stringify: boolStringify
        }, {
          identify: intIdentify,
          default: true,
          tag: "tag:yaml.org,2002:int",
          format: "BIN",
          test: /^([-+]?)0b([0-1_]+)$/,
          resolve: (str, sign, bin) => intResolve(sign, bin, 2),
          stringify: (node) => intStringify(node, 2, "0b")
        }, {
          identify: intIdentify,
          default: true,
          tag: "tag:yaml.org,2002:int",
          format: "OCT",
          test: /^([-+]?)0([0-7_]+)$/,
          resolve: (str, sign, oct) => intResolve(sign, oct, 8),
          stringify: (node) => intStringify(node, 8, "0")
        }, {
          identify: intIdentify,
          default: true,
          tag: "tag:yaml.org,2002:int",
          test: /^([-+]?)([0-9][0-9_]*)$/,
          resolve: (str, sign, abs) => intResolve(sign, abs, 10),
          stringify: resolveSeq.stringifyNumber
        }, {
          identify: intIdentify,
          default: true,
          tag: "tag:yaml.org,2002:int",
          format: "HEX",
          test: /^([-+]?)0x([0-9a-fA-F_]+)$/,
          resolve: (str, sign, hex) => intResolve(sign, hex, 16),
          stringify: (node) => intStringify(node, 16, "0x")
        }, {
          identify: (value) => typeof value === "number",
          default: true,
          tag: "tag:yaml.org,2002:float",
          test: /^(?:[-+]?\.inf|(\.nan))$/i,
          resolve: (str, nan) => nan ? NaN : str[0] === "-" ? Number.NEGATIVE_INFINITY : Number.POSITIVE_INFINITY,
          stringify: resolveSeq.stringifyNumber
        }, {
          identify: (value) => typeof value === "number",
          default: true,
          tag: "tag:yaml.org,2002:float",
          format: "EXP",
          test: /^[-+]?([0-9][0-9_]*)?(\.[0-9_]*)?[eE][-+]?[0-9]+$/,
          resolve: (str) => parseFloat(str.replace(/_/g, "")),
          stringify: ({
            value
          }) => Number(value).toExponential()
        }, {
          identify: (value) => typeof value === "number",
          default: true,
          tag: "tag:yaml.org,2002:float",
          test: /^[-+]?(?:[0-9][0-9_]*)?\.([0-9_]*)$/,
          resolve(str, frac) {
            const node = new resolveSeq.Scalar(parseFloat(str.replace(/_/g, "")));
            if (frac) {
              const f = frac.replace(/_/g, "");
              if (f[f.length - 1] === "0")
                node.minFractionDigits = f.length;
            }
            return node;
          },
          stringify: resolveSeq.stringifyNumber
        }], warnings.binary, warnings.omap, warnings.pairs, warnings.set, warnings.intTime, warnings.floatTime, warnings.timestamp);
        var schemas = {
          core,
          failsafe,
          json,
          yaml11
        };
        var tags = {
          binary: warnings.binary,
          bool: boolObj,
          float: floatObj,
          floatExp: expObj,
          floatNaN: nanObj,
          floatTime: warnings.floatTime,
          int: intObj,
          intHex: hexObj,
          intOct: octObj,
          intTime: warnings.intTime,
          map,
          null: nullObj,
          omap: warnings.omap,
          pairs: warnings.pairs,
          seq,
          set: warnings.set,
          timestamp: warnings.timestamp
        };
        function findTagObject(value, tagName, tags2) {
          if (tagName) {
            const match = tags2.filter((t) => t.tag === tagName);
            const tagObj = match.find((t) => !t.format) || match[0];
            if (!tagObj)
              throw new Error(`Tag ${tagName} not found`);
            return tagObj;
          }
          return tags2.find((t) => (t.identify && t.identify(value) || t.class && value instanceof t.class) && !t.format);
        }
        function createNode(value, tagName, ctx) {
          if (value instanceof resolveSeq.Node)
            return value;
          const {
            defaultPrefix,
            onTagObj,
            prevObjects,
            schema,
            wrapScalars
          } = ctx;
          if (tagName && tagName.startsWith("!!"))
            tagName = defaultPrefix + tagName.slice(2);
          let tagObj = findTagObject(value, tagName, schema.tags);
          if (!tagObj) {
            if (typeof value.toJSON === "function")
              value = value.toJSON();
            if (!value || typeof value !== "object")
              return wrapScalars ? new resolveSeq.Scalar(value) : value;
            tagObj = value instanceof Map ? map : value[Symbol.iterator] ? seq : map;
          }
          if (onTagObj) {
            onTagObj(tagObj);
            delete ctx.onTagObj;
          }
          const obj = {
            value: void 0,
            node: void 0
          };
          if (value && typeof value === "object" && prevObjects) {
            const prev = prevObjects.get(value);
            if (prev) {
              const alias = new resolveSeq.Alias(prev);
              ctx.aliasNodes.push(alias);
              return alias;
            }
            obj.value = value;
            prevObjects.set(value, obj);
          }
          obj.node = tagObj.createNode ? tagObj.createNode(ctx.schema, value, ctx) : wrapScalars ? new resolveSeq.Scalar(value) : value;
          if (tagName && obj.node instanceof resolveSeq.Node)
            obj.node.tag = tagName;
          return obj.node;
        }
        function getSchemaTags(schemas2, knownTags, customTags, schemaId) {
          let tags2 = schemas2[schemaId.replace(/\W/g, "")];
          if (!tags2) {
            const keys = Object.keys(schemas2).map((key) => JSON.stringify(key)).join(", ");
            throw new Error(`Unknown schema "${schemaId}"; use one of ${keys}`);
          }
          if (Array.isArray(customTags)) {
            for (const tag of customTags)
              tags2 = tags2.concat(tag);
          } else if (typeof customTags === "function") {
            tags2 = customTags(tags2.slice());
          }
          for (let i = 0; i < tags2.length; ++i) {
            const tag = tags2[i];
            if (typeof tag === "string") {
              const tagObj = knownTags[tag];
              if (!tagObj) {
                const keys = Object.keys(knownTags).map((key) => JSON.stringify(key)).join(", ");
                throw new Error(`Unknown custom tag "${tag}"; use one of ${keys}`);
              }
              tags2[i] = tagObj;
            }
          }
          return tags2;
        }
        var sortMapEntriesByKey = (a, b) => a.key < b.key ? -1 : a.key > b.key ? 1 : 0;
        var Schema = class {
          constructor({
            customTags,
            merge,
            schema,
            sortMapEntries,
            tags: deprecatedCustomTags
          }) {
            this.merge = !!merge;
            this.name = schema;
            this.sortMapEntries = sortMapEntries === true ? sortMapEntriesByKey : sortMapEntries || null;
            if (!customTags && deprecatedCustomTags)
              warnings.warnOptionDeprecation("tags", "customTags");
            this.tags = getSchemaTags(schemas, tags, customTags || deprecatedCustomTags, schema);
          }
          createNode(value, wrapScalars, tagName, ctx) {
            const baseCtx = {
              defaultPrefix: Schema.defaultPrefix,
              schema: this,
              wrapScalars
            };
            const createCtx = ctx ? Object.assign(ctx, baseCtx) : baseCtx;
            return createNode(value, tagName, createCtx);
          }
          createPair(key, value, ctx) {
            if (!ctx)
              ctx = {
                wrapScalars: true
              };
            const k = this.createNode(key, ctx.wrapScalars, null, ctx);
            const v = this.createNode(value, ctx.wrapScalars, null, ctx);
            return new resolveSeq.Pair(k, v);
          }
        };
        PlainValue._defineProperty(Schema, "defaultPrefix", PlainValue.defaultTagPrefix);
        PlainValue._defineProperty(Schema, "defaultTags", PlainValue.defaultTags);
        exports2.Schema = Schema;
      }
    });
    var require_Document_9b4560a1 = __commonJS2({
      "node_modules/yaml/dist/Document-9b4560a1.js"(exports2) {
        "use strict";
        var PlainValue = require_PlainValue_ec8e588e();
        var resolveSeq = require_resolveSeq_d03cb037();
        var Schema = require_Schema_88e323a7();
        var defaultOptions = {
          anchorPrefix: "a",
          customTags: null,
          indent: 2,
          indentSeq: true,
          keepCstNodes: false,
          keepNodeTypes: true,
          keepBlobsInJSON: true,
          mapAsMap: false,
          maxAliasCount: 100,
          prettyErrors: false,
          simpleKeys: false,
          version: "1.2"
        };
        var scalarOptions = {
          get binary() {
            return resolveSeq.binaryOptions;
          },
          set binary(opt) {
            Object.assign(resolveSeq.binaryOptions, opt);
          },
          get bool() {
            return resolveSeq.boolOptions;
          },
          set bool(opt) {
            Object.assign(resolveSeq.boolOptions, opt);
          },
          get int() {
            return resolveSeq.intOptions;
          },
          set int(opt) {
            Object.assign(resolveSeq.intOptions, opt);
          },
          get null() {
            return resolveSeq.nullOptions;
          },
          set null(opt) {
            Object.assign(resolveSeq.nullOptions, opt);
          },
          get str() {
            return resolveSeq.strOptions;
          },
          set str(opt) {
            Object.assign(resolveSeq.strOptions, opt);
          }
        };
        var documentOptions = {
          "1.0": {
            schema: "yaml-1.1",
            merge: true,
            tagPrefixes: [{
              handle: "!",
              prefix: PlainValue.defaultTagPrefix
            }, {
              handle: "!!",
              prefix: "tag:private.yaml.org,2002:"
            }]
          },
          1.1: {
            schema: "yaml-1.1",
            merge: true,
            tagPrefixes: [{
              handle: "!",
              prefix: "!"
            }, {
              handle: "!!",
              prefix: PlainValue.defaultTagPrefix
            }]
          },
          1.2: {
            schema: "core",
            merge: false,
            tagPrefixes: [{
              handle: "!",
              prefix: "!"
            }, {
              handle: "!!",
              prefix: PlainValue.defaultTagPrefix
            }]
          }
        };
        function stringifyTag(doc, tag) {
          if ((doc.version || doc.options.version) === "1.0") {
            const priv = tag.match(/^tag:private\.yaml\.org,2002:([^:/]+)$/);
            if (priv)
              return "!" + priv[1];
            const vocab = tag.match(/^tag:([a-zA-Z0-9-]+)\.yaml\.org,2002:(.*)/);
            return vocab ? `!${vocab[1]}/${vocab[2]}` : `!${tag.replace(/^tag:/, "")}`;
          }
          let p = doc.tagPrefixes.find((p2) => tag.indexOf(p2.prefix) === 0);
          if (!p) {
            const dtp = doc.getDefaults().tagPrefixes;
            p = dtp && dtp.find((p2) => tag.indexOf(p2.prefix) === 0);
          }
          if (!p)
            return tag[0] === "!" ? tag : `!<${tag}>`;
          const suffix = tag.substr(p.prefix.length).replace(/[!,[\]{}]/g, (ch) => ({
            "!": "%21",
            ",": "%2C",
            "[": "%5B",
            "]": "%5D",
            "{": "%7B",
            "}": "%7D"
          })[ch]);
          return p.handle + suffix;
        }
        function getTagObject(tags, item) {
          if (item instanceof resolveSeq.Alias)
            return resolveSeq.Alias;
          if (item.tag) {
            const match = tags.filter((t) => t.tag === item.tag);
            if (match.length > 0)
              return match.find((t) => t.format === item.format) || match[0];
          }
          let tagObj, obj;
          if (item instanceof resolveSeq.Scalar) {
            obj = item.value;
            const match = tags.filter((t) => t.identify && t.identify(obj) || t.class && obj instanceof t.class);
            tagObj = match.find((t) => t.format === item.format) || match.find((t) => !t.format);
          } else {
            obj = item;
            tagObj = tags.find((t) => t.nodeClass && obj instanceof t.nodeClass);
          }
          if (!tagObj) {
            const name = obj && obj.constructor ? obj.constructor.name : typeof obj;
            throw new Error(`Tag not resolved for ${name} value`);
          }
          return tagObj;
        }
        function stringifyProps(node, tagObj, {
          anchors,
          doc
        }) {
          const props = [];
          const anchor = doc.anchors.getName(node);
          if (anchor) {
            anchors[anchor] = node;
            props.push(`&${anchor}`);
          }
          if (node.tag) {
            props.push(stringifyTag(doc, node.tag));
          } else if (!tagObj.default) {
            props.push(stringifyTag(doc, tagObj.tag));
          }
          return props.join(" ");
        }
        function stringify(item, ctx, onComment, onChompKeep) {
          const {
            anchors,
            schema
          } = ctx.doc;
          let tagObj;
          if (!(item instanceof resolveSeq.Node)) {
            const createCtx = {
              aliasNodes: [],
              onTagObj: (o) => tagObj = o,
              prevObjects: /* @__PURE__ */ new Map()
            };
            item = schema.createNode(item, true, null, createCtx);
            for (const alias of createCtx.aliasNodes) {
              alias.source = alias.source.node;
              let name = anchors.getName(alias.source);
              if (!name) {
                name = anchors.newName();
                anchors.map[name] = alias.source;
              }
            }
          }
          if (item instanceof resolveSeq.Pair)
            return item.toString(ctx, onComment, onChompKeep);
          if (!tagObj)
            tagObj = getTagObject(schema.tags, item);
          const props = stringifyProps(item, tagObj, ctx);
          if (props.length > 0)
            ctx.indentAtStart = (ctx.indentAtStart || 0) + props.length + 1;
          const str = typeof tagObj.stringify === "function" ? tagObj.stringify(item, ctx, onComment, onChompKeep) : item instanceof resolveSeq.Scalar ? resolveSeq.stringifyString(item, ctx, onComment, onChompKeep) : item.toString(ctx, onComment, onChompKeep);
          if (!props)
            return str;
          return item instanceof resolveSeq.Scalar || str[0] === "{" || str[0] === "[" ? `${props} ${str}` : `${props}
${ctx.indent}${str}`;
        }
        var Anchors = class {
          static validAnchorNode(node) {
            return node instanceof resolveSeq.Scalar || node instanceof resolveSeq.YAMLSeq || node instanceof resolveSeq.YAMLMap;
          }
          constructor(prefix) {
            PlainValue._defineProperty(this, "map", /* @__PURE__ */ Object.create(null));
            this.prefix = prefix;
          }
          createAlias(node, name) {
            this.setAnchor(node, name);
            return new resolveSeq.Alias(node);
          }
          createMergePair(...sources) {
            const merge = new resolveSeq.Merge();
            merge.value.items = sources.map((s) => {
              if (s instanceof resolveSeq.Alias) {
                if (s.source instanceof resolveSeq.YAMLMap)
                  return s;
              } else if (s instanceof resolveSeq.YAMLMap) {
                return this.createAlias(s);
              }
              throw new Error("Merge sources must be Map nodes or their Aliases");
            });
            return merge;
          }
          getName(node) {
            const {
              map
            } = this;
            return Object.keys(map).find((a) => map[a] === node);
          }
          getNames() {
            return Object.keys(this.map);
          }
          getNode(name) {
            return this.map[name];
          }
          newName(prefix) {
            if (!prefix)
              prefix = this.prefix;
            const names = Object.keys(this.map);
            for (let i = 1; true; ++i) {
              const name = `${prefix}${i}`;
              if (!names.includes(name))
                return name;
            }
          }
          resolveNodes() {
            const {
              map,
              _cstAliases
            } = this;
            Object.keys(map).forEach((a) => {
              map[a] = map[a].resolved;
            });
            _cstAliases.forEach((a) => {
              a.source = a.source.resolved;
            });
            delete this._cstAliases;
          }
          setAnchor(node, name) {
            if (node != null && !Anchors.validAnchorNode(node)) {
              throw new Error("Anchors may only be set for Scalar, Seq and Map nodes");
            }
            if (name && /[\x00-\x19\s,[\]{}]/.test(name)) {
              throw new Error("Anchor names must not contain whitespace or control characters");
            }
            const {
              map
            } = this;
            const prev = node && Object.keys(map).find((a) => map[a] === node);
            if (prev) {
              if (!name) {
                return prev;
              } else if (prev !== name) {
                delete map[prev];
                map[name] = node;
              }
            } else {
              if (!name) {
                if (!node)
                  return null;
                name = this.newName();
              }
              map[name] = node;
            }
            return name;
          }
        };
        var visit = (node, tags) => {
          if (node && typeof node === "object") {
            const {
              tag
            } = node;
            if (node instanceof resolveSeq.Collection) {
              if (tag)
                tags[tag] = true;
              node.items.forEach((n2) => visit(n2, tags));
            } else if (node instanceof resolveSeq.Pair) {
              visit(node.key, tags);
              visit(node.value, tags);
            } else if (node instanceof resolveSeq.Scalar) {
              if (tag)
                tags[tag] = true;
            }
          }
          return tags;
        };
        var listTagNames = (node) => Object.keys(visit(node, {}));
        function parseContents(doc, contents) {
          const comments = {
            before: [],
            after: []
          };
          let body = void 0;
          let spaceBefore = false;
          for (const node of contents) {
            if (node.valueRange) {
              if (body !== void 0) {
                const msg = "Document contains trailing content not separated by a ... or --- line";
                doc.errors.push(new PlainValue.YAMLSyntaxError(node, msg));
                break;
              }
              const res = resolveSeq.resolveNode(doc, node);
              if (spaceBefore) {
                res.spaceBefore = true;
                spaceBefore = false;
              }
              body = res;
            } else if (node.comment !== null) {
              const cc = body === void 0 ? comments.before : comments.after;
              cc.push(node.comment);
            } else if (node.type === PlainValue.Type.BLANK_LINE) {
              spaceBefore = true;
              if (body === void 0 && comments.before.length > 0 && !doc.commentBefore) {
                doc.commentBefore = comments.before.join("\n");
                comments.before = [];
              }
            }
          }
          doc.contents = body || null;
          if (!body) {
            doc.comment = comments.before.concat(comments.after).join("\n") || null;
          } else {
            const cb = comments.before.join("\n");
            if (cb) {
              const cbNode = body instanceof resolveSeq.Collection && body.items[0] ? body.items[0] : body;
              cbNode.commentBefore = cbNode.commentBefore ? `${cb}
${cbNode.commentBefore}` : cb;
            }
            doc.comment = comments.after.join("\n") || null;
          }
        }
        function resolveTagDirective({
          tagPrefixes
        }, directive) {
          const [handle, prefix] = directive.parameters;
          if (!handle || !prefix) {
            const msg = "Insufficient parameters given for %TAG directive";
            throw new PlainValue.YAMLSemanticError(directive, msg);
          }
          if (tagPrefixes.some((p) => p.handle === handle)) {
            const msg = "The %TAG directive must only be given at most once per handle in the same document.";
            throw new PlainValue.YAMLSemanticError(directive, msg);
          }
          return {
            handle,
            prefix
          };
        }
        function resolveYamlDirective(doc, directive) {
          let [version] = directive.parameters;
          if (directive.name === "YAML:1.0")
            version = "1.0";
          if (!version) {
            const msg = "Insufficient parameters given for %YAML directive";
            throw new PlainValue.YAMLSemanticError(directive, msg);
          }
          if (!documentOptions[version]) {
            const v0 = doc.version || doc.options.version;
            const msg = `Document will be parsed as YAML ${v0} rather than YAML ${version}`;
            doc.warnings.push(new PlainValue.YAMLWarning(directive, msg));
          }
          return version;
        }
        function parseDirectives(doc, directives, prevDoc) {
          const directiveComments = [];
          let hasDirectives = false;
          for (const directive of directives) {
            const {
              comment,
              name
            } = directive;
            switch (name) {
              case "TAG":
                try {
                  doc.tagPrefixes.push(resolveTagDirective(doc, directive));
                } catch (error) {
                  doc.errors.push(error);
                }
                hasDirectives = true;
                break;
              case "YAML":
              case "YAML:1.0":
                if (doc.version) {
                  const msg = "The %YAML directive must only be given at most once per document.";
                  doc.errors.push(new PlainValue.YAMLSemanticError(directive, msg));
                }
                try {
                  doc.version = resolveYamlDirective(doc, directive);
                } catch (error) {
                  doc.errors.push(error);
                }
                hasDirectives = true;
                break;
              default:
                if (name) {
                  const msg = `YAML only supports %TAG and %YAML directives, and not %${name}`;
                  doc.warnings.push(new PlainValue.YAMLWarning(directive, msg));
                }
            }
            if (comment)
              directiveComments.push(comment);
          }
          if (prevDoc && !hasDirectives && "1.1" === (doc.version || prevDoc.version || doc.options.version)) {
            const copyTagPrefix = ({
              handle,
              prefix
            }) => ({
              handle,
              prefix
            });
            doc.tagPrefixes = prevDoc.tagPrefixes.map(copyTagPrefix);
            doc.version = prevDoc.version;
          }
          doc.commentBefore = directiveComments.join("\n") || null;
        }
        function assertCollection(contents) {
          if (contents instanceof resolveSeq.Collection)
            return true;
          throw new Error("Expected a YAML collection as document contents");
        }
        var Document = class {
          constructor(options) {
            this.anchors = new Anchors(options.anchorPrefix);
            this.commentBefore = null;
            this.comment = null;
            this.contents = null;
            this.directivesEndMarker = null;
            this.errors = [];
            this.options = options;
            this.schema = null;
            this.tagPrefixes = [];
            this.version = null;
            this.warnings = [];
          }
          add(value) {
            assertCollection(this.contents);
            return this.contents.add(value);
          }
          addIn(path, value) {
            assertCollection(this.contents);
            this.contents.addIn(path, value);
          }
          delete(key) {
            assertCollection(this.contents);
            return this.contents.delete(key);
          }
          deleteIn(path) {
            if (resolveSeq.isEmptyPath(path)) {
              if (this.contents == null)
                return false;
              this.contents = null;
              return true;
            }
            assertCollection(this.contents);
            return this.contents.deleteIn(path);
          }
          getDefaults() {
            return Document.defaults[this.version] || Document.defaults[this.options.version] || {};
          }
          get(key, keepScalar) {
            return this.contents instanceof resolveSeq.Collection ? this.contents.get(key, keepScalar) : void 0;
          }
          getIn(path, keepScalar) {
            if (resolveSeq.isEmptyPath(path))
              return !keepScalar && this.contents instanceof resolveSeq.Scalar ? this.contents.value : this.contents;
            return this.contents instanceof resolveSeq.Collection ? this.contents.getIn(path, keepScalar) : void 0;
          }
          has(key) {
            return this.contents instanceof resolveSeq.Collection ? this.contents.has(key) : false;
          }
          hasIn(path) {
            if (resolveSeq.isEmptyPath(path))
              return this.contents !== void 0;
            return this.contents instanceof resolveSeq.Collection ? this.contents.hasIn(path) : false;
          }
          set(key, value) {
            assertCollection(this.contents);
            this.contents.set(key, value);
          }
          setIn(path, value) {
            if (resolveSeq.isEmptyPath(path))
              this.contents = value;
            else {
              assertCollection(this.contents);
              this.contents.setIn(path, value);
            }
          }
          setSchema(id, customTags) {
            if (!id && !customTags && this.schema)
              return;
            if (typeof id === "number")
              id = id.toFixed(1);
            if (id === "1.0" || id === "1.1" || id === "1.2") {
              if (this.version)
                this.version = id;
              else
                this.options.version = id;
              delete this.options.schema;
            } else if (id && typeof id === "string") {
              this.options.schema = id;
            }
            if (Array.isArray(customTags))
              this.options.customTags = customTags;
            const opt = Object.assign({}, this.getDefaults(), this.options);
            this.schema = new Schema.Schema(opt);
          }
          parse(node, prevDoc) {
            if (this.options.keepCstNodes)
              this.cstNode = node;
            if (this.options.keepNodeTypes)
              this.type = "DOCUMENT";
            const {
              directives = [],
              contents = [],
              directivesEndMarker,
              error,
              valueRange
            } = node;
            if (error) {
              if (!error.source)
                error.source = this;
              this.errors.push(error);
            }
            parseDirectives(this, directives, prevDoc);
            if (directivesEndMarker)
              this.directivesEndMarker = true;
            this.range = valueRange ? [valueRange.start, valueRange.end] : null;
            this.setSchema();
            this.anchors._cstAliases = [];
            parseContents(this, contents);
            this.anchors.resolveNodes();
            if (this.options.prettyErrors) {
              for (const error2 of this.errors)
                if (error2 instanceof PlainValue.YAMLError)
                  error2.makePretty();
              for (const warn of this.warnings)
                if (warn instanceof PlainValue.YAMLError)
                  warn.makePretty();
            }
            return this;
          }
          listNonDefaultTags() {
            return listTagNames(this.contents).filter((t) => t.indexOf(Schema.Schema.defaultPrefix) !== 0);
          }
          setTagPrefix(handle, prefix) {
            if (handle[0] !== "!" || handle[handle.length - 1] !== "!")
              throw new Error("Handle must start and end with !");
            if (prefix) {
              const prev = this.tagPrefixes.find((p) => p.handle === handle);
              if (prev)
                prev.prefix = prefix;
              else
                this.tagPrefixes.push({
                  handle,
                  prefix
                });
            } else {
              this.tagPrefixes = this.tagPrefixes.filter((p) => p.handle !== handle);
            }
          }
          toJSON(arg, onAnchor) {
            const {
              keepBlobsInJSON,
              mapAsMap,
              maxAliasCount
            } = this.options;
            const keep = keepBlobsInJSON && (typeof arg !== "string" || !(this.contents instanceof resolveSeq.Scalar));
            const ctx = {
              doc: this,
              indentStep: "  ",
              keep,
              mapAsMap: keep && !!mapAsMap,
              maxAliasCount,
              stringify
            };
            const anchorNames = Object.keys(this.anchors.map);
            if (anchorNames.length > 0)
              ctx.anchors = new Map(anchorNames.map((name) => [this.anchors.map[name], {
                alias: [],
                aliasCount: 0,
                count: 1
              }]));
            const res = resolveSeq.toJSON(this.contents, arg, ctx);
            if (typeof onAnchor === "function" && ctx.anchors)
              for (const {
                count,
                res: res2
              } of ctx.anchors.values())
                onAnchor(res2, count);
            return res;
          }
          toString() {
            if (this.errors.length > 0)
              throw new Error("Document with errors cannot be stringified");
            const indentSize = this.options.indent;
            if (!Number.isInteger(indentSize) || indentSize <= 0) {
              const s = JSON.stringify(indentSize);
              throw new Error(`"indent" option must be a positive integer, not ${s}`);
            }
            this.setSchema();
            const lines = [];
            let hasDirectives = false;
            if (this.version) {
              let vd = "%YAML 1.2";
              if (this.schema.name === "yaml-1.1") {
                if (this.version === "1.0")
                  vd = "%YAML:1.0";
                else if (this.version === "1.1")
                  vd = "%YAML 1.1";
              }
              lines.push(vd);
              hasDirectives = true;
            }
            const tagNames = this.listNonDefaultTags();
            this.tagPrefixes.forEach(({
              handle,
              prefix
            }) => {
              if (tagNames.some((t) => t.indexOf(prefix) === 0)) {
                lines.push(`%TAG ${handle} ${prefix}`);
                hasDirectives = true;
              }
            });
            if (hasDirectives || this.directivesEndMarker)
              lines.push("---");
            if (this.commentBefore) {
              if (hasDirectives || !this.directivesEndMarker)
                lines.unshift("");
              lines.unshift(this.commentBefore.replace(/^/gm, "#"));
            }
            const ctx = {
              anchors: /* @__PURE__ */ Object.create(null),
              doc: this,
              indent: "",
              indentStep: " ".repeat(indentSize),
              stringify
            };
            let chompKeep = false;
            let contentComment = null;
            if (this.contents) {
              if (this.contents instanceof resolveSeq.Node) {
                if (this.contents.spaceBefore && (hasDirectives || this.directivesEndMarker))
                  lines.push("");
                if (this.contents.commentBefore)
                  lines.push(this.contents.commentBefore.replace(/^/gm, "#"));
                ctx.forceBlockIndent = !!this.comment;
                contentComment = this.contents.comment;
              }
              const onChompKeep = contentComment ? null : () => chompKeep = true;
              const body = stringify(this.contents, ctx, () => contentComment = null, onChompKeep);
              lines.push(resolveSeq.addComment(body, "", contentComment));
            } else if (this.contents !== void 0) {
              lines.push(stringify(this.contents, ctx));
            }
            if (this.comment) {
              if ((!chompKeep || contentComment) && lines[lines.length - 1] !== "")
                lines.push("");
              lines.push(this.comment.replace(/^/gm, "#"));
            }
            return lines.join("\n") + "\n";
          }
        };
        PlainValue._defineProperty(Document, "defaults", documentOptions);
        exports2.Document = Document;
        exports2.defaultOptions = defaultOptions;
        exports2.scalarOptions = scalarOptions;
      }
    });
    var require_dist2 = __commonJS2({
      "node_modules/yaml/dist/index.js"(exports2) {
        "use strict";
        var parseCst = require_parse_cst();
        var Document$1 = require_Document_9b4560a1();
        var Schema = require_Schema_88e323a7();
        var PlainValue = require_PlainValue_ec8e588e();
        var warnings = require_warnings_1000a372();
        require_resolveSeq_d03cb037();
        function createNode(value, wrapScalars = true, tag) {
          if (tag === void 0 && typeof wrapScalars === "string") {
            tag = wrapScalars;
            wrapScalars = true;
          }
          const options = Object.assign({}, Document$1.Document.defaults[Document$1.defaultOptions.version], Document$1.defaultOptions);
          const schema = new Schema.Schema(options);
          return schema.createNode(value, wrapScalars, tag);
        }
        var Document = class extends Document$1.Document {
          constructor(options) {
            super(Object.assign({}, Document$1.defaultOptions, options));
          }
        };
        function parseAllDocuments(src, options) {
          const stream = [];
          let prev;
          for (const cstDoc of parseCst.parse(src)) {
            const doc = new Document(options);
            doc.parse(cstDoc, prev);
            stream.push(doc);
            prev = doc;
          }
          return stream;
        }
        function parseDocument(src, options) {
          const cst = parseCst.parse(src);
          const doc = new Document(options).parse(cst[0]);
          if (cst.length > 1) {
            const errMsg = "Source contains multiple documents; please use YAML.parseAllDocuments()";
            doc.errors.unshift(new PlainValue.YAMLSemanticError(cst[1], errMsg));
          }
          return doc;
        }
        function parse2(src, options) {
          const doc = parseDocument(src, options);
          doc.warnings.forEach((warning) => warnings.warn(warning));
          if (doc.errors.length > 0)
            throw doc.errors[0];
          return doc.toJSON();
        }
        function stringify(value, options) {
          const doc = new Document(options);
          doc.contents = value;
          return String(doc);
        }
        var YAML = {
          createNode,
          defaultOptions: Document$1.defaultOptions,
          Document,
          parse: parse2,
          parseAllDocuments,
          parseCST: parseCst.parse,
          parseDocument,
          scalarOptions: Document$1.scalarOptions,
          stringify
        };
        exports2.YAML = YAML;
      }
    });
    var require_yaml = __commonJS2({
      "node_modules/yaml/index.js"(exports2, module22) {
        module22.exports = require_dist2().YAML;
      }
    });
    var require_loaders = __commonJS2({
      "node_modules/cosmiconfig/dist/loaders.js"(exports2) {
        "use strict";
        Object.defineProperty(exports2, "__esModule", {
          value: true
        });
        exports2.loaders = void 0;
        var importFresh;
        var loadJs = function loadJs2(filepath) {
          if (importFresh === void 0) {
            importFresh = require_import_fresh();
          }
          const result = importFresh(filepath);
          return result;
        };
        var parseJson;
        var loadJson = function loadJson2(filepath, content) {
          if (parseJson === void 0) {
            parseJson = require_parse_json();
          }
          try {
            const result = parseJson(content);
            return result;
          } catch (error) {
            error.message = `JSON Error in ${filepath}:
${error.message}`;
            throw error;
          }
        };
        var yaml;
        var loadYaml = function loadYaml2(filepath, content) {
          if (yaml === void 0) {
            yaml = require_yaml();
          }
          try {
            const result = yaml.parse(content, {
              prettyErrors: true
            });
            return result;
          } catch (error) {
            error.message = `YAML Error in ${filepath}:
${error.message}`;
            throw error;
          }
        };
        var loaders = {
          loadJs,
          loadJson,
          loadYaml
        };
        exports2.loaders = loaders;
      }
    });
    var require_getPropertyByPath = __commonJS2({
      "node_modules/cosmiconfig/dist/getPropertyByPath.js"(exports2) {
        "use strict";
        Object.defineProperty(exports2, "__esModule", {
          value: true
        });
        exports2.getPropertyByPath = getPropertyByPath;
        function getPropertyByPath(source, path) {
          if (typeof path === "string" && Object.prototype.hasOwnProperty.call(source, path)) {
            return source[path];
          }
          const parsedPath = typeof path === "string" ? path.split(".") : path;
          return parsedPath.reduce((previous, key) => {
            if (previous === void 0) {
              return previous;
            }
            return previous[key];
          }, source);
        }
      }
    });
    var require_ExplorerBase = __commonJS2({
      "node_modules/cosmiconfig/dist/ExplorerBase.js"(exports2) {
        "use strict";
        Object.defineProperty(exports2, "__esModule", {
          value: true
        });
        exports2.getExtensionDescription = getExtensionDescription;
        exports2.ExplorerBase = void 0;
        var _path = _interopRequireDefault(require("path"));
        var _loaders = require_loaders();
        var _getPropertyByPath = require_getPropertyByPath();
        function _interopRequireDefault(obj) {
          return obj && obj.__esModule ? obj : {
            default: obj
          };
        }
        var ExplorerBase = class {
          constructor(options) {
            if (options.cache === true) {
              this.loadCache = /* @__PURE__ */ new Map();
              this.searchCache = /* @__PURE__ */ new Map();
            }
            this.config = options;
            this.validateConfig();
          }
          clearLoadCache() {
            if (this.loadCache) {
              this.loadCache.clear();
            }
          }
          clearSearchCache() {
            if (this.searchCache) {
              this.searchCache.clear();
            }
          }
          clearCaches() {
            this.clearLoadCache();
            this.clearSearchCache();
          }
          validateConfig() {
            const config = this.config;
            config.searchPlaces.forEach((place) => {
              const loaderKey = _path.default.extname(place) || "noExt";
              const loader = config.loaders[loaderKey];
              if (!loader) {
                throw new Error(`No loader specified for ${getExtensionDescription(place)}, so searchPlaces item "${place}" is invalid`);
              }
              if (typeof loader !== "function") {
                throw new Error(`loader for ${getExtensionDescription(place)} is not a function (type provided: "${typeof loader}"), so searchPlaces item "${place}" is invalid`);
              }
            });
          }
          shouldSearchStopWithResult(result) {
            if (result === null)
              return false;
            if (result.isEmpty && this.config.ignoreEmptySearchPlaces)
              return false;
            return true;
          }
          nextDirectoryToSearch(currentDir, currentResult) {
            if (this.shouldSearchStopWithResult(currentResult)) {
              return null;
            }
            const nextDir = nextDirUp(currentDir);
            if (nextDir === currentDir || currentDir === this.config.stopDir) {
              return null;
            }
            return nextDir;
          }
          loadPackageProp(filepath, content) {
            const parsedContent = _loaders.loaders.loadJson(filepath, content);
            const packagePropValue = (0, _getPropertyByPath.getPropertyByPath)(parsedContent, this.config.packageProp);
            return packagePropValue || null;
          }
          getLoaderEntryForFile(filepath) {
            if (_path.default.basename(filepath) === "package.json") {
              const loader2 = this.loadPackageProp.bind(this);
              return loader2;
            }
            const loaderKey = _path.default.extname(filepath) || "noExt";
            const loader = this.config.loaders[loaderKey];
            if (!loader) {
              throw new Error(`No loader specified for ${getExtensionDescription(filepath)}`);
            }
            return loader;
          }
          loadedContentToCosmiconfigResult(filepath, loadedContent) {
            if (loadedContent === null) {
              return null;
            }
            if (loadedContent === void 0) {
              return {
                filepath,
                config: void 0,
                isEmpty: true
              };
            }
            return {
              config: loadedContent,
              filepath
            };
          }
          validateFilePath(filepath) {
            if (!filepath) {
              throw new Error("load must pass a non-empty string");
            }
          }
        };
        exports2.ExplorerBase = ExplorerBase;
        function nextDirUp(dir) {
          return _path.default.dirname(dir);
        }
        function getExtensionDescription(filepath) {
          const ext = _path.default.extname(filepath);
          return ext ? `extension "${ext}"` : "files without extensions";
        }
      }
    });
    var require_readFile = __commonJS2({
      "node_modules/cosmiconfig/dist/readFile.js"(exports2) {
        "use strict";
        Object.defineProperty(exports2, "__esModule", {
          value: true
        });
        exports2.readFile = readFile;
        exports2.readFileSync = readFileSync2;
        var _fs = _interopRequireDefault(require("fs"));
        function _interopRequireDefault(obj) {
          return obj && obj.__esModule ? obj : {
            default: obj
          };
        }
        async function fsReadFileAsync(pathname, encoding) {
          return new Promise((resolve, reject) => {
            _fs.default.readFile(pathname, encoding, (error, contents) => {
              if (error) {
                reject(error);
                return;
              }
              resolve(contents);
            });
          });
        }
        async function readFile(filepath, options = {}) {
          const throwNotFound = options.throwNotFound === true;
          try {
            const content = await fsReadFileAsync(filepath, "utf8");
            return content;
          } catch (error) {
            if (throwNotFound === false && (error.code === "ENOENT" || error.code === "EISDIR")) {
              return null;
            }
            throw error;
          }
        }
        function readFileSync2(filepath, options = {}) {
          const throwNotFound = options.throwNotFound === true;
          try {
            const content = _fs.default.readFileSync(filepath, "utf8");
            return content;
          } catch (error) {
            if (throwNotFound === false && (error.code === "ENOENT" || error.code === "EISDIR")) {
              return null;
            }
            throw error;
          }
        }
      }
    });
    var require_cacheWrapper = __commonJS2({
      "node_modules/cosmiconfig/dist/cacheWrapper.js"(exports2) {
        "use strict";
        Object.defineProperty(exports2, "__esModule", {
          value: true
        });
        exports2.cacheWrapper = cacheWrapper;
        exports2.cacheWrapperSync = cacheWrapperSync;
        async function cacheWrapper(cache, key, fn) {
          const cached = cache.get(key);
          if (cached !== void 0) {
            return cached;
          }
          const result = await fn();
          cache.set(key, result);
          return result;
        }
        function cacheWrapperSync(cache, key, fn) {
          const cached = cache.get(key);
          if (cached !== void 0) {
            return cached;
          }
          const result = fn();
          cache.set(key, result);
          return result;
        }
      }
    });
    var require_path_type = __commonJS2({
      "node_modules/path-type/index.js"(exports2) {
        "use strict";
        var {
          promisify
        } = require("util");
        var fs2 = require("fs");
        async function isType(fsStatType, statsMethodName, filePath2) {
          if (typeof filePath2 !== "string") {
            throw new TypeError(`Expected a string, got ${typeof filePath2}`);
          }
          try {
            const stats = await promisify(fs2[fsStatType])(filePath2);
            return stats[statsMethodName]();
          } catch (error) {
            if (error.code === "ENOENT") {
              return false;
            }
            throw error;
          }
        }
        function isTypeSync(fsStatType, statsMethodName, filePath2) {
          if (typeof filePath2 !== "string") {
            throw new TypeError(`Expected a string, got ${typeof filePath2}`);
          }
          try {
            return fs2[fsStatType](filePath2)[statsMethodName]();
          } catch (error) {
            if (error.code === "ENOENT") {
              return false;
            }
            throw error;
          }
        }
        exports2.isFile = isType.bind(null, "stat", "isFile");
        exports2.isDirectory = isType.bind(null, "stat", "isDirectory");
        exports2.isSymlink = isType.bind(null, "lstat", "isSymbolicLink");
        exports2.isFileSync = isTypeSync.bind(null, "statSync", "isFile");
        exports2.isDirectorySync = isTypeSync.bind(null, "statSync", "isDirectory");
        exports2.isSymlinkSync = isTypeSync.bind(null, "lstatSync", "isSymbolicLink");
      }
    });
    var require_getDirectory = __commonJS2({
      "node_modules/cosmiconfig/dist/getDirectory.js"(exports2) {
        "use strict";
        Object.defineProperty(exports2, "__esModule", {
          value: true
        });
        exports2.getDirectory = getDirectory;
        exports2.getDirectorySync = getDirectorySync;
        var _path = _interopRequireDefault(require("path"));
        var _pathType = require_path_type();
        function _interopRequireDefault(obj) {
          return obj && obj.__esModule ? obj : {
            default: obj
          };
        }
        async function getDirectory(filepath) {
          const filePathIsDirectory = await (0, _pathType.isDirectory)(filepath);
          if (filePathIsDirectory === true) {
            return filepath;
          }
          const directory = _path.default.dirname(filepath);
          return directory;
        }
        function getDirectorySync(filepath) {
          const filePathIsDirectory = (0, _pathType.isDirectorySync)(filepath);
          if (filePathIsDirectory === true) {
            return filepath;
          }
          const directory = _path.default.dirname(filepath);
          return directory;
        }
      }
    });
    var require_Explorer = __commonJS2({
      "node_modules/cosmiconfig/dist/Explorer.js"(exports2) {
        "use strict";
        Object.defineProperty(exports2, "__esModule", {
          value: true
        });
        exports2.Explorer = void 0;
        var _path = _interopRequireDefault(require("path"));
        var _ExplorerBase = require_ExplorerBase();
        var _readFile = require_readFile();
        var _cacheWrapper = require_cacheWrapper();
        var _getDirectory = require_getDirectory();
        function _interopRequireDefault(obj) {
          return obj && obj.__esModule ? obj : {
            default: obj
          };
        }
        var Explorer = class extends _ExplorerBase.ExplorerBase {
          constructor(options) {
            super(options);
          }
          async search(searchFrom = process.cwd()) {
            const startDirectory = await (0, _getDirectory.getDirectory)(searchFrom);
            const result = await this.searchFromDirectory(startDirectory);
            return result;
          }
          async searchFromDirectory(dir) {
            const absoluteDir = _path.default.resolve(process.cwd(), dir);
            const run = async () => {
              const result = await this.searchDirectory(absoluteDir);
              const nextDir = this.nextDirectoryToSearch(absoluteDir, result);
              if (nextDir) {
                return this.searchFromDirectory(nextDir);
              }
              const transformResult = await this.config.transform(result);
              return transformResult;
            };
            if (this.searchCache) {
              return (0, _cacheWrapper.cacheWrapper)(this.searchCache, absoluteDir, run);
            }
            return run();
          }
          async searchDirectory(dir) {
            for await (const place of this.config.searchPlaces) {
              const placeResult = await this.loadSearchPlace(dir, place);
              if (this.shouldSearchStopWithResult(placeResult) === true) {
                return placeResult;
              }
            }
            return null;
          }
          async loadSearchPlace(dir, place) {
            const filepath = _path.default.join(dir, place);
            const fileContents = await (0, _readFile.readFile)(filepath);
            const result = await this.createCosmiconfigResult(filepath, fileContents);
            return result;
          }
          async loadFileContent(filepath, content) {
            if (content === null) {
              return null;
            }
            if (content.trim() === "") {
              return void 0;
            }
            const loader = this.getLoaderEntryForFile(filepath);
            const loaderResult = await loader(filepath, content);
            return loaderResult;
          }
          async createCosmiconfigResult(filepath, content) {
            const fileContent = await this.loadFileContent(filepath, content);
            const result = this.loadedContentToCosmiconfigResult(filepath, fileContent);
            return result;
          }
          async load(filepath) {
            this.validateFilePath(filepath);
            const absoluteFilePath = _path.default.resolve(process.cwd(), filepath);
            const runLoad = async () => {
              const fileContents = await (0, _readFile.readFile)(absoluteFilePath, {
                throwNotFound: true
              });
              const result = await this.createCosmiconfigResult(absoluteFilePath, fileContents);
              const transformResult = await this.config.transform(result);
              return transformResult;
            };
            if (this.loadCache) {
              return (0, _cacheWrapper.cacheWrapper)(this.loadCache, absoluteFilePath, runLoad);
            }
            return runLoad();
          }
        };
        exports2.Explorer = Explorer;
      }
    });
    var require_ExplorerSync = __commonJS2({
      "node_modules/cosmiconfig/dist/ExplorerSync.js"(exports2) {
        "use strict";
        Object.defineProperty(exports2, "__esModule", {
          value: true
        });
        exports2.ExplorerSync = void 0;
        var _path = _interopRequireDefault(require("path"));
        var _ExplorerBase = require_ExplorerBase();
        var _readFile = require_readFile();
        var _cacheWrapper = require_cacheWrapper();
        var _getDirectory = require_getDirectory();
        function _interopRequireDefault(obj) {
          return obj && obj.__esModule ? obj : {
            default: obj
          };
        }
        var ExplorerSync = class extends _ExplorerBase.ExplorerBase {
          constructor(options) {
            super(options);
          }
          searchSync(searchFrom = process.cwd()) {
            const startDirectory = (0, _getDirectory.getDirectorySync)(searchFrom);
            const result = this.searchFromDirectorySync(startDirectory);
            return result;
          }
          searchFromDirectorySync(dir) {
            const absoluteDir = _path.default.resolve(process.cwd(), dir);
            const run = () => {
              const result = this.searchDirectorySync(absoluteDir);
              const nextDir = this.nextDirectoryToSearch(absoluteDir, result);
              if (nextDir) {
                return this.searchFromDirectorySync(nextDir);
              }
              const transformResult = this.config.transform(result);
              return transformResult;
            };
            if (this.searchCache) {
              return (0, _cacheWrapper.cacheWrapperSync)(this.searchCache, absoluteDir, run);
            }
            return run();
          }
          searchDirectorySync(dir) {
            for (const place of this.config.searchPlaces) {
              const placeResult = this.loadSearchPlaceSync(dir, place);
              if (this.shouldSearchStopWithResult(placeResult) === true) {
                return placeResult;
              }
            }
            return null;
          }
          loadSearchPlaceSync(dir, place) {
            const filepath = _path.default.join(dir, place);
            const content = (0, _readFile.readFileSync)(filepath);
            const result = this.createCosmiconfigResultSync(filepath, content);
            return result;
          }
          loadFileContentSync(filepath, content) {
            if (content === null) {
              return null;
            }
            if (content.trim() === "") {
              return void 0;
            }
            const loader = this.getLoaderEntryForFile(filepath);
            const loaderResult = loader(filepath, content);
            return loaderResult;
          }
          createCosmiconfigResultSync(filepath, content) {
            const fileContent = this.loadFileContentSync(filepath, content);
            const result = this.loadedContentToCosmiconfigResult(filepath, fileContent);
            return result;
          }
          loadSync(filepath) {
            this.validateFilePath(filepath);
            const absoluteFilePath = _path.default.resolve(process.cwd(), filepath);
            const runLoadSync = () => {
              const content = (0, _readFile.readFileSync)(absoluteFilePath, {
                throwNotFound: true
              });
              const cosmiconfigResult = this.createCosmiconfigResultSync(absoluteFilePath, content);
              const transformResult = this.config.transform(cosmiconfigResult);
              return transformResult;
            };
            if (this.loadCache) {
              return (0, _cacheWrapper.cacheWrapperSync)(this.loadCache, absoluteFilePath, runLoadSync);
            }
            return runLoadSync();
          }
        };
        exports2.ExplorerSync = ExplorerSync;
      }
    });
    var require_types2 = __commonJS2({
      "node_modules/cosmiconfig/dist/types.js"(exports2) {
        "use strict";
        Object.defineProperty(exports2, "__esModule", {
          value: true
        });
      }
    });
    var require_dist22 = __commonJS2({
      "node_modules/cosmiconfig/dist/index.js"(exports2) {
        "use strict";
        Object.defineProperty(exports2, "__esModule", {
          value: true
        });
        exports2.cosmiconfig = cosmiconfig;
        exports2.cosmiconfigSync = cosmiconfigSync;
        exports2.defaultLoaders = void 0;
        var _os = _interopRequireDefault(require("os"));
        var _Explorer = require_Explorer();
        var _ExplorerSync = require_ExplorerSync();
        var _loaders = require_loaders();
        var _types = require_types2();
        function _interopRequireDefault(obj) {
          return obj && obj.__esModule ? obj : {
            default: obj
          };
        }
        function cosmiconfig(moduleName, options = {}) {
          const normalizedOptions = normalizeOptions(moduleName, options);
          const explorer = new _Explorer.Explorer(normalizedOptions);
          return {
            search: explorer.search.bind(explorer),
            load: explorer.load.bind(explorer),
            clearLoadCache: explorer.clearLoadCache.bind(explorer),
            clearSearchCache: explorer.clearSearchCache.bind(explorer),
            clearCaches: explorer.clearCaches.bind(explorer)
          };
        }
        function cosmiconfigSync(moduleName, options = {}) {
          const normalizedOptions = normalizeOptions(moduleName, options);
          const explorerSync = new _ExplorerSync.ExplorerSync(normalizedOptions);
          return {
            search: explorerSync.searchSync.bind(explorerSync),
            load: explorerSync.loadSync.bind(explorerSync),
            clearLoadCache: explorerSync.clearLoadCache.bind(explorerSync),
            clearSearchCache: explorerSync.clearSearchCache.bind(explorerSync),
            clearCaches: explorerSync.clearCaches.bind(explorerSync)
          };
        }
        var defaultLoaders = Object.freeze({
          ".cjs": _loaders.loaders.loadJs,
          ".js": _loaders.loaders.loadJs,
          ".json": _loaders.loaders.loadJson,
          ".yaml": _loaders.loaders.loadYaml,
          ".yml": _loaders.loaders.loadYaml,
          noExt: _loaders.loaders.loadYaml
        });
        exports2.defaultLoaders = defaultLoaders;
        var identity = function identity2(x) {
          return x;
        };
        function normalizeOptions(moduleName, options) {
          const defaults = {
            packageProp: moduleName,
            searchPlaces: ["package.json", `.${moduleName}rc`, `.${moduleName}rc.json`, `.${moduleName}rc.yaml`, `.${moduleName}rc.yml`, `.${moduleName}rc.js`, `.${moduleName}rc.cjs`, `${moduleName}.config.js`, `${moduleName}.config.cjs`],
            ignoreEmptySearchPlaces: true,
            stopDir: _os.default.homedir(),
            cache: true,
            transform: identity,
            loaders: defaultLoaders
          };
          const normalizedOptions = Object.assign(Object.assign(Object.assign({}, defaults), options), {}, {
            loaders: Object.assign(Object.assign({}, defaults.loaders), options.loaders)
          });
          return normalizedOptions;
        }
      }
    });
    var require_find_parent_dir = __commonJS2({
      "node_modules/find-parent-dir/index.js"(exports2, module22) {
        "use strict";
        var path = require("path");
        var fs2 = require("fs");
        var exists = fs2.exists || path.exists;
        var existsSync = fs2.existsSync || path.existsSync;
        function splitPath(path2) {
          var parts = path2.split(/(\/|\\)/);
          if (!parts.length)
            return parts;
          return !parts[0].length ? parts.slice(1) : parts;
        }
        exports2 = module22.exports = function(currentFullPath, clue, cb) {
          function testDir(parts) {
            if (parts.length === 0)
              return cb(null, null);
            var p = parts.join("");
            exists(path.join(p, clue), function(itdoes) {
              if (itdoes)
                return cb(null, p);
              testDir(parts.slice(0, -1));
            });
          }
          testDir(splitPath(currentFullPath));
        };
        exports2.sync = function(currentFullPath, clue) {
          function testDir(parts) {
            if (parts.length === 0)
              return null;
            var p = parts.join("");
            var itdoes = existsSync(path.join(p, clue));
            return itdoes ? p : testDir(parts.slice(0, -1));
          }
          return testDir(splitPath(currentFullPath));
        };
      }
    });
    var require_get_stdin = __commonJS2({
      "node_modules/get-stdin/index.js"(exports2, module22) {
        "use strict";
        var {
          stdin
        } = process;
        module22.exports = async () => {
          let result = "";
          if (stdin.isTTY) {
            return result;
          }
          stdin.setEncoding("utf8");
          for await (const chunk of stdin) {
            result += chunk;
          }
          return result;
        };
        module22.exports.buffer = async () => {
          const result = [];
          let length = 0;
          if (stdin.isTTY) {
            return Buffer.concat([]);
          }
          for await (const chunk of stdin) {
            result.push(chunk);
            length += chunk.length;
          }
          return Buffer.concat(result, length);
        };
      }
    });
    var require_vendors = __commonJS2({
      "node_modules/ci-info/vendors.json"(exports2, module22) {
        module22.exports = [{
          name: "AppVeyor",
          constant: "APPVEYOR",
          env: "APPVEYOR",
          pr: "APPVEYOR_PULL_REQUEST_NUMBER"
        }, {
          name: "Azure Pipelines",
          constant: "AZURE_PIPELINES",
          env: "SYSTEM_TEAMFOUNDATIONCOLLECTIONURI",
          pr: "SYSTEM_PULLREQUEST_PULLREQUESTID"
        }, {
          name: "Appcircle",
          constant: "APPCIRCLE",
          env: "AC_APPCIRCLE"
        }, {
          name: "Bamboo",
          constant: "BAMBOO",
          env: "bamboo_planKey"
        }, {
          name: "Bitbucket Pipelines",
          constant: "BITBUCKET",
          env: "BITBUCKET_COMMIT",
          pr: "BITBUCKET_PR_ID"
        }, {
          name: "Bitrise",
          constant: "BITRISE",
          env: "BITRISE_IO",
          pr: "BITRISE_PULL_REQUEST"
        }, {
          name: "Buddy",
          constant: "BUDDY",
          env: "BUDDY_WORKSPACE_ID",
          pr: "BUDDY_EXECUTION_PULL_REQUEST_ID"
        }, {
          name: "Buildkite",
          constant: "BUILDKITE",
          env: "BUILDKITE",
          pr: {
            env: "BUILDKITE_PULL_REQUEST",
            ne: "false"
          }
        }, {
          name: "CircleCI",
          constant: "CIRCLE",
          env: "CIRCLECI",
          pr: "CIRCLE_PULL_REQUEST"
        }, {
          name: "Cirrus CI",
          constant: "CIRRUS",
          env: "CIRRUS_CI",
          pr: "CIRRUS_PR"
        }, {
          name: "AWS CodeBuild",
          constant: "CODEBUILD",
          env: "CODEBUILD_BUILD_ARN"
        }, {
          name: "Codefresh",
          constant: "CODEFRESH",
          env: "CF_BUILD_ID",
          pr: {
            any: ["CF_PULL_REQUEST_NUMBER", "CF_PULL_REQUEST_ID"]
          }
        }, {
          name: "Codeship",
          constant: "CODESHIP",
          env: {
            CI_NAME: "codeship"
          }
        }, {
          name: "Drone",
          constant: "DRONE",
          env: "DRONE",
          pr: {
            DRONE_BUILD_EVENT: "pull_request"
          }
        }, {
          name: "dsari",
          constant: "DSARI",
          env: "DSARI"
        }, {
          name: "Expo Application Services",
          constant: "EAS",
          env: "EAS_BUILD"
        }, {
          name: "GitHub Actions",
          constant: "GITHUB_ACTIONS",
          env: "GITHUB_ACTIONS",
          pr: {
            GITHUB_EVENT_NAME: "pull_request"
          }
        }, {
          name: "GitLab CI",
          constant: "GITLAB",
          env: "GITLAB_CI",
          pr: "CI_MERGE_REQUEST_ID"
        }, {
          name: "GoCD",
          constant: "GOCD",
          env: "GO_PIPELINE_LABEL"
        }, {
          name: "LayerCI",
          constant: "LAYERCI",
          env: "LAYERCI",
          pr: "LAYERCI_PULL_REQUEST"
        }, {
          name: "Hudson",
          constant: "HUDSON",
          env: "HUDSON_URL"
        }, {
          name: "Jenkins",
          constant: "JENKINS",
          env: ["JENKINS_URL", "BUILD_ID"],
          pr: {
            any: ["ghprbPullId", "CHANGE_ID"]
          }
        }, {
          name: "Magnum CI",
          constant: "MAGNUM",
          env: "MAGNUM"
        }, {
          name: "Netlify CI",
          constant: "NETLIFY",
          env: "NETLIFY",
          pr: {
            env: "PULL_REQUEST",
            ne: "false"
          }
        }, {
          name: "Nevercode",
          constant: "NEVERCODE",
          env: "NEVERCODE",
          pr: {
            env: "NEVERCODE_PULL_REQUEST",
            ne: "false"
          }
        }, {
          name: "Render",
          constant: "RENDER",
          env: "RENDER",
          pr: {
            IS_PULL_REQUEST: "true"
          }
        }, {
          name: "Sail CI",
          constant: "SAIL",
          env: "SAILCI",
          pr: "SAIL_PULL_REQUEST_NUMBER"
        }, {
          name: "Semaphore",
          constant: "SEMAPHORE",
          env: "SEMAPHORE",
          pr: "PULL_REQUEST_NUMBER"
        }, {
          name: "Screwdriver",
          constant: "SCREWDRIVER",
          env: "SCREWDRIVER",
          pr: {
            env: "SD_PULL_REQUEST",
            ne: "false"
          }
        }, {
          name: "Shippable",
          constant: "SHIPPABLE",
          env: "SHIPPABLE",
          pr: {
            IS_PULL_REQUEST: "true"
          }
        }, {
          name: "Solano CI",
          constant: "SOLANO",
          env: "TDDIUM",
          pr: "TDDIUM_PR_ID"
        }, {
          name: "Strider CD",
          constant: "STRIDER",
          env: "STRIDER"
        }, {
          name: "TaskCluster",
          constant: "TASKCLUSTER",
          env: ["TASK_ID", "RUN_ID"]
        }, {
          name: "TeamCity",
          constant: "TEAMCITY",
          env: "TEAMCITY_VERSION"
        }, {
          name: "Travis CI",
          constant: "TRAVIS",
          env: "TRAVIS",
          pr: {
            env: "TRAVIS_PULL_REQUEST",
            ne: "false"
          }
        }, {
          name: "Vercel",
          constant: "VERCEL",
          env: "NOW_BUILDER"
        }, {
          name: "Visual Studio App Center",
          constant: "APPCENTER",
          env: "APPCENTER_BUILD_ID"
        }];
      }
    });
    var require_ci_info = __commonJS2({
      "node_modules/ci-info/index.js"(exports2) {
        "use strict";
        var vendors = require_vendors();
        var env = process.env;
        Object.defineProperty(exports2, "_vendors", {
          value: vendors.map(function(v) {
            return v.constant;
          })
        });
        exports2.name = null;
        exports2.isPR = null;
        vendors.forEach(function(vendor) {
          const envs = Array.isArray(vendor.env) ? vendor.env : [vendor.env];
          const isCI = envs.every(function(obj) {
            return checkEnv(obj);
          });
          exports2[vendor.constant] = isCI;
          if (isCI) {
            exports2.name = vendor.name;
            switch (typeof vendor.pr) {
              case "string":
                exports2.isPR = !!env[vendor.pr];
                break;
              case "object":
                if ("env" in vendor.pr) {
                  exports2.isPR = vendor.pr.env in env && env[vendor.pr.env] !== vendor.pr.ne;
                } else if ("any" in vendor.pr) {
                  exports2.isPR = vendor.pr.any.some(function(key) {
                    return !!env[key];
                  });
                } else {
                  exports2.isPR = checkEnv(vendor.pr);
                }
                break;
              default:
                exports2.isPR = null;
            }
          }
        });
        exports2.isCI = !!(env.CI || env.CONTINUOUS_INTEGRATION || env.BUILD_NUMBER || env.RUN_ID || exports2.name || false);
        function checkEnv(obj) {
          if (typeof obj === "string")
            return !!env[obj];
          return Object.keys(obj).every(function(k) {
            return env[k] === obj[k];
          });
        }
      }
    });
    module2.exports = {
      cosmiconfig: require_dist22().cosmiconfig,
      cosmiconfigSync: require_dist22().cosmiconfigSync,
      findParentDir: require_find_parent_dir().sync,
      getStdin: require_get_stdin(),
      isCI: () => require_ci_info().isCI
    };
  }
});

// node_modules/prettier/parser-babel.js
var require_parser_babel = __commonJS({
  "node_modules/prettier/parser-babel.js"(exports, module2) {
    (function(e) {
      if (typeof exports == "object" && typeof module2 == "object")
        module2.exports = e();
      else if (typeof define == "function" && define.amd)
        define(e);
      else {
        var i = typeof globalThis < "u" ? globalThis : typeof global < "u" ? global : typeof self < "u" ? self : this || {};
        i.prettierPlugins = i.prettierPlugins || {}, i.prettierPlugins.babel = e();
      }
    })(function() {
      "use strict";
      var E = (l, h) => () => (h || l((h = { exports: {} }).exports, h), h.exports);
      var re = E((xd, Zr) => {
        var Ct = function(l) {
          return l && l.Math == Math && l;
        };
        Zr.exports = Ct(typeof globalThis == "object" && globalThis) || Ct(typeof window == "object" && window) || Ct(typeof self == "object" && self) || Ct(typeof global == "object" && global) || function() {
          return this;
        }() || Function("return this")();
      });
      var ie = E((gd, ei) => {
        ei.exports = function(l) {
          try {
            return !!l();
          } catch {
            return true;
          }
        };
      });
      var ye = E((Pd, ti) => {
        var kh = ie();
        ti.exports = !kh(function() {
          return Object.defineProperty({}, 1, { get: function() {
            return 7;
          } })[1] != 7;
        });
      });
      var bt = E((Ad, si) => {
        var Dh = ie();
        si.exports = !Dh(function() {
          var l = function() {
          }.bind();
          return typeof l != "function" || l.hasOwnProperty("prototype");
        });
      });
      var wt = E((Td, ri) => {
        var Fh = bt(), St = Function.prototype.call;
        ri.exports = Fh ? St.bind(St) : function() {
          return St.apply(St, arguments);
        };
      });
      var oi = E((ni) => {
        "use strict";
        var ii = {}.propertyIsEnumerable, ai = Object.getOwnPropertyDescriptor, Lh = ai && !ii.call({ 1: 2 }, 1);
        ni.f = Lh ? function(h) {
          var p = ai(this, h);
          return !!p && p.enumerable;
        } : ii;
      });
      var fs2 = E((Ed, li) => {
        li.exports = function(l, h) {
          return { enumerable: !(l & 1), configurable: !(l & 2), writable: !(l & 4), value: h };
        };
      });
      var ae = E((Cd, ci) => {
        var hi = bt(), ui = Function.prototype, ds = ui.call, Oh = hi && ui.bind.bind(ds, ds);
        ci.exports = hi ? Oh : function(l) {
          return function() {
            return ds.apply(l, arguments);
          };
        };
      });
      var Ye = E((bd, fi) => {
        var pi = ae(), Bh = pi({}.toString), Mh = pi("".slice);
        fi.exports = function(l) {
          return Mh(Bh(l), 8, -1);
        };
      });
      var mi = E((Sd, di) => {
        var _h = ae(), Rh = ie(), jh = Ye(), ms = Object, qh = _h("".split);
        di.exports = Rh(function() {
          return !ms("z").propertyIsEnumerable(0);
        }) ? function(l) {
          return jh(l) == "String" ? qh(l, "") : ms(l);
        } : ms;
      });
      var ys = E((wd, yi) => {
        yi.exports = function(l) {
          return l == null;
        };
      });
      var xs = E((Id, xi) => {
        var Uh = ys(), $h = TypeError;
        xi.exports = function(l) {
          if (Uh(l))
            throw $h("Can't call method on " + l);
          return l;
        };
      });
      var It = E((Nd, gi) => {
        var Hh = mi(), zh = xs();
        gi.exports = function(l) {
          return Hh(zh(l));
        };
      });
      var Ps = E((kd, Pi) => {
        var gs = typeof document == "object" && document.all, Vh = typeof gs > "u" && gs !== void 0;
        Pi.exports = { all: gs, IS_HTMLDDA: Vh };
      });
      var ee = E((Dd, Ti) => {
        var Ai = Ps(), Kh = Ai.all;
        Ti.exports = Ai.IS_HTMLDDA ? function(l) {
          return typeof l == "function" || l === Kh;
        } : function(l) {
          return typeof l == "function";
        };
      });
      var Ie = E((Fd, Ci) => {
        var vi = ee(), Ei = Ps(), Wh = Ei.all;
        Ci.exports = Ei.IS_HTMLDDA ? function(l) {
          return typeof l == "object" ? l !== null : vi(l) || l === Wh;
        } : function(l) {
          return typeof l == "object" ? l !== null : vi(l);
        };
      });
      var Qe = E((Ld, bi) => {
        var As = re(), Gh = ee(), Jh = function(l) {
          return Gh(l) ? l : void 0;
        };
        bi.exports = function(l, h) {
          return arguments.length < 2 ? Jh(As[l]) : As[l] && As[l][h];
        };
      });
      var wi = E((Od, Si) => {
        var Xh = ae();
        Si.exports = Xh({}.isPrototypeOf);
      });
      var Ni = E((Bd, Ii) => {
        var Yh = Qe();
        Ii.exports = Yh("navigator", "userAgent") || "";
      });
      var Mi = E((Md, Bi) => {
        var Oi = re(), Ts = Ni(), ki = Oi.process, Di = Oi.Deno, Fi = ki && ki.versions || Di && Di.version, Li = Fi && Fi.v8, ne, Nt;
        Li && (ne = Li.split("."), Nt = ne[0] > 0 && ne[0] < 4 ? 1 : +(ne[0] + ne[1]));
        !Nt && Ts && (ne = Ts.match(/Edge\/(\d+)/), (!ne || ne[1] >= 74) && (ne = Ts.match(/Chrome\/(\d+)/), ne && (Nt = +ne[1])));
        Bi.exports = Nt;
      });
      var vs = E((_d, Ri) => {
        var _i = Mi(), Qh = ie();
        Ri.exports = !!Object.getOwnPropertySymbols && !Qh(function() {
          var l = Symbol();
          return !String(l) || !(Object(l) instanceof Symbol) || !Symbol.sham && _i && _i < 41;
        });
      });
      var Es = E((Rd, ji) => {
        var Zh = vs();
        ji.exports = Zh && !Symbol.sham && typeof Symbol.iterator == "symbol";
      });
      var Cs = E((jd, qi) => {
        var eu = Qe(), tu = ee(), su = wi(), ru = Es(), iu = Object;
        qi.exports = ru ? function(l) {
          return typeof l == "symbol";
        } : function(l) {
          var h = eu("Symbol");
          return tu(h) && su(h.prototype, iu(l));
        };
      });
      var $i = E((qd, Ui) => {
        var au = String;
        Ui.exports = function(l) {
          try {
            return au(l);
          } catch {
            return "Object";
          }
        };
      });
      var kt = E((Ud, Hi) => {
        var nu = ee(), ou = $i(), lu = TypeError;
        Hi.exports = function(l) {
          if (nu(l))
            return l;
          throw lu(ou(l) + " is not a function");
        };
      });
      var Vi = E(($d, zi) => {
        var hu = kt(), uu = ys();
        zi.exports = function(l, h) {
          var p = l[h];
          return uu(p) ? void 0 : hu(p);
        };
      });
      var Wi = E((Hd, Ki) => {
        var bs = wt(), Ss = ee(), ws = Ie(), cu = TypeError;
        Ki.exports = function(l, h) {
          var p, d;
          if (h === "string" && Ss(p = l.toString) && !ws(d = bs(p, l)) || Ss(p = l.valueOf) && !ws(d = bs(p, l)) || h !== "string" && Ss(p = l.toString) && !ws(d = bs(p, l)))
            return d;
          throw cu("Can't convert object to primitive value");
        };
      });
      var Ji = E((zd, Gi) => {
        Gi.exports = false;
      });
      var Dt = E((Vd, Yi) => {
        var Xi = re(), pu = Object.defineProperty;
        Yi.exports = function(l, h) {
          try {
            pu(Xi, l, { value: h, configurable: true, writable: true });
          } catch {
            Xi[l] = h;
          }
          return h;
        };
      });
      var Ft = E((Kd, Zi) => {
        var fu = re(), du = Dt(), Qi = "__core-js_shared__", mu = fu[Qi] || du(Qi, {});
        Zi.exports = mu;
      });
      var Is = E((Wd, ta) => {
        var yu = Ji(), ea = Ft();
        (ta.exports = function(l, h) {
          return ea[l] || (ea[l] = h !== void 0 ? h : {});
        })("versions", []).push({ version: "3.26.1", mode: yu ? "pure" : "global", copyright: "\xA9 2014-2022 Denis Pushkarev (zloirock.ru)", license: "https://github.com/zloirock/core-js/blob/v3.26.1/LICENSE", source: "https://github.com/zloirock/core-js" });
      });
      var Ns = E((Gd, sa) => {
        var xu = xs(), gu = Object;
        sa.exports = function(l) {
          return gu(xu(l));
        };
      });
      var ve = E((Jd, ra) => {
        var Pu = ae(), Au = Ns(), Tu = Pu({}.hasOwnProperty);
        ra.exports = Object.hasOwn || function(h, p) {
          return Tu(Au(h), p);
        };
      });
      var ks = E((Xd, ia) => {
        var vu = ae(), Eu = 0, Cu = Math.random(), bu = vu(1 .toString);
        ia.exports = function(l) {
          return "Symbol(" + (l === void 0 ? "" : l) + ")_" + bu(++Eu + Cu, 36);
        };
      });
      var Ze = E((Yd, ha) => {
        var Su = re(), wu = Is(), aa = ve(), Iu = ks(), na = vs(), la = Es(), qe = wu("wks"), Ne = Su.Symbol, oa = Ne && Ne.for, Nu = la ? Ne : Ne && Ne.withoutSetter || Iu;
        ha.exports = function(l) {
          if (!aa(qe, l) || !(na || typeof qe[l] == "string")) {
            var h = "Symbol." + l;
            na && aa(Ne, l) ? qe[l] = Ne[l] : la && oa ? qe[l] = oa(h) : qe[l] = Nu(h);
          }
          return qe[l];
        };
      });
      var fa = E((Qd, pa) => {
        var ku = wt(), ua = Ie(), ca = Cs(), Du = Vi(), Fu = Wi(), Lu = Ze(), Ou = TypeError, Bu = Lu("toPrimitive");
        pa.exports = function(l, h) {
          if (!ua(l) || ca(l))
            return l;
          var p = Du(l, Bu), d;
          if (p) {
            if (h === void 0 && (h = "default"), d = ku(p, l, h), !ua(d) || ca(d))
              return d;
            throw Ou("Can't convert object to primitive value");
          }
          return h === void 0 && (h = "number"), Fu(l, h);
        };
      });
      var Ds = E((Zd, da) => {
        var Mu = fa(), _u = Cs();
        da.exports = function(l) {
          var h = Mu(l, "string");
          return _u(h) ? h : h + "";
        };
      });
      var xa = E((em, ya) => {
        var Ru = re(), ma = Ie(), Fs = Ru.document, ju = ma(Fs) && ma(Fs.createElement);
        ya.exports = function(l) {
          return ju ? Fs.createElement(l) : {};
        };
      });
      var Ls = E((tm, ga) => {
        var qu = ye(), Uu = ie(), $u = xa();
        ga.exports = !qu && !Uu(function() {
          return Object.defineProperty($u("div"), "a", { get: function() {
            return 7;
          } }).a != 7;
        });
      });
      var Os = E((Aa) => {
        var Hu = ye(), zu = wt(), Vu = oi(), Ku = fs2(), Wu = It(), Gu = Ds(), Ju = ve(), Xu = Ls(), Pa = Object.getOwnPropertyDescriptor;
        Aa.f = Hu ? Pa : function(h, p) {
          if (h = Wu(h), p = Gu(p), Xu)
            try {
              return Pa(h, p);
            } catch {
            }
          if (Ju(h, p))
            return Ku(!zu(Vu.f, h, p), h[p]);
        };
      });
      var va = E((rm, Ta) => {
        var Yu = ye(), Qu = ie();
        Ta.exports = Yu && Qu(function() {
          return Object.defineProperty(function() {
          }, "prototype", { value: 42, writable: false }).prototype != 42;
        });
      });
      var Lt = E((im, Ea) => {
        var Zu = Ie(), ec = String, tc = TypeError;
        Ea.exports = function(l) {
          if (Zu(l))
            return l;
          throw tc(ec(l) + " is not an object");
        };
      });
      var et = E((ba) => {
        var sc = ye(), rc = Ls(), ic = va(), Ot = Lt(), Ca = Ds(), ac = TypeError, Bs = Object.defineProperty, nc = Object.getOwnPropertyDescriptor, Ms = "enumerable", _s = "configurable", Rs = "writable";
        ba.f = sc ? ic ? function(h, p, d) {
          if (Ot(h), p = Ca(p), Ot(d), typeof h == "function" && p === "prototype" && "value" in d && Rs in d && !d[Rs]) {
            var x = nc(h, p);
            x && x[Rs] && (h[p] = d.value, d = { configurable: _s in d ? d[_s] : x[_s], enumerable: Ms in d ? d[Ms] : x[Ms], writable: false });
          }
          return Bs(h, p, d);
        } : Bs : function(h, p, d) {
          if (Ot(h), p = Ca(p), Ot(d), rc)
            try {
              return Bs(h, p, d);
            } catch {
            }
          if ("get" in d || "set" in d)
            throw ac("Accessors not supported");
          return "value" in d && (h[p] = d.value), h;
        };
      });
      var js = E((nm, Sa) => {
        var oc = ye(), lc = et(), hc = fs2();
        Sa.exports = oc ? function(l, h, p) {
          return lc.f(l, h, hc(1, p));
        } : function(l, h, p) {
          return l[h] = p, l;
        };
      });
      var Na = E((om, Ia) => {
        var qs = ye(), uc = ve(), wa = Function.prototype, cc = qs && Object.getOwnPropertyDescriptor, Us = uc(wa, "name"), pc = Us && function() {
        }.name === "something", fc = Us && (!qs || qs && cc(wa, "name").configurable);
        Ia.exports = { EXISTS: Us, PROPER: pc, CONFIGURABLE: fc };
      });
      var Hs = E((lm, ka) => {
        var dc = ae(), mc = ee(), $s = Ft(), yc = dc(Function.toString);
        mc($s.inspectSource) || ($s.inspectSource = function(l) {
          return yc(l);
        });
        ka.exports = $s.inspectSource;
      });
      var La = E((hm, Fa) => {
        var xc = re(), gc = ee(), Da = xc.WeakMap;
        Fa.exports = gc(Da) && /native code/.test(String(Da));
      });
      var Ma = E((um, Ba) => {
        var Pc = Is(), Ac = ks(), Oa = Pc("keys");
        Ba.exports = function(l) {
          return Oa[l] || (Oa[l] = Ac(l));
        };
      });
      var zs = E((cm, _a) => {
        _a.exports = {};
      });
      var Ua = E((pm, qa) => {
        var Tc = La(), ja = re(), vc = Ie(), Ec = js(), Vs = ve(), Ks = Ft(), Cc = Ma(), bc = zs(), Ra = "Object already initialized", Ws = ja.TypeError, Sc = ja.WeakMap, Bt, tt, Mt, wc = function(l) {
          return Mt(l) ? tt(l) : Bt(l, {});
        }, Ic = function(l) {
          return function(h) {
            var p;
            if (!vc(h) || (p = tt(h)).type !== l)
              throw Ws("Incompatible receiver, " + l + " required");
            return p;
          };
        };
        Tc || Ks.state ? (oe = Ks.state || (Ks.state = new Sc()), oe.get = oe.get, oe.has = oe.has, oe.set = oe.set, Bt = function(l, h) {
          if (oe.has(l))
            throw Ws(Ra);
          return h.facade = l, oe.set(l, h), h;
        }, tt = function(l) {
          return oe.get(l) || {};
        }, Mt = function(l) {
          return oe.has(l);
        }) : (ke = Cc("state"), bc[ke] = true, Bt = function(l, h) {
          if (Vs(l, ke))
            throw Ws(Ra);
          return h.facade = l, Ec(l, ke, h), h;
        }, tt = function(l) {
          return Vs(l, ke) ? l[ke] : {};
        }, Mt = function(l) {
          return Vs(l, ke);
        });
        var oe, ke;
        qa.exports = { set: Bt, get: tt, has: Mt, enforce: wc, getterFor: Ic };
      });
      var Js = E((fm, Ha) => {
        var Nc = ie(), kc = ee(), _t = ve(), Gs = ye(), Dc = Na().CONFIGURABLE, Fc = Hs(), $a = Ua(), Lc = $a.enforce, Oc = $a.get, Rt = Object.defineProperty, Bc = Gs && !Nc(function() {
          return Rt(function() {
          }, "length", { value: 8 }).length !== 8;
        }), Mc = String(String).split("String"), _c = Ha.exports = function(l, h, p) {
          String(h).slice(0, 7) === "Symbol(" && (h = "[" + String(h).replace(/^Symbol\(([^)]*)\)/, "$1") + "]"), p && p.getter && (h = "get " + h), p && p.setter && (h = "set " + h), (!_t(l, "name") || Dc && l.name !== h) && (Gs ? Rt(l, "name", { value: h, configurable: true }) : l.name = h), Bc && p && _t(p, "arity") && l.length !== p.arity && Rt(l, "length", { value: p.arity });
          try {
            p && _t(p, "constructor") && p.constructor ? Gs && Rt(l, "prototype", { writable: false }) : l.prototype && (l.prototype = void 0);
          } catch {
          }
          var d = Lc(l);
          return _t(d, "source") || (d.source = Mc.join(typeof h == "string" ? h : "")), l;
        };
        Function.prototype.toString = _c(function() {
          return kc(this) && Oc(this).source || Fc(this);
        }, "toString");
      });
      var Va = E((dm, za) => {
        var Rc = ee(), jc = et(), qc = Js(), Uc = Dt();
        za.exports = function(l, h, p, d) {
          d || (d = {});
          var x = d.enumerable, P = d.name !== void 0 ? d.name : h;
          if (Rc(p) && qc(p, P, d), d.global)
            x ? l[h] = p : Uc(h, p);
          else {
            try {
              d.unsafe ? l[h] && (x = true) : delete l[h];
            } catch {
            }
            x ? l[h] = p : jc.f(l, h, { value: p, enumerable: false, configurable: !d.nonConfigurable, writable: !d.nonWritable });
          }
          return l;
        };
      });
      var Wa = E((mm, Ka) => {
        var $c = Math.ceil, Hc = Math.floor;
        Ka.exports = Math.trunc || function(h) {
          var p = +h;
          return (p > 0 ? Hc : $c)(p);
        };
      });
      var Xs = E((ym, Ga) => {
        var zc = Wa();
        Ga.exports = function(l) {
          var h = +l;
          return h !== h || h === 0 ? 0 : zc(h);
        };
      });
      var Xa = E((xm, Ja) => {
        var Vc = Xs(), Kc = Math.max, Wc = Math.min;
        Ja.exports = function(l, h) {
          var p = Vc(l);
          return p < 0 ? Kc(p + h, 0) : Wc(p, h);
        };
      });
      var Qa = E((gm, Ya) => {
        var Gc = Xs(), Jc = Math.min;
        Ya.exports = function(l) {
          return l > 0 ? Jc(Gc(l), 9007199254740991) : 0;
        };
      });
      var jt = E((Pm, Za) => {
        var Xc = Qa();
        Za.exports = function(l) {
          return Xc(l.length);
        };
      });
      var sn = E((Am, tn) => {
        var Yc = It(), Qc = Xa(), Zc = jt(), en = function(l) {
          return function(h, p, d) {
            var x = Yc(h), P = Zc(x), m = Qc(d, P), v;
            if (l && p != p) {
              for (; P > m; )
                if (v = x[m++], v != v)
                  return true;
            } else
              for (; P > m; m++)
                if ((l || m in x) && x[m] === p)
                  return l || m || 0;
            return !l && -1;
          };
        };
        tn.exports = { includes: en(true), indexOf: en(false) };
      });
      var nn = E((Tm, an) => {
        var ep = ae(), Ys = ve(), tp = It(), sp = sn().indexOf, rp = zs(), rn = ep([].push);
        an.exports = function(l, h) {
          var p = tp(l), d = 0, x = [], P;
          for (P in p)
            !Ys(rp, P) && Ys(p, P) && rn(x, P);
          for (; h.length > d; )
            Ys(p, P = h[d++]) && (~sp(x, P) || rn(x, P));
          return x;
        };
      });
      var ln = E((vm, on) => {
        on.exports = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
      });
      var un = E((hn) => {
        var ip = nn(), ap = ln(), np = ap.concat("length", "prototype");
        hn.f = Object.getOwnPropertyNames || function(h) {
          return ip(h, np);
        };
      });
      var pn = E((cn) => {
        cn.f = Object.getOwnPropertySymbols;
      });
      var dn = E((bm, fn) => {
        var op = Qe(), lp = ae(), hp = un(), up = pn(), cp = Lt(), pp = lp([].concat);
        fn.exports = op("Reflect", "ownKeys") || function(h) {
          var p = hp.f(cp(h)), d = up.f;
          return d ? pp(p, d(h)) : p;
        };
      });
      var xn = E((Sm, yn) => {
        var mn = ve(), fp = dn(), dp = Os(), mp = et();
        yn.exports = function(l, h, p) {
          for (var d = fp(h), x = mp.f, P = dp.f, m = 0; m < d.length; m++) {
            var v = d[m];
            !mn(l, v) && !(p && mn(p, v)) && x(l, v, P(h, v));
          }
        };
      });
      var Pn = E((wm, gn) => {
        var yp = ie(), xp = ee(), gp = /#|\.prototype\./, st = function(l, h) {
          var p = Ap[Pp(l)];
          return p == vp ? true : p == Tp ? false : xp(h) ? yp(h) : !!h;
        }, Pp = st.normalize = function(l) {
          return String(l).replace(gp, ".").toLowerCase();
        }, Ap = st.data = {}, Tp = st.NATIVE = "N", vp = st.POLYFILL = "P";
        gn.exports = st;
      });
      var Zs = E((Im, An) => {
        var Qs = re(), Ep = Os().f, Cp = js(), bp = Va(), Sp = Dt(), wp = xn(), Ip = Pn();
        An.exports = function(l, h) {
          var p = l.target, d = l.global, x = l.stat, P, m, v, S, k, F;
          if (d ? m = Qs : x ? m = Qs[p] || Sp(p, {}) : m = (Qs[p] || {}).prototype, m)
            for (v in h) {
              if (k = h[v], l.dontCallGetSet ? (F = Ep(m, v), S = F && F.value) : S = m[v], P = Ip(d ? v : p + (x ? "." : "#") + v, l.forced), !P && S !== void 0) {
                if (typeof k == typeof S)
                  continue;
                wp(k, S);
              }
              (l.sham || S && S.sham) && Cp(k, "sham", true), bp(m, v, k, l);
            }
        };
      });
      var Tn = E(() => {
        var Np = Zs(), er = re();
        Np({ global: true, forced: er.globalThis !== er }, { globalThis: er });
      });
      var vn = E(() => {
        Tn();
      });
      var bn = E((Lm, Cn) => {
        var En = Js(), kp = et();
        Cn.exports = function(l, h, p) {
          return p.get && En(p.get, h, { getter: true }), p.set && En(p.set, h, { setter: true }), kp.f(l, h, p);
        };
      });
      var wn = E((Om, Sn) => {
        "use strict";
        var Dp = Lt();
        Sn.exports = function() {
          var l = Dp(this), h = "";
          return l.hasIndices && (h += "d"), l.global && (h += "g"), l.ignoreCase && (h += "i"), l.multiline && (h += "m"), l.dotAll && (h += "s"), l.unicode && (h += "u"), l.unicodeSets && (h += "v"), l.sticky && (h += "y"), h;
        };
      });
      var kn = E(() => {
        var Fp = re(), Lp = ye(), Op = bn(), Bp = wn(), Mp = ie(), In = Fp.RegExp, Nn = In.prototype, _p = Lp && Mp(function() {
          var l = true;
          try {
            In(".", "d");
          } catch {
            l = false;
          }
          var h = {}, p = "", d = l ? "dgimsy" : "gimsy", x = function(S, k) {
            Object.defineProperty(h, S, { get: function() {
              return p += k, true;
            } });
          }, P = { dotAll: "s", global: "g", ignoreCase: "i", multiline: "m", sticky: "y" };
          l && (P.hasIndices = "d");
          for (var m in P)
            x(m, P[m]);
          var v = Object.getOwnPropertyDescriptor(Nn, "flags").get.call(h);
          return v !== d || p !== d;
        });
        _p && Op(Nn, "flags", { configurable: true, get: Bp });
      });
      var tr = E((_m, Dn) => {
        var Rp = Ye();
        Dn.exports = Array.isArray || function(h) {
          return Rp(h) == "Array";
        };
      });
      var Ln = E((Rm, Fn) => {
        var jp = TypeError, qp = 9007199254740991;
        Fn.exports = function(l) {
          if (l > qp)
            throw jp("Maximum allowed index exceeded");
          return l;
        };
      });
      var Bn = E((jm, On) => {
        var Up = Ye(), $p = ae();
        On.exports = function(l) {
          if (Up(l) === "Function")
            return $p(l);
        };
      });
      var Rn = E((qm, _n) => {
        var Mn = Bn(), Hp = kt(), zp = bt(), Vp = Mn(Mn.bind);
        _n.exports = function(l, h) {
          return Hp(l), h === void 0 ? l : zp ? Vp(l, h) : function() {
            return l.apply(h, arguments);
          };
        };
      });
      var Un = E((Um, qn) => {
        "use strict";
        var Kp = tr(), Wp = jt(), Gp = Ln(), Jp = Rn(), jn = function(l, h, p, d, x, P, m, v) {
          for (var S = x, k = 0, F = m ? Jp(m, v) : false, w, L; k < d; )
            k in p && (w = F ? F(p[k], k, h) : p[k], P > 0 && Kp(w) ? (L = Wp(w), S = jn(l, h, w, L, S, P - 1) - 1) : (Gp(S + 1), l[S] = w), S++), k++;
          return S;
        };
        qn.exports = jn;
      });
      var zn = E(($m, Hn) => {
        var Xp = Ze(), Yp = Xp("toStringTag"), $n = {};
        $n[Yp] = "z";
        Hn.exports = String($n) === "[object z]";
      });
      var Kn = E((Hm, Vn) => {
        var Qp = zn(), Zp = ee(), qt = Ye(), ef = Ze(), tf = ef("toStringTag"), sf = Object, rf = qt(function() {
          return arguments;
        }()) == "Arguments", af = function(l, h) {
          try {
            return l[h];
          } catch {
          }
        };
        Vn.exports = Qp ? qt : function(l) {
          var h, p, d;
          return l === void 0 ? "Undefined" : l === null ? "Null" : typeof (p = af(h = sf(l), tf)) == "string" ? p : rf ? qt(h) : (d = qt(h)) == "Object" && Zp(h.callee) ? "Arguments" : d;
        };
      });
      var Qn = E((zm, Yn) => {
        var nf = ae(), of = ie(), Wn = ee(), lf = Kn(), hf = Qe(), uf = Hs(), Gn = function() {
        }, cf = [], Jn = hf("Reflect", "construct"), sr = /^\s*(?:class|function)\b/, pf = nf(sr.exec), ff = !sr.exec(Gn), rt = function(h) {
          if (!Wn(h))
            return false;
          try {
            return Jn(Gn, cf, h), true;
          } catch {
            return false;
          }
        }, Xn = function(h) {
          if (!Wn(h))
            return false;
          switch (lf(h)) {
            case "AsyncFunction":
            case "GeneratorFunction":
            case "AsyncGeneratorFunction":
              return false;
          }
          try {
            return ff || !!pf(sr, uf(h));
          } catch {
            return true;
          }
        };
        Xn.sham = true;
        Yn.exports = !Jn || of(function() {
          var l;
          return rt(rt.call) || !rt(Object) || !rt(function() {
            l = true;
          }) || l;
        }) ? Xn : rt;
      });
      var so = E((Vm, to) => {
        var Zn = tr(), df = Qn(), mf = Ie(), yf = Ze(), xf = yf("species"), eo = Array;
        to.exports = function(l) {
          var h;
          return Zn(l) && (h = l.constructor, df(h) && (h === eo || Zn(h.prototype)) ? h = void 0 : mf(h) && (h = h[xf], h === null && (h = void 0))), h === void 0 ? eo : h;
        };
      });
      var io = E((Km, ro) => {
        var gf = so();
        ro.exports = function(l, h) {
          return new (gf(l))(h === 0 ? 0 : h);
        };
      });
      var ao = E(() => {
        "use strict";
        var Pf = Zs(), Af = Un(), Tf = kt(), vf = Ns(), Ef = jt(), Cf = io();
        Pf({ target: "Array", proto: true }, { flatMap: function(h) {
          var p = vf(this), d = Ef(p), x;
          return Tf(h), x = Cf(p, 0), x.length = Af(x, p, p, d, 0, 1, h, arguments.length > 1 ? arguments[1] : void 0), x;
        } });
      });
      var md = E((ty, Oo) => {
        vn();
        kn();
        ao();
        var nr = Object.defineProperty, bf = Object.getOwnPropertyDescriptor, or = Object.getOwnPropertyNames, Sf = Object.prototype.hasOwnProperty, co = (l, h) => function() {
          return l && (h = (0, l[or(l)[0]])(l = 0)), h;
        }, $ = (l, h) => function() {
          return h || (0, l[or(l)[0]])((h = { exports: {} }).exports, h), h.exports;
        }, wf = (l, h) => {
          for (var p in h)
            nr(l, p, { get: h[p], enumerable: true });
        }, If = (l, h, p, d) => {
          if (h && typeof h == "object" || typeof h == "function")
            for (let x of or(h))
              !Sf.call(l, x) && x !== p && nr(l, x, { get: () => h[x], enumerable: !(d = bf(h, x)) || d.enumerable });
          return l;
        }, Nf = (l) => If(nr({}, "__esModule", { value: true }), l), U = co({ "<define:process>"() {
        } }), kf = $({ "src/utils/try-combinations.js"(l, h) {
          "use strict";
          U();
          function p() {
            let d;
            for (var x = arguments.length, P = new Array(x), m = 0; m < x; m++)
              P[m] = arguments[m];
            for (let [v, S] of P.entries())
              try {
                return { result: S() };
              } catch (k) {
                v === 0 && (d = k);
              }
            return { error: d };
          }
          h.exports = p;
        } }), po = $({ "src/language-js/utils/get-shebang.js"(l, h) {
          "use strict";
          U();
          function p(d) {
            if (!d.startsWith("#!"))
              return "";
            let x = d.indexOf(`
`);
            return x === -1 ? d : d.slice(0, x);
          }
          h.exports = p;
        } }), Df = $({ "src/utils/text/skip-inline-comment.js"(l, h) {
          "use strict";
          U();
          function p(d, x) {
            if (x === false)
              return false;
            if (d.charAt(x) === "/" && d.charAt(x + 1) === "*") {
              for (let P = x + 2; P < d.length; ++P)
                if (d.charAt(P) === "*" && d.charAt(P + 1) === "/")
                  return P + 2;
            }
            return x;
          }
          h.exports = p;
        } }), Ff = $({ "src/utils/text/skip-newline.js"(l, h) {
          "use strict";
          U();
          function p(d, x, P) {
            let m = P && P.backwards;
            if (x === false)
              return false;
            let v = d.charAt(x);
            if (m) {
              if (d.charAt(x - 1) === "\r" && v === `
`)
                return x - 2;
              if (v === `
` || v === "\r" || v === "\u2028" || v === "\u2029")
                return x - 1;
            } else {
              if (v === "\r" && d.charAt(x + 1) === `
`)
                return x + 2;
              if (v === `
` || v === "\r" || v === "\u2028" || v === "\u2029")
                return x + 1;
            }
            return x;
          }
          h.exports = p;
        } }), fo = $({ "src/utils/text/skip.js"(l, h) {
          "use strict";
          U();
          function p(v) {
            return (S, k, F) => {
              let w = F && F.backwards;
              if (k === false)
                return false;
              let { length: L } = S, A = k;
              for (; A >= 0 && A < L; ) {
                let _ = S.charAt(A);
                if (v instanceof RegExp) {
                  if (!v.test(_))
                    return A;
                } else if (!v.includes(_))
                  return A;
                w ? A-- : A++;
              }
              return A === -1 || A === L ? A : false;
            };
          }
          var d = p(/\s/), x = p(" 	"), P = p(",; 	"), m = p(/[^\n\r]/);
          h.exports = { skipWhitespace: d, skipSpaces: x, skipToLineEnd: P, skipEverythingButNewLine: m };
        } }), Lf = $({ "src/utils/text/skip-trailing-comment.js"(l, h) {
          "use strict";
          U();
          var { skipEverythingButNewLine: p } = fo();
          function d(x, P) {
            return P === false ? false : x.charAt(P) === "/" && x.charAt(P + 1) === "/" ? p(x, P) : P;
          }
          h.exports = d;
        } }), Of = $({ "src/utils/text/get-next-non-space-non-comment-character-index-with-start-index.js"(l, h) {
          "use strict";
          U();
          var p = Df(), d = Ff(), x = Lf(), { skipSpaces: P } = fo();
          function m(v, S) {
            let k = null, F = S;
            for (; F !== k; )
              k = F, F = P(v, F), F = p(v, F), F = x(v, F), F = d(v, F);
            return F;
          }
          h.exports = m;
        } }), mo = {};
        wf(mo, { EOL: () => ar, arch: () => Bf, cpus: () => vo, default: () => wo, endianness: () => yo, freemem: () => Ao, getNetworkInterfaces: () => So, hostname: () => xo, loadavg: () => go, networkInterfaces: () => bo, platform: () => Mf, release: () => Co, tmpDir: () => rr, tmpdir: () => ir, totalmem: () => To, type: () => Eo, uptime: () => Po });
        function yo() {
          if (typeof Ut > "u") {
            var l = new ArrayBuffer(2), h = new Uint8Array(l), p = new Uint16Array(l);
            if (h[0] = 1, h[1] = 2, p[0] === 258)
              Ut = "BE";
            else if (p[0] === 513)
              Ut = "LE";
            else
              throw new Error("unable to figure out endianess");
          }
          return Ut;
        }
        function xo() {
          return typeof globalThis.location < "u" ? globalThis.location.hostname : "";
        }
        function go() {
          return [];
        }
        function Po() {
          return 0;
        }
        function Ao() {
          return Number.MAX_VALUE;
        }
        function To() {
          return Number.MAX_VALUE;
        }
        function vo() {
          return [];
        }
        function Eo() {
          return "Browser";
        }
        function Co() {
          return typeof globalThis.navigator < "u" ? globalThis.navigator.appVersion : "";
        }
        function bo() {
        }
        function So() {
        }
        function Bf() {
          return "javascript";
        }
        function Mf() {
          return "browser";
        }
        function rr() {
          return "/tmp";
        }
        var Ut, ir, ar, wo, _f = co({ "node-modules-polyfills:os"() {
          U(), ir = rr, ar = `
`, wo = { EOL: ar, tmpdir: ir, tmpDir: rr, networkInterfaces: bo, getNetworkInterfaces: So, release: Co, type: Eo, cpus: vo, totalmem: To, freemem: Ao, uptime: Po, loadavg: go, hostname: xo, endianness: yo };
        } }), Rf = $({ "node-modules-polyfills-commonjs:os"(l, h) {
          U();
          var p = (_f(), Nf(mo));
          if (p && p.default) {
            h.exports = p.default;
            for (let d in p)
              h.exports[d] = p[d];
          } else
            p && (h.exports = p);
        } }), jf = $({ "node_modules/detect-newline/index.js"(l, h) {
          "use strict";
          U();
          var p = (d) => {
            if (typeof d != "string")
              throw new TypeError("Expected a string");
            let x = d.match(/(?:\r?\n)/g) || [];
            if (x.length === 0)
              return;
            let P = x.filter((v) => v === `\r
`).length, m = x.length - P;
            return P > m ? `\r
` : `
`;
          };
          h.exports = p, h.exports.graceful = (d) => typeof d == "string" && p(d) || `
`;
        } }), qf = $({ "node_modules/jest-docblock/build/index.js"(l) {
          "use strict";
          U(), Object.defineProperty(l, "__esModule", { value: true }), l.extract = A, l.parse = G, l.parseWithComments = N, l.print = O, l.strip = _;
          function h() {
            let R = Rf();
            return h = function() {
              return R;
            }, R;
          }
          function p() {
            let R = d(jf());
            return p = function() {
              return R;
            }, R;
          }
          function d(R) {
            return R && R.__esModule ? R : { default: R };
          }
          var x = /\*\/$/, P = /^\/\*\*?/, m = /^\s*(\/\*\*?(.|\r?\n)*?\*\/)/, v = /(^|\s+)\/\/([^\r\n]*)/g, S = /^(\r?\n)+/, k = /(?:^|\r?\n) *(@[^\r\n]*?) *\r?\n *(?![^@\r\n]*\/\/[^]*)([^@\r\n\s][^@\r\n]+?) *\r?\n/g, F = /(?:^|\r?\n) *@(\S+) *([^\r\n]*)/g, w = /(\r?\n|^) *\* ?/g, L = [];
          function A(R) {
            let z = R.match(m);
            return z ? z[0].trimLeft() : "";
          }
          function _(R) {
            let z = R.match(m);
            return z && z[0] ? R.substring(z[0].length) : R;
          }
          function G(R) {
            return N(R).pragmas;
          }
          function N(R) {
            let z = (0, p().default)(R) || h().EOL;
            R = R.replace(P, "").replace(x, "").replace(w, "$1");
            let Q = "";
            for (; Q !== R; )
              Q = R, R = R.replace(k, `${z}$1 $2${z}`);
            R = R.replace(S, "").trimRight();
            let b = /* @__PURE__ */ Object.create(null), B = R.replace(F, "").replace(S, "").trimRight(), Z;
            for (; Z = F.exec(R); ) {
              let q = Z[2].replace(v, "");
              typeof b[Z[1]] == "string" || Array.isArray(b[Z[1]]) ? b[Z[1]] = L.concat(b[Z[1]], q) : b[Z[1]] = q;
            }
            return { comments: B, pragmas: b };
          }
          function O(R) {
            let { comments: z = "", pragmas: Q = {} } = R, b = (0, p().default)(z) || h().EOL, B = "/**", Z = " *", q = " */", ue = Object.keys(Q), te = ue.map((se) => H(se, Q[se])).reduce((se, He) => se.concat(He), []).map((se) => `${Z} ${se}${b}`).join("");
            if (!z) {
              if (ue.length === 0)
                return "";
              if (ue.length === 1 && !Array.isArray(Q[ue[0]])) {
                let se = Q[ue[0]];
                return `${B} ${H(ue[0], se)[0]}${q}`;
              }
            }
            let it = z.split(b).map((se) => `${Z} ${se}`).join(b) + b;
            return B + b + (z ? it : "") + (z && ue.length ? Z + b : "") + te + q;
          }
          function H(R, z) {
            return L.concat(z).map((Q) => `@${R} ${Q}`.trim());
          }
        } }), Uf = $({ "src/common/end-of-line.js"(l, h) {
          "use strict";
          U();
          function p(m) {
            let v = m.indexOf("\r");
            return v >= 0 ? m.charAt(v + 1) === `
` ? "crlf" : "cr" : "lf";
          }
          function d(m) {
            switch (m) {
              case "cr":
                return "\r";
              case "crlf":
                return `\r
`;
              default:
                return `
`;
            }
          }
          function x(m, v) {
            let S;
            switch (v) {
              case `
`:
                S = /\n/g;
                break;
              case "\r":
                S = /\r/g;
                break;
              case `\r
`:
                S = /\r\n/g;
                break;
              default:
                throw new Error(`Unexpected "eol" ${JSON.stringify(v)}.`);
            }
            let k = m.match(S);
            return k ? k.length : 0;
          }
          function P(m) {
            return m.replace(/\r\n?/g, `
`);
          }
          h.exports = { guessEndOfLine: p, convertEndOfLineToChars: d, countEndOfLineChars: x, normalizeEndOfLine: P };
        } }), $f = $({ "src/language-js/pragma.js"(l, h) {
          "use strict";
          U();
          var { parseWithComments: p, strip: d, extract: x, print: P } = qf(), { normalizeEndOfLine: m } = Uf(), v = po();
          function S(w) {
            let L = v(w);
            L && (w = w.slice(L.length + 1));
            let A = x(w), { pragmas: _, comments: G } = p(A);
            return { shebang: L, text: w, pragmas: _, comments: G };
          }
          function k(w) {
            let L = Object.keys(S(w).pragmas);
            return L.includes("prettier") || L.includes("format");
          }
          function F(w) {
            let { shebang: L, text: A, pragmas: _, comments: G } = S(w), N = d(A), O = P({ pragmas: Object.assign({ format: "" }, _), comments: G.trimStart() });
            return (L ? `${L}
` : "") + m(O) + (N.startsWith(`
`) ? `
` : `

`) + N;
          }
          h.exports = { hasPragma: k, insertPragma: F };
        } }), Io = $({ "src/utils/is-non-empty-array.js"(l, h) {
          "use strict";
          U();
          function p(d) {
            return Array.isArray(d) && d.length > 0;
          }
          h.exports = p;
        } }), No = $({ "src/language-js/loc.js"(l, h) {
          "use strict";
          U();
          var p = Io();
          function d(S) {
            var k, F;
            let w = S.range ? S.range[0] : S.start, L = (k = (F = S.declaration) === null || F === void 0 ? void 0 : F.decorators) !== null && k !== void 0 ? k : S.decorators;
            return p(L) ? Math.min(d(L[0]), w) : w;
          }
          function x(S) {
            return S.range ? S.range[1] : S.end;
          }
          function P(S, k) {
            let F = d(S);
            return Number.isInteger(F) && F === d(k);
          }
          function m(S, k) {
            let F = x(S);
            return Number.isInteger(F) && F === x(k);
          }
          function v(S, k) {
            return P(S, k) && m(S, k);
          }
          h.exports = { locStart: d, locEnd: x, hasSameLocStart: P, hasSameLoc: v };
        } }), ko = $({ "src/language-js/parse/utils/create-parser.js"(l, h) {
          "use strict";
          U();
          var { hasPragma: p } = $f(), { locStart: d, locEnd: x } = No();
          function P(m) {
            return m = typeof m == "function" ? { parse: m } : m, Object.assign({ astFormat: "estree", hasPragma: p, locStart: d, locEnd: x }, m);
          }
          h.exports = P;
        } }), lr = $({ "src/common/parser-create-error.js"(l, h) {
          "use strict";
          U();
          function p(d, x) {
            let P = new SyntaxError(d + " (" + x.start.line + ":" + x.start.column + ")");
            return P.loc = x, P;
          }
          h.exports = p;
        } }), Do = $({ "src/language-js/parse/utils/create-babel-parse-error.js"(l, h) {
          "use strict";
          U();
          var p = lr();
          function d(x) {
            let { message: P, loc: m } = x;
            return p(P.replace(/ \(.*\)/, ""), { start: { line: m ? m.line : 0, column: m ? m.column + 1 : 0 } });
          }
          h.exports = d;
        } }), Hf = $({ "src/language-js/utils/is-ts-keyword-type.js"(l, h) {
          "use strict";
          U();
          function p(d) {
            let { type: x } = d;
            return x.startsWith("TS") && x.endsWith("Keyword");
          }
          h.exports = p;
        } }), zf = $({ "src/language-js/utils/is-block-comment.js"(l, h) {
          "use strict";
          U();
          var p = /* @__PURE__ */ new Set(["Block", "CommentBlock", "MultiLine"]), d = (x) => p.has(x == null ? void 0 : x.type);
          h.exports = d;
        } }), Vf = $({ "src/language-js/utils/is-type-cast-comment.js"(l, h) {
          "use strict";
          U();
          var p = zf();
          function d(x) {
            return p(x) && x.value[0] === "*" && /@(?:type|satisfies)\b/.test(x.value);
          }
          h.exports = d;
        } }), Kf = $({ "src/utils/get-last.js"(l, h) {
          "use strict";
          U();
          var p = (d) => d[d.length - 1];
          h.exports = p;
        } }), Wf = $({ "src/language-js/parse/postprocess/visit-node.js"(l, h) {
          "use strict";
          U();
          function p(d, x) {
            if (Array.isArray(d)) {
              for (let P = 0; P < d.length; P++)
                d[P] = p(d[P], x);
              return d;
            }
            if (d && typeof d == "object" && typeof d.type == "string") {
              let P = Object.keys(d);
              for (let m = 0; m < P.length; m++)
                d[P[m]] = p(d[P[m]], x);
              return x(d) || d;
            }
            return d;
          }
          h.exports = p;
        } }), Gf = $({ "src/language-js/parse/postprocess/throw-syntax-error.js"(l, h) {
          "use strict";
          U();
          var p = lr();
          function d(x, P) {
            let { start: m, end: v } = x.loc;
            throw p(P, { start: { line: m.line, column: m.column + 1 }, end: { line: v.line, column: v.column + 1 } });
          }
          h.exports = d;
        } }), Jf = $({ "src/language-js/parse/postprocess/index.js"(l, h) {
          "use strict";
          U();
          var { locStart: p, locEnd: d } = No(), x = Hf(), P = Vf(), m = Kf(), v = Wf(), S = Gf();
          function k(A, _) {
            if (_.parser !== "typescript" && _.parser !== "flow" && _.parser !== "acorn" && _.parser !== "espree" && _.parser !== "meriyah") {
              let N = /* @__PURE__ */ new Set();
              A = v(A, (O) => {
                O.leadingComments && O.leadingComments.some(P) && N.add(p(O));
              }), A = v(A, (O) => {
                if (O.type === "ParenthesizedExpression") {
                  let { expression: H } = O;
                  if (H.type === "TypeCastExpression")
                    return H.range = O.range, H;
                  let R = p(O);
                  if (!N.has(R))
                    return H.extra = Object.assign(Object.assign({}, H.extra), {}, { parenthesized: true }), H;
                }
              });
            }
            return A = v(A, (N) => {
              switch (N.type) {
                case "ChainExpression":
                  return F(N.expression);
                case "LogicalExpression": {
                  if (w(N))
                    return L(N);
                  break;
                }
                case "VariableDeclaration": {
                  let O = m(N.declarations);
                  O && O.init && G(N, O);
                  break;
                }
                case "TSParenthesizedType":
                  return x(N.typeAnnotation) || N.typeAnnotation.type === "TSThisType" || (N.typeAnnotation.range = [p(N), d(N)]), N.typeAnnotation;
                case "TSTypeParameter":
                  if (typeof N.name == "string") {
                    let O = p(N);
                    N.name = { type: "Identifier", name: N.name, range: [O, O + N.name.length] };
                  }
                  break;
                case "ObjectExpression":
                  if (_.parser === "typescript") {
                    let O = N.properties.find((H) => H.type === "Property" && H.value.type === "TSEmptyBodyFunctionExpression");
                    O && S(O.value, "Unexpected token.");
                  }
                  break;
                case "SequenceExpression": {
                  let O = m(N.expressions);
                  N.range = [p(N), Math.min(d(O), d(N))];
                  break;
                }
                case "TopicReference":
                  _.__isUsingHackPipeline = true;
                  break;
                case "ExportAllDeclaration": {
                  let { exported: O } = N;
                  if (_.parser === "meriyah" && O && O.type === "Identifier") {
                    let H = _.originalText.slice(p(O), d(O));
                    (H.startsWith('"') || H.startsWith("'")) && (N.exported = Object.assign(Object.assign({}, N.exported), {}, { type: "Literal", value: N.exported.name, raw: H }));
                  }
                  break;
                }
                case "PropertyDefinition":
                  if (_.parser === "meriyah" && N.static && !N.computed && !N.key) {
                    let O = "static", H = p(N);
                    Object.assign(N, { static: false, key: { type: "Identifier", name: O, range: [H, H + O.length] } });
                  }
                  break;
              }
            }), A;
            function G(N, O) {
              _.originalText[d(O)] !== ";" && (N.range = [p(N), d(O)]);
            }
          }
          function F(A) {
            switch (A.type) {
              case "CallExpression":
                A.type = "OptionalCallExpression", A.callee = F(A.callee);
                break;
              case "MemberExpression":
                A.type = "OptionalMemberExpression", A.object = F(A.object);
                break;
              case "TSNonNullExpression":
                A.expression = F(A.expression);
                break;
            }
            return A;
          }
          function w(A) {
            return A.type === "LogicalExpression" && A.right.type === "LogicalExpression" && A.operator === A.right.operator;
          }
          function L(A) {
            return w(A) ? L({ type: "LogicalExpression", operator: A.operator, left: L({ type: "LogicalExpression", operator: A.operator, left: A.left, right: A.right.left, range: [p(A.left), d(A.right.left)] }), right: A.right.right, range: [p(A), d(A)] }) : A;
          }
          h.exports = k;
        } }), Fo = $({ "node_modules/@babel/parser/lib/index.js"(l) {
          "use strict";
          U(), Object.defineProperty(l, "__esModule", { value: true });
          var h = { sourceType: "script", sourceFilename: void 0, startColumn: 0, startLine: 1, allowAwaitOutsideFunction: false, allowReturnOutsideFunction: false, allowNewTargetOutsideFunction: false, allowImportExportEverywhere: false, allowSuperOutsideMethod: false, allowUndeclaredExports: false, plugins: [], strictMode: null, ranges: false, tokens: false, createParenthesizedExpressions: false, errorRecovery: false, attachComment: true, annexB: true };
          function p(t) {
            if (t && t.annexB != null && t.annexB !== false)
              throw new Error("The `annexB` option can only be set to `false`.");
            let r = {};
            for (let e of Object.keys(h))
              r[e] = t && t[e] != null ? t[e] : h[e];
            return r;
          }
          var d = class {
            constructor(t, r) {
              this.token = void 0, this.preserveSpace = void 0, this.token = t, this.preserveSpace = !!r;
            }
          }, x = { brace: new d("{"), j_oTag: new d("<tag"), j_cTag: new d("</tag"), j_expr: new d("<tag>...</tag>", true) };
          x.template = new d("`", true);
          var P = true, m = true, v = true, S = true, k = true, F = true, w = class {
            constructor(t) {
              let r = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
              this.label = void 0, this.keyword = void 0, this.beforeExpr = void 0, this.startsExpr = void 0, this.rightAssociative = void 0, this.isLoop = void 0, this.isAssign = void 0, this.prefix = void 0, this.postfix = void 0, this.binop = void 0, this.label = t, this.keyword = r.keyword, this.beforeExpr = !!r.beforeExpr, this.startsExpr = !!r.startsExpr, this.rightAssociative = !!r.rightAssociative, this.isLoop = !!r.isLoop, this.isAssign = !!r.isAssign, this.prefix = !!r.prefix, this.postfix = !!r.postfix, this.binop = r.binop != null ? r.binop : null, this.updateContext = null;
            }
          }, L = /* @__PURE__ */ new Map();
          function A(t) {
            let r = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
            r.keyword = t;
            let e = b(t, r);
            return L.set(t, e), e;
          }
          function _(t, r) {
            return b(t, { beforeExpr: P, binop: r });
          }
          var G = -1, N = [], O = [], H = [], R = [], z = [], Q = [];
          function b(t) {
            let r = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
            var e, s, i, a;
            return ++G, O.push(t), H.push((e = r.binop) != null ? e : -1), R.push((s = r.beforeExpr) != null ? s : false), z.push((i = r.startsExpr) != null ? i : false), Q.push((a = r.prefix) != null ? a : false), N.push(new w(t, r)), G;
          }
          function B(t) {
            let r = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
            var e, s, i, a;
            return ++G, L.set(t, G), O.push(t), H.push((e = r.binop) != null ? e : -1), R.push((s = r.beforeExpr) != null ? s : false), z.push((i = r.startsExpr) != null ? i : false), Q.push((a = r.prefix) != null ? a : false), N.push(new w("name", r)), G;
          }
          var Z = { bracketL: b("[", { beforeExpr: P, startsExpr: m }), bracketHashL: b("#[", { beforeExpr: P, startsExpr: m }), bracketBarL: b("[|", { beforeExpr: P, startsExpr: m }), bracketR: b("]"), bracketBarR: b("|]"), braceL: b("{", { beforeExpr: P, startsExpr: m }), braceBarL: b("{|", { beforeExpr: P, startsExpr: m }), braceHashL: b("#{", { beforeExpr: P, startsExpr: m }), braceR: b("}"), braceBarR: b("|}"), parenL: b("(", { beforeExpr: P, startsExpr: m }), parenR: b(")"), comma: b(",", { beforeExpr: P }), semi: b(";", { beforeExpr: P }), colon: b(":", { beforeExpr: P }), doubleColon: b("::", { beforeExpr: P }), dot: b("."), question: b("?", { beforeExpr: P }), questionDot: b("?."), arrow: b("=>", { beforeExpr: P }), template: b("template"), ellipsis: b("...", { beforeExpr: P }), backQuote: b("`", { startsExpr: m }), dollarBraceL: b("${", { beforeExpr: P, startsExpr: m }), templateTail: b("...`", { startsExpr: m }), templateNonTail: b("...${", { beforeExpr: P, startsExpr: m }), at: b("@"), hash: b("#", { startsExpr: m }), interpreterDirective: b("#!..."), eq: b("=", { beforeExpr: P, isAssign: S }), assign: b("_=", { beforeExpr: P, isAssign: S }), slashAssign: b("_=", { beforeExpr: P, isAssign: S }), xorAssign: b("_=", { beforeExpr: P, isAssign: S }), moduloAssign: b("_=", { beforeExpr: P, isAssign: S }), incDec: b("++/--", { prefix: k, postfix: F, startsExpr: m }), bang: b("!", { beforeExpr: P, prefix: k, startsExpr: m }), tilde: b("~", { beforeExpr: P, prefix: k, startsExpr: m }), doubleCaret: b("^^", { startsExpr: m }), doubleAt: b("@@", { startsExpr: m }), pipeline: _("|>", 0), nullishCoalescing: _("??", 1), logicalOR: _("||", 1), logicalAND: _("&&", 2), bitwiseOR: _("|", 3), bitwiseXOR: _("^", 4), bitwiseAND: _("&", 5), equality: _("==/!=/===/!==", 6), lt: _("</>/<=/>=", 7), gt: _("</>/<=/>=", 7), relational: _("</>/<=/>=", 7), bitShift: _("<</>>/>>>", 8), bitShiftL: _("<</>>/>>>", 8), bitShiftR: _("<</>>/>>>", 8), plusMin: b("+/-", { beforeExpr: P, binop: 9, prefix: k, startsExpr: m }), modulo: b("%", { binop: 10, startsExpr: m }), star: b("*", { binop: 10 }), slash: _("/", 10), exponent: b("**", { beforeExpr: P, binop: 11, rightAssociative: true }), _in: A("in", { beforeExpr: P, binop: 7 }), _instanceof: A("instanceof", { beforeExpr: P, binop: 7 }), _break: A("break"), _case: A("case", { beforeExpr: P }), _catch: A("catch"), _continue: A("continue"), _debugger: A("debugger"), _default: A("default", { beforeExpr: P }), _else: A("else", { beforeExpr: P }), _finally: A("finally"), _function: A("function", { startsExpr: m }), _if: A("if"), _return: A("return", { beforeExpr: P }), _switch: A("switch"), _throw: A("throw", { beforeExpr: P, prefix: k, startsExpr: m }), _try: A("try"), _var: A("var"), _const: A("const"), _with: A("with"), _new: A("new", { beforeExpr: P, startsExpr: m }), _this: A("this", { startsExpr: m }), _super: A("super", { startsExpr: m }), _class: A("class", { startsExpr: m }), _extends: A("extends", { beforeExpr: P }), _export: A("export"), _import: A("import", { startsExpr: m }), _null: A("null", { startsExpr: m }), _true: A("true", { startsExpr: m }), _false: A("false", { startsExpr: m }), _typeof: A("typeof", { beforeExpr: P, prefix: k, startsExpr: m }), _void: A("void", { beforeExpr: P, prefix: k, startsExpr: m }), _delete: A("delete", { beforeExpr: P, prefix: k, startsExpr: m }), _do: A("do", { isLoop: v, beforeExpr: P }), _for: A("for", { isLoop: v }), _while: A("while", { isLoop: v }), _as: B("as", { startsExpr: m }), _assert: B("assert", { startsExpr: m }), _async: B("async", { startsExpr: m }), _await: B("await", { startsExpr: m }), _from: B("from", { startsExpr: m }), _get: B("get", { startsExpr: m }), _let: B("let", { startsExpr: m }), _meta: B("meta", { startsExpr: m }), _of: B("of", { startsExpr: m }), _sent: B("sent", { startsExpr: m }), _set: B("set", { startsExpr: m }), _static: B("static", { startsExpr: m }), _using: B("using", { startsExpr: m }), _yield: B("yield", { startsExpr: m }), _asserts: B("asserts", { startsExpr: m }), _checks: B("checks", { startsExpr: m }), _exports: B("exports", { startsExpr: m }), _global: B("global", { startsExpr: m }), _implements: B("implements", { startsExpr: m }), _intrinsic: B("intrinsic", { startsExpr: m }), _infer: B("infer", { startsExpr: m }), _is: B("is", { startsExpr: m }), _mixins: B("mixins", { startsExpr: m }), _proto: B("proto", { startsExpr: m }), _require: B("require", { startsExpr: m }), _satisfies: B("satisfies", { startsExpr: m }), _keyof: B("keyof", { startsExpr: m }), _readonly: B("readonly", { startsExpr: m }), _unique: B("unique", { startsExpr: m }), _abstract: B("abstract", { startsExpr: m }), _declare: B("declare", { startsExpr: m }), _enum: B("enum", { startsExpr: m }), _module: B("module", { startsExpr: m }), _namespace: B("namespace", { startsExpr: m }), _interface: B("interface", { startsExpr: m }), _type: B("type", { startsExpr: m }), _opaque: B("opaque", { startsExpr: m }), name: b("name", { startsExpr: m }), string: b("string", { startsExpr: m }), num: b("num", { startsExpr: m }), bigint: b("bigint", { startsExpr: m }), decimal: b("decimal", { startsExpr: m }), regexp: b("regexp", { startsExpr: m }), privateName: b("#name", { startsExpr: m }), eof: b("eof"), jsxName: b("jsxName"), jsxText: b("jsxText", { beforeExpr: true }), jsxTagStart: b("jsxTagStart", { startsExpr: true }), jsxTagEnd: b("jsxTagEnd"), placeholder: b("%%", { startsExpr: true }) };
          function q(t) {
            return t >= 93 && t <= 130;
          }
          function ue(t) {
            return t <= 92;
          }
          function te(t) {
            return t >= 58 && t <= 130;
          }
          function it(t) {
            return t >= 58 && t <= 134;
          }
          function se(t) {
            return R[t];
          }
          function He(t) {
            return z[t];
          }
          function Bo(t) {
            return t >= 29 && t <= 33;
          }
          function hr(t) {
            return t >= 127 && t <= 129;
          }
          function Mo(t) {
            return t >= 90 && t <= 92;
          }
          function $t(t) {
            return t >= 58 && t <= 92;
          }
          function _o(t) {
            return t >= 39 && t <= 59;
          }
          function Ro(t) {
            return t === 34;
          }
          function jo(t) {
            return Q[t];
          }
          function qo(t) {
            return t >= 119 && t <= 121;
          }
          function Uo(t) {
            return t >= 122 && t <= 128;
          }
          function xe(t) {
            return O[t];
          }
          function at(t) {
            return H[t];
          }
          function $o(t) {
            return t === 57;
          }
          function nt(t) {
            return t >= 24 && t <= 25;
          }
          function ce(t) {
            return N[t];
          }
          N[8].updateContext = (t) => {
            t.pop();
          }, N[5].updateContext = N[7].updateContext = N[23].updateContext = (t) => {
            t.push(x.brace);
          }, N[22].updateContext = (t) => {
            t[t.length - 1] === x.template ? t.pop() : t.push(x.template);
          }, N[140].updateContext = (t) => {
            t.push(x.j_expr, x.j_oTag);
          };
          function ot(t, r) {
            if (t == null)
              return {};
            var e = {}, s = Object.keys(t), i, a;
            for (a = 0; a < s.length; a++)
              i = s[a], !(r.indexOf(i) >= 0) && (e[i] = t[i]);
            return e;
          }
          var ge = class {
            constructor(t, r, e) {
              this.line = void 0, this.column = void 0, this.index = void 0, this.line = t, this.column = r, this.index = e;
            }
          }, lt = class {
            constructor(t, r) {
              this.start = void 0, this.end = void 0, this.filename = void 0, this.identifierName = void 0, this.start = t, this.end = r;
            }
          };
          function Y(t, r) {
            let { line: e, column: s, index: i } = t;
            return new ge(e, s + r, i + r);
          }
          var Ht = { SyntaxError: "BABEL_PARSER_SYNTAX_ERROR", SourceTypeModuleError: "BABEL_PARSER_SOURCETYPE_MODULE_REQUIRED" }, Ho = function(t) {
            let r = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : t.length - 1;
            return { get() {
              return t.reduce((e, s) => e[s], this);
            }, set(e) {
              t.reduce((s, i, a) => a === r ? s[i] = e : s[i], this);
            } };
          }, zo = (t, r, e) => Object.keys(e).map((s) => [s, e[s]]).filter((s) => {
            let [, i] = s;
            return !!i;
          }).map((s) => {
            let [i, a] = s;
            return [i, typeof a == "function" ? { value: a, enumerable: false } : typeof a.reflect == "string" ? Object.assign({}, a, Ho(a.reflect.split("."))) : a];
          }).reduce((s, i) => {
            let [a, n2] = i;
            return Object.defineProperty(s, a, Object.assign({ configurable: true }, n2));
          }, Object.assign(new t(), r)), Vo = { ImportMetaOutsideModule: { message: `import.meta may appear only with 'sourceType: "module"'`, code: Ht.SourceTypeModuleError }, ImportOutsideModule: { message: `'import' and 'export' may appear only with 'sourceType: "module"'`, code: Ht.SourceTypeModuleError } }, ur = { ArrayPattern: "array destructuring pattern", AssignmentExpression: "assignment expression", AssignmentPattern: "assignment expression", ArrowFunctionExpression: "arrow function expression", ConditionalExpression: "conditional expression", CatchClause: "catch clause", ForOfStatement: "for-of statement", ForInStatement: "for-in statement", ForStatement: "for-loop", FormalParameters: "function parameter list", Identifier: "identifier", ImportSpecifier: "import specifier", ImportDefaultSpecifier: "import default specifier", ImportNamespaceSpecifier: "import namespace specifier", ObjectPattern: "object destructuring pattern", ParenthesizedExpression: "parenthesized expression", RestElement: "rest element", UpdateExpression: { true: "prefix operation", false: "postfix operation" }, VariableDeclarator: "variable declaration", YieldExpression: "yield expression" }, zt = (t) => {
            let { type: r, prefix: e } = t;
            return r === "UpdateExpression" ? ur.UpdateExpression[String(e)] : ur[r];
          }, Ko = { AccessorIsGenerator: (t) => {
            let { kind: r } = t;
            return `A ${r}ter cannot be a generator.`;
          }, ArgumentsInClass: "'arguments' is only allowed in functions and class methods.", AsyncFunctionInSingleStatementContext: "Async functions can only be declared at the top level or inside a block.", AwaitBindingIdentifier: "Can not use 'await' as identifier inside an async function.", AwaitBindingIdentifierInStaticBlock: "Can not use 'await' as identifier inside a static block.", AwaitExpressionFormalParameter: "'await' is not allowed in async function parameters.", AwaitInUsingBinding: "'await' is not allowed to be used as a name in 'using' declarations.", AwaitNotInAsyncContext: "'await' is only allowed within async functions and at the top levels of modules.", AwaitNotInAsyncFunction: "'await' is only allowed within async functions.", BadGetterArity: "A 'get' accessor must not have any formal parameters.", BadSetterArity: "A 'set' accessor must have exactly one formal parameter.", BadSetterRestParameter: "A 'set' accessor function argument must not be a rest parameter.", ConstructorClassField: "Classes may not have a field named 'constructor'.", ConstructorClassPrivateField: "Classes may not have a private field named '#constructor'.", ConstructorIsAccessor: "Class constructor may not be an accessor.", ConstructorIsAsync: "Constructor can't be an async function.", ConstructorIsGenerator: "Constructor can't be a generator.", DeclarationMissingInitializer: (t) => {
            let { kind: r } = t;
            return `Missing initializer in ${r} declaration.`;
          }, DecoratorArgumentsOutsideParentheses: "Decorator arguments must be moved inside parentheses: use '@(decorator(args))' instead of '@(decorator)(args)'.", DecoratorBeforeExport: "Decorators must be placed *before* the 'export' keyword. Remove the 'decoratorsBeforeExport: true' option to use the 'export @decorator class {}' syntax.", DecoratorsBeforeAfterExport: "Decorators can be placed *either* before or after the 'export' keyword, but not in both locations at the same time.", DecoratorConstructor: "Decorators can't be used with a constructor. Did you mean '@dec class { ... }'?", DecoratorExportClass: "Decorators must be placed *after* the 'export' keyword. Remove the 'decoratorsBeforeExport: false' option to use the '@decorator export class {}' syntax.", DecoratorSemicolon: "Decorators must not be followed by a semicolon.", DecoratorStaticBlock: "Decorators can't be used with a static block.", DeletePrivateField: "Deleting a private field is not allowed.", DestructureNamedImport: "ES2015 named imports do not destructure. Use another statement for destructuring after the import.", DuplicateConstructor: "Duplicate constructor in the same class.", DuplicateDefaultExport: "Only one default export allowed per module.", DuplicateExport: (t) => {
            let { exportName: r } = t;
            return `\`${r}\` has already been exported. Exported identifiers must be unique.`;
          }, DuplicateProto: "Redefinition of __proto__ property.", DuplicateRegExpFlags: "Duplicate regular expression flag.", ElementAfterRest: "Rest element must be last element.", EscapedCharNotAnIdentifier: "Invalid Unicode escape.", ExportBindingIsString: (t) => {
            let { localName: r, exportName: e } = t;
            return `A string literal cannot be used as an exported binding without \`from\`.
- Did you mean \`export { '${r}' as '${e}' } from 'some-module'\`?`;
          }, ExportDefaultFromAsIdentifier: "'from' is not allowed as an identifier after 'export default'.", ForInOfLoopInitializer: (t) => {
            let { type: r } = t;
            return `'${r === "ForInStatement" ? "for-in" : "for-of"}' loop variable declaration may not have an initializer.`;
          }, ForInUsing: "For-in loop may not start with 'using' declaration.", ForOfAsync: "The left-hand side of a for-of loop may not be 'async'.", ForOfLet: "The left-hand side of a for-of loop may not start with 'let'.", GeneratorInSingleStatementContext: "Generators can only be declared at the top level or inside a block.", IllegalBreakContinue: (t) => {
            let { type: r } = t;
            return `Unsyntactic ${r === "BreakStatement" ? "break" : "continue"}.`;
          }, IllegalLanguageModeDirective: "Illegal 'use strict' directive in function with non-simple parameter list.", IllegalReturn: "'return' outside of function.", ImportBindingIsString: (t) => {
            let { importName: r } = t;
            return `A string literal cannot be used as an imported binding.
- Did you mean \`import { "${r}" as foo }\`?`;
          }, ImportCallArgumentTrailingComma: "Trailing comma is disallowed inside import(...) arguments.", ImportCallArity: (t) => {
            let { maxArgumentCount: r } = t;
            return `\`import()\` requires exactly ${r === 1 ? "one argument" : "one or two arguments"}.`;
          }, ImportCallNotNewExpression: "Cannot use new with import(...).", ImportCallSpreadArgument: "`...` is not allowed in `import()`.", ImportJSONBindingNotDefault: "A JSON module can only be imported with `default`.", ImportReflectionHasAssertion: "`import module x` cannot have assertions.", ImportReflectionNotBinding: 'Only `import module x from "./module"` is valid.', IncompatibleRegExpUVFlags: "The 'u' and 'v' regular expression flags cannot be enabled at the same time.", InvalidBigIntLiteral: "Invalid BigIntLiteral.", InvalidCodePoint: "Code point out of bounds.", InvalidCoverInitializedName: "Invalid shorthand property initializer.", InvalidDecimal: "Invalid decimal.", InvalidDigit: (t) => {
            let { radix: r } = t;
            return `Expected number in radix ${r}.`;
          }, InvalidEscapeSequence: "Bad character escape sequence.", InvalidEscapeSequenceTemplate: "Invalid escape sequence in template.", InvalidEscapedReservedWord: (t) => {
            let { reservedWord: r } = t;
            return `Escape sequence in keyword ${r}.`;
          }, InvalidIdentifier: (t) => {
            let { identifierName: r } = t;
            return `Invalid identifier ${r}.`;
          }, InvalidLhs: (t) => {
            let { ancestor: r } = t;
            return `Invalid left-hand side in ${zt(r)}.`;
          }, InvalidLhsBinding: (t) => {
            let { ancestor: r } = t;
            return `Binding invalid left-hand side in ${zt(r)}.`;
          }, InvalidNumber: "Invalid number.", InvalidOrMissingExponent: "Floating-point numbers require a valid exponent after the 'e'.", InvalidOrUnexpectedToken: (t) => {
            let { unexpected: r } = t;
            return `Unexpected character '${r}'.`;
          }, InvalidParenthesizedAssignment: "Invalid parenthesized assignment pattern.", InvalidPrivateFieldResolution: (t) => {
            let { identifierName: r } = t;
            return `Private name #${r} is not defined.`;
          }, InvalidPropertyBindingPattern: "Binding member expression.", InvalidRecordProperty: "Only properties and spread elements are allowed in record definitions.", InvalidRestAssignmentPattern: "Invalid rest operator's argument.", LabelRedeclaration: (t) => {
            let { labelName: r } = t;
            return `Label '${r}' is already declared.`;
          }, LetInLexicalBinding: "'let' is not allowed to be used as a name in 'let' or 'const' declarations.", LineTerminatorBeforeArrow: "No line break is allowed before '=>'.", MalformedRegExpFlags: "Invalid regular expression flag.", MissingClassName: "A class name is required.", MissingEqInAssignment: "Only '=' operator can be used for specifying default value.", MissingSemicolon: "Missing semicolon.", MissingPlugin: (t) => {
            let { missingPlugin: r } = t;
            return `This experimental syntax requires enabling the parser plugin: ${r.map((e) => JSON.stringify(e)).join(", ")}.`;
          }, MissingOneOfPlugins: (t) => {
            let { missingPlugin: r } = t;
            return `This experimental syntax requires enabling one of the following parser plugin(s): ${r.map((e) => JSON.stringify(e)).join(", ")}.`;
          }, MissingUnicodeEscape: "Expecting Unicode escape sequence \\uXXXX.", MixingCoalesceWithLogical: "Nullish coalescing operator(??) requires parens when mixing with logical operators.", ModuleAttributeDifferentFromType: "The only accepted module attribute is `type`.", ModuleAttributeInvalidValue: "Only string literals are allowed as module attribute values.", ModuleAttributesWithDuplicateKeys: (t) => {
            let { key: r } = t;
            return `Duplicate key "${r}" is not allowed in module attributes.`;
          }, ModuleExportNameHasLoneSurrogate: (t) => {
            let { surrogateCharCode: r } = t;
            return `An export name cannot include a lone surrogate, found '\\u${r.toString(16)}'.`;
          }, ModuleExportUndefined: (t) => {
            let { localName: r } = t;
            return `Export '${r}' is not defined.`;
          }, MultipleDefaultsInSwitch: "Multiple default clauses.", NewlineAfterThrow: "Illegal newline after throw.", NoCatchOrFinally: "Missing catch or finally clause.", NumberIdentifier: "Identifier directly after number.", NumericSeparatorInEscapeSequence: "Numeric separators are not allowed inside unicode escape sequences or hex escape sequences.", ObsoleteAwaitStar: "'await*' has been removed from the async functions proposal. Use Promise.all() instead.", OptionalChainingNoNew: "Constructors in/after an Optional Chain are not allowed.", OptionalChainingNoTemplate: "Tagged Template Literals are not allowed in optionalChain.", OverrideOnConstructor: "'override' modifier cannot appear on a constructor declaration.", ParamDupe: "Argument name clash.", PatternHasAccessor: "Object pattern can't contain getter or setter.", PatternHasMethod: "Object pattern can't contain methods.", PrivateInExpectedIn: (t) => {
            let { identifierName: r } = t;
            return `Private names are only allowed in property accesses (\`obj.#${r}\`) or in \`in\` expressions (\`#${r} in obj\`).`;
          }, PrivateNameRedeclaration: (t) => {
            let { identifierName: r } = t;
            return `Duplicate private name #${r}.`;
          }, RecordExpressionBarIncorrectEndSyntaxType: "Record expressions ending with '|}' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'bar'.", RecordExpressionBarIncorrectStartSyntaxType: "Record expressions starting with '{|' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'bar'.", RecordExpressionHashIncorrectStartSyntaxType: "Record expressions starting with '#{' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'hash'.", RecordNoProto: "'__proto__' is not allowed in Record expressions.", RestTrailingComma: "Unexpected trailing comma after rest element.", SloppyFunction: "In non-strict mode code, functions can only be declared at top level or inside a block.", SloppyFunctionAnnexB: "In non-strict mode code, functions can only be declared at top level, inside a block, or as the body of an if statement.", StaticPrototype: "Classes may not have static property named prototype.", SuperNotAllowed: "`super()` is only valid inside a class constructor of a subclass. Maybe a typo in the method name ('constructor') or not extending another class?", SuperPrivateField: "Private fields can't be accessed on super.", TrailingDecorator: "Decorators must be attached to a class element.", TupleExpressionBarIncorrectEndSyntaxType: "Tuple expressions ending with '|]' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'bar'.", TupleExpressionBarIncorrectStartSyntaxType: "Tuple expressions starting with '[|' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'bar'.", TupleExpressionHashIncorrectStartSyntaxType: "Tuple expressions starting with '#[' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'hash'.", UnexpectedArgumentPlaceholder: "Unexpected argument placeholder.", UnexpectedAwaitAfterPipelineBody: 'Unexpected "await" after pipeline body; await must have parentheses in minimal proposal.', UnexpectedDigitAfterHash: "Unexpected digit after hash token.", UnexpectedImportExport: "'import' and 'export' may only appear at the top level.", UnexpectedKeyword: (t) => {
            let { keyword: r } = t;
            return `Unexpected keyword '${r}'.`;
          }, UnexpectedLeadingDecorator: "Leading decorators must be attached to a class declaration.", UnexpectedLexicalDeclaration: "Lexical declaration cannot appear in a single-statement context.", UnexpectedNewTarget: "`new.target` can only be used in functions or class properties.", UnexpectedNumericSeparator: "A numeric separator is only allowed between two digits.", UnexpectedPrivateField: "Unexpected private name.", UnexpectedReservedWord: (t) => {
            let { reservedWord: r } = t;
            return `Unexpected reserved word '${r}'.`;
          }, UnexpectedSuper: "'super' is only allowed in object methods and classes.", UnexpectedToken: (t) => {
            let { expected: r, unexpected: e } = t;
            return `Unexpected token${e ? ` '${e}'.` : ""}${r ? `, expected "${r}"` : ""}`;
          }, UnexpectedTokenUnaryExponentiation: "Illegal expression. Wrap left hand side or entire exponentiation in parentheses.", UnexpectedUsingDeclaration: "Using declaration cannot appear in the top level when source type is `script`.", UnsupportedBind: "Binding should be performed on object property.", UnsupportedDecoratorExport: "A decorated export must export a class declaration.", UnsupportedDefaultExport: "Only expressions, functions or classes are allowed as the `default` export.", UnsupportedImport: "`import` can only be used in `import()` or `import.meta`.", UnsupportedMetaProperty: (t) => {
            let { target: r, onlyValidPropertyName: e } = t;
            return `The only valid meta property for ${r} is ${r}.${e}.`;
          }, UnsupportedParameterDecorator: "Decorators cannot be used to decorate parameters.", UnsupportedPropertyDecorator: "Decorators cannot be used to decorate object literal properties.", UnsupportedSuper: "'super' can only be used with function calls (i.e. super()) or in property accesses (i.e. super.prop or super[prop]).", UnterminatedComment: "Unterminated comment.", UnterminatedRegExp: "Unterminated regular expression.", UnterminatedString: "Unterminated string constant.", UnterminatedTemplate: "Unterminated template.", UsingDeclarationHasBindingPattern: "Using declaration cannot have destructuring patterns.", VarRedeclaration: (t) => {
            let { identifierName: r } = t;
            return `Identifier '${r}' has already been declared.`;
          }, YieldBindingIdentifier: "Can not use 'yield' as identifier inside a generator.", YieldInParameter: "Yield expression is not allowed in formal parameters.", ZeroDigitNumericSeparator: "Numeric separator can not be used after leading 0." }, Wo = { StrictDelete: "Deleting local variable in strict mode.", StrictEvalArguments: (t) => {
            let { referenceName: r } = t;
            return `Assigning to '${r}' in strict mode.`;
          }, StrictEvalArgumentsBinding: (t) => {
            let { bindingName: r } = t;
            return `Binding '${r}' in strict mode.`;
          }, StrictFunction: "In strict mode code, functions can only be declared at top level or inside a block.", StrictNumericEscape: "The only valid numeric escape in strict mode is '\\0'.", StrictOctalLiteral: "Legacy octal literals are not allowed in strict mode.", StrictWith: "'with' in strict mode." }, Go = /* @__PURE__ */ new Set(["ArrowFunctionExpression", "AssignmentExpression", "ConditionalExpression", "YieldExpression"]), Jo = { PipeBodyIsTighter: "Unexpected yield after pipeline body; any yield expression acting as Hack-style pipe body must be parenthesized due to its loose operator precedence.", PipeTopicRequiresHackPipes: 'Topic reference is used, but the pipelineOperator plugin was not passed a "proposal": "hack" or "smart" option.', PipeTopicUnbound: "Topic reference is unbound; it must be inside a pipe body.", PipeTopicUnconfiguredToken: (t) => {
            let { token: r } = t;
            return `Invalid topic token ${r}. In order to use ${r} as a topic reference, the pipelineOperator plugin must be configured with { "proposal": "hack", "topicToken": "${r}" }.`;
          }, PipeTopicUnused: "Hack-style pipe body does not contain a topic reference; Hack-style pipes must use topic at least once.", PipeUnparenthesizedBody: (t) => {
            let { type: r } = t;
            return `Hack-style pipe body cannot be an unparenthesized ${zt({ type: r })}; please wrap it in parentheses.`;
          }, PipelineBodyNoArrow: 'Unexpected arrow "=>" after pipeline body; arrow function in pipeline body must be parenthesized.', PipelineBodySequenceExpression: "Pipeline body may not be a comma-separated sequence expression.", PipelineHeadSequenceExpression: "Pipeline head should not be a comma-separated sequence expression.", PipelineTopicUnused: "Pipeline is in topic style but does not use topic reference.", PrimaryTopicNotAllowed: "Topic reference was used in a lexical context without topic binding.", PrimaryTopicRequiresSmartPipeline: 'Topic reference is used, but the pipelineOperator plugin was not passed a "proposal": "hack" or "smart" option.' }, Xo = ["toMessage"], Yo = ["message"];
          function Qo(t) {
            let { toMessage: r } = t, e = ot(t, Xo);
            return function s(i) {
              let { loc: a, details: n2 } = i;
              return zo(SyntaxError, Object.assign({}, e, { loc: a }), { clone() {
                let o = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {}, u = o.loc || {};
                return s({ loc: new ge("line" in u ? u.line : this.loc.line, "column" in u ? u.column : this.loc.column, "index" in u ? u.index : this.loc.index), details: Object.assign({}, this.details, o.details) });
              }, details: { value: n2, enumerable: false }, message: { get() {
                return `${r(this.details)} (${this.loc.line}:${this.loc.column})`;
              }, set(o) {
                Object.defineProperty(this, "message", { value: o });
              } }, pos: { reflect: "loc.index", enumerable: true }, missingPlugin: "missingPlugin" in n2 && { reflect: "details.missingPlugin", enumerable: true } });
            };
          }
          function pe(t, r) {
            if (Array.isArray(t))
              return (s) => pe(s, t[0]);
            let e = {};
            for (let s of Object.keys(t)) {
              let i = t[s], a = typeof i == "string" ? { message: () => i } : typeof i == "function" ? { message: i } : i, { message: n2 } = a, o = ot(a, Yo), u = typeof n2 == "string" ? () => n2 : n2;
              e[s] = Qo(Object.assign({ code: Ht.SyntaxError, reasonCode: s, toMessage: u }, r ? { syntaxPlugin: r } : {}, o));
            }
            return e;
          }
          var f = Object.assign({}, pe(Vo), pe(Ko), pe(Wo), pe`pipelineOperator`(Jo)), { defineProperty: Zo } = Object, cr = (t, r) => Zo(t, r, { enumerable: false, value: t[r] });
          function ze(t) {
            return t.loc.start && cr(t.loc.start, "index"), t.loc.end && cr(t.loc.end, "index"), t;
          }
          var el = (t) => class extends t {
            parse() {
              let e = ze(super.parse());
              return this.options.tokens && (e.tokens = e.tokens.map(ze)), e;
            }
            parseRegExpLiteral(e) {
              let { pattern: s, flags: i } = e, a = null;
              try {
                a = new RegExp(s, i);
              } catch {
              }
              let n2 = this.estreeParseLiteral(a);
              return n2.regex = { pattern: s, flags: i }, n2;
            }
            parseBigIntLiteral(e) {
              let s;
              try {
                s = BigInt(e);
              } catch {
                s = null;
              }
              let i = this.estreeParseLiteral(s);
              return i.bigint = String(i.value || e), i;
            }
            parseDecimalLiteral(e) {
              let i = this.estreeParseLiteral(null);
              return i.decimal = String(i.value || e), i;
            }
            estreeParseLiteral(e) {
              return this.parseLiteral(e, "Literal");
            }
            parseStringLiteral(e) {
              return this.estreeParseLiteral(e);
            }
            parseNumericLiteral(e) {
              return this.estreeParseLiteral(e);
            }
            parseNullLiteral() {
              return this.estreeParseLiteral(null);
            }
            parseBooleanLiteral(e) {
              return this.estreeParseLiteral(e);
            }
            directiveToStmt(e) {
              let s = e.value;
              delete e.value, s.type = "Literal", s.raw = s.extra.raw, s.value = s.extra.expressionValue;
              let i = e;
              return i.type = "ExpressionStatement", i.expression = s, i.directive = s.extra.rawValue, delete s.extra, i;
            }
            initFunction(e, s) {
              super.initFunction(e, s), e.expression = false;
            }
            checkDeclaration(e) {
              e != null && this.isObjectProperty(e) ? this.checkDeclaration(e.value) : super.checkDeclaration(e);
            }
            getObjectOrClassMethodParams(e) {
              return e.value.params;
            }
            isValidDirective(e) {
              var s;
              return e.type === "ExpressionStatement" && e.expression.type === "Literal" && typeof e.expression.value == "string" && !((s = e.expression.extra) != null && s.parenthesized);
            }
            parseBlockBody(e, s, i, a, n2) {
              super.parseBlockBody(e, s, i, a, n2);
              let o = e.directives.map((u) => this.directiveToStmt(u));
              e.body = o.concat(e.body), delete e.directives;
            }
            pushClassMethod(e, s, i, a, n2, o) {
              this.parseMethod(s, i, a, n2, o, "ClassMethod", true), s.typeParameters && (s.value.typeParameters = s.typeParameters, delete s.typeParameters), e.body.push(s);
            }
            parsePrivateName() {
              let e = super.parsePrivateName();
              return this.getPluginOption("estree", "classFeatures") ? this.convertPrivateNameToPrivateIdentifier(e) : e;
            }
            convertPrivateNameToPrivateIdentifier(e) {
              let s = super.getPrivateNameSV(e);
              return e = e, delete e.id, e.name = s, e.type = "PrivateIdentifier", e;
            }
            isPrivateName(e) {
              return this.getPluginOption("estree", "classFeatures") ? e.type === "PrivateIdentifier" : super.isPrivateName(e);
            }
            getPrivateNameSV(e) {
              return this.getPluginOption("estree", "classFeatures") ? e.name : super.getPrivateNameSV(e);
            }
            parseLiteral(e, s) {
              let i = super.parseLiteral(e, s);
              return i.raw = i.extra.raw, delete i.extra, i;
            }
            parseFunctionBody(e, s) {
              let i = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : false;
              super.parseFunctionBody(e, s, i), e.expression = e.body.type !== "BlockStatement";
            }
            parseMethod(e, s, i, a, n2, o) {
              let u = arguments.length > 6 && arguments[6] !== void 0 ? arguments[6] : false, c = this.startNode();
              return c.kind = e.kind, c = super.parseMethod(c, s, i, a, n2, o, u), c.type = "FunctionExpression", delete c.kind, e.value = c, o === "ClassPrivateMethod" && (e.computed = false), this.finishNode(e, "MethodDefinition");
            }
            parseClassProperty() {
              let e = super.parseClassProperty(...arguments);
              return this.getPluginOption("estree", "classFeatures") && (e.type = "PropertyDefinition"), e;
            }
            parseClassPrivateProperty() {
              let e = super.parseClassPrivateProperty(...arguments);
              return this.getPluginOption("estree", "classFeatures") && (e.type = "PropertyDefinition", e.computed = false), e;
            }
            parseObjectMethod(e, s, i, a, n2) {
              let o = super.parseObjectMethod(e, s, i, a, n2);
              return o && (o.type = "Property", o.kind === "method" && (o.kind = "init"), o.shorthand = false), o;
            }
            parseObjectProperty(e, s, i, a) {
              let n2 = super.parseObjectProperty(e, s, i, a);
              return n2 && (n2.kind = "init", n2.type = "Property"), n2;
            }
            isValidLVal(e, s, i) {
              return e === "Property" ? "value" : super.isValidLVal(e, s, i);
            }
            isAssignable(e, s) {
              return e != null && this.isObjectProperty(e) ? this.isAssignable(e.value, s) : super.isAssignable(e, s);
            }
            toAssignable(e) {
              let s = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : false;
              if (e != null && this.isObjectProperty(e)) {
                let { key: i, value: a } = e;
                this.isPrivateName(i) && this.classScope.usePrivateName(this.getPrivateNameSV(i), i.loc.start), this.toAssignable(a, s);
              } else
                super.toAssignable(e, s);
            }
            toAssignableObjectExpressionProp(e, s, i) {
              e.kind === "get" || e.kind === "set" ? this.raise(f.PatternHasAccessor, { at: e.key }) : e.method ? this.raise(f.PatternHasMethod, { at: e.key }) : super.toAssignableObjectExpressionProp(e, s, i);
            }
            finishCallExpression(e, s) {
              let i = super.finishCallExpression(e, s);
              if (i.callee.type === "Import") {
                if (i.type = "ImportExpression", i.source = i.arguments[0], this.hasPlugin("importAssertions")) {
                  var a;
                  i.attributes = (a = i.arguments[1]) != null ? a : null;
                }
                delete i.arguments, delete i.callee;
              }
              return i;
            }
            toReferencedArguments(e) {
              e.type !== "ImportExpression" && super.toReferencedArguments(e);
            }
            parseExport(e, s) {
              let i = this.state.lastTokStartLoc, a = super.parseExport(e, s);
              switch (a.type) {
                case "ExportAllDeclaration":
                  a.exported = null;
                  break;
                case "ExportNamedDeclaration":
                  a.specifiers.length === 1 && a.specifiers[0].type === "ExportNamespaceSpecifier" && (a.type = "ExportAllDeclaration", a.exported = a.specifiers[0].exported, delete a.specifiers);
                case "ExportDefaultDeclaration":
                  {
                    var n2;
                    let { declaration: o } = a;
                    (o == null ? void 0 : o.type) === "ClassDeclaration" && ((n2 = o.decorators) == null ? void 0 : n2.length) > 0 && o.start === a.start && this.resetStartLocation(a, i);
                  }
                  break;
              }
              return a;
            }
            parseSubscript(e, s, i, a) {
              let n2 = super.parseSubscript(e, s, i, a);
              if (a.optionalChainMember) {
                if ((n2.type === "OptionalMemberExpression" || n2.type === "OptionalCallExpression") && (n2.type = n2.type.substring(8)), a.stop) {
                  let o = this.startNodeAtNode(n2);
                  return o.expression = n2, this.finishNode(o, "ChainExpression");
                }
              } else
                (n2.type === "MemberExpression" || n2.type === "CallExpression") && (n2.optional = false);
              return n2;
            }
            hasPropertyAsPrivateName(e) {
              return e.type === "ChainExpression" && (e = e.expression), super.hasPropertyAsPrivateName(e);
            }
            isObjectProperty(e) {
              return e.type === "Property" && e.kind === "init" && !e.method;
            }
            isObjectMethod(e) {
              return e.method || e.kind === "get" || e.kind === "set";
            }
            finishNodeAt(e, s, i) {
              return ze(super.finishNodeAt(e, s, i));
            }
            resetStartLocation(e, s) {
              super.resetStartLocation(e, s), ze(e);
            }
            resetEndLocation(e) {
              let s = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : this.state.lastTokEndLoc;
              super.resetEndLocation(e, s), ze(e);
            }
          }, Vt = "\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0560-\u0588\u05D0-\u05EA\u05EF-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u0860-\u086A\u0870-\u0887\u0889-\u088E\u08A0-\u08C9\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u09FC\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C5D\u0C60\u0C61\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D04-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E86-\u0E8A\u0E8C-\u0EA3\u0EA5\u0EA7-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u1711\u171F-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1878\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4C\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1C80-\u1C88\u1C90-\u1CBA\u1CBD-\u1CBF\u1CE9-\u1CEC\u1CEE-\u1CF3\u1CF5\u1CF6\u1CFA\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2118-\u211D\u2124\u2126\u2128\u212A-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309B-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312F\u3131-\u318E\u31A0-\u31BF\u31F0-\u31FF\u3400-\u4DBF\u4E00-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA7CA\uA7D0\uA7D1\uA7D3\uA7D5-\uA7D9\uA7F2-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA8FE\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB69\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC", pr = "\u200C\u200D\xB7\u0300-\u036F\u0387\u0483-\u0487\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u0669\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u06F0-\u06F9\u0711\u0730-\u074A\u07A6-\u07B0\u07C0-\u07C9\u07EB-\u07F3\u07FD\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u0898-\u089F\u08CA-\u08E1\u08E3-\u0903\u093A-\u093C\u093E-\u094F\u0951-\u0957\u0962\u0963\u0966-\u096F\u0981-\u0983\u09BC\u09BE-\u09C4\u09C7\u09C8\u09CB-\u09CD\u09D7\u09E2\u09E3\u09E6-\u09EF\u09FE\u0A01-\u0A03\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A66-\u0A71\u0A75\u0A81-\u0A83\u0ABC\u0ABE-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AE2\u0AE3\u0AE6-\u0AEF\u0AFA-\u0AFF\u0B01-\u0B03\u0B3C\u0B3E-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B55-\u0B57\u0B62\u0B63\u0B66-\u0B6F\u0B82\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD7\u0BE6-\u0BEF\u0C00-\u0C04\u0C3C\u0C3E-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C66-\u0C6F\u0C81-\u0C83\u0CBC\u0CBE-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CE2\u0CE3\u0CE6-\u0CEF\u0CF3\u0D00-\u0D03\u0D3B\u0D3C\u0D3E-\u0D44\u0D46-\u0D48\u0D4A-\u0D4D\u0D57\u0D62\u0D63\u0D66-\u0D6F\u0D81-\u0D83\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2\u0DF3\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0E50-\u0E59\u0EB1\u0EB4-\u0EBC\u0EC8-\u0ECE\u0ED0-\u0ED9\u0F18\u0F19\u0F20-\u0F29\u0F35\u0F37\u0F39\u0F3E\u0F3F\u0F71-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102B-\u103E\u1040-\u1049\u1056-\u1059\u105E-\u1060\u1062-\u1064\u1067-\u106D\u1071-\u1074\u1082-\u108D\u108F-\u109D\u135D-\u135F\u1369-\u1371\u1712-\u1715\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4-\u17D3\u17DD\u17E0-\u17E9\u180B-\u180D\u180F-\u1819\u18A9\u1920-\u192B\u1930-\u193B\u1946-\u194F\u19D0-\u19DA\u1A17-\u1A1B\u1A55-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AB0-\u1ABD\u1ABF-\u1ACE\u1B00-\u1B04\u1B34-\u1B44\u1B50-\u1B59\u1B6B-\u1B73\u1B80-\u1B82\u1BA1-\u1BAD\u1BB0-\u1BB9\u1BE6-\u1BF3\u1C24-\u1C37\u1C40-\u1C49\u1C50-\u1C59\u1CD0-\u1CD2\u1CD4-\u1CE8\u1CED\u1CF4\u1CF7-\u1CF9\u1DC0-\u1DFF\u203F\u2040\u2054\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\uA620-\uA629\uA66F\uA674-\uA67D\uA69E\uA69F\uA6F0\uA6F1\uA802\uA806\uA80B\uA823-\uA827\uA82C\uA880\uA881\uA8B4-\uA8C5\uA8D0-\uA8D9\uA8E0-\uA8F1\uA8FF-\uA909\uA926-\uA92D\uA947-\uA953\uA980-\uA983\uA9B3-\uA9C0\uA9D0-\uA9D9\uA9E5\uA9F0-\uA9F9\uAA29-\uAA36\uAA43\uAA4C\uAA4D\uAA50-\uAA59\uAA7B-\uAA7D\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEB-\uAAEF\uAAF5\uAAF6\uABE3-\uABEA\uABEC\uABED\uABF0-\uABF9\uFB1E\uFE00-\uFE0F\uFE20-\uFE2F\uFE33\uFE34\uFE4D-\uFE4F\uFF10-\uFF19\uFF3F", tl = new RegExp("[" + Vt + "]"), sl = new RegExp("[" + Vt + pr + "]");
          Vt = pr = null;
          var fr = [0, 11, 2, 25, 2, 18, 2, 1, 2, 14, 3, 13, 35, 122, 70, 52, 268, 28, 4, 48, 48, 31, 14, 29, 6, 37, 11, 29, 3, 35, 5, 7, 2, 4, 43, 157, 19, 35, 5, 35, 5, 39, 9, 51, 13, 10, 2, 14, 2, 6, 2, 1, 2, 10, 2, 14, 2, 6, 2, 1, 68, 310, 10, 21, 11, 7, 25, 5, 2, 41, 2, 8, 70, 5, 3, 0, 2, 43, 2, 1, 4, 0, 3, 22, 11, 22, 10, 30, 66, 18, 2, 1, 11, 21, 11, 25, 71, 55, 7, 1, 65, 0, 16, 3, 2, 2, 2, 28, 43, 28, 4, 28, 36, 7, 2, 27, 28, 53, 11, 21, 11, 18, 14, 17, 111, 72, 56, 50, 14, 50, 14, 35, 349, 41, 7, 1, 79, 28, 11, 0, 9, 21, 43, 17, 47, 20, 28, 22, 13, 52, 58, 1, 3, 0, 14, 44, 33, 24, 27, 35, 30, 0, 3, 0, 9, 34, 4, 0, 13, 47, 15, 3, 22, 0, 2, 0, 36, 17, 2, 24, 20, 1, 64, 6, 2, 0, 2, 3, 2, 14, 2, 9, 8, 46, 39, 7, 3, 1, 3, 21, 2, 6, 2, 1, 2, 4, 4, 0, 19, 0, 13, 4, 159, 52, 19, 3, 21, 2, 31, 47, 21, 1, 2, 0, 185, 46, 42, 3, 37, 47, 21, 0, 60, 42, 14, 0, 72, 26, 38, 6, 186, 43, 117, 63, 32, 7, 3, 0, 3, 7, 2, 1, 2, 23, 16, 0, 2, 0, 95, 7, 3, 38, 17, 0, 2, 0, 29, 0, 11, 39, 8, 0, 22, 0, 12, 45, 20, 0, 19, 72, 264, 8, 2, 36, 18, 0, 50, 29, 113, 6, 2, 1, 2, 37, 22, 0, 26, 5, 2, 1, 2, 31, 15, 0, 328, 18, 16, 0, 2, 12, 2, 33, 125, 0, 80, 921, 103, 110, 18, 195, 2637, 96, 16, 1071, 18, 5, 4026, 582, 8634, 568, 8, 30, 18, 78, 18, 29, 19, 47, 17, 3, 32, 20, 6, 18, 689, 63, 129, 74, 6, 0, 67, 12, 65, 1, 2, 0, 29, 6135, 9, 1237, 43, 8, 8936, 3, 2, 6, 2, 1, 2, 290, 16, 0, 30, 2, 3, 0, 15, 3, 9, 395, 2309, 106, 6, 12, 4, 8, 8, 9, 5991, 84, 2, 70, 2, 1, 3, 0, 3, 1, 3, 3, 2, 11, 2, 0, 2, 6, 2, 64, 2, 3, 3, 7, 2, 6, 2, 27, 2, 3, 2, 4, 2, 0, 4, 6, 2, 339, 3, 24, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 7, 1845, 30, 7, 5, 262, 61, 147, 44, 11, 6, 17, 0, 322, 29, 19, 43, 485, 27, 757, 6, 2, 3, 2, 1, 2, 14, 2, 196, 60, 67, 8, 0, 1205, 3, 2, 26, 2, 1, 2, 0, 3, 0, 2, 9, 2, 3, 2, 0, 2, 0, 7, 0, 5, 0, 2, 0, 2, 0, 2, 2, 2, 1, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 1, 2, 0, 3, 3, 2, 6, 2, 3, 2, 3, 2, 0, 2, 9, 2, 16, 6, 2, 2, 4, 2, 16, 4421, 42719, 33, 4153, 7, 221, 3, 5761, 15, 7472, 3104, 541, 1507, 4938, 6, 4191], rl = [509, 0, 227, 0, 150, 4, 294, 9, 1368, 2, 2, 1, 6, 3, 41, 2, 5, 0, 166, 1, 574, 3, 9, 9, 370, 1, 81, 2, 71, 10, 50, 3, 123, 2, 54, 14, 32, 10, 3, 1, 11, 3, 46, 10, 8, 0, 46, 9, 7, 2, 37, 13, 2, 9, 6, 1, 45, 0, 13, 2, 49, 13, 9, 3, 2, 11, 83, 11, 7, 0, 3, 0, 158, 11, 6, 9, 7, 3, 56, 1, 2, 6, 3, 1, 3, 2, 10, 0, 11, 1, 3, 6, 4, 4, 193, 17, 10, 9, 5, 0, 82, 19, 13, 9, 214, 6, 3, 8, 28, 1, 83, 16, 16, 9, 82, 12, 9, 9, 84, 14, 5, 9, 243, 14, 166, 9, 71, 5, 2, 1, 3, 3, 2, 0, 2, 1, 13, 9, 120, 6, 3, 6, 4, 0, 29, 9, 41, 6, 2, 3, 9, 0, 10, 10, 47, 15, 406, 7, 2, 7, 17, 9, 57, 21, 2, 13, 123, 5, 4, 0, 2, 1, 2, 6, 2, 0, 9, 9, 49, 4, 2, 1, 2, 4, 9, 9, 330, 3, 10, 1, 2, 0, 49, 6, 4, 4, 14, 9, 5351, 0, 7, 14, 13835, 9, 87, 9, 39, 4, 60, 6, 26, 9, 1014, 0, 2, 54, 8, 3, 82, 0, 12, 1, 19628, 1, 4706, 45, 3, 22, 543, 4, 4, 5, 9, 7, 3, 6, 31, 3, 149, 2, 1418, 49, 513, 54, 5, 49, 9, 0, 15, 0, 23, 4, 2, 14, 1361, 6, 2, 16, 3, 6, 2, 1, 2, 4, 101, 0, 161, 6, 10, 9, 357, 0, 62, 13, 499, 13, 983, 6, 110, 6, 6, 9, 4759, 9, 787719, 239];
          function Kt(t, r) {
            let e = 65536;
            for (let s = 0, i = r.length; s < i; s += 2) {
              if (e += r[s], e > t)
                return false;
              if (e += r[s + 1], e >= t)
                return true;
            }
            return false;
          }
          function fe(t) {
            return t < 65 ? t === 36 : t <= 90 ? true : t < 97 ? t === 95 : t <= 122 ? true : t <= 65535 ? t >= 170 && tl.test(String.fromCharCode(t)) : Kt(t, fr);
          }
          function De(t) {
            return t < 48 ? t === 36 : t < 58 ? true : t < 65 ? false : t <= 90 ? true : t < 97 ? t === 95 : t <= 122 ? true : t <= 65535 ? t >= 170 && sl.test(String.fromCharCode(t)) : Kt(t, fr) || Kt(t, rl);
          }
          var Wt = { keyword: ["break", "case", "catch", "continue", "debugger", "default", "do", "else", "finally", "for", "function", "if", "return", "switch", "throw", "try", "var", "const", "while", "with", "new", "this", "super", "class", "extends", "export", "import", "null", "true", "false", "in", "instanceof", "typeof", "void", "delete"], strict: ["implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"], strictBind: ["eval", "arguments"] }, il = new Set(Wt.keyword), al = new Set(Wt.strict), nl = new Set(Wt.strictBind);
          function dr(t, r) {
            return r && t === "await" || t === "enum";
          }
          function mr(t, r) {
            return dr(t, r) || al.has(t);
          }
          function yr(t) {
            return nl.has(t);
          }
          function xr(t, r) {
            return mr(t, r) || yr(t);
          }
          function ol(t) {
            return il.has(t);
          }
          function ll(t, r, e) {
            return t === 64 && r === 64 && fe(e);
          }
          var hl = /* @__PURE__ */ new Set(["break", "case", "catch", "continue", "debugger", "default", "do", "else", "finally", "for", "function", "if", "return", "switch", "throw", "try", "var", "const", "while", "with", "new", "this", "super", "class", "extends", "export", "import", "null", "true", "false", "in", "instanceof", "typeof", "void", "delete", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield", "eval", "arguments", "enum", "await"]);
          function ul(t) {
            return hl.has(t);
          }
          var Fe = 0, Le = 1, de = 2, Gt = 4, gr = 8, ht = 16, Pr = 32, Ee = 64, ut = 128, Oe = 256, ct = Le | de | ut | Oe, le = 1, Ce = 2, Ar = 4, be = 8, pt = 16, Tr = 64, ft = 128, Jt = 256, Xt = 512, Yt = 1024, Qt = 2048, Ve = 4096, dt = 8192, vr = le | Ce | be | ft | dt, Be = le | 0 | be | dt, cl = le | 0 | be | 0, mt = le | 0 | Ar | 0, Er = le | 0 | pt | 0, pl = 0 | Ce | 0 | ft, fl = 0 | Ce | 0 | 0, Cr = le | Ce | be | Jt | dt, br = 0 | Yt, Pe = 0 | Tr, dl = le | 0 | 0 | Tr, ml = Cr | Xt, yl = 0 | Yt, Sr = 0 | Ce | 0 | Ve, xl = Qt, yt = 4, Zt = 2, es = 1, ts = Zt | es, gl = Zt | yt, Pl = es | yt, Al = Zt, Tl = es, ss = 0, rs = class {
            constructor(t) {
              this.var = /* @__PURE__ */ new Set(), this.lexical = /* @__PURE__ */ new Set(), this.functions = /* @__PURE__ */ new Set(), this.flags = t;
            }
          }, is = class {
            constructor(t, r) {
              this.parser = void 0, this.scopeStack = [], this.inModule = void 0, this.undefinedExports = /* @__PURE__ */ new Map(), this.parser = t, this.inModule = r;
            }
            get inTopLevel() {
              return (this.currentScope().flags & Le) > 0;
            }
            get inFunction() {
              return (this.currentVarScopeFlags() & de) > 0;
            }
            get allowSuper() {
              return (this.currentThisScopeFlags() & ht) > 0;
            }
            get allowDirectSuper() {
              return (this.currentThisScopeFlags() & Pr) > 0;
            }
            get inClass() {
              return (this.currentThisScopeFlags() & Ee) > 0;
            }
            get inClassAndNotInNonArrowFunction() {
              let t = this.currentThisScopeFlags();
              return (t & Ee) > 0 && (t & de) === 0;
            }
            get inStaticBlock() {
              for (let t = this.scopeStack.length - 1; ; t--) {
                let { flags: r } = this.scopeStack[t];
                if (r & ut)
                  return true;
                if (r & (ct | Ee))
                  return false;
              }
            }
            get inNonArrowFunction() {
              return (this.currentThisScopeFlags() & de) > 0;
            }
            get treatFunctionsAsVar() {
              return this.treatFunctionsAsVarInScope(this.currentScope());
            }
            createScope(t) {
              return new rs(t);
            }
            enter(t) {
              this.scopeStack.push(this.createScope(t));
            }
            exit() {
              return this.scopeStack.pop().flags;
            }
            treatFunctionsAsVarInScope(t) {
              return !!(t.flags & (de | ut) || !this.parser.inModule && t.flags & Le);
            }
            declareName(t, r, e) {
              let s = this.currentScope();
              if (r & be || r & pt)
                this.checkRedeclarationInScope(s, t, r, e), r & pt ? s.functions.add(t) : s.lexical.add(t), r & be && this.maybeExportDefined(s, t);
              else if (r & Ar)
                for (let i = this.scopeStack.length - 1; i >= 0 && (s = this.scopeStack[i], this.checkRedeclarationInScope(s, t, r, e), s.var.add(t), this.maybeExportDefined(s, t), !(s.flags & ct)); --i)
                  ;
              this.parser.inModule && s.flags & Le && this.undefinedExports.delete(t);
            }
            maybeExportDefined(t, r) {
              this.parser.inModule && t.flags & Le && this.undefinedExports.delete(r);
            }
            checkRedeclarationInScope(t, r, e, s) {
              this.isRedeclaredInScope(t, r, e) && this.parser.raise(f.VarRedeclaration, { at: s, identifierName: r });
            }
            isRedeclaredInScope(t, r, e) {
              return e & le ? e & be ? t.lexical.has(r) || t.functions.has(r) || t.var.has(r) : e & pt ? t.lexical.has(r) || !this.treatFunctionsAsVarInScope(t) && t.var.has(r) : t.lexical.has(r) && !(t.flags & gr && t.lexical.values().next().value === r) || !this.treatFunctionsAsVarInScope(t) && t.functions.has(r) : false;
            }
            checkLocalExport(t) {
              let { name: r } = t, e = this.scopeStack[0];
              !e.lexical.has(r) && !e.var.has(r) && !e.functions.has(r) && this.undefinedExports.set(r, t.loc.start);
            }
            currentScope() {
              return this.scopeStack[this.scopeStack.length - 1];
            }
            currentVarScopeFlags() {
              for (let t = this.scopeStack.length - 1; ; t--) {
                let { flags: r } = this.scopeStack[t];
                if (r & ct)
                  return r;
              }
            }
            currentThisScopeFlags() {
              for (let t = this.scopeStack.length - 1; ; t--) {
                let { flags: r } = this.scopeStack[t];
                if (r & (ct | Ee) && !(r & Gt))
                  return r;
              }
            }
          }, vl = class extends rs {
            constructor() {
              super(...arguments), this.declareFunctions = /* @__PURE__ */ new Set();
            }
          }, El = class extends is {
            createScope(t) {
              return new vl(t);
            }
            declareName(t, r, e) {
              let s = this.currentScope();
              if (r & Qt) {
                this.checkRedeclarationInScope(s, t, r, e), this.maybeExportDefined(s, t), s.declareFunctions.add(t);
                return;
              }
              super.declareName(t, r, e);
            }
            isRedeclaredInScope(t, r, e) {
              return super.isRedeclaredInScope(t, r, e) ? true : e & Qt ? !t.declareFunctions.has(r) && (t.lexical.has(r) || t.functions.has(r)) : false;
            }
            checkLocalExport(t) {
              this.scopeStack[0].declareFunctions.has(t.name) || super.checkLocalExport(t);
            }
          }, Cl = class {
            constructor() {
              this.sawUnambiguousESM = false, this.ambiguousScriptDifferentAst = false;
            }
            hasPlugin(t) {
              if (typeof t == "string")
                return this.plugins.has(t);
              {
                let [r, e] = t;
                if (!this.hasPlugin(r))
                  return false;
                let s = this.plugins.get(r);
                for (let i of Object.keys(e))
                  if ((s == null ? void 0 : s[i]) !== e[i])
                    return false;
                return true;
              }
            }
            getPluginOption(t, r) {
              var e;
              return (e = this.plugins.get(t)) == null ? void 0 : e[r];
            }
          };
          function wr(t, r) {
            t.trailingComments === void 0 ? t.trailingComments = r : t.trailingComments.unshift(...r);
          }
          function bl(t, r) {
            t.leadingComments === void 0 ? t.leadingComments = r : t.leadingComments.unshift(...r);
          }
          function Ke(t, r) {
            t.innerComments === void 0 ? t.innerComments = r : t.innerComments.unshift(...r);
          }
          function We(t, r, e) {
            let s = null, i = r.length;
            for (; s === null && i > 0; )
              s = r[--i];
            s === null || s.start > e.start ? Ke(t, e.comments) : wr(s, e.comments);
          }
          var Sl = class extends Cl {
            addComment(t) {
              this.filename && (t.loc.filename = this.filename), this.state.comments.push(t);
            }
            processComment(t) {
              let { commentStack: r } = this.state, e = r.length;
              if (e === 0)
                return;
              let s = e - 1, i = r[s];
              i.start === t.end && (i.leadingNode = t, s--);
              let { start: a } = t;
              for (; s >= 0; s--) {
                let n2 = r[s], o = n2.end;
                if (o > a)
                  n2.containingNode = t, this.finalizeComment(n2), r.splice(s, 1);
                else {
                  o === a && (n2.trailingNode = t);
                  break;
                }
              }
            }
            finalizeComment(t) {
              let { comments: r } = t;
              if (t.leadingNode !== null || t.trailingNode !== null)
                t.leadingNode !== null && wr(t.leadingNode, r), t.trailingNode !== null && bl(t.trailingNode, r);
              else {
                let { containingNode: e, start: s } = t;
                if (this.input.charCodeAt(s - 1) === 44)
                  switch (e.type) {
                    case "ObjectExpression":
                    case "ObjectPattern":
                    case "RecordExpression":
                      We(e, e.properties, t);
                      break;
                    case "CallExpression":
                    case "OptionalCallExpression":
                      We(e, e.arguments, t);
                      break;
                    case "FunctionDeclaration":
                    case "FunctionExpression":
                    case "ArrowFunctionExpression":
                    case "ObjectMethod":
                    case "ClassMethod":
                    case "ClassPrivateMethod":
                      We(e, e.params, t);
                      break;
                    case "ArrayExpression":
                    case "ArrayPattern":
                    case "TupleExpression":
                      We(e, e.elements, t);
                      break;
                    case "ExportNamedDeclaration":
                    case "ImportDeclaration":
                      We(e, e.specifiers, t);
                      break;
                    default:
                      Ke(e, r);
                  }
                else
                  Ke(e, r);
              }
            }
            finalizeRemainingComments() {
              let { commentStack: t } = this.state;
              for (let r = t.length - 1; r >= 0; r--)
                this.finalizeComment(t[r]);
              this.state.commentStack = [];
            }
            resetPreviousNodeTrailingComments(t) {
              let { commentStack: r } = this.state, { length: e } = r;
              if (e === 0)
                return;
              let s = r[e - 1];
              s.leadingNode === t && (s.leadingNode = null);
            }
            takeSurroundingComments(t, r, e) {
              let { commentStack: s } = this.state, i = s.length;
              if (i === 0)
                return;
              let a = i - 1;
              for (; a >= 0; a--) {
                let n2 = s[a], o = n2.end;
                if (n2.start === e)
                  n2.leadingNode = t;
                else if (o === r)
                  n2.trailingNode = t;
                else if (o < r)
                  break;
              }
            }
          }, as = /\r\n?|[\n\u2028\u2029]/, xt = new RegExp(as.source, "g");
          function Ge(t) {
            switch (t) {
              case 10:
              case 13:
              case 8232:
              case 8233:
                return true;
              default:
                return false;
            }
          }
          var ns = /(?:\s|\/\/.*|\/\*[^]*?\*\/)*/g, wl = /(?:[^\S\n\r\u2028\u2029]|\/\/.*|\/\*.*?\*\/)*/y, Ir = new RegExp("(?=(" + wl.source + "))\\1" + /(?=[\n\r\u2028\u2029]|\/\*(?!.*?\*\/)|$)/.source, "y");
          function Il(t) {
            switch (t) {
              case 9:
              case 11:
              case 12:
              case 32:
              case 160:
              case 5760:
              case 8192:
              case 8193:
              case 8194:
              case 8195:
              case 8196:
              case 8197:
              case 8198:
              case 8199:
              case 8200:
              case 8201:
              case 8202:
              case 8239:
              case 8287:
              case 12288:
              case 65279:
                return true;
              default:
                return false;
            }
          }
          var Nr = class {
            constructor() {
              this.strict = void 0, this.curLine = void 0, this.lineStart = void 0, this.startLoc = void 0, this.endLoc = void 0, this.errors = [], this.potentialArrowAt = -1, this.noArrowAt = [], this.noArrowParamsConversionAt = [], this.maybeInArrowParameters = false, this.inType = false, this.noAnonFunctionType = false, this.hasFlowComment = false, this.isAmbientContext = false, this.inAbstractClass = false, this.inDisallowConditionalTypesContext = false, this.topicContext = { maxNumOfResolvableTopics: 0, maxTopicIndex: null }, this.soloAwait = false, this.inFSharpPipelineDirectBody = false, this.labels = [], this.comments = [], this.commentStack = [], this.pos = 0, this.type = 137, this.value = null, this.start = 0, this.end = 0, this.lastTokEndLoc = null, this.lastTokStartLoc = null, this.lastTokStart = 0, this.context = [x.brace], this.canStartJSXElement = true, this.containsEsc = false, this.firstInvalidTemplateEscapePos = null, this.strictErrors = /* @__PURE__ */ new Map(), this.tokensLength = 0;
            }
            init(t) {
              let { strictMode: r, sourceType: e, startLine: s, startColumn: i } = t;
              this.strict = r === false ? false : r === true ? true : e === "module", this.curLine = s, this.lineStart = -i, this.startLoc = this.endLoc = new ge(s, i, 0);
            }
            curPosition() {
              return new ge(this.curLine, this.pos - this.lineStart, this.pos);
            }
            clone(t) {
              let r = new Nr(), e = Object.keys(this);
              for (let s = 0, i = e.length; s < i; s++) {
                let a = e[s], n2 = this[a];
                !t && Array.isArray(n2) && (n2 = n2.slice()), r[a] = n2;
              }
              return r;
            }
          }, Nl = function(r) {
            return r >= 48 && r <= 57;
          }, kr = { decBinOct: /* @__PURE__ */ new Set([46, 66, 69, 79, 95, 98, 101, 111]), hex: /* @__PURE__ */ new Set([46, 88, 95, 120]) }, gt = { bin: (t) => t === 48 || t === 49, oct: (t) => t >= 48 && t <= 55, dec: (t) => t >= 48 && t <= 57, hex: (t) => t >= 48 && t <= 57 || t >= 65 && t <= 70 || t >= 97 && t <= 102 };
          function Dr(t, r, e, s, i, a) {
            let n2 = e, o = s, u = i, c = "", y = null, g = e, { length: T } = r;
            for (; ; ) {
              if (e >= T) {
                a.unterminated(n2, o, u), c += r.slice(g, e);
                break;
              }
              let C = r.charCodeAt(e);
              if (kl(t, C, r, e)) {
                c += r.slice(g, e);
                break;
              }
              if (C === 92) {
                c += r.slice(g, e);
                let M = Dl(r, e, s, i, t === "template", a);
                M.ch === null && !y ? y = { pos: e, lineStart: s, curLine: i } : c += M.ch, { pos: e, lineStart: s, curLine: i } = M, g = e;
              } else
                C === 8232 || C === 8233 ? (++e, ++i, s = e) : C === 10 || C === 13 ? t === "template" ? (c += r.slice(g, e) + `
`, ++e, C === 13 && r.charCodeAt(e) === 10 && ++e, ++i, g = s = e) : a.unterminated(n2, o, u) : ++e;
            }
            return { pos: e, str: c, firstInvalidLoc: y, lineStart: s, curLine: i, containsInvalid: !!y };
          }
          function kl(t, r, e, s) {
            return t === "template" ? r === 96 || r === 36 && e.charCodeAt(s + 1) === 123 : r === (t === "double" ? 34 : 39);
          }
          function Dl(t, r, e, s, i, a) {
            let n2 = !i;
            r++;
            let o = (c) => ({ pos: r, ch: c, lineStart: e, curLine: s }), u = t.charCodeAt(r++);
            switch (u) {
              case 110:
                return o(`
`);
              case 114:
                return o("\r");
              case 120: {
                let c;
                return { code: c, pos: r } = os(t, r, e, s, 2, false, n2, a), o(c === null ? null : String.fromCharCode(c));
              }
              case 117: {
                let c;
                return { code: c, pos: r } = Lr(t, r, e, s, n2, a), o(c === null ? null : String.fromCodePoint(c));
              }
              case 116:
                return o("	");
              case 98:
                return o("\b");
              case 118:
                return o("\v");
              case 102:
                return o("\f");
              case 13:
                t.charCodeAt(r) === 10 && ++r;
              case 10:
                e = r, ++s;
              case 8232:
              case 8233:
                return o("");
              case 56:
              case 57:
                if (i)
                  return o(null);
                a.strictNumericEscape(r - 1, e, s);
              default:
                if (u >= 48 && u <= 55) {
                  let c = r - 1, g = t.slice(c, r + 2).match(/^[0-7]+/)[0], T = parseInt(g, 8);
                  T > 255 && (g = g.slice(0, -1), T = parseInt(g, 8)), r += g.length - 1;
                  let C = t.charCodeAt(r);
                  if (g !== "0" || C === 56 || C === 57) {
                    if (i)
                      return o(null);
                    a.strictNumericEscape(c, e, s);
                  }
                  return o(String.fromCharCode(T));
                }
                return o(String.fromCharCode(u));
            }
          }
          function os(t, r, e, s, i, a, n2, o) {
            let u = r, c;
            return { n: c, pos: r } = Fr(t, r, e, s, 16, i, a, false, o, !n2), c === null && (n2 ? o.invalidEscapeSequence(u, e, s) : r = u - 1), { code: c, pos: r };
          }
          function Fr(t, r, e, s, i, a, n2, o, u, c) {
            let y = r, g = i === 16 ? kr.hex : kr.decBinOct, T = i === 16 ? gt.hex : i === 10 ? gt.dec : i === 8 ? gt.oct : gt.bin, C = false, M = 0;
            for (let j = 0, K = a == null ? 1 / 0 : a; j < K; ++j) {
              let W = t.charCodeAt(r), V;
              if (W === 95 && o !== "bail") {
                let X = t.charCodeAt(r - 1), je = t.charCodeAt(r + 1);
                if (o) {
                  if (Number.isNaN(je) || !T(je) || g.has(X) || g.has(je)) {
                    if (c)
                      return { n: null, pos: r };
                    u.unexpectedNumericSeparator(r, e, s);
                  }
                } else {
                  if (c)
                    return { n: null, pos: r };
                  u.numericSeparatorInEscapeSequence(r, e, s);
                }
                ++r;
                continue;
              }
              if (W >= 97 ? V = W - 97 + 10 : W >= 65 ? V = W - 65 + 10 : Nl(W) ? V = W - 48 : V = 1 / 0, V >= i) {
                if (V <= 9 && c)
                  return { n: null, pos: r };
                if (V <= 9 && u.invalidDigit(r, e, s, i))
                  V = 0;
                else if (n2)
                  V = 0, C = true;
                else
                  break;
              }
              ++r, M = M * i + V;
            }
            return r === y || a != null && r - y !== a || C ? { n: null, pos: r } : { n: M, pos: r };
          }
          function Lr(t, r, e, s, i, a) {
            let n2 = t.charCodeAt(r), o;
            if (n2 === 123) {
              if (++r, { code: o, pos: r } = os(t, r, e, s, t.indexOf("}", r) - r, true, i, a), ++r, o !== null && o > 1114111)
                if (i)
                  a.invalidCodePoint(r, e, s);
                else
                  return { code: null, pos: r };
            } else
              ({ code: o, pos: r } = os(t, r, e, s, 4, false, i, a));
            return { code: o, pos: r };
          }
          var Fl = ["at"], Ll = ["at"];
          function Je(t, r, e) {
            return new ge(e, t - r, t);
          }
          var Ol = /* @__PURE__ */ new Set([103, 109, 115, 105, 121, 117, 100, 118]), Ae = class {
            constructor(t) {
              this.type = t.type, this.value = t.value, this.start = t.start, this.end = t.end, this.loc = new lt(t.startLoc, t.endLoc);
            }
          }, Bl = class extends Sl {
            constructor(t, r) {
              super(), this.isLookahead = void 0, this.tokens = [], this.errorHandlers_readInt = { invalidDigit: (e, s, i, a) => this.options.errorRecovery ? (this.raise(f.InvalidDigit, { at: Je(e, s, i), radix: a }), true) : false, numericSeparatorInEscapeSequence: this.errorBuilder(f.NumericSeparatorInEscapeSequence), unexpectedNumericSeparator: this.errorBuilder(f.UnexpectedNumericSeparator) }, this.errorHandlers_readCodePoint = Object.assign({}, this.errorHandlers_readInt, { invalidEscapeSequence: this.errorBuilder(f.InvalidEscapeSequence), invalidCodePoint: this.errorBuilder(f.InvalidCodePoint) }), this.errorHandlers_readStringContents_string = Object.assign({}, this.errorHandlers_readCodePoint, { strictNumericEscape: (e, s, i) => {
                this.recordStrictModeErrors(f.StrictNumericEscape, { at: Je(e, s, i) });
              }, unterminated: (e, s, i) => {
                throw this.raise(f.UnterminatedString, { at: Je(e - 1, s, i) });
              } }), this.errorHandlers_readStringContents_template = Object.assign({}, this.errorHandlers_readCodePoint, { strictNumericEscape: this.errorBuilder(f.StrictNumericEscape), unterminated: (e, s, i) => {
                throw this.raise(f.UnterminatedTemplate, { at: Je(e, s, i) });
              } }), this.state = new Nr(), this.state.init(t), this.input = r, this.length = r.length, this.isLookahead = false;
            }
            pushToken(t) {
              this.tokens.length = this.state.tokensLength, this.tokens.push(t), ++this.state.tokensLength;
            }
            next() {
              this.checkKeywordEscapes(), this.options.tokens && this.pushToken(new Ae(this.state)), this.state.lastTokStart = this.state.start, this.state.lastTokEndLoc = this.state.endLoc, this.state.lastTokStartLoc = this.state.startLoc, this.nextToken();
            }
            eat(t) {
              return this.match(t) ? (this.next(), true) : false;
            }
            match(t) {
              return this.state.type === t;
            }
            createLookaheadState(t) {
              return { pos: t.pos, value: null, type: t.type, start: t.start, end: t.end, context: [this.curContext()], inType: t.inType, startLoc: t.startLoc, lastTokEndLoc: t.lastTokEndLoc, curLine: t.curLine, lineStart: t.lineStart, curPosition: t.curPosition };
            }
            lookahead() {
              let t = this.state;
              this.state = this.createLookaheadState(t), this.isLookahead = true, this.nextToken(), this.isLookahead = false;
              let r = this.state;
              return this.state = t, r;
            }
            nextTokenStart() {
              return this.nextTokenStartSince(this.state.pos);
            }
            nextTokenStartSince(t) {
              return ns.lastIndex = t, ns.test(this.input) ? ns.lastIndex : t;
            }
            lookaheadCharCode() {
              return this.input.charCodeAt(this.nextTokenStart());
            }
            codePointAtPos(t) {
              let r = this.input.charCodeAt(t);
              if ((r & 64512) === 55296 && ++t < this.input.length) {
                let e = this.input.charCodeAt(t);
                (e & 64512) === 56320 && (r = 65536 + ((r & 1023) << 10) + (e & 1023));
              }
              return r;
            }
            setStrict(t) {
              this.state.strict = t, t && (this.state.strictErrors.forEach((r) => {
                let [e, s] = r;
                return this.raise(e, { at: s });
              }), this.state.strictErrors.clear());
            }
            curContext() {
              return this.state.context[this.state.context.length - 1];
            }
            nextToken() {
              if (this.skipSpace(), this.state.start = this.state.pos, this.isLookahead || (this.state.startLoc = this.state.curPosition()), this.state.pos >= this.length) {
                this.finishToken(137);
                return;
              }
              this.getTokenFromCode(this.codePointAtPos(this.state.pos));
            }
            skipBlockComment(t) {
              let r;
              this.isLookahead || (r = this.state.curPosition());
              let e = this.state.pos, s = this.input.indexOf(t, e + 2);
              if (s === -1)
                throw this.raise(f.UnterminatedComment, { at: this.state.curPosition() });
              for (this.state.pos = s + t.length, xt.lastIndex = e + 2; xt.test(this.input) && xt.lastIndex <= s; )
                ++this.state.curLine, this.state.lineStart = xt.lastIndex;
              if (this.isLookahead)
                return;
              let i = { type: "CommentBlock", value: this.input.slice(e + 2, s), start: e, end: s + t.length, loc: new lt(r, this.state.curPosition()) };
              return this.options.tokens && this.pushToken(i), i;
            }
            skipLineComment(t) {
              let r = this.state.pos, e;
              this.isLookahead || (e = this.state.curPosition());
              let s = this.input.charCodeAt(this.state.pos += t);
              if (this.state.pos < this.length)
                for (; !Ge(s) && ++this.state.pos < this.length; )
                  s = this.input.charCodeAt(this.state.pos);
              if (this.isLookahead)
                return;
              let i = this.state.pos, n2 = { type: "CommentLine", value: this.input.slice(r + t, i), start: r, end: i, loc: new lt(e, this.state.curPosition()) };
              return this.options.tokens && this.pushToken(n2), n2;
            }
            skipSpace() {
              let t = this.state.pos, r = [];
              e:
                for (; this.state.pos < this.length; ) {
                  let e = this.input.charCodeAt(this.state.pos);
                  switch (e) {
                    case 32:
                    case 160:
                    case 9:
                      ++this.state.pos;
                      break;
                    case 13:
                      this.input.charCodeAt(this.state.pos + 1) === 10 && ++this.state.pos;
                    case 10:
                    case 8232:
                    case 8233:
                      ++this.state.pos, ++this.state.curLine, this.state.lineStart = this.state.pos;
                      break;
                    case 47:
                      switch (this.input.charCodeAt(this.state.pos + 1)) {
                        case 42: {
                          let s = this.skipBlockComment("*/");
                          s !== void 0 && (this.addComment(s), this.options.attachComment && r.push(s));
                          break;
                        }
                        case 47: {
                          let s = this.skipLineComment(2);
                          s !== void 0 && (this.addComment(s), this.options.attachComment && r.push(s));
                          break;
                        }
                        default:
                          break e;
                      }
                      break;
                    default:
                      if (Il(e))
                        ++this.state.pos;
                      else if (e === 45 && !this.inModule && this.options.annexB) {
                        let s = this.state.pos;
                        if (this.input.charCodeAt(s + 1) === 45 && this.input.charCodeAt(s + 2) === 62 && (t === 0 || this.state.lineStart > t)) {
                          let i = this.skipLineComment(3);
                          i !== void 0 && (this.addComment(i), this.options.attachComment && r.push(i));
                        } else
                          break e;
                      } else if (e === 60 && !this.inModule && this.options.annexB) {
                        let s = this.state.pos;
                        if (this.input.charCodeAt(s + 1) === 33 && this.input.charCodeAt(s + 2) === 45 && this.input.charCodeAt(s + 3) === 45) {
                          let i = this.skipLineComment(4);
                          i !== void 0 && (this.addComment(i), this.options.attachComment && r.push(i));
                        } else
                          break e;
                      } else
                        break e;
                  }
                }
              if (r.length > 0) {
                let e = this.state.pos, s = { start: t, end: e, comments: r, leadingNode: null, trailingNode: null, containingNode: null };
                this.state.commentStack.push(s);
              }
            }
            finishToken(t, r) {
              this.state.end = this.state.pos, this.state.endLoc = this.state.curPosition();
              let e = this.state.type;
              this.state.type = t, this.state.value = r, this.isLookahead || this.updateContext(e);
            }
            replaceToken(t) {
              this.state.type = t, this.updateContext();
            }
            readToken_numberSign() {
              if (this.state.pos === 0 && this.readToken_interpreter())
                return;
              let t = this.state.pos + 1, r = this.codePointAtPos(t);
              if (r >= 48 && r <= 57)
                throw this.raise(f.UnexpectedDigitAfterHash, { at: this.state.curPosition() });
              if (r === 123 || r === 91 && this.hasPlugin("recordAndTuple")) {
                if (this.expectPlugin("recordAndTuple"), this.getPluginOption("recordAndTuple", "syntaxType") === "bar")
                  throw this.raise(r === 123 ? f.RecordExpressionHashIncorrectStartSyntaxType : f.TupleExpressionHashIncorrectStartSyntaxType, { at: this.state.curPosition() });
                this.state.pos += 2, r === 123 ? this.finishToken(7) : this.finishToken(1);
              } else
                fe(r) ? (++this.state.pos, this.finishToken(136, this.readWord1(r))) : r === 92 ? (++this.state.pos, this.finishToken(136, this.readWord1())) : this.finishOp(27, 1);
            }
            readToken_dot() {
              let t = this.input.charCodeAt(this.state.pos + 1);
              if (t >= 48 && t <= 57) {
                this.readNumber(true);
                return;
              }
              t === 46 && this.input.charCodeAt(this.state.pos + 2) === 46 ? (this.state.pos += 3, this.finishToken(21)) : (++this.state.pos, this.finishToken(16));
            }
            readToken_slash() {
              this.input.charCodeAt(this.state.pos + 1) === 61 ? this.finishOp(31, 2) : this.finishOp(56, 1);
            }
            readToken_interpreter() {
              if (this.state.pos !== 0 || this.length < 2)
                return false;
              let t = this.input.charCodeAt(this.state.pos + 1);
              if (t !== 33)
                return false;
              let r = this.state.pos;
              for (this.state.pos += 1; !Ge(t) && ++this.state.pos < this.length; )
                t = this.input.charCodeAt(this.state.pos);
              let e = this.input.slice(r + 2, this.state.pos);
              return this.finishToken(28, e), true;
            }
            readToken_mult_modulo(t) {
              let r = t === 42 ? 55 : 54, e = 1, s = this.input.charCodeAt(this.state.pos + 1);
              t === 42 && s === 42 && (e++, s = this.input.charCodeAt(this.state.pos + 2), r = 57), s === 61 && !this.state.inType && (e++, r = t === 37 ? 33 : 30), this.finishOp(r, e);
            }
            readToken_pipe_amp(t) {
              let r = this.input.charCodeAt(this.state.pos + 1);
              if (r === t) {
                this.input.charCodeAt(this.state.pos + 2) === 61 ? this.finishOp(30, 3) : this.finishOp(t === 124 ? 41 : 42, 2);
                return;
              }
              if (t === 124) {
                if (r === 62) {
                  this.finishOp(39, 2);
                  return;
                }
                if (this.hasPlugin("recordAndTuple") && r === 125) {
                  if (this.getPluginOption("recordAndTuple", "syntaxType") !== "bar")
                    throw this.raise(f.RecordExpressionBarIncorrectEndSyntaxType, { at: this.state.curPosition() });
                  this.state.pos += 2, this.finishToken(9);
                  return;
                }
                if (this.hasPlugin("recordAndTuple") && r === 93) {
                  if (this.getPluginOption("recordAndTuple", "syntaxType") !== "bar")
                    throw this.raise(f.TupleExpressionBarIncorrectEndSyntaxType, { at: this.state.curPosition() });
                  this.state.pos += 2, this.finishToken(4);
                  return;
                }
              }
              if (r === 61) {
                this.finishOp(30, 2);
                return;
              }
              this.finishOp(t === 124 ? 43 : 45, 1);
            }
            readToken_caret() {
              let t = this.input.charCodeAt(this.state.pos + 1);
              t === 61 && !this.state.inType ? this.finishOp(32, 2) : t === 94 && this.hasPlugin(["pipelineOperator", { proposal: "hack", topicToken: "^^" }]) ? (this.finishOp(37, 2), this.input.codePointAt(this.state.pos) === 94 && this.unexpected()) : this.finishOp(44, 1);
            }
            readToken_atSign() {
              this.input.charCodeAt(this.state.pos + 1) === 64 && this.hasPlugin(["pipelineOperator", { proposal: "hack", topicToken: "@@" }]) ? this.finishOp(38, 2) : this.finishOp(26, 1);
            }
            readToken_plus_min(t) {
              let r = this.input.charCodeAt(this.state.pos + 1);
              if (r === t) {
                this.finishOp(34, 2);
                return;
              }
              r === 61 ? this.finishOp(30, 2) : this.finishOp(53, 1);
            }
            readToken_lt() {
              let { pos: t } = this.state, r = this.input.charCodeAt(t + 1);
              if (r === 60) {
                if (this.input.charCodeAt(t + 2) === 61) {
                  this.finishOp(30, 3);
                  return;
                }
                this.finishOp(51, 2);
                return;
              }
              if (r === 61) {
                this.finishOp(49, 2);
                return;
              }
              this.finishOp(47, 1);
            }
            readToken_gt() {
              let { pos: t } = this.state, r = this.input.charCodeAt(t + 1);
              if (r === 62) {
                let e = this.input.charCodeAt(t + 2) === 62 ? 3 : 2;
                if (this.input.charCodeAt(t + e) === 61) {
                  this.finishOp(30, e + 1);
                  return;
                }
                this.finishOp(52, e);
                return;
              }
              if (r === 61) {
                this.finishOp(49, 2);
                return;
              }
              this.finishOp(48, 1);
            }
            readToken_eq_excl(t) {
              let r = this.input.charCodeAt(this.state.pos + 1);
              if (r === 61) {
                this.finishOp(46, this.input.charCodeAt(this.state.pos + 2) === 61 ? 3 : 2);
                return;
              }
              if (t === 61 && r === 62) {
                this.state.pos += 2, this.finishToken(19);
                return;
              }
              this.finishOp(t === 61 ? 29 : 35, 1);
            }
            readToken_question() {
              let t = this.input.charCodeAt(this.state.pos + 1), r = this.input.charCodeAt(this.state.pos + 2);
              t === 63 ? r === 61 ? this.finishOp(30, 3) : this.finishOp(40, 2) : t === 46 && !(r >= 48 && r <= 57) ? (this.state.pos += 2, this.finishToken(18)) : (++this.state.pos, this.finishToken(17));
            }
            getTokenFromCode(t) {
              switch (t) {
                case 46:
                  this.readToken_dot();
                  return;
                case 40:
                  ++this.state.pos, this.finishToken(10);
                  return;
                case 41:
                  ++this.state.pos, this.finishToken(11);
                  return;
                case 59:
                  ++this.state.pos, this.finishToken(13);
                  return;
                case 44:
                  ++this.state.pos, this.finishToken(12);
                  return;
                case 91:
                  if (this.hasPlugin("recordAndTuple") && this.input.charCodeAt(this.state.pos + 1) === 124) {
                    if (this.getPluginOption("recordAndTuple", "syntaxType") !== "bar")
                      throw this.raise(f.TupleExpressionBarIncorrectStartSyntaxType, { at: this.state.curPosition() });
                    this.state.pos += 2, this.finishToken(2);
                  } else
                    ++this.state.pos, this.finishToken(0);
                  return;
                case 93:
                  ++this.state.pos, this.finishToken(3);
                  return;
                case 123:
                  if (this.hasPlugin("recordAndTuple") && this.input.charCodeAt(this.state.pos + 1) === 124) {
                    if (this.getPluginOption("recordAndTuple", "syntaxType") !== "bar")
                      throw this.raise(f.RecordExpressionBarIncorrectStartSyntaxType, { at: this.state.curPosition() });
                    this.state.pos += 2, this.finishToken(6);
                  } else
                    ++this.state.pos, this.finishToken(5);
                  return;
                case 125:
                  ++this.state.pos, this.finishToken(8);
                  return;
                case 58:
                  this.hasPlugin("functionBind") && this.input.charCodeAt(this.state.pos + 1) === 58 ? this.finishOp(15, 2) : (++this.state.pos, this.finishToken(14));
                  return;
                case 63:
                  this.readToken_question();
                  return;
                case 96:
                  this.readTemplateToken();
                  return;
                case 48: {
                  let r = this.input.charCodeAt(this.state.pos + 1);
                  if (r === 120 || r === 88) {
                    this.readRadixNumber(16);
                    return;
                  }
                  if (r === 111 || r === 79) {
                    this.readRadixNumber(8);
                    return;
                  }
                  if (r === 98 || r === 66) {
                    this.readRadixNumber(2);
                    return;
                  }
                }
                case 49:
                case 50:
                case 51:
                case 52:
                case 53:
                case 54:
                case 55:
                case 56:
                case 57:
                  this.readNumber(false);
                  return;
                case 34:
                case 39:
                  this.readString(t);
                  return;
                case 47:
                  this.readToken_slash();
                  return;
                case 37:
                case 42:
                  this.readToken_mult_modulo(t);
                  return;
                case 124:
                case 38:
                  this.readToken_pipe_amp(t);
                  return;
                case 94:
                  this.readToken_caret();
                  return;
                case 43:
                case 45:
                  this.readToken_plus_min(t);
                  return;
                case 60:
                  this.readToken_lt();
                  return;
                case 62:
                  this.readToken_gt();
                  return;
                case 61:
                case 33:
                  this.readToken_eq_excl(t);
                  return;
                case 126:
                  this.finishOp(36, 1);
                  return;
                case 64:
                  this.readToken_atSign();
                  return;
                case 35:
                  this.readToken_numberSign();
                  return;
                case 92:
                  this.readWord();
                  return;
                default:
                  if (fe(t)) {
                    this.readWord(t);
                    return;
                  }
              }
              throw this.raise(f.InvalidOrUnexpectedToken, { at: this.state.curPosition(), unexpected: String.fromCodePoint(t) });
            }
            finishOp(t, r) {
              let e = this.input.slice(this.state.pos, this.state.pos + r);
              this.state.pos += r, this.finishToken(t, e);
            }
            readRegexp() {
              let t = this.state.startLoc, r = this.state.start + 1, e, s, { pos: i } = this.state;
              for (; ; ++i) {
                if (i >= this.length)
                  throw this.raise(f.UnterminatedRegExp, { at: Y(t, 1) });
                let u = this.input.charCodeAt(i);
                if (Ge(u))
                  throw this.raise(f.UnterminatedRegExp, { at: Y(t, 1) });
                if (e)
                  e = false;
                else {
                  if (u === 91)
                    s = true;
                  else if (u === 93 && s)
                    s = false;
                  else if (u === 47 && !s)
                    break;
                  e = u === 92;
                }
              }
              let a = this.input.slice(r, i);
              ++i;
              let n2 = "", o = () => Y(t, i + 2 - r);
              for (; i < this.length; ) {
                let u = this.codePointAtPos(i), c = String.fromCharCode(u);
                if (Ol.has(u))
                  u === 118 ? (this.expectPlugin("regexpUnicodeSets", o()), n2.includes("u") && this.raise(f.IncompatibleRegExpUVFlags, { at: o() })) : u === 117 && n2.includes("v") && this.raise(f.IncompatibleRegExpUVFlags, { at: o() }), n2.includes(c) && this.raise(f.DuplicateRegExpFlags, { at: o() });
                else if (De(u) || u === 92)
                  this.raise(f.MalformedRegExpFlags, { at: o() });
                else
                  break;
                ++i, n2 += c;
              }
              this.state.pos = i, this.finishToken(135, { pattern: a, flags: n2 });
            }
            readInt(t, r) {
              let e = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : false, s = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : true, { n: i, pos: a } = Fr(this.input, this.state.pos, this.state.lineStart, this.state.curLine, t, r, e, s, this.errorHandlers_readInt, false);
              return this.state.pos = a, i;
            }
            readRadixNumber(t) {
              let r = this.state.curPosition(), e = false;
              this.state.pos += 2;
              let s = this.readInt(t);
              s == null && this.raise(f.InvalidDigit, { at: Y(r, 2), radix: t });
              let i = this.input.charCodeAt(this.state.pos);
              if (i === 110)
                ++this.state.pos, e = true;
              else if (i === 109)
                throw this.raise(f.InvalidDecimal, { at: r });
              if (fe(this.codePointAtPos(this.state.pos)))
                throw this.raise(f.NumberIdentifier, { at: this.state.curPosition() });
              if (e) {
                let a = this.input.slice(r.index, this.state.pos).replace(/[_n]/g, "");
                this.finishToken(133, a);
                return;
              }
              this.finishToken(132, s);
            }
            readNumber(t) {
              let r = this.state.pos, e = this.state.curPosition(), s = false, i = false, a = false, n2 = false, o = false;
              !t && this.readInt(10) === null && this.raise(f.InvalidNumber, { at: this.state.curPosition() });
              let u = this.state.pos - r >= 2 && this.input.charCodeAt(r) === 48;
              if (u) {
                let T = this.input.slice(r, this.state.pos);
                if (this.recordStrictModeErrors(f.StrictOctalLiteral, { at: e }), !this.state.strict) {
                  let C = T.indexOf("_");
                  C > 0 && this.raise(f.ZeroDigitNumericSeparator, { at: Y(e, C) });
                }
                o = u && !/[89]/.test(T);
              }
              let c = this.input.charCodeAt(this.state.pos);
              if (c === 46 && !o && (++this.state.pos, this.readInt(10), s = true, c = this.input.charCodeAt(this.state.pos)), (c === 69 || c === 101) && !o && (c = this.input.charCodeAt(++this.state.pos), (c === 43 || c === 45) && ++this.state.pos, this.readInt(10) === null && this.raise(f.InvalidOrMissingExponent, { at: e }), s = true, n2 = true, c = this.input.charCodeAt(this.state.pos)), c === 110 && ((s || u) && this.raise(f.InvalidBigIntLiteral, { at: e }), ++this.state.pos, i = true), c === 109 && (this.expectPlugin("decimal", this.state.curPosition()), (n2 || u) && this.raise(f.InvalidDecimal, { at: e }), ++this.state.pos, a = true), fe(this.codePointAtPos(this.state.pos)))
                throw this.raise(f.NumberIdentifier, { at: this.state.curPosition() });
              let y = this.input.slice(r, this.state.pos).replace(/[_mn]/g, "");
              if (i) {
                this.finishToken(133, y);
                return;
              }
              if (a) {
                this.finishToken(134, y);
                return;
              }
              let g = o ? parseInt(y, 8) : parseFloat(y);
              this.finishToken(132, g);
            }
            readCodePoint(t) {
              let { code: r, pos: e } = Lr(this.input, this.state.pos, this.state.lineStart, this.state.curLine, t, this.errorHandlers_readCodePoint);
              return this.state.pos = e, r;
            }
            readString(t) {
              let { str: r, pos: e, curLine: s, lineStart: i } = Dr(t === 34 ? "double" : "single", this.input, this.state.pos + 1, this.state.lineStart, this.state.curLine, this.errorHandlers_readStringContents_string);
              this.state.pos = e + 1, this.state.lineStart = i, this.state.curLine = s, this.finishToken(131, r);
            }
            readTemplateContinuation() {
              this.match(8) || this.unexpected(null, 8), this.state.pos--, this.readTemplateToken();
            }
            readTemplateToken() {
              let t = this.input[this.state.pos], { str: r, firstInvalidLoc: e, pos: s, curLine: i, lineStart: a } = Dr("template", this.input, this.state.pos + 1, this.state.lineStart, this.state.curLine, this.errorHandlers_readStringContents_template);
              this.state.pos = s + 1, this.state.lineStart = a, this.state.curLine = i, e && (this.state.firstInvalidTemplateEscapePos = new ge(e.curLine, e.pos - e.lineStart, e.pos)), this.input.codePointAt(s) === 96 ? this.finishToken(24, e ? null : t + r + "`") : (this.state.pos++, this.finishToken(25, e ? null : t + r + "${"));
            }
            recordStrictModeErrors(t, r) {
              let { at: e } = r, s = e.index;
              this.state.strict && !this.state.strictErrors.has(s) ? this.raise(t, { at: e }) : this.state.strictErrors.set(s, [t, e]);
            }
            readWord1(t) {
              this.state.containsEsc = false;
              let r = "", e = this.state.pos, s = this.state.pos;
              for (t !== void 0 && (this.state.pos += t <= 65535 ? 1 : 2); this.state.pos < this.length; ) {
                let i = this.codePointAtPos(this.state.pos);
                if (De(i))
                  this.state.pos += i <= 65535 ? 1 : 2;
                else if (i === 92) {
                  this.state.containsEsc = true, r += this.input.slice(s, this.state.pos);
                  let a = this.state.curPosition(), n2 = this.state.pos === e ? fe : De;
                  if (this.input.charCodeAt(++this.state.pos) !== 117) {
                    this.raise(f.MissingUnicodeEscape, { at: this.state.curPosition() }), s = this.state.pos - 1;
                    continue;
                  }
                  ++this.state.pos;
                  let o = this.readCodePoint(true);
                  o !== null && (n2(o) || this.raise(f.EscapedCharNotAnIdentifier, { at: a }), r += String.fromCodePoint(o)), s = this.state.pos;
                } else
                  break;
              }
              return r + this.input.slice(s, this.state.pos);
            }
            readWord(t) {
              let r = this.readWord1(t), e = L.get(r);
              e !== void 0 ? this.finishToken(e, xe(e)) : this.finishToken(130, r);
            }
            checkKeywordEscapes() {
              let { type: t } = this.state;
              $t(t) && this.state.containsEsc && this.raise(f.InvalidEscapedReservedWord, { at: this.state.startLoc, reservedWord: xe(t) });
            }
            raise(t, r) {
              let { at: e } = r, s = ot(r, Fl), i = e instanceof ge ? e : e.loc.start, a = t({ loc: i, details: s });
              if (!this.options.errorRecovery)
                throw a;
              return this.isLookahead || this.state.errors.push(a), a;
            }
            raiseOverwrite(t, r) {
              let { at: e } = r, s = ot(r, Ll), i = e instanceof ge ? e : e.loc.start, a = i.index, n2 = this.state.errors;
              for (let o = n2.length - 1; o >= 0; o--) {
                let u = n2[o];
                if (u.loc.index === a)
                  return n2[o] = t({ loc: i, details: s });
                if (u.loc.index < a)
                  break;
              }
              return this.raise(t, r);
            }
            updateContext(t) {
            }
            unexpected(t, r) {
              throw this.raise(f.UnexpectedToken, { expected: r ? xe(r) : null, at: t != null ? t : this.state.startLoc });
            }
            expectPlugin(t, r) {
              if (this.hasPlugin(t))
                return true;
              throw this.raise(f.MissingPlugin, { at: r != null ? r : this.state.startLoc, missingPlugin: [t] });
            }
            expectOnePlugin(t) {
              if (!t.some((r) => this.hasPlugin(r)))
                throw this.raise(f.MissingOneOfPlugins, { at: this.state.startLoc, missingPlugin: t });
            }
            errorBuilder(t) {
              return (r, e, s) => {
                this.raise(t, { at: Je(r, e, s) });
              };
            }
          }, Ml = class {
            constructor() {
              this.privateNames = /* @__PURE__ */ new Set(), this.loneAccessors = /* @__PURE__ */ new Map(), this.undefinedPrivateNames = /* @__PURE__ */ new Map();
            }
          }, _l = class {
            constructor(t) {
              this.parser = void 0, this.stack = [], this.undefinedPrivateNames = /* @__PURE__ */ new Map(), this.parser = t;
            }
            current() {
              return this.stack[this.stack.length - 1];
            }
            enter() {
              this.stack.push(new Ml());
            }
            exit() {
              let t = this.stack.pop(), r = this.current();
              for (let [e, s] of Array.from(t.undefinedPrivateNames))
                r ? r.undefinedPrivateNames.has(e) || r.undefinedPrivateNames.set(e, s) : this.parser.raise(f.InvalidPrivateFieldResolution, { at: s, identifierName: e });
            }
            declarePrivateName(t, r, e) {
              let { privateNames: s, loneAccessors: i, undefinedPrivateNames: a } = this.current(), n2 = s.has(t);
              if (r & ts) {
                let o = n2 && i.get(t);
                if (o) {
                  let u = o & yt, c = r & yt, y = o & ts, g = r & ts;
                  n2 = y === g || u !== c, n2 || i.delete(t);
                } else
                  n2 || i.set(t, r);
              }
              n2 && this.parser.raise(f.PrivateNameRedeclaration, { at: e, identifierName: t }), s.add(t), a.delete(t);
            }
            usePrivateName(t, r) {
              let e;
              for (e of this.stack)
                if (e.privateNames.has(t))
                  return;
              e ? e.undefinedPrivateNames.set(t, r) : this.parser.raise(f.InvalidPrivateFieldResolution, { at: r, identifierName: t });
            }
          }, Rl = 0, Or = 1, ls = 2, Br = 3, Pt = class {
            constructor() {
              let t = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : Rl;
              this.type = void 0, this.type = t;
            }
            canBeArrowParameterDeclaration() {
              return this.type === ls || this.type === Or;
            }
            isCertainlyParameterDeclaration() {
              return this.type === Br;
            }
          }, Mr = class extends Pt {
            constructor(t) {
              super(t), this.declarationErrors = /* @__PURE__ */ new Map();
            }
            recordDeclarationError(t, r) {
              let { at: e } = r, s = e.index;
              this.declarationErrors.set(s, [t, e]);
            }
            clearDeclarationError(t) {
              this.declarationErrors.delete(t);
            }
            iterateErrors(t) {
              this.declarationErrors.forEach(t);
            }
          }, jl = class {
            constructor(t) {
              this.parser = void 0, this.stack = [new Pt()], this.parser = t;
            }
            enter(t) {
              this.stack.push(t);
            }
            exit() {
              this.stack.pop();
            }
            recordParameterInitializerError(t, r) {
              let { at: e } = r, s = { at: e.loc.start }, { stack: i } = this, a = i.length - 1, n2 = i[a];
              for (; !n2.isCertainlyParameterDeclaration(); ) {
                if (n2.canBeArrowParameterDeclaration())
                  n2.recordDeclarationError(t, s);
                else
                  return;
                n2 = i[--a];
              }
              this.parser.raise(t, s);
            }
            recordArrowParameterBindingError(t, r) {
              let { at: e } = r, { stack: s } = this, i = s[s.length - 1], a = { at: e.loc.start };
              if (i.isCertainlyParameterDeclaration())
                this.parser.raise(t, a);
              else if (i.canBeArrowParameterDeclaration())
                i.recordDeclarationError(t, a);
              else
                return;
            }
            recordAsyncArrowParametersError(t) {
              let { at: r } = t, { stack: e } = this, s = e.length - 1, i = e[s];
              for (; i.canBeArrowParameterDeclaration(); )
                i.type === ls && i.recordDeclarationError(f.AwaitBindingIdentifier, { at: r }), i = e[--s];
            }
            validateAsPattern() {
              let { stack: t } = this, r = t[t.length - 1];
              r.canBeArrowParameterDeclaration() && r.iterateErrors((e) => {
                let [s, i] = e;
                this.parser.raise(s, { at: i });
                let a = t.length - 2, n2 = t[a];
                for (; n2.canBeArrowParameterDeclaration(); )
                  n2.clearDeclarationError(i.index), n2 = t[--a];
              });
            }
          };
          function ql() {
            return new Pt(Br);
          }
          function Ul() {
            return new Mr(Or);
          }
          function $l() {
            return new Mr(ls);
          }
          function _r() {
            return new Pt();
          }
          var Me = 0, Rr = 1, At = 2, jr = 4, _e = 8, Hl = class {
            constructor() {
              this.stacks = [];
            }
            enter(t) {
              this.stacks.push(t);
            }
            exit() {
              this.stacks.pop();
            }
            currentFlags() {
              return this.stacks[this.stacks.length - 1];
            }
            get hasAwait() {
              return (this.currentFlags() & At) > 0;
            }
            get hasYield() {
              return (this.currentFlags() & Rr) > 0;
            }
            get hasReturn() {
              return (this.currentFlags() & jr) > 0;
            }
            get hasIn() {
              return (this.currentFlags() & _e) > 0;
            }
          };
          function Tt(t, r) {
            return (t ? At : 0) | (r ? Rr : 0);
          }
          var zl = class extends Bl {
            addExtra(t, r, e) {
              let s = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : true;
              if (!t)
                return;
              let i = t.extra = t.extra || {};
              s ? i[r] = e : Object.defineProperty(i, r, { enumerable: s, value: e });
            }
            isContextual(t) {
              return this.state.type === t && !this.state.containsEsc;
            }
            isUnparsedContextual(t, r) {
              let e = t + r.length;
              if (this.input.slice(t, e) === r) {
                let s = this.input.charCodeAt(e);
                return !(De(s) || (s & 64512) === 55296);
              }
              return false;
            }
            isLookaheadContextual(t) {
              let r = this.nextTokenStart();
              return this.isUnparsedContextual(r, t);
            }
            eatContextual(t) {
              return this.isContextual(t) ? (this.next(), true) : false;
            }
            expectContextual(t, r) {
              if (!this.eatContextual(t)) {
                if (r != null)
                  throw this.raise(r, { at: this.state.startLoc });
                this.unexpected(null, t);
              }
            }
            canInsertSemicolon() {
              return this.match(137) || this.match(8) || this.hasPrecedingLineBreak();
            }
            hasPrecedingLineBreak() {
              return as.test(this.input.slice(this.state.lastTokEndLoc.index, this.state.start));
            }
            hasFollowingLineBreak() {
              return Ir.lastIndex = this.state.end, Ir.test(this.input);
            }
            isLineTerminator() {
              return this.eat(13) || this.canInsertSemicolon();
            }
            semicolon() {
              ((arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : true) ? this.isLineTerminator() : this.eat(13)) || this.raise(f.MissingSemicolon, { at: this.state.lastTokEndLoc });
            }
            expect(t, r) {
              this.eat(t) || this.unexpected(r, t);
            }
            tryParse(t) {
              let r = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : this.state.clone(), e = { node: null };
              try {
                let s = t(function() {
                  let i = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : null;
                  throw e.node = i, e;
                });
                if (this.state.errors.length > r.errors.length) {
                  let i = this.state;
                  return this.state = r, this.state.tokensLength = i.tokensLength, { node: s, error: i.errors[r.errors.length], thrown: false, aborted: false, failState: i };
                }
                return { node: s, error: null, thrown: false, aborted: false, failState: null };
              } catch (s) {
                let i = this.state;
                if (this.state = r, s instanceof SyntaxError)
                  return { node: null, error: s, thrown: true, aborted: false, failState: i };
                if (s === e)
                  return { node: e.node, error: null, thrown: false, aborted: true, failState: i };
                throw s;
              }
            }
            checkExpressionErrors(t, r) {
              if (!t)
                return false;
              let { shorthandAssignLoc: e, doubleProtoLoc: s, privateKeyLoc: i, optionalParametersLoc: a } = t, n2 = !!e || !!s || !!a || !!i;
              if (!r)
                return n2;
              e != null && this.raise(f.InvalidCoverInitializedName, { at: e }), s != null && this.raise(f.DuplicateProto, { at: s }), i != null && this.raise(f.UnexpectedPrivateField, { at: i }), a != null && this.unexpected(a);
            }
            isLiteralPropertyName() {
              return it(this.state.type);
            }
            isPrivateName(t) {
              return t.type === "PrivateName";
            }
            getPrivateNameSV(t) {
              return t.id.name;
            }
            hasPropertyAsPrivateName(t) {
              return (t.type === "MemberExpression" || t.type === "OptionalMemberExpression") && this.isPrivateName(t.property);
            }
            isObjectProperty(t) {
              return t.type === "ObjectProperty";
            }
            isObjectMethod(t) {
              return t.type === "ObjectMethod";
            }
            initializeScopes() {
              let t = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : this.options.sourceType === "module", r = this.state.labels;
              this.state.labels = [];
              let e = this.exportedIdentifiers;
              this.exportedIdentifiers = /* @__PURE__ */ new Set();
              let s = this.inModule;
              this.inModule = t;
              let i = this.scope, a = this.getScopeHandler();
              this.scope = new a(this, t);
              let n2 = this.prodParam;
              this.prodParam = new Hl();
              let o = this.classScope;
              this.classScope = new _l(this);
              let u = this.expressionScope;
              return this.expressionScope = new jl(this), () => {
                this.state.labels = r, this.exportedIdentifiers = e, this.inModule = s, this.scope = i, this.prodParam = n2, this.classScope = o, this.expressionScope = u;
              };
            }
            enterInitialScopes() {
              let t = Me;
              this.inModule && (t |= At), this.scope.enter(Le), this.prodParam.enter(t);
            }
            checkDestructuringPrivate(t) {
              let { privateKeyLoc: r } = t;
              r !== null && this.expectPlugin("destructuringPrivate", r);
            }
          }, vt = class {
            constructor() {
              this.shorthandAssignLoc = null, this.doubleProtoLoc = null, this.privateKeyLoc = null, this.optionalParametersLoc = null;
            }
          }, Et = class {
            constructor(t, r, e) {
              this.type = "", this.start = r, this.end = 0, this.loc = new lt(e), t != null && t.options.ranges && (this.range = [r, 0]), t != null && t.filename && (this.loc.filename = t.filename);
            }
          }, hs = Et.prototype;
          hs.__clone = function() {
            let t = new Et(void 0, this.start, this.loc.start), r = Object.keys(this);
            for (let e = 0, s = r.length; e < s; e++) {
              let i = r[e];
              i !== "leadingComments" && i !== "trailingComments" && i !== "innerComments" && (t[i] = this[i]);
            }
            return t;
          };
          function Vl(t) {
            return me(t);
          }
          function me(t) {
            let { type: r, start: e, end: s, loc: i, range: a, extra: n2, name: o } = t, u = Object.create(hs);
            return u.type = r, u.start = e, u.end = s, u.loc = i, u.range = a, u.extra = n2, u.name = o, r === "Placeholder" && (u.expectedNode = t.expectedNode), u;
          }
          function Kl(t) {
            let { type: r, start: e, end: s, loc: i, range: a, extra: n2 } = t;
            if (r === "Placeholder")
              return Vl(t);
            let o = Object.create(hs);
            return o.type = r, o.start = e, o.end = s, o.loc = i, o.range = a, t.raw !== void 0 ? o.raw = t.raw : o.extra = n2, o.value = t.value, o;
          }
          var Wl = class extends zl {
            startNode() {
              return new Et(this, this.state.start, this.state.startLoc);
            }
            startNodeAt(t) {
              return new Et(this, t.index, t);
            }
            startNodeAtNode(t) {
              return this.startNodeAt(t.loc.start);
            }
            finishNode(t, r) {
              return this.finishNodeAt(t, r, this.state.lastTokEndLoc);
            }
            finishNodeAt(t, r, e) {
              return t.type = r, t.end = e.index, t.loc.end = e, this.options.ranges && (t.range[1] = e.index), this.options.attachComment && this.processComment(t), t;
            }
            resetStartLocation(t, r) {
              t.start = r.index, t.loc.start = r, this.options.ranges && (t.range[0] = r.index);
            }
            resetEndLocation(t) {
              let r = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : this.state.lastTokEndLoc;
              t.end = r.index, t.loc.end = r, this.options.ranges && (t.range[1] = r.index);
            }
            resetStartLocationFromNode(t, r) {
              this.resetStartLocation(t, r.loc.start);
            }
          }, Gl = /* @__PURE__ */ new Set(["_", "any", "bool", "boolean", "empty", "extends", "false", "interface", "mixed", "null", "number", "static", "string", "true", "typeof", "void"]), D = pe`flow`({ AmbiguousConditionalArrow: "Ambiguous expression: wrap the arrow functions in parentheses to disambiguate.", AmbiguousDeclareModuleKind: "Found both `declare module.exports` and `declare export` in the same module. Modules can only have 1 since they are either an ES module or they are a CommonJS module.", AssignReservedType: (t) => {
            let { reservedType: r } = t;
            return `Cannot overwrite reserved type ${r}.`;
          }, DeclareClassElement: "The `declare` modifier can only appear on class fields.", DeclareClassFieldInitializer: "Initializers are not allowed in fields with the `declare` modifier.", DuplicateDeclareModuleExports: "Duplicate `declare module.exports` statement.", EnumBooleanMemberNotInitialized: (t) => {
            let { memberName: r, enumName: e } = t;
            return `Boolean enum members need to be initialized. Use either \`${r} = true,\` or \`${r} = false,\` in enum \`${e}\`.`;
          }, EnumDuplicateMemberName: (t) => {
            let { memberName: r, enumName: e } = t;
            return `Enum member names need to be unique, but the name \`${r}\` has already been used before in enum \`${e}\`.`;
          }, EnumInconsistentMemberValues: (t) => {
            let { enumName: r } = t;
            return `Enum \`${r}\` has inconsistent member initializers. Either use no initializers, or consistently use literals (either booleans, numbers, or strings) for all member initializers.`;
          }, EnumInvalidExplicitType: (t) => {
            let { invalidEnumType: r, enumName: e } = t;
            return `Enum type \`${r}\` is not valid. Use one of \`boolean\`, \`number\`, \`string\`, or \`symbol\` in enum \`${e}\`.`;
          }, EnumInvalidExplicitTypeUnknownSupplied: (t) => {
            let { enumName: r } = t;
            return `Supplied enum type is not valid. Use one of \`boolean\`, \`number\`, \`string\`, or \`symbol\` in enum \`${r}\`.`;
          }, EnumInvalidMemberInitializerPrimaryType: (t) => {
            let { enumName: r, memberName: e, explicitType: s } = t;
            return `Enum \`${r}\` has type \`${s}\`, so the initializer of \`${e}\` needs to be a ${s} literal.`;
          }, EnumInvalidMemberInitializerSymbolType: (t) => {
            let { enumName: r, memberName: e } = t;
            return `Symbol enum members cannot be initialized. Use \`${e},\` in enum \`${r}\`.`;
          }, EnumInvalidMemberInitializerUnknownType: (t) => {
            let { enumName: r, memberName: e } = t;
            return `The enum member initializer for \`${e}\` needs to be a literal (either a boolean, number, or string) in enum \`${r}\`.`;
          }, EnumInvalidMemberName: (t) => {
            let { enumName: r, memberName: e, suggestion: s } = t;
            return `Enum member names cannot start with lowercase 'a' through 'z'. Instead of using \`${e}\`, consider using \`${s}\`, in enum \`${r}\`.`;
          }, EnumNumberMemberNotInitialized: (t) => {
            let { enumName: r, memberName: e } = t;
            return `Number enum members need to be initialized, e.g. \`${e} = 1\` in enum \`${r}\`.`;
          }, EnumStringMemberInconsistentlyInitailized: (t) => {
            let { enumName: r } = t;
            return `String enum members need to consistently either all use initializers, or use no initializers, in enum \`${r}\`.`;
          }, GetterMayNotHaveThisParam: "A getter cannot have a `this` parameter.", ImportReflectionHasImportType: "An `import module` declaration can not use `type` or `typeof` keyword.", ImportTypeShorthandOnlyInPureImport: "The `type` and `typeof` keywords on named imports can only be used on regular `import` statements. It cannot be used with `import type` or `import typeof` statements.", InexactInsideExact: "Explicit inexact syntax cannot appear inside an explicit exact object type.", InexactInsideNonObject: "Explicit inexact syntax cannot appear in class or interface definitions.", InexactVariance: "Explicit inexact syntax cannot have variance.", InvalidNonTypeImportInDeclareModule: "Imports within a `declare module` body must always be `import type` or `import typeof`.", MissingTypeParamDefault: "Type parameter declaration needs a default, since a preceding type parameter declaration has a default.", NestedDeclareModule: "`declare module` cannot be used inside another `declare module`.", NestedFlowComment: "Cannot have a flow comment inside another flow comment.", PatternIsOptional: Object.assign({ message: "A binding pattern parameter cannot be optional in an implementation signature." }, { reasonCode: "OptionalBindingPattern" }), SetterMayNotHaveThisParam: "A setter cannot have a `this` parameter.", SpreadVariance: "Spread properties cannot have variance.", ThisParamAnnotationRequired: "A type annotation is required for the `this` parameter.", ThisParamBannedInConstructor: "Constructors cannot have a `this` parameter; constructors don't bind `this` like other functions.", ThisParamMayNotBeOptional: "The `this` parameter cannot be optional.", ThisParamMustBeFirst: "The `this` parameter must be the first function parameter.", ThisParamNoDefault: "The `this` parameter may not have a default value.", TypeBeforeInitializer: "Type annotations must come before default assignments, e.g. instead of `age = 25: number` use `age: number = 25`.", TypeCastInPattern: "The type cast expression is expected to be wrapped with parenthesis.", UnexpectedExplicitInexactInObject: "Explicit inexact syntax must appear at the end of an inexact object.", UnexpectedReservedType: (t) => {
            let { reservedType: r } = t;
            return `Unexpected reserved type ${r}.`;
          }, UnexpectedReservedUnderscore: "`_` is only allowed as a type argument to call or new.", UnexpectedSpaceBetweenModuloChecks: "Spaces between `%` and `checks` are not allowed here.", UnexpectedSpreadType: "Spread operator cannot appear in class or interface definitions.", UnexpectedSubtractionOperand: 'Unexpected token, expected "number" or "bigint".', UnexpectedTokenAfterTypeParameter: "Expected an arrow function after this type parameter declaration.", UnexpectedTypeParameterBeforeAsyncArrowFunction: "Type parameters must come after the async keyword, e.g. instead of `<T> async () => {}`, use `async <T>() => {}`.", UnsupportedDeclareExportKind: (t) => {
            let { unsupportedExportKind: r, suggestion: e } = t;
            return `\`declare export ${r}\` is not supported. Use \`${e}\` instead.`;
          }, UnsupportedStatementInDeclareModule: "Only declares and type imports are allowed inside declare module.", UnterminatedFlowComment: "Unterminated flow-comment." });
          function Jl(t) {
            return t.type === "DeclareExportAllDeclaration" || t.type === "DeclareExportDeclaration" && (!t.declaration || t.declaration.type !== "TypeAlias" && t.declaration.type !== "InterfaceDeclaration");
          }
          function us(t) {
            return t.importKind === "type" || t.importKind === "typeof";
          }
          function qr(t) {
            return te(t) && t !== 97;
          }
          var Xl = { const: "declare export var", let: "declare export var", type: "export type", interface: "export interface" };
          function Yl(t, r) {
            let e = [], s = [];
            for (let i = 0; i < t.length; i++)
              (r(t[i], i, t) ? e : s).push(t[i]);
            return [e, s];
          }
          var Ql = /\*?\s*@((?:no)?flow)\b/, Zl = (t) => class extends t {
            constructor() {
              super(...arguments), this.flowPragma = void 0;
            }
            getScopeHandler() {
              return El;
            }
            shouldParseTypes() {
              return this.getPluginOption("flow", "all") || this.flowPragma === "flow";
            }
            shouldParseEnums() {
              return !!this.getPluginOption("flow", "enums");
            }
            finishToken(e, s) {
              e !== 131 && e !== 13 && e !== 28 && this.flowPragma === void 0 && (this.flowPragma = null), super.finishToken(e, s);
            }
            addComment(e) {
              if (this.flowPragma === void 0) {
                let s = Ql.exec(e.value);
                if (s)
                  if (s[1] === "flow")
                    this.flowPragma = "flow";
                  else if (s[1] === "noflow")
                    this.flowPragma = "noflow";
                  else
                    throw new Error("Unexpected flow pragma");
              }
              super.addComment(e);
            }
            flowParseTypeInitialiser(e) {
              let s = this.state.inType;
              this.state.inType = true, this.expect(e || 14);
              let i = this.flowParseType();
              return this.state.inType = s, i;
            }
            flowParsePredicate() {
              let e = this.startNode(), s = this.state.startLoc;
              return this.next(), this.expectContextual(108), this.state.lastTokStart > s.index + 1 && this.raise(D.UnexpectedSpaceBetweenModuloChecks, { at: s }), this.eat(10) ? (e.value = super.parseExpression(), this.expect(11), this.finishNode(e, "DeclaredPredicate")) : this.finishNode(e, "InferredPredicate");
            }
            flowParseTypeAndPredicateInitialiser() {
              let e = this.state.inType;
              this.state.inType = true, this.expect(14);
              let s = null, i = null;
              return this.match(54) ? (this.state.inType = e, i = this.flowParsePredicate()) : (s = this.flowParseType(), this.state.inType = e, this.match(54) && (i = this.flowParsePredicate())), [s, i];
            }
            flowParseDeclareClass(e) {
              return this.next(), this.flowParseInterfaceish(e, true), this.finishNode(e, "DeclareClass");
            }
            flowParseDeclareFunction(e) {
              this.next();
              let s = e.id = this.parseIdentifier(), i = this.startNode(), a = this.startNode();
              this.match(47) ? i.typeParameters = this.flowParseTypeParameterDeclaration() : i.typeParameters = null, this.expect(10);
              let n2 = this.flowParseFunctionTypeParams();
              return i.params = n2.params, i.rest = n2.rest, i.this = n2._this, this.expect(11), [i.returnType, e.predicate] = this.flowParseTypeAndPredicateInitialiser(), a.typeAnnotation = this.finishNode(i, "FunctionTypeAnnotation"), s.typeAnnotation = this.finishNode(a, "TypeAnnotation"), this.resetEndLocation(s), this.semicolon(), this.scope.declareName(e.id.name, xl, e.id.loc.start), this.finishNode(e, "DeclareFunction");
            }
            flowParseDeclare(e, s) {
              if (this.match(80))
                return this.flowParseDeclareClass(e);
              if (this.match(68))
                return this.flowParseDeclareFunction(e);
              if (this.match(74))
                return this.flowParseDeclareVariable(e);
              if (this.eatContextual(125))
                return this.match(16) ? this.flowParseDeclareModuleExports(e) : (s && this.raise(D.NestedDeclareModule, { at: this.state.lastTokStartLoc }), this.flowParseDeclareModule(e));
              if (this.isContextual(128))
                return this.flowParseDeclareTypeAlias(e);
              if (this.isContextual(129))
                return this.flowParseDeclareOpaqueType(e);
              if (this.isContextual(127))
                return this.flowParseDeclareInterface(e);
              if (this.match(82))
                return this.flowParseDeclareExportDeclaration(e, s);
              this.unexpected();
            }
            flowParseDeclareVariable(e) {
              return this.next(), e.id = this.flowParseTypeAnnotatableIdentifier(true), this.scope.declareName(e.id.name, mt, e.id.loc.start), this.semicolon(), this.finishNode(e, "DeclareVariable");
            }
            flowParseDeclareModule(e) {
              this.scope.enter(Fe), this.match(131) ? e.id = super.parseExprAtom() : e.id = this.parseIdentifier();
              let s = e.body = this.startNode(), i = s.body = [];
              for (this.expect(5); !this.match(8); ) {
                let o = this.startNode();
                this.match(83) ? (this.next(), !this.isContextual(128) && !this.match(87) && this.raise(D.InvalidNonTypeImportInDeclareModule, { at: this.state.lastTokStartLoc }), super.parseImport(o)) : (this.expectContextual(123, D.UnsupportedStatementInDeclareModule), o = this.flowParseDeclare(o, true)), i.push(o);
              }
              this.scope.exit(), this.expect(8), this.finishNode(s, "BlockStatement");
              let a = null, n2 = false;
              return i.forEach((o) => {
                Jl(o) ? (a === "CommonJS" && this.raise(D.AmbiguousDeclareModuleKind, { at: o }), a = "ES") : o.type === "DeclareModuleExports" && (n2 && this.raise(D.DuplicateDeclareModuleExports, { at: o }), a === "ES" && this.raise(D.AmbiguousDeclareModuleKind, { at: o }), a = "CommonJS", n2 = true);
              }), e.kind = a || "CommonJS", this.finishNode(e, "DeclareModule");
            }
            flowParseDeclareExportDeclaration(e, s) {
              if (this.expect(82), this.eat(65))
                return this.match(68) || this.match(80) ? e.declaration = this.flowParseDeclare(this.startNode()) : (e.declaration = this.flowParseType(), this.semicolon()), e.default = true, this.finishNode(e, "DeclareExportDeclaration");
              if (this.match(75) || this.isLet() || (this.isContextual(128) || this.isContextual(127)) && !s) {
                let i = this.state.value;
                throw this.raise(D.UnsupportedDeclareExportKind, { at: this.state.startLoc, unsupportedExportKind: i, suggestion: Xl[i] });
              }
              if (this.match(74) || this.match(68) || this.match(80) || this.isContextual(129))
                return e.declaration = this.flowParseDeclare(this.startNode()), e.default = false, this.finishNode(e, "DeclareExportDeclaration");
              if (this.match(55) || this.match(5) || this.isContextual(127) || this.isContextual(128) || this.isContextual(129))
                return e = this.parseExport(e, null), e.type === "ExportNamedDeclaration" && (e.type = "ExportDeclaration", e.default = false, delete e.exportKind), e.type = "Declare" + e.type, e;
              this.unexpected();
            }
            flowParseDeclareModuleExports(e) {
              return this.next(), this.expectContextual(109), e.typeAnnotation = this.flowParseTypeAnnotation(), this.semicolon(), this.finishNode(e, "DeclareModuleExports");
            }
            flowParseDeclareTypeAlias(e) {
              this.next();
              let s = this.flowParseTypeAlias(e);
              return s.type = "DeclareTypeAlias", s;
            }
            flowParseDeclareOpaqueType(e) {
              this.next();
              let s = this.flowParseOpaqueType(e, true);
              return s.type = "DeclareOpaqueType", s;
            }
            flowParseDeclareInterface(e) {
              return this.next(), this.flowParseInterfaceish(e, false), this.finishNode(e, "DeclareInterface");
            }
            flowParseInterfaceish(e, s) {
              if (e.id = this.flowParseRestrictedIdentifier(!s, true), this.scope.declareName(e.id.name, s ? Er : Be, e.id.loc.start), this.match(47) ? e.typeParameters = this.flowParseTypeParameterDeclaration() : e.typeParameters = null, e.extends = [], e.implements = [], e.mixins = [], this.eat(81))
                do
                  e.extends.push(this.flowParseInterfaceExtends());
                while (!s && this.eat(12));
              if (s) {
                if (this.eatContextual(115))
                  do
                    e.mixins.push(this.flowParseInterfaceExtends());
                  while (this.eat(12));
                if (this.eatContextual(111))
                  do
                    e.implements.push(this.flowParseInterfaceExtends());
                  while (this.eat(12));
              }
              e.body = this.flowParseObjectType({ allowStatic: s, allowExact: false, allowSpread: false, allowProto: s, allowInexact: false });
            }
            flowParseInterfaceExtends() {
              let e = this.startNode();
              return e.id = this.flowParseQualifiedTypeIdentifier(), this.match(47) ? e.typeParameters = this.flowParseTypeParameterInstantiation() : e.typeParameters = null, this.finishNode(e, "InterfaceExtends");
            }
            flowParseInterface(e) {
              return this.flowParseInterfaceish(e, false), this.finishNode(e, "InterfaceDeclaration");
            }
            checkNotUnderscore(e) {
              e === "_" && this.raise(D.UnexpectedReservedUnderscore, { at: this.state.startLoc });
            }
            checkReservedType(e, s, i) {
              Gl.has(e) && this.raise(i ? D.AssignReservedType : D.UnexpectedReservedType, { at: s, reservedType: e });
            }
            flowParseRestrictedIdentifier(e, s) {
              return this.checkReservedType(this.state.value, this.state.startLoc, s), this.parseIdentifier(e);
            }
            flowParseTypeAlias(e) {
              return e.id = this.flowParseRestrictedIdentifier(false, true), this.scope.declareName(e.id.name, Be, e.id.loc.start), this.match(47) ? e.typeParameters = this.flowParseTypeParameterDeclaration() : e.typeParameters = null, e.right = this.flowParseTypeInitialiser(29), this.semicolon(), this.finishNode(e, "TypeAlias");
            }
            flowParseOpaqueType(e, s) {
              return this.expectContextual(128), e.id = this.flowParseRestrictedIdentifier(true, true), this.scope.declareName(e.id.name, Be, e.id.loc.start), this.match(47) ? e.typeParameters = this.flowParseTypeParameterDeclaration() : e.typeParameters = null, e.supertype = null, this.match(14) && (e.supertype = this.flowParseTypeInitialiser(14)), e.impltype = null, s || (e.impltype = this.flowParseTypeInitialiser(29)), this.semicolon(), this.finishNode(e, "OpaqueType");
            }
            flowParseTypeParameter() {
              let e = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : false, s = this.state.startLoc, i = this.startNode(), a = this.flowParseVariance(), n2 = this.flowParseTypeAnnotatableIdentifier();
              return i.name = n2.name, i.variance = a, i.bound = n2.typeAnnotation, this.match(29) ? (this.eat(29), i.default = this.flowParseType()) : e && this.raise(D.MissingTypeParamDefault, { at: s }), this.finishNode(i, "TypeParameter");
            }
            flowParseTypeParameterDeclaration() {
              let e = this.state.inType, s = this.startNode();
              s.params = [], this.state.inType = true, this.match(47) || this.match(140) ? this.next() : this.unexpected();
              let i = false;
              do {
                let a = this.flowParseTypeParameter(i);
                s.params.push(a), a.default && (i = true), this.match(48) || this.expect(12);
              } while (!this.match(48));
              return this.expect(48), this.state.inType = e, this.finishNode(s, "TypeParameterDeclaration");
            }
            flowParseTypeParameterInstantiation() {
              let e = this.startNode(), s = this.state.inType;
              e.params = [], this.state.inType = true, this.expect(47);
              let i = this.state.noAnonFunctionType;
              for (this.state.noAnonFunctionType = false; !this.match(48); )
                e.params.push(this.flowParseType()), this.match(48) || this.expect(12);
              return this.state.noAnonFunctionType = i, this.expect(48), this.state.inType = s, this.finishNode(e, "TypeParameterInstantiation");
            }
            flowParseTypeParameterInstantiationCallOrNew() {
              let e = this.startNode(), s = this.state.inType;
              for (e.params = [], this.state.inType = true, this.expect(47); !this.match(48); )
                e.params.push(this.flowParseTypeOrImplicitInstantiation()), this.match(48) || this.expect(12);
              return this.expect(48), this.state.inType = s, this.finishNode(e, "TypeParameterInstantiation");
            }
            flowParseInterfaceType() {
              let e = this.startNode();
              if (this.expectContextual(127), e.extends = [], this.eat(81))
                do
                  e.extends.push(this.flowParseInterfaceExtends());
                while (this.eat(12));
              return e.body = this.flowParseObjectType({ allowStatic: false, allowExact: false, allowSpread: false, allowProto: false, allowInexact: false }), this.finishNode(e, "InterfaceTypeAnnotation");
            }
            flowParseObjectPropertyKey() {
              return this.match(132) || this.match(131) ? super.parseExprAtom() : this.parseIdentifier(true);
            }
            flowParseObjectTypeIndexer(e, s, i) {
              return e.static = s, this.lookahead().type === 14 ? (e.id = this.flowParseObjectPropertyKey(), e.key = this.flowParseTypeInitialiser()) : (e.id = null, e.key = this.flowParseType()), this.expect(3), e.value = this.flowParseTypeInitialiser(), e.variance = i, this.finishNode(e, "ObjectTypeIndexer");
            }
            flowParseObjectTypeInternalSlot(e, s) {
              return e.static = s, e.id = this.flowParseObjectPropertyKey(), this.expect(3), this.expect(3), this.match(47) || this.match(10) ? (e.method = true, e.optional = false, e.value = this.flowParseObjectTypeMethodish(this.startNodeAt(e.loc.start))) : (e.method = false, this.eat(17) && (e.optional = true), e.value = this.flowParseTypeInitialiser()), this.finishNode(e, "ObjectTypeInternalSlot");
            }
            flowParseObjectTypeMethodish(e) {
              for (e.params = [], e.rest = null, e.typeParameters = null, e.this = null, this.match(47) && (e.typeParameters = this.flowParseTypeParameterDeclaration()), this.expect(10), this.match(78) && (e.this = this.flowParseFunctionTypeParam(true), e.this.name = null, this.match(11) || this.expect(12)); !this.match(11) && !this.match(21); )
                e.params.push(this.flowParseFunctionTypeParam(false)), this.match(11) || this.expect(12);
              return this.eat(21) && (e.rest = this.flowParseFunctionTypeParam(false)), this.expect(11), e.returnType = this.flowParseTypeInitialiser(), this.finishNode(e, "FunctionTypeAnnotation");
            }
            flowParseObjectTypeCallProperty(e, s) {
              let i = this.startNode();
              return e.static = s, e.value = this.flowParseObjectTypeMethodish(i), this.finishNode(e, "ObjectTypeCallProperty");
            }
            flowParseObjectType(e) {
              let { allowStatic: s, allowExact: i, allowSpread: a, allowProto: n2, allowInexact: o } = e, u = this.state.inType;
              this.state.inType = true;
              let c = this.startNode();
              c.callProperties = [], c.properties = [], c.indexers = [], c.internalSlots = [];
              let y, g, T = false;
              for (i && this.match(6) ? (this.expect(6), y = 9, g = true) : (this.expect(5), y = 8, g = false), c.exact = g; !this.match(y); ) {
                let M = false, j = null, K = null, W = this.startNode();
                if (n2 && this.isContextual(116)) {
                  let X = this.lookahead();
                  X.type !== 14 && X.type !== 17 && (this.next(), j = this.state.startLoc, s = false);
                }
                if (s && this.isContextual(104)) {
                  let X = this.lookahead();
                  X.type !== 14 && X.type !== 17 && (this.next(), M = true);
                }
                let V = this.flowParseVariance();
                if (this.eat(0))
                  j != null && this.unexpected(j), this.eat(0) ? (V && this.unexpected(V.loc.start), c.internalSlots.push(this.flowParseObjectTypeInternalSlot(W, M))) : c.indexers.push(this.flowParseObjectTypeIndexer(W, M, V));
                else if (this.match(10) || this.match(47))
                  j != null && this.unexpected(j), V && this.unexpected(V.loc.start), c.callProperties.push(this.flowParseObjectTypeCallProperty(W, M));
                else {
                  let X = "init";
                  if (this.isContextual(98) || this.isContextual(103)) {
                    let Nh = this.lookahead();
                    it(Nh.type) && (X = this.state.value, this.next());
                  }
                  let je = this.flowParseObjectTypeProperty(W, M, j, V, X, a, o != null ? o : !g);
                  je === null ? (T = true, K = this.state.lastTokStartLoc) : c.properties.push(je);
                }
                this.flowObjectTypeSemicolon(), K && !this.match(8) && !this.match(9) && this.raise(D.UnexpectedExplicitInexactInObject, { at: K });
              }
              this.expect(y), a && (c.inexact = T);
              let C = this.finishNode(c, "ObjectTypeAnnotation");
              return this.state.inType = u, C;
            }
            flowParseObjectTypeProperty(e, s, i, a, n2, o, u) {
              if (this.eat(21))
                return this.match(12) || this.match(13) || this.match(8) || this.match(9) ? (o ? u || this.raise(D.InexactInsideExact, { at: this.state.lastTokStartLoc }) : this.raise(D.InexactInsideNonObject, { at: this.state.lastTokStartLoc }), a && this.raise(D.InexactVariance, { at: a }), null) : (o || this.raise(D.UnexpectedSpreadType, { at: this.state.lastTokStartLoc }), i != null && this.unexpected(i), a && this.raise(D.SpreadVariance, { at: a }), e.argument = this.flowParseType(), this.finishNode(e, "ObjectTypeSpreadProperty"));
              {
                e.key = this.flowParseObjectPropertyKey(), e.static = s, e.proto = i != null, e.kind = n2;
                let c = false;
                return this.match(47) || this.match(10) ? (e.method = true, i != null && this.unexpected(i), a && this.unexpected(a.loc.start), e.value = this.flowParseObjectTypeMethodish(this.startNodeAt(e.loc.start)), (n2 === "get" || n2 === "set") && this.flowCheckGetterSetterParams(e), !o && e.key.name === "constructor" && e.value.this && this.raise(D.ThisParamBannedInConstructor, { at: e.value.this })) : (n2 !== "init" && this.unexpected(), e.method = false, this.eat(17) && (c = true), e.value = this.flowParseTypeInitialiser(), e.variance = a), e.optional = c, this.finishNode(e, "ObjectTypeProperty");
              }
            }
            flowCheckGetterSetterParams(e) {
              let s = e.kind === "get" ? 0 : 1, i = e.value.params.length + (e.value.rest ? 1 : 0);
              e.value.this && this.raise(e.kind === "get" ? D.GetterMayNotHaveThisParam : D.SetterMayNotHaveThisParam, { at: e.value.this }), i !== s && this.raise(e.kind === "get" ? f.BadGetterArity : f.BadSetterArity, { at: e }), e.kind === "set" && e.value.rest && this.raise(f.BadSetterRestParameter, { at: e });
            }
            flowObjectTypeSemicolon() {
              !this.eat(13) && !this.eat(12) && !this.match(8) && !this.match(9) && this.unexpected();
            }
            flowParseQualifiedTypeIdentifier(e, s) {
              var i;
              (i = e) != null || (e = this.state.startLoc);
              let a = s || this.flowParseRestrictedIdentifier(true);
              for (; this.eat(16); ) {
                let n2 = this.startNodeAt(e);
                n2.qualification = a, n2.id = this.flowParseRestrictedIdentifier(true), a = this.finishNode(n2, "QualifiedTypeIdentifier");
              }
              return a;
            }
            flowParseGenericType(e, s) {
              let i = this.startNodeAt(e);
              return i.typeParameters = null, i.id = this.flowParseQualifiedTypeIdentifier(e, s), this.match(47) && (i.typeParameters = this.flowParseTypeParameterInstantiation()), this.finishNode(i, "GenericTypeAnnotation");
            }
            flowParseTypeofType() {
              let e = this.startNode();
              return this.expect(87), e.argument = this.flowParsePrimaryType(), this.finishNode(e, "TypeofTypeAnnotation");
            }
            flowParseTupleType() {
              let e = this.startNode();
              for (e.types = [], this.expect(0); this.state.pos < this.length && !this.match(3) && (e.types.push(this.flowParseType()), !this.match(3)); )
                this.expect(12);
              return this.expect(3), this.finishNode(e, "TupleTypeAnnotation");
            }
            flowParseFunctionTypeParam(e) {
              let s = null, i = false, a = null, n2 = this.startNode(), o = this.lookahead(), u = this.state.type === 78;
              return o.type === 14 || o.type === 17 ? (u && !e && this.raise(D.ThisParamMustBeFirst, { at: n2 }), s = this.parseIdentifier(u), this.eat(17) && (i = true, u && this.raise(D.ThisParamMayNotBeOptional, { at: n2 })), a = this.flowParseTypeInitialiser()) : a = this.flowParseType(), n2.name = s, n2.optional = i, n2.typeAnnotation = a, this.finishNode(n2, "FunctionTypeParam");
            }
            reinterpretTypeAsFunctionTypeParam(e) {
              let s = this.startNodeAt(e.loc.start);
              return s.name = null, s.optional = false, s.typeAnnotation = e, this.finishNode(s, "FunctionTypeParam");
            }
            flowParseFunctionTypeParams() {
              let e = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : [], s = null, i = null;
              for (this.match(78) && (i = this.flowParseFunctionTypeParam(true), i.name = null, this.match(11) || this.expect(12)); !this.match(11) && !this.match(21); )
                e.push(this.flowParseFunctionTypeParam(false)), this.match(11) || this.expect(12);
              return this.eat(21) && (s = this.flowParseFunctionTypeParam(false)), { params: e, rest: s, _this: i };
            }
            flowIdentToTypeAnnotation(e, s, i) {
              switch (i.name) {
                case "any":
                  return this.finishNode(s, "AnyTypeAnnotation");
                case "bool":
                case "boolean":
                  return this.finishNode(s, "BooleanTypeAnnotation");
                case "mixed":
                  return this.finishNode(s, "MixedTypeAnnotation");
                case "empty":
                  return this.finishNode(s, "EmptyTypeAnnotation");
                case "number":
                  return this.finishNode(s, "NumberTypeAnnotation");
                case "string":
                  return this.finishNode(s, "StringTypeAnnotation");
                case "symbol":
                  return this.finishNode(s, "SymbolTypeAnnotation");
                default:
                  return this.checkNotUnderscore(i.name), this.flowParseGenericType(e, i);
              }
            }
            flowParsePrimaryType() {
              let e = this.state.startLoc, s = this.startNode(), i, a, n2 = false, o = this.state.noAnonFunctionType;
              switch (this.state.type) {
                case 5:
                  return this.flowParseObjectType({ allowStatic: false, allowExact: false, allowSpread: true, allowProto: false, allowInexact: true });
                case 6:
                  return this.flowParseObjectType({ allowStatic: false, allowExact: true, allowSpread: true, allowProto: false, allowInexact: false });
                case 0:
                  return this.state.noAnonFunctionType = false, a = this.flowParseTupleType(), this.state.noAnonFunctionType = o, a;
                case 47:
                  return s.typeParameters = this.flowParseTypeParameterDeclaration(), this.expect(10), i = this.flowParseFunctionTypeParams(), s.params = i.params, s.rest = i.rest, s.this = i._this, this.expect(11), this.expect(19), s.returnType = this.flowParseType(), this.finishNode(s, "FunctionTypeAnnotation");
                case 10:
                  if (this.next(), !this.match(11) && !this.match(21))
                    if (q(this.state.type) || this.match(78)) {
                      let u = this.lookahead().type;
                      n2 = u !== 17 && u !== 14;
                    } else
                      n2 = true;
                  if (n2) {
                    if (this.state.noAnonFunctionType = false, a = this.flowParseType(), this.state.noAnonFunctionType = o, this.state.noAnonFunctionType || !(this.match(12) || this.match(11) && this.lookahead().type === 19))
                      return this.expect(11), a;
                    this.eat(12);
                  }
                  return a ? i = this.flowParseFunctionTypeParams([this.reinterpretTypeAsFunctionTypeParam(a)]) : i = this.flowParseFunctionTypeParams(), s.params = i.params, s.rest = i.rest, s.this = i._this, this.expect(11), this.expect(19), s.returnType = this.flowParseType(), s.typeParameters = null, this.finishNode(s, "FunctionTypeAnnotation");
                case 131:
                  return this.parseLiteral(this.state.value, "StringLiteralTypeAnnotation");
                case 85:
                case 86:
                  return s.value = this.match(85), this.next(), this.finishNode(s, "BooleanLiteralTypeAnnotation");
                case 53:
                  if (this.state.value === "-") {
                    if (this.next(), this.match(132))
                      return this.parseLiteralAtNode(-this.state.value, "NumberLiteralTypeAnnotation", s);
                    if (this.match(133))
                      return this.parseLiteralAtNode(-this.state.value, "BigIntLiteralTypeAnnotation", s);
                    throw this.raise(D.UnexpectedSubtractionOperand, { at: this.state.startLoc });
                  }
                  this.unexpected();
                  return;
                case 132:
                  return this.parseLiteral(this.state.value, "NumberLiteralTypeAnnotation");
                case 133:
                  return this.parseLiteral(this.state.value, "BigIntLiteralTypeAnnotation");
                case 88:
                  return this.next(), this.finishNode(s, "VoidTypeAnnotation");
                case 84:
                  return this.next(), this.finishNode(s, "NullLiteralTypeAnnotation");
                case 78:
                  return this.next(), this.finishNode(s, "ThisTypeAnnotation");
                case 55:
                  return this.next(), this.finishNode(s, "ExistsTypeAnnotation");
                case 87:
                  return this.flowParseTypeofType();
                default:
                  if ($t(this.state.type)) {
                    let u = xe(this.state.type);
                    return this.next(), super.createIdentifier(s, u);
                  } else if (q(this.state.type))
                    return this.isContextual(127) ? this.flowParseInterfaceType() : this.flowIdentToTypeAnnotation(e, s, this.parseIdentifier());
              }
              this.unexpected();
            }
            flowParsePostfixType() {
              let e = this.state.startLoc, s = this.flowParsePrimaryType(), i = false;
              for (; (this.match(0) || this.match(18)) && !this.canInsertSemicolon(); ) {
                let a = this.startNodeAt(e), n2 = this.eat(18);
                i = i || n2, this.expect(0), !n2 && this.match(3) ? (a.elementType = s, this.next(), s = this.finishNode(a, "ArrayTypeAnnotation")) : (a.objectType = s, a.indexType = this.flowParseType(), this.expect(3), i ? (a.optional = n2, s = this.finishNode(a, "OptionalIndexedAccessType")) : s = this.finishNode(a, "IndexedAccessType"));
              }
              return s;
            }
            flowParsePrefixType() {
              let e = this.startNode();
              return this.eat(17) ? (e.typeAnnotation = this.flowParsePrefixType(), this.finishNode(e, "NullableTypeAnnotation")) : this.flowParsePostfixType();
            }
            flowParseAnonFunctionWithoutParens() {
              let e = this.flowParsePrefixType();
              if (!this.state.noAnonFunctionType && this.eat(19)) {
                let s = this.startNodeAt(e.loc.start);
                return s.params = [this.reinterpretTypeAsFunctionTypeParam(e)], s.rest = null, s.this = null, s.returnType = this.flowParseType(), s.typeParameters = null, this.finishNode(s, "FunctionTypeAnnotation");
              }
              return e;
            }
            flowParseIntersectionType() {
              let e = this.startNode();
              this.eat(45);
              let s = this.flowParseAnonFunctionWithoutParens();
              for (e.types = [s]; this.eat(45); )
                e.types.push(this.flowParseAnonFunctionWithoutParens());
              return e.types.length === 1 ? s : this.finishNode(e, "IntersectionTypeAnnotation");
            }
            flowParseUnionType() {
              let e = this.startNode();
              this.eat(43);
              let s = this.flowParseIntersectionType();
              for (e.types = [s]; this.eat(43); )
                e.types.push(this.flowParseIntersectionType());
              return e.types.length === 1 ? s : this.finishNode(e, "UnionTypeAnnotation");
            }
            flowParseType() {
              let e = this.state.inType;
              this.state.inType = true;
              let s = this.flowParseUnionType();
              return this.state.inType = e, s;
            }
            flowParseTypeOrImplicitInstantiation() {
              if (this.state.type === 130 && this.state.value === "_") {
                let e = this.state.startLoc, s = this.parseIdentifier();
                return this.flowParseGenericType(e, s);
              } else
                return this.flowParseType();
            }
            flowParseTypeAnnotation() {
              let e = this.startNode();
              return e.typeAnnotation = this.flowParseTypeInitialiser(), this.finishNode(e, "TypeAnnotation");
            }
            flowParseTypeAnnotatableIdentifier(e) {
              let s = e ? this.parseIdentifier() : this.flowParseRestrictedIdentifier();
              return this.match(14) && (s.typeAnnotation = this.flowParseTypeAnnotation(), this.resetEndLocation(s)), s;
            }
            typeCastToParameter(e) {
              return e.expression.typeAnnotation = e.typeAnnotation, this.resetEndLocation(e.expression, e.typeAnnotation.loc.end), e.expression;
            }
            flowParseVariance() {
              let e = null;
              return this.match(53) ? (e = this.startNode(), this.state.value === "+" ? e.kind = "plus" : e.kind = "minus", this.next(), this.finishNode(e, "Variance")) : e;
            }
            parseFunctionBody(e, s) {
              let i = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : false;
              if (s) {
                this.forwardNoArrowParamsConversionAt(e, () => super.parseFunctionBody(e, true, i));
                return;
              }
              super.parseFunctionBody(e, false, i);
            }
            parseFunctionBodyAndFinish(e, s) {
              let i = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : false;
              if (this.match(14)) {
                let a = this.startNode();
                [a.typeAnnotation, e.predicate] = this.flowParseTypeAndPredicateInitialiser(), e.returnType = a.typeAnnotation ? this.finishNode(a, "TypeAnnotation") : null;
              }
              return super.parseFunctionBodyAndFinish(e, s, i);
            }
            parseStatementLike(e) {
              if (this.state.strict && this.isContextual(127)) {
                let i = this.lookahead();
                if (te(i.type)) {
                  let a = this.startNode();
                  return this.next(), this.flowParseInterface(a);
                }
              } else if (this.shouldParseEnums() && this.isContextual(124)) {
                let i = this.startNode();
                return this.next(), this.flowParseEnumDeclaration(i);
              }
              let s = super.parseStatementLike(e);
              return this.flowPragma === void 0 && !this.isValidDirective(s) && (this.flowPragma = null), s;
            }
            parseExpressionStatement(e, s, i) {
              if (s.type === "Identifier") {
                if (s.name === "declare") {
                  if (this.match(80) || q(this.state.type) || this.match(68) || this.match(74) || this.match(82))
                    return this.flowParseDeclare(e);
                } else if (q(this.state.type)) {
                  if (s.name === "interface")
                    return this.flowParseInterface(e);
                  if (s.name === "type")
                    return this.flowParseTypeAlias(e);
                  if (s.name === "opaque")
                    return this.flowParseOpaqueType(e, false);
                }
              }
              return super.parseExpressionStatement(e, s, i);
            }
            shouldParseExportDeclaration() {
              let { type: e } = this.state;
              return hr(e) || this.shouldParseEnums() && e === 124 ? !this.state.containsEsc : super.shouldParseExportDeclaration();
            }
            isExportDefaultSpecifier() {
              let { type: e } = this.state;
              return hr(e) || this.shouldParseEnums() && e === 124 ? this.state.containsEsc : super.isExportDefaultSpecifier();
            }
            parseExportDefaultExpression() {
              if (this.shouldParseEnums() && this.isContextual(124)) {
                let e = this.startNode();
                return this.next(), this.flowParseEnumDeclaration(e);
              }
              return super.parseExportDefaultExpression();
            }
            parseConditional(e, s, i) {
              if (!this.match(17))
                return e;
              if (this.state.maybeInArrowParameters) {
                let T = this.lookaheadCharCode();
                if (T === 44 || T === 61 || T === 58 || T === 41)
                  return this.setOptionalParametersError(i), e;
              }
              this.expect(17);
              let a = this.state.clone(), n2 = this.state.noArrowAt, o = this.startNodeAt(s), { consequent: u, failed: c } = this.tryParseConditionalConsequent(), [y, g] = this.getArrowLikeExpressions(u);
              if (c || g.length > 0) {
                let T = [...n2];
                if (g.length > 0) {
                  this.state = a, this.state.noArrowAt = T;
                  for (let C = 0; C < g.length; C++)
                    T.push(g[C].start);
                  ({ consequent: u, failed: c } = this.tryParseConditionalConsequent()), [y, g] = this.getArrowLikeExpressions(u);
                }
                c && y.length > 1 && this.raise(D.AmbiguousConditionalArrow, { at: a.startLoc }), c && y.length === 1 && (this.state = a, T.push(y[0].start), this.state.noArrowAt = T, { consequent: u, failed: c } = this.tryParseConditionalConsequent());
              }
              return this.getArrowLikeExpressions(u, true), this.state.noArrowAt = n2, this.expect(14), o.test = e, o.consequent = u, o.alternate = this.forwardNoArrowParamsConversionAt(o, () => this.parseMaybeAssign(void 0, void 0)), this.finishNode(o, "ConditionalExpression");
            }
            tryParseConditionalConsequent() {
              this.state.noArrowParamsConversionAt.push(this.state.start);
              let e = this.parseMaybeAssignAllowIn(), s = !this.match(14);
              return this.state.noArrowParamsConversionAt.pop(), { consequent: e, failed: s };
            }
            getArrowLikeExpressions(e, s) {
              let i = [e], a = [];
              for (; i.length !== 0; ) {
                let n2 = i.pop();
                n2.type === "ArrowFunctionExpression" ? (n2.typeParameters || !n2.returnType ? this.finishArrowValidation(n2) : a.push(n2), i.push(n2.body)) : n2.type === "ConditionalExpression" && (i.push(n2.consequent), i.push(n2.alternate));
              }
              return s ? (a.forEach((n2) => this.finishArrowValidation(n2)), [a, []]) : Yl(a, (n2) => n2.params.every((o) => this.isAssignable(o, true)));
            }
            finishArrowValidation(e) {
              var s;
              this.toAssignableList(e.params, (s = e.extra) == null ? void 0 : s.trailingCommaLoc, false), this.scope.enter(de | Gt), super.checkParams(e, false, true), this.scope.exit();
            }
            forwardNoArrowParamsConversionAt(e, s) {
              let i;
              return this.state.noArrowParamsConversionAt.indexOf(e.start) !== -1 ? (this.state.noArrowParamsConversionAt.push(this.state.start), i = s(), this.state.noArrowParamsConversionAt.pop()) : i = s(), i;
            }
            parseParenItem(e, s) {
              if (e = super.parseParenItem(e, s), this.eat(17) && (e.optional = true, this.resetEndLocation(e)), this.match(14)) {
                let i = this.startNodeAt(s);
                return i.expression = e, i.typeAnnotation = this.flowParseTypeAnnotation(), this.finishNode(i, "TypeCastExpression");
              }
              return e;
            }
            assertModuleNodeAllowed(e) {
              e.type === "ImportDeclaration" && (e.importKind === "type" || e.importKind === "typeof") || e.type === "ExportNamedDeclaration" && e.exportKind === "type" || e.type === "ExportAllDeclaration" && e.exportKind === "type" || super.assertModuleNodeAllowed(e);
            }
            parseExport(e, s) {
              let i = super.parseExport(e, s);
              return (i.type === "ExportNamedDeclaration" || i.type === "ExportAllDeclaration") && (i.exportKind = i.exportKind || "value"), i;
            }
            parseExportDeclaration(e) {
              if (this.isContextual(128)) {
                e.exportKind = "type";
                let s = this.startNode();
                return this.next(), this.match(5) ? (e.specifiers = this.parseExportSpecifiers(true), super.parseExportFrom(e), null) : this.flowParseTypeAlias(s);
              } else if (this.isContextual(129)) {
                e.exportKind = "type";
                let s = this.startNode();
                return this.next(), this.flowParseOpaqueType(s, false);
              } else if (this.isContextual(127)) {
                e.exportKind = "type";
                let s = this.startNode();
                return this.next(), this.flowParseInterface(s);
              } else if (this.shouldParseEnums() && this.isContextual(124)) {
                e.exportKind = "value";
                let s = this.startNode();
                return this.next(), this.flowParseEnumDeclaration(s);
              } else
                return super.parseExportDeclaration(e);
            }
            eatExportStar(e) {
              return super.eatExportStar(e) ? true : this.isContextual(128) && this.lookahead().type === 55 ? (e.exportKind = "type", this.next(), this.next(), true) : false;
            }
            maybeParseExportNamespaceSpecifier(e) {
              let { startLoc: s } = this.state, i = super.maybeParseExportNamespaceSpecifier(e);
              return i && e.exportKind === "type" && this.unexpected(s), i;
            }
            parseClassId(e, s, i) {
              super.parseClassId(e, s, i), this.match(47) && (e.typeParameters = this.flowParseTypeParameterDeclaration());
            }
            parseClassMember(e, s, i) {
              let { startLoc: a } = this.state;
              if (this.isContextual(123)) {
                if (super.parseClassMemberFromModifier(e, s))
                  return;
                s.declare = true;
              }
              super.parseClassMember(e, s, i), s.declare && (s.type !== "ClassProperty" && s.type !== "ClassPrivateProperty" && s.type !== "PropertyDefinition" ? this.raise(D.DeclareClassElement, { at: a }) : s.value && this.raise(D.DeclareClassFieldInitializer, { at: s.value }));
            }
            isIterator(e) {
              return e === "iterator" || e === "asyncIterator";
            }
            readIterator() {
              let e = super.readWord1(), s = "@@" + e;
              (!this.isIterator(e) || !this.state.inType) && this.raise(f.InvalidIdentifier, { at: this.state.curPosition(), identifierName: s }), this.finishToken(130, s);
            }
            getTokenFromCode(e) {
              let s = this.input.charCodeAt(this.state.pos + 1);
              e === 123 && s === 124 ? this.finishOp(6, 2) : this.state.inType && (e === 62 || e === 60) ? this.finishOp(e === 62 ? 48 : 47, 1) : this.state.inType && e === 63 ? s === 46 ? this.finishOp(18, 2) : this.finishOp(17, 1) : ll(e, s, this.input.charCodeAt(this.state.pos + 2)) ? (this.state.pos += 2, this.readIterator()) : super.getTokenFromCode(e);
            }
            isAssignable(e, s) {
              return e.type === "TypeCastExpression" ? this.isAssignable(e.expression, s) : super.isAssignable(e, s);
            }
            toAssignable(e) {
              let s = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : false;
              !s && e.type === "AssignmentExpression" && e.left.type === "TypeCastExpression" && (e.left = this.typeCastToParameter(e.left)), super.toAssignable(e, s);
            }
            toAssignableList(e, s, i) {
              for (let a = 0; a < e.length; a++) {
                let n2 = e[a];
                (n2 == null ? void 0 : n2.type) === "TypeCastExpression" && (e[a] = this.typeCastToParameter(n2));
              }
              super.toAssignableList(e, s, i);
            }
            toReferencedList(e, s) {
              for (let a = 0; a < e.length; a++) {
                var i;
                let n2 = e[a];
                n2 && n2.type === "TypeCastExpression" && !((i = n2.extra) != null && i.parenthesized) && (e.length > 1 || !s) && this.raise(D.TypeCastInPattern, { at: n2.typeAnnotation });
              }
              return e;
            }
            parseArrayLike(e, s, i, a) {
              let n2 = super.parseArrayLike(e, s, i, a);
              return s && !this.state.maybeInArrowParameters && this.toReferencedList(n2.elements), n2;
            }
            isValidLVal(e, s, i) {
              return e === "TypeCastExpression" || super.isValidLVal(e, s, i);
            }
            parseClassProperty(e) {
              return this.match(14) && (e.typeAnnotation = this.flowParseTypeAnnotation()), super.parseClassProperty(e);
            }
            parseClassPrivateProperty(e) {
              return this.match(14) && (e.typeAnnotation = this.flowParseTypeAnnotation()), super.parseClassPrivateProperty(e);
            }
            isClassMethod() {
              return this.match(47) || super.isClassMethod();
            }
            isClassProperty() {
              return this.match(14) || super.isClassProperty();
            }
            isNonstaticConstructor(e) {
              return !this.match(14) && super.isNonstaticConstructor(e);
            }
            pushClassMethod(e, s, i, a, n2, o) {
              if (s.variance && this.unexpected(s.variance.loc.start), delete s.variance, this.match(47) && (s.typeParameters = this.flowParseTypeParameterDeclaration()), super.pushClassMethod(e, s, i, a, n2, o), s.params && n2) {
                let u = s.params;
                u.length > 0 && this.isThisParam(u[0]) && this.raise(D.ThisParamBannedInConstructor, { at: s });
              } else if (s.type === "MethodDefinition" && n2 && s.value.params) {
                let u = s.value.params;
                u.length > 0 && this.isThisParam(u[0]) && this.raise(D.ThisParamBannedInConstructor, { at: s });
              }
            }
            pushClassPrivateMethod(e, s, i, a) {
              s.variance && this.unexpected(s.variance.loc.start), delete s.variance, this.match(47) && (s.typeParameters = this.flowParseTypeParameterDeclaration()), super.pushClassPrivateMethod(e, s, i, a);
            }
            parseClassSuper(e) {
              if (super.parseClassSuper(e), e.superClass && this.match(47) && (e.superTypeParameters = this.flowParseTypeParameterInstantiation()), this.isContextual(111)) {
                this.next();
                let s = e.implements = [];
                do {
                  let i = this.startNode();
                  i.id = this.flowParseRestrictedIdentifier(true), this.match(47) ? i.typeParameters = this.flowParseTypeParameterInstantiation() : i.typeParameters = null, s.push(this.finishNode(i, "ClassImplements"));
                } while (this.eat(12));
              }
            }
            checkGetterSetterParams(e) {
              super.checkGetterSetterParams(e);
              let s = this.getObjectOrClassMethodParams(e);
              if (s.length > 0) {
                let i = s[0];
                this.isThisParam(i) && e.kind === "get" ? this.raise(D.GetterMayNotHaveThisParam, { at: i }) : this.isThisParam(i) && this.raise(D.SetterMayNotHaveThisParam, { at: i });
              }
            }
            parsePropertyNamePrefixOperator(e) {
              e.variance = this.flowParseVariance();
            }
            parseObjPropValue(e, s, i, a, n2, o, u) {
              e.variance && this.unexpected(e.variance.loc.start), delete e.variance;
              let c;
              this.match(47) && !o && (c = this.flowParseTypeParameterDeclaration(), this.match(10) || this.unexpected());
              let y = super.parseObjPropValue(e, s, i, a, n2, o, u);
              return c && ((y.value || y).typeParameters = c), y;
            }
            parseAssignableListItemTypes(e) {
              return this.eat(17) && (e.type !== "Identifier" && this.raise(D.PatternIsOptional, { at: e }), this.isThisParam(e) && this.raise(D.ThisParamMayNotBeOptional, { at: e }), e.optional = true), this.match(14) ? e.typeAnnotation = this.flowParseTypeAnnotation() : this.isThisParam(e) && this.raise(D.ThisParamAnnotationRequired, { at: e }), this.match(29) && this.isThisParam(e) && this.raise(D.ThisParamNoDefault, { at: e }), this.resetEndLocation(e), e;
            }
            parseMaybeDefault(e, s) {
              let i = super.parseMaybeDefault(e, s);
              return i.type === "AssignmentPattern" && i.typeAnnotation && i.right.start < i.typeAnnotation.start && this.raise(D.TypeBeforeInitializer, { at: i.typeAnnotation }), i;
            }
            shouldParseDefaultImport(e) {
              return us(e) ? qr(this.state.type) : super.shouldParseDefaultImport(e);
            }
            checkImportReflection(e) {
              super.checkImportReflection(e), e.module && e.importKind !== "value" && this.raise(D.ImportReflectionHasImportType, { at: e.specifiers[0].loc.start });
            }
            parseImportSpecifierLocal(e, s, i) {
              s.local = us(e) ? this.flowParseRestrictedIdentifier(true, true) : this.parseIdentifier(), e.specifiers.push(this.finishImportSpecifier(s, i));
            }
            maybeParseDefaultImportSpecifier(e) {
              e.importKind = "value";
              let s = null;
              if (this.match(87) ? s = "typeof" : this.isContextual(128) && (s = "type"), s) {
                let i = this.lookahead(), { type: a } = i;
                s === "type" && a === 55 && this.unexpected(null, i.type), (qr(a) || a === 5 || a === 55) && (this.next(), e.importKind = s);
              }
              return super.maybeParseDefaultImportSpecifier(e);
            }
            parseImportSpecifier(e, s, i, a, n2) {
              let o = e.imported, u = null;
              o.type === "Identifier" && (o.name === "type" ? u = "type" : o.name === "typeof" && (u = "typeof"));
              let c = false;
              if (this.isContextual(93) && !this.isLookaheadContextual("as")) {
                let g = this.parseIdentifier(true);
                u !== null && !te(this.state.type) ? (e.imported = g, e.importKind = u, e.local = me(g)) : (e.imported = o, e.importKind = null, e.local = this.parseIdentifier());
              } else {
                if (u !== null && te(this.state.type))
                  e.imported = this.parseIdentifier(true), e.importKind = u;
                else {
                  if (s)
                    throw this.raise(f.ImportBindingIsString, { at: e, importName: o.value });
                  e.imported = o, e.importKind = null;
                }
                this.eatContextual(93) ? e.local = this.parseIdentifier() : (c = true, e.local = me(e.imported));
              }
              let y = us(e);
              return i && y && this.raise(D.ImportTypeShorthandOnlyInPureImport, { at: e }), (i || y) && this.checkReservedType(e.local.name, e.local.loc.start, true), c && !i && !y && this.checkReservedWord(e.local.name, e.loc.start, true, true), this.finishImportSpecifier(e, "ImportSpecifier");
            }
            parseBindingAtom() {
              switch (this.state.type) {
                case 78:
                  return this.parseIdentifier(true);
                default:
                  return super.parseBindingAtom();
              }
            }
            parseFunctionParams(e, s) {
              let i = e.kind;
              i !== "get" && i !== "set" && this.match(47) && (e.typeParameters = this.flowParseTypeParameterDeclaration()), super.parseFunctionParams(e, s);
            }
            parseVarId(e, s) {
              super.parseVarId(e, s), this.match(14) && (e.id.typeAnnotation = this.flowParseTypeAnnotation(), this.resetEndLocation(e.id));
            }
            parseAsyncArrowFromCallExpression(e, s) {
              if (this.match(14)) {
                let i = this.state.noAnonFunctionType;
                this.state.noAnonFunctionType = true, e.returnType = this.flowParseTypeAnnotation(), this.state.noAnonFunctionType = i;
              }
              return super.parseAsyncArrowFromCallExpression(e, s);
            }
            shouldParseAsyncArrow() {
              return this.match(14) || super.shouldParseAsyncArrow();
            }
            parseMaybeAssign(e, s) {
              var i;
              let a = null, n2;
              if (this.hasPlugin("jsx") && (this.match(140) || this.match(47))) {
                if (a = this.state.clone(), n2 = this.tryParse(() => super.parseMaybeAssign(e, s), a), !n2.error)
                  return n2.node;
                let { context: c } = this.state, y = c[c.length - 1];
                (y === x.j_oTag || y === x.j_expr) && c.pop();
              }
              if ((i = n2) != null && i.error || this.match(47)) {
                var o, u;
                a = a || this.state.clone();
                let c, y = this.tryParse((T) => {
                  var C;
                  c = this.flowParseTypeParameterDeclaration();
                  let M = this.forwardNoArrowParamsConversionAt(c, () => {
                    let K = super.parseMaybeAssign(e, s);
                    return this.resetStartLocationFromNode(K, c), K;
                  });
                  (C = M.extra) != null && C.parenthesized && T();
                  let j = this.maybeUnwrapTypeCastExpression(M);
                  return j.type !== "ArrowFunctionExpression" && T(), j.typeParameters = c, this.resetStartLocationFromNode(j, c), M;
                }, a), g = null;
                if (y.node && this.maybeUnwrapTypeCastExpression(y.node).type === "ArrowFunctionExpression") {
                  if (!y.error && !y.aborted)
                    return y.node.async && this.raise(D.UnexpectedTypeParameterBeforeAsyncArrowFunction, { at: c }), y.node;
                  g = y.node;
                }
                if ((o = n2) != null && o.node)
                  return this.state = n2.failState, n2.node;
                if (g)
                  return this.state = y.failState, g;
                throw (u = n2) != null && u.thrown ? n2.error : y.thrown ? y.error : this.raise(D.UnexpectedTokenAfterTypeParameter, { at: c });
              }
              return super.parseMaybeAssign(e, s);
            }
            parseArrow(e) {
              if (this.match(14)) {
                let s = this.tryParse(() => {
                  let i = this.state.noAnonFunctionType;
                  this.state.noAnonFunctionType = true;
                  let a = this.startNode();
                  return [a.typeAnnotation, e.predicate] = this.flowParseTypeAndPredicateInitialiser(), this.state.noAnonFunctionType = i, this.canInsertSemicolon() && this.unexpected(), this.match(19) || this.unexpected(), a;
                });
                if (s.thrown)
                  return null;
                s.error && (this.state = s.failState), e.returnType = s.node.typeAnnotation ? this.finishNode(s.node, "TypeAnnotation") : null;
              }
              return super.parseArrow(e);
            }
            shouldParseArrow(e) {
              return this.match(14) || super.shouldParseArrow(e);
            }
            setArrowFunctionParameters(e, s) {
              this.state.noArrowParamsConversionAt.indexOf(e.start) !== -1 ? e.params = s : super.setArrowFunctionParameters(e, s);
            }
            checkParams(e, s, i) {
              let a = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : true;
              if (!(i && this.state.noArrowParamsConversionAt.indexOf(e.start) !== -1)) {
                for (let n2 = 0; n2 < e.params.length; n2++)
                  this.isThisParam(e.params[n2]) && n2 > 0 && this.raise(D.ThisParamMustBeFirst, { at: e.params[n2] });
                super.checkParams(e, s, i, a);
              }
            }
            parseParenAndDistinguishExpression(e) {
              return super.parseParenAndDistinguishExpression(e && this.state.noArrowAt.indexOf(this.state.start) === -1);
            }
            parseSubscripts(e, s, i) {
              if (e.type === "Identifier" && e.name === "async" && this.state.noArrowAt.indexOf(s.index) !== -1) {
                this.next();
                let a = this.startNodeAt(s);
                a.callee = e, a.arguments = super.parseCallExpressionArguments(11, false), e = this.finishNode(a, "CallExpression");
              } else if (e.type === "Identifier" && e.name === "async" && this.match(47)) {
                let a = this.state.clone(), n2 = this.tryParse((u) => this.parseAsyncArrowWithTypeParameters(s) || u(), a);
                if (!n2.error && !n2.aborted)
                  return n2.node;
                let o = this.tryParse(() => super.parseSubscripts(e, s, i), a);
                if (o.node && !o.error)
                  return o.node;
                if (n2.node)
                  return this.state = n2.failState, n2.node;
                if (o.node)
                  return this.state = o.failState, o.node;
                throw n2.error || o.error;
              }
              return super.parseSubscripts(e, s, i);
            }
            parseSubscript(e, s, i, a) {
              if (this.match(18) && this.isLookaheadToken_lt()) {
                if (a.optionalChainMember = true, i)
                  return a.stop = true, e;
                this.next();
                let n2 = this.startNodeAt(s);
                return n2.callee = e, n2.typeArguments = this.flowParseTypeParameterInstantiation(), this.expect(10), n2.arguments = this.parseCallExpressionArguments(11, false), n2.optional = true, this.finishCallExpression(n2, true);
              } else if (!i && this.shouldParseTypes() && this.match(47)) {
                let n2 = this.startNodeAt(s);
                n2.callee = e;
                let o = this.tryParse(() => (n2.typeArguments = this.flowParseTypeParameterInstantiationCallOrNew(), this.expect(10), n2.arguments = super.parseCallExpressionArguments(11, false), a.optionalChainMember && (n2.optional = false), this.finishCallExpression(n2, a.optionalChainMember)));
                if (o.node)
                  return o.error && (this.state = o.failState), o.node;
              }
              return super.parseSubscript(e, s, i, a);
            }
            parseNewCallee(e) {
              super.parseNewCallee(e);
              let s = null;
              this.shouldParseTypes() && this.match(47) && (s = this.tryParse(() => this.flowParseTypeParameterInstantiationCallOrNew()).node), e.typeArguments = s;
            }
            parseAsyncArrowWithTypeParameters(e) {
              let s = this.startNodeAt(e);
              if (this.parseFunctionParams(s, false), !!this.parseArrow(s))
                return super.parseArrowExpression(s, void 0, true);
            }
            readToken_mult_modulo(e) {
              let s = this.input.charCodeAt(this.state.pos + 1);
              if (e === 42 && s === 47 && this.state.hasFlowComment) {
                this.state.hasFlowComment = false, this.state.pos += 2, this.nextToken();
                return;
              }
              super.readToken_mult_modulo(e);
            }
            readToken_pipe_amp(e) {
              let s = this.input.charCodeAt(this.state.pos + 1);
              if (e === 124 && s === 125) {
                this.finishOp(9, 2);
                return;
              }
              super.readToken_pipe_amp(e);
            }
            parseTopLevel(e, s) {
              let i = super.parseTopLevel(e, s);
              return this.state.hasFlowComment && this.raise(D.UnterminatedFlowComment, { at: this.state.curPosition() }), i;
            }
            skipBlockComment() {
              if (this.hasPlugin("flowComments") && this.skipFlowComment()) {
                if (this.state.hasFlowComment)
                  throw this.raise(D.NestedFlowComment, { at: this.state.startLoc });
                this.hasFlowCommentCompletion();
                let e = this.skipFlowComment();
                e && (this.state.pos += e, this.state.hasFlowComment = true);
                return;
              }
              return super.skipBlockComment(this.state.hasFlowComment ? "*-/" : "*/");
            }
            skipFlowComment() {
              let { pos: e } = this.state, s = 2;
              for (; [32, 9].includes(this.input.charCodeAt(e + s)); )
                s++;
              let i = this.input.charCodeAt(s + e), a = this.input.charCodeAt(s + e + 1);
              return i === 58 && a === 58 ? s + 2 : this.input.slice(s + e, s + e + 12) === "flow-include" ? s + 12 : i === 58 && a !== 58 ? s : false;
            }
            hasFlowCommentCompletion() {
              if (this.input.indexOf("*/", this.state.pos) === -1)
                throw this.raise(f.UnterminatedComment, { at: this.state.curPosition() });
            }
            flowEnumErrorBooleanMemberNotInitialized(e, s) {
              let { enumName: i, memberName: a } = s;
              this.raise(D.EnumBooleanMemberNotInitialized, { at: e, memberName: a, enumName: i });
            }
            flowEnumErrorInvalidMemberInitializer(e, s) {
              return this.raise(s.explicitType ? s.explicitType === "symbol" ? D.EnumInvalidMemberInitializerSymbolType : D.EnumInvalidMemberInitializerPrimaryType : D.EnumInvalidMemberInitializerUnknownType, Object.assign({ at: e }, s));
            }
            flowEnumErrorNumberMemberNotInitialized(e, s) {
              let { enumName: i, memberName: a } = s;
              this.raise(D.EnumNumberMemberNotInitialized, { at: e, enumName: i, memberName: a });
            }
            flowEnumErrorStringMemberInconsistentlyInitailized(e, s) {
              let { enumName: i } = s;
              this.raise(D.EnumStringMemberInconsistentlyInitailized, { at: e, enumName: i });
            }
            flowEnumMemberInit() {
              let e = this.state.startLoc, s = () => this.match(12) || this.match(8);
              switch (this.state.type) {
                case 132: {
                  let i = this.parseNumericLiteral(this.state.value);
                  return s() ? { type: "number", loc: i.loc.start, value: i } : { type: "invalid", loc: e };
                }
                case 131: {
                  let i = this.parseStringLiteral(this.state.value);
                  return s() ? { type: "string", loc: i.loc.start, value: i } : { type: "invalid", loc: e };
                }
                case 85:
                case 86: {
                  let i = this.parseBooleanLiteral(this.match(85));
                  return s() ? { type: "boolean", loc: i.loc.start, value: i } : { type: "invalid", loc: e };
                }
                default:
                  return { type: "invalid", loc: e };
              }
            }
            flowEnumMemberRaw() {
              let e = this.state.startLoc, s = this.parseIdentifier(true), i = this.eat(29) ? this.flowEnumMemberInit() : { type: "none", loc: e };
              return { id: s, init: i };
            }
            flowEnumCheckExplicitTypeMismatch(e, s, i) {
              let { explicitType: a } = s;
              a !== null && a !== i && this.flowEnumErrorInvalidMemberInitializer(e, s);
            }
            flowEnumMembers(e) {
              let { enumName: s, explicitType: i } = e, a = /* @__PURE__ */ new Set(), n2 = { booleanMembers: [], numberMembers: [], stringMembers: [], defaultedMembers: [] }, o = false;
              for (; !this.match(8); ) {
                if (this.eat(21)) {
                  o = true;
                  break;
                }
                let u = this.startNode(), { id: c, init: y } = this.flowEnumMemberRaw(), g = c.name;
                if (g === "")
                  continue;
                /^[a-z]/.test(g) && this.raise(D.EnumInvalidMemberName, { at: c, memberName: g, suggestion: g[0].toUpperCase() + g.slice(1), enumName: s }), a.has(g) && this.raise(D.EnumDuplicateMemberName, { at: c, memberName: g, enumName: s }), a.add(g);
                let T = { enumName: s, explicitType: i, memberName: g };
                switch (u.id = c, y.type) {
                  case "boolean": {
                    this.flowEnumCheckExplicitTypeMismatch(y.loc, T, "boolean"), u.init = y.value, n2.booleanMembers.push(this.finishNode(u, "EnumBooleanMember"));
                    break;
                  }
                  case "number": {
                    this.flowEnumCheckExplicitTypeMismatch(y.loc, T, "number"), u.init = y.value, n2.numberMembers.push(this.finishNode(u, "EnumNumberMember"));
                    break;
                  }
                  case "string": {
                    this.flowEnumCheckExplicitTypeMismatch(y.loc, T, "string"), u.init = y.value, n2.stringMembers.push(this.finishNode(u, "EnumStringMember"));
                    break;
                  }
                  case "invalid":
                    throw this.flowEnumErrorInvalidMemberInitializer(y.loc, T);
                  case "none":
                    switch (i) {
                      case "boolean":
                        this.flowEnumErrorBooleanMemberNotInitialized(y.loc, T);
                        break;
                      case "number":
                        this.flowEnumErrorNumberMemberNotInitialized(y.loc, T);
                        break;
                      default:
                        n2.defaultedMembers.push(this.finishNode(u, "EnumDefaultedMember"));
                    }
                }
                this.match(8) || this.expect(12);
              }
              return { members: n2, hasUnknownMembers: o };
            }
            flowEnumStringMembers(e, s, i) {
              let { enumName: a } = i;
              if (e.length === 0)
                return s;
              if (s.length === 0)
                return e;
              if (s.length > e.length) {
                for (let n2 of e)
                  this.flowEnumErrorStringMemberInconsistentlyInitailized(n2, { enumName: a });
                return s;
              } else {
                for (let n2 of s)
                  this.flowEnumErrorStringMemberInconsistentlyInitailized(n2, { enumName: a });
                return e;
              }
            }
            flowEnumParseExplicitType(e) {
              let { enumName: s } = e;
              if (!this.eatContextual(101))
                return null;
              if (!q(this.state.type))
                throw this.raise(D.EnumInvalidExplicitTypeUnknownSupplied, { at: this.state.startLoc, enumName: s });
              let { value: i } = this.state;
              return this.next(), i !== "boolean" && i !== "number" && i !== "string" && i !== "symbol" && this.raise(D.EnumInvalidExplicitType, { at: this.state.startLoc, enumName: s, invalidEnumType: i }), i;
            }
            flowEnumBody(e, s) {
              let i = s.name, a = s.loc.start, n2 = this.flowEnumParseExplicitType({ enumName: i });
              this.expect(5);
              let { members: o, hasUnknownMembers: u } = this.flowEnumMembers({ enumName: i, explicitType: n2 });
              switch (e.hasUnknownMembers = u, n2) {
                case "boolean":
                  return e.explicitType = true, e.members = o.booleanMembers, this.expect(8), this.finishNode(e, "EnumBooleanBody");
                case "number":
                  return e.explicitType = true, e.members = o.numberMembers, this.expect(8), this.finishNode(e, "EnumNumberBody");
                case "string":
                  return e.explicitType = true, e.members = this.flowEnumStringMembers(o.stringMembers, o.defaultedMembers, { enumName: i }), this.expect(8), this.finishNode(e, "EnumStringBody");
                case "symbol":
                  return e.members = o.defaultedMembers, this.expect(8), this.finishNode(e, "EnumSymbolBody");
                default: {
                  let c = () => (e.members = [], this.expect(8), this.finishNode(e, "EnumStringBody"));
                  e.explicitType = false;
                  let y = o.booleanMembers.length, g = o.numberMembers.length, T = o.stringMembers.length, C = o.defaultedMembers.length;
                  if (!y && !g && !T && !C)
                    return c();
                  if (!y && !g)
                    return e.members = this.flowEnumStringMembers(o.stringMembers, o.defaultedMembers, { enumName: i }), this.expect(8), this.finishNode(e, "EnumStringBody");
                  if (!g && !T && y >= C) {
                    for (let M of o.defaultedMembers)
                      this.flowEnumErrorBooleanMemberNotInitialized(M.loc.start, { enumName: i, memberName: M.id.name });
                    return e.members = o.booleanMembers, this.expect(8), this.finishNode(e, "EnumBooleanBody");
                  } else if (!y && !T && g >= C) {
                    for (let M of o.defaultedMembers)
                      this.flowEnumErrorNumberMemberNotInitialized(M.loc.start, { enumName: i, memberName: M.id.name });
                    return e.members = o.numberMembers, this.expect(8), this.finishNode(e, "EnumNumberBody");
                  } else
                    return this.raise(D.EnumInconsistentMemberValues, { at: a, enumName: i }), c();
                }
              }
            }
            flowParseEnumDeclaration(e) {
              let s = this.parseIdentifier();
              return e.id = s, e.body = this.flowEnumBody(this.startNode(), s), this.finishNode(e, "EnumDeclaration");
            }
            isLookaheadToken_lt() {
              let e = this.nextTokenStart();
              if (this.input.charCodeAt(e) === 60) {
                let s = this.input.charCodeAt(e + 1);
                return s !== 60 && s !== 61;
              }
              return false;
            }
            maybeUnwrapTypeCastExpression(e) {
              return e.type === "TypeCastExpression" ? e.expression : e;
            }
          }, eh = { __proto__: null, quot: '"', amp: "&", apos: "'", lt: "<", gt: ">", nbsp: "\xA0", iexcl: "\xA1", cent: "\xA2", pound: "\xA3", curren: "\xA4", yen: "\xA5", brvbar: "\xA6", sect: "\xA7", uml: "\xA8", copy: "\xA9", ordf: "\xAA", laquo: "\xAB", not: "\xAC", shy: "\xAD", reg: "\xAE", macr: "\xAF", deg: "\xB0", plusmn: "\xB1", sup2: "\xB2", sup3: "\xB3", acute: "\xB4", micro: "\xB5", para: "\xB6", middot: "\xB7", cedil: "\xB8", sup1: "\xB9", ordm: "\xBA", raquo: "\xBB", frac14: "\xBC", frac12: "\xBD", frac34: "\xBE", iquest: "\xBF", Agrave: "\xC0", Aacute: "\xC1", Acirc: "\xC2", Atilde: "\xC3", Auml: "\xC4", Aring: "\xC5", AElig: "\xC6", Ccedil: "\xC7", Egrave: "\xC8", Eacute: "\xC9", Ecirc: "\xCA", Euml: "\xCB", Igrave: "\xCC", Iacute: "\xCD", Icirc: "\xCE", Iuml: "\xCF", ETH: "\xD0", Ntilde: "\xD1", Ograve: "\xD2", Oacute: "\xD3", Ocirc: "\xD4", Otilde: "\xD5", Ouml: "\xD6", times: "\xD7", Oslash: "\xD8", Ugrave: "\xD9", Uacute: "\xDA", Ucirc: "\xDB", Uuml: "\xDC", Yacute: "\xDD", THORN: "\xDE", szlig: "\xDF", agrave: "\xE0", aacute: "\xE1", acirc: "\xE2", atilde: "\xE3", auml: "\xE4", aring: "\xE5", aelig: "\xE6", ccedil: "\xE7", egrave: "\xE8", eacute: "\xE9", ecirc: "\xEA", euml: "\xEB", igrave: "\xEC", iacute: "\xED", icirc: "\xEE", iuml: "\xEF", eth: "\xF0", ntilde: "\xF1", ograve: "\xF2", oacute: "\xF3", ocirc: "\xF4", otilde: "\xF5", ouml: "\xF6", divide: "\xF7", oslash: "\xF8", ugrave: "\xF9", uacute: "\xFA", ucirc: "\xFB", uuml: "\xFC", yacute: "\xFD", thorn: "\xFE", yuml: "\xFF", OElig: "\u0152", oelig: "\u0153", Scaron: "\u0160", scaron: "\u0161", Yuml: "\u0178", fnof: "\u0192", circ: "\u02C6", tilde: "\u02DC", Alpha: "\u0391", Beta: "\u0392", Gamma: "\u0393", Delta: "\u0394", Epsilon: "\u0395", Zeta: "\u0396", Eta: "\u0397", Theta: "\u0398", Iota: "\u0399", Kappa: "\u039A", Lambda: "\u039B", Mu: "\u039C", Nu: "\u039D", Xi: "\u039E", Omicron: "\u039F", Pi: "\u03A0", Rho: "\u03A1", Sigma: "\u03A3", Tau: "\u03A4", Upsilon: "\u03A5", Phi: "\u03A6", Chi: "\u03A7", Psi: "\u03A8", Omega: "\u03A9", alpha: "\u03B1", beta: "\u03B2", gamma: "\u03B3", delta: "\u03B4", epsilon: "\u03B5", zeta: "\u03B6", eta: "\u03B7", theta: "\u03B8", iota: "\u03B9", kappa: "\u03BA", lambda: "\u03BB", mu: "\u03BC", nu: "\u03BD", xi: "\u03BE", omicron: "\u03BF", pi: "\u03C0", rho: "\u03C1", sigmaf: "\u03C2", sigma: "\u03C3", tau: "\u03C4", upsilon: "\u03C5", phi: "\u03C6", chi: "\u03C7", psi: "\u03C8", omega: "\u03C9", thetasym: "\u03D1", upsih: "\u03D2", piv: "\u03D6", ensp: "\u2002", emsp: "\u2003", thinsp: "\u2009", zwnj: "\u200C", zwj: "\u200D", lrm: "\u200E", rlm: "\u200F", ndash: "\u2013", mdash: "\u2014", lsquo: "\u2018", rsquo: "\u2019", sbquo: "\u201A", ldquo: "\u201C", rdquo: "\u201D", bdquo: "\u201E", dagger: "\u2020", Dagger: "\u2021", bull: "\u2022", hellip: "\u2026", permil: "\u2030", prime: "\u2032", Prime: "\u2033", lsaquo: "\u2039", rsaquo: "\u203A", oline: "\u203E", frasl: "\u2044", euro: "\u20AC", image: "\u2111", weierp: "\u2118", real: "\u211C", trade: "\u2122", alefsym: "\u2135", larr: "\u2190", uarr: "\u2191", rarr: "\u2192", darr: "\u2193", harr: "\u2194", crarr: "\u21B5", lArr: "\u21D0", uArr: "\u21D1", rArr: "\u21D2", dArr: "\u21D3", hArr: "\u21D4", forall: "\u2200", part: "\u2202", exist: "\u2203", empty: "\u2205", nabla: "\u2207", isin: "\u2208", notin: "\u2209", ni: "\u220B", prod: "\u220F", sum: "\u2211", minus: "\u2212", lowast: "\u2217", radic: "\u221A", prop: "\u221D", infin: "\u221E", ang: "\u2220", and: "\u2227", or: "\u2228", cap: "\u2229", cup: "\u222A", int: "\u222B", there4: "\u2234", sim: "\u223C", cong: "\u2245", asymp: "\u2248", ne: "\u2260", equiv: "\u2261", le: "\u2264", ge: "\u2265", sub: "\u2282", sup: "\u2283", nsub: "\u2284", sube: "\u2286", supe: "\u2287", oplus: "\u2295", otimes: "\u2297", perp: "\u22A5", sdot: "\u22C5", lceil: "\u2308", rceil: "\u2309", lfloor: "\u230A", rfloor: "\u230B", lang: "\u2329", rang: "\u232A", loz: "\u25CA", spades: "\u2660", clubs: "\u2663", hearts: "\u2665", diams: "\u2666" }, Se = pe`jsx`({ AttributeIsEmpty: "JSX attributes must only be assigned a non-empty expression.", MissingClosingTagElement: (t) => {
            let { openingTagName: r } = t;
            return `Expected corresponding JSX closing tag for <${r}>.`;
          }, MissingClosingTagFragment: "Expected corresponding JSX closing tag for <>.", UnexpectedSequenceExpression: "Sequence expressions cannot be directly nested inside JSX. Did you mean to wrap it in parentheses (...)?", UnexpectedToken: (t) => {
            let { unexpected: r, HTMLEntity: e } = t;
            return `Unexpected token \`${r}\`. Did you mean \`${e}\` or \`{'${r}'}\`?`;
          }, UnsupportedJsxValue: "JSX value should be either an expression or a quoted JSX text.", UnterminatedJsxContent: "Unterminated JSX contents.", UnwrappedAdjacentJSXElements: "Adjacent JSX elements must be wrapped in an enclosing tag. Did you want a JSX fragment <>...</>?" });
          function Te(t) {
            return t ? t.type === "JSXOpeningFragment" || t.type === "JSXClosingFragment" : false;
          }
          function Re(t) {
            if (t.type === "JSXIdentifier")
              return t.name;
            if (t.type === "JSXNamespacedName")
              return t.namespace.name + ":" + t.name.name;
            if (t.type === "JSXMemberExpression")
              return Re(t.object) + "." + Re(t.property);
            throw new Error("Node had unexpected type: " + t.type);
          }
          var th = (t) => class extends t {
            jsxReadToken() {
              let e = "", s = this.state.pos;
              for (; ; ) {
                if (this.state.pos >= this.length)
                  throw this.raise(Se.UnterminatedJsxContent, { at: this.state.startLoc });
                let i = this.input.charCodeAt(this.state.pos);
                switch (i) {
                  case 60:
                  case 123:
                    if (this.state.pos === this.state.start) {
                      i === 60 && this.state.canStartJSXElement ? (++this.state.pos, this.finishToken(140)) : super.getTokenFromCode(i);
                      return;
                    }
                    e += this.input.slice(s, this.state.pos), this.finishToken(139, e);
                    return;
                  case 38:
                    e += this.input.slice(s, this.state.pos), e += this.jsxReadEntity(), s = this.state.pos;
                    break;
                  case 62:
                  case 125:
                  default:
                    Ge(i) ? (e += this.input.slice(s, this.state.pos), e += this.jsxReadNewLine(true), s = this.state.pos) : ++this.state.pos;
                }
              }
            }
            jsxReadNewLine(e) {
              let s = this.input.charCodeAt(this.state.pos), i;
              return ++this.state.pos, s === 13 && this.input.charCodeAt(this.state.pos) === 10 ? (++this.state.pos, i = e ? `
` : `\r
`) : i = String.fromCharCode(s), ++this.state.curLine, this.state.lineStart = this.state.pos, i;
            }
            jsxReadString(e) {
              let s = "", i = ++this.state.pos;
              for (; ; ) {
                if (this.state.pos >= this.length)
                  throw this.raise(f.UnterminatedString, { at: this.state.startLoc });
                let a = this.input.charCodeAt(this.state.pos);
                if (a === e)
                  break;
                a === 38 ? (s += this.input.slice(i, this.state.pos), s += this.jsxReadEntity(), i = this.state.pos) : Ge(a) ? (s += this.input.slice(i, this.state.pos), s += this.jsxReadNewLine(false), i = this.state.pos) : ++this.state.pos;
              }
              s += this.input.slice(i, this.state.pos++), this.finishToken(131, s);
            }
            jsxReadEntity() {
              let e = ++this.state.pos;
              if (this.codePointAtPos(this.state.pos) === 35) {
                ++this.state.pos;
                let s = 10;
                this.codePointAtPos(this.state.pos) === 120 && (s = 16, ++this.state.pos);
                let i = this.readInt(s, void 0, false, "bail");
                if (i !== null && this.codePointAtPos(this.state.pos) === 59)
                  return ++this.state.pos, String.fromCodePoint(i);
              } else {
                let s = 0, i = false;
                for (; s++ < 10 && this.state.pos < this.length && !(i = this.codePointAtPos(this.state.pos) == 59); )
                  ++this.state.pos;
                if (i) {
                  let a = this.input.slice(e, this.state.pos), n2 = eh[a];
                  if (++this.state.pos, n2)
                    return n2;
                }
              }
              return this.state.pos = e, "&";
            }
            jsxReadWord() {
              let e, s = this.state.pos;
              do
                e = this.input.charCodeAt(++this.state.pos);
              while (De(e) || e === 45);
              this.finishToken(138, this.input.slice(s, this.state.pos));
            }
            jsxParseIdentifier() {
              let e = this.startNode();
              return this.match(138) ? e.name = this.state.value : $t(this.state.type) ? e.name = xe(this.state.type) : this.unexpected(), this.next(), this.finishNode(e, "JSXIdentifier");
            }
            jsxParseNamespacedName() {
              let e = this.state.startLoc, s = this.jsxParseIdentifier();
              if (!this.eat(14))
                return s;
              let i = this.startNodeAt(e);
              return i.namespace = s, i.name = this.jsxParseIdentifier(), this.finishNode(i, "JSXNamespacedName");
            }
            jsxParseElementName() {
              let e = this.state.startLoc, s = this.jsxParseNamespacedName();
              if (s.type === "JSXNamespacedName")
                return s;
              for (; this.eat(16); ) {
                let i = this.startNodeAt(e);
                i.object = s, i.property = this.jsxParseIdentifier(), s = this.finishNode(i, "JSXMemberExpression");
              }
              return s;
            }
            jsxParseAttributeValue() {
              let e;
              switch (this.state.type) {
                case 5:
                  return e = this.startNode(), this.setContext(x.brace), this.next(), e = this.jsxParseExpressionContainer(e, x.j_oTag), e.expression.type === "JSXEmptyExpression" && this.raise(Se.AttributeIsEmpty, { at: e }), e;
                case 140:
                case 131:
                  return this.parseExprAtom();
                default:
                  throw this.raise(Se.UnsupportedJsxValue, { at: this.state.startLoc });
              }
            }
            jsxParseEmptyExpression() {
              let e = this.startNodeAt(this.state.lastTokEndLoc);
              return this.finishNodeAt(e, "JSXEmptyExpression", this.state.startLoc);
            }
            jsxParseSpreadChild(e) {
              return this.next(), e.expression = this.parseExpression(), this.setContext(x.j_expr), this.state.canStartJSXElement = true, this.expect(8), this.finishNode(e, "JSXSpreadChild");
            }
            jsxParseExpressionContainer(e, s) {
              if (this.match(8))
                e.expression = this.jsxParseEmptyExpression();
              else {
                let i = this.parseExpression();
                e.expression = i;
              }
              return this.setContext(s), this.state.canStartJSXElement = true, this.expect(8), this.finishNode(e, "JSXExpressionContainer");
            }
            jsxParseAttribute() {
              let e = this.startNode();
              return this.match(5) ? (this.setContext(x.brace), this.next(), this.expect(21), e.argument = this.parseMaybeAssignAllowIn(), this.setContext(x.j_oTag), this.state.canStartJSXElement = true, this.expect(8), this.finishNode(e, "JSXSpreadAttribute")) : (e.name = this.jsxParseNamespacedName(), e.value = this.eat(29) ? this.jsxParseAttributeValue() : null, this.finishNode(e, "JSXAttribute"));
            }
            jsxParseOpeningElementAt(e) {
              let s = this.startNodeAt(e);
              return this.eat(141) ? this.finishNode(s, "JSXOpeningFragment") : (s.name = this.jsxParseElementName(), this.jsxParseOpeningElementAfterName(s));
            }
            jsxParseOpeningElementAfterName(e) {
              let s = [];
              for (; !this.match(56) && !this.match(141); )
                s.push(this.jsxParseAttribute());
              return e.attributes = s, e.selfClosing = this.eat(56), this.expect(141), this.finishNode(e, "JSXOpeningElement");
            }
            jsxParseClosingElementAt(e) {
              let s = this.startNodeAt(e);
              return this.eat(141) ? this.finishNode(s, "JSXClosingFragment") : (s.name = this.jsxParseElementName(), this.expect(141), this.finishNode(s, "JSXClosingElement"));
            }
            jsxParseElementAt(e) {
              let s = this.startNodeAt(e), i = [], a = this.jsxParseOpeningElementAt(e), n2 = null;
              if (!a.selfClosing) {
                e:
                  for (; ; )
                    switch (this.state.type) {
                      case 140:
                        if (e = this.state.startLoc, this.next(), this.eat(56)) {
                          n2 = this.jsxParseClosingElementAt(e);
                          break e;
                        }
                        i.push(this.jsxParseElementAt(e));
                        break;
                      case 139:
                        i.push(this.parseExprAtom());
                        break;
                      case 5: {
                        let o = this.startNode();
                        this.setContext(x.brace), this.next(), this.match(21) ? i.push(this.jsxParseSpreadChild(o)) : i.push(this.jsxParseExpressionContainer(o, x.j_expr));
                        break;
                      }
                      default:
                        this.unexpected();
                    }
                Te(a) && !Te(n2) && n2 !== null ? this.raise(Se.MissingClosingTagFragment, { at: n2 }) : !Te(a) && Te(n2) ? this.raise(Se.MissingClosingTagElement, { at: n2, openingTagName: Re(a.name) }) : !Te(a) && !Te(n2) && Re(n2.name) !== Re(a.name) && this.raise(Se.MissingClosingTagElement, { at: n2, openingTagName: Re(a.name) });
              }
              if (Te(a) ? (s.openingFragment = a, s.closingFragment = n2) : (s.openingElement = a, s.closingElement = n2), s.children = i, this.match(47))
                throw this.raise(Se.UnwrappedAdjacentJSXElements, { at: this.state.startLoc });
              return Te(a) ? this.finishNode(s, "JSXFragment") : this.finishNode(s, "JSXElement");
            }
            jsxParseElement() {
              let e = this.state.startLoc;
              return this.next(), this.jsxParseElementAt(e);
            }
            setContext(e) {
              let { context: s } = this.state;
              s[s.length - 1] = e;
            }
            parseExprAtom(e) {
              return this.match(139) ? this.parseLiteral(this.state.value, "JSXText") : this.match(140) ? this.jsxParseElement() : this.match(47) && this.input.charCodeAt(this.state.pos) !== 33 ? (this.replaceToken(140), this.jsxParseElement()) : super.parseExprAtom(e);
            }
            skipSpace() {
              this.curContext().preserveSpace || super.skipSpace();
            }
            getTokenFromCode(e) {
              let s = this.curContext();
              if (s === x.j_expr) {
                this.jsxReadToken();
                return;
              }
              if (s === x.j_oTag || s === x.j_cTag) {
                if (fe(e)) {
                  this.jsxReadWord();
                  return;
                }
                if (e === 62) {
                  ++this.state.pos, this.finishToken(141);
                  return;
                }
                if ((e === 34 || e === 39) && s === x.j_oTag) {
                  this.jsxReadString(e);
                  return;
                }
              }
              if (e === 60 && this.state.canStartJSXElement && this.input.charCodeAt(this.state.pos + 1) !== 33) {
                ++this.state.pos, this.finishToken(140);
                return;
              }
              super.getTokenFromCode(e);
            }
            updateContext(e) {
              let { context: s, type: i } = this.state;
              if (i === 56 && e === 140)
                s.splice(-2, 2, x.j_cTag), this.state.canStartJSXElement = false;
              else if (i === 140)
                s.push(x.j_oTag);
              else if (i === 141) {
                let a = s[s.length - 1];
                a === x.j_oTag && e === 56 || a === x.j_cTag ? (s.pop(), this.state.canStartJSXElement = s[s.length - 1] === x.j_expr) : (this.setContext(x.j_expr), this.state.canStartJSXElement = true);
              } else
                this.state.canStartJSXElement = se(i);
            }
          }, sh = class extends rs {
            constructor() {
              super(...arguments), this.types = /* @__PURE__ */ new Set(), this.enums = /* @__PURE__ */ new Set(), this.constEnums = /* @__PURE__ */ new Set(), this.classes = /* @__PURE__ */ new Set(), this.exportOnlyBindings = /* @__PURE__ */ new Set();
            }
          }, rh = class extends is {
            constructor() {
              super(...arguments), this.importsStack = [];
            }
            createScope(t) {
              return this.importsStack.push(/* @__PURE__ */ new Set()), new sh(t);
            }
            enter(t) {
              t == Oe && this.importsStack.push(/* @__PURE__ */ new Set()), super.enter(t);
            }
            exit() {
              let t = super.exit();
              return t == Oe && this.importsStack.pop(), t;
            }
            hasImport(t, r) {
              let e = this.importsStack.length;
              if (this.importsStack[e - 1].has(t))
                return true;
              if (!r && e > 1) {
                for (let s = 0; s < e - 1; s++)
                  if (this.importsStack[s].has(t))
                    return true;
              }
              return false;
            }
            declareName(t, r, e) {
              if (r & Ve) {
                this.hasImport(t, true) && this.parser.raise(f.VarRedeclaration, { at: e, identifierName: t }), this.importsStack[this.importsStack.length - 1].add(t);
                return;
              }
              let s = this.currentScope();
              if (r & Yt) {
                this.maybeExportDefined(s, t), s.exportOnlyBindings.add(t);
                return;
              }
              super.declareName(t, r, e), r & Ce && (r & le || (this.checkRedeclarationInScope(s, t, r, e), this.maybeExportDefined(s, t)), s.types.add(t)), r & Jt && s.enums.add(t), r & Xt && s.constEnums.add(t), r & ft && s.classes.add(t);
            }
            isRedeclaredInScope(t, r, e) {
              if (t.enums.has(r)) {
                if (e & Jt) {
                  let s = !!(e & Xt), i = t.constEnums.has(r);
                  return s !== i;
                }
                return true;
              }
              return e & ft && t.classes.has(r) ? t.lexical.has(r) ? !!(e & le) : false : e & Ce && t.types.has(r) ? true : super.isRedeclaredInScope(t, r, e);
            }
            checkLocalExport(t) {
              let { name: r } = t;
              if (this.hasImport(r))
                return;
              let e = this.scopeStack.length;
              for (let s = e - 1; s >= 0; s--) {
                let i = this.scopeStack[s];
                if (i.types.has(r) || i.exportOnlyBindings.has(r))
                  return;
              }
              super.checkLocalExport(t);
            }
          }, ih = (t, r) => Object.hasOwnProperty.call(t, r) && t[r], Ur = (t) => t.type === "ParenthesizedExpression" ? Ur(t.expression) : t, ah = class extends Wl {
            toAssignable(t) {
              let r = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : false;
              var e, s;
              let i;
              switch ((t.type === "ParenthesizedExpression" || (e = t.extra) != null && e.parenthesized) && (i = Ur(t), r ? i.type === "Identifier" ? this.expressionScope.recordArrowParameterBindingError(f.InvalidParenthesizedAssignment, { at: t }) : i.type !== "MemberExpression" && this.raise(f.InvalidParenthesizedAssignment, { at: t }) : this.raise(f.InvalidParenthesizedAssignment, { at: t })), t.type) {
                case "Identifier":
                case "ObjectPattern":
                case "ArrayPattern":
                case "AssignmentPattern":
                case "RestElement":
                  break;
                case "ObjectExpression":
                  t.type = "ObjectPattern";
                  for (let n2 = 0, o = t.properties.length, u = o - 1; n2 < o; n2++) {
                    var a;
                    let c = t.properties[n2], y = n2 === u;
                    this.toAssignableObjectExpressionProp(c, y, r), y && c.type === "RestElement" && (a = t.extra) != null && a.trailingCommaLoc && this.raise(f.RestTrailingComma, { at: t.extra.trailingCommaLoc });
                  }
                  break;
                case "ObjectProperty": {
                  let { key: n2, value: o } = t;
                  this.isPrivateName(n2) && this.classScope.usePrivateName(this.getPrivateNameSV(n2), n2.loc.start), this.toAssignable(o, r);
                  break;
                }
                case "SpreadElement":
                  throw new Error("Internal @babel/parser error (this is a bug, please report it). SpreadElement should be converted by .toAssignable's caller.");
                case "ArrayExpression":
                  t.type = "ArrayPattern", this.toAssignableList(t.elements, (s = t.extra) == null ? void 0 : s.trailingCommaLoc, r);
                  break;
                case "AssignmentExpression":
                  t.operator !== "=" && this.raise(f.MissingEqInAssignment, { at: t.left.loc.end }), t.type = "AssignmentPattern", delete t.operator, this.toAssignable(t.left, r);
                  break;
                case "ParenthesizedExpression":
                  this.toAssignable(i, r);
                  break;
              }
            }
            toAssignableObjectExpressionProp(t, r, e) {
              if (t.type === "ObjectMethod")
                this.raise(t.kind === "get" || t.kind === "set" ? f.PatternHasAccessor : f.PatternHasMethod, { at: t.key });
              else if (t.type === "SpreadElement") {
                t.type = "RestElement";
                let s = t.argument;
                this.checkToRestConversion(s, false), this.toAssignable(s, e), r || this.raise(f.RestTrailingComma, { at: t });
              } else
                this.toAssignable(t, e);
            }
            toAssignableList(t, r, e) {
              let s = t.length - 1;
              for (let i = 0; i <= s; i++) {
                let a = t[i];
                if (a) {
                  if (a.type === "SpreadElement") {
                    a.type = "RestElement";
                    let n2 = a.argument;
                    this.checkToRestConversion(n2, true), this.toAssignable(n2, e);
                  } else
                    this.toAssignable(a, e);
                  a.type === "RestElement" && (i < s ? this.raise(f.RestTrailingComma, { at: a }) : r && this.raise(f.RestTrailingComma, { at: r }));
                }
              }
            }
            isAssignable(t, r) {
              switch (t.type) {
                case "Identifier":
                case "ObjectPattern":
                case "ArrayPattern":
                case "AssignmentPattern":
                case "RestElement":
                  return true;
                case "ObjectExpression": {
                  let e = t.properties.length - 1;
                  return t.properties.every((s, i) => s.type !== "ObjectMethod" && (i === e || s.type !== "SpreadElement") && this.isAssignable(s));
                }
                case "ObjectProperty":
                  return this.isAssignable(t.value);
                case "SpreadElement":
                  return this.isAssignable(t.argument);
                case "ArrayExpression":
                  return t.elements.every((e) => e === null || this.isAssignable(e));
                case "AssignmentExpression":
                  return t.operator === "=";
                case "ParenthesizedExpression":
                  return this.isAssignable(t.expression);
                case "MemberExpression":
                case "OptionalMemberExpression":
                  return !r;
                default:
                  return false;
              }
            }
            toReferencedList(t, r) {
              return t;
            }
            toReferencedListDeep(t, r) {
              this.toReferencedList(t, r);
              for (let e of t)
                (e == null ? void 0 : e.type) === "ArrayExpression" && this.toReferencedListDeep(e.elements);
            }
            parseSpread(t) {
              let r = this.startNode();
              return this.next(), r.argument = this.parseMaybeAssignAllowIn(t, void 0), this.finishNode(r, "SpreadElement");
            }
            parseRestBinding() {
              let t = this.startNode();
              return this.next(), t.argument = this.parseBindingAtom(), this.finishNode(t, "RestElement");
            }
            parseBindingAtom() {
              switch (this.state.type) {
                case 0: {
                  let t = this.startNode();
                  return this.next(), t.elements = this.parseBindingList(3, 93, 1), this.finishNode(t, "ArrayPattern");
                }
                case 5:
                  return this.parseObjectLike(8, true);
              }
              return this.parseIdentifier();
            }
            parseBindingList(t, r, e) {
              let s = e & 1, i = [], a = true;
              for (; !this.eat(t); )
                if (a ? a = false : this.expect(12), s && this.match(12))
                  i.push(null);
                else {
                  if (this.eat(t))
                    break;
                  if (this.match(21)) {
                    if (i.push(this.parseAssignableListItemTypes(this.parseRestBinding(), e)), !this.checkCommaAfterRest(r)) {
                      this.expect(t);
                      break;
                    }
                  } else {
                    let n2 = [];
                    for (this.match(26) && this.hasPlugin("decorators") && this.raise(f.UnsupportedParameterDecorator, { at: this.state.startLoc }); this.match(26); )
                      n2.push(this.parseDecorator());
                    i.push(this.parseAssignableListItem(e, n2));
                  }
                }
              return i;
            }
            parseBindingRestProperty(t) {
              return this.next(), t.argument = this.parseIdentifier(), this.checkCommaAfterRest(125), this.finishNode(t, "RestElement");
            }
            parseBindingProperty() {
              let t = this.startNode(), { type: r, startLoc: e } = this.state;
              return r === 21 ? this.parseBindingRestProperty(t) : (r === 136 ? (this.expectPlugin("destructuringPrivate", e), this.classScope.usePrivateName(this.state.value, e), t.key = this.parsePrivateName()) : this.parsePropertyName(t), t.method = false, this.parseObjPropValue(t, e, false, false, true, false));
            }
            parseAssignableListItem(t, r) {
              let e = this.parseMaybeDefault();
              this.parseAssignableListItemTypes(e, t);
              let s = this.parseMaybeDefault(e.loc.start, e);
              return r.length && (e.decorators = r), s;
            }
            parseAssignableListItemTypes(t, r) {
              return t;
            }
            parseMaybeDefault(t, r) {
              var e, s;
              if ((e = t) != null || (t = this.state.startLoc), r = (s = r) != null ? s : this.parseBindingAtom(), !this.eat(29))
                return r;
              let i = this.startNodeAt(t);
              return i.left = r, i.right = this.parseMaybeAssignAllowIn(), this.finishNode(i, "AssignmentPattern");
            }
            isValidLVal(t, r, e) {
              return ih({ AssignmentPattern: "left", RestElement: "argument", ObjectProperty: "value", ParenthesizedExpression: "expression", ArrayPattern: "elements", ObjectPattern: "properties" }, t);
            }
            checkLVal(t, r) {
              let { in: e, binding: s = Pe, checkClashes: i = false, strictModeChanged: a = false, hasParenthesizedAncestor: n2 = false } = r;
              var o;
              let u = t.type;
              if (this.isObjectMethod(t))
                return;
              if (u === "MemberExpression") {
                s !== Pe && this.raise(f.InvalidPropertyBindingPattern, { at: t });
                return;
              }
              if (u === "Identifier") {
                this.checkIdentifier(t, s, a);
                let { name: C } = t;
                i && (i.has(C) ? this.raise(f.ParamDupe, { at: t }) : i.add(C));
                return;
              }
              let c = this.isValidLVal(u, !(n2 || (o = t.extra) != null && o.parenthesized) && e.type === "AssignmentExpression", s);
              if (c === true)
                return;
              if (c === false) {
                let C = s === Pe ? f.InvalidLhs : f.InvalidLhsBinding;
                this.raise(C, { at: t, ancestor: e });
                return;
              }
              let [y, g] = Array.isArray(c) ? c : [c, u === "ParenthesizedExpression"], T = u === "ArrayPattern" || u === "ObjectPattern" || u === "ParenthesizedExpression" ? { type: u } : e;
              for (let C of [].concat(t[y]))
                C && this.checkLVal(C, { in: T, binding: s, checkClashes: i, strictModeChanged: a, hasParenthesizedAncestor: g });
            }
            checkIdentifier(t, r) {
              let e = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : false;
              this.state.strict && (e ? xr(t.name, this.inModule) : yr(t.name)) && (r === Pe ? this.raise(f.StrictEvalArguments, { at: t, referenceName: t.name }) : this.raise(f.StrictEvalArgumentsBinding, { at: t, bindingName: t.name })), r & dt && t.name === "let" && this.raise(f.LetInLexicalBinding, { at: t }), r & Pe || this.declareNameFromIdentifier(t, r);
            }
            declareNameFromIdentifier(t, r) {
              this.scope.declareName(t.name, r, t.loc.start);
            }
            checkToRestConversion(t, r) {
              switch (t.type) {
                case "ParenthesizedExpression":
                  this.checkToRestConversion(t.expression, r);
                  break;
                case "Identifier":
                case "MemberExpression":
                  break;
                case "ArrayExpression":
                case "ObjectExpression":
                  if (r)
                    break;
                default:
                  this.raise(f.InvalidRestAssignmentPattern, { at: t });
              }
            }
            checkCommaAfterRest(t) {
              return this.match(12) ? (this.raise(this.lookaheadCharCode() === t ? f.RestTrailingComma : f.ElementAfterRest, { at: this.state.startLoc }), true) : false;
            }
          }, nh = (t, r) => Object.hasOwnProperty.call(t, r) && t[r];
          function oh(t) {
            if (t == null)
              throw new Error(`Unexpected ${t} value.`);
            return t;
          }
          function $r(t) {
            if (!t)
              throw new Error("Assert fail");
          }
          var I = pe`typescript`({ AbstractMethodHasImplementation: (t) => {
            let { methodName: r } = t;
            return `Method '${r}' cannot have an implementation because it is marked abstract.`;
          }, AbstractPropertyHasInitializer: (t) => {
            let { propertyName: r } = t;
            return `Property '${r}' cannot have an initializer because it is marked abstract.`;
          }, AccesorCannotDeclareThisParameter: "'get' and 'set' accessors cannot declare 'this' parameters.", AccesorCannotHaveTypeParameters: "An accessor cannot have type parameters.", AccessorCannotBeOptional: "An 'accessor' property cannot be declared optional.", ClassMethodHasDeclare: "Class methods cannot have the 'declare' modifier.", ClassMethodHasReadonly: "Class methods cannot have the 'readonly' modifier.", ConstInitiailizerMustBeStringOrNumericLiteralOrLiteralEnumReference: "A 'const' initializer in an ambient context must be a string or numeric literal or literal enum reference.", ConstructorHasTypeParameters: "Type parameters cannot appear on a constructor declaration.", DeclareAccessor: (t) => {
            let { kind: r } = t;
            return `'declare' is not allowed in ${r}ters.`;
          }, DeclareClassFieldHasInitializer: "Initializers are not allowed in ambient contexts.", DeclareFunctionHasImplementation: "An implementation cannot be declared in ambient contexts.", DuplicateAccessibilityModifier: (t) => {
            let { modifier: r } = t;
            return "Accessibility modifier already seen.";
          }, DuplicateModifier: (t) => {
            let { modifier: r } = t;
            return `Duplicate modifier: '${r}'.`;
          }, EmptyHeritageClauseType: (t) => {
            let { token: r } = t;
            return `'${r}' list cannot be empty.`;
          }, EmptyTypeArguments: "Type argument list cannot be empty.", EmptyTypeParameters: "Type parameter list cannot be empty.", ExpectedAmbientAfterExportDeclare: "'export declare' must be followed by an ambient declaration.", ImportAliasHasImportType: "An import alias can not use 'import type'.", ImportReflectionHasImportType: "An `import module` declaration can not use `type` modifier", IncompatibleModifiers: (t) => {
            let { modifiers: r } = t;
            return `'${r[0]}' modifier cannot be used with '${r[1]}' modifier.`;
          }, IndexSignatureHasAbstract: "Index signatures cannot have the 'abstract' modifier.", IndexSignatureHasAccessibility: (t) => {
            let { modifier: r } = t;
            return `Index signatures cannot have an accessibility modifier ('${r}').`;
          }, IndexSignatureHasDeclare: "Index signatures cannot have the 'declare' modifier.", IndexSignatureHasOverride: "'override' modifier cannot appear on an index signature.", IndexSignatureHasStatic: "Index signatures cannot have the 'static' modifier.", InitializerNotAllowedInAmbientContext: "Initializers are not allowed in ambient contexts.", InvalidModifierOnTypeMember: (t) => {
            let { modifier: r } = t;
            return `'${r}' modifier cannot appear on a type member.`;
          }, InvalidModifierOnTypeParameter: (t) => {
            let { modifier: r } = t;
            return `'${r}' modifier cannot appear on a type parameter.`;
          }, InvalidModifierOnTypeParameterPositions: (t) => {
            let { modifier: r } = t;
            return `'${r}' modifier can only appear on a type parameter of a class, interface or type alias.`;
          }, InvalidModifiersOrder: (t) => {
            let { orderedModifiers: r } = t;
            return `'${r[0]}' modifier must precede '${r[1]}' modifier.`;
          }, InvalidPropertyAccessAfterInstantiationExpression: "Invalid property access after an instantiation expression. You can either wrap the instantiation expression in parentheses, or delete the type arguments.", InvalidTupleMemberLabel: "Tuple members must be labeled with a simple identifier.", MissingInterfaceName: "'interface' declarations must be followed by an identifier.", MixedLabeledAndUnlabeledElements: "Tuple members must all have names or all not have names.", NonAbstractClassHasAbstractMethod: "Abstract methods can only appear within an abstract class.", NonClassMethodPropertyHasAbstractModifer: "'abstract' modifier can only appear on a class, method, or property declaration.", OptionalTypeBeforeRequired: "A required element cannot follow an optional element.", OverrideNotInSubClass: "This member cannot have an 'override' modifier because its containing class does not extend another class.", PatternIsOptional: "A binding pattern parameter cannot be optional in an implementation signature.", PrivateElementHasAbstract: "Private elements cannot have the 'abstract' modifier.", PrivateElementHasAccessibility: (t) => {
            let { modifier: r } = t;
            return `Private elements cannot have an accessibility modifier ('${r}').`;
          }, ReadonlyForMethodSignature: "'readonly' modifier can only appear on a property declaration or index signature.", ReservedArrowTypeParam: "This syntax is reserved in files with the .mts or .cts extension. Add a trailing comma, as in `<T,>() => ...`.", ReservedTypeAssertion: "This syntax is reserved in files with the .mts or .cts extension. Use an `as` expression instead.", SetAccesorCannotHaveOptionalParameter: "A 'set' accessor cannot have an optional parameter.", SetAccesorCannotHaveRestParameter: "A 'set' accessor cannot have rest parameter.", SetAccesorCannotHaveReturnType: "A 'set' accessor cannot have a return type annotation.", SingleTypeParameterWithoutTrailingComma: (t) => {
            let { typeParameterName: r } = t;
            return `Single type parameter ${r} should have a trailing comma. Example usage: <${r},>.`;
          }, StaticBlockCannotHaveModifier: "Static class blocks cannot have any modifier.", TupleOptionalAfterType: "A labeled tuple optional element must be declared using a question mark after the name and before the colon (`name?: type`), rather than after the type (`name: type?`).", TypeAnnotationAfterAssign: "Type annotations must come before default assignments, e.g. instead of `age = 25: number` use `age: number = 25`.", TypeImportCannotSpecifyDefaultAndNamed: "A type-only import can specify a default import or named bindings, but not both.", TypeModifierIsUsedInTypeExports: "The 'type' modifier cannot be used on a named export when 'export type' is used on its export statement.", TypeModifierIsUsedInTypeImports: "The 'type' modifier cannot be used on a named import when 'import type' is used on its import statement.", UnexpectedParameterModifier: "A parameter property is only allowed in a constructor implementation.", UnexpectedReadonly: "'readonly' type modifier is only permitted on array and tuple literal types.", UnexpectedTypeAnnotation: "Did not expect a type annotation here.", UnexpectedTypeCastInParameter: "Unexpected type cast in parameter position.", UnsupportedImportTypeArgument: "Argument in a type import must be a string literal.", UnsupportedParameterPropertyKind: "A parameter property may not be declared using a binding pattern.", UnsupportedSignatureParameterKind: (t) => {
            let { type: r } = t;
            return `Name in a signature must be an Identifier, ObjectPattern or ArrayPattern, instead got ${r}.`;
          } });
          function lh(t) {
            switch (t) {
              case "any":
                return "TSAnyKeyword";
              case "boolean":
                return "TSBooleanKeyword";
              case "bigint":
                return "TSBigIntKeyword";
              case "never":
                return "TSNeverKeyword";
              case "number":
                return "TSNumberKeyword";
              case "object":
                return "TSObjectKeyword";
              case "string":
                return "TSStringKeyword";
              case "symbol":
                return "TSSymbolKeyword";
              case "undefined":
                return "TSUndefinedKeyword";
              case "unknown":
                return "TSUnknownKeyword";
              default:
                return;
            }
          }
          function Hr(t) {
            return t === "private" || t === "public" || t === "protected";
          }
          function hh(t) {
            return t === "in" || t === "out";
          }
          var uh = (t) => class extends t {
            constructor() {
              super(...arguments), this.tsParseInOutModifiers = this.tsParseModifiers.bind(this, { allowedModifiers: ["in", "out"], disallowedModifiers: ["const", "public", "private", "protected", "readonly", "declare", "abstract", "override"], errorTemplate: I.InvalidModifierOnTypeParameter }), this.tsParseConstModifier = this.tsParseModifiers.bind(this, { allowedModifiers: ["const"], disallowedModifiers: ["in", "out"], errorTemplate: I.InvalidModifierOnTypeParameterPositions }), this.tsParseInOutConstModifiers = this.tsParseModifiers.bind(this, { allowedModifiers: ["in", "out", "const"], disallowedModifiers: ["public", "private", "protected", "readonly", "declare", "abstract", "override"], errorTemplate: I.InvalidModifierOnTypeParameter });
            }
            getScopeHandler() {
              return rh;
            }
            tsIsIdentifier() {
              return q(this.state.type);
            }
            tsTokenCanFollowModifier() {
              return (this.match(0) || this.match(5) || this.match(55) || this.match(21) || this.match(136) || this.isLiteralPropertyName()) && !this.hasPrecedingLineBreak();
            }
            tsNextTokenCanFollowModifier() {
              return this.next(), this.tsTokenCanFollowModifier();
            }
            tsParseModifier(e, s) {
              if (!q(this.state.type) && this.state.type !== 58 && this.state.type !== 75)
                return;
              let i = this.state.value;
              if (e.indexOf(i) !== -1) {
                if (s && this.tsIsStartOfStaticBlocks())
                  return;
                if (this.tsTryParse(this.tsNextTokenCanFollowModifier.bind(this)))
                  return i;
              }
            }
            tsParseModifiers(e, s) {
              let { allowedModifiers: i, disallowedModifiers: a, stopOnStartOfClassStaticBlock: n2, errorTemplate: o = I.InvalidModifierOnTypeMember } = e, u = (y, g, T, C) => {
                g === T && s[C] && this.raise(I.InvalidModifiersOrder, { at: y, orderedModifiers: [T, C] });
              }, c = (y, g, T, C) => {
                (s[T] && g === C || s[C] && g === T) && this.raise(I.IncompatibleModifiers, { at: y, modifiers: [T, C] });
              };
              for (; ; ) {
                let { startLoc: y } = this.state, g = this.tsParseModifier(i.concat(a != null ? a : []), n2);
                if (!g)
                  break;
                Hr(g) ? s.accessibility ? this.raise(I.DuplicateAccessibilityModifier, { at: y, modifier: g }) : (u(y, g, g, "override"), u(y, g, g, "static"), u(y, g, g, "readonly"), s.accessibility = g) : hh(g) ? (s[g] && this.raise(I.DuplicateModifier, { at: y, modifier: g }), s[g] = true, u(y, g, "in", "out")) : (Object.hasOwnProperty.call(s, g) ? this.raise(I.DuplicateModifier, { at: y, modifier: g }) : (u(y, g, "static", "readonly"), u(y, g, "static", "override"), u(y, g, "override", "readonly"), u(y, g, "abstract", "override"), c(y, g, "declare", "override"), c(y, g, "static", "abstract")), s[g] = true), a != null && a.includes(g) && this.raise(o, { at: y, modifier: g });
              }
            }
            tsIsListTerminator(e) {
              switch (e) {
                case "EnumMembers":
                case "TypeMembers":
                  return this.match(8);
                case "HeritageClauseElement":
                  return this.match(5);
                case "TupleElementTypes":
                  return this.match(3);
                case "TypeParametersOrArguments":
                  return this.match(48);
              }
            }
            tsParseList(e, s) {
              let i = [];
              for (; !this.tsIsListTerminator(e); )
                i.push(s());
              return i;
            }
            tsParseDelimitedList(e, s, i) {
              return oh(this.tsParseDelimitedListWorker(e, s, true, i));
            }
            tsParseDelimitedListWorker(e, s, i, a) {
              let n2 = [], o = -1;
              for (; !this.tsIsListTerminator(e); ) {
                o = -1;
                let u = s();
                if (u == null)
                  return;
                if (n2.push(u), this.eat(12)) {
                  o = this.state.lastTokStart;
                  continue;
                }
                if (this.tsIsListTerminator(e))
                  break;
                i && this.expect(12);
                return;
              }
              return a && (a.value = o), n2;
            }
            tsParseBracketedList(e, s, i, a, n2) {
              a || (i ? this.expect(0) : this.expect(47));
              let o = this.tsParseDelimitedList(e, s, n2);
              return i ? this.expect(3) : this.expect(48), o;
            }
            tsParseImportType() {
              let e = this.startNode();
              return this.expect(83), this.expect(10), this.match(131) || this.raise(I.UnsupportedImportTypeArgument, { at: this.state.startLoc }), e.argument = super.parseExprAtom(), this.expect(11), this.eat(16) && (e.qualifier = this.tsParseEntityName()), this.match(47) && (e.typeParameters = this.tsParseTypeArguments()), this.finishNode(e, "TSImportType");
            }
            tsParseEntityName() {
              let e = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : true, s = this.parseIdentifier(e);
              for (; this.eat(16); ) {
                let i = this.startNodeAtNode(s);
                i.left = s, i.right = this.parseIdentifier(e), s = this.finishNode(i, "TSQualifiedName");
              }
              return s;
            }
            tsParseTypeReference() {
              let e = this.startNode();
              return e.typeName = this.tsParseEntityName(), !this.hasPrecedingLineBreak() && this.match(47) && (e.typeParameters = this.tsParseTypeArguments()), this.finishNode(e, "TSTypeReference");
            }
            tsParseThisTypePredicate(e) {
              this.next();
              let s = this.startNodeAtNode(e);
              return s.parameterName = e, s.typeAnnotation = this.tsParseTypeAnnotation(false), s.asserts = false, this.finishNode(s, "TSTypePredicate");
            }
            tsParseThisTypeNode() {
              let e = this.startNode();
              return this.next(), this.finishNode(e, "TSThisType");
            }
            tsParseTypeQuery() {
              let e = this.startNode();
              return this.expect(87), this.match(83) ? e.exprName = this.tsParseImportType() : e.exprName = this.tsParseEntityName(), !this.hasPrecedingLineBreak() && this.match(47) && (e.typeParameters = this.tsParseTypeArguments()), this.finishNode(e, "TSTypeQuery");
            }
            tsParseTypeParameter(e) {
              let s = this.startNode();
              return e(s), s.name = this.tsParseTypeParameterName(), s.constraint = this.tsEatThenParseType(81), s.default = this.tsEatThenParseType(29), this.finishNode(s, "TSTypeParameter");
            }
            tsTryParseTypeParameters(e) {
              if (this.match(47))
                return this.tsParseTypeParameters(e);
            }
            tsParseTypeParameters(e) {
              let s = this.startNode();
              this.match(47) || this.match(140) ? this.next() : this.unexpected();
              let i = { value: -1 };
              return s.params = this.tsParseBracketedList("TypeParametersOrArguments", this.tsParseTypeParameter.bind(this, e), false, true, i), s.params.length === 0 && this.raise(I.EmptyTypeParameters, { at: s }), i.value !== -1 && this.addExtra(s, "trailingComma", i.value), this.finishNode(s, "TSTypeParameterDeclaration");
            }
            tsFillSignature(e, s) {
              let i = e === 19, a = "parameters", n2 = "typeAnnotation";
              s.typeParameters = this.tsTryParseTypeParameters(this.tsParseConstModifier), this.expect(10), s[a] = this.tsParseBindingListForSignature(), i ? s[n2] = this.tsParseTypeOrTypePredicateAnnotation(e) : this.match(e) && (s[n2] = this.tsParseTypeOrTypePredicateAnnotation(e));
            }
            tsParseBindingListForSignature() {
              return super.parseBindingList(11, 41, 2).map((e) => (e.type !== "Identifier" && e.type !== "RestElement" && e.type !== "ObjectPattern" && e.type !== "ArrayPattern" && this.raise(I.UnsupportedSignatureParameterKind, { at: e, type: e.type }), e));
            }
            tsParseTypeMemberSemicolon() {
              !this.eat(12) && !this.isLineTerminator() && this.expect(13);
            }
            tsParseSignatureMember(e, s) {
              return this.tsFillSignature(14, s), this.tsParseTypeMemberSemicolon(), this.finishNode(s, e);
            }
            tsIsUnambiguouslyIndexSignature() {
              return this.next(), q(this.state.type) ? (this.next(), this.match(14)) : false;
            }
            tsTryParseIndexSignature(e) {
              if (!(this.match(0) && this.tsLookAhead(this.tsIsUnambiguouslyIndexSignature.bind(this))))
                return;
              this.expect(0);
              let s = this.parseIdentifier();
              s.typeAnnotation = this.tsParseTypeAnnotation(), this.resetEndLocation(s), this.expect(3), e.parameters = [s];
              let i = this.tsTryParseTypeAnnotation();
              return i && (e.typeAnnotation = i), this.tsParseTypeMemberSemicolon(), this.finishNode(e, "TSIndexSignature");
            }
            tsParsePropertyOrMethodSignature(e, s) {
              this.eat(17) && (e.optional = true);
              let i = e;
              if (this.match(10) || this.match(47)) {
                s && this.raise(I.ReadonlyForMethodSignature, { at: e });
                let a = i;
                a.kind && this.match(47) && this.raise(I.AccesorCannotHaveTypeParameters, { at: this.state.curPosition() }), this.tsFillSignature(14, a), this.tsParseTypeMemberSemicolon();
                let n2 = "parameters", o = "typeAnnotation";
                if (a.kind === "get")
                  a[n2].length > 0 && (this.raise(f.BadGetterArity, { at: this.state.curPosition() }), this.isThisParam(a[n2][0]) && this.raise(I.AccesorCannotDeclareThisParameter, { at: this.state.curPosition() }));
                else if (a.kind === "set") {
                  if (a[n2].length !== 1)
                    this.raise(f.BadSetterArity, { at: this.state.curPosition() });
                  else {
                    let u = a[n2][0];
                    this.isThisParam(u) && this.raise(I.AccesorCannotDeclareThisParameter, { at: this.state.curPosition() }), u.type === "Identifier" && u.optional && this.raise(I.SetAccesorCannotHaveOptionalParameter, { at: this.state.curPosition() }), u.type === "RestElement" && this.raise(I.SetAccesorCannotHaveRestParameter, { at: this.state.curPosition() });
                  }
                  a[o] && this.raise(I.SetAccesorCannotHaveReturnType, { at: a[o] });
                } else
                  a.kind = "method";
                return this.finishNode(a, "TSMethodSignature");
              } else {
                let a = i;
                s && (a.readonly = true);
                let n2 = this.tsTryParseTypeAnnotation();
                return n2 && (a.typeAnnotation = n2), this.tsParseTypeMemberSemicolon(), this.finishNode(a, "TSPropertySignature");
              }
            }
            tsParseTypeMember() {
              let e = this.startNode();
              if (this.match(10) || this.match(47))
                return this.tsParseSignatureMember("TSCallSignatureDeclaration", e);
              if (this.match(77)) {
                let i = this.startNode();
                return this.next(), this.match(10) || this.match(47) ? this.tsParseSignatureMember("TSConstructSignatureDeclaration", e) : (e.key = this.createIdentifier(i, "new"), this.tsParsePropertyOrMethodSignature(e, false));
              }
              this.tsParseModifiers({ allowedModifiers: ["readonly"], disallowedModifiers: ["declare", "abstract", "private", "protected", "public", "static", "override"] }, e);
              let s = this.tsTryParseIndexSignature(e);
              return s || (super.parsePropertyName(e), !e.computed && e.key.type === "Identifier" && (e.key.name === "get" || e.key.name === "set") && this.tsTokenCanFollowModifier() && (e.kind = e.key.name, super.parsePropertyName(e)), this.tsParsePropertyOrMethodSignature(e, !!e.readonly));
            }
            tsParseTypeLiteral() {
              let e = this.startNode();
              return e.members = this.tsParseObjectTypeMembers(), this.finishNode(e, "TSTypeLiteral");
            }
            tsParseObjectTypeMembers() {
              this.expect(5);
              let e = this.tsParseList("TypeMembers", this.tsParseTypeMember.bind(this));
              return this.expect(8), e;
            }
            tsIsStartOfMappedType() {
              return this.next(), this.eat(53) ? this.isContextual(120) : (this.isContextual(120) && this.next(), !this.match(0) || (this.next(), !this.tsIsIdentifier()) ? false : (this.next(), this.match(58)));
            }
            tsParseMappedTypeParameter() {
              let e = this.startNode();
              return e.name = this.tsParseTypeParameterName(), e.constraint = this.tsExpectThenParseType(58), this.finishNode(e, "TSTypeParameter");
            }
            tsParseMappedType() {
              let e = this.startNode();
              return this.expect(5), this.match(53) ? (e.readonly = this.state.value, this.next(), this.expectContextual(120)) : this.eatContextual(120) && (e.readonly = true), this.expect(0), e.typeParameter = this.tsParseMappedTypeParameter(), e.nameType = this.eatContextual(93) ? this.tsParseType() : null, this.expect(3), this.match(53) ? (e.optional = this.state.value, this.next(), this.expect(17)) : this.eat(17) && (e.optional = true), e.typeAnnotation = this.tsTryParseType(), this.semicolon(), this.expect(8), this.finishNode(e, "TSMappedType");
            }
            tsParseTupleType() {
              let e = this.startNode();
              e.elementTypes = this.tsParseBracketedList("TupleElementTypes", this.tsParseTupleElementType.bind(this), true, false);
              let s = false, i = null;
              return e.elementTypes.forEach((a) => {
                var n2;
                let { type: o } = a;
                s && o !== "TSRestType" && o !== "TSOptionalType" && !(o === "TSNamedTupleMember" && a.optional) && this.raise(I.OptionalTypeBeforeRequired, { at: a }), s || (s = o === "TSNamedTupleMember" && a.optional || o === "TSOptionalType");
                let u = o;
                o === "TSRestType" && (a = a.typeAnnotation, u = a.type);
                let c = u === "TSNamedTupleMember";
                (n2 = i) != null || (i = c), i !== c && this.raise(I.MixedLabeledAndUnlabeledElements, { at: a });
              }), this.finishNode(e, "TSTupleType");
            }
            tsParseTupleElementType() {
              let { startLoc: e } = this.state, s = this.eat(21), i, a, n2, o, c = te(this.state.type) ? this.lookaheadCharCode() : null;
              if (c === 58)
                i = true, n2 = false, a = this.parseIdentifier(true), this.expect(14), o = this.tsParseType();
              else if (c === 63) {
                n2 = true;
                let y = this.state.startLoc, g = this.state.value, T = this.tsParseNonArrayType();
                this.lookaheadCharCode() === 58 ? (i = true, a = this.createIdentifier(this.startNodeAt(y), g), this.expect(17), this.expect(14), o = this.tsParseType()) : (i = false, o = T, this.expect(17));
              } else
                o = this.tsParseType(), n2 = this.eat(17), i = this.eat(14);
              if (i) {
                let y;
                a ? (y = this.startNodeAtNode(a), y.optional = n2, y.label = a, y.elementType = o, this.eat(17) && (y.optional = true, this.raise(I.TupleOptionalAfterType, { at: this.state.lastTokStartLoc }))) : (y = this.startNodeAtNode(o), y.optional = n2, this.raise(I.InvalidTupleMemberLabel, { at: o }), y.label = o, y.elementType = this.tsParseType()), o = this.finishNode(y, "TSNamedTupleMember");
              } else if (n2) {
                let y = this.startNodeAtNode(o);
                y.typeAnnotation = o, o = this.finishNode(y, "TSOptionalType");
              }
              if (s) {
                let y = this.startNodeAt(e);
                y.typeAnnotation = o, o = this.finishNode(y, "TSRestType");
              }
              return o;
            }
            tsParseParenthesizedType() {
              let e = this.startNode();
              return this.expect(10), e.typeAnnotation = this.tsParseType(), this.expect(11), this.finishNode(e, "TSParenthesizedType");
            }
            tsParseFunctionOrConstructorType(e, s) {
              let i = this.startNode();
              return e === "TSConstructorType" && (i.abstract = !!s, s && this.next(), this.next()), this.tsInAllowConditionalTypesContext(() => this.tsFillSignature(19, i)), this.finishNode(i, e);
            }
            tsParseLiteralTypeNode() {
              let e = this.startNode();
              return e.literal = (() => {
                switch (this.state.type) {
                  case 132:
                  case 133:
                  case 131:
                  case 85:
                  case 86:
                    return super.parseExprAtom();
                  default:
                    this.unexpected();
                }
              })(), this.finishNode(e, "TSLiteralType");
            }
            tsParseTemplateLiteralType() {
              let e = this.startNode();
              return e.literal = super.parseTemplate(false), this.finishNode(e, "TSLiteralType");
            }
            parseTemplateSubstitution() {
              return this.state.inType ? this.tsParseType() : super.parseTemplateSubstitution();
            }
            tsParseThisTypeOrThisTypePredicate() {
              let e = this.tsParseThisTypeNode();
              return this.isContextual(114) && !this.hasPrecedingLineBreak() ? this.tsParseThisTypePredicate(e) : e;
            }
            tsParseNonArrayType() {
              switch (this.state.type) {
                case 131:
                case 132:
                case 133:
                case 85:
                case 86:
                  return this.tsParseLiteralTypeNode();
                case 53:
                  if (this.state.value === "-") {
                    let e = this.startNode(), s = this.lookahead();
                    return s.type !== 132 && s.type !== 133 && this.unexpected(), e.literal = this.parseMaybeUnary(), this.finishNode(e, "TSLiteralType");
                  }
                  break;
                case 78:
                  return this.tsParseThisTypeOrThisTypePredicate();
                case 87:
                  return this.tsParseTypeQuery();
                case 83:
                  return this.tsParseImportType();
                case 5:
                  return this.tsLookAhead(this.tsIsStartOfMappedType.bind(this)) ? this.tsParseMappedType() : this.tsParseTypeLiteral();
                case 0:
                  return this.tsParseTupleType();
                case 10:
                  return this.tsParseParenthesizedType();
                case 25:
                case 24:
                  return this.tsParseTemplateLiteralType();
                default: {
                  let { type: e } = this.state;
                  if (q(e) || e === 88 || e === 84) {
                    let s = e === 88 ? "TSVoidKeyword" : e === 84 ? "TSNullKeyword" : lh(this.state.value);
                    if (s !== void 0 && this.lookaheadCharCode() !== 46) {
                      let i = this.startNode();
                      return this.next(), this.finishNode(i, s);
                    }
                    return this.tsParseTypeReference();
                  }
                }
              }
              this.unexpected();
            }
            tsParseArrayTypeOrHigher() {
              let e = this.tsParseNonArrayType();
              for (; !this.hasPrecedingLineBreak() && this.eat(0); )
                if (this.match(3)) {
                  let s = this.startNodeAtNode(e);
                  s.elementType = e, this.expect(3), e = this.finishNode(s, "TSArrayType");
                } else {
                  let s = this.startNodeAtNode(e);
                  s.objectType = e, s.indexType = this.tsParseType(), this.expect(3), e = this.finishNode(s, "TSIndexedAccessType");
                }
              return e;
            }
            tsParseTypeOperator() {
              let e = this.startNode(), s = this.state.value;
              return this.next(), e.operator = s, e.typeAnnotation = this.tsParseTypeOperatorOrHigher(), s === "readonly" && this.tsCheckTypeAnnotationForReadOnly(e), this.finishNode(e, "TSTypeOperator");
            }
            tsCheckTypeAnnotationForReadOnly(e) {
              switch (e.typeAnnotation.type) {
                case "TSTupleType":
                case "TSArrayType":
                  return;
                default:
                  this.raise(I.UnexpectedReadonly, { at: e });
              }
            }
            tsParseInferType() {
              let e = this.startNode();
              this.expectContextual(113);
              let s = this.startNode();
              return s.name = this.tsParseTypeParameterName(), s.constraint = this.tsTryParse(() => this.tsParseConstraintForInferType()), e.typeParameter = this.finishNode(s, "TSTypeParameter"), this.finishNode(e, "TSInferType");
            }
            tsParseConstraintForInferType() {
              if (this.eat(81)) {
                let e = this.tsInDisallowConditionalTypesContext(() => this.tsParseType());
                if (this.state.inDisallowConditionalTypesContext || !this.match(17))
                  return e;
              }
            }
            tsParseTypeOperatorOrHigher() {
              return qo(this.state.type) && !this.state.containsEsc ? this.tsParseTypeOperator() : this.isContextual(113) ? this.tsParseInferType() : this.tsInAllowConditionalTypesContext(() => this.tsParseArrayTypeOrHigher());
            }
            tsParseUnionOrIntersectionType(e, s, i) {
              let a = this.startNode(), n2 = this.eat(i), o = [];
              do
                o.push(s());
              while (this.eat(i));
              return o.length === 1 && !n2 ? o[0] : (a.types = o, this.finishNode(a, e));
            }
            tsParseIntersectionTypeOrHigher() {
              return this.tsParseUnionOrIntersectionType("TSIntersectionType", this.tsParseTypeOperatorOrHigher.bind(this), 45);
            }
            tsParseUnionTypeOrHigher() {
              return this.tsParseUnionOrIntersectionType("TSUnionType", this.tsParseIntersectionTypeOrHigher.bind(this), 43);
            }
            tsIsStartOfFunctionType() {
              return this.match(47) ? true : this.match(10) && this.tsLookAhead(this.tsIsUnambiguouslyStartOfFunctionType.bind(this));
            }
            tsSkipParameterStart() {
              if (q(this.state.type) || this.match(78))
                return this.next(), true;
              if (this.match(5)) {
                let { errors: e } = this.state, s = e.length;
                try {
                  return this.parseObjectLike(8, true), e.length === s;
                } catch {
                  return false;
                }
              }
              if (this.match(0)) {
                this.next();
                let { errors: e } = this.state, s = e.length;
                try {
                  return super.parseBindingList(3, 93, 1), e.length === s;
                } catch {
                  return false;
                }
              }
              return false;
            }
            tsIsUnambiguouslyStartOfFunctionType() {
              return this.next(), !!(this.match(11) || this.match(21) || this.tsSkipParameterStart() && (this.match(14) || this.match(12) || this.match(17) || this.match(29) || this.match(11) && (this.next(), this.match(19))));
            }
            tsParseTypeOrTypePredicateAnnotation(e) {
              return this.tsInType(() => {
                let s = this.startNode();
                this.expect(e);
                let i = this.startNode(), a = !!this.tsTryParse(this.tsParseTypePredicateAsserts.bind(this));
                if (a && this.match(78)) {
                  let u = this.tsParseThisTypeOrThisTypePredicate();
                  return u.type === "TSThisType" ? (i.parameterName = u, i.asserts = true, i.typeAnnotation = null, u = this.finishNode(i, "TSTypePredicate")) : (this.resetStartLocationFromNode(u, i), u.asserts = true), s.typeAnnotation = u, this.finishNode(s, "TSTypeAnnotation");
                }
                let n2 = this.tsIsIdentifier() && this.tsTryParse(this.tsParseTypePredicatePrefix.bind(this));
                if (!n2)
                  return a ? (i.parameterName = this.parseIdentifier(), i.asserts = a, i.typeAnnotation = null, s.typeAnnotation = this.finishNode(i, "TSTypePredicate"), this.finishNode(s, "TSTypeAnnotation")) : this.tsParseTypeAnnotation(false, s);
                let o = this.tsParseTypeAnnotation(false);
                return i.parameterName = n2, i.typeAnnotation = o, i.asserts = a, s.typeAnnotation = this.finishNode(i, "TSTypePredicate"), this.finishNode(s, "TSTypeAnnotation");
              });
            }
            tsTryParseTypeOrTypePredicateAnnotation() {
              return this.match(14) ? this.tsParseTypeOrTypePredicateAnnotation(14) : void 0;
            }
            tsTryParseTypeAnnotation() {
              return this.match(14) ? this.tsParseTypeAnnotation() : void 0;
            }
            tsTryParseType() {
              return this.tsEatThenParseType(14);
            }
            tsParseTypePredicatePrefix() {
              let e = this.parseIdentifier();
              if (this.isContextual(114) && !this.hasPrecedingLineBreak())
                return this.next(), e;
            }
            tsParseTypePredicateAsserts() {
              if (this.state.type !== 107)
                return false;
              let e = this.state.containsEsc;
              return this.next(), !q(this.state.type) && !this.match(78) ? false : (e && this.raise(f.InvalidEscapedReservedWord, { at: this.state.lastTokStartLoc, reservedWord: "asserts" }), true);
            }
            tsParseTypeAnnotation() {
              let e = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : true, s = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : this.startNode();
              return this.tsInType(() => {
                e && this.expect(14), s.typeAnnotation = this.tsParseType();
              }), this.finishNode(s, "TSTypeAnnotation");
            }
            tsParseType() {
              $r(this.state.inType);
              let e = this.tsParseNonConditionalType();
              if (this.state.inDisallowConditionalTypesContext || this.hasPrecedingLineBreak() || !this.eat(81))
                return e;
              let s = this.startNodeAtNode(e);
              return s.checkType = e, s.extendsType = this.tsInDisallowConditionalTypesContext(() => this.tsParseNonConditionalType()), this.expect(17), s.trueType = this.tsInAllowConditionalTypesContext(() => this.tsParseType()), this.expect(14), s.falseType = this.tsInAllowConditionalTypesContext(() => this.tsParseType()), this.finishNode(s, "TSConditionalType");
            }
            isAbstractConstructorSignature() {
              return this.isContextual(122) && this.lookahead().type === 77;
            }
            tsParseNonConditionalType() {
              return this.tsIsStartOfFunctionType() ? this.tsParseFunctionOrConstructorType("TSFunctionType") : this.match(77) ? this.tsParseFunctionOrConstructorType("TSConstructorType") : this.isAbstractConstructorSignature() ? this.tsParseFunctionOrConstructorType("TSConstructorType", true) : this.tsParseUnionTypeOrHigher();
            }
            tsParseTypeAssertion() {
              this.getPluginOption("typescript", "disallowAmbiguousJSXLike") && this.raise(I.ReservedTypeAssertion, { at: this.state.startLoc });
              let e = this.startNode();
              return e.typeAnnotation = this.tsInType(() => (this.next(), this.match(75) ? this.tsParseTypeReference() : this.tsParseType())), this.expect(48), e.expression = this.parseMaybeUnary(), this.finishNode(e, "TSTypeAssertion");
            }
            tsParseHeritageClause(e) {
              let s = this.state.startLoc, i = this.tsParseDelimitedList("HeritageClauseElement", () => {
                let a = this.startNode();
                return a.expression = this.tsParseEntityName(), this.match(47) && (a.typeParameters = this.tsParseTypeArguments()), this.finishNode(a, "TSExpressionWithTypeArguments");
              });
              return i.length || this.raise(I.EmptyHeritageClauseType, { at: s, token: e }), i;
            }
            tsParseInterfaceDeclaration(e) {
              let s = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
              if (this.hasFollowingLineBreak())
                return null;
              this.expectContextual(127), s.declare && (e.declare = true), q(this.state.type) ? (e.id = this.parseIdentifier(), this.checkIdentifier(e.id, pl)) : (e.id = null, this.raise(I.MissingInterfaceName, { at: this.state.startLoc })), e.typeParameters = this.tsTryParseTypeParameters(this.tsParseInOutConstModifiers), this.eat(81) && (e.extends = this.tsParseHeritageClause("extends"));
              let i = this.startNode();
              return i.body = this.tsInType(this.tsParseObjectTypeMembers.bind(this)), e.body = this.finishNode(i, "TSInterfaceBody"), this.finishNode(e, "TSInterfaceDeclaration");
            }
            tsParseTypeAliasDeclaration(e) {
              return e.id = this.parseIdentifier(), this.checkIdentifier(e.id, fl), e.typeAnnotation = this.tsInType(() => {
                if (e.typeParameters = this.tsTryParseTypeParameters(this.tsParseInOutModifiers), this.expect(29), this.isContextual(112) && this.lookahead().type !== 16) {
                  let s = this.startNode();
                  return this.next(), this.finishNode(s, "TSIntrinsicKeyword");
                }
                return this.tsParseType();
              }), this.semicolon(), this.finishNode(e, "TSTypeAliasDeclaration");
            }
            tsInNoContext(e) {
              let s = this.state.context;
              this.state.context = [s[0]];
              try {
                return e();
              } finally {
                this.state.context = s;
              }
            }
            tsInType(e) {
              let s = this.state.inType;
              this.state.inType = true;
              try {
                return e();
              } finally {
                this.state.inType = s;
              }
            }
            tsInDisallowConditionalTypesContext(e) {
              let s = this.state.inDisallowConditionalTypesContext;
              this.state.inDisallowConditionalTypesContext = true;
              try {
                return e();
              } finally {
                this.state.inDisallowConditionalTypesContext = s;
              }
            }
            tsInAllowConditionalTypesContext(e) {
              let s = this.state.inDisallowConditionalTypesContext;
              this.state.inDisallowConditionalTypesContext = false;
              try {
                return e();
              } finally {
                this.state.inDisallowConditionalTypesContext = s;
              }
            }
            tsEatThenParseType(e) {
              return this.match(e) ? this.tsNextThenParseType() : void 0;
            }
            tsExpectThenParseType(e) {
              return this.tsDoThenParseType(() => this.expect(e));
            }
            tsNextThenParseType() {
              return this.tsDoThenParseType(() => this.next());
            }
            tsDoThenParseType(e) {
              return this.tsInType(() => (e(), this.tsParseType()));
            }
            tsParseEnumMember() {
              let e = this.startNode();
              return e.id = this.match(131) ? super.parseStringLiteral(this.state.value) : this.parseIdentifier(true), this.eat(29) && (e.initializer = super.parseMaybeAssignAllowIn()), this.finishNode(e, "TSEnumMember");
            }
            tsParseEnumDeclaration(e) {
              let s = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
              return s.const && (e.const = true), s.declare && (e.declare = true), this.expectContextual(124), e.id = this.parseIdentifier(), this.checkIdentifier(e.id, e.const ? ml : Cr), this.expect(5), e.members = this.tsParseDelimitedList("EnumMembers", this.tsParseEnumMember.bind(this)), this.expect(8), this.finishNode(e, "TSEnumDeclaration");
            }
            tsParseModuleBlock() {
              let e = this.startNode();
              return this.scope.enter(Fe), this.expect(5), super.parseBlockOrModuleBlockBody(e.body = [], void 0, true, 8), this.scope.exit(), this.finishNode(e, "TSModuleBlock");
            }
            tsParseModuleOrNamespaceDeclaration(e) {
              let s = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : false;
              if (e.id = this.parseIdentifier(), s || this.checkIdentifier(e.id, yl), this.eat(16)) {
                let i = this.startNode();
                this.tsParseModuleOrNamespaceDeclaration(i, true), e.body = i;
              } else
                this.scope.enter(Oe), this.prodParam.enter(Me), e.body = this.tsParseModuleBlock(), this.prodParam.exit(), this.scope.exit();
              return this.finishNode(e, "TSModuleDeclaration");
            }
            tsParseAmbientExternalModuleDeclaration(e) {
              return this.isContextual(110) ? (e.global = true, e.id = this.parseIdentifier()) : this.match(131) ? e.id = super.parseStringLiteral(this.state.value) : this.unexpected(), this.match(5) ? (this.scope.enter(Oe), this.prodParam.enter(Me), e.body = this.tsParseModuleBlock(), this.prodParam.exit(), this.scope.exit()) : this.semicolon(), this.finishNode(e, "TSModuleDeclaration");
            }
            tsParseImportEqualsDeclaration(e, s) {
              e.isExport = s || false, e.id = this.parseIdentifier(), this.checkIdentifier(e.id, Ve), this.expect(29);
              let i = this.tsParseModuleReference();
              return e.importKind === "type" && i.type !== "TSExternalModuleReference" && this.raise(I.ImportAliasHasImportType, { at: i }), e.moduleReference = i, this.semicolon(), this.finishNode(e, "TSImportEqualsDeclaration");
            }
            tsIsExternalModuleReference() {
              return this.isContextual(117) && this.lookaheadCharCode() === 40;
            }
            tsParseModuleReference() {
              return this.tsIsExternalModuleReference() ? this.tsParseExternalModuleReference() : this.tsParseEntityName(false);
            }
            tsParseExternalModuleReference() {
              let e = this.startNode();
              return this.expectContextual(117), this.expect(10), this.match(131) || this.unexpected(), e.expression = super.parseExprAtom(), this.expect(11), this.finishNode(e, "TSExternalModuleReference");
            }
            tsLookAhead(e) {
              let s = this.state.clone(), i = e();
              return this.state = s, i;
            }
            tsTryParseAndCatch(e) {
              let s = this.tryParse((i) => e() || i());
              if (!(s.aborted || !s.node))
                return s.error && (this.state = s.failState), s.node;
            }
            tsTryParse(e) {
              let s = this.state.clone(), i = e();
              if (i !== void 0 && i !== false)
                return i;
              this.state = s;
            }
            tsTryParseDeclare(e) {
              if (this.isLineTerminator())
                return;
              let s = this.state.type, i;
              return this.isContextual(99) && (s = 74, i = "let"), this.tsInAmbientContext(() => {
                if (s === 68)
                  return e.declare = true, super.parseFunctionStatement(e, false, false);
                if (s === 80)
                  return e.declare = true, this.parseClass(e, true, false);
                if (s === 124)
                  return this.tsParseEnumDeclaration(e, { declare: true });
                if (s === 110)
                  return this.tsParseAmbientExternalModuleDeclaration(e);
                if (s === 75 || s === 74)
                  return !this.match(75) || !this.isLookaheadContextual("enum") ? (e.declare = true, this.parseVarStatement(e, i || this.state.value, true)) : (this.expect(75), this.tsParseEnumDeclaration(e, { const: true, declare: true }));
                if (s === 127) {
                  let a = this.tsParseInterfaceDeclaration(e, { declare: true });
                  if (a)
                    return a;
                }
                if (q(s))
                  return this.tsParseDeclaration(e, this.state.value, true, null);
              });
            }
            tsTryParseExportDeclaration() {
              return this.tsParseDeclaration(this.startNode(), this.state.value, true, null);
            }
            tsParseExpressionStatement(e, s, i) {
              switch (s.name) {
                case "declare": {
                  let a = this.tsTryParseDeclare(e);
                  if (a)
                    return a.declare = true, a;
                  break;
                }
                case "global":
                  if (this.match(5)) {
                    this.scope.enter(Oe), this.prodParam.enter(Me);
                    let a = e;
                    return a.global = true, a.id = s, a.body = this.tsParseModuleBlock(), this.scope.exit(), this.prodParam.exit(), this.finishNode(a, "TSModuleDeclaration");
                  }
                  break;
                default:
                  return this.tsParseDeclaration(e, s.name, false, i);
              }
            }
            tsParseDeclaration(e, s, i, a) {
              switch (s) {
                case "abstract":
                  if (this.tsCheckLineTerminator(i) && (this.match(80) || q(this.state.type)))
                    return this.tsParseAbstractDeclaration(e, a);
                  break;
                case "module":
                  if (this.tsCheckLineTerminator(i)) {
                    if (this.match(131))
                      return this.tsParseAmbientExternalModuleDeclaration(e);
                    if (q(this.state.type))
                      return this.tsParseModuleOrNamespaceDeclaration(e);
                  }
                  break;
                case "namespace":
                  if (this.tsCheckLineTerminator(i) && q(this.state.type))
                    return this.tsParseModuleOrNamespaceDeclaration(e);
                  break;
                case "type":
                  if (this.tsCheckLineTerminator(i) && q(this.state.type))
                    return this.tsParseTypeAliasDeclaration(e);
                  break;
              }
            }
            tsCheckLineTerminator(e) {
              return e ? this.hasFollowingLineBreak() ? false : (this.next(), true) : !this.isLineTerminator();
            }
            tsTryParseGenericAsyncArrowFunction(e) {
              if (!this.match(47))
                return;
              let s = this.state.maybeInArrowParameters;
              this.state.maybeInArrowParameters = true;
              let i = this.tsTryParseAndCatch(() => {
                let a = this.startNodeAt(e);
                return a.typeParameters = this.tsParseTypeParameters(this.tsParseConstModifier), super.parseFunctionParams(a), a.returnType = this.tsTryParseTypeOrTypePredicateAnnotation(), this.expect(19), a;
              });
              if (this.state.maybeInArrowParameters = s, !!i)
                return super.parseArrowExpression(i, null, true);
            }
            tsParseTypeArgumentsInExpression() {
              if (this.reScan_lt() === 47)
                return this.tsParseTypeArguments();
            }
            tsParseTypeArguments() {
              let e = this.startNode();
              return e.params = this.tsInType(() => this.tsInNoContext(() => (this.expect(47), this.tsParseDelimitedList("TypeParametersOrArguments", this.tsParseType.bind(this))))), e.params.length === 0 && this.raise(I.EmptyTypeArguments, { at: e }), this.expect(48), this.finishNode(e, "TSTypeParameterInstantiation");
            }
            tsIsDeclarationStart() {
              return Uo(this.state.type);
            }
            isExportDefaultSpecifier() {
              return this.tsIsDeclarationStart() ? false : super.isExportDefaultSpecifier();
            }
            parseAssignableListItem(e, s) {
              let i = this.state.startLoc, a = {};
              this.tsParseModifiers({ allowedModifiers: ["public", "private", "protected", "override", "readonly"] }, a);
              let n2 = a.accessibility, o = a.override, u = a.readonly;
              !(e & 4) && (n2 || u || o) && this.raise(I.UnexpectedParameterModifier, { at: i });
              let c = this.parseMaybeDefault();
              this.parseAssignableListItemTypes(c, e);
              let y = this.parseMaybeDefault(c.loc.start, c);
              if (n2 || u || o) {
                let g = this.startNodeAt(i);
                return s.length && (g.decorators = s), n2 && (g.accessibility = n2), u && (g.readonly = u), o && (g.override = o), y.type !== "Identifier" && y.type !== "AssignmentPattern" && this.raise(I.UnsupportedParameterPropertyKind, { at: g }), g.parameter = y, this.finishNode(g, "TSParameterProperty");
              }
              return s.length && (c.decorators = s), y;
            }
            isSimpleParameter(e) {
              return e.type === "TSParameterProperty" && super.isSimpleParameter(e.parameter) || super.isSimpleParameter(e);
            }
            tsDisallowOptionalPattern(e) {
              for (let s of e.params)
                s.type !== "Identifier" && s.optional && !this.state.isAmbientContext && this.raise(I.PatternIsOptional, { at: s });
            }
            setArrowFunctionParameters(e, s, i) {
              super.setArrowFunctionParameters(e, s, i), this.tsDisallowOptionalPattern(e);
            }
            parseFunctionBodyAndFinish(e, s) {
              let i = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : false;
              this.match(14) && (e.returnType = this.tsParseTypeOrTypePredicateAnnotation(14));
              let a = s === "FunctionDeclaration" ? "TSDeclareFunction" : s === "ClassMethod" || s === "ClassPrivateMethod" ? "TSDeclareMethod" : void 0;
              return a && !this.match(5) && this.isLineTerminator() ? this.finishNode(e, a) : a === "TSDeclareFunction" && this.state.isAmbientContext && (this.raise(I.DeclareFunctionHasImplementation, { at: e }), e.declare) ? super.parseFunctionBodyAndFinish(e, a, i) : (this.tsDisallowOptionalPattern(e), super.parseFunctionBodyAndFinish(e, s, i));
            }
            registerFunctionStatementId(e) {
              !e.body && e.id ? this.checkIdentifier(e.id, br) : super.registerFunctionStatementId(e);
            }
            tsCheckForInvalidTypeCasts(e) {
              e.forEach((s) => {
                (s == null ? void 0 : s.type) === "TSTypeCastExpression" && this.raise(I.UnexpectedTypeAnnotation, { at: s.typeAnnotation });
              });
            }
            toReferencedList(e, s) {
              return this.tsCheckForInvalidTypeCasts(e), e;
            }
            parseArrayLike(e, s, i, a) {
              let n2 = super.parseArrayLike(e, s, i, a);
              return n2.type === "ArrayExpression" && this.tsCheckForInvalidTypeCasts(n2.elements), n2;
            }
            parseSubscript(e, s, i, a) {
              if (!this.hasPrecedingLineBreak() && this.match(35)) {
                this.state.canStartJSXElement = false, this.next();
                let o = this.startNodeAt(s);
                return o.expression = e, this.finishNode(o, "TSNonNullExpression");
              }
              let n2 = false;
              if (this.match(18) && this.lookaheadCharCode() === 60) {
                if (i)
                  return a.stop = true, e;
                a.optionalChainMember = n2 = true, this.next();
              }
              if (this.match(47) || this.match(51)) {
                let o, u = this.tsTryParseAndCatch(() => {
                  if (!i && this.atPossibleAsyncArrow(e)) {
                    let T = this.tsTryParseGenericAsyncArrowFunction(s);
                    if (T)
                      return T;
                  }
                  let c = this.tsParseTypeArgumentsInExpression();
                  if (!c)
                    return;
                  if (n2 && !this.match(10)) {
                    o = this.state.curPosition();
                    return;
                  }
                  if (nt(this.state.type)) {
                    let T = super.parseTaggedTemplateExpression(e, s, a);
                    return T.typeParameters = c, T;
                  }
                  if (!i && this.eat(10)) {
                    let T = this.startNodeAt(s);
                    return T.callee = e, T.arguments = this.parseCallExpressionArguments(11, false), this.tsCheckForInvalidTypeCasts(T.arguments), T.typeParameters = c, a.optionalChainMember && (T.optional = n2), this.finishCallExpression(T, a.optionalChainMember);
                  }
                  let y = this.state.type;
                  if (y === 48 || y === 52 || y !== 10 && He(y) && !this.hasPrecedingLineBreak())
                    return;
                  let g = this.startNodeAt(s);
                  return g.expression = e, g.typeParameters = c, this.finishNode(g, "TSInstantiationExpression");
                });
                if (o && this.unexpected(o, 10), u)
                  return u.type === "TSInstantiationExpression" && (this.match(16) || this.match(18) && this.lookaheadCharCode() !== 40) && this.raise(I.InvalidPropertyAccessAfterInstantiationExpression, { at: this.state.startLoc }), u;
              }
              return super.parseSubscript(e, s, i, a);
            }
            parseNewCallee(e) {
              var s;
              super.parseNewCallee(e);
              let { callee: i } = e;
              i.type === "TSInstantiationExpression" && !((s = i.extra) != null && s.parenthesized) && (e.typeParameters = i.typeParameters, e.callee = i.expression);
            }
            parseExprOp(e, s, i) {
              let a;
              if (at(58) > i && !this.hasPrecedingLineBreak() && (this.isContextual(93) || (a = this.isContextual(118)))) {
                let n2 = this.startNodeAt(s);
                return n2.expression = e, n2.typeAnnotation = this.tsInType(() => (this.next(), this.match(75) ? (a && this.raise(f.UnexpectedKeyword, { at: this.state.startLoc, keyword: "const" }), this.tsParseTypeReference()) : this.tsParseType())), this.finishNode(n2, a ? "TSSatisfiesExpression" : "TSAsExpression"), this.reScan_lt_gt(), this.parseExprOp(n2, s, i);
              }
              return super.parseExprOp(e, s, i);
            }
            checkReservedWord(e, s, i, a) {
              this.state.isAmbientContext || super.checkReservedWord(e, s, i, a);
            }
            checkImportReflection(e) {
              super.checkImportReflection(e), e.module && e.importKind !== "value" && this.raise(I.ImportReflectionHasImportType, { at: e.specifiers[0].loc.start });
            }
            checkDuplicateExports() {
            }
            parseImport(e) {
              if (e.importKind = "value", q(this.state.type) || this.match(55) || this.match(5)) {
                let i = this.lookahead();
                if (this.isContextual(128) && i.type !== 12 && i.type !== 97 && i.type !== 29 && (e.importKind = "type", this.next(), i = this.lookahead()), q(this.state.type) && i.type === 29)
                  return this.tsParseImportEqualsDeclaration(e);
              }
              let s = super.parseImport(e);
              return s.importKind === "type" && s.specifiers.length > 1 && s.specifiers[0].type === "ImportDefaultSpecifier" && this.raise(I.TypeImportCannotSpecifyDefaultAndNamed, { at: s }), s;
            }
            parseExport(e, s) {
              if (this.match(83))
                return this.next(), this.isContextual(128) && this.lookaheadCharCode() !== 61 ? (e.importKind = "type", this.next()) : e.importKind = "value", this.tsParseImportEqualsDeclaration(e, true);
              if (this.eat(29)) {
                let i = e;
                return i.expression = super.parseExpression(), this.semicolon(), this.finishNode(i, "TSExportAssignment");
              } else if (this.eatContextual(93)) {
                let i = e;
                return this.expectContextual(126), i.id = this.parseIdentifier(), this.semicolon(), this.finishNode(i, "TSNamespaceExportDeclaration");
              } else {
                if (e.exportKind = "value", this.isContextual(128)) {
                  let i = this.lookaheadCharCode();
                  (i === 123 || i === 42) && (this.next(), e.exportKind = "type");
                }
                return super.parseExport(e, s);
              }
            }
            isAbstractClass() {
              return this.isContextual(122) && this.lookahead().type === 80;
            }
            parseExportDefaultExpression() {
              if (this.isAbstractClass()) {
                let e = this.startNode();
                return this.next(), e.abstract = true, this.parseClass(e, true, true);
              }
              if (this.match(127)) {
                let e = this.tsParseInterfaceDeclaration(this.startNode());
                if (e)
                  return e;
              }
              return super.parseExportDefaultExpression();
            }
            parseVarStatement(e, s) {
              let i = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : false, { isAmbientContext: a } = this.state, n2 = super.parseVarStatement(e, s, i || a);
              if (!a)
                return n2;
              for (let { id: o, init: u } of n2.declarations)
                u && (s !== "const" || o.typeAnnotation ? this.raise(I.InitializerNotAllowedInAmbientContext, { at: u }) : ph(u, this.hasPlugin("estree")) || this.raise(I.ConstInitiailizerMustBeStringOrNumericLiteralOrLiteralEnumReference, { at: u }));
              return n2;
            }
            parseStatementContent(e, s) {
              if (this.match(75) && this.isLookaheadContextual("enum")) {
                let i = this.startNode();
                return this.expect(75), this.tsParseEnumDeclaration(i, { const: true });
              }
              if (this.isContextual(124))
                return this.tsParseEnumDeclaration(this.startNode());
              if (this.isContextual(127)) {
                let i = this.tsParseInterfaceDeclaration(this.startNode());
                if (i)
                  return i;
              }
              return super.parseStatementContent(e, s);
            }
            parseAccessModifier() {
              return this.tsParseModifier(["public", "protected", "private"]);
            }
            tsHasSomeModifiers(e, s) {
              return s.some((i) => Hr(i) ? e.accessibility === i : !!e[i]);
            }
            tsIsStartOfStaticBlocks() {
              return this.isContextual(104) && this.lookaheadCharCode() === 123;
            }
            parseClassMember(e, s, i) {
              let a = ["declare", "private", "public", "protected", "override", "abstract", "readonly", "static"];
              this.tsParseModifiers({ allowedModifiers: a, disallowedModifiers: ["in", "out"], stopOnStartOfClassStaticBlock: true, errorTemplate: I.InvalidModifierOnTypeParameterPositions }, s);
              let n2 = () => {
                this.tsIsStartOfStaticBlocks() ? (this.next(), this.next(), this.tsHasSomeModifiers(s, a) && this.raise(I.StaticBlockCannotHaveModifier, { at: this.state.curPosition() }), super.parseClassStaticBlock(e, s)) : this.parseClassMemberWithIsStatic(e, s, i, !!s.static);
              };
              s.declare ? this.tsInAmbientContext(n2) : n2();
            }
            parseClassMemberWithIsStatic(e, s, i, a) {
              let n2 = this.tsTryParseIndexSignature(s);
              if (n2) {
                e.body.push(n2), s.abstract && this.raise(I.IndexSignatureHasAbstract, { at: s }), s.accessibility && this.raise(I.IndexSignatureHasAccessibility, { at: s, modifier: s.accessibility }), s.declare && this.raise(I.IndexSignatureHasDeclare, { at: s }), s.override && this.raise(I.IndexSignatureHasOverride, { at: s });
                return;
              }
              !this.state.inAbstractClass && s.abstract && this.raise(I.NonAbstractClassHasAbstractMethod, { at: s }), s.override && (i.hadSuperClass || this.raise(I.OverrideNotInSubClass, { at: s })), super.parseClassMemberWithIsStatic(e, s, i, a);
            }
            parsePostMemberNameModifiers(e) {
              this.eat(17) && (e.optional = true), e.readonly && this.match(10) && this.raise(I.ClassMethodHasReadonly, { at: e }), e.declare && this.match(10) && this.raise(I.ClassMethodHasDeclare, { at: e });
            }
            parseExpressionStatement(e, s, i) {
              return (s.type === "Identifier" ? this.tsParseExpressionStatement(e, s, i) : void 0) || super.parseExpressionStatement(e, s, i);
            }
            shouldParseExportDeclaration() {
              return this.tsIsDeclarationStart() ? true : super.shouldParseExportDeclaration();
            }
            parseConditional(e, s, i) {
              if (!this.state.maybeInArrowParameters || !this.match(17))
                return super.parseConditional(e, s, i);
              let a = this.tryParse(() => super.parseConditional(e, s));
              return a.node ? (a.error && (this.state = a.failState), a.node) : (a.error && super.setOptionalParametersError(i, a.error), e);
            }
            parseParenItem(e, s) {
              if (e = super.parseParenItem(e, s), this.eat(17) && (e.optional = true, this.resetEndLocation(e)), this.match(14)) {
                let i = this.startNodeAt(s);
                return i.expression = e, i.typeAnnotation = this.tsParseTypeAnnotation(), this.finishNode(i, "TSTypeCastExpression");
              }
              return e;
            }
            parseExportDeclaration(e) {
              if (!this.state.isAmbientContext && this.isContextual(123))
                return this.tsInAmbientContext(() => this.parseExportDeclaration(e));
              let s = this.state.startLoc, i = this.eatContextual(123);
              if (i && (this.isContextual(123) || !this.shouldParseExportDeclaration()))
                throw this.raise(I.ExpectedAmbientAfterExportDeclare, { at: this.state.startLoc });
              let n2 = q(this.state.type) && this.tsTryParseExportDeclaration() || super.parseExportDeclaration(e);
              return n2 ? ((n2.type === "TSInterfaceDeclaration" || n2.type === "TSTypeAliasDeclaration" || i) && (e.exportKind = "type"), i && (this.resetStartLocation(n2, s), n2.declare = true), n2) : null;
            }
            parseClassId(e, s, i, a) {
              if ((!s || i) && this.isContextual(111))
                return;
              super.parseClassId(e, s, i, e.declare ? br : vr);
              let n2 = this.tsTryParseTypeParameters(this.tsParseInOutConstModifiers);
              n2 && (e.typeParameters = n2);
            }
            parseClassPropertyAnnotation(e) {
              e.optional || (this.eat(35) ? e.definite = true : this.eat(17) && (e.optional = true));
              let s = this.tsTryParseTypeAnnotation();
              s && (e.typeAnnotation = s);
            }
            parseClassProperty(e) {
              if (this.parseClassPropertyAnnotation(e), this.state.isAmbientContext && !(e.readonly && !e.typeAnnotation) && this.match(29) && this.raise(I.DeclareClassFieldHasInitializer, { at: this.state.startLoc }), e.abstract && this.match(29)) {
                let { key: s } = e;
                this.raise(I.AbstractPropertyHasInitializer, { at: this.state.startLoc, propertyName: s.type === "Identifier" && !e.computed ? s.name : `[${this.input.slice(s.start, s.end)}]` });
              }
              return super.parseClassProperty(e);
            }
            parseClassPrivateProperty(e) {
              return e.abstract && this.raise(I.PrivateElementHasAbstract, { at: e }), e.accessibility && this.raise(I.PrivateElementHasAccessibility, { at: e, modifier: e.accessibility }), this.parseClassPropertyAnnotation(e), super.parseClassPrivateProperty(e);
            }
            parseClassAccessorProperty(e) {
              return this.parseClassPropertyAnnotation(e), e.optional && this.raise(I.AccessorCannotBeOptional, { at: e }), super.parseClassAccessorProperty(e);
            }
            pushClassMethod(e, s, i, a, n2, o) {
              let u = this.tsTryParseTypeParameters(this.tsParseConstModifier);
              u && n2 && this.raise(I.ConstructorHasTypeParameters, { at: u });
              let { declare: c = false, kind: y } = s;
              c && (y === "get" || y === "set") && this.raise(I.DeclareAccessor, { at: s, kind: y }), u && (s.typeParameters = u), super.pushClassMethod(e, s, i, a, n2, o);
            }
            pushClassPrivateMethod(e, s, i, a) {
              let n2 = this.tsTryParseTypeParameters(this.tsParseConstModifier);
              n2 && (s.typeParameters = n2), super.pushClassPrivateMethod(e, s, i, a);
            }
            declareClassPrivateMethodInScope(e, s) {
              e.type !== "TSDeclareMethod" && (e.type === "MethodDefinition" && !e.value.body || super.declareClassPrivateMethodInScope(e, s));
            }
            parseClassSuper(e) {
              super.parseClassSuper(e), e.superClass && (this.match(47) || this.match(51)) && (e.superTypeParameters = this.tsParseTypeArgumentsInExpression()), this.eatContextual(111) && (e.implements = this.tsParseHeritageClause("implements"));
            }
            parseObjPropValue(e, s, i, a, n2, o, u) {
              let c = this.tsTryParseTypeParameters(this.tsParseConstModifier);
              return c && (e.typeParameters = c), super.parseObjPropValue(e, s, i, a, n2, o, u);
            }
            parseFunctionParams(e, s) {
              let i = this.tsTryParseTypeParameters(this.tsParseConstModifier);
              i && (e.typeParameters = i), super.parseFunctionParams(e, s);
            }
            parseVarId(e, s) {
              super.parseVarId(e, s), e.id.type === "Identifier" && !this.hasPrecedingLineBreak() && this.eat(35) && (e.definite = true);
              let i = this.tsTryParseTypeAnnotation();
              i && (e.id.typeAnnotation = i, this.resetEndLocation(e.id));
            }
            parseAsyncArrowFromCallExpression(e, s) {
              return this.match(14) && (e.returnType = this.tsParseTypeAnnotation()), super.parseAsyncArrowFromCallExpression(e, s);
            }
            parseMaybeAssign(e, s) {
              var i, a, n2, o, u, c, y;
              let g, T, C;
              if (this.hasPlugin("jsx") && (this.match(140) || this.match(47))) {
                if (g = this.state.clone(), T = this.tryParse(() => super.parseMaybeAssign(e, s), g), !T.error)
                  return T.node;
                let { context: K } = this.state, W = K[K.length - 1];
                (W === x.j_oTag || W === x.j_expr) && K.pop();
              }
              if (!((i = T) != null && i.error) && !this.match(47))
                return super.parseMaybeAssign(e, s);
              (!g || g === this.state) && (g = this.state.clone());
              let M, j = this.tryParse((K) => {
                var W, V;
                M = this.tsParseTypeParameters(this.tsParseConstModifier);
                let X = super.parseMaybeAssign(e, s);
                return (X.type !== "ArrowFunctionExpression" || (W = X.extra) != null && W.parenthesized) && K(), ((V = M) == null ? void 0 : V.params.length) !== 0 && this.resetStartLocationFromNode(X, M), X.typeParameters = M, X;
              }, g);
              if (!j.error && !j.aborted)
                return M && this.reportReservedArrowTypeParam(M), j.node;
              if (!T && ($r(!this.hasPlugin("jsx")), C = this.tryParse(() => super.parseMaybeAssign(e, s), g), !C.error))
                return C.node;
              if ((a = T) != null && a.node)
                return this.state = T.failState, T.node;
              if (j.node)
                return this.state = j.failState, M && this.reportReservedArrowTypeParam(M), j.node;
              if ((n2 = C) != null && n2.node)
                return this.state = C.failState, C.node;
              throw (o = T) != null && o.thrown ? T.error : j.thrown ? j.error : (u = C) != null && u.thrown ? C.error : ((c = T) == null ? void 0 : c.error) || j.error || ((y = C) == null ? void 0 : y.error);
            }
            reportReservedArrowTypeParam(e) {
              var s;
              e.params.length === 1 && !e.params[0].constraint && !((s = e.extra) != null && s.trailingComma) && this.getPluginOption("typescript", "disallowAmbiguousJSXLike") && this.raise(I.ReservedArrowTypeParam, { at: e });
            }
            parseMaybeUnary(e, s) {
              return !this.hasPlugin("jsx") && this.match(47) ? this.tsParseTypeAssertion() : super.parseMaybeUnary(e, s);
            }
            parseArrow(e) {
              if (this.match(14)) {
                let s = this.tryParse((i) => {
                  let a = this.tsParseTypeOrTypePredicateAnnotation(14);
                  return (this.canInsertSemicolon() || !this.match(19)) && i(), a;
                });
                if (s.aborted)
                  return;
                s.thrown || (s.error && (this.state = s.failState), e.returnType = s.node);
              }
              return super.parseArrow(e);
            }
            parseAssignableListItemTypes(e, s) {
              if (!(s & 2))
                return e;
              this.eat(17) && (e.optional = true);
              let i = this.tsTryParseTypeAnnotation();
              return i && (e.typeAnnotation = i), this.resetEndLocation(e), e;
            }
            isAssignable(e, s) {
              switch (e.type) {
                case "TSTypeCastExpression":
                  return this.isAssignable(e.expression, s);
                case "TSParameterProperty":
                  return true;
                default:
                  return super.isAssignable(e, s);
              }
            }
            toAssignable(e) {
              let s = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : false;
              switch (e.type) {
                case "ParenthesizedExpression":
                  this.toAssignableParenthesizedExpression(e, s);
                  break;
                case "TSAsExpression":
                case "TSSatisfiesExpression":
                case "TSNonNullExpression":
                case "TSTypeAssertion":
                  s ? this.expressionScope.recordArrowParameterBindingError(I.UnexpectedTypeCastInParameter, { at: e }) : this.raise(I.UnexpectedTypeCastInParameter, { at: e }), this.toAssignable(e.expression, s);
                  break;
                case "AssignmentExpression":
                  !s && e.left.type === "TSTypeCastExpression" && (e.left = this.typeCastToParameter(e.left));
                default:
                  super.toAssignable(e, s);
              }
            }
            toAssignableParenthesizedExpression(e, s) {
              switch (e.expression.type) {
                case "TSAsExpression":
                case "TSSatisfiesExpression":
                case "TSNonNullExpression":
                case "TSTypeAssertion":
                case "ParenthesizedExpression":
                  this.toAssignable(e.expression, s);
                  break;
                default:
                  super.toAssignable(e, s);
              }
            }
            checkToRestConversion(e, s) {
              switch (e.type) {
                case "TSAsExpression":
                case "TSSatisfiesExpression":
                case "TSTypeAssertion":
                case "TSNonNullExpression":
                  this.checkToRestConversion(e.expression, false);
                  break;
                default:
                  super.checkToRestConversion(e, s);
              }
            }
            isValidLVal(e, s, i) {
              return nh({ TSTypeCastExpression: true, TSParameterProperty: "parameter", TSNonNullExpression: "expression", TSAsExpression: (i !== Pe || !s) && ["expression", true], TSSatisfiesExpression: (i !== Pe || !s) && ["expression", true], TSTypeAssertion: (i !== Pe || !s) && ["expression", true] }, e) || super.isValidLVal(e, s, i);
            }
            parseBindingAtom() {
              switch (this.state.type) {
                case 78:
                  return this.parseIdentifier(true);
                default:
                  return super.parseBindingAtom();
              }
            }
            parseMaybeDecoratorArguments(e) {
              if (this.match(47) || this.match(51)) {
                let s = this.tsParseTypeArgumentsInExpression();
                if (this.match(10)) {
                  let i = super.parseMaybeDecoratorArguments(e);
                  return i.typeParameters = s, i;
                }
                this.unexpected(null, 10);
              }
              return super.parseMaybeDecoratorArguments(e);
            }
            checkCommaAfterRest(e) {
              return this.state.isAmbientContext && this.match(12) && this.lookaheadCharCode() === e ? (this.next(), false) : super.checkCommaAfterRest(e);
            }
            isClassMethod() {
              return this.match(47) || super.isClassMethod();
            }
            isClassProperty() {
              return this.match(35) || this.match(14) || super.isClassProperty();
            }
            parseMaybeDefault(e, s) {
              let i = super.parseMaybeDefault(e, s);
              return i.type === "AssignmentPattern" && i.typeAnnotation && i.right.start < i.typeAnnotation.start && this.raise(I.TypeAnnotationAfterAssign, { at: i.typeAnnotation }), i;
            }
            getTokenFromCode(e) {
              if (this.state.inType) {
                if (e === 62) {
                  this.finishOp(48, 1);
                  return;
                }
                if (e === 60) {
                  this.finishOp(47, 1);
                  return;
                }
              }
              super.getTokenFromCode(e);
            }
            reScan_lt_gt() {
              let { type: e } = this.state;
              e === 47 ? (this.state.pos -= 1, this.readToken_lt()) : e === 48 && (this.state.pos -= 1, this.readToken_gt());
            }
            reScan_lt() {
              let { type: e } = this.state;
              return e === 51 ? (this.state.pos -= 2, this.finishOp(47, 1), 47) : e;
            }
            toAssignableList(e, s, i) {
              for (let a = 0; a < e.length; a++) {
                let n2 = e[a];
                (n2 == null ? void 0 : n2.type) === "TSTypeCastExpression" && (e[a] = this.typeCastToParameter(n2));
              }
              super.toAssignableList(e, s, i);
            }
            typeCastToParameter(e) {
              return e.expression.typeAnnotation = e.typeAnnotation, this.resetEndLocation(e.expression, e.typeAnnotation.loc.end), e.expression;
            }
            shouldParseArrow(e) {
              return this.match(14) ? e.every((s) => this.isAssignable(s, true)) : super.shouldParseArrow(e);
            }
            shouldParseAsyncArrow() {
              return this.match(14) || super.shouldParseAsyncArrow();
            }
            canHaveLeadingDecorator() {
              return super.canHaveLeadingDecorator() || this.isAbstractClass();
            }
            jsxParseOpeningElementAfterName(e) {
              if (this.match(47) || this.match(51)) {
                let s = this.tsTryParseAndCatch(() => this.tsParseTypeArgumentsInExpression());
                s && (e.typeParameters = s);
              }
              return super.jsxParseOpeningElementAfterName(e);
            }
            getGetterSetterExpectedParamCount(e) {
              let s = super.getGetterSetterExpectedParamCount(e), a = this.getObjectOrClassMethodParams(e)[0];
              return a && this.isThisParam(a) ? s + 1 : s;
            }
            parseCatchClauseParam() {
              let e = super.parseCatchClauseParam(), s = this.tsTryParseTypeAnnotation();
              return s && (e.typeAnnotation = s, this.resetEndLocation(e)), e;
            }
            tsInAmbientContext(e) {
              let s = this.state.isAmbientContext;
              this.state.isAmbientContext = true;
              try {
                return e();
              } finally {
                this.state.isAmbientContext = s;
              }
            }
            parseClass(e, s, i) {
              let a = this.state.inAbstractClass;
              this.state.inAbstractClass = !!e.abstract;
              try {
                return super.parseClass(e, s, i);
              } finally {
                this.state.inAbstractClass = a;
              }
            }
            tsParseAbstractDeclaration(e, s) {
              if (this.match(80))
                return e.abstract = true, this.maybeTakeDecorators(s, this.parseClass(e, true, false));
              if (this.isContextual(127)) {
                if (!this.hasFollowingLineBreak())
                  return e.abstract = true, this.raise(I.NonClassMethodPropertyHasAbstractModifer, { at: e }), this.tsParseInterfaceDeclaration(e);
              } else
                this.unexpected(null, 80);
            }
            parseMethod(e, s, i, a, n2, o, u) {
              let c = super.parseMethod(e, s, i, a, n2, o, u);
              if (c.abstract && (this.hasPlugin("estree") ? !!c.value.body : !!c.body)) {
                let { key: g } = c;
                this.raise(I.AbstractMethodHasImplementation, { at: c, methodName: g.type === "Identifier" && !c.computed ? g.name : `[${this.input.slice(g.start, g.end)}]` });
              }
              return c;
            }
            tsParseTypeParameterName() {
              return this.parseIdentifier().name;
            }
            shouldParseAsAmbientContext() {
              return !!this.getPluginOption("typescript", "dts");
            }
            parse() {
              return this.shouldParseAsAmbientContext() && (this.state.isAmbientContext = true), super.parse();
            }
            getExpression() {
              return this.shouldParseAsAmbientContext() && (this.state.isAmbientContext = true), super.getExpression();
            }
            parseExportSpecifier(e, s, i, a) {
              return !s && a ? (this.parseTypeOnlyImportExportSpecifier(e, false, i), this.finishNode(e, "ExportSpecifier")) : (e.exportKind = "value", super.parseExportSpecifier(e, s, i, a));
            }
            parseImportSpecifier(e, s, i, a, n2) {
              return !s && a ? (this.parseTypeOnlyImportExportSpecifier(e, true, i), this.finishNode(e, "ImportSpecifier")) : (e.importKind = "value", super.parseImportSpecifier(e, s, i, a, i ? Sr : Ve));
            }
            parseTypeOnlyImportExportSpecifier(e, s, i) {
              let a = s ? "imported" : "local", n2 = s ? "local" : "exported", o = e[a], u, c = false, y = true, g = o.loc.start;
              if (this.isContextual(93)) {
                let C = this.parseIdentifier();
                if (this.isContextual(93)) {
                  let M = this.parseIdentifier();
                  te(this.state.type) ? (c = true, o = C, u = s ? this.parseIdentifier() : this.parseModuleExportName(), y = false) : (u = M, y = false);
                } else
                  te(this.state.type) ? (y = false, u = s ? this.parseIdentifier() : this.parseModuleExportName()) : (c = true, o = C);
              } else
                te(this.state.type) && (c = true, s ? (o = this.parseIdentifier(true), this.isContextual(93) || this.checkReservedWord(o.name, o.loc.start, true, true)) : o = this.parseModuleExportName());
              c && i && this.raise(s ? I.TypeModifierIsUsedInTypeImports : I.TypeModifierIsUsedInTypeExports, { at: g }), e[a] = o, e[n2] = u;
              let T = s ? "importKind" : "exportKind";
              e[T] = c ? "type" : "value", y && this.eatContextual(93) && (e[n2] = s ? this.parseIdentifier() : this.parseModuleExportName()), e[n2] || (e[n2] = me(e[a])), s && this.checkIdentifier(e[n2], c ? Sr : Ve);
            }
          };
          function ch(t) {
            if (t.type !== "MemberExpression")
              return false;
            let { computed: r, property: e } = t;
            return r && e.type !== "StringLiteral" && (e.type !== "TemplateLiteral" || e.expressions.length > 0) ? false : Vr(t.object);
          }
          function ph(t, r) {
            var e;
            let { type: s } = t;
            if ((e = t.extra) != null && e.parenthesized)
              return false;
            if (r) {
              if (s === "Literal") {
                let { value: i } = t;
                if (typeof i == "string" || typeof i == "boolean")
                  return true;
              }
            } else if (s === "StringLiteral" || s === "BooleanLiteral")
              return true;
            return !!(zr(t, r) || fh(t, r) || s === "TemplateLiteral" && t.expressions.length === 0 || ch(t));
          }
          function zr(t, r) {
            return r ? t.type === "Literal" && (typeof t.value == "number" || "bigint" in t) : t.type === "NumericLiteral" || t.type === "BigIntLiteral";
          }
          function fh(t, r) {
            if (t.type === "UnaryExpression") {
              let { operator: e, argument: s } = t;
              if (e === "-" && zr(s, r))
                return true;
            }
            return false;
          }
          function Vr(t) {
            return t.type === "Identifier" ? true : t.type !== "MemberExpression" || t.computed ? false : Vr(t.object);
          }
          var Kr = pe`placeholders`({ ClassNameIsRequired: "A class name is required.", UnexpectedSpace: "Unexpected space in placeholder." }), dh = (t) => class extends t {
            parsePlaceholder(e) {
              if (this.match(142)) {
                let s = this.startNode();
                return this.next(), this.assertNoSpace(), s.name = super.parseIdentifier(true), this.assertNoSpace(), this.expect(142), this.finishPlaceholder(s, e);
              }
            }
            finishPlaceholder(e, s) {
              let i = !!(e.expectedNode && e.type === "Placeholder");
              return e.expectedNode = s, i ? e : this.finishNode(e, "Placeholder");
            }
            getTokenFromCode(e) {
              e === 37 && this.input.charCodeAt(this.state.pos + 1) === 37 ? this.finishOp(142, 2) : super.getTokenFromCode(e);
            }
            parseExprAtom(e) {
              return this.parsePlaceholder("Expression") || super.parseExprAtom(e);
            }
            parseIdentifier(e) {
              return this.parsePlaceholder("Identifier") || super.parseIdentifier(e);
            }
            checkReservedWord(e, s, i, a) {
              e !== void 0 && super.checkReservedWord(e, s, i, a);
            }
            parseBindingAtom() {
              return this.parsePlaceholder("Pattern") || super.parseBindingAtom();
            }
            isValidLVal(e, s, i) {
              return e === "Placeholder" || super.isValidLVal(e, s, i);
            }
            toAssignable(e, s) {
              e && e.type === "Placeholder" && e.expectedNode === "Expression" ? e.expectedNode = "Pattern" : super.toAssignable(e, s);
            }
            chStartsBindingIdentifier(e, s) {
              return !!(super.chStartsBindingIdentifier(e, s) || this.lookahead().type === 142);
            }
            verifyBreakContinue(e, s) {
              e.label && e.label.type === "Placeholder" || super.verifyBreakContinue(e, s);
            }
            parseExpressionStatement(e, s) {
              if (s.type !== "Placeholder" || s.extra && s.extra.parenthesized)
                return super.parseExpressionStatement(e, s);
              if (this.match(14)) {
                let i = e;
                return i.label = this.finishPlaceholder(s, "Identifier"), this.next(), i.body = super.parseStatementOrSloppyAnnexBFunctionDeclaration(), this.finishNode(i, "LabeledStatement");
              }
              return this.semicolon(), e.name = s.name, this.finishPlaceholder(e, "Statement");
            }
            parseBlock(e, s, i) {
              return this.parsePlaceholder("BlockStatement") || super.parseBlock(e, s, i);
            }
            parseFunctionId(e) {
              return this.parsePlaceholder("Identifier") || super.parseFunctionId(e);
            }
            parseClass(e, s, i) {
              let a = s ? "ClassDeclaration" : "ClassExpression";
              this.next();
              let n2 = this.state.strict, o = this.parsePlaceholder("Identifier");
              if (o)
                if (this.match(81) || this.match(142) || this.match(5))
                  e.id = o;
                else {
                  if (i || !s)
                    return e.id = null, e.body = this.finishPlaceholder(o, "ClassBody"), this.finishNode(e, a);
                  throw this.raise(Kr.ClassNameIsRequired, { at: this.state.startLoc });
                }
              else
                this.parseClassId(e, s, i);
              return super.parseClassSuper(e), e.body = this.parsePlaceholder("ClassBody") || super.parseClassBody(!!e.superClass, n2), this.finishNode(e, a);
            }
            parseExport(e, s) {
              let i = this.parsePlaceholder("Identifier");
              if (!i)
                return super.parseExport(e, s);
              if (!this.isContextual(97) && !this.match(12))
                return e.specifiers = [], e.source = null, e.declaration = this.finishPlaceholder(i, "Declaration"), this.finishNode(e, "ExportNamedDeclaration");
              this.expectPlugin("exportDefaultFrom");
              let a = this.startNode();
              return a.exported = i, e.specifiers = [this.finishNode(a, "ExportDefaultSpecifier")], super.parseExport(e, s);
            }
            isExportDefaultSpecifier() {
              if (this.match(65)) {
                let e = this.nextTokenStart();
                if (this.isUnparsedContextual(e, "from") && this.input.startsWith(xe(142), this.nextTokenStartSince(e + 4)))
                  return true;
              }
              return super.isExportDefaultSpecifier();
            }
            maybeParseExportDefaultSpecifier(e) {
              return e.specifiers && e.specifiers.length > 0 ? true : super.maybeParseExportDefaultSpecifier(e);
            }
            checkExport(e) {
              let { specifiers: s } = e;
              s != null && s.length && (e.specifiers = s.filter((i) => i.exported.type === "Placeholder")), super.checkExport(e), e.specifiers = s;
            }
            parseImport(e) {
              let s = this.parsePlaceholder("Identifier");
              if (!s)
                return super.parseImport(e);
              if (e.specifiers = [], !this.isContextual(97) && !this.match(12))
                return e.source = this.finishPlaceholder(s, "StringLiteral"), this.semicolon(), this.finishNode(e, "ImportDeclaration");
              let i = this.startNodeAtNode(s);
              return i.local = s, e.specifiers.push(this.finishNode(i, "ImportDefaultSpecifier")), this.eat(12) && (this.maybeParseStarImportSpecifier(e) || this.parseNamedImportSpecifiers(e)), this.expectContextual(97), e.source = this.parseImportSource(), this.semicolon(), this.finishNode(e, "ImportDeclaration");
            }
            parseImportSource() {
              return this.parsePlaceholder("StringLiteral") || super.parseImportSource();
            }
            assertNoSpace() {
              this.state.start > this.state.lastTokEndLoc.index && this.raise(Kr.UnexpectedSpace, { at: this.state.lastTokEndLoc });
            }
          }, mh = (t) => class extends t {
            parseV8Intrinsic() {
              if (this.match(54)) {
                let e = this.state.startLoc, s = this.startNode();
                if (this.next(), q(this.state.type)) {
                  let i = this.parseIdentifierName(), a = this.createIdentifier(s, i);
                  if (a.type = "V8IntrinsicIdentifier", this.match(10))
                    return a;
                }
                this.unexpected(e);
              }
            }
            parseExprAtom(e) {
              return this.parseV8Intrinsic() || super.parseExprAtom(e);
            }
          };
          function J(t, r) {
            let [e, s] = typeof r == "string" ? [r, {}] : r, i = Object.keys(s), a = i.length === 0;
            return t.some((n2) => {
              if (typeof n2 == "string")
                return a && n2 === e;
              {
                let [o, u] = n2;
                if (o !== e)
                  return false;
                for (let c of i)
                  if (u[c] !== s[c])
                    return false;
                return true;
              }
            });
          }
          function we(t, r, e) {
            let s = t.find((i) => Array.isArray(i) ? i[0] === r : i === r);
            return s && Array.isArray(s) && s.length > 1 ? s[1][e] : null;
          }
          var Wr = ["minimal", "fsharp", "hack", "smart"], Gr = ["^^", "@@", "^", "%", "#"], Jr = ["hash", "bar"];
          function yh(t) {
            if (J(t, "decorators")) {
              if (J(t, "decorators-legacy"))
                throw new Error("Cannot use the decorators and decorators-legacy plugin together");
              let r = we(t, "decorators", "decoratorsBeforeExport");
              if (r != null && typeof r != "boolean")
                throw new Error("'decoratorsBeforeExport' must be a boolean, if specified.");
              let e = we(t, "decorators", "allowCallParenthesized");
              if (e != null && typeof e != "boolean")
                throw new Error("'allowCallParenthesized' must be a boolean.");
            }
            if (J(t, "flow") && J(t, "typescript"))
              throw new Error("Cannot combine flow and typescript plugins.");
            if (J(t, "placeholders") && J(t, "v8intrinsic"))
              throw new Error("Cannot combine placeholders and v8intrinsic plugins.");
            if (J(t, "pipelineOperator")) {
              let r = we(t, "pipelineOperator", "proposal");
              if (!Wr.includes(r)) {
                let s = Wr.map((i) => `"${i}"`).join(", ");
                throw new Error(`"pipelineOperator" requires "proposal" option whose value must be one of: ${s}.`);
              }
              let e = J(t, ["recordAndTuple", { syntaxType: "hash" }]);
              if (r === "hack") {
                if (J(t, "placeholders"))
                  throw new Error("Cannot combine placeholders plugin and Hack-style pipes.");
                if (J(t, "v8intrinsic"))
                  throw new Error("Cannot combine v8intrinsic plugin and Hack-style pipes.");
                let s = we(t, "pipelineOperator", "topicToken");
                if (!Gr.includes(s)) {
                  let i = Gr.map((a) => `"${a}"`).join(", ");
                  throw new Error(`"pipelineOperator" in "proposal": "hack" mode also requires a "topicToken" option whose value must be one of: ${i}.`);
                }
                if (s === "#" && e)
                  throw new Error('Plugin conflict between `["pipelineOperator", { proposal: "hack", topicToken: "#" }]` and `["recordAndtuple", { syntaxType: "hash"}]`.');
              } else if (r === "smart" && e)
                throw new Error('Plugin conflict between `["pipelineOperator", { proposal: "smart" }]` and `["recordAndtuple", { syntaxType: "hash"}]`.');
            }
            if (J(t, "moduleAttributes")) {
              if (J(t, "importAssertions"))
                throw new Error("Cannot combine importAssertions and moduleAttributes plugins.");
              if (we(t, "moduleAttributes", "version") !== "may-2020")
                throw new Error("The 'moduleAttributes' plugin requires a 'version' option, representing the last proposal update. Currently, the only supported value is 'may-2020'.");
            }
            if (J(t, "recordAndTuple") && we(t, "recordAndTuple", "syntaxType") != null && !Jr.includes(we(t, "recordAndTuple", "syntaxType")))
              throw new Error("The 'syntaxType' option of the 'recordAndTuple' plugin must be one of: " + Jr.map((r) => `'${r}'`).join(", "));
            if (J(t, "asyncDoExpressions") && !J(t, "doExpressions")) {
              let r = new Error("'asyncDoExpressions' requires 'doExpressions', please add 'doExpressions' to parser plugins.");
              throw r.missingPlugins = "doExpressions", r;
            }
          }
          var Xr = { estree: el, jsx: th, flow: Zl, typescript: uh, v8intrinsic: mh, placeholders: dh }, xh = Object.keys(Xr), gh = class extends ah {
            checkProto(t, r, e, s) {
              if (t.type === "SpreadElement" || this.isObjectMethod(t) || t.computed || t.shorthand)
                return;
              let i = t.key;
              if ((i.type === "Identifier" ? i.name : i.value) === "__proto__") {
                if (r) {
                  this.raise(f.RecordNoProto, { at: i });
                  return;
                }
                e.used && (s ? s.doubleProtoLoc === null && (s.doubleProtoLoc = i.loc.start) : this.raise(f.DuplicateProto, { at: i })), e.used = true;
              }
            }
            shouldExitDescending(t, r) {
              return t.type === "ArrowFunctionExpression" && t.start === r;
            }
            getExpression() {
              this.enterInitialScopes(), this.nextToken();
              let t = this.parseExpression();
              return this.match(137) || this.unexpected(), this.finalizeRemainingComments(), t.comments = this.state.comments, t.errors = this.state.errors, this.options.tokens && (t.tokens = this.tokens), t;
            }
            parseExpression(t, r) {
              return t ? this.disallowInAnd(() => this.parseExpressionBase(r)) : this.allowInAnd(() => this.parseExpressionBase(r));
            }
            parseExpressionBase(t) {
              let r = this.state.startLoc, e = this.parseMaybeAssign(t);
              if (this.match(12)) {
                let s = this.startNodeAt(r);
                for (s.expressions = [e]; this.eat(12); )
                  s.expressions.push(this.parseMaybeAssign(t));
                return this.toReferencedList(s.expressions), this.finishNode(s, "SequenceExpression");
              }
              return e;
            }
            parseMaybeAssignDisallowIn(t, r) {
              return this.disallowInAnd(() => this.parseMaybeAssign(t, r));
            }
            parseMaybeAssignAllowIn(t, r) {
              return this.allowInAnd(() => this.parseMaybeAssign(t, r));
            }
            setOptionalParametersError(t, r) {
              var e;
              t.optionalParametersLoc = (e = r == null ? void 0 : r.loc) != null ? e : this.state.startLoc;
            }
            parseMaybeAssign(t, r) {
              let e = this.state.startLoc;
              if (this.isContextual(106) && this.prodParam.hasYield) {
                let n2 = this.parseYield();
                return r && (n2 = r.call(this, n2, e)), n2;
              }
              let s;
              t ? s = false : (t = new vt(), s = true);
              let { type: i } = this.state;
              (i === 10 || q(i)) && (this.state.potentialArrowAt = this.state.start);
              let a = this.parseMaybeConditional(t);
              if (r && (a = r.call(this, a, e)), Bo(this.state.type)) {
                let n2 = this.startNodeAt(e), o = this.state.value;
                if (n2.operator = o, this.match(29)) {
                  this.toAssignable(a, true), n2.left = a;
                  let u = e.index;
                  t.doubleProtoLoc != null && t.doubleProtoLoc.index >= u && (t.doubleProtoLoc = null), t.shorthandAssignLoc != null && t.shorthandAssignLoc.index >= u && (t.shorthandAssignLoc = null), t.privateKeyLoc != null && t.privateKeyLoc.index >= u && (this.checkDestructuringPrivate(t), t.privateKeyLoc = null);
                } else
                  n2.left = a;
                return this.next(), n2.right = this.parseMaybeAssign(), this.checkLVal(a, { in: this.finishNode(n2, "AssignmentExpression") }), n2;
              } else
                s && this.checkExpressionErrors(t, true);
              return a;
            }
            parseMaybeConditional(t) {
              let r = this.state.startLoc, e = this.state.potentialArrowAt, s = this.parseExprOps(t);
              return this.shouldExitDescending(s, e) ? s : this.parseConditional(s, r, t);
            }
            parseConditional(t, r, e) {
              if (this.eat(17)) {
                let s = this.startNodeAt(r);
                return s.test = t, s.consequent = this.parseMaybeAssignAllowIn(), this.expect(14), s.alternate = this.parseMaybeAssign(), this.finishNode(s, "ConditionalExpression");
              }
              return t;
            }
            parseMaybeUnaryOrPrivate(t) {
              return this.match(136) ? this.parsePrivateName() : this.parseMaybeUnary(t);
            }
            parseExprOps(t) {
              let r = this.state.startLoc, e = this.state.potentialArrowAt, s = this.parseMaybeUnaryOrPrivate(t);
              return this.shouldExitDescending(s, e) ? s : this.parseExprOp(s, r, -1);
            }
            parseExprOp(t, r, e) {
              if (this.isPrivateName(t)) {
                let i = this.getPrivateNameSV(t);
                (e >= at(58) || !this.prodParam.hasIn || !this.match(58)) && this.raise(f.PrivateInExpectedIn, { at: t, identifierName: i }), this.classScope.usePrivateName(i, t.loc.start);
              }
              let s = this.state.type;
              if (_o(s) && (this.prodParam.hasIn || !this.match(58))) {
                let i = at(s);
                if (i > e) {
                  if (s === 39) {
                    if (this.expectPlugin("pipelineOperator"), this.state.inFSharpPipelineDirectBody)
                      return t;
                    this.checkPipelineAtInfixOperator(t, r);
                  }
                  let a = this.startNodeAt(r);
                  a.left = t, a.operator = this.state.value;
                  let n2 = s === 41 || s === 42, o = s === 40;
                  if (o && (i = at(42)), this.next(), s === 39 && this.hasPlugin(["pipelineOperator", { proposal: "minimal" }]) && this.state.type === 96 && this.prodParam.hasAwait)
                    throw this.raise(f.UnexpectedAwaitAfterPipelineBody, { at: this.state.startLoc });
                  a.right = this.parseExprOpRightExpr(s, i);
                  let u = this.finishNode(a, n2 || o ? "LogicalExpression" : "BinaryExpression"), c = this.state.type;
                  if (o && (c === 41 || c === 42) || n2 && c === 40)
                    throw this.raise(f.MixingCoalesceWithLogical, { at: this.state.startLoc });
                  return this.parseExprOp(u, r, e);
                }
              }
              return t;
            }
            parseExprOpRightExpr(t, r) {
              let e = this.state.startLoc;
              switch (t) {
                case 39:
                  switch (this.getPluginOption("pipelineOperator", "proposal")) {
                    case "hack":
                      return this.withTopicBindingContext(() => this.parseHackPipeBody());
                    case "smart":
                      return this.withTopicBindingContext(() => {
                        if (this.prodParam.hasYield && this.isContextual(106))
                          throw this.raise(f.PipeBodyIsTighter, { at: this.state.startLoc });
                        return this.parseSmartPipelineBodyInStyle(this.parseExprOpBaseRightExpr(t, r), e);
                      });
                    case "fsharp":
                      return this.withSoloAwaitPermittingContext(() => this.parseFSharpPipelineBody(r));
                  }
                default:
                  return this.parseExprOpBaseRightExpr(t, r);
              }
            }
            parseExprOpBaseRightExpr(t, r) {
              let e = this.state.startLoc;
              return this.parseExprOp(this.parseMaybeUnaryOrPrivate(), e, $o(t) ? r - 1 : r);
            }
            parseHackPipeBody() {
              var t;
              let { startLoc: r } = this.state, e = this.parseMaybeAssign();
              return Go.has(e.type) && !((t = e.extra) != null && t.parenthesized) && this.raise(f.PipeUnparenthesizedBody, { at: r, type: e.type }), this.topicReferenceWasUsedInCurrentContext() || this.raise(f.PipeTopicUnused, { at: r }), e;
            }
            checkExponentialAfterUnary(t) {
              this.match(57) && this.raise(f.UnexpectedTokenUnaryExponentiation, { at: t.argument });
            }
            parseMaybeUnary(t, r) {
              let e = this.state.startLoc, s = this.isContextual(96);
              if (s && this.isAwaitAllowed()) {
                this.next();
                let o = this.parseAwait(e);
                return r || this.checkExponentialAfterUnary(o), o;
              }
              let i = this.match(34), a = this.startNode();
              if (jo(this.state.type)) {
                a.operator = this.state.value, a.prefix = true, this.match(72) && this.expectPlugin("throwExpressions");
                let o = this.match(89);
                if (this.next(), a.argument = this.parseMaybeUnary(null, true), this.checkExpressionErrors(t, true), this.state.strict && o) {
                  let u = a.argument;
                  u.type === "Identifier" ? this.raise(f.StrictDelete, { at: a }) : this.hasPropertyAsPrivateName(u) && this.raise(f.DeletePrivateField, { at: a });
                }
                if (!i)
                  return r || this.checkExponentialAfterUnary(a), this.finishNode(a, "UnaryExpression");
              }
              let n2 = this.parseUpdate(a, i, t);
              if (s) {
                let { type: o } = this.state;
                if ((this.hasPlugin("v8intrinsic") ? He(o) : He(o) && !this.match(54)) && !this.isAmbiguousAwait())
                  return this.raiseOverwrite(f.AwaitNotInAsyncContext, { at: e }), this.parseAwait(e);
              }
              return n2;
            }
            parseUpdate(t, r, e) {
              if (r) {
                let a = t;
                return this.checkLVal(a.argument, { in: this.finishNode(a, "UpdateExpression") }), t;
              }
              let s = this.state.startLoc, i = this.parseExprSubscripts(e);
              if (this.checkExpressionErrors(e, false))
                return i;
              for (; Ro(this.state.type) && !this.canInsertSemicolon(); ) {
                let a = this.startNodeAt(s);
                a.operator = this.state.value, a.prefix = false, a.argument = i, this.next(), this.checkLVal(i, { in: i = this.finishNode(a, "UpdateExpression") });
              }
              return i;
            }
            parseExprSubscripts(t) {
              let r = this.state.startLoc, e = this.state.potentialArrowAt, s = this.parseExprAtom(t);
              return this.shouldExitDescending(s, e) ? s : this.parseSubscripts(s, r);
            }
            parseSubscripts(t, r, e) {
              let s = { optionalChainMember: false, maybeAsyncArrow: this.atPossibleAsyncArrow(t), stop: false };
              do
                t = this.parseSubscript(t, r, e, s), s.maybeAsyncArrow = false;
              while (!s.stop);
              return t;
            }
            parseSubscript(t, r, e, s) {
              let { type: i } = this.state;
              if (!e && i === 15)
                return this.parseBind(t, r, e, s);
              if (nt(i))
                return this.parseTaggedTemplateExpression(t, r, s);
              let a = false;
              if (i === 18) {
                if (e && (this.raise(f.OptionalChainingNoNew, { at: this.state.startLoc }), this.lookaheadCharCode() === 40))
                  return s.stop = true, t;
                s.optionalChainMember = a = true, this.next();
              }
              if (!e && this.match(10))
                return this.parseCoverCallAndAsyncArrowHead(t, r, s, a);
              {
                let n2 = this.eat(0);
                return n2 || a || this.eat(16) ? this.parseMember(t, r, s, n2, a) : (s.stop = true, t);
              }
            }
            parseMember(t, r, e, s, i) {
              let a = this.startNodeAt(r);
              return a.object = t, a.computed = s, s ? (a.property = this.parseExpression(), this.expect(3)) : this.match(136) ? (t.type === "Super" && this.raise(f.SuperPrivateField, { at: r }), this.classScope.usePrivateName(this.state.value, this.state.startLoc), a.property = this.parsePrivateName()) : a.property = this.parseIdentifier(true), e.optionalChainMember ? (a.optional = i, this.finishNode(a, "OptionalMemberExpression")) : this.finishNode(a, "MemberExpression");
            }
            parseBind(t, r, e, s) {
              let i = this.startNodeAt(r);
              return i.object = t, this.next(), i.callee = this.parseNoCallExpr(), s.stop = true, this.parseSubscripts(this.finishNode(i, "BindExpression"), r, e);
            }
            parseCoverCallAndAsyncArrowHead(t, r, e, s) {
              let i = this.state.maybeInArrowParameters, a = null;
              this.state.maybeInArrowParameters = true, this.next();
              let n2 = this.startNodeAt(r);
              n2.callee = t;
              let { maybeAsyncArrow: o, optionalChainMember: u } = e;
              o && (this.expressionScope.enter($l()), a = new vt()), u && (n2.optional = s), s ? n2.arguments = this.parseCallExpressionArguments(11) : n2.arguments = this.parseCallExpressionArguments(11, t.type === "Import", t.type !== "Super", n2, a);
              let c = this.finishCallExpression(n2, u);
              return o && this.shouldParseAsyncArrow() && !s ? (e.stop = true, this.checkDestructuringPrivate(a), this.expressionScope.validateAsPattern(), this.expressionScope.exit(), c = this.parseAsyncArrowFromCallExpression(this.startNodeAt(r), c)) : (o && (this.checkExpressionErrors(a, true), this.expressionScope.exit()), this.toReferencedArguments(c)), this.state.maybeInArrowParameters = i, c;
            }
            toReferencedArguments(t, r) {
              this.toReferencedListDeep(t.arguments, r);
            }
            parseTaggedTemplateExpression(t, r, e) {
              let s = this.startNodeAt(r);
              return s.tag = t, s.quasi = this.parseTemplate(true), e.optionalChainMember && this.raise(f.OptionalChainingNoTemplate, { at: r }), this.finishNode(s, "TaggedTemplateExpression");
            }
            atPossibleAsyncArrow(t) {
              return t.type === "Identifier" && t.name === "async" && this.state.lastTokEndLoc.index === t.end && !this.canInsertSemicolon() && t.end - t.start === 5 && t.start === this.state.potentialArrowAt;
            }
            finishCallExpression(t, r) {
              if (t.callee.type === "Import")
                if (t.arguments.length === 2 && (this.hasPlugin("moduleAttributes") || this.expectPlugin("importAssertions")), t.arguments.length === 0 || t.arguments.length > 2)
                  this.raise(f.ImportCallArity, { at: t, maxArgumentCount: this.hasPlugin("importAssertions") || this.hasPlugin("moduleAttributes") ? 2 : 1 });
                else
                  for (let e of t.arguments)
                    e.type === "SpreadElement" && this.raise(f.ImportCallSpreadArgument, { at: e });
              return this.finishNode(t, r ? "OptionalCallExpression" : "CallExpression");
            }
            parseCallExpressionArguments(t, r, e, s, i) {
              let a = [], n2 = true, o = this.state.inFSharpPipelineDirectBody;
              for (this.state.inFSharpPipelineDirectBody = false; !this.eat(t); ) {
                if (n2)
                  n2 = false;
                else if (this.expect(12), this.match(t)) {
                  r && !this.hasPlugin("importAssertions") && !this.hasPlugin("moduleAttributes") && this.raise(f.ImportCallArgumentTrailingComma, { at: this.state.lastTokStartLoc }), s && this.addTrailingCommaExtraToNode(s), this.next();
                  break;
                }
                a.push(this.parseExprListItem(false, i, e));
              }
              return this.state.inFSharpPipelineDirectBody = o, a;
            }
            shouldParseAsyncArrow() {
              return this.match(19) && !this.canInsertSemicolon();
            }
            parseAsyncArrowFromCallExpression(t, r) {
              var e;
              return this.resetPreviousNodeTrailingComments(r), this.expect(19), this.parseArrowExpression(t, r.arguments, true, (e = r.extra) == null ? void 0 : e.trailingCommaLoc), r.innerComments && Ke(t, r.innerComments), r.callee.trailingComments && Ke(t, r.callee.trailingComments), t;
            }
            parseNoCallExpr() {
              let t = this.state.startLoc;
              return this.parseSubscripts(this.parseExprAtom(), t, true);
            }
            parseExprAtom(t) {
              let r, e = null, { type: s } = this.state;
              switch (s) {
                case 79:
                  return this.parseSuper();
                case 83:
                  return r = this.startNode(), this.next(), this.match(16) ? this.parseImportMetaProperty(r) : (this.match(10) || this.raise(f.UnsupportedImport, { at: this.state.lastTokStartLoc }), this.finishNode(r, "Import"));
                case 78:
                  return r = this.startNode(), this.next(), this.finishNode(r, "ThisExpression");
                case 90:
                  return this.parseDo(this.startNode(), false);
                case 56:
                case 31:
                  return this.readRegexp(), this.parseRegExpLiteral(this.state.value);
                case 132:
                  return this.parseNumericLiteral(this.state.value);
                case 133:
                  return this.parseBigIntLiteral(this.state.value);
                case 134:
                  return this.parseDecimalLiteral(this.state.value);
                case 131:
                  return this.parseStringLiteral(this.state.value);
                case 84:
                  return this.parseNullLiteral();
                case 85:
                  return this.parseBooleanLiteral(true);
                case 86:
                  return this.parseBooleanLiteral(false);
                case 10: {
                  let i = this.state.potentialArrowAt === this.state.start;
                  return this.parseParenAndDistinguishExpression(i);
                }
                case 2:
                case 1:
                  return this.parseArrayLike(this.state.type === 2 ? 4 : 3, false, true);
                case 0:
                  return this.parseArrayLike(3, true, false, t);
                case 6:
                case 7:
                  return this.parseObjectLike(this.state.type === 6 ? 9 : 8, false, true);
                case 5:
                  return this.parseObjectLike(8, false, false, t);
                case 68:
                  return this.parseFunctionOrFunctionSent();
                case 26:
                  e = this.parseDecorators();
                case 80:
                  return this.parseClass(this.maybeTakeDecorators(e, this.startNode()), false);
                case 77:
                  return this.parseNewOrNewTarget();
                case 25:
                case 24:
                  return this.parseTemplate(false);
                case 15: {
                  r = this.startNode(), this.next(), r.object = null;
                  let i = r.callee = this.parseNoCallExpr();
                  if (i.type === "MemberExpression")
                    return this.finishNode(r, "BindExpression");
                  throw this.raise(f.UnsupportedBind, { at: i });
                }
                case 136:
                  return this.raise(f.PrivateInExpectedIn, { at: this.state.startLoc, identifierName: this.state.value }), this.parsePrivateName();
                case 33:
                  return this.parseTopicReferenceThenEqualsSign(54, "%");
                case 32:
                  return this.parseTopicReferenceThenEqualsSign(44, "^");
                case 37:
                case 38:
                  return this.parseTopicReference("hack");
                case 44:
                case 54:
                case 27: {
                  let i = this.getPluginOption("pipelineOperator", "proposal");
                  if (i)
                    return this.parseTopicReference(i);
                  this.unexpected();
                  break;
                }
                case 47: {
                  let i = this.input.codePointAt(this.nextTokenStart());
                  fe(i) || i === 62 ? this.expectOnePlugin(["jsx", "flow", "typescript"]) : this.unexpected();
                  break;
                }
                default:
                  if (q(s)) {
                    if (this.isContextual(125) && this.lookaheadCharCode() === 123 && !this.hasFollowingLineBreak())
                      return this.parseModuleExpression();
                    let i = this.state.potentialArrowAt === this.state.start, a = this.state