/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.StreamReceiver;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.StreamReceiverHandler;
import com.vaadin.flow.server.communication.StreamResourceHandler;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamRequestHandler
implements RequestHandler {
    private static final char PATH_SEPARATOR = '/';
    static final String DYN_RES_PREFIX = "VAADIN/dynamic/resource/";
    private StreamResourceHandler resourceHandler = new StreamResourceHandler();
    private StreamReceiverHandler receiverHandler = new StreamReceiverHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        Optional abstractStreamResource;
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            return false;
        }
        assert (pathInfo.startsWith(Character.toString('/')));
        if (!(pathInfo = pathInfo.substring(1)).startsWith(DYN_RES_PREFIX)) {
            return false;
        }
        session.lock();
        try {
            abstractStreamResource = StreamRequestHandler.getPathUri(pathInfo).flatMap(session.getResourceRegistry()::getResource);
            if (!abstractStreamResource.isPresent()) {
                response.sendError(404, "Resource is not found for path=" + pathInfo);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            session.unlock();
        }
        if (abstractStreamResource.isPresent()) {
            AbstractStreamResource resource = (AbstractStreamResource)abstractStreamResource.get();
            if (resource instanceof StreamResource) {
                this.resourceHandler.handleRequest(session, request, response, (StreamResource)resource);
            } else if (resource instanceof StreamReceiver) {
                StreamReceiver streamReceiver = (StreamReceiver)resource;
                String[] parts = this.parsePath(pathInfo);
                this.receiverHandler.handleRequest(session, request, response, streamReceiver, parts[0], parts[1]);
            } else {
                StreamRequestHandler.getLogger().warn("Received unknown stream resource.");
            }
        }
        return true;
    }

    private String[] parsePath(String pathInfo) {
        int startOfData = pathInfo.indexOf(DYN_RES_PREFIX) + DYN_RES_PREFIX.length();
        String uppUri = pathInfo.substring(startOfData);
        return uppUri.split("/", 3);
    }

    public static String generateURI(String name, String id) {
        StringBuilder builder = new StringBuilder(DYN_RES_PREFIX);
        try {
            builder.append(UI.getCurrent().getUIId()).append('/');
            builder.append(id).append('/');
            builder.append(URLEncoder.encode(name, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return builder.toString();
    }

    private static Optional<URI> getPathUri(String path) {
        boolean hasPrefix;
        int index = path.lastIndexOf(47);
        boolean bl = hasPrefix = index >= 0;
        if (!hasPrefix) {
            StreamRequestHandler.getLogger().info("Unsupported path structure, path={}", (Object)path);
            return Optional.empty();
        }
        String prefix = path.substring(0, index + 1);
        String name = path.substring(prefix.length());
        name = name.replace('+', ' ');
        try {
            URI uri = new URI(prefix + URLEncoder.encode(name, StandardCharsets.UTF_8.name()));
            return Optional.of(uri);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            StreamRequestHandler.getLogger().info("Path '{}' is not correct URI (it violates RFC 2396)", (Object)path, (Object)e);
            return Optional.empty();
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)StreamResourceHandler.class.getName());
    }
}

