/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.Pair;
import com.vaadin.flow.server.DevServerWatchDog;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.StaticFileServer;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DevModeHandler
implements RequestHandler {
    private static final String START_FAILURE = "Couldn't start dev server because";
    private static final AtomicReference<DevModeHandler> atomicHandler = new AtomicReference();
    private static final Pattern WEBPACK_ILLEGAL_CHAR_PATTERN = Pattern.compile("\"|%22");
    private static final String DEFAULT_OUTPUT_PATTERN = ": Compiled.";
    private static final String DEFAULT_ERROR_PATTERN = ": Failed to compile.";
    private static final String FAILED_MSG = "\n------------------ Frontend compilation failed. -----------------";
    private static final String SUCCEED_MSG = "\n----------------- Frontend compiled successfully. -----------------";
    private static final String START = "\n------------------ Starting Frontend compilation. ------------------\n";
    private static final String END = "\n------------------------- Webpack stopped  -------------------------\n";
    private static final String LOG_START = "Running webpack to compile frontend resources. This may take a moment, please stand by...";
    private static final String LOG_END = "Started webpack-dev-server. Time: {}ms";
    private static final String DEFAULT_TIMEOUT_FOR_PATTERN = "60000";
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private static final int DEFAULT_TIMEOUT = 120000;
    private static final String WEBPACK_HOST = "http://localhost";
    private boolean notified = false;
    private StringBuilder cumulativeOutput = new StringBuilder();
    private volatile String failedOutput;
    private AtomicBoolean isDevServerFailedToStart = new AtomicBoolean();
    private transient BrowserLiveReload liveReload;
    public static final String WEBPACK_SERVER = "node_modules/webpack-dev-server/bin/webpack-dev-server.js";
    private volatile int port;
    private final AtomicReference<Process> webpackProcess = new AtomicReference();
    private final boolean reuseDevServer;
    private final AtomicReference<DevServerWatchDog> watchDog = new AtomicReference();
    private final CompletableFuture<Void> devServerStartFuture;
    private final File npmFolder;

    private DevModeHandler(DeploymentConfiguration config, int runningPort, File npmFolder, CompletableFuture<Void> waitFor) {
        this.npmFolder = Objects.requireNonNull(npmFolder);
        this.port = runningPort;
        this.reuseDevServer = config.reuseDevServer();
        Object service = config.getInitParameters().get(Executor.class);
        BiConsumer<Void, Throwable> action = (value, exception) -> {
            waitFor.getNow(null);
            this.runOnFutureComplete(config);
        };
        this.devServerStartFuture = service instanceof Executor ? waitFor.whenCompleteAsync((BiConsumer)action, (Executor)service) : waitFor.whenCompleteAsync((BiConsumer)action);
    }

    public static DevModeHandler start(DeploymentConfiguration configuration, File npmFolder, CompletableFuture<Void> waitFor) {
        return DevModeHandler.start(0, configuration, npmFolder, waitFor);
    }

    public static DevModeHandler start(int runningPort, DeploymentConfiguration configuration, File npmFolder, CompletableFuture<Void> waitFor) {
        if (configuration.isProductionMode() || !configuration.enableDevServer()) {
            return null;
        }
        DevModeHandler handler = atomicHandler.get();
        if (handler == null) {
            handler = DevModeHandler.createInstance(runningPort, configuration, npmFolder, waitFor);
            atomicHandler.compareAndSet(null, handler);
        }
        return DevModeHandler.getDevModeHandler();
    }

    public static DevModeHandler getDevModeHandler() {
        return atomicHandler.get();
    }

    @Override
    public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        if (this.devServerStartFuture.isDone()) {
            try {
                this.devServerStartFuture.getNow(null);
            }
            catch (CompletionException exception) {
                this.isDevServerFailedToStart.set(true);
                throw this.getCause(exception);
            }
            return false;
        }
        try (InputStream inputStream = DevModeHandler.class.getResourceAsStream("dev-mode-not-ready.html");){
            IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
        }
        response.setContentType("text/html;charset=utf-8");
        return true;
    }

    private RuntimeException getCause(Throwable exception) {
        if (exception instanceof CompletionException) {
            return this.getCause(exception.getCause());
        }
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        return new IllegalStateException(exception);
    }

    public void setLiveReload(BrowserLiveReload liveReload) {
        this.liveReload = liveReload;
    }

    public BrowserLiveReload getLiveReload() {
        return this.liveReload;
    }

    private static DevModeHandler createInstance(int runningPort, DeploymentConfiguration configuration, File npmFolder, CompletableFuture<Void> waitFor) {
        return new DevModeHandler(configuration, runningPort, npmFolder, waitFor);
    }

    public boolean isDevModeRequest(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        return pathInfo != null && (pathInfo.startsWith("/VAADIN/") || StaticFileServer.APP_THEME_PATTERN.matcher(pathInfo).find()) && !pathInfo.startsWith("/VAADIN/dynamic/resource/");
    }

    public boolean serveDevModeRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.isDevServerFailedToStart.get() || !this.devServerStartFuture.isDone()) {
            return false;
        }
        String requestFilename = request.getPathInfo();
        if (HandlerHelper.isPathUnsafe(requestFilename) || WEBPACK_ILLEGAL_CHAR_PATTERN.matcher(requestFilename).find()) {
            DevModeHandler.getLogger().info("Blocked attempt to access file: {}", (Object)requestFilename);
            response.setStatus(403);
            return true;
        }
        if (StaticFileServer.APP_THEME_PATTERN.matcher(requestFilename).find()) {
            requestFilename = "/VAADIN/static" + requestFilename;
        }
        HttpURLConnection connection = this.prepareConnection(requestFilename, request.getMethod());
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String header2;
            connection.setRequestProperty(header2, "Connect".equals(header2 = (String)headerNames.nextElement()) ? "close" : request.getHeader(header2));
        }
        DevModeHandler.getLogger().debug("Requesting resource to webpack {}", (Object)connection.getURL());
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            DevModeHandler.getLogger().debug("Resource not served by webpack {}", (Object)requestFilename);
            return false;
        }
        DevModeHandler.getLogger().debug("Served resource by webpack: {} {}", (Object)responseCode, (Object)requestFilename);
        connection.getHeaderFields().forEach((header, values) -> {
            if (header != null) {
                if ("Transfer-Encoding".equals(header)) {
                    return;
                }
                response.addHeader(header, (String)values.get(0));
            }
        });
        if (responseCode == 200) {
            this.writeStream(response.getOutputStream(), connection.getInputStream());
        } else if (responseCode < 400) {
            response.setStatus(responseCode);
        } else {
            response.sendError(responseCode);
        }
        response.getOutputStream().close();
        return true;
    }

    private boolean checkWebpackConnection() {
        try {
            this.prepareConnection("/", "GET").getResponseCode();
            return true;
        }
        catch (IOException e) {
            DevModeHandler.getLogger().debug("Error checking webpack dev server connection", (Throwable)e);
            return false;
        }
    }

    public HttpURLConnection prepareConnection(String path, String method) throws IOException {
        URL uri = new URL("http://localhost:" + this.getPort() + path);
        HttpURLConnection connection = (HttpURLConnection)uri.openConnection();
        connection.setRequestMethod(method);
        connection.setReadTimeout(120000);
        connection.setConnectTimeout(120000);
        return connection;
    }

    private synchronized void doNotify() {
        if (!this.notified) {
            this.notified = true;
            this.notifyAll();
        }
    }

    private void logStream(InputStream input, Pattern success, Pattern failure) {
        Thread thread = new Thread(() -> {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            try {
                this.readLinesLoop(success, failure, reader);
            }
            catch (IOException e) {
                if ("Stream closed".equals(e.getMessage())) {
                    FrontendUtils.console("\u001b[38;5;35m%s\u001b[0m", END);
                    DevModeHandler.getLogger().debug("Exception when reading webpack output.", (Throwable)e);
                }
                DevModeHandler.getLogger().error("Exception when reading webpack output.", (Throwable)e);
            }
            this.doNotify();
        });
        thread.setDaemon(true);
        thread.setName("webpack");
        thread.start();
    }

    private void readLinesLoop(Pattern success, Pattern failure, BufferedReader reader) throws IOException {
        String line;
        StringBuilder output = this.getOutputBuilder();
        Consumer<String> info = s -> DevModeHandler.getLogger().debug(String.format("\u001b[38;5;35m%s\u001b[0m", "{}"), s);
        Consumer<String> error = s -> DevModeHandler.getLogger().error(String.format("\u001b[38;5;196m%s\u001b[0m", "{}"), s);
        Consumer<String> warn = s -> DevModeHandler.getLogger().debug(String.format("\u001b[38;5;111m%s\u001b[0m", "{}"), s);
        Consumer<String> log = info;
        while ((line = reader.readLine()) != null) {
            String cleanLine = line.replaceAll("\u001b\\[[;\\d]*m", "").replaceAll("\\?babel-target=[\\w\\d]+", "");
            log = line.contains("WARNING") ? warn : (line.contains("ERROR") ? error : (this.isInfo(line, cleanLine) ? info : log));
            log.accept(cleanLine);
            if (log.equals(error)) {
                output.append(cleanLine).append(System.lineSeparator());
            }
            this.cumulativeOutput.append(cleanLine).append(System.lineSeparator());
            boolean succeed = success.matcher(line).find();
            boolean failed = failure.matcher(line).find();
            if (!succeed && !failed) continue;
            log.accept(succeed ? SUCCEED_MSG : FAILED_MSG);
            this.failedOutput = failed ? output.toString() : null;
            output = this.getOutputBuilder();
            this.cumulativeOutput = new StringBuilder();
            log = info;
            this.doNotify();
        }
    }

    private boolean isInfo(String line, String cleanLine) {
        return line.trim().isEmpty() || cleanLine.trim().startsWith("i");
    }

    private StringBuilder getOutputBuilder() {
        StringBuilder output = new StringBuilder();
        output.append(String.format("Webpack build failed with errors:%n", new Object[0]));
        return output;
    }

    private void writeStream(ServletOutputStream outputStream, InputStream inputStream) throws IOException {
        int bytes;
        byte[] buffer = new byte[32768];
        while ((bytes = inputStream.read(buffer)) >= 0) {
            outputStream.write(buffer, 0, bytes);
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)"dev-webpack");
    }

    public String getFailedOutput() {
        return this.failedOutput;
    }

    public void removeRunningDevServerPort() {
        FileUtils.deleteQuietly((File)LazyDevServerPortFileInit.DEV_SERVER_PORT_FILE);
    }

    private void runOnFutureComplete(DeploymentConfiguration config) {
        try {
            this.doStartDevModeServer(config);
        }
        catch (ExecutionFailedException exception) {
            DevModeHandler.getLogger().error(null, (Throwable)exception);
            throw new CompletionException(exception);
        }
    }

    private void saveRunningDevServerPort() {
        File portFile = LazyDevServerPortFileInit.DEV_SERVER_PORT_FILE;
        try {
            FileUtils.writeStringToFile((File)portFile, (String)String.valueOf(this.port), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStartDevModeServer(DeploymentConfiguration config) throws ExecutionFailedException {
        if (this.port > 0) {
            if (!this.checkWebpackConnection()) {
                throw new IllegalStateException(String.format("%s webpack-dev-server port '%d' is defined but it's not working properly", START_FAILURE, this.port));
            }
            this.reuseExistingPort(this.port);
            return;
        }
        this.port = DevModeHandler.getRunningDevServerPort();
        if (this.port > 0) {
            if (this.checkWebpackConnection()) {
                this.reuseExistingPort(this.port);
                return;
            }
            DevModeHandler.getLogger().warn("webpack-dev-server port '%d' is defined but it's not working properly. Using a new free port...", (Object)this.port);
            this.port = 0;
        }
        Pair<File, File> webPackFiles = this.validateFiles(this.npmFolder);
        DevModeHandler.getLogger().info("Starting webpack-dev-server");
        this.watchDog.set(new DevServerWatchDog());
        this.port = DevModeHandler.getFreePort();
        this.saveRunningDevServerPort();
        boolean success = false;
        try {
            success = this.doStartWebpack(config, webPackFiles);
        }
        finally {
            if (!success) {
                this.removeRunningDevServerPort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doStartWebpack(DeploymentConfiguration config, Pair<File, File> webPackFiles) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).directory(this.npmFolder);
        String nodeVersion = config.getStringProperty("node.version", "v14.21.3");
        String nodeDownloadRoot = config.getStringProperty("node.download.root", "https://nodejs.org/dist/");
        boolean useHomeNodeExec = config.getBooleanProperty("require.home.node", false);
        FrontendTools tools = new FrontendTools(this.npmFolder.getAbsolutePath(), () -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath(), nodeVersion, URI.create(nodeDownloadRoot), useHomeNodeExec);
        tools.validateNodeAndNpmVersion();
        processBuilder.environment().putAll(tools.getWebpackNodeEnvironment());
        String nodeExec = null;
        nodeExec = useHomeNodeExec ? tools.forceAlternativeNodeExecutable() : tools.getNodeExecutable();
        List<String> command = this.makeCommands(config, webPackFiles.getFirst(), webPackFiles.getSecond(), nodeExec);
        FrontendUtils.console("\u001b[38;5;35m%s\u001b[0m", START);
        if (DevModeHandler.getLogger().isDebugEnabled()) {
            DevModeHandler.getLogger().debug(FrontendUtils.commandToString(this.npmFolder.getAbsolutePath(), command));
        }
        long start = System.nanoTime();
        processBuilder.command(command);
        processBuilder.environment().put("watchDogPort", Integer.toString(this.watchDog.get().getWatchDogPort()));
        try {
            this.webpackProcess.set(processBuilder.redirectError(ProcessBuilder.Redirect.PIPE).redirectErrorStream(true).start());
            Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
            Pattern succeed = Pattern.compile(config.getStringProperty("devmode.webpack.output.success.pattern", DEFAULT_OUTPUT_PATTERN));
            Pattern failure = Pattern.compile(config.getStringProperty("devmode.webpack.output.error.pattern", DEFAULT_ERROR_PATTERN));
            this.logStream(this.webpackProcess.get().getInputStream(), succeed, failure);
            DevModeHandler.getLogger().info(LOG_START);
            DevModeHandler devModeHandler = this;
            synchronized (devModeHandler) {
                this.wait(Integer.parseInt(config.getStringProperty("devmode.webpack.output.pattern.timeout", DEFAULT_TIMEOUT_FOR_PATTERN)));
            }
            if (!this.webpackProcess.get().isAlive()) {
                DevModeHandler.getLogger().error(String.format("Webpack failed with the exception:%n%s", this.cumulativeOutput.toString()));
                throw new IllegalStateException("Webpack exited prematurely");
            }
            long ms = (System.nanoTime() - start) / 1000000L;
            DevModeHandler.getLogger().info(LOG_END, (Object)ms);
            this.saveRunningDevServerPort();
            return true;
        }
        catch (IOException e) {
            DevModeHandler.getLogger().error("Failed to start the webpack process", (Throwable)e);
        }
        catch (InterruptedException e) {
            DevModeHandler.getLogger().debug("Webpack process start has been interrupted", (Throwable)e);
        }
        return false;
    }

    private void reuseExistingPort(int port) {
        DevModeHandler.getLogger().info("Reusing webpack-dev-server running at {}:{}", (Object)WEBPACK_HOST, (Object)port);
        this.saveRunningDevServerPort();
        this.watchDog.set(null);
    }

    private List<String> makeCommands(DeploymentConfiguration config, File webpack, File webpackConfig, String nodeExec) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(nodeExec);
        command.add(webpack.getAbsolutePath());
        command.add("--config");
        command.add(webpackConfig.getAbsolutePath());
        command.add("--port");
        command.add(String.valueOf(this.port));
        command.add("--host=127.0.0.1");
        command.addAll(Arrays.asList(config.getStringProperty("devmode.webpack.options", "-d --inline=false").split(" +")));
        return command;
    }

    private Pair<File, File> validateFiles(File npmFolder) throws ExecutionFailedException {
        assert (this.port == 0);
        File webpack = new File(npmFolder, WEBPACK_SERVER);
        File webpackConfig = new File(npmFolder, "webpack.config.js");
        if (!npmFolder.exists()) {
            DevModeHandler.getLogger().warn("No project folder '{}' exists", (Object)npmFolder);
            throw new ExecutionFailedException("Couldn't start dev server because the target execution folder doesn't exist.");
        }
        if (!webpack.exists()) {
            DevModeHandler.getLogger().warn("'{}' doesn't exist. Did you run `npm install`?", (Object)webpack);
            throw new ExecutionFailedException(String.format("%s '%s' doesn't exist. `npm install` has not run or failed.", START_FAILURE, webpack));
        }
        if (!webpack.canExecute()) {
            DevModeHandler.getLogger().warn(" '{}' is not an executable. Did you run `npm install`?", (Object)webpack);
            throw new ExecutionFailedException(String.format("%s '%s' is not an executable. `npm install` has not run or failed.", START_FAILURE, webpack));
        }
        if (!webpackConfig.canRead()) {
            DevModeHandler.getLogger().warn("Webpack configuration '{}' is not found or is not readable.", (Object)webpackConfig);
            throw new ExecutionFailedException(String.format("%s '%s' doesn't exist or is not readable.", START_FAILURE, webpackConfig));
        }
        return new Pair<File, File>(webpack, webpackConfig);
    }

    private static int getRunningDevServerPort() {
        int port = 0;
        File portFile = LazyDevServerPortFileInit.DEV_SERVER_PORT_FILE;
        if (portFile.canRead()) {
            try {
                String portString = FileUtils.readFileToString((File)portFile, (Charset)StandardCharsets.UTF_8).trim();
                if (!portString.isEmpty()) {
                    port = Integer.parseInt(portString);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return port;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int getFreePort() {
        try (ServerSocket s = new ServerSocket(0);){
            s.setReuseAddress(true);
            int n = s.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to find a free port for running webpack", e);
        }
    }

    public int getPort() {
        return this.port;
    }

    public boolean reuseDevServer() {
        return this.reuseDevServer;
    }

    public void stop() {
        Process process;
        if (atomicHandler.get() == null) {
            return;
        }
        try {
            this.prepareConnection("/stop", "GET").getResponseCode();
        }
        catch (IOException e) {
            DevModeHandler.getLogger().debug("webpack-dev-server does not support the `/stop` command.", (Throwable)e);
        }
        DevServerWatchDog watchDogInstance = this.watchDog.get();
        if (watchDogInstance != null) {
            watchDogInstance.stop();
        }
        if ((process = this.webpackProcess.get()) != null && process.isAlive()) {
            process.destroy();
        }
        atomicHandler.set(null);
        this.removeRunningDevServerPort();
    }

    void join() {
        this.devServerStartFuture.join();
    }

    private static final class LazyDevServerPortFileInit {
        private static final File DEV_SERVER_PORT_FILE = LazyDevServerPortFileInit.createDevServerPortFile();

        private LazyDevServerPortFileInit() {
        }

        private static File createDevServerPortFile() {
            try {
                return File.createTempFile("flow-dev-server", "port");
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception);
            }
        }
    }
}

