/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.RouteAliasData;
import com.vaadin.flow.router.RouteBaseData;
import com.vaadin.flow.router.RouterLayout;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class RouteData
extends RouteBaseData<RouteData> {
    private final List<RouteAliasData> routeAliases;

    public RouteData(List<Class<? extends RouterLayout>> parentLayouts, String url, List<Class<?>> parameters, Class<? extends Component> navigationTarget, List<RouteAliasData> routeAliases) {
        super(parentLayouts, url, parameters, navigationTarget);
        Collections.sort(routeAliases);
        this.routeAliases = Collections.unmodifiableList(routeAliases);
    }

    public List<RouteAliasData> getRouteAliases() {
        return this.routeAliases;
    }

    public String toString() {
        return "RouteData{parentLayout=" + this.getParentLayout() + ", url='" + this.getUrl() + '\'' + ", parameters=" + this.getParameters() + ", navigationTarget=" + this.getNavigationTarget() + ", routeAliases=" + this.routeAliases + '}';
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RouteData) {
            RouteData other = (RouteData)obj;
            return other.getParentLayouts().equals(this.getParentLayouts()) && other.getUrl().equals(this.getUrl()) && other.getNavigationTarget().equals(this.getNavigationTarget()) && this.routeAliases.containsAll(other.routeAliases);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getParentLayouts(), this.getUrl(), this.getNavigationTarget(), this.routeAliases);
    }
}

