/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.FrontendVersion;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;

class VersionsJsonConverter {
    private static final String JS_VERSION = "jsVersion";
    private static final String NPM_NAME = "npmName";
    private static final String NPM_VERSION = "npmVersion";
    private final JsonObject convertedObject = Json.createObject();
    private final JsonObject userManagedDependencies;

    VersionsJsonConverter(JsonObject platformVersions, JsonObject packageJson) {
        this.collectDependencies(platformVersions);
        this.userManagedDependencies = this.collectUserManagedDependencies(packageJson);
    }

    JsonObject getManagedVersions() {
        JsonObject json = Json.createObject();
        for (String key : this.convertedObject.keys()) {
            if (!this.userManagedDependencies.hasKey(key)) {
                json.put(key, this.convertedObject.getString(key));
                continue;
            }
            json.put(key, this.userManagedDependencies.getString(key));
        }
        return json;
    }

    private void collectDependencies(JsonObject obj) {
        for (String key : obj.keys()) {
            JsonValue value = obj.get(key);
            if (!(value instanceof JsonObject)) continue;
            JsonObject json = (JsonObject)value;
            if (json.hasKey(NPM_NAME)) {
                this.addDependency(json);
                continue;
            }
            this.collectDependencies(json);
        }
    }

    private void addDependency(JsonObject obj) {
        assert (obj.hasKey(NPM_NAME));
        String npmName = obj.getString(NPM_NAME);
        if (obj.hasKey(NPM_VERSION)) {
            this.convertedObject.put(npmName, obj.getString(NPM_VERSION));
        } else if (obj.hasKey(JS_VERSION)) {
            this.convertedObject.put(npmName, obj.getString(JS_VERSION));
        } else {
            throw new IllegalStateException("Vaadin code versions file contains unexpected data: dependency '" + npmName + "' has no 'npmVersion'/'jsVersion' . Please report a bug in https://github.com/vaadin/platform/issues/new");
        }
    }

    private JsonObject collectUserManagedDependencies(JsonObject packageJson) {
        JsonObject json = Json.createObject();
        JsonObject vaadinDep = packageJson.hasKey("vaadin") && packageJson.getObject("vaadin").hasKey("dependencies") ? packageJson.getObject("vaadin").getObject("dependencies") : Json.createObject();
        if (packageJson.hasKey("dependencies")) {
            JsonObject dependencies = packageJson.getObject("dependencies");
            for (String key : dependencies.keys()) {
                if (!this.isUserChanged(key, vaadinDep, dependencies)) continue;
                json.put(key, dependencies.getString(key));
            }
        }
        return json;
    }

    private boolean isUserChanged(String key, JsonObject vaadinDep, JsonObject dependencies) {
        if (vaadinDep.hasKey(key)) {
            FrontendVersion dep;
            FrontendVersion vaadin = new FrontendVersion(vaadinDep.getString(key));
            return !vaadin.isEqualTo(dep = new FrontendVersion(dependencies.getString(key)));
        }
        return true;
    }
}

