/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.FrontendVersion;
import elemental.json.Json;
import elemental.json.JsonObject;

class VersionsJsonFilter {
    private final JsonObject userManagedDependencies;
    private final String dependenciesKey;

    VersionsJsonFilter(JsonObject packageJson, String dependenciesKey) {
        this.dependenciesKey = dependenciesKey;
        this.userManagedDependencies = this.collectUserManagedDependencies(packageJson);
    }

    JsonObject getFilteredVersions(JsonObject versions) {
        JsonObject json = Json.createObject();
        for (String key : versions.keys()) {
            if (this.userManagedDependencies.hasKey(key)) continue;
            json.put(key, versions.getString(key));
        }
        return json;
    }

    private JsonObject collectUserManagedDependencies(JsonObject packageJson) {
        JsonObject json = Json.createObject();
        JsonObject vaadinDep = packageJson.hasKey("vaadin") && packageJson.getObject("vaadin").hasKey(this.dependenciesKey) ? packageJson.getObject("vaadin").getObject(this.dependenciesKey) : Json.createObject();
        if (packageJson.hasKey(this.dependenciesKey)) {
            JsonObject dependencies = packageJson.getObject(this.dependenciesKey);
            for (String key : dependencies.keys()) {
                if (!this.isUserChanged(key, vaadinDep, dependencies)) continue;
                json.put(key, dependencies.getString(key));
            }
        }
        return json;
    }

    private boolean isUserChanged(String key, JsonObject vaadinDep, JsonObject dependencies) {
        if (vaadinDep.hasKey(key)) {
            FrontendVersion dep;
            FrontendVersion vaadin = new FrontendVersion(vaadinDep.getString(key));
            return !vaadin.isEqualTo(dep = new FrontendVersion(dependencies.getString(key)));
        }
        return true;
    }
}

