/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementUtil;
import com.vaadin.flow.internal.ReflectTools;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.stream.Stream;

public abstract class Composite<T extends Component>
extends Component {
    private T content;
    private transient ThreadLocal<Boolean> contentIsInitializing = new ThreadLocal();

    protected Composite() {
        super(null);
    }

    protected T initContent() {
        return (T)ReflectTools.createInstance(Composite.findContentType(this.getClass()));
    }

    private static Class<? extends Component> findContentType(Class<? extends Composite<?>> compositeClass) {
        Type type = GenericTypeReflector.getTypeParameter((Type)compositeClass.getGenericSuperclass(), Composite.class.getTypeParameters()[0]);
        if (type instanceof Class || type instanceof ParameterizedType) {
            return GenericTypeReflector.erase((Type)type).asSubclass(Component.class);
        }
        throw new IllegalStateException(Composite.getExceptionMessage(type));
    }

    private static String getExceptionMessage(Type type) {
        if (type == null) {
            return "Composite is used as raw type: either add type information or override initContent().";
        }
        if (type instanceof TypeVariable) {
            return String.format("Could not determine the composite content type for TypeVariable '%s'. Either specify exact type or override initContent().", type.getTypeName());
        }
        return String.format("Could not determine the composite content type for %s. Override initContent().", type.getTypeName());
    }

    public T getContent() {
        if (this.content == null) {
            try {
                if (Boolean.TRUE.equals(this.contentIsInitializing.get())) {
                    throw new IllegalStateException("The content is not yet initialized. Detected direct or indirect call to 'getContent' from 'initContent'. You may not call any framework method on a '" + Composite.class.getSimpleName() + "' instance before 'initContent' has completed initializing the component.");
                }
                this.contentIsInitializing.set(true);
                T newContent = this.initContent();
                if (newContent == null) {
                    throw new IllegalStateException("initContent returned null instead of a component");
                }
                this.setContent(newContent);
            }
            finally {
                this.contentIsInitializing.set(false);
            }
        }
        return this.content;
    }

    private void setContent(T content) {
        assert (((Component)content).getElement().getComponent().isPresent()) : "Composite should never be attached to an element which is not attached to a component";
        assert (this.content == null) : "Content has already been initialized";
        this.content = content;
        Element element = ((Component)content).getElement();
        ElementUtil.setComponent(element, this);
    }

    @Override
    public Element getElement() {
        return ((Component)this.getContent()).getElement();
    }

    @Override
    public Stream<Component> getChildren() {
        return Stream.of(this.getContent());
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        stream.defaultReadObject();
        this.contentIsInitializing = new ThreadLocal();
    }
}

