/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.client.ClientResourcesUtils;
import com.vaadin.flow.component.PushConfiguration;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.Inline;
import com.vaadin.flow.component.page.Push;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.BootstrapHandlerHelper;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.BrowserLiveReloadAccess;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.BootstrapException;
import com.vaadin.flow.server.BootstrapPageResponse;
import com.vaadin.flow.server.BootstrapUtils;
import com.vaadin.flow.server.DevModeHandler;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.InitialPageSettings;
import com.vaadin.flow.server.InlineTargets;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.PwaIcon;
import com.vaadin.flow.server.PwaRegistry;
import com.vaadin.flow.server.SynchronizedRequestHandler;
import com.vaadin.flow.server.SystemMessages;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.Version;
import com.vaadin.flow.server.communication.AtmospherePushConnection;
import com.vaadin.flow.server.communication.PushConnectionFactory;
import com.vaadin.flow.server.communication.UidlWriter;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.shared.VaadinUriResolver;
import com.vaadin.flow.shared.communication.PushMode;
import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.flow.shared.ui.LoadMode;
import com.vaadin.flow.theme.ThemeDefinition;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapHandler
extends SynchronizedRequestHandler {
    public static final String POLYFILLS_JS = "frontend://bower_components/webcomponentsjs/webcomponents-loader.js";
    private static final CharSequence GWT_STAT_EVENTS_JS = "if (typeof window.__gwtStatsEvent != 'function') {window.Vaadin.Flow.gwtStatsEvents = [];window.__gwtStatsEvent = function(event) {window.Vaadin.Flow.gwtStatsEvents.push(event); return true;};};";
    static final String CONTENT_ATTRIBUTE = "content";
    private static final String DEFER_ATTRIBUTE = "defer";
    static final String VIEWPORT = "viewport";
    private static final String META_TAG = "meta";
    private static final String SCRIPT_TAG = "script";
    private static final String CLIENT_ENGINE_NOCACHE_FILE = "VAADIN/static/client/client.nocache.js";
    private static final String BOOTSTRAP_JS = BootstrapHandler.readResource("BootstrapHandler.js");
    private static final String BABEL_HELPERS_JS = BootstrapHandler.readResource("babel-helpers.min.js");
    private static final String ES6_COLLECTIONS = "//<![CDATA[\n" + BootstrapHandler.readResource("es6-collections.js") + "//]]>";
    private static final String CSS_TYPE_ATTRIBUTE_VALUE = "text/css";
    static final String SAFARI_10_1_SCRIPT_NOMODULE_FIX = "//<![CDATA[\n" + BootstrapHandler.readResource("safari-10-1-script-nomodule.js") + "//]]>";
    private static final String CAPTION = "caption";
    private static final String MESSAGE = "message";
    private static final String URL = "url";
    static Supplier<String> clientEngineFile = () -> LazyClientEngineInit.access$600();
    private final PageBuilder pageBuilder;

    public BootstrapHandler() {
        this(new BootstrapPageBuilder());
    }

    protected BootstrapHandler(PageBuilder pageBuilder) {
        this.pageBuilder = pageBuilder;
    }

    protected PageBuilder getPageBuilder() {
        return this.pageBuilder;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)BootstrapHandler.class.getName());
    }

    @Override
    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        Class<? extends UI> uiClass = BootstrapHandler.getUIClass(request);
        BootstrapContext context = this.createAndInitUI(uiClass, request, response, session);
        HandlerHelper.setResponseNoCacheHeaders(response::setHeader, response::setDateHeader);
        Document document = this.pageBuilder.getBootstrapPage(context);
        this.writeBootstrapPage(response, document.outerHtml());
        return true;
    }

    private void writeBootstrapPage(VaadinResponse response, String html) throws IOException {
        response.setContentType("text/html; charset=utf-8");
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(response.getOutputStream(), StandardCharsets.UTF_8));){
            writer.append(html);
        }
    }

    protected static String getServiceUrl(BootstrapContext context) {
        return BootstrapHandlerHelper.getServiceUrl(context.getRequest());
    }

    protected static Optional<String> resolvePageTitle(BootstrapContext context) {
        String title = context.getUI().getInternals().getTitle();
        if (title != null) {
            context.getUI().getInternals().cancelPendingTitleUpdate();
        }
        return Optional.ofNullable(title);
    }

    protected BootstrapContext createAndInitUI(Class<? extends UI> uiClass, VaadinRequest request, VaadinResponse response, VaadinSession session) {
        UI ui = ReflectTools.createInstance(uiClass);
        ui.getInternals().setContextRoot(request.getService().getContextRootRelativePath(request));
        PushConfiguration pushConfiguration = ui.getPushConfiguration();
        ui.getInternals().setSession(session);
        ui.setLocale(session.getLocale());
        BootstrapContext context = this.createBootstrapContext(request, response, ui, request.getService()::getContextRootRelativePath);
        Optional<Push> push = context.getPageConfigurationAnnotation(Push.class);
        DeploymentConfiguration deploymentConfiguration = context.getSession().getService().getDeploymentConfiguration();
        PushMode pushMode = push.map(Push::value).orElseGet(deploymentConfiguration::getPushMode);
        this.setupPushConnectionFactory(pushConfiguration, context);
        pushConfiguration.setPushMode(pushMode);
        pushConfiguration.setPushUrl(deploymentConfiguration.getPushURL());
        push.map(Push::transport).ifPresent(pushConfiguration::setTransport);
        UI.setCurrent(ui);
        ui.doInit(request, session.getNextUIid());
        session.addUI(ui);
        session.getService().fireUIInitListeners(ui);
        if (ui.getRouter() != null) {
            ui.getRouter().initializeUI(ui, request);
        }
        return context;
    }

    protected BootstrapContext createBootstrapContext(VaadinRequest request, VaadinResponse response, UI ui, Function<VaadinRequest, String> contextPathCallback) {
        return new BootstrapContext(request, response, ui.getInternals().getSession(), ui, contextPathCallback);
    }

    protected void setupPushConnectionFactory(PushConfiguration pushConfiguration, BootstrapContext context) {
        VaadinService service = context.getSession().getService();
        Iterator<PushConnectionFactory> iter = ServiceLoader.load(PushConnectionFactory.class, service.getClassLoader()).iterator();
        if (iter.hasNext()) {
            pushConfiguration.setPushConnectionFactory(iter.next());
            if (iter.hasNext()) {
                throw new BootstrapException("Multiple " + PushConnectionFactory.class.getName() + " implementations found");
            }
        }
    }

    protected static Class<? extends UI> getUIClass(VaadinRequest request) {
        String uiClassName = request.getService().getDeploymentConfiguration().getUIClassName();
        if (uiClassName == null) {
            throw new BootstrapException("Could not determine the uiClassName for the request path " + request.getPathInfo());
        }
        ClassLoader classLoader = request.getService().getClassLoader();
        try {
            return Class.forName(uiClassName, true, classLoader).asSubclass(UI.class);
        }
        catch (ClassNotFoundException e) {
            throw new BootstrapException("Vaadin Servlet mapped to the request path " + request.getPathInfo() + " cannot find the mapped UI class with name " + uiClassName, e);
        }
    }

    /*
     * Exception decompiling
     */
    protected static String readResource(String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class LazyClientEngineInit {
        private static final String CLIENT_ENGINE_FILE = LazyClientEngineInit.readClientEngine();

        private LazyClientEngineInit() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static String readClientEngine() {
            try (InputStream prop = ClientResourcesUtils.getResource("/META-INF/resources/VAADIN/static/client/compile.properties");){
                if (prop != null) {
                    Properties properties = new Properties();
                    properties.load(prop);
                    String string = "VAADIN/static/client/" + properties.getProperty("jsFile");
                    return string;
                }
                BootstrapHandler.getLogger().warn("No compile.properties available on initialization, could not read client engine file name.");
                return null;
            }
            catch (IOException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    private static final class ApplicationParameterBuilder {
        private final Function<VaadinRequest, String> contextCallback;

        private ApplicationParameterBuilder(Function<VaadinRequest, String> contextCallback) {
            this.contextCallback = contextCallback;
        }

        public JsonObject getApplicationParameters(BootstrapContext context) {
            VaadinRequest request = context.getRequest();
            VaadinSession session = context.getSession();
            DeploymentConfiguration deploymentConfiguration = session.getConfiguration();
            boolean productionMode = deploymentConfiguration.isProductionMode();
            JsonObject appConfig = Json.createObject();
            appConfig.put("frontendUrlEs6", deploymentConfiguration.getEs6FrontendPrefix());
            appConfig.put("frontendUrlEs5", deploymentConfiguration.getEs5FrontendPrefix());
            if (!productionMode) {
                BrowserLiveReload liveReload;
                JsonObject versionInfo = Json.createObject();
                versionInfo.put("vaadinVersion", Version.getFullVersion());
                String atmosphereVersion = AtmospherePushConnection.getAtmosphereVersion();
                if (atmosphereVersion != null) {
                    versionInfo.put("atmosphereVersion", atmosphereVersion);
                }
                appConfig.put("versionInfo", (JsonValue)versionInfo);
                appConfig.put("devmodeGizmoEnabled", deploymentConfiguration.isDevModeLiveReloadEnabled());
                VaadinService service = session.getService();
                BrowserLiveReloadAccess liveReloadAccess = service.getInstantiator().getOrCreate(BrowserLiveReloadAccess.class);
                BrowserLiveReload browserLiveReload = liveReload = liveReloadAccess != null ? liveReloadAccess.getLiveReload(service) : null;
                if (liveReload != null) {
                    appConfig.put("liveReloadUrl", BootstrapHandlerHelper.getPushURL(session, request));
                    if (liveReload.getBackend() != null) {
                        appConfig.put("liveReloadBackend", liveReload.getBackend().toString());
                    }
                    appConfig.put("springBootLiveReloadPort", 35729.0);
                }
            }
            Locale locale = HandlerHelper.findLocale(session, request);
            SystemMessages systemMessages = session.getService().getSystemMessages(locale, request);
            if (systemMessages != null) {
                JsonObject sessExpMsg = Json.createObject();
                this.putValueOrNull(sessExpMsg, BootstrapHandler.CAPTION, systemMessages.getSessionExpiredCaption());
                this.putValueOrNull(sessExpMsg, BootstrapHandler.MESSAGE, systemMessages.getSessionExpiredMessage());
                this.putValueOrNull(sessExpMsg, BootstrapHandler.URL, systemMessages.getSessionExpiredURL());
                appConfig.put("sessExpMsg", (JsonValue)sessExpMsg);
            }
            String contextRoot = this.contextCallback.apply(request);
            appConfig.put("contextRootUrl", contextRoot);
            if (!productionMode) {
                appConfig.put("debug", true);
            }
            if (deploymentConfiguration.isRequestTiming()) {
                appConfig.put("requestTiming", true);
            }
            appConfig.put("heartbeatInterval", (double)deploymentConfiguration.getHeartbeatInterval());
            appConfig.put("maxMessageSuspendTimeout", (double)deploymentConfiguration.getMaxMessageSuspendTimeout());
            boolean sendUrlsAsParameters = deploymentConfiguration.isSendUrlsAsParameters();
            if (!sendUrlsAsParameters) {
                appConfig.put("sendUrlsAsParameters", false);
            }
            appConfig.put("v-uiId", (double)context.getUI().getUIId());
            return appConfig;
        }

        private void putValueOrNull(JsonObject object, String key, String value) {
            assert (object != null);
            assert (key != null);
            if (value == null) {
                object.put(key, (JsonValue)Json.createNull());
            } else {
                object.put(key, value);
            }
        }
    }

    protected static final class BootstrapPageBuilder
    implements PageBuilder,
    Serializable {
        protected BootstrapPageBuilder() {
        }

        @Override
        public Document getBootstrapPage(BootstrapContext context) {
            DeploymentConfiguration config = context.getSession().getConfiguration();
            Document document = new Document("");
            DocumentType doctype = new DocumentType("html", "", "");
            document.appendChild((Node)doctype);
            Element html = document.appendElement("html");
            html.attr("lang", context.getUI().getLocale().getLanguage());
            Element head = html.appendElement("head");
            html.appendElement("body");
            List<Element> dependenciesToInlineInBody = this.setupDocumentHead(head, context);
            dependenciesToInlineInBody.forEach(dependency -> document.body().appendChild((Node)dependency));
            this.setupDocumentBody(document);
            document.outputSettings().prettyPrint(false);
            BootstrapUtils.getInlineTargets(context).ifPresent(targets -> this.handleInlineTargets(context, head, document.body(), (InlineTargets)targets));
            BootstrapUtils.getInitialPageSettings(context).ifPresent(initialPageSettings -> this.handleInitialPageSettings(context, head, (InitialPageSettings)initialPageSettings));
            if (config.isCompatibilityMode()) {
                this.handleThemeContents(context, document);
            }
            if (!config.isProductionMode()) {
                if (config.isBowerMode()) {
                    this.exportBowerUsageStatistics(document);
                } else {
                    this.exportNpmUsageStatistics(document);
                }
            }
            this.setupPwa(document, context);
            if (!config.isCompatibilityMode() && !config.isProductionMode()) {
                this.checkWebpackStatus(document);
            }
            BootstrapPageResponse response = new BootstrapPageResponse(context.getRequest(), context.getSession(), context.getResponse(), document, context.getUI(), context.getUriResolver());
            context.getSession().getService().modifyBootstrapPage(response);
            return document;
        }

        private String getClientEngine() {
            return clientEngineFile.get();
        }

        private void checkWebpackStatus(Document document) {
            String errorMsg;
            DevModeHandler devMode = DevModeHandler.getDevModeHandler();
            if (devMode != null && (errorMsg = devMode.getFailedOutput()) != null) {
                Element errorElement = document.createElement("div");
                errorElement.setBaseUri("");
                errorElement.attr("class", "v-system-error");
                errorElement.attr("onclick", "this.parentElement.removeChild(this)");
                errorElement.html("<h3 style=\"display:inline;\">Webpack Error</h3><h6 style=\"display:inline; padding-left:10px;\">Click to close</h6><pre>" + errorMsg + "</pre>");
                document.body().appendChild((Node)errorElement);
            }
        }

        private void exportBowerUsageStatistics(Document document) {
            String registerScript = UsageStatistics.getEntries().map(entry -> {
                String json = BootstrapPageBuilder.createUsageStatisticsJson(entry);
                String escapedName = Json.create((String)entry.getName()).toJson();
                return String.format("window.Vaadin[%s]=%s;", escapedName, json);
            }).collect(Collectors.joining("\n"));
            if (!registerScript.isEmpty()) {
                document.body().appendElement(BootstrapHandler.SCRIPT_TAG).text(registerScript);
            }
        }

        private void exportNpmUsageStatistics(Document document) {
            String entries = UsageStatistics.getEntries().map(BootstrapPageBuilder::createUsageStatisticsJson).collect(Collectors.joining(","));
            if (!entries.isEmpty()) {
                document.body().appendElement(BootstrapHandler.SCRIPT_TAG).text("window.Vaadin.registrations = window.Vaadin.registrations || [];\nwindow.Vaadin.registrations.push(" + entries + ");");
            }
        }

        private static String createUsageStatisticsJson(UsageStatistics.UsageEntry entry) {
            JsonObject json = Json.createObject();
            json.put("is", entry.getName());
            json.put("version", entry.getVersion());
            return json.toJson();
        }

        private void handleThemeContents(BootstrapContext context, Document document) {
            JsonObject themeContent;
            BootstrapUtils.ThemeSettings themeSettings = BootstrapUtils.getThemeSettings(context);
            if (themeSettings == null) {
                return;
            }
            List<JsonObject> themeContents = themeSettings.getHeadContents();
            if (themeContents != null) {
                themeContents.stream().map(dependency -> this.createDependencyElement(context, (JsonObject)dependency)).forEach(element -> this.insertElements((Element)element, arg_0 -> ((Element)document.head()).appendChild(arg_0)));
            }
            if ((themeContent = themeSettings.getHeadInjectedContent()) != null) {
                Element dependency2 = this.createDependencyElement(context, themeContent);
                this.insertElements(dependency2, arg_0 -> ((Element)document.head()).appendChild(arg_0));
            }
            if (themeSettings.getHtmlAttributes() != null) {
                Element html = document.body().parent();
                assert ("html".equalsIgnoreCase(html.tagName()));
                themeSettings.getHtmlAttributes().forEach((arg_0, arg_1) -> ((Element)html).attr(arg_0, arg_1));
            }
        }

        private Element createDependencyElement(BootstrapContext context, JsonObject dependencyJson) {
            String type = dependencyJson.getString("type");
            if (Dependency.Type.contains(type)) {
                Dependency.Type dependencyType = Dependency.Type.valueOf(type);
                return this.createDependencyElement(context.getUriResolver(), LoadMode.INLINE, dependencyJson, dependencyType);
            }
            return Jsoup.parse((String)dependencyJson.getString("contents"), (String)"", (Parser)Parser.xmlParser());
        }

        private void handleInlineTargets(BootstrapContext context, Element head, Element body, InlineTargets targets) {
            targets.getInlineHead(Inline.Position.PREPEND).stream().map(dependency -> this.createDependencyElement(context, (JsonObject)dependency)).forEach(element -> this.insertElements((Element)element, arg_0 -> ((Element)head).prependChild(arg_0)));
            targets.getInlineHead(Inline.Position.APPEND).stream().map(dependency -> this.createDependencyElement(context, (JsonObject)dependency)).forEach(element -> this.insertElements((Element)element, arg_0 -> ((Element)head).appendChild(arg_0)));
            targets.getInlineBody(Inline.Position.PREPEND).stream().map(dependency -> this.createDependencyElement(context, (JsonObject)dependency)).forEach(element -> this.insertElements((Element)element, arg_0 -> ((Element)body).prependChild(arg_0)));
            targets.getInlineBody(Inline.Position.APPEND).stream().map(dependency -> this.createDependencyElement(context, (JsonObject)dependency)).forEach(element -> this.insertElements((Element)element, arg_0 -> ((Element)body).appendChild(arg_0)));
        }

        private void handleInitialPageSettings(BootstrapContext context, Element head, InitialPageSettings initialPageSettings) {
            if (initialPageSettings.getViewport() != null) {
                Elements viewport = head.getElementsByAttributeValue("name", BootstrapHandler.VIEWPORT);
                if (!viewport.isEmpty() && viewport.size() == 1) {
                    ((Element)viewport.get(0)).attr(BootstrapHandler.CONTENT_ATTRIBUTE, initialPageSettings.getViewport());
                } else {
                    head.appendElement(BootstrapHandler.META_TAG).attr("name", BootstrapHandler.VIEWPORT).attr(BootstrapHandler.CONTENT_ATTRIBUTE, initialPageSettings.getViewport());
                }
            }
            initialPageSettings.getInline(InitialPageSettings.Position.PREPEND).stream().map(dependency -> this.createDependencyElement(context, (JsonObject)dependency)).forEach(element -> this.insertElements((Element)element, arg_0 -> ((Element)head).prependChild(arg_0)));
            initialPageSettings.getInline(InitialPageSettings.Position.APPEND).stream().map(dependency -> this.createDependencyElement(context, (JsonObject)dependency)).forEach(element -> this.insertElements((Element)element, arg_0 -> ((Element)head).appendChild(arg_0)));
            initialPageSettings.getElement(InitialPageSettings.Position.PREPEND).forEach(element -> this.insertElements((Element)element, arg_0 -> ((Element)head).prependChild(arg_0)));
            initialPageSettings.getElement(InitialPageSettings.Position.APPEND).forEach(element -> this.insertElements((Element)element, arg_0 -> ((Element)head).appendChild(arg_0)));
        }

        private void insertElements(Element element, Consumer<Element> action) {
            if (element instanceof Document) {
                element.getAllElements().stream().filter(item -> !(item instanceof Document) && element.equals((Object)item.parent())).forEach(action::accept);
            } else if (element != null) {
                action.accept(element);
            }
        }

        private List<Element> setupDocumentHead(Element head, BootstrapContext context) {
            this.setupMetaAndTitle(head, context);
            this.setupCss(head, context);
            JsonObject initialUIDL = this.getInitialUidl(context.getUI());
            Map<LoadMode, JsonArray> dependenciesToProcessOnServer = this.popDependenciesToProcessOnServer(initialUIDL);
            this.setupFrameworkLibraries(head, initialUIDL, context);
            return this.applyUserDependencies(head, context, dependenciesToProcessOnServer);
        }

        protected JsonObject getInitialUidl(UI ui) {
            JsonObject json = new UidlWriter().createUidl(ui, false);
            VaadinSession session = ui.getSession();
            if (session.getConfiguration().isXsrfProtectionEnabled()) {
                this.writeSecurityKeyUIDL(json, ui);
            }
            this.writePushIdUIDL(json, session);
            if (BootstrapHandler.getLogger().isDebugEnabled()) {
                BootstrapHandler.getLogger().debug("Initial UIDL: {}", (Object)json.asString());
            }
            return json;
        }

        private void writePushIdUIDL(JsonObject response, VaadinSession session) {
            String pushId = session.getPushId();
            response.put("Vaadin-Push-ID", pushId);
        }

        private void writeSecurityKeyUIDL(JsonObject response, UI ui) {
            String seckey = ui.getCsrfToken();
            response.put("Vaadin-Security-Key", seckey);
        }

        private List<Element> applyUserDependencies(Element head, BootstrapContext context, Map<LoadMode, JsonArray> dependenciesToProcessOnServer) {
            ArrayList<Element> dependenciesToInlineInBody = new ArrayList<Element>();
            for (Map.Entry<LoadMode, JsonArray> entry : dependenciesToProcessOnServer.entrySet()) {
                dependenciesToInlineInBody.addAll(this.inlineDependenciesInHead(head, context.getUriResolver(), entry.getKey(), entry.getValue()));
            }
            return dependenciesToInlineInBody;
        }

        private List<Element> inlineDependenciesInHead(Element head, BootstrapUriResolver uriResolver, LoadMode loadMode, JsonArray dependencies) {
            ArrayList<Element> dependenciesToInlineInBody = new ArrayList<Element>();
            for (int i = 0; i < dependencies.length(); ++i) {
                JsonObject dependencyJson = dependencies.getObject(i);
                Dependency.Type dependencyType = Dependency.Type.valueOf(dependencyJson.getString("type"));
                Element dependencyElement = this.createDependencyElement(uriResolver, loadMode, dependencyJson, dependencyType);
                if (loadMode == LoadMode.INLINE && dependencyType == Dependency.Type.HTML_IMPORT) {
                    dependenciesToInlineInBody.add(dependencyElement);
                    continue;
                }
                head.appendChild((Node)dependencyElement);
            }
            return dependenciesToInlineInBody;
        }

        private Map<LoadMode, JsonArray> popDependenciesToProcessOnServer(JsonObject initialUIDL) {
            EnumMap<LoadMode, JsonArray> result = new EnumMap<LoadMode, JsonArray>(LoadMode.class);
            Stream.of(LoadMode.EAGER, LoadMode.INLINE).forEach(mode -> {
                if (initialUIDL.hasKey(mode.name())) {
                    result.put((LoadMode)((Object)mode), initialUIDL.getArray(mode.name()));
                    initialUIDL.remove(mode.name());
                }
            });
            return result;
        }

        private void setupFrameworkLibraries(Element head, JsonObject initialUIDL, BootstrapContext context) {
            VaadinService service = context.getSession().getService();
            DeploymentConfiguration conf = service.getDeploymentConfiguration();
            if (conf.isCompatibilityMode()) {
                this.inlineEs6Collections(head, context);
                this.appendWebComponentsPolyfills(head, context);
            } else {
                conf.getPolyfills().forEach(polyfill -> head.appendChild((Node)this.createJavaScriptElement("./VAADIN/" + polyfill, false)));
                this.appendSafari10ScriptNoModuleFix(head, context);
                try {
                    this.appendNpmBundle(head, service, context);
                }
                catch (IOException e) {
                    throw new BootstrapException("Unable to read webpack stats file.", e);
                }
            }
            if (context.getPushMode().isEnabled()) {
                head.appendChild((Node)this.getPushScript(context));
            }
            head.appendChild((Node)this.getBootstrapScript((JsonValue)initialUIDL, context));
            head.appendChild((Node)this.createJavaScriptElement(this.getClientEngineUrl(context)));
        }

        private void appendNpmBundle(Element head, VaadinService service, BootstrapContext context) throws IOException {
            String content = FrontendUtils.getStatsAssetsByChunkName(service);
            if (content == null) {
                StringBuilder message = new StringBuilder("The stats file from webpack (stats.json) was not found.\n");
                if (service.getDeploymentConfiguration().isProductionMode()) {
                    message.append("The application is running in production mode.");
                    message.append("Verify that build-frontend task has executed successfully and that stats.json is on the classpath.");
                    message.append("Or switch application to development mode.");
                } else if (!service.getDeploymentConfiguration().enableDevServer()) {
                    message.append("Dev server is disabled for the application.");
                    message.append("Verify that build-frontend task has executed successfully and that stats.json is on the classpath.");
                } else {
                    message.append("This typically mean that you have started the application without executing the 'prepare-frontend' Maven target.\n");
                    message.append("If you are using Spring Boot and are launching the Application class directly, ");
                    message.append("you need to run \"mvn install\" once first or launch the application using \"mvn spring-boot:run\"");
                }
                throw new IOException(message.toString());
            }
            JsonObject chunks = Json.parse((String)content);
            for (String key : chunks.keys()) {
                Element script;
                String chunkName = chunks.get(key).getType().equals((Object)JsonType.ARRAY) ? this.getArrayChunkName(chunks, key) : chunks.getString(key);
                if (key.endsWith(".es5")) {
                    script = this.createJavaScriptElement("./VAADIN/" + chunkName);
                    head.appendChild((Node)script.attr("nomodule", true).attr("data-app-id", context.getUI().getInternals().getAppId()));
                    continue;
                }
                script = this.createJavaScriptElement("./VAADIN/" + chunkName, false);
                head.appendChild((Node)script.attr("type", "module").attr("data-app-id", context.getUI().getInternals().getAppId()).attr("crossorigin", true));
            }
        }

        private String getArrayChunkName(JsonObject chunks, String key) {
            JsonArray chunkArray = chunks.getArray(key);
            for (int i = 0; i < chunkArray.length(); ++i) {
                String chunkName = chunkArray.getString(0);
                if (!chunkName.endsWith(".js")) continue;
                return chunkName;
            }
            return "";
        }

        private String getClientEngineUrl(BootstrapContext context) {
            boolean resolveNow;
            boolean productionMode = context.getSession().getConfiguration().isProductionMode();
            boolean bl = resolveNow = !productionMode || this.getClientEngine() == null;
            if (resolveNow && ClientResourcesUtils.getResource("/META-INF/resources/VAADIN/static/client/client.nocache.js") != null) {
                return context.getUriResolver().resolveVaadinUri("context://VAADIN/static/client/client.nocache.js");
            }
            if (this.getClientEngine() == null) {
                throw new BootstrapException("Client engine file name has not been resolved during initialization");
            }
            return context.getUriResolver().resolveVaadinUri("context://" + this.getClientEngine());
        }

        private void inlineEs6Collections(Element head, BootstrapContext context) {
            if (!context.getSession().getBrowser().isEs6Supported()) {
                head.appendChild((Node)this.createInlineJavaScriptElement(ES6_COLLECTIONS));
            }
        }

        private void appendSafari10ScriptNoModuleFix(Element head, BootstrapContext context) {
            if (context.getSession().getBrowser().isSafari() && context.getSession().getBrowser().getBrowserMajorVersion() == 10 && context.getSession().getBrowser().getBrowserMinorVersion() <= 1) {
                head.appendChild((Node)this.createInlineJavaScriptElement(SAFARI_10_1_SCRIPT_NOMODULE_FIX));
            }
        }

        private void setupCss(Element head, BootstrapContext context) {
            Element styles = head.appendElement("style").attr("type", BootstrapHandler.CSS_TYPE_ATTRIBUTE_VALUE);
            String bodySizeContent = BootstrapUtils.getBodySizeContent(context);
            styles.appendText(bodySizeContent);
            styles.appendText(".v-reconnect-dialog, .v-system-error {position: absolute;color: black;background: white;top: 1em;right: 1em;border: 1px solid black;padding: 1em;z-index: 10000;max-width: calc(100vw - 4em);max-height: calc(100vh - 4em);overflow: auto;} .v-system-error {color: red;pointer-events: auto;}");
        }

        private void setupMetaAndTitle(Element head, BootstrapContext context) {
            head.appendElement(BootstrapHandler.META_TAG).attr("http-equiv", "Content-Type").attr(BootstrapHandler.CONTENT_ATTRIBUTE, "text/html; charset=utf-8");
            head.appendElement(BootstrapHandler.META_TAG).attr("http-equiv", "X-UA-Compatible").attr(BootstrapHandler.CONTENT_ATTRIBUTE, "IE=edge");
            head.appendElement("base").attr("href", BootstrapHandlerHelper.getServiceUrl(context.getRequest()));
            head.appendElement(BootstrapHandler.META_TAG).attr("name", BootstrapHandler.VIEWPORT).attr(BootstrapHandler.CONTENT_ATTRIBUTE, BootstrapUtils.getViewportContent(context).orElse("width=device-width, initial-scale=1.0"));
            BootstrapUtils.getMetaTargets(context).forEach((name, content) -> head.appendElement(BootstrapHandler.META_TAG).attr("name", name).attr(BootstrapHandler.CONTENT_ATTRIBUTE, content));
            BootstrapHandler.resolvePageTitle(context).ifPresent(title -> {
                if (!title.isEmpty()) {
                    head.appendElement("title").appendText(title);
                }
            });
        }

        private void setupPwa(Document document, BootstrapContext context) {
            PwaRegistry registry = context.getPwaRegistry().orElse(null);
            if (registry == null) {
                return;
            }
            PwaConfiguration config = registry.getPwaConfiguration();
            if (config.isEnabled()) {
                Element head = document.head();
                head.appendElement(BootstrapHandler.META_TAG).attr("name", "apple-mobile-web-app-capable").attr(BootstrapHandler.CONTENT_ATTRIBUTE, "yes");
                head.appendElement(BootstrapHandler.META_TAG).attr("name", "theme-color").attr(BootstrapHandler.CONTENT_ATTRIBUTE, config.getThemeColor());
                head.appendElement(BootstrapHandler.META_TAG).attr("name", "apple-mobile-web-app-status-bar-style").attr(BootstrapHandler.CONTENT_ATTRIBUTE, config.getThemeColor());
                head.appendElement("link").attr("rel", "manifest").attr("href", config.getManifestPath());
                for (PwaIcon icon : registry.getHeaderIcons()) {
                    head.appendChild((Node)icon.asElement());
                }
                head.appendElement(BootstrapHandler.SCRIPT_TAG).text("if ('serviceWorker' in navigator) {\n  window.addEventListener('load', function() {\n    navigator.serviceWorker.register('" + config.getServiceWorkerPath() + "');\n  });\n}");
                if (config.isInstallPromptEnabled()) {
                    document.body().append(registry.getInstallPrompt());
                }
            }
        }

        private void appendWebComponentsPolyfills(Element head, BootstrapContext context) {
            VaadinSession session = context.getSession();
            DeploymentConfiguration config = session.getConfiguration();
            String es5AdapterUrl = "frontend://bower_components/webcomponentsjs/custom-elements-es5-adapter.js";
            VaadinService service = session.getService();
            if (!service.isResourceAvailable(BootstrapHandler.POLYFILLS_JS, session.getBrowser(), null)) {
                return;
            }
            boolean loadEs5Adapter = config.getBooleanProperty("load.es5.adapters", true);
            if (loadEs5Adapter && !session.getBrowser().isEs6Supported()) {
                head.appendChild((Node)this.createInlineJavaScriptElement(BABEL_HELPERS_JS));
                if (session.getBrowser().isEs5AdapterNeeded()) {
                    head.appendChild((Node)this.createJavaScriptElement(context.getUriResolver().resolveVaadinUri(es5AdapterUrl), false));
                }
            }
            String resolvedUrl = context.getUriResolver().resolveVaadinUri(BootstrapHandler.POLYFILLS_JS);
            head.appendChild((Node)this.createJavaScriptElement(resolvedUrl, false));
        }

        private Element createInlineJavaScriptElement(String javaScriptContents) {
            Element wrapper = this.createJavaScriptElement(null, false);
            wrapper.appendChild((Node)new DataNode(javaScriptContents));
            return wrapper;
        }

        private Element createJavaScriptElement(String sourceUrl, boolean defer) {
            return this.createJavaScriptElement(sourceUrl, defer, "text/javascript");
        }

        private Element createJavaScriptElement(String sourceUrl, boolean defer, String type) {
            Element jsElement = new Element(Tag.valueOf((String)BootstrapHandler.SCRIPT_TAG), "").attr("type", type).attr(BootstrapHandler.DEFER_ATTRIBUTE, defer);
            if (sourceUrl != null) {
                jsElement = jsElement.attr("src", sourceUrl);
            }
            return jsElement;
        }

        private Element createJavaScriptElement(String sourceUrl) {
            return this.createJavaScriptElement(sourceUrl, true);
        }

        private Element createDependencyElement(BootstrapUriResolver resolver, LoadMode loadMode, JsonObject dependency, Dependency.Type type) {
            Element dependencyElement;
            boolean inlineElement = loadMode == LoadMode.INLINE;
            String url = dependency.hasKey(BootstrapHandler.URL) ? resolver.resolveVaadinUri(dependency.getString(BootstrapHandler.URL)) : null;
            switch (type) {
                case STYLESHEET: {
                    dependencyElement = this.createStylesheetElement(url);
                    break;
                }
                case JAVASCRIPT: {
                    dependencyElement = this.createJavaScriptElement(url, !inlineElement);
                    break;
                }
                case JS_MODULE: {
                    dependencyElement = this.createJavaScriptElement(url, false, "module");
                    break;
                }
                case HTML_IMPORT: {
                    dependencyElement = this.createHtmlImportElement(url);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported dependency type: " + (Object)((Object)type));
                }
            }
            if (inlineElement) {
                dependencyElement.appendChild((Node)new DataNode(dependency.getString("contents")));
            }
            return dependencyElement;
        }

        private Element createHtmlImportElement(String url) {
            Element htmlImportElement = url != null ? new Element(Tag.valueOf((String)"link"), "").attr("rel", "import").attr("href", url) : new Element(Tag.valueOf((String)"span"), "").attr("hidden", true);
            return htmlImportElement;
        }

        private Element createStylesheetElement(String url) {
            Element cssElement = url != null ? new Element(Tag.valueOf((String)"link"), "").attr("rel", "stylesheet").attr("type", BootstrapHandler.CSS_TYPE_ATTRIBUTE_VALUE).attr("href", url) : new Element(Tag.valueOf((String)"style"), "").attr("type", BootstrapHandler.CSS_TYPE_ATTRIBUTE_VALUE);
            return cssElement;
        }

        private void setupDocumentBody(Document document) {
            document.body().appendElement("noscript").append("You have to enable javascript in your browser to use this web site.");
        }

        private Element getPushScript(BootstrapContext context) {
            VaadinRequest request = context.getRequest();
            String versionQueryParam = "?v=" + Version.getFullVersion();
            String pushJSPath = context.getRequest().getService().getContextRootRelativePath(request);
            pushJSPath = request.getService().getDeploymentConfiguration().isProductionMode() ? pushJSPath + "VAADIN/static/push/vaadinPush-min.js" : pushJSPath + "VAADIN/static/push/vaadinPush.js";
            pushJSPath = pushJSPath + versionQueryParam;
            return this.createJavaScriptElement(pushJSPath);
        }

        private Element getBootstrapScript(JsonValue initialUIDL, BootstrapContext context) {
            return this.createInlineJavaScriptElement("//<![CDATA[\n" + this.getBootstrapJS(initialUIDL, context) + "//]]>");
        }

        private String getBootstrapJS() {
            if (BOOTSTRAP_JS.isEmpty()) {
                throw new BootstrapException("BootstrapHandler.js has not been loaded during initialization");
            }
            return BOOTSTRAP_JS;
        }

        private String getBootstrapJS(JsonValue initialUIDL, BootstrapContext context) {
            boolean productionMode = context.getSession().getConfiguration().isProductionMode();
            String result = this.getBootstrapJS();
            JsonObject appConfig = context.getApplicationParameters();
            int indent = 0;
            if (!productionMode) {
                indent = 4;
            }
            String appConfigString = JsonUtil.stringify((JsonValue)appConfig, (int)indent);
            String initialUIDLString = JsonUtil.stringify((JsonValue)initialUIDL, (int)indent);
            initialUIDLString = initialUIDLString.replace("<", "\\x3C");
            result = !productionMode ? result.replace("{{GWT_STAT_EVENTS}}", GWT_STAT_EVENTS_JS) : result.replace("{{GWT_STAT_EVENTS}}", "");
            result = result.replace("{{APP_ID}}", context.getAppId());
            result = result.replace("{{CONFIG_JSON}}", appConfigString);
            result = result.replace("{{INITIAL_UIDL}}", initialUIDLString);
            result = result.replace("{{PRODUCTION_MODE}}", String.valueOf(productionMode));
            return result;
        }
    }

    public static interface PageBuilder
    extends Serializable {
        public Document getBootstrapPage(BootstrapContext var1);
    }

    public static class BootstrapUriResolver
    extends VaadinUriResolver {
        private String frontendRootUrl;
        private String servletPathToContextRoot;

        protected BootstrapUriResolver(UI ui) {
            this(ui.getInternals().getContextRootRelativePath(), ui.getSession());
        }

        public BootstrapUriResolver(String contextRootRelatiePath, VaadinSession session) {
            this.servletPathToContextRoot = contextRootRelatiePath;
            DeploymentConfiguration config = session.getConfiguration();
            this.frontendRootUrl = config.isCompatibilityMode() ? (session.getBrowser().isEs6Supported() ? config.getEs6FrontendPrefix() : config.getEs5FrontendPrefix()) : config.getNpmFrontendPrefix();
            assert (this.frontendRootUrl.endsWith("/"));
            assert (this.servletPathToContextRoot.endsWith("/"));
        }

        public String resolveVaadinUri(String uri) {
            return super.resolveVaadinUri(uri, this.frontendRootUrl, this.servletPathToContextRoot);
        }
    }

    protected static class BootstrapContext {
        private final VaadinRequest request;
        private final VaadinResponse response;
        private final VaadinSession session;
        private final UI ui;
        private final Class<?> pageConfigurationHolder;
        private final ApplicationParameterBuilder parameterBuilder;
        private String appId;
        private PushMode pushMode;
        private JsonObject applicationParameters;
        private BootstrapUriResolver uriResolver;

        protected BootstrapContext(VaadinRequest request, VaadinResponse response, VaadinSession session, UI ui, Function<VaadinRequest, String> contextCallback) {
            this.request = request;
            this.response = response;
            this.session = session;
            this.ui = ui;
            this.parameterBuilder = new ApplicationParameterBuilder(contextCallback);
            this.pageConfigurationHolder = BootstrapUtils.resolvePageConfigurationHolder(ui, request).orElse(null);
        }

        public VaadinResponse getResponse() {
            return this.response;
        }

        public VaadinRequest getRequest() {
            return this.request;
        }

        public VaadinSession getSession() {
            return this.session;
        }

        public UI getUI() {
            return this.ui;
        }

        public PushMode getPushMode() {
            if (this.pushMode == null) {
                this.pushMode = this.getUI().getPushConfiguration().getPushMode();
                if (this.pushMode == null) {
                    this.pushMode = this.getRequest().getService().getDeploymentConfiguration().getPushMode();
                }
                if (this.pushMode.isEnabled() && !this.getRequest().getService().ensurePushAvailable()) {
                    this.pushMode = PushMode.DISABLED;
                }
            }
            return this.pushMode;
        }

        public String getAppId() {
            if (this.appId == null) {
                this.appId = this.getRequest().getService().getMainDivId(this.getSession(), this.getRequest());
            }
            return this.appId;
        }

        public JsonObject getApplicationParameters() {
            if (this.applicationParameters == null) {
                this.applicationParameters = this.parameterBuilder.getApplicationParameters(this);
            }
            return this.applicationParameters;
        }

        public BootstrapUriResolver getUriResolver() {
            if (this.uriResolver == null) {
                this.uriResolver = new BootstrapUriResolver(this.getUI());
            }
            return this.uriResolver;
        }

        public boolean isProductionMode() {
            return this.request.getService().getDeploymentConfiguration().isProductionMode();
        }

        public <T extends Annotation> Optional<T> getPageConfigurationAnnotation(Class<T> annotationType) {
            if (this.pageConfigurationHolder == null) {
                return Optional.empty();
            }
            return AnnotationReader.getAnnotationFor(this.pageConfigurationHolder, annotationType);
        }

        public <T extends Annotation> List<T> getPageConfigurationAnnotations(Class<T> annotationType) {
            if (this.pageConfigurationHolder == null) {
                return Collections.emptyList();
            }
            return AnnotationReader.getAnnotationsFor(this.pageConfigurationHolder, annotationType);
        }

        protected Optional<ThemeDefinition> getTheme() {
            return this.ui.getThemeFor(this.pageConfigurationHolder, null);
        }

        protected Optional<PwaRegistry> getPwaRegistry() {
            VaadinService vaadinService = this.getSession().getService();
            if (vaadinService == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(vaadinService.getPwaRegistry());
        }
    }
}

