/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FallibleCommand;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskGenerateTsFiles
implements FallibleCommand {
    private static final String TSCONFIG_JSON = "tsconfig.json";
    private static final String TS_DEFINITIONS = "types.d.ts";
    private final File npmFolder;
    private final List<String> modules;

    TaskGenerateTsFiles(File npmFolder, List<String> modules) {
        this.npmFolder = npmFolder;
        this.modules = modules;
    }

    protected boolean shouldGenerate() {
        return this.modules.stream().filter(file -> file.endsWith(".ts")).count() >= 1L;
    }

    @Override
    public void execute() throws ExecutionFailedException {
        if (!this.shouldGenerate()) {
            return;
        }
        this.writeFile(TSCONFIG_JSON);
        this.writeFile(TS_DEFINITIONS);
    }

    private void writeFile(String file) throws ExecutionFailedException {
        File generatedFile = new File(this.npmFolder, file);
        if (generatedFile.exists()) {
            return;
        }
        try {
            String fileContent = IOUtils.toString((InputStream)this.getClass().getResourceAsStream(file), (Charset)StandardCharsets.UTF_8);
            this.log().info("writing file '{}'", (Object)generatedFile);
            FileUtils.forceMkdirParent((File)generatedFile);
            FileUtils.writeStringToFile((File)generatedFile, (String)fileContent, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException exception) {
            String errorMessage = String.format("Error writing '%s'", generatedFile);
            throw new ExecutionFailedException(errorMessage, exception);
        }
    }

    Logger log() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

