/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.theme;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.theme.NoTheme;
import com.vaadin.flow.theme.Theme;
import com.vaadin.flow.theme.ThemeDefinition;
import java.util.List;
import java.util.Optional;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThemeUtil {
    private static final boolean IS_OSGI_ENV = ThemeUtil.isInOSGi();

    private ThemeUtil() {
    }

    public static Optional<ThemeDefinition> getLumoThemeDefinition() {
        if (IS_OSGI_ENV) {
            Bundle bundle = FrameworkUtil.getBundle(ThemeDefinition.class);
            if (bundle == null) {
                return Optional.ofNullable(LazyLoadLumoTheme.LUMO_CLASS_IF_AVAILABLE);
            }
            BundleContext context = bundle.getBundleContext();
            ServiceReference reference = context.getServiceReference(ThemeDefinition.class);
            return Optional.ofNullable(reference).map(arg_0 -> ((BundleContext)context).getService(arg_0));
        }
        return Optional.ofNullable(LazyLoadLumoTheme.LUMO_CLASS_IF_AVAILABLE);
    }

    public static ThemeDefinition findThemeForNavigationTarget(UI ui, Class<?> navigationTarget, String path) {
        Class<?> target;
        Optional<Theme> themeAnnotation;
        if (navigationTarget == null) {
            return ThemeUtil.getLumoThemeDefinition().orElse(null);
        }
        Class<? extends RouterLayout> topParentLayout = null;
        if (Component.class.isAssignableFrom(navigationTarget)) {
            List<Class<? extends RouterLayout>> routeLayouts = ui.getInternals().getRouter().getRegistry().getRouteLayouts(path, navigationTarget);
            topParentLayout = routeLayouts.isEmpty() ? null : routeLayouts.get(routeLayouts.size() - 1);
        }
        if ((themeAnnotation = AnnotationReader.getAnnotationFor(target = topParentLayout == null ? navigationTarget : topParentLayout, Theme.class)).isPresent()) {
            return new ThemeDefinition(themeAnnotation.get());
        }
        if (!AnnotationReader.getAnnotationFor(target, NoTheme.class).isPresent()) {
            return ThemeUtil.getLumoThemeDefinition().orElse(null);
        }
        return null;
    }

    private static boolean isInOSGi() {
        try {
            Class.forName("org.osgi.framework.FrameworkUtil");
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    private static final class LazyLoadLumoTheme {
        private static final ThemeDefinition LUMO_CLASS_IF_AVAILABLE = LazyLoadLumoTheme.loadLumoClassIfAvailable();

        private LazyLoadLumoTheme() {
        }

        private static ThemeDefinition loadLumoClassIfAvailable() {
            try {
                Class<?> theme = Class.forName("com.vaadin.flow.theme.lumo.LumoThemeDefinition");
                return (ThemeDefinition)ReflectTools.createInstance(theme);
            }
            catch (ClassNotFoundException e) {
                Logger logger = LoggerFactory.getLogger((String)RouteUtil.class.getName());
                logger.trace("Lumo theme is not present in the classpath. The application will not use any default theme.", (Throwable)e);
                return null;
            }
        }
    }
}

