/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.FrontendVersion;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;

public class TaskUpdatePackages
extends NodeUpdater {
    private static final String VERSION = "version";
    private static final String SHRINK_WRAP = "@vaadin/vaadin-shrinkwrap";
    protected static final String VAADIN_APP_PACKAGE_HASH = "vaadinAppPackageHash";
    protected static final String VAADIN_FLOW_DEPS = "@vaadin/flow-deps";
    private final boolean forceCleanUp;
    private final boolean enablePnpm;

    TaskUpdatePackages(ClassFinder finder, FrontendDependenciesScanner frontendDependencies, File npmFolder, File generatedPath, boolean forceCleanUp, boolean enablePnpm) {
        super(finder, frontendDependencies, npmFolder, generatedPath);
        this.forceCleanUp = forceCleanUp;
        this.enablePnpm = enablePnpm;
    }

    @Override
    public void execute() {
        try {
            Map<String, String> scannedApplicationDependencies = this.frontDeps.getPackages();
            JsonObject packageJson = this.getPackageJson();
            this.modified = this.updatePackageJsonDependencies(packageJson, scannedApplicationDependencies);
            if (this.modified) {
                this.writePackageFile(packageJson);
                if (this.enablePnpm) {
                    this.deletePnpmLockFile();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    String writePackageFile(JsonObject json) throws IOException {
        this.sortObject(json, "dependencies");
        this.sortObject(json, "devDependencies");
        this.sortObject(json, "vaadin");
        return super.writePackageFile(json);
    }

    private void sortObject(JsonObject json, String key) {
        if (!json.hasKey(key)) {
            return;
        }
        JsonObject object = (JsonObject)json.get(key);
        JsonObject ordered = this.orderKeys(object);
        Stream.of(object.keys()).forEach(arg_0 -> ((JsonObject)object).remove(arg_0));
        Stream.of(ordered.keys()).forEach(prop -> {
            JsonValue value = ordered.get(prop);
            object.put(prop, value);
        });
    }

    private JsonObject orderKeys(JsonObject object) {
        Object[] keys = object.keys();
        Arrays.sort(keys);
        JsonObject result = Json.createObject();
        for (Object key : keys) {
            JsonValue value = object.get((String)key);
            if (value instanceof JsonObject) {
                value = this.orderKeys((JsonObject)value);
            }
            result.put((String)key, value);
        }
        return result;
    }

    private boolean updatePackageJsonDependencies(JsonObject packageJson, Map<String, String> applicationDependencies) throws IOException {
        JsonObject platformPinnedDependencies;
        int added = 0;
        for (Map.Entry<String, String> dep : applicationDependencies.entrySet()) {
            added += this.addDependency(packageJson, "dependencies", dep.getKey(), dep.getValue());
        }
        ArrayList<String> pinnedPlatformDependencies = new ArrayList<String>();
        if (!this.enablePnpm && (platformPinnedDependencies = this.getPlatformPinnedDependencies()) != null) {
            for (String key : platformPinnedDependencies.keys()) {
                if (!applicationDependencies.containsKey(key) && this.pinPlatformDependency(packageJson, platformPinnedDependencies, key)) {
                    ++added;
                }
                pinnedPlatformDependencies.add(key);
            }
        }
        if (added > 0) {
            this.log().debug("Added {} dependencies to main package.json", (Object)added);
        }
        JsonObject dependencies = packageJson.getObject("dependencies");
        List<String> dependencyCollection = Stream.concat(applicationDependencies.entrySet().stream(), TaskUpdatePackages.getDefaultDependencies().entrySet().stream()).map(Map.Entry::getKey).collect(Collectors.toList());
        dependencyCollection.addAll(pinnedPlatformDependencies);
        boolean doCleanUp = this.forceCleanUp;
        int removed = this.removeLegacyProperties(packageJson);
        removed += this.cleanDependencies(dependencyCollection, packageJson, "dependencies");
        if (dependencies != null) {
            doCleanUp = doCleanUp || !this.enablePnpm && this.isPlatformVersionUpdated(dependencies);
        }
        dependencyCollection = new ArrayList<String>(TaskUpdatePackages.getDefaultDevDependencies().keySet());
        int removedDev = this.cleanDependencies(dependencyCollection, packageJson, "devDependencies");
        if (removed > 0) {
            this.log().debug("Removed {} dependencies", (Object)removed);
        }
        if (removedDev > 0) {
            this.log().debug("Removed {} devDependencies", (Object)removedDev);
        }
        if (doCleanUp) {
            this.cleanUp();
        }
        String oldHash = packageJson.getObject("vaadin").getString("hash");
        String newHash = TaskUpdatePackages.generatePackageJsonHash(packageJson);
        packageJson.getObject("vaadin").put("hash", newHash);
        return added > 0 || removed > 0 || !oldHash.equals(newHash);
    }

    private int cleanDependencies(List<String> dependencyCollection, JsonObject packageJson, String dependencyKey) {
        int removed = 0;
        JsonObject dependencyObject = packageJson.getObject(dependencyKey);
        JsonObject vaadinDependencyObject = packageJson.getObject("vaadin").getObject(dependencyKey);
        if (dependencyObject != null) {
            for (String key : dependencyObject.keys()) {
                if (dependencyCollection.contains(key) || !vaadinDependencyObject.hasKey(key)) continue;
                dependencyObject.remove(key);
                vaadinDependencyObject.remove(key);
                this.log().debug("Removed \"{}\".", (Object)key);
                ++removed;
            }
        }
        return removed;
    }

    private boolean pinPlatformDependency(JsonObject packageJson, JsonObject platformPinnedVersions, String pkg) {
        FrontendVersion platformPinnedVersion = FrontendUtils.getPackageVersionFromJson(platformPinnedVersions, pkg, "vaadin_dependencies.json");
        if (platformPinnedVersion == null) {
            return false;
        }
        JsonObject vaadinDeps = packageJson.getObject("vaadin").getObject("dependencies");
        JsonObject packageJsonDeps = packageJson.getObject("dependencies");
        assert (vaadinDeps != null) : "vaadin{ dependencies { } } should exist";
        assert (packageJsonDeps != null) : "dependencies { } should exist";
        if (!(packageJsonDeps.hasKey(pkg) && vaadinDeps.hasKey(pkg) && platformPinnedVersion.equals(new FrontendVersion(packageJsonDeps.getString(pkg))) && platformPinnedVersion.equals(new FrontendVersion(vaadinDeps.getString(pkg))))) {
            packageJsonDeps.put(pkg, platformPinnedVersion.getFullVersion());
            vaadinDeps.put(pkg, platformPinnedVersion.getFullVersion());
            return true;
        }
        return false;
    }

    private boolean isPlatformVersionUpdated(JsonObject dependencies) throws IOException {
        String existingShrinkWrapVersion;
        String shrinkWrapVersion = null;
        if (dependencies.hasKey(SHRINK_WRAP)) {
            shrinkWrapVersion = dependencies.getString(SHRINK_WRAP);
        }
        return !Objects.equals(shrinkWrapVersion, existingShrinkWrapVersion = this.getExistingShrinkWrapVersion());
    }

    private int removeLegacyProperties(JsonObject packageJson) throws IOException {
        JsonObject object;
        int result = 0;
        if (packageJson.hasKey("dependencies") && (object = packageJson.getObject("dependencies")).hasKey(VAADIN_FLOW_DEPS)) {
            object.remove(VAADIN_FLOW_DEPS);
            this.log().debug("Removed \"{}\" as it's not generated anymore.", (Object)VAADIN_FLOW_DEPS);
        }
        if (packageJson.hasKey(VAADIN_APP_PACKAGE_HASH)) {
            packageJson.remove(VAADIN_APP_PACKAGE_HASH);
            this.log().debug("Removed \"{}\" as it's not used.", (Object)VAADIN_APP_PACKAGE_HASH);
            ++result;
        }
        if (!this.enablePnpm) {
            return result;
        }
        File packageLockFile = this.getPackageLockFile();
        if (packageLockFile.exists()) {
            FileUtils.forceDelete((File)this.getPackageLockFile());
        }
        return result;
    }

    private void cleanUp() throws IOException {
        File generatedNodeModules;
        File packageLock = this.getPackageLockFile();
        if (packageLock.exists() && !packageLock.delete()) {
            throw new IOException("Could not remove " + packageLock.getPath() + " file. This file has been generated with a different platform version. Try to remove it manually.");
        }
        if (this.nodeModulesFolder.exists()) {
            this.removeDir(this.nodeModulesFolder);
        }
        if ((generatedNodeModules = new File(this.generatedFolder, "node_modules/")).exists()) {
            this.removeDir(generatedNodeModules);
        }
    }

    private void removeDir(File file) throws IOException {
        Files.walkFileTree(file.toPath(), new RemoveFileVisitor());
    }

    private String getExistingShrinkWrapVersion() throws IOException {
        String shrinkWrapVersion = this.getShrinkWrapVersion(this.getPackageJson());
        if (shrinkWrapVersion != null) {
            return shrinkWrapVersion;
        }
        shrinkWrapVersion = this.getPackageLockShrinkWrapVersion();
        return shrinkWrapVersion;
    }

    private String getPackageLockShrinkWrapVersion() throws IOException {
        JsonObject dependencies = this.getPackageLockDependencies();
        if (dependencies == null) {
            return null;
        }
        if (!dependencies.hasKey(SHRINK_WRAP)) {
            return null;
        }
        JsonObject shrinkWrap = dependencies.getObject(SHRINK_WRAP);
        if (shrinkWrap.hasKey(VERSION)) {
            return shrinkWrap.get(VERSION).asString();
        }
        return null;
    }

    private JsonObject getPackageLockDependencies() throws IOException {
        File packageLock = this.getPackageLockFile();
        if (!packageLock.exists()) {
            return null;
        }
        JsonObject packageLockJson = TaskUpdatePackages.getJsonFileContent(packageLock);
        if (packageLockJson == null) {
            return null;
        }
        if (!packageLockJson.hasKey("dependencies")) {
            return null;
        }
        JsonObject dependencies = packageLockJson.getObject("dependencies");
        return dependencies;
    }

    private File getPackageLockFile() {
        return new File(this.npmFolder, "package-lock.json");
    }

    private String getShrinkWrapVersion(JsonObject packageJson) {
        JsonObject dependencies;
        if (packageJson == null) {
            return null;
        }
        if (packageJson.hasKey("dependencies") && (dependencies = packageJson.getObject("dependencies")).hasKey(SHRINK_WRAP)) {
            JsonValue value = dependencies.get(SHRINK_WRAP);
            return value.asString();
        }
        return null;
    }

    private void deletePnpmLockFile() throws IOException {
        File lockFile = new File(this.npmFolder, "pnpm-lock.yaml");
        if (lockFile.exists()) {
            FileUtils.forceDelete((File)lockFile);
        }
    }

    static String generatePackageJsonHash(JsonObject packageJson) {
        StringBuilder hashContent = new StringBuilder();
        if (packageJson.hasKey("dependencies")) {
            JsonObject dependencies = packageJson.getObject("dependencies");
            hashContent.append("\"dependencies\": {");
            String sortedDependencies = Arrays.stream(dependencies.keys()).sorted(String::compareToIgnoreCase).map(key -> String.format("\"%s\": \"%s\"", key, dependencies.getString(key))).collect(Collectors.joining(",\n  "));
            hashContent.append(sortedDependencies);
            hashContent.append("}");
        }
        if (packageJson.hasKey("devDependencies")) {
            if (hashContent.length() > 0) {
                hashContent.append(",\n");
            }
            JsonObject devDependencies = packageJson.getObject("devDependencies");
            hashContent.append("\"devDependencies\": {");
            String sortedDevDependencies = Arrays.stream(devDependencies.keys()).sorted(String::compareToIgnoreCase).map(key -> String.format("\"%s\": \"%s\"", key, devDependencies.getString(key))).collect(Collectors.joining(",\n  "));
            hashContent.append(sortedDevDependencies);
            hashContent.append("}");
        }
        return StringUtil.getHash(hashContent.toString());
    }

    private static class RemoveFileVisitor
    extends SimpleFileVisitor<Path>
    implements Serializable {
        private RemoveFileVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return super.visitFile(file, attrs);
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Files.delete(dir);
            return super.postVisitDirectory(dir, exc);
        }
    }
}

