/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.shared;

import java.io.Serializable;

public class BrowserDetails
implements Serializable {
    private static final String CHROME = " chrome/";
    private static final String HEADLESSCHROME = " headlesschrome/";
    private static final String OS_MAJOR = "OS major";
    private static final String OS_MINOR = "OS minor";
    private static final String BROWSER_MAJOR = "Browser major";
    private static final String BROWSER_MINOR = "Browser minor";
    private boolean isGecko;
    private boolean isWebKit;
    private boolean isPresto;
    private boolean isTrident;
    private boolean isSafari;
    private boolean isChrome;
    private boolean isFirefox;
    private boolean isOpera;
    private boolean isIE;
    private boolean isEdge;
    private boolean isWindowsPhone;
    private boolean isIPad;
    private boolean isIPhone;
    private boolean isChromeOS;
    private OperatingSystem os = OperatingSystem.UNKNOWN;
    private float browserEngineVersion = -1.0f;
    private int browserMajorVersion = -1;
    private int browserMinorVersion = -1;
    private int osMajorVersion = -1;
    private int osMinorVersion = -1;

    public BrowserDetails(String userAgent) {
        String tmp;
        int rvPos;
        userAgent = userAgent.toLowerCase();
        this.isGecko = userAgent.contains("gecko") && !userAgent.contains("webkit") && !userAgent.contains("trident/");
        this.isPresto = userAgent.contains(" presto/");
        this.isTrident = userAgent.contains("trident/");
        this.isWebKit = !this.isTrident && userAgent.contains("applewebkit");
        this.isChrome = userAgent.contains(CHROME) || userAgent.contains(" crios/") || userAgent.contains(HEADLESSCHROME);
        this.isOpera = userAgent.contains("opera");
        this.isIE = userAgent.contains("msie") && !this.isOpera && !userAgent.contains("webtv");
        this.isIE = this.isIE || this.isTrident;
        this.isSafari = !this.isChrome && !this.isIE && userAgent.contains("safari");
        this.isFirefox = userAgent.contains(" firefox/");
        if (userAgent.contains(" edge/") || userAgent.contains(" edg/") || userAgent.contains(" edga/") || userAgent.contains(" edgios/")) {
            this.isEdge = true;
            this.isChrome = false;
            this.isOpera = false;
            this.isIE = false;
            this.isSafari = false;
            this.isFirefox = false;
            this.isWebKit = false;
            this.isGecko = false;
        }
        try {
            if (this.isGecko) {
                rvPos = userAgent.indexOf("rv:");
                if (rvPos >= 0) {
                    tmp = userAgent.substring(rvPos + 3);
                    tmp = tmp.replaceFirst("(\\.[0-9]+).+", "$1");
                    this.browserEngineVersion = Float.parseFloat(tmp);
                }
            } else if (this.isWebKit) {
                String tmp2 = userAgent.substring(userAgent.indexOf("webkit/") + 7);
                tmp2 = tmp2.replaceFirst("([0-9]+\\.[0-9]+).*", "$1");
                this.browserEngineVersion = Float.parseFloat(tmp2);
            } else if (this.isTrident) {
                String tmp3 = userAgent.substring(userAgent.indexOf("trident/") + 8);
                tmp3 = tmp3.replaceFirst("([0-9]+\\.[0-9]+).*", "$1");
                this.browserEngineVersion = Float.parseFloat(tmp3);
                if (this.browserEngineVersion > 7.0f) {
                    this.browserEngineVersion = 7.0f;
                }
            } else if (this.isEdge) {
                this.browserEngineVersion = 0.0f;
            }
        }
        catch (Exception e) {
            BrowserDetails.log("Browser engine version parsing failed for: " + userAgent, e);
        }
        try {
            int i;
            if (this.isIE) {
                if (!userAgent.contains("msie")) {
                    rvPos = userAgent.indexOf("rv:");
                    if (rvPos >= 0) {
                        tmp = userAgent.substring(rvPos + 3);
                        tmp = tmp.replaceFirst("(\\.[0-9]+).+", "$1");
                        this.parseVersionString(tmp);
                    }
                } else if (this.isTrident) {
                    this.browserMajorVersion = 4 + (int)this.browserEngineVersion;
                    this.browserMinorVersion = 0;
                } else {
                    String ieVersionString = userAgent.substring(userAgent.indexOf("msie ") + 5);
                    ieVersionString = BrowserDetails.safeSubstring(ieVersionString, 0, ieVersionString.indexOf(59));
                    this.parseVersionString(ieVersionString);
                }
            } else if (this.isFirefox) {
                i = userAgent.indexOf(" firefox/") + 9;
                this.parseVersionString(BrowserDetails.safeSubstring(userAgent, i, i + 5));
            } else if (this.isChrome) {
                this.parseChromeVersion(userAgent);
            } else if (this.isSafari) {
                i = userAgent.indexOf(" version/");
                if (i >= 0) {
                    this.parseVersionString(BrowserDetails.safeSubstring(userAgent, i += 9, i + 5));
                } else {
                    int engineVersion = (int)(this.browserEngineVersion * 10.0f);
                    if (engineVersion >= 6010 && engineVersion < 6015) {
                        this.browserMajorVersion = 9;
                        this.browserMinorVersion = 0;
                    } else if (engineVersion >= 6015 && engineVersion < 6018) {
                        this.browserMajorVersion = 9;
                        this.browserMinorVersion = 1;
                    } else if (engineVersion >= 6020 && engineVersion < 6030) {
                        this.browserMajorVersion = 10;
                        this.browserMinorVersion = 0;
                    } else if (engineVersion >= 6030 && engineVersion < 6040) {
                        this.browserMajorVersion = 10;
                        this.browserMinorVersion = 1;
                    } else if (engineVersion >= 6040 && engineVersion < 6050) {
                        this.browserMajorVersion = 11;
                        this.browserMinorVersion = 0;
                    } else if (engineVersion >= 6050 && engineVersion < 6060) {
                        this.browserMajorVersion = 11;
                        this.browserMinorVersion = 1;
                    } else if (engineVersion >= 6060 && engineVersion < 6070) {
                        this.browserMajorVersion = 12;
                        this.browserMinorVersion = 0;
                    } else if (engineVersion >= 6070) {
                        this.browserMajorVersion = 12;
                        this.browserMinorVersion = 1;
                    }
                }
            } else if (this.isOpera) {
                i = userAgent.indexOf(" version/");
                i = i != -1 ? (i += 9) : userAgent.indexOf("opera/") + 6;
                this.parseVersionString(BrowserDetails.safeSubstring(userAgent, i, i + 5));
            } else if (this.isEdge) {
                i = userAgent.indexOf(" edge/") + 6;
                if (userAgent.contains(" edg/")) {
                    i = userAgent.indexOf(" edg/") + 5;
                } else if (userAgent.contains(" edga/")) {
                    i = userAgent.indexOf(" edga/") + 6;
                } else if (userAgent.contains(" edgios/")) {
                    i = userAgent.indexOf(" edgios/") + 8;
                }
                this.parseVersionString(BrowserDetails.safeSubstring(userAgent, i, i + 8));
            }
        }
        catch (Exception e) {
            BrowserDetails.log("Browser version parsing failed for: " + userAgent, e);
        }
        if (userAgent.contains("windows ")) {
            this.os = OperatingSystem.WINDOWS;
            this.isWindowsPhone = userAgent.contains("windows phone");
        } else if (userAgent.contains("android")) {
            this.os = OperatingSystem.ANDROID;
            this.parseAndroidVersion(userAgent);
        } else if (userAgent.contains("linux")) {
            this.os = OperatingSystem.LINUX;
        } else if (userAgent.contains("macintosh") || userAgent.contains("mac osx") || userAgent.contains("mac os x")) {
            this.isIPad = userAgent.contains("ipad");
            this.isIPhone = userAgent.contains("iphone");
            if (this.isIPad || userAgent.contains("ipod") || this.isIPhone) {
                this.os = OperatingSystem.IOS;
                this.parseIOSVersion(userAgent);
            } else {
                this.os = OperatingSystem.MACOSX;
            }
        } else if (userAgent.contains("; cros ")) {
            this.os = OperatingSystem.CHROMEOS;
            this.isChromeOS = true;
            this.parseChromeOSVersion(userAgent);
        }
    }

    private void parseChromeOSVersion(String userAgent) {
        int cur;
        int start = userAgent.indexOf("; cros ");
        if (start == -1) {
            return;
        }
        int end = userAgent.indexOf(41, start);
        if (end == -1) {
            return;
        }
        for (cur = end; cur >= start && userAgent.charAt(cur) != ' '; --cur) {
        }
        if (cur == start) {
            return;
        }
        String osVersionString = userAgent.substring(cur + 1, end);
        String[] parts = osVersionString.split("\\.");
        this.parseChromeOsVersionParts(parts);
    }

    private void parseChromeOsVersionParts(String[] parts) {
        this.osMajorVersion = -1;
        this.osMinorVersion = -1;
        if (parts.length > 2) {
            this.osMajorVersion = this.parseVersionPart(parts[0], OS_MAJOR);
            this.osMinorVersion = this.parseVersionPart(parts[1], OS_MINOR);
        }
    }

    private void parseChromeVersion(String userAgent) {
        int i = userAgent.indexOf(" crios/");
        if (i == -1) {
            i = userAgent.indexOf(CHROME);
            i = i == -1 ? userAgent.indexOf(HEADLESSCHROME) + HEADLESSCHROME.length() : (i += CHROME.length());
            this.parseVersionString(BrowserDetails.safeSubstring(userAgent, i, i + 5));
        } else {
            this.parseVersionString(BrowserDetails.safeSubstring(userAgent, i += 7, i + 6));
        }
    }

    private void parseAndroidVersion(String userAgent) {
        if (!userAgent.contains("android")) {
            return;
        }
        String osVersionString = BrowserDetails.safeSubstring(userAgent, userAgent.indexOf("android ") + "android ".length(), userAgent.length());
        osVersionString = BrowserDetails.safeSubstring(osVersionString, 0, osVersionString.indexOf(";"));
        String[] parts = osVersionString.split("\\.");
        this.parseOsVersion(parts);
    }

    private void parseIOSVersion(String userAgent) {
        if (!userAgent.contains("os ") || !userAgent.contains(" like mac")) {
            return;
        }
        String osVersionString = BrowserDetails.safeSubstring(userAgent, userAgent.indexOf("os ") + 3, userAgent.indexOf(" like mac"));
        String[] parts = osVersionString.split("_");
        this.parseOsVersion(parts);
    }

    private void parseOsVersion(String[] parts) {
        this.osMajorVersion = -1;
        this.osMinorVersion = -1;
        if (parts.length >= 1) {
            this.osMajorVersion = this.parseVersionPart(parts[0], OS_MAJOR);
        }
        if (parts.length >= 2) {
            int dashIndex = parts[1].indexOf(45);
            if (dashIndex > -1) {
                String dashlessVersion = parts[1].substring(0, dashIndex);
                this.osMinorVersion = this.parseVersionPart(dashlessVersion, OS_MINOR);
            } else {
                this.osMinorVersion = this.parseVersionPart(parts[1], OS_MINOR);
            }
        }
    }

    private void parseVersionString(String versionString) {
        int idx = versionString.indexOf(46);
        if (idx < 0) {
            idx = versionString.length();
        }
        String majorVersionPart = BrowserDetails.safeSubstring(versionString, 0, idx);
        this.browserMajorVersion = this.parseVersionPart(majorVersionPart, BROWSER_MAJOR);
        int idx2 = versionString.indexOf(46, idx + 1);
        if (idx2 < 0) {
            idx2 = versionString.length();
        }
        String minorVersionPart = BrowserDetails.safeSubstring(versionString, idx + 1, idx2).replaceAll("[^0-9].*", "");
        this.browserMinorVersion = this.parseVersionPart(minorVersionPart, BROWSER_MINOR);
    }

    private static String safeSubstring(String string, int beginIndex, int endIndex) {
        int trimmedStart = beginIndex < 0 ? 0 : beginIndex;
        int trimmedEnd = endIndex < 0 || endIndex > string.length() ? string.length() : endIndex;
        return string.substring(trimmedStart, trimmedEnd);
    }

    private int parseVersionPart(String versionString, String partName) {
        try {
            return Integer.parseInt(versionString);
        }
        catch (Exception e) {
            BrowserDetails.log(partName + " version parsing failed for: " + versionString, e);
            return -1;
        }
    }

    public boolean isFirefox() {
        return this.isFirefox;
    }

    public boolean isGecko() {
        return this.isGecko;
    }

    public boolean isWebKit() {
        return this.isWebKit;
    }

    public boolean isPresto() {
        return this.isPresto;
    }

    public boolean isTrident() {
        return this.isTrident;
    }

    public boolean isSafari() {
        return this.isSafari;
    }

    @Deprecated
    public boolean isSafariOrIOS() {
        return this.isSafari() || this.isIOS();
    }

    public boolean isChrome() {
        return this.isChrome;
    }

    public boolean isOpera() {
        return this.isOpera;
    }

    public boolean isIE() {
        return this.isIE;
    }

    public boolean isEdge() {
        return this.isEdge;
    }

    public float getBrowserEngineVersion() {
        return this.browserEngineVersion;
    }

    public final int getBrowserMajorVersion() {
        return this.browserMajorVersion;
    }

    public final int getBrowserMinorVersion() {
        return this.browserMinorVersion;
    }

    public boolean isWindows() {
        return this.os == OperatingSystem.WINDOWS;
    }

    public boolean isWindowsPhone() {
        return this.isWindowsPhone;
    }

    public boolean isMacOSX() {
        return this.os == OperatingSystem.MACOSX;
    }

    public boolean isLinux() {
        return this.os == OperatingSystem.LINUX;
    }

    public boolean isAndroid() {
        return this.os == OperatingSystem.ANDROID;
    }

    @Deprecated
    public boolean isIOS() {
        return this.os == OperatingSystem.IOS;
    }

    public boolean isIPhone() {
        return this.isIPhone;
    }

    public boolean isChromeOS() {
        return this.isChromeOS;
    }

    @Deprecated
    public boolean isIPad() {
        return this.isIPad;
    }

    public int getOperatingSystemMajorVersion() {
        return this.osMajorVersion;
    }

    public int getOperatingSystemMinorVersion() {
        return this.osMinorVersion;
    }

    public boolean isTooOldToFunctionProperly() {
        if (this.isIE() && this.getBrowserMajorVersion() < 11) {
            return true;
        }
        if (this.isSafari() && this.getBrowserMajorVersion() < 9) {
            if (this.getOperatingSystemMajorVersion() > 14) {
                return false;
            }
            return this.getOperatingSystemMajorVersion() != 14 || this.getOperatingSystemMinorVersion() < 7;
        }
        if (this.isFirefox() && this.getBrowserMajorVersion() < 43) {
            return true;
        }
        if (this.isOpera() && this.getBrowserMajorVersion() < 34) {
            return true;
        }
        return this.isChrome() && this.getBrowserMajorVersion() < 47;
    }

    public boolean isEs6Supported() {
        if (this.isEs5AdapterNeeded()) {
            return false;
        }
        if (this.isWebKit() && this.getBrowserEngineVersion() >= 604.0f) {
            return true;
        }
        if (this.isSafari() && this.getBrowserMajorVersion() >= 10) {
            return true;
        }
        if (this.isFirefox() && this.getBrowserMajorVersion() >= 51) {
            return true;
        }
        if (this.isOpera() && this.getBrowserMajorVersion() >= 36) {
            return true;
        }
        if (this.isChrome() && this.getBrowserMajorVersion() >= 49) {
            return true;
        }
        return this.isEdge() && (this.getBrowserMajorVersion() > 15 || this.getBrowserMajorVersion() == 15 && this.getBrowserMinorVersion() >= 15063);
    }

    public boolean isEs5AdapterNeeded() {
        if (this.isIOS() && this.getOperatingSystemMajorVersion() == 10) {
            return true;
        }
        return this.isSafari() && this.getBrowserMajorVersion() == 10;
    }

    private static void log(String error, Exception e) {
        System.err.println(error + ' ' + e.getMessage());
    }

    public static enum OperatingSystem {
        UNKNOWN,
        WINDOWS,
        MACOSX,
        LINUX,
        IOS,
        ANDROID,
        CHROMEOS;

    }
}

