/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.UrlUtil;
import com.vaadin.flow.server.frontend.ImportExtractor;
import com.vaadin.flow.server.frontend.scanner.CssData;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.ThemeDefinition;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

abstract class AbstractUpdateImports
implements Runnable {
    private static final String CSS_PREPARE = "function addCssBlock(block) {\n const tpl = document.createElement('template');\n tpl.innerHTML = block;\n document.head.appendChild(tpl.content);\n}";
    private static final String CSS_PRE = "import $css_%d from '%s';%naddCssBlock(`";
    private static final String CSS_POST = "`);";
    private static final String CSS_BASIC_TPL = "import $css_%d from '%s';%naddCssBlock(`<custom-style><style%s>${$css_%d}</style></custom-style>`);";
    private static final String CSS_MODULE_TPL = "import $css_%d from '%s';%naddCssBlock(`<dom-module id=\"%s\"><template><style%s>${$css_%d}</style></template></dom-module>`);";
    private static final String CSS_THEME_FOR_TPL = "import $css_%d from '%s';%naddCssBlock(`<dom-module id=\"%s_%d\" theme-for=\"%s\"><template><style%s>${$css_%d}</style></template></dom-module>`);";
    private static final String IMPORT_TEMPLATE = "import '%s';";
    private static final Pattern FRONTEND_IMPORT_LINE = Pattern.compile(String.format("import '%s';", "Frontend/\\S*"));
    private final File frontendDir;
    private final File npmDir;
    private final File generatedDir;
    private final File tokenFile;

    AbstractUpdateImports(File frontendDirectory, File npmDirectory, File generatedDirectory, File tokenFile) {
        this.frontendDir = frontendDirectory;
        this.npmDir = npmDirectory;
        this.generatedDir = generatedDirectory;
        this.tokenFile = tokenFile;
    }

    @Override
    public void run() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.addAll(this.getThemeLines());
        lines.addAll(this.getCssLines());
        this.collectModules(lines);
        this.writeImportLines(lines);
    }

    protected abstract void writeImportLines(List<String> var1);

    protected abstract List<String> getModules();

    protected abstract Set<String> getScripts();

    protected abstract URL getResource(String var1);

    protected abstract ThemeDefinition getThemeDefinition();

    protected abstract AbstractTheme getTheme();

    protected abstract Set<CssData> getCss();

    protected abstract Collection<String> getThemeLines();

    protected abstract Collection<String> getGeneratedModules();

    protected abstract Logger getLogger();

    List<String> resolveModules(Collection<String> modules, boolean isJsModule) {
        return modules.stream().map(module -> this.resolveResource((String)module, isJsModule)).sorted().collect(Collectors.toList());
    }

    protected Collection<String> getCssLines() {
        Set<CssData> css = this.getCss();
        if (css.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> lines = new ArrayList<String>();
        this.addLines(lines, CSS_PREPARE);
        HashSet<String> cssNotFound = new HashSet<String>();
        int i = 0;
        for (CssData cssData : css) {
            if (!this.addCssLines(lines, cssData, i)) {
                cssNotFound.add(cssData.getValue());
            }
            ++i;
        }
        if (!cssNotFound.isEmpty()) {
            String prefix = String.format("Failed to find the following css files in the `node_modules` or `%s` directory tree:", this.frontendDir.getPath());
            String suffix = this.tokenFile == null && !this.frontendDir.exists() ? "Unable to locate frontend resources and missing token file. Please run the `prepare-frontend` Vaadin plugin goal before deploying the application" : String.format("Check that they exist or are installed. If you use a custom directory for your resource files instead of the default `frontend` folder then make sure it's correctly configured (e.g. set '%s' property)", "vaadin.frontend.frontend.folder");
            throw new IllegalStateException(this.notFoundMessage(cssNotFound, prefix, suffix));
        }
        lines.add("");
        return lines;
    }

    protected void updateImportsFile(File importsFile, List<String> newContent) throws IOException {
        List oldContent;
        List list = oldContent = importsFile.exists() ? FileUtils.readLines((File)importsFile, (Charset)StandardCharsets.UTF_8) : null;
        if (newContent.equals(oldContent)) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("No js modules to update '{}' file", (Object)importsFile);
            }
        } else {
            FileUtils.forceMkdir((File)importsFile.getParentFile());
            FileUtils.writeStringToFile((File)importsFile, (String)String.join((CharSequence)"\n", newContent), (Charset)StandardCharsets.UTF_8);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Updated {}", (Object)importsFile);
            }
        }
    }

    protected String resolveResource(String importPath, boolean isJsModule) {
        String resolved = importPath;
        if (!importPath.startsWith("@")) {
            String resource;
            if (importPath.startsWith("frontend://")) {
                resolved = importPath.replaceFirst("frontend://", "./");
                if (isJsModule) {
                    this.getLogger().warn("Do not use the '{}' protocol in '@JsModule', changing '{}' to '{}', please update your component.", new Object[]{"frontend://", importPath, resolved});
                }
            }
            if (this.hasMetaInfResource(resource = resolved.replaceFirst("^\\./+", ""))) {
                if (!resolved.startsWith("./")) {
                    this.getLogger().warn("Use the './' prefix for files in JAR files: '{}', please update your component.", (Object)importPath);
                }
                resolved = "@vaadin/flow-frontend/" + resource;
            }
        }
        return resolved;
    }

    protected void addLines(Collection<String> lines, String content) {
        lines.addAll(Arrays.asList(content.split("\\R")));
    }

    protected String getThemeIdPrefix() {
        return "flow_css_mod";
    }

    protected abstract String getImportsNotFoundMessage();

    private void collectModules(List<String> lines) {
        LinkedHashSet<String> modules = new LinkedHashSet<String>();
        modules.addAll(this.resolveModules(this.getModules(), true));
        modules.addAll(this.resolveModules(this.getScripts(), false));
        modules.addAll(this.getGeneratedModules());
        modules.removeIf(UrlUtil::isExternal);
        ArrayList<String> externals = new ArrayList<String>();
        ArrayList<String> internals = new ArrayList<String>();
        for (String module : this.getModuleLines(modules)) {
            if (FRONTEND_IMPORT_LINE.matcher(module).matches()) {
                internals.add(module);
                continue;
            }
            externals.add(module);
        }
        lines.addAll(externals);
        lines.addAll(internals);
    }

    private Set<String> getUniqueEs6ImportPaths(Collection<String> modules) {
        HashSet<String> npmNotFound = new HashSet<String>();
        HashSet<String> resourceNotFound = new HashSet<String>();
        LinkedHashSet<String> es6ImportPaths = new LinkedHashSet<String>();
        AbstractTheme theme = this.getTheme();
        HashSet<String> visited = new HashSet<String>();
        Iterator<String> iterator = modules.iterator();
        while (iterator.hasNext()) {
            String originalModulePath;
            String translatedModulePath = originalModulePath = iterator.next();
            String localModulePath = null;
            if (theme != null && translatedModulePath.contains(theme.getBaseUrl())) {
                translatedModulePath = theme.translateUrl(translatedModulePath);
                String themePath = theme.getThemeUrl();
                localModulePath = translatedModulePath.replaceFirst("@.+" + themePath, themePath);
            }
            if (localModulePath != null && this.frontendFileExists(localModulePath)) {
                es6ImportPaths.add(this.toValidBrowserImport(localModulePath));
            } else if (this.importedFileExists(translatedModulePath)) {
                es6ImportPaths.add(this.toValidBrowserImport(translatedModulePath));
            } else if (this.importedFileExists(originalModulePath)) {
                es6ImportPaths.add(this.toValidBrowserImport(originalModulePath));
            } else if (originalModulePath.startsWith("./")) {
                resourceNotFound.add(originalModulePath);
            } else {
                npmNotFound.add(originalModulePath);
                es6ImportPaths.add(originalModulePath);
            }
            if (theme == null) continue;
            this.handleImports(originalModulePath, theme, es6ImportPaths, visited);
        }
        if (!resourceNotFound.isEmpty()) {
            String prefix = "Failed to find the following files: ";
            String suffix = this.tokenFile == null && !this.frontendDir.exists() ? "Unable to locate frontend resources and missing token file. Please run the `prepare-frontend` Vaadin plugin goal before deploying the application" : String.format("%n  Locations searched were:%n      - `%s` in this project%n      - `%s` in included JARs%n      - `%s` in included JARs%n%n  Please, double check that those files exist. If you use a custom directory for your resource files instead of default `frontend` folder then make sure you it's correctly configured (e.g. set '%s' property)", this.frontendDir.getPath(), "META-INF/frontend", "META-INF/resources/frontend", "vaadin.frontend.frontend.folder");
            throw new IllegalStateException(this.notFoundMessage(resourceNotFound, prefix, suffix));
        }
        if (!npmNotFound.isEmpty() && this.getLogger().isInfoEnabled()) {
            this.getLogger().info(this.notFoundMessage(npmNotFound, "Failed to find the following imports in the `node_modules` tree:", this.getImportsNotFoundMessage()));
        }
        return es6ImportPaths;
    }

    private Collection<String> getModuleLines(Set<String> modules) {
        return this.getUniqueEs6ImportPaths(modules).stream().map(path -> String.format(IMPORT_TEMPLATE, path)).collect(Collectors.toList());
    }

    private boolean frontendFileExists(String jsImport) {
        File file = this.getFile(this.frontendDir, jsImport);
        return file.exists();
    }

    private boolean importedFileExists(String importName) {
        File file = this.getImportedFrontendFile(importName);
        if (file != null) {
            return true;
        }
        boolean found = this.isFile(this.getNodeModulesDir(), importName);
        if (importName.toLowerCase().endsWith(".css")) {
            return found;
        }
        found = found || this.isFile(this.getNodeModulesDir(), importName + ".js");
        found = found || this.isFile(this.getNodeModulesDir(), importName, "package.json");
        found = found || this.isFile(this.generatedDir, AbstractUpdateImports.generatedResourcePathIntoRelativePath(importName));
        return found;
    }

    private File getImportedFrontendFile(String jsImport) {
        File file = this.getFile(this.frontendDir, jsImport);
        if (file.exists()) {
            return file;
        }
        file = this.getFile(new File(this.getNodeModulesDir(), "node_modules/"), "@vaadin/flow-frontend/", jsImport);
        return file.exists() ? file : null;
    }

    private File getNodeModulesDir() {
        return new File(this.npmDir, "node_modules/");
    }

    private File getFile(File base, String ... path) {
        return new File(base, String.join((CharSequence)"/", path));
    }

    private boolean isFile(File base, String ... path) {
        return this.getFile(base, path).isFile();
    }

    private boolean addCssLines(Collection<String> lines, CssData cssData, int i) {
        String include;
        String cssFile = this.resolveResource(cssData.getValue(), false);
        boolean found = this.importedFileExists(cssFile);
        String cssImport = this.toValidBrowserImport(cssFile);
        String string = include = cssData.getInclude() != null ? " include=\"" + cssData.getInclude() + "\"" : "";
        if (cssData.getThemefor() != null) {
            this.addLines(lines, String.format(CSS_THEME_FOR_TPL, i, cssImport, this.getThemeIdPrefix(), i, cssData.getThemefor(), include, i));
        } else if (cssData.getId() != null) {
            this.addLines(lines, String.format(CSS_MODULE_TPL, i, cssImport, cssData.getId(), include, i));
        } else {
            this.addLines(lines, String.format(CSS_BASIC_TPL, i, cssImport, include, i));
        }
        return found;
    }

    private String notFoundMessage(Set<String> files, String prefix, String suffix) {
        return String.format("%n%n  %s%n      - %s%n  %s%n%n", prefix, String.join((CharSequence)"\n      - ", files), suffix);
    }

    private boolean hasMetaInfResource(String resource) {
        return this.getResource("META-INF/frontend/" + resource) != null || this.getResource("META-INF/resources/frontend/" + resource) != null;
    }

    private String toValidBrowserImport(String jsImport) {
        if (jsImport.startsWith("GENERATED/")) {
            return AbstractUpdateImports.generatedResourcePathIntoRelativePath(jsImport);
        }
        if (this.isFile(this.frontendDir, jsImport)) {
            if (!jsImport.startsWith("./")) {
                this.getLogger().warn("Use the './' prefix for files in the '{}' folder: '{}', please update your annotations.", (Object)this.frontendDir, (Object)jsImport);
            }
            return "Frontend/" + jsImport.replaceFirst("^\\./", "");
        }
        return jsImport;
    }

    private void visitImportsRecursively(Path filePath, String path, AbstractTheme theme, Collection<String> imports, Set<String> visitedImports) throws IOException {
        String content = null;
        try (Stream<String> contentStream = Files.lines(filePath, StandardCharsets.UTF_8);){
            content = contentStream.collect(Collectors.joining("\n"));
        }
        catch (UncheckedIOException ioe) {
            if (ioe.getCause() instanceof MalformedInputException) {
                this.getLogger().trace("Failed to read file '{}' found from Es6 import statements. This is probably due to it being a binary file, in which case it doesn't matter as imports are only in js/ts files.", (Object)filePath.toString(), (Object)ioe);
                return;
            }
            throw ioe;
        }
        ImportExtractor extractor = new ImportExtractor(content);
        List<String> importedPaths = extractor.getImportedPaths();
        for (String importedPath : importedPaths) {
            String translatedPath;
            String resolvedPath = this.resolve(importedPath, filePath, path);
            File file = this.getImportedFrontendFile(resolvedPath);
            if (file == null && !importedPath.startsWith("./")) {
                file = this.getFile(this.getNodeModulesDir(), resolvedPath);
                resolvedPath = importedPath;
            }
            if (file == null) continue;
            if ((resolvedPath = this.normalizePath(resolvedPath)).contains(theme.getBaseUrl()) && !visitedImports.contains(translatedPath = theme.translateUrl(resolvedPath)) && this.importedFileExists(translatedPath)) {
                visitedImports.add(translatedPath);
                imports.add(this.normalizeImportPath(translatedPath));
            }
            this.handleImports(resolvedPath, theme, imports, visitedImports);
        }
    }

    private void handleImports(String path, AbstractTheme theme, Collection<String> imports, Set<String> visitedImports) {
        if (visitedImports.contains(path)) {
            return;
        }
        File file = this.getImportedFrontendFile(path);
        if (file == null) {
            return;
        }
        Path filePath = file.toPath();
        visitedImports.add(filePath.normalize().toString().replace("\\", "/"));
        try {
            this.visitImportsRecursively(filePath, path, theme, imports, visitedImports);
        }
        catch (IOException exception) {
            this.getLogger().warn("Could not read file {}. Skipping applying theme for its imports", (Object)file.getPath(), (Object)exception);
        }
    }

    private String resolve(String importedPath, Path moduleFile, String path) {
        String pathPrefix = moduleFile.toString();
        pathPrefix = pathPrefix.substring(0, pathPrefix.length() - path.length());
        String resolvedPath = moduleFile.getParent().resolve(importedPath).toString();
        if (resolvedPath.startsWith(pathPrefix)) {
            resolvedPath = resolvedPath.substring(pathPrefix.length());
        }
        return resolvedPath;
    }

    private String normalizePath(String path) {
        File file = new File(path);
        return file.toPath().normalize().toString().replace("\\", "/");
    }

    private String normalizeImportPath(String path) {
        return this.toValidBrowserImport(this.normalizePath(path));
    }

    private static String generatedResourcePathIntoRelativePath(String path) {
        return path.replace("GENERATED/", "./");
    }
}

