/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.KeyModifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@FunctionalInterface
public interface Key
extends Serializable {
    public static final Key UNIDENTIFIED = Key.of("Unidentified", new String[0]);
    public static final Key ALT = Key.of("Alt", "AltLeft");
    public static final Key ALT_GRAPH = Key.of("AltGraph", "AltRight");
    public static final Key CAPS_LOCK = Key.of("CapsLock", new String[0]);
    public static final Key CONTROL = Key.of("Control", "ControlLeft", "ControlRight");
    public static final Key FN = Key.of("Fn", new String[0]);
    public static final Key FN_LOCK = Key.of("FnLock", new String[0]);
    public static final Key HYPER = Key.of("Hyper", new String[0]);
    public static final Key META = Key.of("Meta", new String[0]);
    public static final Key NUM_LOCK = Key.of("NumLock", new String[0]);
    public static final Key SCROLL_LOCK = Key.of("ScrollLock", new String[0]);
    public static final Key SHIFT = Key.of("Shift", "ShiftLeft", "ShiftRight");
    public static final Key SUPER = Key.of("Super", new String[0]);
    public static final Key SYMBOL = Key.of("Symbol", new String[0]);
    public static final Key SYMBOL_LOCK = Key.of("SymbolLock", new String[0]);
    public static final Key ENTER = Key.of("Enter", new String[0]);
    public static final Key TAB = Key.of("Tab", new String[0]);
    public static final Key SPACE = Key.of(" ", "Space");
    public static final Key ARROW_DOWN = Key.of("ArrowDown", new String[0]);
    public static final Key ARROW_LEFT = Key.of("ArrowLeft", new String[0]);
    public static final Key ARROW_RIGHT = Key.of("ArrowRight", new String[0]);
    public static final Key ARROW_UP = Key.of("ArrowUp", new String[0]);
    public static final Key END = Key.of("End", new String[0]);
    public static final Key HOME = Key.of("Home", new String[0]);
    public static final Key PAGE_DOWN = Key.of("PageDown", new String[0]);
    public static final Key PAGE_UP = Key.of("PageUp", new String[0]);
    public static final Key BACKSPACE = Key.of("Backspace", new String[0]);
    public static final Key CLEAR = Key.of("Clear", new String[0]);
    public static final Key COPY = Key.of("Copy", new String[0]);
    public static final Key CR_SEL = Key.of("CrSel", new String[0]);
    public static final Key CUT = Key.of("Cut", new String[0]);
    public static final Key DELETE = Key.of("Delete", "Del");
    public static final Key ERASE_EOF = Key.of("EraseEof", new String[0]);
    public static final Key EX_SEL = Key.of("ExSel", new String[0]);
    public static final Key INSERT = Key.of("Insert", new String[0]);
    public static final Key PASTE = Key.of("Paste", new String[0]);
    public static final Key REDO = Key.of("Redo", new String[0]);
    public static final Key UNDO = Key.of("Undo", new String[0]);
    public static final Key ACCEPT = Key.of("Accept", new String[0]);
    public static final Key AGAIN = Key.of("Again", new String[0]);
    public static final Key ATTN = Key.of("Attn", new String[0]);
    public static final Key CANCEL = Key.of("Cancel", new String[0]);
    public static final Key CONTEXT_MENU = Key.of("ContextMenu", new String[0]);
    public static final Key ESCAPE = Key.of("Escape", "Esc");
    public static final Key EXECUTE = Key.of("Execute", new String[0]);
    public static final Key FIND = Key.of("Find", new String[0]);
    public static final Key FINISH = Key.of("Finish", new String[0]);
    public static final Key HELP = Key.of("Help", new String[0]);
    public static final Key PAUSE = Key.of("Pause", new String[0]);
    public static final Key PLAY = Key.of("Play", new String[0]);
    public static final Key PROPS = Key.of("Props", new String[0]);
    public static final Key SELECT = Key.of("Select", new String[0]);
    public static final Key ZOOM_IN = Key.of("ZoomIn", new String[0]);
    public static final Key ZOOM_OUT = Key.of("ZoomOut", new String[0]);
    public static final Key BRIGHTNESS_DOWN = Key.of("BrightnessDown", new String[0]);
    public static final Key BRIGHTNESS_UP = Key.of("BrightnessUp", new String[0]);
    public static final Key EJECT = Key.of("Eject", new String[0]);
    public static final Key LOG_OFF = Key.of("LogOff", new String[0]);
    public static final Key POWER = Key.of("Power", new String[0]);
    public static final Key POWER_OFF = Key.of("PowerOff", new String[0]);
    public static final Key PRINT_SCREEN = Key.of("PrintScreen", new String[0]);
    public static final Key HIBERNATE = Key.of("Hibernate", new String[0]);
    public static final Key STANDBY = Key.of("Standby", new String[0]);
    public static final Key WAKE_UP = Key.of("WakeUp", new String[0]);
    public static final Key ALL_CANDIDATES = Key.of("AllCandidates", new String[0]);
    public static final Key ALPHANUMERIC = Key.of("Alphanumeric", new String[0]);
    public static final Key CODE_INPUT = Key.of("CodeInput", new String[0]);
    public static final Key COMPOSE = Key.of("Compose", new String[0]);
    public static final Key CONVERT = Key.of("Convert", new String[0]);
    public static final Key DEAD = Key.of("Dead", new String[0]);
    public static final Key FINAL_MODE = Key.of("FinalMode", new String[0]);
    public static final Key GROUP_FIRST = Key.of("GroupFirst", new String[0]);
    public static final Key GROUP_LAST = Key.of("GroupLast", new String[0]);
    public static final Key GROUP_NEXT = Key.of("GroupNext", new String[0]);
    public static final Key GROUP_PREVIOUS = Key.of("GroupPrevious", new String[0]);
    public static final Key MODE_CHANGE = Key.of("ModeChange", new String[0]);
    public static final Key NEXT_CANDIDATE = Key.of("NextCandidate", new String[0]);
    public static final Key NON_CONVERT = Key.of("NonConvert", new String[0]);
    public static final Key PREVIOUS_CANDIDATE = Key.of("PreviousCandidate", new String[0]);
    public static final Key PROCESS = Key.of("Process", new String[0]);
    public static final Key SINGLE_CANDIDATE = Key.of("SingleCandidate", new String[0]);
    public static final Key HANGUL_MODE = Key.of("HangulMode", new String[0]);
    public static final Key HANJA_MODE = Key.of("HanjaMode", new String[0]);
    public static final Key JUNJA_MODE = Key.of("JunjaMode", new String[0]);
    public static final Key EISU = Key.of("Eisu", new String[0]);
    public static final Key HANKAKU = Key.of("Hankaku", new String[0]);
    public static final Key HIRAGANA = Key.of("Hiragana", new String[0]);
    public static final Key HIRAGANA_KATAKANA = Key.of("HiraganaKatakana", new String[0]);
    public static final Key KANA_MODE = Key.of("KanaMode", new String[0]);
    public static final Key KANJI_MODE = Key.of("KanjiMode", new String[0]);
    public static final Key KATAKANA = Key.of("Katakana", new String[0]);
    public static final Key ROMAJI = Key.of("Romaji", new String[0]);
    public static final Key ZENKAKU = Key.of("Zenkaku", new String[0]);
    public static final Key ZENKAKU_HANAKU = Key.of("ZenkakuHanaku", new String[0]);
    public static final Key F1 = Key.of("F1", new String[0]);
    public static final Key F2 = Key.of("F2", new String[0]);
    public static final Key F3 = Key.of("F3", new String[0]);
    public static final Key F4 = Key.of("F4", new String[0]);
    public static final Key F5 = Key.of("F5", new String[0]);
    public static final Key F6 = Key.of("F6", new String[0]);
    public static final Key F7 = Key.of("F7", new String[0]);
    public static final Key F8 = Key.of("F8", new String[0]);
    public static final Key F9 = Key.of("F9", new String[0]);
    public static final Key F10 = Key.of("F10", new String[0]);
    public static final Key F11 = Key.of("F11", new String[0]);
    public static final Key F12 = Key.of("F12", new String[0]);
    public static final Key F13 = Key.of("F13", new String[0]);
    public static final Key F14 = Key.of("F14", new String[0]);
    public static final Key F15 = Key.of("F15", new String[0]);
    public static final Key F16 = Key.of("F16", new String[0]);
    public static final Key F17 = Key.of("F17", new String[0]);
    public static final Key F18 = Key.of("F18", new String[0]);
    public static final Key F19 = Key.of("F19", new String[0]);
    public static final Key F20 = Key.of("F20", new String[0]);
    public static final Key SOFT1 = Key.of("Soft1", new String[0]);
    public static final Key SOFT2 = Key.of("Soft2", new String[0]);
    public static final Key SOFT3 = Key.of("Soft3", new String[0]);
    public static final Key SOFT4 = Key.of("Soft4", new String[0]);
    public static final Key APP_SWITCH = Key.of("AppSwitch", new String[0]);
    public static final Key CALL = Key.of("Call", new String[0]);
    public static final Key CAMERA = Key.of("Camera", new String[0]);
    public static final Key CAMERA_FOCUS = Key.of("CameraFocus", new String[0]);
    public static final Key END_CALL = Key.of("EndCall", new String[0]);
    public static final Key GO_BACK = Key.of("GoBack", new String[0]);
    public static final Key GO_HOME = Key.of("GoHome", new String[0]);
    public static final Key HEADSET_HOOK = Key.of("HeadsetHook", new String[0]);
    public static final Key LAST_NUMBER_REDIAL = Key.of("LastNumberRedial", new String[0]);
    public static final Key NOTIFICATION = Key.of("Notification", new String[0]);
    public static final Key MANNER_MODE = Key.of("MannerMode", new String[0]);
    public static final Key VOICE_DIAL = Key.of("VoiceDial", new String[0]);
    public static final Key CHANNEL_DOWN = Key.of("ChannelDown", new String[0]);
    public static final Key CHANNEL_UP = Key.of("ChannelUp", new String[0]);
    public static final Key MEDIA_FAST_FORWARD = Key.of("MediaFastForward", new String[0]);
    public static final Key MEDIA_PAUSE = Key.of("MediaPause", new String[0]);
    public static final Key MEDIA_PLAY = Key.of("MediaPlay", new String[0]);
    public static final Key MEDIA_PLAY_PAUSE = Key.of("MediaPlayPause", new String[0]);
    public static final Key MEDIA_RECORD = Key.of("MediaRecord", new String[0]);
    public static final Key MEDIA_REWIND = Key.of("MediaRewind", new String[0]);
    public static final Key MEDIA_STOP = Key.of("MediaStop", new String[0]);
    public static final Key MEDIA_TRACK_NEXT = Key.of("MediaTrackNext", new String[0]);
    public static final Key MEDIA_TRACK_PREVIOUS = Key.of("MediaTrackPrevious", new String[0]);
    public static final Key AUDIO_BALANCE_LEFT = Key.of("AudioBalanceLeft", new String[0]);
    public static final Key AUDIO_BALANCE_RIGHT = Key.of("AudioBalanceRight", new String[0]);
    public static final Key AUDIO_BASS_DOWN = Key.of("AudioBassDown", new String[0]);
    public static final Key AUDIO_BASS_BOOST_DOWN = Key.of("AudioBassBoostDown", new String[0]);
    public static final Key AUDIO_BASS_BOOST_TOGGLE = Key.of("AudioBassBoostToggle", new String[0]);
    public static final Key AUDIO_BASS_BOOST_UP = Key.of("AudioBassBoostUp", new String[0]);
    public static final Key AUDIO_BASS_UP = Key.of("AudioBassUp", new String[0]);
    public static final Key AUDIO_FADER_FRONT = Key.of("AudioFaderFront", new String[0]);
    public static final Key AUDIO_FADER_REAR = Key.of("AudioFaderRear", new String[0]);
    public static final Key AUDIO_SURROUND_MODE_NEXT = Key.of("AudioSurroundModeNext", new String[0]);
    public static final Key AUDIO_TREBLE_DOWN = Key.of("AudioTrebleDown", new String[0]);
    public static final Key AUDIO_TREBLE_UP = Key.of("AudioTrebleUp", new String[0]);
    public static final Key AUDIO_VOLUME_DOWN = Key.of("AudioVolumeDown", new String[0]);
    public static final Key AUDIO_VOLUME_MUTE = Key.of("AudioVolumeMute", new String[0]);
    public static final Key AUDIO_VOLUME_UP = Key.of("AudioVolumeUp", new String[0]);
    public static final Key MICROPHONE_TOGGLE = Key.of("MicrophoneToggle", new String[0]);
    public static final Key MICROPHONE_VOLUME_DOWN = Key.of("MicrophoneVolumeDown", new String[0]);
    public static final Key MICROPHONE_VOLUME_MUTE = Key.of("MicrophoneVolumeMute", new String[0]);
    public static final Key MICROPHONE_VOLUME_UP = Key.of("MicrophoneVolumeUp", new String[0]);
    public static final Key TV = Key.of("TV", new String[0]);
    public static final Key TV_3D_MODE = Key.of("TV3DMode", new String[0]);
    public static final Key TV_ANTENNA_CABLE = Key.of("TVAntennaCable", new String[0]);
    public static final Key TV_AUDIO_DESCRIPTION = Key.of("TVAudioDescription", new String[0]);
    public static final Key TV_AUDIO_DESCRIPTION_MIX_DOWN = Key.of("TVAudioDescriptionMixDown", new String[0]);
    public static final Key TV_AUDIO_DESCRIPTION_MIX_UP = Key.of("TVAudioDescriptionMixUp", new String[0]);
    public static final Key TV_CONTENTS_MENU = Key.of("TVContentsMenu", new String[0]);
    public static final Key TV_DATA_SERVICE = Key.of("TVDataService", new String[0]);
    public static final Key TV_INPUT = Key.of("TVInput", new String[0]);
    public static final Key TV_INPUT_COMPONENT1 = Key.of("TVInputComponent1", new String[0]);
    public static final Key TV_INPUT_COMPONENT2 = Key.of("TVInputComponent2", new String[0]);
    public static final Key TV_INPUT_COMPOSITE1 = Key.of("TVInputComposite1", new String[0]);
    public static final Key TV_INPUT_COMPOSITE2 = Key.of("TVInputComposite2", new String[0]);
    public static final Key TV_INPUT_HDMI1 = Key.of("TVInputHDMI1", new String[0]);
    public static final Key TV_INPUT_HDMI2 = Key.of("TVInputHDMI2", new String[0]);
    public static final Key TV_INPUT_HDMI3 = Key.of("TVInputHDMI3", new String[0]);
    public static final Key TV_INPUT_HDMI4 = Key.of("TVInputHDMI4", new String[0]);
    public static final Key TV_INPUT_VGA1 = Key.of("TVInputVGA1", new String[0]);
    public static final Key TV_MEDIA_CONTEXT = Key.of("TVMediaContext", new String[0]);
    public static final Key TV_NETWORK = Key.of("TVNetwork", new String[0]);
    public static final Key TV_NUMBER_ENTRY = Key.of("TVNumberEntry", new String[0]);
    public static final Key TV_POWER = Key.of("TVPower", new String[0]);
    public static final Key TV_RADIO_SERVICE = Key.of("TVRadioService", new String[0]);
    public static final Key TV_SATELLITE = Key.of("TVSatellite", new String[0]);
    public static final Key TV_SATELLITE_BS = Key.of("TVSatelliteBS", new String[0]);
    public static final Key TV_SATELLITE_CS = Key.of("TVSatelliteCS", new String[0]);
    public static final Key TV_SATELLITE_TOGGLE = Key.of("TVSatelliteToggle", new String[0]);
    public static final Key TV_TERRESTRIAL_ANALOG = Key.of("TVTerrestrialAnalog", new String[0]);
    public static final Key TV_TERRESTRIAL_DIGITAL = Key.of("TVTerrestrialDigital", new String[0]);
    public static final Key TV_TIMER = Key.of("TVTimer", new String[0]);
    public static final Key AVR_INPUT = Key.of("AVRInput", new String[0]);
    public static final Key AVR_POWER = Key.of("AVRPower", new String[0]);
    public static final Key COLOR_F0_RED = Key.of("ColorF0Red", new String[0]);
    public static final Key COLOR_F1_GREEN = Key.of("ColorF1Green", new String[0]);
    public static final Key COLOR_F2_YELLOW = Key.of("ColorF2Yellow", new String[0]);
    public static final Key COLOR_F3_BLUE = Key.of("ColorF3Blue", new String[0]);
    public static final Key COLOR_F4_GREY = Key.of("ColorF4Grey", new String[0]);
    public static final Key COLOR_F5_BROWN = Key.of("ColorF5Brown", new String[0]);
    public static final Key CLOSED_CAPTION_TOGGLE = Key.of("ClosedCaptionToggle", new String[0]);
    public static final Key DIMMER = Key.of("Dimmer", new String[0]);
    public static final Key DISPLAY_SWAP = Key.of("DisplaySwap", new String[0]);
    public static final Key DVR = Key.of("DVR", new String[0]);
    public static final Key EXIT = Key.of("Exit", new String[0]);
    public static final Key FAVORITE_CLEAR0 = Key.of("FavoriteClear0", new String[0]);
    public static final Key FAVORITE_CLEAR1 = Key.of("FavoriteClear1", new String[0]);
    public static final Key FAVORITE_CLEAR2 = Key.of("FavoriteClear2", new String[0]);
    public static final Key FAVORITE_CLEAR3 = Key.of("FavoriteClear3", new String[0]);
    public static final Key FAVORITE_RECALL0 = Key.of("FavoriteRecall0", new String[0]);
    public static final Key FAVORITE_RECALL1 = Key.of("FavoriteRecall1", new String[0]);
    public static final Key FAVORITE_RECALL2 = Key.of("FavoriteRecall2", new String[0]);
    public static final Key FAVORITE_RECALL3 = Key.of("FavoriteRecall3", new String[0]);
    public static final Key FAVORITE_STORE0 = Key.of("FavoriteStore0", new String[0]);
    public static final Key FAVORITE_STORE1 = Key.of("FavoriteStore1", new String[0]);
    public static final Key FAVORITE_STORE2 = Key.of("FavoriteStore2", new String[0]);
    public static final Key FAVORITE_STORE3 = Key.of("FavoriteStore3", new String[0]);
    public static final Key GUIDE = Key.of("Guide", new String[0]);
    public static final Key GUIDE_NEXT_DAY = Key.of("GuideNextDay", new String[0]);
    public static final Key GUIDE_PREVIOUS_DAY = Key.of("GuidePreviousDay", new String[0]);
    public static final Key INFO = Key.of("Info", new String[0]);
    public static final Key INSTANT_REPLAY = Key.of("InstantReplay", new String[0]);
    public static final Key LINK = Key.of("Link", new String[0]);
    public static final Key LIST_PROGRAM = Key.of("ListProgram", new String[0]);
    public static final Key LIVE_CONTENT = Key.of("LiveContent", new String[0]);
    public static final Key LOCK = Key.of("Lock", new String[0]);
    public static final Key MEDIA_APPS = Key.of("MediaApps", new String[0]);
    public static final Key MEDIA_AUDIO_TRACK = Key.of("MediaAudioTrack", new String[0]);
    public static final Key MEDIA_LAST = Key.of("MediaLast", new String[0]);
    public static final Key MEDIA_SKIP_BACKWARD = Key.of("MediaSkipBackward", new String[0]);
    public static final Key MEDIA_SKIP_FORWARD = Key.of("MediaSkipForward", new String[0]);
    public static final Key MEDIA_STEP_BACKWARD = Key.of("MediaStepBackward", new String[0]);
    public static final Key MEDIA_STEP_FORWARD = Key.of("MediaStepForward", new String[0]);
    public static final Key MEDIA_TOP_MENU = Key.of("MediaTopMenu", new String[0]);
    public static final Key NAVIGATE_IN = Key.of("NavigateIn", new String[0]);
    public static final Key NAVIGATE_NEXT = Key.of("NavigateNext", new String[0]);
    public static final Key NAVIGATE_OUT = Key.of("NavigateOut", new String[0]);
    public static final Key NAVIGATE_PREVIOUS = Key.of("NavigatePrevious", new String[0]);
    public static final Key NEXT_FAVORITE_CHANNEL = Key.of("NextFavoriteChannel", new String[0]);
    public static final Key NEXT_USER_PROFILE = Key.of("NextUserProfile", new String[0]);
    public static final Key ON_DEMAND = Key.of("OnDemand", new String[0]);
    public static final Key PAIRING = Key.of("Pairing", new String[0]);
    public static final Key PINP_DOWN = Key.of("PinPDown", new String[0]);
    public static final Key PINP_MOVE = Key.of("PinPMove", new String[0]);
    public static final Key PINP_TOGGLE = Key.of("PinPToggle", new String[0]);
    public static final Key PINP_UP = Key.of("PinPUp", new String[0]);
    public static final Key PLAY_SPEED_DOWN = Key.of("PlaySpeedDown", new String[0]);
    public static final Key PLAY_SPEED_RESET = Key.of("PlaySpeedReset", new String[0]);
    public static final Key PLAY_SPEED_UP = Key.of("PlaySpeedUp", new String[0]);
    public static final Key RANDOM_TOGGLE = Key.of("RandomToggle", new String[0]);
    public static final Key RC_LOW_BATTERY = Key.of("RcLowBattery", new String[0]);
    public static final Key RECORD_SPEED_NEXT = Key.of("RecordSpeedNext", new String[0]);
    public static final Key RF_BYPASS = Key.of("RfBypass", new String[0]);
    public static final Key SCAN_CHANNELS_TOGGLE = Key.of("ScanChannelsToggle", new String[0]);
    public static final Key SCREEN_MODE_NEXT = Key.of("ScreenModeNext", new String[0]);
    public static final Key SETTINGS = Key.of("Settings", new String[0]);
    public static final Key SPLIT_SCREEN_TOGGLE = Key.of("SplitScreenToggle", new String[0]);
    public static final Key STB_INPUT = Key.of("STBInput", new String[0]);
    public static final Key STB_POWER = Key.of("STBPower", new String[0]);
    public static final Key SUBTITLE = Key.of("Subtitle", new String[0]);
    public static final Key TELETEXT = Key.of("Teletext", new String[0]);
    public static final Key VIDEO_MODE_NEXT = Key.of("VideoModeNext", new String[0]);
    public static final Key WINK = Key.of("Wink", new String[0]);
    public static final Key ZOOM_TOGGLE = Key.of("ZoomToggle", new String[0]);
    public static final Key SPEECH_CORRECTION_LIST = Key.of("SpeechCorrectionList", new String[0]);
    public static final Key SPEECH_INPUT_TOGGLE = Key.of("SpeechInputToggle", new String[0]);
    public static final Key CLOSE = Key.of("Close", new String[0]);
    public static final Key NEW = Key.of("New", new String[0]);
    public static final Key OPEN = Key.of("Open", new String[0]);
    public static final Key PRINT = Key.of("Print", new String[0]);
    public static final Key SAVE = Key.of("Save", new String[0]);
    public static final Key SPELL_CHECK = Key.of("SpellCheck", new String[0]);
    public static final Key MAIL_FORWARD = Key.of("MailForward", new String[0]);
    public static final Key MAIL_REPLY = Key.of("MailReply", new String[0]);
    public static final Key MAIL_SEND = Key.of("MailSend", new String[0]);
    public static final Key LAUNCH_CALCULATOR = Key.of("LaunchCalculator", new String[0]);
    public static final Key LAUNCH_CALENDAR = Key.of("LaunchCalendar", new String[0]);
    public static final Key LAUNCH_CONTACTS = Key.of("LaunchContacts", new String[0]);
    public static final Key LAUNCH_MAIL = Key.of("LaunchMail", new String[0]);
    public static final Key LAUNCH_MEDIA_PLAYER = Key.of("LaunchMediaPlayer", new String[0]);
    public static final Key LAUNCH_MUSIC_PLAYER = Key.of("LaunchMusicPlayer", new String[0]);
    public static final Key LAUNCH_MY_COMPUTER = Key.of("LaunchMyComputer", new String[0]);
    public static final Key LAUNCH_PHONE = Key.of("LaunchPhone", new String[0]);
    public static final Key LAUNCH_SCREEN_SAVER = Key.of("LaunchScreenSaver", new String[0]);
    public static final Key LAUNCH_SPREADSHEET = Key.of("LaunchSpreadsheet", new String[0]);
    public static final Key LAUNCH_WEB_BROWSER = Key.of("LaunchWebBrowser", new String[0]);
    public static final Key LAUNCH_WEB_CAM = Key.of("LaunchWebCam", new String[0]);
    public static final Key LAUNCH_WORD_PROCESSOR = Key.of("LaunchWordProcessor", new String[0]);
    public static final Key LAUNCH_APPLICATION1 = Key.of("LaunchApplication1", new String[0]);
    public static final Key LAUNCH_APPLICATION2 = Key.of("LaunchApplication2", new String[0]);
    public static final Key LAUNCH_APPLICATION3 = Key.of("LaunchApplication3", new String[0]);
    public static final Key LAUNCH_APPLICATION4 = Key.of("LaunchApplication4", new String[0]);
    public static final Key LAUNCH_APPLICATION5 = Key.of("LaunchApplication5", new String[0]);
    public static final Key LAUNCH_APPLICATION6 = Key.of("LaunchApplication6", new String[0]);
    public static final Key LAUNCH_APPLICATION7 = Key.of("LaunchApplication7", new String[0]);
    public static final Key LAUNCH_APPLICATION8 = Key.of("LaunchApplication8", new String[0]);
    public static final Key LAUNCH_APPLICATION9 = Key.of("LaunchApplication9", new String[0]);
    public static final Key LAUNCH_APPLICATION10 = Key.of("LaunchApplication10", new String[0]);
    public static final Key LAUNCH_APPLICATION11 = Key.of("LaunchApplication11", new String[0]);
    public static final Key LAUNCH_APPLICATION12 = Key.of("LaunchApplication12", new String[0]);
    public static final Key LAUNCH_APPLICATION13 = Key.of("LaunchApplication13", new String[0]);
    public static final Key LAUNCH_APPLICATION14 = Key.of("LaunchApplication14", new String[0]);
    public static final Key LAUNCH_APPLICATION15 = Key.of("LaunchApplication15", new String[0]);
    public static final Key LAUNCH_APPLICATION16 = Key.of("LaunchApplication16", new String[0]);
    public static final Key BROWSER_BACK = Key.of("BrowserBack", new String[0]);
    public static final Key BROWSER_FAVORITES = Key.of("BrowserFavorites", new String[0]);
    public static final Key BROWSER_FORWARD = Key.of("BrowserForward", new String[0]);
    public static final Key BROWSER_HOME = Key.of("BrowserHome", new String[0]);
    public static final Key BROWSER_REFRESH = Key.of("BrowserRefresh", new String[0]);
    public static final Key BROWSER_SEARCH = Key.of("BrowserSearch", new String[0]);
    public static final Key BROWSER_STOP = Key.of("BrowserStop", new String[0]);
    public static final Key DECIMAL = Key.of("Decimal", new String[0]);
    public static final Key KEY11 = Key.of("Key11", new String[0]);
    public static final Key KEY12 = Key.of("Key12", new String[0]);
    public static final Key MULTIPLY = Key.of("Multiply", new String[0]);
    public static final Key ADD = Key.of("Add", new String[0]);
    public static final Key DIVIDE = Key.of("Divide", new String[0]);
    public static final Key SUBTRACT = Key.of("Subtract", new String[0]);
    public static final Key SEPARATOR = Key.of("Separator", new String[0]);
    public static final Key BACKQUOTE = Key.of("Backquote", new String[0]);
    public static final Key BACKSLASH = Key.of("Backslash", new String[0]);
    public static final Key BRACKET_LEFT = Key.of("BracketLeft", new String[0]);
    public static final Key BRACKET_RIGHT = Key.of("BracketRight", new String[0]);
    public static final Key COMMA = Key.of("Comma", new String[0]);
    public static final Key DIGIT_0 = Key.of("Digit0", new String[0]);
    public static final Key DIGIT_1 = Key.of("Digit1", new String[0]);
    public static final Key DIGIT_2 = Key.of("Digit2", new String[0]);
    public static final Key DIGIT_3 = Key.of("Digit3", new String[0]);
    public static final Key DIGIT_4 = Key.of("Digit4", new String[0]);
    public static final Key DIGIT_5 = Key.of("Digit5", new String[0]);
    public static final Key DIGIT_6 = Key.of("Digit6", new String[0]);
    public static final Key DIGIT_7 = Key.of("Digit7", new String[0]);
    public static final Key DIGIT_8 = Key.of("Digit8", new String[0]);
    public static final Key DIGIT_9 = Key.of("Digit9", new String[0]);
    public static final Key EQUAL = Key.of("Equal", new String[0]);
    public static final Key INTL_BACKSLASH = Key.of("IntlBackslash", new String[0]);
    public static final Key INTL_RO = Key.of("IntlRo", new String[0]);
    public static final Key INTL_YEN = Key.of("IntlYen", new String[0]);
    public static final Key KEY_A = Key.of("KeyA", new String[0]);
    public static final Key KEY_B = Key.of("KeyB", new String[0]);
    public static final Key KEY_C = Key.of("KeyC", new String[0]);
    public static final Key KEY_D = Key.of("KeyD", new String[0]);
    public static final Key KEY_E = Key.of("KeyE", new String[0]);
    public static final Key KEY_F = Key.of("KeyF", new String[0]);
    public static final Key KEY_G = Key.of("KeyG", new String[0]);
    public static final Key KEY_H = Key.of("KeyH", new String[0]);
    public static final Key KEY_I = Key.of("KeyI", new String[0]);
    public static final Key KEY_J = Key.of("KeyJ", new String[0]);
    public static final Key KEY_K = Key.of("KeyK", new String[0]);
    public static final Key KEY_L = Key.of("KeyL", new String[0]);
    public static final Key KEY_M = Key.of("KeyM", new String[0]);
    public static final Key KEY_N = Key.of("KeyN", new String[0]);
    public static final Key KEY_O = Key.of("KeyO", new String[0]);
    public static final Key KEY_P = Key.of("KeyP", new String[0]);
    public static final Key KEY_Q = Key.of("KeyQ", new String[0]);
    public static final Key KEY_R = Key.of("KeyR", new String[0]);
    public static final Key KEY_S = Key.of("KeyS", new String[0]);
    public static final Key KEY_T = Key.of("KeyT", new String[0]);
    public static final Key KEY_U = Key.of("KeyU", new String[0]);
    public static final Key KEY_V = Key.of("KeyV", new String[0]);
    public static final Key KEY_W = Key.of("KeyW", new String[0]);
    public static final Key KEY_X = Key.of("KeyX", new String[0]);
    public static final Key KEY_Y = Key.of("KeyY", new String[0]);
    public static final Key KEY_Z = Key.of("KeyZ", new String[0]);
    public static final Key MINUS = Key.of("Minus", new String[0]);
    public static final Key PERIOD = Key.of("Period", new String[0]);
    public static final Key QUOTE = Key.of("Quote", new String[0]);
    public static final Key SEMICOLON = Key.of("Semicolon", new String[0]);
    public static final Key SLASH = Key.of("Slash", new String[0]);
    public static final Key ALT_LEFT = Key.of("AltLeft", new String[0]);
    public static final Key ALT_RIGHT = Key.of("AltRight", new String[0]);
    public static final Key CONTROL_LEFT = Key.of("ControlLeft", new String[0]);
    public static final Key CONTROL_RIGHT = Key.of("ControlRight", new String[0]);
    public static final Key META_LEFT = Key.of("MetaLeft", new String[0]);
    public static final Key META_RIGHT = Key.of("MetaRight", new String[0]);
    public static final Key SHIFT_LEFT = Key.of("ShiftLeft", new String[0]);
    public static final Key SHIFT_RIGHT = Key.of("ShiftRight", new String[0]);
    public static final Key LANG_1 = Key.of("Lang1", new String[0]);
    public static final Key LANG_2 = Key.of("Lang2", new String[0]);
    public static final Key LANG_3 = Key.of("Lang3", new String[0]);
    public static final Key LANG_4 = Key.of("Lang4", new String[0]);
    public static final Key LANG_5 = Key.of("Lang5", new String[0]);
    public static final Key NUMPAD_0 = Key.of("Numpad0", new String[0]);
    public static final Key NUMPAD_1 = Key.of("Numpad1", new String[0]);
    public static final Key NUMPAD_2 = Key.of("Numpad2", new String[0]);
    public static final Key NUMPAD_3 = Key.of("Numpad3", new String[0]);
    public static final Key NUMPAD_4 = Key.of("Numpad4", new String[0]);
    public static final Key NUMPAD_5 = Key.of("Numpad5", new String[0]);
    public static final Key NUMPAD_6 = Key.of("Numpad6", new String[0]);
    public static final Key NUMPAD_7 = Key.of("Numpad7", new String[0]);
    public static final Key NUMPAD_8 = Key.of("Numpad8", new String[0]);
    public static final Key NUMPAD_9 = Key.of("Numpad9", new String[0]);
    public static final Key NUMPAD_ADD = Key.of("NumpadAdd", new String[0]);
    public static final Key NUMPAD_BACKSPACE = Key.of("NumpadBackspace", new String[0]);
    public static final Key NUMPAD_CLEAR = Key.of("NumpadClear", new String[0]);
    public static final Key NUMPAD_CLEAR_ENTRY = Key.of("NumpadClearEntry", new String[0]);
    public static final Key NUMPAD_COMMA = Key.of("NumpadComma", new String[0]);
    public static final Key NUMPAD_DECIMAL = Key.of("NumpadDecimal", new String[0]);
    public static final Key NUMPAD_DIVIDE = Key.of("NumpadDivide", new String[0]);
    public static final Key NUMPAD_ENTER = Key.of("NumpadEnter", new String[0]);
    public static final Key NUMPAD_EQUAL = Key.of("NumpadEqual", new String[0]);
    public static final Key NUMPAD_HASH = Key.of("NumpadHash", new String[0]);
    public static final Key NUMPAD_MEMORY_ADD = Key.of("NumpadMemoryAdd", new String[0]);
    public static final Key NUMPAD_MEMORY_CLEAR = Key.of("NumpadMemoryClear", new String[0]);
    public static final Key NUMPAD_MEMORY_RECALL = Key.of("NumpadMemoryRecall", new String[0]);
    public static final Key NUMPAD_MEMORY_STORE = Key.of("NumpadMemoryStore", new String[0]);
    public static final Key NUMPAD_MEMORY_SUBTRACT = Key.of("NumpadMemorySubtract", new String[0]);
    public static final Key NUMPAD_MULTIPLY = Key.of("NumpadMultiply", new String[0]);
    public static final Key NUMPAD_PAREN_LEFT = Key.of("NumpadParenLeft", new String[0]);
    public static final Key NUMPAD_PAREN_RIGHT = Key.of("NumpadParenRight", new String[0]);
    public static final Key NUMPAD_STAR = Key.of("NumpadStar", new String[0]);
    public static final Key NUMPAD_SUBTRACT = Key.of("NumpadSubtract", new String[0]);
    public static final Key LAUNCH_APP_1 = Key.of("LaunchApp1", new String[0]);
    public static final Key LAUNCH_APP_2 = Key.of("LaunchApp2", new String[0]);
    public static final Key MEDIA_SELECT = Key.of("MediaSelect", new String[0]);
    public static final Key SLEEP = Key.of("Sleep", new String[0]);
    public static final Key TURBO = Key.of("Turbo", new String[0]);
    public static final Key ABORT = Key.of("Abort", new String[0]);
    public static final Key RESUME = Key.of("Resume", new String[0]);
    public static final Key SUSPEND = Key.of("Suspend", new String[0]);

    public static Key of(String key, String ... additionalKeys) {
        Objects.requireNonNull(key);
        if ("".equals(key)) {
            throw new IllegalArgumentException("'key' cannot be empty");
        }
        final ArrayList<String> keys = new ArrayList<String>(additionalKeys.length + 1);
        keys.add(key);
        Collections.addAll(keys, additionalKeys);
        return new Key(){

            @Override
            public List<String> getKeys() {
                return Collections.unmodifiableList(keys);
            }

            public String toString() {
                List<String> keys2 = this.getKeys();
                if (keys2.size() == 1) {
                    return keys2.get(0);
                }
                return keys2.get(0) + ",  additional keys : [" + keys2.stream().skip(1L).collect(Collectors.joining(", ")) + "]";
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj == this) {
                    return true;
                }
                if (!obj.getClass().equals(this.getClass())) {
                    return false;
                }
                return this.getKeys().equals(((Key)obj).getKeys());
            }

            public int hashCode() {
                return Objects.hash(this.getKeys());
            }
        };
    }

    public List<String> getKeys();

    default public boolean matches(String key) {
        return this.getKeys().contains(key);
    }

    public static boolean isModifier(Key key) {
        return Stream.of(KeyModifier.values()).anyMatch(k -> k.matches(key.getKeys().get(0)));
    }
}

