/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.Platform;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendToolsSettings;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.FrontendVersion;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.TaskGeneratePackageJson;
import com.vaadin.flow.shared.util.SharedUtil;
import elemental.json.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class TaskRunNpmInstall
implements FallibleCommand {
    private static final String MODULES_YAML = ".modules.yaml";
    private static final String NPM_VALIDATION_FAIL_MESSAGE = "%n%n======================================================================================================%nThe path to npm cache contains whitespaces, and the currently installed npm version doesn't accept this.%nMost likely your Windows user home path contains whitespaces.%nTo workaround it, please change the npm cache path by using the following command:%n    npm config set cache [path-to-npm-cache] --global%n(you may also want to exclude the whitespaces with 'dir /x' to use the same dir),%nor upgrade the npm version to 7 (or newer) by:%n 1) Running 'npm-windows-upgrade' tool with Windows PowerShell:%n        Set-ExecutionPolicy Unrestricted -Scope CurrentUser -Force%n        npm install -g npm-windows-upgrade%n        npm-windows-upgrade%n 2) Manually installing a newer version of npx: npm install -g npx%n 3) Manually installing a newer version of pnpm: npm install -g pnpm%n 4) Deleting the following files from your Vaadin project's folder (if present):%n        node_modules, package-lock.json, webpack.generated.js, pnpm-lock.yaml, pnpmfile.js%n======================================================================================================%n";
    private static Stats lastInstallStats = new Stats();
    private final NodeUpdater packageUpdater;
    private final List<String> ignoredNodeFolders = Arrays.asList(".bin", "pnpm", ".ignored_pnpm", ".pnpm", ".staging", ".vaadin", ".modules.yaml");
    private final boolean enablePnpm;
    private final boolean requireHomeNodeExec;
    private final boolean autoUpdate;
    private final String nodeVersion;
    private final URI nodeDownloadRoot;
    private final boolean useGlobalPnpm;
    private List<String> additionalPostinstallPackages;

    TaskRunNpmInstall(NodeUpdater packageUpdater, boolean enablePnpm, boolean requireHomeNodeExec, String nodeVersion, URI nodeDownloadRoot, boolean useGlobalPnpm, boolean autoUpdate, List<String> additionalPostinstallPackages) {
        this.packageUpdater = packageUpdater;
        this.enablePnpm = enablePnpm;
        this.requireHomeNodeExec = requireHomeNodeExec;
        this.nodeVersion = Objects.requireNonNull(nodeVersion);
        this.nodeDownloadRoot = Objects.requireNonNull(nodeDownloadRoot);
        this.useGlobalPnpm = useGlobalPnpm;
        this.autoUpdate = autoUpdate;
        this.additionalPostinstallPackages = Objects.requireNonNull(additionalPostinstallPackages);
    }

    @Override
    public void execute() throws ExecutionFailedException {
        String toolName;
        String string = toolName = this.enablePnpm ? "pnpm" : "npm";
        if (this.packageUpdater.modified || this.shouldRunNpmInstall()) {
            this.packageUpdater.log().info("Running `" + toolName + " install` to resolve and optionally download frontend dependencies. This may take a moment, please stand by...");
            this.runNpmInstall();
            this.updateLocalHash();
        } else {
            this.packageUpdater.log().info("Skipping `{} install` because the frontend packages are already installed in the folder '{}' and the hash in the file '{}' is the same as in '{}'", new Object[]{toolName, this.packageUpdater.nodeModulesFolder.getAbsolutePath(), this.packageUpdater.getVaadinJsonFile().getAbsolutePath(), "package.json"});
        }
    }

    private void updateLocalHash() {
        try {
            JsonObject vaadin = this.packageUpdater.getPackageJson().getObject("vaadin");
            if (vaadin == null) {
                this.packageUpdater.log().warn("No vaadin object in package.json");
                return;
            }
            String hash = vaadin.getString("hash");
            HashMap<String, String> updates = new HashMap<String, String>();
            updates.put("hash", hash);
            Platform.getVaadinVersion().ifPresent(s -> updates.put("vaadinVersion", (String)s));
            updates.put("projectFolder", this.packageUpdater.npmFolder.getAbsolutePath());
            this.packageUpdater.updateVaadinJsonContents(updates);
        }
        catch (IOException e) {
            this.packageUpdater.log().warn("Failed to update node_modules hash.", (Throwable)e);
        }
    }

    private boolean shouldRunNpmInstall() {
        if (!this.packageUpdater.nodeModulesFolder.isDirectory()) {
            return true;
        }
        File[] installedPackages = this.packageUpdater.nodeModulesFolder.listFiles((dir, name) -> !this.ignoredNodeFolders.contains(name));
        assert (installedPackages != null);
        if (installedPackages.length == 0) {
            return true;
        }
        if (installedPackages.length == 1 && "@vaadin/flow-frontend/".startsWith(installedPackages[0].getName())) {
            return true;
        }
        return this.isVaadinHashOrProjectFolderUpdated();
    }

    boolean isVaadinHashOrProjectFolderUpdated() {
        try {
            JsonObject nodeModulesVaadinJson = this.packageUpdater.getVaadinJsonContents();
            if (nodeModulesVaadinJson.hasKey("hash")) {
                JsonObject packageJson = this.packageUpdater.getPackageJson();
                if (!nodeModulesVaadinJson.getString("hash").equals(packageJson.getObject("vaadin").getString("hash"))) {
                    return true;
                }
                return nodeModulesVaadinJson.hasKey("projectFolder") && !this.packageUpdater.npmFolder.getAbsolutePath().equals(nodeModulesVaadinJson.getString("projectFolder"));
            }
        }
        catch (IOException e) {
            this.packageUpdater.log().warn("Failed to load hashes forcing npm execution", (Throwable)e);
        }
        return true;
    }

    private void runNpmInstall() throws ExecutionFailedException {
        ArrayList<String> postinstallCommand;
        ArrayList<String> npmInstallCommand;
        this.cleanUp();
        long startTime = System.currentTimeMillis();
        Logger logger = this.packageUpdater.log();
        String baseDir = this.packageUpdater.npmFolder.getAbsolutePath();
        FrontendToolsSettings settings = new FrontendToolsSettings(baseDir, () -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath());
        settings.setNodeDownloadRoot(this.nodeDownloadRoot);
        settings.setForceAlternativeNode(this.requireHomeNodeExec);
        settings.setUseGlobalPnpm(this.useGlobalPnpm);
        settings.setAutoUpdate(this.autoUpdate);
        settings.setNodeVersion(this.nodeVersion);
        FrontendTools tools = new FrontendTools(settings);
        tools.validateNodeAndNpmVersion();
        if (this.enablePnpm) {
            try {
                this.createPnpmFile(this.packageUpdater.versionsPath, tools);
            }
            catch (IOException exception) {
                throw new ExecutionFailedException("Failed to read frontend version data from vaadin-core and make it available to pnpm for locking transitive dependencies.\nPlease report an issue, as a workaround try running project with npm by setting system variable -Dvaadin.pnpm.enable=false", exception);
            }
            try {
                this.createNpmRcFile();
            }
            catch (IOException exception) {
                logger.warn(".npmrc generation failed; pnpm package installation may require manaually passing the --shamefully-hoist flag", (Throwable)exception);
            }
        }
        try {
            List<String> npmExecutable;
            if (this.requireHomeNodeExec) {
                tools.forceAlternativeNodeExecutable();
            }
            if (this.enablePnpm) {
                this.validateInstalledNpm(tools);
                npmExecutable = tools.getPnpmExecutable();
            } else {
                npmExecutable = tools.getNpmExecutable();
            }
            npmInstallCommand = new ArrayList<String>(npmExecutable);
            postinstallCommand = new ArrayList<String>(npmExecutable);
            postinstallCommand.remove("--shamefully-hoist=true");
        }
        catch (IllegalStateException exception) {
            throw new ExecutionFailedException(exception.getMessage(), exception);
        }
        npmInstallCommand.add("--ignore-scripts");
        npmInstallCommand.add("install");
        postinstallCommand.add("run");
        postinstallCommand.add("postinstall");
        if (logger.isDebugEnabled()) {
            logger.debug(FrontendUtils.commandToString(this.packageUpdater.npmFolder.getAbsolutePath(), npmInstallCommand));
        }
        String toolName = this.enablePnpm ? "pnpm" : "npm";
        String commandString = npmInstallCommand.stream().collect(Collectors.joining(" "));
        logger.info("using '{}' for frontend package installation", (Object)String.join((CharSequence)" ", npmInstallCommand));
        File packageLockFile = this.packageUpdater.getPackageLockFile();
        if (!this.enablePnpm && !packageLockFile.exists()) {
            this.packageUpdater.log().warn("package-lock.json is missing from this project. This may cause the npm package installation to take several minutes. It is recommended to keep the package-lock.json file persistently in your project. Please stand by...");
        }
        Process process = null;
        try {
            process = this.runNpmCommand(npmInstallCommand, this.packageUpdater.npmFolder);
            logger.debug("Output of `{}`:", (Object)commandString);
            StringBuilder toolOutput = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String stdoutLine;
                while ((stdoutLine = reader.readLine()) != null) {
                    logger.debug(stdoutLine);
                    toolOutput.append(stdoutLine).append(System.lineSeparator());
                }
            }
            int errorCode = process.waitFor();
            if (errorCode != 0) {
                logger.error("Command `{}` failed:\n{}", (Object)commandString, (Object)toolOutput);
                logger.error(">>> Dependency ERROR. Check that all required dependencies are deployed in {} repositories.", (Object)toolName);
                throw new ExecutionFailedException(SharedUtil.capitalize(toolName) + " install has exited with non zero status. Some dependencies are not installed. Check " + toolName + " command output");
            }
            logger.info("Frontend dependencies resolved successfully.");
        }
        catch (IOException | InterruptedException e) {
            logger.error("Error when running `{} install`", (Object)toolName, (Object)e);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new ExecutionFailedException("Command '" + toolName + " install' failed to finish", e);
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
        ArrayList<String> postinstallPackages = new ArrayList<String>();
        postinstallPackages.add(".");
        postinstallPackages.add("esbuild");
        postinstallPackages.add("@vaadin/vaadin-usage-statistics");
        postinstallPackages.addAll(this.additionalPostinstallPackages);
        for (String postinstallPackage : postinstallPackages) {
            File packageFolder;
            block35: {
                File packageJsonFile = this.getPackageJsonForModule(postinstallPackage);
                if (packageJsonFile == null || !packageJsonFile.exists()) continue;
                packageFolder = packageJsonFile.getParentFile();
                try {
                    JsonObject packageJson = TaskGeneratePackageJson.getJsonFileContent(packageJsonFile);
                    if (!this.containsPostinstallScript(packageJson)) {
                        logger.debug("Skipping postinstall for '{}' as no postinstall script was found in the package.json", (Object)postinstallPackage);
                    }
                    break block35;
                }
                catch (IOException ioe) {
                    logger.error("Couldn't read package.json for {}. Skipping postinstall", (Throwable)ioe);
                }
                continue;
            }
            logger.debug("Running postinstall for '{}'", (Object)postinstallPackage);
            try {
                process = this.runNpmCommand(postinstallCommand, packageFolder);
                process.waitFor();
            }
            catch (IOException | InterruptedException e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new ExecutionFailedException("Error when running postinstall script for '" + postinstallPackage + "'", e);
            }
        }
        TaskRunNpmInstall.lastInstallStats.installTimeMs = System.currentTimeMillis() - startTime;
        TaskRunNpmInstall.lastInstallStats.packageManager = this.enablePnpm ? "pnpm" : "npm";
    }

    private File getPackageJsonForModule(String module) {
        if (module.trim().equals("")) {
            return null;
        }
        if (module.equals(".")) {
            return new File(this.packageUpdater.npmFolder, "package.json");
        }
        return new File(new File(this.packageUpdater.nodeModulesFolder, module), "package.json");
    }

    private boolean containsPostinstallScript(JsonObject packageJson) {
        return packageJson != null && packageJson.hasKey("scripts") && packageJson.getObject("scripts").hasKey("postinstall");
    }

    private Process runNpmCommand(List<String> command, File workingDirectory) throws IOException {
        ProcessBuilder builder = FrontendUtils.createProcessBuilder(command);
        builder.environment().put("ADBLOCK", "1");
        builder.environment().put("NO_UPDATE_NOTIFIER", "1");
        builder.directory(workingDirectory);
        builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        Process process = builder.start();
        Runtime.getRuntime().addShutdownHook(new Thread(process::destroyForcibly));
        return process;
    }

    private void createPnpmFile(String versionsPath, FrontendTools tools) throws IOException {
        if (versionsPath == null) {
            return;
        }
        String pnpmFileName = ".pnpmfile.cjs";
        List<String> pnpmExecutable = tools.getSuitablePnpm();
        pnpmExecutable.add("--version");
        try {
            FrontendVersion pnpmVersion = FrontendUtils.getVersion("pnpm", pnpmExecutable);
            if (pnpmVersion.isOlderThan(new FrontendVersion("6.0"))) {
                pnpmFileName = "pnpmfile.js";
            }
        }
        catch (FrontendUtils.UnknownVersionException e) {
            this.packageUpdater.log().error("Failed to determine pnpm version", (Throwable)e);
        }
        File pnpmFile = new File(this.packageUpdater.npmFolder.getAbsolutePath(), pnpmFileName);
        try (InputStream content = TaskRunNpmInstall.class.getResourceAsStream("/pnpmfile.js");){
            if (content == null) {
                throw new IOException("Couldn't find template pnpmfile.js in the classpath");
            }
            FileUtils.copyInputStreamToFile((InputStream)content, (File)pnpmFile);
            this.packageUpdater.log().debug("Generated pnpmfile hook file: '{}'", (Object)pnpmFile);
            FileUtils.writeLines((File)pnpmFile, this.modifyPnpmFile(pnpmFile, versionsPath));
        }
    }

    private void createNpmRcFile() throws IOException {
        boolean shouldWrite;
        File npmrcFile = new File(this.packageUpdater.npmFolder.getAbsolutePath(), ".npmrc");
        if (npmrcFile.exists()) {
            List lines = FileUtils.readLines((File)npmrcFile, (Charset)StandardCharsets.UTF_8);
            if (lines.stream().anyMatch(line -> line.contains("NOTICE: this is an auto-generated file"))) {
                shouldWrite = true;
            } else {
                if (lines.stream().noneMatch(line -> line.contains("shamefully-hoist"))) {
                    String message = "Custom .npmrc file ({}) found in project; pnpm package installation may require passing the --shamefully-hoist flag";
                    this.packageUpdater.log().info(message, (Object)npmrcFile);
                }
                shouldWrite = false;
            }
        } else {
            shouldWrite = true;
        }
        if (shouldWrite) {
            try (InputStream content = TaskRunNpmInstall.class.getResourceAsStream("/npmrc");){
                if (content == null) {
                    throw new IOException("Couldn't find template npmrc in the classpath");
                }
                FileUtils.copyInputStreamToFile((InputStream)content, (File)npmrcFile);
                this.packageUpdater.log().debug("Generated pnpm configuration: '{}'", (Object)npmrcFile);
            }
        }
    }

    private List<String> modifyPnpmFile(File generatedFile, String versionsPath) throws IOException {
        List lines = FileUtils.readLines((File)generatedFile, (Charset)StandardCharsets.UTF_8);
        int i = 0;
        for (String line : lines) {
            if (line.startsWith("const versionsFile")) {
                lines.set(i, "const versionsFile = require('path').resolve(__dirname, '" + versionsPath + "');");
            }
            ++i;
        }
        return lines;
    }

    private void cleanUp() throws ExecutionFailedException {
        File staging;
        boolean hasModulesYaml;
        if (!this.packageUpdater.nodeModulesFolder.exists()) {
            TaskRunNpmInstall.lastInstallStats.cleanupTimeMs = 0L;
            return;
        }
        long startTime = System.currentTimeMillis();
        File modulesYaml = new File(this.packageUpdater.nodeModulesFolder, MODULES_YAML);
        boolean bl = hasModulesYaml = modulesYaml.exists() && modulesYaml.isFile();
        if (!this.enablePnpm && hasModulesYaml) {
            this.deleteNodeModules(this.packageUpdater.nodeModulesFolder);
        } else if (!(!this.enablePnpm || hasModulesYaml || (staging = new File(this.packageUpdater.nodeModulesFolder, ".staging")).isDirectory() && staging.listFiles((dir, name) -> name.startsWith("pnpm-")).length != 0)) {
            this.deleteNodeModules(this.packageUpdater.nodeModulesFolder);
        }
        TaskRunNpmInstall.lastInstallStats.cleanupTimeMs = System.currentTimeMillis() - startTime;
    }

    private void deleteNodeModules(File nodeModulesFolder) throws ExecutionFailedException {
        try {
            FrontendUtils.deleteNodeModules(nodeModulesFolder);
        }
        catch (IOException exception) {
            Logger log = this.packageUpdater.log();
            log.debug("Exception removing node_modules", (Throwable)exception);
            log.error("Failed to remove '" + this.packageUpdater.nodeModulesFolder.getAbsolutePath() + "'. Please remove it manually.");
            throw new ExecutionFailedException("Exception removing node_modules. Please remove it manually.");
        }
    }

    private void validateInstalledNpm(FrontendTools tools) throws IllegalStateException {
        File npmCacheDir = null;
        try {
            npmCacheDir = tools.getNpmCacheDir();
        }
        catch (FrontendUtils.CommandExecutionException | IllegalStateException e) {
            this.packageUpdater.log().warn("Failed to get npm cache directory", (Throwable)e);
        }
        if (npmCacheDir != null && !tools.folderIsAcceptableByNpm(npmCacheDir)) {
            throw new IllegalStateException(String.format(NPM_VALIDATION_FAIL_MESSAGE, new Object[0]));
        }
    }

    public static Stats getLastInstallStats() {
        return lastInstallStats;
    }

    public static class Stats {
        private long installTimeMs = 0L;
        private long cleanupTimeMs = 0L;
        private String packageManager = "";

        private Stats() {
        }

        public long getInstallTimeMs() {
            return this.installTimeMs;
        }

        public long getCleanupTimeMs() {
            return this.cleanupTimeMs;
        }

        public String getPackageManager() {
            return this.packageManager;
        }
    }
}

