/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.FallibleCommand;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskUpdateVite
implements FallibleCommand,
Serializable {
    private File configFolder;
    private String buildFolder;

    TaskUpdateVite(File configFolder, String buildFolder) {
        this.configFolder = configFolder;
        this.buildFolder = buildFolder;
    }

    @Override
    public void execute() {
        try {
            this.createConfig();
            this.createGeneratedConfig();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void createConfig() throws IOException {
        File configFile = new File(this.configFolder, "vite.config.ts");
        if (configFile.exists()) {
            return;
        }
        URL resource = this.getClass().getClassLoader().getResource("vite.config.ts");
        String template = IOUtils.toString((URL)resource, (Charset)StandardCharsets.UTF_8);
        FileUtils.write((File)configFile, (CharSequence)template, (Charset)StandardCharsets.UTF_8);
        this.log().debug("Created vite configuration file: '{}'", (Object)configFile);
    }

    private void createGeneratedConfig() throws IOException {
        File generatedConfigFile = new File(this.configFolder, "vite.generated.ts");
        URL resource = this.getClass().getClassLoader().getResource("vite.generated.ts");
        String template = IOUtils.toString((URL)resource, (Charset)StandardCharsets.UTF_8);
        template = template.replace("#settingsImport#", "./" + this.buildFolder + "/vaadin-dev-server-settings.json").replace("#buildFolder#", "./" + this.buildFolder);
        FileUtils.write((File)generatedConfigFile, (CharSequence)template, (Charset)StandardCharsets.UTF_8);
        this.log().debug("Created vite generated configuration file: '{}'", (Object)generatedConfigFile);
    }

    private Logger log() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

