/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import java.io.Serializable;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ShortcutEvent
extends EventObject
implements Serializable {
    private Component lifecycleOwner;
    private Key key;
    private Set<KeyModifier> keyModifiers;

    public ShortcutEvent(Component source, Component lifecycleOwner, Key key, Set<KeyModifier> keyModifiers) {
        super(source);
        this.lifecycleOwner = lifecycleOwner;
        this.key = key;
        this.keyModifiers = keyModifiers == null ? Collections.emptySet() : Collections.unmodifiableSet(keyModifiers);
    }

    @Override
    public Component getSource() {
        return (Component)super.getSource();
    }

    public Component getLifecycleOwner() {
        return this.lifecycleOwner;
    }

    public Key getKey() {
        return this.key;
    }

    public Set<KeyModifier> getKeyModifiers() {
        return this.keyModifiers;
    }

    public boolean matches(Key key, KeyModifier ... keyModifiers) {
        if (key == null) {
            return false;
        }
        if (keyModifiers.length != this.keyModifiers.size()) {
            return false;
        }
        List keyStrings = Stream.of(keyModifiers).map(k -> k.getKeys().get(0)).collect(Collectors.toList());
        return key.matches(this.key.getKeys().get(0)) && this.keyModifiers.stream().allMatch(k -> keyStrings.stream().anyMatch(k::matches));
    }
}

