/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class TaskGenerateTsConfig
extends AbstractTaskClientGenerator {
    static final String TSCONFIG_JSON = "tsconfig.json";
    private final File npmFolder;
    private FeatureFlags featureFlags;

    TaskGenerateTsConfig(File npmFolder, FeatureFlags featureFlags) {
        this.npmFolder = npmFolder;
        this.featureFlags = featureFlags;
    }

    @Override
    protected String getFileContent() throws IOException {
        try (InputStream tsConfStream = this.getClass().getResourceAsStream(TSCONFIG_JSON);){
            String config = IOUtils.toString((InputStream)tsConfStream, (Charset)StandardCharsets.UTF_8);
            if (this.featureFlags.isEnabled(FeatureFlags.WEBPACK)) {
                config = config.replaceFirst("\"target\".*", "\"target\": \"es2019\",");
            }
            String string = config;
            return string;
        }
    }

    @Override
    public void execute() throws ExecutionFailedException {
        if (this.shouldGenerate()) {
            super.execute();
        } else if (this.featureFlags.isEnabled(FeatureFlags.WEBPACK)) {
            this.ensureTarget("es2019");
        } else {
            this.ensureTarget(this.getDefaultEsTargetVersion());
        }
    }

    private void ensureTarget(String esVersion) throws ExecutionFailedException {
        try {
            File projectTsconfig = new File(this.npmFolder, TSCONFIG_JSON);
            String current = FileUtils.readFileToString((File)projectTsconfig, (Charset)StandardCharsets.UTF_8);
            String currentEsVersion = this.getEsTargetVersion(current);
            if (!currentEsVersion.equals(esVersion)) {
                current = current.replace(currentEsVersion, esVersion);
                TaskGenerateTsConfig.writeIfChanged(projectTsconfig, current);
            }
        }
        catch (Exception e) {
            TaskGenerateTsConfig.log().debug("Unable to modify target version in tsconfig.json", (Throwable)e);
        }
    }

    private String getDefaultEsTargetVersion() throws ExecutionFailedException {
        try {
            String defaultTsConfig = this.getFileContent();
            return this.getEsTargetVersion(defaultTsConfig);
        }
        catch (Exception e) {
            throw new ExecutionFailedException("Error finding default es target value", e);
        }
    }

    private String getEsTargetVersion(String tsConfig) {
        String json = tsConfig.replaceAll("//.*", "");
        JsonObject parsed = Json.parse((String)json);
        return parsed.getObject("compilerOptions").getString("target");
    }

    @Override
    protected File getGeneratedFile() {
        return new File(this.npmFolder, TSCONFIG_JSON);
    }

    @Override
    protected boolean shouldGenerate() {
        return !new File(this.npmFolder, TSCONFIG_JSON).exists();
    }
}

