/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.PushConfiguration;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.UIDetachedException;
import com.vaadin.flow.internal.nodefeature.PushConfigurationMap;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.AtmospherePushConnection;
import com.vaadin.flow.server.communication.PushConnection;
import com.vaadin.flow.server.communication.PushConnectionFactory;
import com.vaadin.flow.shared.communication.PushMode;
import com.vaadin.flow.shared.ui.Transport;
import java.util.Collection;
import java.util.Objects;

class PushConfigurationImpl
implements PushConfiguration {
    private UI ui;
    private PushConnectionFactory pushConnectionFactory;

    PushConfigurationImpl(UI ui) {
        this.ui = ui;
        this.pushConnectionFactory = AtmospherePushConnection::new;
        this.getPushConfigurationMap().setTransport(Transport.WEBSOCKET_XHR);
        this.getPushConfigurationMap().setFallbackTransport(Transport.LONG_POLLING);
        this.getPushConfigurationMap().setPushMode(PushMode.DISABLED);
    }

    private PushConfigurationMap getPushConfigurationMap() {
        return this.ui.getInternals().getStateTree().getRootNode().getFeature(PushConfigurationMap.class);
    }

    @Override
    public PushMode getPushMode() {
        return this.getPushConfigurationMap().getPushMode();
    }

    @Override
    public void setPushMode(PushMode pushMode) {
        if (pushMode == null) {
            throw new IllegalArgumentException("Push mode cannot be null");
        }
        VaadinSession session = this.ui.getSession();
        if (session == null) {
            throw new UIDetachedException("Cannot set the push mode for a detached UI");
        }
        session.checkHasLock();
        if (pushMode.isEnabled() && !session.getService().ensurePushAvailable()) {
            throw new IllegalStateException("Push is not available. See previous log messages for more information.");
        }
        PushMode oldMode = this.getPushConfigurationMap().getPushMode();
        if (oldMode != pushMode) {
            this.getPushConfigurationMap().setPushMode(pushMode);
            if (!oldMode.isEnabled() && pushMode.isEnabled()) {
                this.ui.getInternals().setPushConnection((PushConnection)this.pushConnectionFactory.apply(this.ui));
            }
        }
    }

    @Override
    public Transport getTransport() {
        return this.getPushConfigurationMap().getTransport();
    }

    @Override
    public void setTransport(Transport transport) {
        this.getPushConfigurationMap().setTransport(transport);
    }

    @Override
    public Transport getFallbackTransport() {
        return this.getPushConfigurationMap().getFallbackTransport();
    }

    @Override
    public void setFallbackTransport(Transport fallbackTransport) {
        this.getPushConfigurationMap().setFallbackTransport(fallbackTransport);
    }

    @Override
    public String getParameter(String parameter) {
        return this.getPushConfigurationMap().getParameter(parameter);
    }

    @Override
    public void setParameter(String parameter, String value) {
        this.getPushConfigurationMap().setParameter(parameter, value);
    }

    @Override
    public Collection<String> getParameterNames() {
        return this.getPushConfigurationMap().getParameterNames();
    }

    @Override
    public void setPushConnectionFactory(PushConnectionFactory pushConnectionFactory) {
        this.pushConnectionFactory = Objects.requireNonNull(pushConnectionFactory, "Push connection factory must not be null");
    }
}

