/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.PushConfiguration;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.JavaScriptBootstrapUI;
import com.vaadin.flow.internal.BootstrapHandlerHelper;
import com.vaadin.flow.internal.DevModeHandler;
import com.vaadin.flow.internal.DevModeHandlerManager;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.router.InvalidLocationException;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.LocationUtil;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.BootstrapHandler;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinSession;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;

public class JavaScriptBootstrapHandler
extends BootstrapHandler {
    public JavaScriptBootstrapHandler() {
        super(context -> null);
    }

    @Override
    protected boolean canHandleRequest(VaadinRequest request) {
        return HandlerHelper.isRequestType(request, HandlerHelper.RequestType.INIT) && this.isServletRootRequest(request);
    }

    private boolean isServletRootRequest(VaadinRequest request) {
        String pathInfo = request.getPathInfo();
        return pathInfo == null || "".equals(pathInfo) || "/".equals(pathInfo);
    }

    protected String getRequestUrl(VaadinRequest request) {
        return ((VaadinServletRequest)request).getRequestURL().toString();
    }

    @Override
    protected BootstrapHandler.BootstrapContext createAndInitUI(Class<? extends UI> uiClass, VaadinRequest request, VaadinResponse response, VaadinSession session) {
        BootstrapHandler.BootstrapContext context = super.createAndInitUI(JavaScriptBootstrapUI.class, request, response, session);
        JsonObject config = context.getApplicationParameters();
        String requestURL = this.getRequestUrl(request);
        PushConfiguration pushConfiguration = context.getUI().getPushConfiguration();
        AppShellRegistry registry = AppShellRegistry.getInstance(session.getService().getContext());
        registry.modifyPushConfiguration(pushConfiguration);
        config.put("requestURL", requestURL);
        return context;
    }

    @Override
    protected void initializeUIWithRouter(BootstrapHandler.BootstrapContext context, UI ui) {
        if (context.getRequest().getParameter("serverSideRouting") != null) {
            ui.getSession().setAttribute("clientRoutingMode", Boolean.TRUE);
            ui.getInternals().getRouter().initializeUI(ui, context.getRoute());
        }
    }

    @Override
    protected BootstrapHandler.BootstrapContext createBootstrapContext(VaadinRequest request, VaadinResponse response, UI ui, Function<VaadinRequest, String> callback) {
        return new JavaScriptBootstrapContext(request, response, ui, callback);
    }

    @Override
    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        try {
            String pathAndParams = request.getParameter("location");
            if (pathAndParams == null) {
                throw new InvalidLocationException("Location parameter missing from bootstrap request to server.");
            }
            LocationUtil.parsePathToSegments(pathAndParams, false);
        }
        catch (InvalidLocationException invalidLocationException) {
            response.sendError(400, "Invalid location: " + invalidLocationException.getMessage());
            return true;
        }
        HandlerHelper.setResponseNoCacheHeaders(response::setHeader, response::setDateHeader);
        this.writeResponse(response, this.getInitialJson(request, response, session));
        return true;
    }

    protected static String getServiceUrl(VaadinRequest vaadinRequest) {
        return BootstrapHandlerHelper.getServiceUrl(vaadinRequest);
    }

    private JsonObject getStats() {
        JsonObject stats = Json.createObject();
        UsageStatistics.getEntries().forEach(entry -> {
            String name = entry.getName();
            String version = entry.getVersion();
            JsonObject json = Json.createObject();
            json.put("is", name);
            json.put("version", version);
            String escapedName = Json.create((String)name).toJson();
            stats.put(escapedName, (JsonValue)json);
        });
        return stats;
    }

    private JsonValue getErrors(VaadinService service) {
        String errorMsg;
        JsonObject errors = Json.createObject();
        Optional<DevModeHandler> devModeHandler = DevModeHandlerManager.getDevModeHandler(service);
        if (devModeHandler.isPresent() && (errorMsg = devModeHandler.get().getFailedOutput()) != null) {
            errors.put("webpack-dev-server", errorMsg);
        }
        return errors.keys().length > 0 ? errors : Json.createNull();
    }

    private void writeResponse(VaadinResponse response, JsonObject json) throws IOException {
        response.setContentType("application/json");
        response.setStatus(200);
        response.getOutputStream().write(JsonUtil.stringify((JsonValue)json).getBytes("UTF-8"));
    }

    protected JsonObject getInitialJson(VaadinRequest request, VaadinResponse response, VaadinSession session) {
        BootstrapHandler.BootstrapContext context = this.createAndInitUI(JavaScriptBootstrapUI.class, request, response, session);
        JsonObject initial = Json.createObject();
        boolean productionMode = context.getSession().getConfiguration().isProductionMode();
        JsonObject appConfig = context.getApplicationParameters();
        appConfig.put("productionMode", (JsonValue)Json.create((boolean)productionMode));
        appConfig.put("appId", context.getAppId());
        appConfig.put("uidl", (JsonValue)JavaScriptBootstrapHandler.getInitialUidl(context.getUI()));
        initial.put("appConfig", (JsonValue)appConfig);
        if (context.getPushMode().isEnabled()) {
            initial.put("pushScript", JavaScriptBootstrapHandler.getPushScript(context));
        }
        if (!session.getConfiguration().isProductionMode()) {
            initial.put("stats", (JsonValue)this.getStats());
        }
        initial.put("errors", this.getErrors(request.getService()));
        return initial;
    }

    public static class JavaScriptBootstrapContext
    extends BootstrapHandler.BootstrapContext {
        public JavaScriptBootstrapContext(VaadinRequest request, VaadinResponse response, UI ui, Function<VaadinRequest, String> callback) {
            super(request, response, ui.getInternals().getSession(), ui, callback, JavaScriptBootstrapContext::initRoute);
        }

        private static Location initRoute(VaadinRequest request) {
            String path = request.getParameter("location");
            String params = request.getParameter("query");
            if (path != null) {
                return new Location(path, QueryParameters.fromString(params));
            }
            if (request instanceof VaadinServletRequest) {
                return new Location(request.getPathInfo(), QueryParameters.fromString(((VaadinServletRequest)request).getQueryString()));
            }
            return new Location(request.getPathInfo(), QueryParameters.empty());
        }
    }
}

