/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.Pair;
import com.vaadin.flow.server.frontend.FrontendToolsLocator;
import com.vaadin.flow.server.frontend.FrontendToolsSettings;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.FrontendVersion;
import com.vaadin.flow.server.frontend.installer.InstallationException;
import com.vaadin.flow.server.frontend.installer.NodeInstaller;
import com.vaadin.flow.server.frontend.installer.Platform;
import com.vaadin.flow.server.frontend.installer.ProxyConfig;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontendTools {
    public static final String DEFAULT_NODE_VERSION = "v18.20.0";
    public static final String DEFAULT_NPM_VERSION = "10.5.0";
    public static final String DEFAULT_PNPM_VERSION = "8.6.11";
    public static final String INSTALL_NODE_LOCALLY = "%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.10.0:install-node-and-npm -DnodeVersion=\"v18.20.0\" ";
    public static final String NPM_BIN_PATH = FrontendUtils.isWindows() ? "node/node_modules/npm/bin/" : "node/lib/node_modules/npm/bin/";
    private static final String NPM_BIN_LINUX_LEGACY_PATH = "node/node_modules/npm/bin/";
    private static final String MSG_PREFIX = "%n%n======================================================================================================";
    private static final String MSG_SUFFIX = "%n======================================================================================================%n";
    private static final String PNPM_NOT_FOUND = "%n%n======================================================================================================%nVaadin is configured to use a globally installed pnpm ('pnpm.global=true'), but pnpm was not found on your system.%nInstall pnpm by following the instruction at https://pnpm.io/installation %nor exclude 'pnpm.global' from the configuration or set it to false.%n======================================================================================================%n";
    private static final String LOCAL_NODE_NOT_FOUND = "%n%n======================================================================================================%nVaadin requires Node.js and npm to be installed. The %s directory already contains 'node' but it's either not a file or not a 'node' executable. Please check the %s directory and clean it up: remove '%s'.%n then run the application or Maven goal again.%n======================================================================================================%n";
    private static final String BAD_VERSION = "%n%n======================================================================================================%nYour installed '%s' version (%s) is known to have problems.%nPlease update to a new one either:%n  - by following the https://nodejs.org/en/download/ guide to install it globally%s%n  - or by running the frontend-maven-plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.10.0:install-node-and-npm -DnodeVersion=\"v18.20.0\" %n%nYou can disable the version check using -D%s=true%n======================================================================================================%n";
    private static final FrontendVersion WHITESPACE_ACCEPTING_NPM_VERSION = new FrontendVersion(7, 0);
    private static final int SUPPORTED_NODE_MAJOR_VERSION = 16;
    private static final int SUPPORTED_NODE_MINOR_VERSION = 14;
    private static final int SUPPORTED_NPM_MAJOR_VERSION = 8;
    private static final int SUPPORTED_NPM_MINOR_VERSION = 3;
    static final FrontendVersion SUPPORTED_NODE_VERSION = new FrontendVersion(16, 14);
    private static final FrontendVersion SUPPORTED_NPM_VERSION = new FrontendVersion(8, 3);
    static final String NPMRC_NOPROXY_PROPERTY_KEY = "noproxy";
    static final String NPMRC_HTTPS_PROXY_PROPERTY_KEY = "https-proxy";
    static final String NPMRC_PROXY_PROPERTY_KEY = "proxy";
    static final String SYSTEM_NOPROXY_PROPERTY_KEY = "NOPROXY";
    static final String SYSTEM_HTTPS_PROXY_PROPERTY_KEY = "HTTPS_PROXY";
    static final String SYSTEM_HTTP_PROXY_PROPERTY_KEY = "HTTP_PROXY";
    private static final int SUPPORTED_PNPM_MAJOR_VERSION = 5;
    private static final int SUPPORTED_PNPM_MINOR_VERSION = 0;
    private static final FrontendVersion SUPPORTED_PNPM_VERSION = new FrontendVersion(5, 0);
    private final String baseDir;
    private final Supplier<String> alternativeDirGetter;
    private final FrontendToolsLocator frontendToolsLocator = new FrontendToolsLocator();
    private final String nodeVersion;
    private final URI nodeDownloadRoot;
    private final boolean ignoreVersionChecks;
    private boolean forceAlternativeNode;
    private final boolean useGlobalPnpm;
    private final boolean autoUpdate;

    public FrontendTools(FrontendToolsSettings settings) {
        this.baseDir = Objects.requireNonNull(settings.getBaseDir());
        this.alternativeDirGetter = settings.getAlternativeDirGetter();
        this.nodeVersion = Objects.requireNonNull(settings.getNodeVersion());
        this.nodeDownloadRoot = Objects.requireNonNull(settings.getNodeDownloadRoot());
        this.ignoreVersionChecks = settings.isIgnoreVersionChecks();
        this.forceAlternativeNode = settings.isForceAlternativeNode();
        this.useGlobalPnpm = settings.isUseGlobalPnpm();
        this.autoUpdate = settings.isAutoUpdate();
    }

    public FrontendTools(ApplicationConfiguration applicationConfiguration, File projectRoot) {
        this(FrontendTools.createSettings(applicationConfiguration, projectRoot));
    }

    @Deprecated
    public FrontendTools(String baseDir, Supplier<String> alternativeDirGetter) {
        this(baseDir, alternativeDirGetter, DEFAULT_NODE_VERSION, URI.create(Platform.guess().getNodeDownloadRoot()), false, false);
    }

    @Deprecated
    public FrontendTools(String baseDir, Supplier<String> alternativeDirGetter, boolean forceAlternativeNode) {
        this(baseDir, alternativeDirGetter, DEFAULT_NODE_VERSION, URI.create(Platform.guess().getNodeDownloadRoot()), forceAlternativeNode, false);
    }

    @Deprecated
    public FrontendTools(String baseDir, Supplier<String> alternativeDirGetter, String nodeVersion, URI nodeDownloadRoot) {
        this(baseDir, alternativeDirGetter, nodeVersion, nodeDownloadRoot, false, false);
    }

    @Deprecated
    public FrontendTools(String baseDir, Supplier<String> alternativeDirGetter, String nodeVersion, URI nodeDownloadRoot, boolean forceAlternativeNode, boolean useGlobalPnpm) {
        this(baseDir, alternativeDirGetter, nodeVersion, nodeDownloadRoot, forceAlternativeNode, useGlobalPnpm, false);
    }

    @Deprecated
    public FrontendTools(String baseDir, Supplier<String> alternativeDirGetter, String nodeVersion, URI nodeDownloadRoot, boolean forceAlternativeNode, boolean useGlobalPnpm, boolean autoUpdate) {
        this(baseDir, alternativeDirGetter, nodeVersion, nodeDownloadRoot, "true".equalsIgnoreCase(System.getProperty("vaadin.ignoreVersionChecks")), forceAlternativeNode, useGlobalPnpm, autoUpdate);
    }

    FrontendTools(String baseDir, Supplier<String> alternativeDirGetter, String nodeVersion, URI nodeDownloadRoot, boolean ignoreVersionChecks, boolean forceAlternativeNode, boolean useGlobalPnpm, boolean autoUpdate) {
        this.baseDir = Objects.requireNonNull(baseDir);
        this.alternativeDirGetter = alternativeDirGetter;
        this.nodeVersion = Objects.requireNonNull(nodeVersion);
        this.nodeDownloadRoot = Objects.requireNonNull(nodeDownloadRoot);
        this.ignoreVersionChecks = ignoreVersionChecks;
        this.forceAlternativeNode = forceAlternativeNode;
        this.useGlobalPnpm = useGlobalPnpm;
        this.autoUpdate = autoUpdate;
    }

    private static FrontendToolsSettings createSettings(ApplicationConfiguration applicationConfiguration, File projectRoot) {
        boolean useHomeNodeExec = applicationConfiguration.getBooleanProperty("require.home.node", false);
        boolean nodeAutoUpdate = applicationConfiguration.getBooleanProperty("node.auto.update", false);
        boolean useGlobalPnpm = applicationConfiguration.getBooleanProperty("pnpm.global", false);
        String nodeVersion = applicationConfiguration.getStringProperty("node.version", DEFAULT_NODE_VERSION);
        String nodeDownloadRoot = applicationConfiguration.getStringProperty("node.download.root", Platform.guess().getNodeDownloadRoot());
        FrontendToolsSettings settings = new FrontendToolsSettings(projectRoot.getAbsolutePath(), () -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath());
        settings.setForceAlternativeNode(useHomeNodeExec);
        settings.setAutoUpdate(nodeAutoUpdate);
        settings.setUseGlobalPnpm(useGlobalPnpm);
        settings.setNodeVersion(nodeVersion);
        settings.setNodeDownloadRoot(URI.create(nodeDownloadRoot));
        return settings;
    }

    public String getNodeExecutable() {
        Pair<String, String> nodeCommands = this.getNodeCommands();
        File file = this.getExecutable(this.baseDir, nodeCommands.getSecond());
        if (file == null && !this.forceAlternativeNode) {
            file = this.frontendToolsLocator.tryLocateTool(nodeCommands.getFirst()).orElse(null);
        }
        if ((file = this.rejectUnsupportedNodeVersion(file)) == null) {
            file = this.updateAlternateIfNeeded(this.getExecutable(this.getAlternativeDir(), nodeCommands.getSecond()));
        }
        if (file == null && this.alternativeDirGetter != null) {
            this.getLogger().info("Couldn't find {}. Installing Node and npm to {}.", (Object)nodeCommands.getFirst(), (Object)this.getAlternativeDir());
            file = new File(this.installNode(this.nodeVersion, this.nodeDownloadRoot));
        }
        if (file == null) {
            throw new IllegalStateException("Node not found");
        }
        return file.getAbsolutePath();
    }

    private File updateAlternateIfNeeded(File file) {
        if (file == null) {
            return null;
        }
        try {
            ArrayList versionCommand = Lists.newArrayList();
            versionCommand.add(file.getAbsolutePath());
            versionCommand.add("--version");
            FrontendVersion installedNodeVersion = FrontendUtils.getVersion("node", versionCommand);
            boolean installDefault = false;
            FrontendVersion defaultVersion = new FrontendVersion(this.nodeVersion);
            if (installedNodeVersion.isOlderThan(SUPPORTED_NODE_VERSION)) {
                this.getLogger().info("Updating unsupported node version {} to {}", (Object)installedNodeVersion.getFullVersion(), (Object)defaultVersion.getFullVersion());
                installDefault = true;
            } else if (this.autoUpdate && installedNodeVersion.isOlderThan(defaultVersion)) {
                this.getLogger().info("Updating current installed node version from {} to {}", (Object)installedNodeVersion.getFullVersion(), (Object)defaultVersion.getFullVersion());
                installDefault = true;
            }
            if (installDefault) {
                file = new File(this.installNode(this.nodeVersion, this.nodeDownloadRoot));
            }
        }
        catch (FrontendUtils.UnknownVersionException e) {
            this.getLogger().error("Failed to get version for installed node.", (Throwable)e);
        }
        return file;
    }

    private File rejectUnsupportedNodeVersion(File nodeExecutable) {
        if (nodeExecutable == null) {
            return null;
        }
        try {
            ArrayList versionCommand = Lists.newArrayList();
            versionCommand.add(nodeExecutable.getAbsolutePath());
            versionCommand.add("--version");
            FrontendVersion installedNodeVersion = FrontendUtils.getVersion("node", versionCommand);
            if (installedNodeVersion.isOlderThan(SUPPORTED_NODE_VERSION)) {
                this.getLogger().info("{} Node.js version {} is older than the required minimum version {}. Using Node.js from {}.", new Object[]{nodeExecutable.getPath().startsWith(this.baseDir) ? "The project-specific" : "The globally installed", installedNodeVersion.getFullVersion(), SUPPORTED_NODE_VERSION.getFullVersion(), this.alternativeDirGetter.get()});
                this.forceAlternativeNode = true;
                return null;
            }
        }
        catch (FrontendUtils.UnknownVersionException e) {
            this.getLogger().error("Failed to get version for installed node.", (Throwable)e);
        }
        return nodeExecutable;
    }

    public String forceAlternativeNodeExecutable() {
        Pair<String, String> nodeCommands = this.getNodeCommands();
        String dir = this.getAlternativeDir();
        File file = new File(dir, nodeCommands.getSecond());
        if (file.exists()) {
            if (!this.frontendToolsLocator.verifyTool(file)) {
                throw new IllegalStateException(String.format(LOCAL_NODE_NOT_FOUND, dir, dir, file.getAbsolutePath()));
            }
            return this.updateAlternateIfNeeded(file).getAbsolutePath();
        }
        this.getLogger().info("Node not found in {}. Installing node {}.", (Object)dir, (Object)this.nodeVersion);
        return this.installNode(this.nodeVersion, this.nodeDownloadRoot);
    }

    public List<String> getNpmExecutable() {
        return this.getNpmExecutable(true);
    }

    public List<String> getPnpmExecutable() {
        List<String> pnpmCommand = this.getSuitablePnpm();
        assert (!pnpmCommand.isEmpty());
        pnpmCommand = new ArrayList<String>(pnpmCommand);
        pnpmCommand.add("--shamefully-hoist=true");
        return pnpmCommand;
    }

    public void validateNodeAndNpmVersion() {
        if (this.ignoreVersionChecks) {
            return;
        }
        Pair<FrontendVersion, String> foundNodeVersionAndExe = null;
        try {
            foundNodeVersionAndExe = this.getNodeVersionAndExecutable();
            FrontendVersion foundNodeVersion = foundNodeVersionAndExe.getFirst();
            this.getLogger().debug("Using node {} located at {}", (Object)foundNodeVersion.getFullVersion(), (Object)foundNodeVersionAndExe.getSecond());
            FrontendUtils.validateToolVersion("node", foundNodeVersion, SUPPORTED_NODE_VERSION);
        }
        catch (FrontendUtils.UnknownVersionException e) {
            this.getLogger().warn("Error checking if node is new enough", (Throwable)e);
        }
        catch (IllegalStateException ise) {
            if (foundNodeVersionAndExe != null) {
                this.getLogger().info("Validated node from '{}'", (Object)foundNodeVersionAndExe.getSecond());
            }
            throw ise;
        }
        try {
            FrontendVersion foundNpmVersion = this.getNpmVersion();
            this.getLogger().debug("Using npm {} located at {}", (Object)foundNpmVersion.getFullVersion(), (Object)this.getNpmExecutable(false).get(0));
            FrontendUtils.validateToolVersion("npm", foundNpmVersion, SUPPORTED_NPM_VERSION);
        }
        catch (FrontendUtils.UnknownVersionException e) {
            this.getLogger().warn("Error checking if npm is new enough", (Throwable)e);
        }
    }

    public FrontendVersion getNodeVersion() throws FrontendUtils.UnknownVersionException {
        return this.getNodeVersionAndExecutable().getFirst();
    }

    private Pair<FrontendVersion, String> getNodeVersionAndExecutable() throws FrontendUtils.UnknownVersionException {
        String executable = this.getNodeBinary();
        ArrayList<String> nodeVersionCommand = new ArrayList<String>();
        nodeVersionCommand.add(executable);
        nodeVersionCommand.add("--version");
        return new Pair<FrontendVersion, String>(FrontendUtils.getVersion("node", nodeVersionCommand), executable);
    }

    protected String installNode(String nodeVersion, URI downloadRoot) {
        NodeInstaller nodeInstaller = new NodeInstaller(new File(this.getAlternativeDir()), this.getProxies()).setNodeVersion(nodeVersion);
        if (downloadRoot != null) {
            nodeInstaller.setNodeDownloadRoot(downloadRoot);
        }
        try {
            nodeInstaller.install();
        }
        catch (InstallationException e) {
            throw new IllegalStateException("Failed to install Node", e);
        }
        return new File(nodeInstaller.getInstallDirectory(), this.getNodeCommands().getFirst()).toString();
    }

    protected List<ProxyConfig.Proxy> getProxies() {
        File projectNpmrc = new File(this.baseDir, ".npmrc");
        File userNpmrc = new File(FileUtils.getUserDirectory(), ".npmrc");
        ArrayList<ProxyConfig.Proxy> proxyList = new ArrayList<ProxyConfig.Proxy>();
        proxyList.addAll(this.readProxySettingsFromSystemProperties());
        proxyList.addAll(this.readProxySettingsFromNpmrcFile("user .npmrc", userNpmrc));
        proxyList.addAll(this.readProxySettingsFromNpmrcFile("project .npmrc", projectNpmrc));
        proxyList.addAll(this.readProxySettingsFromEnvironmentVariables());
        return proxyList;
    }

    boolean folderIsAcceptableByNpm(File folder) {
        boolean hidden;
        Objects.requireNonNull(folder);
        boolean bl = hidden = folder.isHidden() || folder.getPath().contains(File.separator + ".");
        if (!(hidden || folder.exists() && folder.isDirectory())) {
            this.getLogger().warn("Failed to check whether npm accepts the folder '{}', because the folder doesn't exist or not a directory", (Object)folder);
            return true;
        }
        if (FrontendUtils.isWindows() && folder.getAbsolutePath().matches(".*[\\s+].*")) {
            try {
                FrontendVersion foundNpmVersion = this.getNpmVersion();
                return FrontendUtils.isVersionAtLeast(foundNpmVersion, WHITESPACE_ACCEPTING_NPM_VERSION);
            }
            catch (FrontendUtils.UnknownVersionException e) {
                this.getLogger().warn("Error checking if npm accepts path '{}'", (Object)folder, (Object)e);
            }
        }
        return true;
    }

    File getNpmCacheDir() throws FrontendUtils.CommandExecutionException, IllegalStateException {
        ArrayList<String> npmCacheCommand = new ArrayList<String>(this.getNpmExecutable(false));
        npmCacheCommand.add("config");
        npmCacheCommand.add("get");
        npmCacheCommand.add("cache");
        npmCacheCommand.add("--global");
        String output = FrontendUtils.executeCommand(npmCacheCommand);
        output = this.removeLineBreaks(output);
        if (output.isEmpty()) {
            throw new IllegalStateException(String.format("Command '%s' returned an empty path", String.join((CharSequence)" ", npmCacheCommand)));
        }
        return new File(output);
    }

    public FrontendVersion getNpmVersion() throws FrontendUtils.UnknownVersionException {
        ArrayList<String> npmVersionCommand = new ArrayList<String>(this.getNpmExecutable(false));
        npmVersionCommand.add("--version");
        return FrontendUtils.getVersion("npm", npmVersionCommand);
    }

    public Map<String, String> getWebpackNodeEnvironment() {
        HashMap<String, String> environment = new HashMap<String, String>();
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(this.getNodeExecutable(), "-p", "crypto.createHash('md4')");
        try {
            Process process = processBuilder.start();
            int errorLevel = process.waitFor();
            if (errorLevel != 0) {
                environment.put("NODE_OPTIONS", "--openssl-legacy-provider");
            }
        }
        catch (IOException e) {
            this.getLogger().error("IO error while determining --openssl-legacy-provider parameter requirement", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.getLogger().error("Interrupted while determining --openssl-legacy-provider parameter requirement", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return environment;
    }

    private File getExecutable(String dir, String location) {
        File file = new File(dir, location);
        if (this.frontendToolsLocator.verifyTool(file)) {
            return file;
        }
        return null;
    }

    private Pair<String, String> getNodeCommands() {
        if (FrontendUtils.isWindows()) {
            return new Pair<String, String>("node.exe", "node/node.exe");
        }
        return new Pair<String, String>("node", "node/node");
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(FrontendTools.class);
    }

    private List<ProxyConfig.Proxy> readProxySettingsFromNpmrcFile(String fileDescription, File npmrc) {
        ArrayList<ProxyConfig.Proxy> arrayList;
        if (!npmrc.exists()) {
            return Collections.emptyList();
        }
        FileReader fileReader = new FileReader(npmrc);
        try {
            String proxyUrl;
            String httpsProxyUrl;
            ArrayList<ProxyConfig.Proxy> proxyList = new ArrayList<ProxyConfig.Proxy>(2);
            Properties properties = new Properties();
            properties.load(fileReader);
            String noproxy = properties.getProperty(NPMRC_NOPROXY_PROPERTY_KEY);
            if (noproxy != null) {
                noproxy = noproxy.replaceAll(",", "|");
            }
            if ((httpsProxyUrl = properties.getProperty(NPMRC_HTTPS_PROXY_PROPERTY_KEY)) != null) {
                proxyList.add(new ProxyConfig.Proxy("https-proxy - " + fileDescription, httpsProxyUrl, noproxy));
            }
            if ((proxyUrl = properties.getProperty(NPMRC_PROXY_PROPERTY_KEY)) != null) {
                proxyList.add(new ProxyConfig.Proxy("proxy - " + fileDescription, proxyUrl, noproxy));
            }
            arrayList = proxyList;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        fileReader.close();
        return arrayList;
    }

    private List<ProxyConfig.Proxy> readProxySettingsFromSystemProperties() {
        String proxyUrl;
        String httpsProxyUrl;
        ArrayList<ProxyConfig.Proxy> proxyList = new ArrayList<ProxyConfig.Proxy>(2);
        String noproxy = this.getNonNull(System.getProperty(SYSTEM_NOPROXY_PROPERTY_KEY), System.getProperty(SYSTEM_NOPROXY_PROPERTY_KEY.toLowerCase()));
        if (noproxy != null) {
            noproxy = noproxy.replaceAll(",", "|");
        }
        if ((httpsProxyUrl = this.getNonNull(System.getProperty(SYSTEM_HTTPS_PROXY_PROPERTY_KEY), System.getProperty(SYSTEM_HTTPS_PROXY_PROPERTY_KEY.toLowerCase()))) != null) {
            proxyList.add(new ProxyConfig.Proxy("https-proxy - system", httpsProxyUrl, noproxy));
        }
        if ((proxyUrl = this.getNonNull(System.getProperty(SYSTEM_HTTP_PROXY_PROPERTY_KEY), System.getProperty(SYSTEM_HTTP_PROXY_PROPERTY_KEY.toLowerCase()))) != null) {
            proxyList.add(new ProxyConfig.Proxy("proxy - system", proxyUrl, noproxy));
        }
        return proxyList;
    }

    private List<ProxyConfig.Proxy> readProxySettingsFromEnvironmentVariables() {
        String proxyUrl;
        String httpsProxyUrl;
        ArrayList<ProxyConfig.Proxy> proxyList = new ArrayList<ProxyConfig.Proxy>(2);
        String noproxy = this.getNonNull(System.getenv(SYSTEM_NOPROXY_PROPERTY_KEY), System.getenv(SYSTEM_NOPROXY_PROPERTY_KEY.toLowerCase()));
        if (noproxy != null) {
            noproxy = noproxy.replaceAll(",", "|");
        }
        if ((httpsProxyUrl = this.getNonNull(System.getenv(SYSTEM_HTTPS_PROXY_PROPERTY_KEY), System.getenv(SYSTEM_HTTPS_PROXY_PROPERTY_KEY.toLowerCase()))) != null) {
            proxyList.add(new ProxyConfig.Proxy("https-proxy - env", httpsProxyUrl, noproxy));
        }
        if ((proxyUrl = this.getNonNull(System.getenv(SYSTEM_HTTP_PROXY_PROPERTY_KEY), System.getenv(SYSTEM_HTTP_PROXY_PROPERTY_KEY.toLowerCase()))) != null) {
            proxyList.add(new ProxyConfig.Proxy("proxy - env", proxyUrl, noproxy));
        }
        return proxyList;
    }

    private String getNonNull(String ... valueArray) {
        for (String value : valueArray) {
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private List<String> getNpmExecutable(boolean removePnpmLock) {
        ArrayList<String> returnCommand = new ArrayList<String>(this.getNpmCliToolExecutable(BuildTool.NPM, new String[0]));
        returnCommand.add("--no-update-notifier");
        returnCommand.add("--no-audit");
        returnCommand.add("--scripts-prepend-node-path=true");
        if (removePnpmLock && new File(this.baseDir, "pnpm-lock.yaml").delete()) {
            this.getLogger().debug("pnpm-lock.yaml file is removed from " + this.baseDir);
        }
        return returnCommand;
    }

    private List<String> getNpmCliToolExecutable(BuildTool cliTool, String ... flags) {
        Optional<String> command;
        List<String> returnCommand = this.getNpmScriptCommand(this.baseDir, cliTool.getScript());
        boolean alternativeDirChecked = false;
        if (returnCommand.isEmpty() && this.forceAlternativeNode) {
            returnCommand = this.getNpmScriptCommand(this.getAlternativeDir(), cliTool.getScript());
            alternativeDirChecked = true;
        }
        if (returnCommand.isEmpty() && (command = this.frontendToolsLocator.tryLocateTool(cliTool.getCommand()).map(File::getAbsolutePath)).isPresent()) {
            returnCommand = Collections.singletonList(command.get());
            if (!alternativeDirChecked && cliTool.equals((Object)BuildTool.NPM)) {
                try {
                    ArrayList<String> npmVersionCommand = new ArrayList<String>(returnCommand);
                    npmVersionCommand.add("--version");
                    FrontendVersion npmVersion = FrontendUtils.getVersion("npm", npmVersionCommand);
                    if (npmVersion.isOlderThan(SUPPORTED_NPM_VERSION)) {
                        returnCommand = new ArrayList<String>();
                        this.forceAlternativeNodeExecutable();
                    }
                }
                catch (FrontendUtils.UnknownVersionException uve) {
                    this.getLogger().error("Could not determine npm version", (Throwable)uve);
                    returnCommand = new ArrayList<String>();
                    this.forceAlternativeNodeExecutable();
                }
            }
        }
        if (!alternativeDirChecked && returnCommand.isEmpty()) {
            returnCommand = this.getNpmScriptCommand(this.getAlternativeDir(), cliTool.getScript());
            this.forceAlternativeNode = true;
        }
        if (flags.length > 0) {
            returnCommand = new ArrayList<String>(returnCommand);
            Collections.addAll(returnCommand, flags);
        }
        return returnCommand;
    }

    private List<String> getNpmScriptCommand(String dir, String scriptName) {
        File file = new File(dir, NPM_BIN_PATH + scriptName);
        if (!FrontendUtils.isWindows() && !file.canRead()) {
            file = new File(dir, NPM_BIN_LINUX_LEGACY_PATH + scriptName);
        }
        ArrayList<String> returnCommand = new ArrayList<String>();
        if (file.canRead()) {
            returnCommand.add(this.getNodeBinary());
            returnCommand.add(file.getAbsolutePath());
        }
        return returnCommand;
    }

    List<String> getSuitablePnpm() {
        List pnpmCommand;
        if (this.useGlobalPnpm) {
            pnpmCommand = this.frontendToolsLocator.tryLocateTool(BuildTool.PNPM.getCommand()).map(File::getAbsolutePath).map(Collections::singletonList).orElseThrow(() -> new IllegalStateException(String.format(PNPM_NOT_FOUND, new Object[0])));
            pnpmCommand = Stream.of(pnpmCommand).filter(this::validatePnpmVersion).findFirst().orElseThrow(() -> new IllegalStateException("Found too old globally installed 'pnpm'. Please upgrade 'pnpm' to at least " + SUPPORTED_PNPM_VERSION.getFullVersion()));
        } else {
            pnpmCommand = this.getNpmCliToolExecutable(BuildTool.NPX, "--yes", "--quiet", "pnpm");
            if (!this.validatePnpmVersion(pnpmCommand)) {
                throw new IllegalStateException("Found too old globally installed 'pnpm'. Please upgrade 'pnpm' to at least " + SUPPORTED_PNPM_VERSION.getFullVersion());
            }
        }
        return pnpmCommand;
    }

    private boolean validatePnpmVersion(List<String> pnpmCommand) {
        String commandLine = String.join((CharSequence)" ", pnpmCommand);
        try {
            boolean versionAccepted;
            ArrayList<String> versionCmd = new ArrayList<String>(pnpmCommand);
            versionCmd.add("--version");
            FrontendVersion pnpmVersion = FrontendUtils.getVersion("pnpm", versionCmd);
            boolean versionNewEnough = FrontendUtils.isVersionAtLeast(pnpmVersion, SUPPORTED_PNPM_VERSION);
            boolean bl = versionAccepted = this.ignoreVersionChecks || versionNewEnough;
            if (!versionAccepted) {
                this.getLogger().warn("pnpm '{}' is version {} which is not supported (expected >={})", new Object[]{commandLine, pnpmVersion.getFullVersion(), SUPPORTED_PNPM_VERSION.getFullVersion()});
            }
            return versionAccepted;
        }
        catch (FrontendUtils.UnknownVersionException e) {
            this.getLogger().warn("version check '{}' failed", (Object)commandLine, (Object)e);
            return false;
        }
    }

    private String buildBadVersionString(String tool, String version, String ... extraUpdateInstructions) {
        StringBuilder extraInstructions = new StringBuilder();
        for (String instruction : extraUpdateInstructions) {
            extraInstructions.append("%n  - or ").append(instruction);
        }
        return String.format(BAD_VERSION, tool, version, extraInstructions.toString(), "vaadin.ignoreVersionChecks");
    }

    private String getAlternativeDir() {
        return this.alternativeDirGetter.get();
    }

    public String getNodeBinary() {
        if (this.forceAlternativeNode) {
            return this.forceAlternativeNodeExecutable();
        }
        return this.getNodeExecutable();
    }

    private String removeLineBreaks(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return String.join((CharSequence)"", str.split(System.lineSeparator()));
    }

    private static enum BuildTool {
        NPM("npm", "npm-cli.js"),
        NPX("npx", "npx-cli.js"),
        PNPM("pnpm", null);

        private final String name;
        private final String script;

        private BuildTool(String tool, String script) {
            this.name = tool;
            this.script = script;
        }

        String getCommand() {
            return FrontendUtils.isWindows() ? this.name + ".cmd" : this.name;
        }

        String getScript() {
            if (this.script == null) {
                throw new RuntimeException(String.format("'%s' build tool doesn't have a CLI script", this.name));
            }
            return this.script;
        }
    }
}

