/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.flow.router;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Indicates that a previous view instance should be-reused when reloading a
 * location in the same browser window/tab.
 * <p>
 * This annotation can also be used, when exporting embeddable web components.
 * Place this annotation onto the class extending
 * {@link com.vaadin.flow.component.WebComponentExporter}. This flags all the
 * embedded components from that exporter to be preserved on refresh. Due to the
 * challenge of uniquely identifying embedded components through refresh, when
 * embedded, the component is identified by window name and a generated
 * component id. This means, that if the same component instance is embedded
 * onto two pages within the same window context, the state can be transferred
 * between locations. To avoid state leaking, provide unique id for the embedded
 * web component. The id must be unique across all the pages where instances of
 * the web component are embedded.
 *
 * @since 2.0
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Inherited
@Documented
public @interface PreserveOnRefresh {
}
