/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendToolsSettings;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.FrontendVersion;
import com.vaadin.flow.server.frontend.GenerateMainImports;
import com.vaadin.flow.server.frontend.JarContentsManager;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskUpdatePackages;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.server.webcomponent.WebComponentExporterTagExtractor;
import com.vaadin.flow.server.webcomponent.WebComponentExporterUtils;
import com.vaadin.flow.shared.util.SharedUtil;
import com.vaadin.flow.theme.ThemeDefinition;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import elemental.json.JsonValue;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRunDevBundleBuild
implements FallibleCommand {
    private static final Pattern THEME_PATH_PATTERN = Pattern.compile("themes\\/([\\s\\S]+?)\\/theme.json");
    public static final String README = "This directory is automatically generated by Vaadin and contains the pre-compiled \nfrontend files/resources for your project (frontend development bundle).\n\nIt should be added to Version Control System and committed, so that other developers\ndo not have to compile it again.\n\nFrontend development bundle is automatically updated when needed:\n- an npm/pnpm package is added with @NpmPackage or directly into package.json\n- CSS, JavaScript or TypeScript files are added with @CssImport, @JsModule or @JavaScript\n- Vaadin add-on with front-end customizations is added\n- Custom theme imports/assets added into 'theme.json' file\n- Exported web component is added.\n\nIf your project development needs a hot deployment of the frontend changes, \nyou can switch Flow to use Vite development server (default in Vaadin 23.3 and earlier versions):\n- set `vaadin.frontend.hotdeploy=true` in `application.properties`\n- configure `vaadin-maven-plugin`:\n```\n   <configuration>\n       <frontendHotdeploy>true</frontendHotdeploy>\n   </configuration>\n```\n- configure `jetty-maven-plugin`:\n```\n   <configuration>\n       <systemProperties>\n           <vaadin.frontend.hotdeploy>true</vaadin.frontend.hotdeploy>\n       </systemProperties>\n   </configuration>\n```\n\nRead more [about Vaadin development mode](https://vaadin.com/docs/next/configuration/development-mode/#pre-compiled-front-end-bundle-for-faster-start-up).";
    public static final String README_NOT_CREATED = "Failed to create a README file in src/main/dev-bundle";
    private final Options options;

    TaskRunDevBundleBuild(Options options) {
        this.options = options;
    }

    @Override
    public void execute() throws ExecutionFailedException {
        TaskRunDevBundleBuild.getLogger().info("Creating a new express mode bundle. This can take a while but will only run when the project setup is changed, addons are added or frontend files are modified");
        this.runFrontendBuildTool("Vite", "vite/bin/vite.js", Collections.emptyMap(), "build");
        this.addReadme();
    }

    public static boolean needsBuild(Options options, FrontendDependenciesScanner frontendDependencies, ClassFinder finder) {
        TaskRunDevBundleBuild.getLogger().info("Checking if an express mode bundle build is needed");
        try {
            boolean needsBuild = TaskRunDevBundleBuild.needsBuildInternal(options, frontendDependencies, finder);
            if (needsBuild) {
                TaskRunDevBundleBuild.getLogger().info("An express mode bundle build is needed");
            } else {
                TaskRunDevBundleBuild.getLogger().info("An express mode bundle build is not needed");
            }
            return needsBuild;
        }
        catch (Exception e) {
            TaskRunDevBundleBuild.getLogger().error("Error when checking if an express mode bundle build is needed", (Throwable)e);
            return true;
        }
    }

    protected static boolean needsBuildInternal(Options options, FrontendDependenciesScanner frontendDependencies, ClassFinder finder) throws IOException {
        Map<String, String> npmPackages;
        File npmFolder = options.getNpmFolder();
        if (!FrontendUtils.getDevBundleFolder(npmFolder).exists() && !TaskRunDevBundleBuild.hasJarBundle()) {
            TaskRunDevBundleBuild.getLogger().info("No dev-bundle found.");
            return true;
        }
        String statsJsonContent = FrontendUtils.findBundleStatsJson(npmFolder);
        if (statsJsonContent == null) {
            TaskRunDevBundleBuild.getLogger().info("No dev-bundle stats.json found for validation.");
            return true;
        }
        JsonObject packageJson = TaskRunDevBundleBuild.getPackageJson(options, frontendDependencies, finder);
        JsonObject statsJson = Json.parse((String)statsJsonContent);
        if (!TaskRunDevBundleBuild.hashAndBundleModulesEqual(statsJson, packageJson, npmPackages = frontendDependencies.getPackages())) {
            UsageStatistics.markAsUsed("flow/rebundle-reason-missing-package", null);
            return true;
        }
        if (!TaskRunDevBundleBuild.frontendImportsFound(statsJson, options, finder, frontendDependencies)) {
            UsageStatistics.markAsUsed("flow/rebundle-reason-missing-frontend-import", null);
            return true;
        }
        if (TaskRunDevBundleBuild.themeConfigurationChanged(options, statsJson, frontendDependencies)) {
            UsageStatistics.markAsUsed("flow/rebundle-reason-changed-theme-config", null);
            return true;
        }
        if (TaskRunDevBundleBuild.exportedWebComponents(statsJson, finder)) {
            UsageStatistics.markAsUsed("flow/rebundle-reason-added-exported-component", null);
            return true;
        }
        return false;
    }

    private static boolean exportedWebComponents(JsonObject statsJson, ClassFinder finder) {
        try {
            HashSet exporterRelatedClasses = new HashSet();
            finder.getSubTypesOf(WebComponentExporter.class.getName()).forEach(exporterRelatedClasses::add);
            finder.getSubTypesOf(WebComponentExporterFactory.class.getName()).forEach(exporterRelatedClasses::add);
            Set webComponents = WebComponentExporterUtils.getFactories(exporterRelatedClasses).stream().map(TaskRunDevBundleBuild::getTag).collect(Collectors.toSet());
            JsonArray webComponentsInStats = statsJson.getArray("webComponents");
            if (webComponentsInStats == null) {
                if (!webComponents.isEmpty()) {
                    TaskRunDevBundleBuild.getLogger().info("Found embedded web components not yet included into the dev bundle: {}", (Object)String.join((CharSequence)", ", webComponents));
                    return true;
                }
                return false;
            }
            for (int index = 0; index < webComponentsInStats.length(); ++index) {
                String webComponentInStats = webComponentsInStats.getString(index);
                webComponents.remove(webComponentInStats);
            }
            if (!webComponents.isEmpty()) {
                TaskRunDevBundleBuild.getLogger().info("Found newly added embedded web components not yet included into the dev bundle: {}", (Object)String.join((CharSequence)", ", webComponents));
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException e) {
            TaskRunDevBundleBuild.getLogger().error("Unable to locate embedded web component classes.");
            return false;
        }
    }

    private static boolean themeConfigurationChanged(Options options, JsonObject statsJson, FrontendDependenciesScanner frontendDependencies) throws IOException {
        JsonObject content;
        ArrayList<String> missedKeys;
        HashMap themeJsonContents = new HashMap();
        if (options.getJarFiles() == null) {
            return false;
        }
        options.getJarFiles().stream().filter(File::exists).filter(file -> !file.isDirectory()).forEach(jarFile -> TaskRunDevBundleBuild.getPackagedThemeJsonContents(jarFile, themeJsonContents));
        ThemeDefinition themeDefinition = frontendDependencies.getThemeDefinition();
        Optional<JsonObject> projectThemeJson = TaskRunDevBundleBuild.getContentForProjectThemeJson(options, themeDefinition);
        JsonObject contentsInStats = statsJson.getObject("themeJsonContents");
        if (contentsInStats == null && (!themeJsonContents.isEmpty() || projectThemeJson.isPresent())) {
            TaskRunDevBundleBuild.getLogger().info("Found newly added theme configurations in 'theme.json'.");
            return true;
        }
        if (projectThemeJson.isPresent()) {
            String key;
            String projectThemeName = themeDefinition.getName();
            if (contentsInStats.hasKey(projectThemeName)) {
                key = projectThemeName;
            } else if (contentsInStats.hasKey("vaadin-dev-bundle")) {
                key = "vaadin-dev-bundle";
            } else {
                TaskRunDevBundleBuild.getLogger().info("Found newly added configuration for project theme '{}' in 'theme.json'.", (Object)projectThemeName);
                return true;
            }
            missedKeys = new ArrayList<String>();
            content = Json.parse((String)contentsInStats.getString(key));
            if (!TaskRunDevBundleBuild.objectIncludesEntry((JsonValue)content, (JsonValue)projectThemeJson.get(), missedKeys)) {
                TaskRunDevBundleBuild.getLogger().info("Project custom theme '{}' has imports/assets in 'theme.json' not present in the bundle", (Object)projectThemeName);
                Collections.reverse(missedKeys);
                TaskRunDevBundleBuild.logChangedFiles(missedKeys, "Detected missed entries:");
                return true;
            }
        }
        for (Map.Entry themeContent : themeJsonContents.entrySet()) {
            if (!contentsInStats.hasKey((String)themeContent.getKey())) {
                TaskRunDevBundleBuild.getLogger().info("Found new configuration for theme '{}' in 'theme.json'.", themeContent.getKey());
                return true;
            }
            missedKeys = new ArrayList();
            content = Json.parse((String)contentsInStats.getString((String)themeContent.getKey()));
            if (TaskRunDevBundleBuild.objectIncludesEntry((JsonValue)content, (JsonValue)themeContent.getValue(), missedKeys)) continue;
            TaskRunDevBundleBuild.getLogger().info("Packaged custom theme '{}' has imports/assets in 'theme.json' not present in the bundle", themeContent.getKey());
            return true;
        }
        return false;
    }

    private static boolean objectIncludesEntry(JsonValue jsonFromBundle, JsonValue projectJson, Collection<String> missedKeys) {
        JsonType bundleJsonType = jsonFromBundle.getType();
        JsonType projectJsonObjectTypeType = projectJson.getType();
        assert (bundleJsonType.equals((Object)projectJsonObjectTypeType));
        if (bundleJsonType == JsonType.NULL) {
            return true;
        }
        if (bundleJsonType == JsonType.BOOLEAN) {
            return JsonUtils.booleanEqual(jsonFromBundle, projectJson);
        }
        if (bundleJsonType == JsonType.NUMBER) {
            return JsonUtils.numbersEqual(jsonFromBundle, projectJson);
        }
        if (bundleJsonType == JsonType.STRING) {
            return JsonUtils.stringEqual(jsonFromBundle, projectJson);
        }
        if (bundleJsonType == JsonType.ARRAY) {
            JsonArray jsonArrayFromBundle = (JsonArray)jsonFromBundle;
            JsonArray projectJsonArray = (JsonArray)projectJson;
            return TaskRunDevBundleBuild.compareArrays(missedKeys, jsonArrayFromBundle, projectJsonArray);
        }
        if (bundleJsonType == JsonType.OBJECT) {
            JsonObject jsonObjectFromBundle = (JsonObject)jsonFromBundle;
            JsonObject projectJsonObject = (JsonObject)projectJson;
            return TaskRunDevBundleBuild.compareObjects(missedKeys, jsonObjectFromBundle, projectJsonObject);
        }
        throw new IllegalArgumentException("Unsupported JsonType: " + bundleJsonType);
    }

    private static boolean frontendImportsFound(JsonObject statsJson, Options options, ClassFinder finder, FrontendDependenciesScanner frontendDependencies) throws IOException {
        GenerateMainImports generateMainImports = new GenerateMainImports(finder, frontendDependencies, options, statsJson);
        generateMainImports.run();
        List imports = generateMainImports.getLines().stream().filter(line -> line.startsWith("import")).map(line -> line.substring(line.indexOf(39) + 1, line.lastIndexOf(39))).map(importString -> importString.contains("?") ? importString.substring(0, importString.lastIndexOf("?")) : importString).collect(Collectors.toList());
        JsonArray statsBundle = statsJson.hasKey("bundleImports") ? statsJson.getArray("bundleImports") : Json.createArray();
        List missingFromBundle = imports.stream().filter(importString -> !TaskRunDevBundleBuild.arrayContainsString(statsBundle, importString)).collect(Collectors.toList());
        if (!missingFromBundle.isEmpty()) {
            for (String dependency : missingFromBundle) {
                TaskRunDevBundleBuild.getLogger().info("Frontend import " + dependency + " is missing from the bundle");
            }
            return false;
        }
        String resourcePath = "generated/jar-resources/";
        List<String> jarImports = imports.stream().filter(importString -> importString.contains(resourcePath)).map(importString -> importString.substring(importString.indexOf(resourcePath) + resourcePath.length())).collect(Collectors.toList());
        List<String> projectImports = imports.stream().filter(importString -> importString.startsWith("Frontend/") && !importString.contains(resourcePath)).map(importString -> importString.substring("Frontend/".length())).collect(Collectors.toList());
        JsonObject frontendHashes = statsJson.getObject("frontendHashes");
        ArrayList<String> faultyContent = new ArrayList<String>();
        for (String jarImport : jarImports) {
            String jarResourceString = FrontendUtils.getJarResourceString(jarImport);
            if (jarResourceString == null) {
                TaskRunDevBundleBuild.getLogger().info("No file found for '{}'", (Object)jarImport);
                return false;
            }
            TaskRunDevBundleBuild.compareFrontendHashes(frontendHashes, faultyContent, jarImport, jarResourceString);
        }
        for (String projectImport : projectImports) {
            File frontendFile = new File(options.getFrontendDirectory(), projectImport);
            if (!frontendFile.exists()) {
                TaskRunDevBundleBuild.getLogger().info("No file found for '{}'", (Object)projectImport);
                return false;
            }
            String frontendFileContent = FileUtils.readFileToString((File)frontendFile, (Charset)StandardCharsets.UTF_8);
            TaskRunDevBundleBuild.compareFrontendHashes(frontendHashes, faultyContent, projectImport, frontendFileContent);
        }
        if (!faultyContent.isEmpty()) {
            TaskRunDevBundleBuild.logChangedFiles(faultyContent, "Detected changed content for frontend files:");
            return false;
        }
        if (TaskRunDevBundleBuild.indexFileAddedOrDeleted(options, frontendHashes)) {
            return false;
        }
        Map<String, String> remainingImports = TaskRunDevBundleBuild.getRemainingImports(jarImports, projectImports, frontendHashes);
        return !TaskRunDevBundleBuild.importedFrontendFilesChanged(options.getFrontendDirectory(), remainingImports);
    }

    private static boolean indexFileAddedOrDeleted(Options options, JsonObject frontendHashes) {
        List<String> indexFiles = Arrays.asList("index.ts", "index.js", "index.tsx");
        for (String indexFile : indexFiles) {
            File file = new File(options.getFrontendDirectory(), indexFile);
            if (file.exists() && !frontendHashes.hasKey(indexFile)) {
                TaskRunDevBundleBuild.getLogger().info("Detected added {} file", (Object)indexFile);
                return true;
            }
            if (file.exists() || !frontendHashes.hasKey(indexFile)) continue;
            TaskRunDevBundleBuild.getLogger().info("Detected deleted {} file", (Object)indexFile);
            return true;
        }
        return false;
    }

    private static Map<String, String> getRemainingImports(List<String> jarImports, List<String> projectImports, JsonObject frontendHashes) {
        HashMap<String, String> remainingImportEntries = new HashMap<String, String>();
        ArrayList<String> remainingKeys = new ArrayList<String>(Arrays.asList(frontendHashes.keys()));
        remainingKeys.removeAll(jarImports);
        remainingKeys.removeAll(projectImports);
        if (!remainingKeys.isEmpty()) {
            for (String key : remainingKeys) {
                remainingImportEntries.put(key, frontendHashes.getString(key));
            }
            return remainingImportEntries;
        }
        return Collections.emptyMap();
    }

    private static boolean importedFrontendFilesChanged(File frontendDirectory, Map<String, String> remainingImports) throws IOException {
        if (!remainingImports.isEmpty()) {
            ArrayList<String> changed = new ArrayList<String>();
            for (Map.Entry<String, String> importEntry : remainingImports.entrySet()) {
                String hash;
                String filePath = importEntry.getKey();
                String expectedHash = importEntry.getValue();
                File frontendFile = new File(frontendDirectory, filePath);
                if (!frontendFile.exists() || expectedHash.equals(hash = TaskRunDevBundleBuild.calculateHash(FileUtils.readFileToString((File)frontendFile, (Charset)StandardCharsets.UTF_8)))) continue;
                changed.add(filePath);
            }
            if (!changed.isEmpty()) {
                TaskRunDevBundleBuild.logChangedFiles(changed, "Detected changed frontend files:");
                return true;
            }
        }
        return false;
    }

    private static void logChangedFiles(List<String> frontendFiles, String message) {
        if (message == null || ((String)message).isEmpty()) {
            throw new IllegalArgumentException("Changed files message cannot be empty");
        }
        if (((String)message).contains("{}")) {
            throw new IllegalArgumentException("Changed files message shouldn't include '{}' placeholder");
        }
        message = (String)message + "\n{}";
        StringBuilder handledFiles = new StringBuilder();
        for (String file : frontendFiles) {
            handledFiles.append(" - ").append(file).append("\n");
        }
        TaskRunDevBundleBuild.getLogger().info((String)message, (Object)handledFiles);
    }

    private static void compareFrontendHashes(JsonObject frontendHashes, List<String> faultyContent, String frontendFilePath, String frontendFileContent) {
        String contentHash = TaskRunDevBundleBuild.calculateHash(frontendFileContent);
        if (frontendHashes.hasKey(frontendFilePath) && !frontendHashes.getString(frontendFilePath).equals(contentHash)) {
            faultyContent.add(frontendFilePath);
        } else if (!frontendHashes.hasKey(frontendFilePath)) {
            TaskRunDevBundleBuild.getLogger().info("No hash info for '{}'", (Object)frontendFilePath);
            faultyContent.add(frontendFilePath);
        }
    }

    private static String calculateHash(String fileContent) {
        String content = fileContent.replaceAll("\\r\\n", "\n");
        return StringUtil.getHash(content, StandardCharsets.UTF_8);
    }

    private static boolean arrayContainsString(JsonArray array, String string) {
        string = string.replace("Frontend/", "./");
        for (int i = 0; i < array.length(); ++i) {
            if (!string.equals(array.getString(i).replace("Frontend/", "./"))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasJarBundle() {
        URL resource = TaskRunDevBundleBuild.class.getClassLoader().getResource("vaadin-dev-bundle/config/stats.json");
        return resource != null;
    }

    private static boolean hashAndBundleModulesEqual(JsonObject statsJson, JsonObject packageJson, Map<String, String> npmPackages) {
        String packageJsonHash = TaskRunDevBundleBuild.getPackageJsonHash(packageJson);
        String bundlePackageJsonHash = TaskRunDevBundleBuild.getStatsHash(statsJson);
        if (packageJsonHash == null || packageJsonHash.isEmpty()) {
            TaskRunDevBundleBuild.getLogger().error("No hash found for 'package.json' even though one should always be generated!");
            return false;
        }
        JsonObject bundleModules = statsJson.getObject("packageJsonDependencies");
        if (bundleModules == null) {
            TaskRunDevBundleBuild.getLogger().error("Dev bundle did not contain package json dependencies to validate.\nRebuild of bundle needed.");
            return false;
        }
        if (packageJsonHash.equals(bundlePackageJsonHash) && !TaskRunDevBundleBuild.dependenciesContainsAllPackages(npmPackages, bundleModules)) {
            return false;
        }
        JsonObject dependencies = packageJson.getObject("dependencies");
        List dependenciesList = Arrays.stream(dependencies.keys()).filter(pkg -> !"@vaadin/flow-frontend".equals(pkg)).collect(Collectors.toList());
        List missingFromBundle = dependenciesList.stream().filter(pkg -> !bundleModules.hasKey(pkg)).collect(Collectors.toList());
        if (!missingFromBundle.isEmpty()) {
            for (String dependency : missingFromBundle) {
                TaskRunDevBundleBuild.getLogger().info("Dependency " + dependency + " is missing from the bundle");
            }
            return false;
        }
        missingFromBundle = dependenciesList.stream().filter(pkg -> !TaskRunDevBundleBuild.versionAccepted(dependencies.getString(pkg), bundleModules.getString(pkg))).collect(Collectors.toList());
        if (!missingFromBundle.isEmpty()) {
            for (String pkg2 : missingFromBundle) {
                TaskRunDevBundleBuild.getLogger().info("Dependency {}:{} has the wrong version {} in the bundle", new Object[]{pkg2, dependencies.getString(pkg2), bundleModules.getString(pkg2)});
            }
            return false;
        }
        return true;
    }

    private static boolean versionAccepted(String expected, String actual) {
        FrontendVersion expectedVersion = new FrontendVersion(expected);
        FrontendVersion actualVersion = new FrontendVersion(actual);
        if (expected.startsWith("~")) {
            boolean correctRange = expectedVersion.getMajorVersion() == actualVersion.getMajorVersion() && expectedVersion.getMinorVersion() == actualVersion.getMinorVersion();
            return (expectedVersion.isEqualTo(actualVersion) || expectedVersion.isOlderThan(actualVersion)) && correctRange;
        }
        if (expected.startsWith("^")) {
            boolean correctRange = expectedVersion.getMajorVersion() == actualVersion.getMajorVersion();
            return (expectedVersion.isEqualTo(actualVersion) || expectedVersion.isOlderThan(actualVersion)) && correctRange;
        }
        return expectedVersion.isEqualTo(actualVersion);
    }

    private static JsonObject getPackageJson(Options options, FrontendDependenciesScanner frontendDependencies, ClassFinder finder) {
        File packageJsonFile = new File(options.getNpmFolder(), "package.json");
        if (packageJsonFile.exists()) {
            try {
                JsonObject packageJson = Json.parse((String)FileUtils.readFileToString((File)packageJsonFile, (Charset)StandardCharsets.UTF_8));
                TaskRunDevBundleBuild.cleanOldPlatformDependencies(packageJson);
                return TaskRunDevBundleBuild.getDefaultPackageJson(options, frontendDependencies, finder, packageJson);
            }
            catch (IOException e) {
                TaskRunDevBundleBuild.getLogger().warn("Failed to read package.json", (Throwable)e);
            }
        } else {
            return TaskRunDevBundleBuild.getDefaultPackageJson(options, frontendDependencies, finder, null);
        }
        return null;
    }

    protected static JsonObject getDefaultPackageJson(Options options, FrontendDependenciesScanner frontendDependencies, ClassFinder finder, JsonObject packageJson) {
        NodeUpdater nodeUpdater = new NodeUpdater(finder, frontendDependencies, options){

            @Override
            public void execute() {
            }
        };
        try {
            if (packageJson == null) {
                packageJson = nodeUpdater.getPackageJson();
            }
            nodeUpdater.addVaadinDefaultsToJson(packageJson);
            nodeUpdater.updateDefaultDependencies(packageJson);
            Map<String, String> applicationDependencies = frontendDependencies.getPackages();
            for (Map.Entry<String, String> dep : applicationDependencies.entrySet()) {
                nodeUpdater.addDependency(packageJson, "dependencies", dep.getKey(), dep.getValue());
            }
            String hash = TaskUpdatePackages.generatePackageJsonHash(packageJson);
            packageJson.getObject("vaadin").put("hash", hash);
            JsonObject platformPinnedDependencies = nodeUpdater.getPlatformPinnedDependencies();
            for (String key : platformPinnedDependencies.keys()) {
                if (applicationDependencies.containsKey(key)) continue;
                TaskUpdatePackages.pinPlatformDependency(packageJson, platformPinnedDependencies, key);
            }
            return packageJson;
        }
        catch (IOException e) {
            TaskRunDevBundleBuild.getLogger().warn("Failed to generate package.json", (Throwable)e);
            return null;
        }
    }

    private static String getStatsHash(JsonObject statsJson) {
        if (statsJson.hasKey("packageJsonHash")) {
            return statsJson.getString("packageJsonHash");
        }
        return null;
    }

    private static String getPackageJsonHash(JsonObject packageJson) {
        if (packageJson != null && packageJson.hasKey("vaadin") && packageJson.getObject("vaadin").hasKey("hash")) {
            return packageJson.getObject("vaadin").getString("hash");
        }
        return null;
    }

    private static boolean dependenciesContainsAllPackages(Map<String, String> npmPackages, JsonObject dependencies) {
        List<String> collect = npmPackages.keySet().stream().filter(pkg -> !dependencies.hasKey(pkg) || !TaskRunDevBundleBuild.versionAccepted(dependencies.getString(pkg), (String)npmPackages.get(pkg))).collect(Collectors.toList());
        if (!collect.isEmpty()) {
            collect.forEach(dependency -> TaskRunDevBundleBuild.getLogger().info("Dependency " + dependency + " is missing from the bundle"));
            return false;
        }
        return true;
    }

    private static void getPackagedThemeJsonContents(File jarFileToLookup, Map<String, JsonObject> packagedThemeHashes) {
        JarContentsManager jarContentsManager = new JarContentsManager();
        if (jarContentsManager.containsPath(jarFileToLookup, "META-INF/resources/themes/")) {
            List<String> themeJsons = jarContentsManager.findFiles(jarFileToLookup, "META-INF/resources/themes/", "theme.json");
            for (String themeJson : themeJsons) {
                byte[] byteContent = jarContentsManager.getFileContents(jarFileToLookup, themeJson);
                String content = IOUtils.toString((byte[])byteContent, (String)"UTF-8");
                content = content.replaceAll("\\r\\n", "\n");
                Matcher matcher = THEME_PATH_PATTERN.matcher(themeJson);
                if (!matcher.find()) {
                    throw new IllegalStateException("Packaged theme folders structure is incorrect, should have META-INF/resources/themes/[theme-name]/");
                }
                String themeName = matcher.group(1);
                JsonObject jsonContent = Json.parse((String)content);
                packagedThemeHashes.put(themeName, jsonContent);
            }
        }
    }

    private static Optional<JsonObject> getContentForProjectThemeJson(Options options, ThemeDefinition themeDefinition) throws IOException {
        if (themeDefinition != null) {
            String themeName = themeDefinition.getName();
            File projectThemeJson = new File(options.getFrontendDirectory(), "themes/" + themeName + "/theme.json");
            if (projectThemeJson.exists()) {
                String content = FileUtils.readFileToString((File)projectThemeJson, (Charset)StandardCharsets.UTF_8);
                content = content.replaceAll("\\r\\n", "\n");
                return Optional.of(Json.parse((String)content));
            }
        }
        return Optional.empty();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(TaskRunDevBundleBuild.class);
    }

    private void runFrontendBuildTool(String toolName, String executable, Map<String, String> environment, String ... params) throws ExecutionFailedException {
        Logger logger = TaskRunDevBundleBuild.getLogger();
        FrontendToolsSettings settings = new FrontendToolsSettings(this.options.getNpmFolder().getAbsolutePath(), () -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath());
        settings.setNodeDownloadRoot(this.options.getNodeDownloadRoot());
        settings.setForceAlternativeNode(this.options.isRequireHomeNodeExec());
        settings.setUseGlobalPnpm(this.options.isUseGlobalPnpm());
        settings.setAutoUpdate(this.options.isNodeAutoUpdate());
        settings.setNodeVersion(this.options.getNodeVersion());
        FrontendTools frontendTools = new FrontendTools(settings);
        File buildExecutable = new File(this.options.getNpmFolder(), "node_modules/" + executable);
        if (!buildExecutable.isFile()) {
            throw new IllegalStateException(String.format("Unable to locate %s executable by path '%s'. Double check that the plugin is executed correctly", toolName, buildExecutable.getAbsolutePath()));
        }
        String nodePath = this.options.isRequireHomeNodeExec() ? frontendTools.forceAlternativeNodeExecutable() : frontendTools.getNodeExecutable();
        ArrayList<String> command = new ArrayList<String>();
        command.add(nodePath);
        command.add(buildExecutable.getAbsolutePath());
        command.addAll(Arrays.asList(params));
        String commandString = command.stream().collect(Collectors.joining(" "));
        ProcessBuilder builder = FrontendUtils.createProcessBuilder(command);
        builder.environment().put("devBundle", "true");
        Process process = null;
        try {
            builder.directory(this.options.getNpmFolder());
            builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
            builder.redirectError(ProcessBuilder.Redirect.INHERIT);
            process = builder.start();
            Runtime.getRuntime().addShutdownHook(new Thread(process::destroyForcibly));
            logger.debug("Output of `{}`:", (Object)commandString);
            StringBuilder toolOutput = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String stdoutLine;
                while ((stdoutLine = reader.readLine()) != null) {
                    logger.debug(stdoutLine);
                    toolOutput.append(stdoutLine).append(System.lineSeparator());
                }
            }
            int errorCode = process.waitFor();
            if (errorCode != 0) {
                logger.error("Command `{}` failed:\n{}", (Object)commandString, (Object)toolOutput);
                throw new ExecutionFailedException(SharedUtil.capitalize(toolName) + " build exited with a non zero status");
            }
            logger.info("Development frontend bundle built");
        }
        catch (IOException | InterruptedException e) {
            logger.error("Error when running `{}`", (Object)commandString, (Object)e);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new ExecutionFailedException("Command '" + commandString + "' failed to finish", e);
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
    }

    private static void cleanOldPlatformDependencies(JsonObject packageJson) {
        if (packageJson == null || !TaskRunDevBundleBuild.hasFrameworkDependencyObjects(packageJson)) {
            return;
        }
        JsonObject dependencies = packageJson.getObject("dependencies");
        JsonObject vaadinDependencies = packageJson.getObject("vaadin").getObject("dependencies");
        for (String vaadinDependency : vaadinDependencies.keys()) {
            String version = vaadinDependencies.getString(vaadinDependency);
            if (!dependencies.hasKey(vaadinDependency) || !version.equals(dependencies.getString(vaadinDependency))) continue;
            dependencies.remove(vaadinDependency);
            TaskRunDevBundleBuild.getLogger().debug("Old Vaadin provided dependency '{}':'{}' has been removed from package.json", (Object)vaadinDependency, (Object)version);
        }
    }

    private static boolean hasFrameworkDependencyObjects(JsonObject packageJson) {
        return packageJson.hasKey("vaadin") && packageJson.getObject("vaadin").hasKey("dependencies") && packageJson.hasKey("dependencies");
    }

    private static String getTag(WebComponentExporterFactory<? extends Component> factory) {
        WebComponentExporterTagExtractor exporterTagExtractor = new WebComponentExporterTagExtractor();
        return exporterTagExtractor.apply(factory);
    }

    private static boolean compareObjects(Collection<String> missedKeys, JsonObject jsonObjectFromBundle, JsonObject projectJsonObject) {
        boolean allEntriesFound = true;
        for (String projectEntryKey : projectJsonObject.keys()) {
            JsonValue projectEntry = projectJsonObject.get(projectEntryKey);
            if (projectEntry.getType() == JsonType.STRING && "parent".equals(projectEntryKey)) continue;
            boolean entryFound = false;
            for (String bundleEntryKey : jsonObjectFromBundle.keys()) {
                JsonValue bundleEntry = jsonObjectFromBundle.get(bundleEntryKey);
                if (bundleEntry.getType() != projectEntry.getType() || !TaskRunDevBundleBuild.objectIncludesEntry(bundleEntry, projectEntry, missedKeys)) continue;
                entryFound = true;
                break;
            }
            if (!entryFound) {
                missedKeys.add(projectEntryKey);
            }
            allEntriesFound = allEntriesFound && entryFound;
        }
        return allEntriesFound;
    }

    private static boolean compareArrays(Collection<String> missedKeys, JsonArray jsonArrayFromBundle, JsonArray projectJsonArray) {
        boolean allEntriesFound = true;
        for (int projectArrayIndex = 0; projectArrayIndex < projectJsonArray.length(); ++projectArrayIndex) {
            JsonValue projectArrayEntry = projectJsonArray.get(projectArrayIndex);
            boolean entryFound = false;
            for (int bundleArrayIndex = 0; bundleArrayIndex < jsonArrayFromBundle.length(); ++bundleArrayIndex) {
                JsonValue bundleArrayEntry = jsonArrayFromBundle.get(bundleArrayIndex);
                if (bundleArrayEntry.getType() != projectArrayEntry.getType() || !TaskRunDevBundleBuild.objectIncludesEntry(bundleArrayEntry, projectArrayEntry, missedKeys)) continue;
                entryFound = true;
                break;
            }
            if (!entryFound) {
                missedKeys.add(projectArrayEntry.toJson());
            }
            allEntriesFound = allEntriesFound && entryFound;
        }
        return allEntriesFound;
    }

    private void addReadme() {
        File devBundleFolder = new File(this.options.getNpmFolder(), "src/main/dev-bundle");
        assert (devBundleFolder.exists());
        try {
            File readme = new File(devBundleFolder, "README.md");
            boolean created = readme.createNewFile();
            if (created) {
                FileUtils.writeStringToFile((File)readme, (String)README, (Charset)StandardCharsets.UTF_8);
            } else {
                TaskRunDevBundleBuild.getLogger().warn(README_NOT_CREATED);
            }
        }
        catch (Exception e) {
            TaskRunDevBundleBuild.getLogger().error(README_NOT_CREATED, (Throwable)e);
        }
    }
}

