/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.springcsrf;

import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.internal.springcsrf.SpringCsrfToken;
import com.vaadin.flow.server.VaadinRequest;
import elemental.json.JsonObject;
import jakarta.servlet.ServletRequest;
import java.util.Optional;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class SpringCsrfTokenUtil {
    private static final String CONTENT_ATTRIBUTE = "content";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String SPRING_CSRF_TOKEN_ATTRIBUTE_IN_REQUEST = "org.springframework.security.web.csrf.CsrfToken";
    private static final String SPRING_CSRF_HEADER_PROPERTY = "headerName";
    private static final String SPRING_CSRF_PARAMETER_PROPERTY = "parameterName";
    private static final String SPRING_CSRF_TOKEN_PROPERTY = "token";
    private static final String SPRING_CSRF_PARAMETER_NAME_ATTRIBUTE = "_csrf_parameter";
    private static final String SPRING_CSRF_HEADER_NAME_ATTRIBUTE = "_csrf_header";
    private static final String SPRING_CSRF_TOKEN_ATTRIBUTE = "_csrf";
    private static final String META_TAG = "meta";

    private SpringCsrfTokenUtil() {
    }

    public static Optional<SpringCsrfToken> getSpringCsrfToken(VaadinRequest request) {
        Object springCsrfToken = request.getAttribute(SPRING_CSRF_TOKEN_ATTRIBUTE_IN_REQUEST);
        return SpringCsrfTokenUtil.extractTokenFromBean(springCsrfToken);
    }

    public static Optional<SpringCsrfToken> getSpringCsrfToken(ServletRequest request) {
        Object springCsrfToken = request.getAttribute(SPRING_CSRF_TOKEN_ATTRIBUTE_IN_REQUEST);
        return SpringCsrfTokenUtil.extractTokenFromBean(springCsrfToken);
    }

    private static Optional<SpringCsrfToken> extractTokenFromBean(Object springCsrfToken) {
        JsonObject springCsrfTokenJson;
        if (springCsrfToken != null && (springCsrfTokenJson = JsonUtils.beanToJson(springCsrfToken)) != null && springCsrfTokenJson.hasKey(SPRING_CSRF_TOKEN_PROPERTY) && springCsrfTokenJson.hasKey(SPRING_CSRF_HEADER_PROPERTY)) {
            String token = springCsrfTokenJson.getString(SPRING_CSRF_TOKEN_PROPERTY);
            String headerName = springCsrfTokenJson.getString(SPRING_CSRF_HEADER_PROPERTY);
            String parameterName = springCsrfTokenJson.getString(SPRING_CSRF_PARAMETER_PROPERTY);
            return Optional.of(new SpringCsrfToken(headerName, parameterName, token));
        }
        return Optional.empty();
    }

    public static void addTokenAsMetaTagsToHeadIfPresentInRequest(Element head, VaadinRequest request) {
        Optional<SpringCsrfToken> springCsrfToken = SpringCsrfTokenUtil.getSpringCsrfToken(request);
        springCsrfToken.ifPresent(csrfToken -> {
            SpringCsrfTokenUtil.addMetaTagToHead(head, SPRING_CSRF_TOKEN_ATTRIBUTE, csrfToken.getToken());
            SpringCsrfTokenUtil.addMetaTagToHead(head, SPRING_CSRF_HEADER_NAME_ATTRIBUTE, csrfToken.getHeaderName());
            SpringCsrfTokenUtil.addMetaTagToHead(head, SPRING_CSRF_PARAMETER_NAME_ATTRIBUTE, csrfToken.getParameterName());
        });
    }

    private static void addMetaTagToHead(Element head, String name, String value) {
        Element meta = new Element(META_TAG);
        meta.attr(NAME_ATTRIBUTE, name);
        meta.attr(CONTENT_ATTRIBUTE, value);
        head.insertChildren(0, new Node[]{meta});
    }
}

