/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.router.ParentLayout;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RoutePathProvider;
import com.vaadin.flow.router.RoutePrefix;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteUtil {
    protected RouteUtil() {
    }

    public static List<Class<? extends RouterLayout>> getParentLayouts(VaadinContext context, Class<?> component, String path) {
        ArrayList<Class<? extends RouterLayout>> list = new ArrayList<Class<? extends RouterLayout>>();
        Optional<Route> route = AnnotationReader.getAnnotationFor(component, Route.class);
        List<RouteAlias> routeAliases = AnnotationReader.getAnnotationsFor(component, RouteAlias.class);
        if (route.isPresent() && path.equals(RouteUtil.getRoutePath(context, component)) && !route.get().layout().equals(UI.class)) {
            list.addAll(RouteUtil.collectRouteParentLayouts(route.get().layout()));
        } else {
            Optional<RouteAlias> matchingRoute = RouteUtil.getMatchingRouteAlias(component, path, routeAliases);
            if (matchingRoute.isPresent()) {
                list.addAll(RouteUtil.collectRouteParentLayouts(matchingRoute.get().layout()));
            }
        }
        return list;
    }

    public static String getRoutePath(VaadinContext context, Class<?> component) {
        Route route = component.getAnnotation(Route.class);
        if (route.absolute()) {
            return RouteUtil.resolve(context, component);
        }
        List<String> parentRoutePrefixes = RouteUtil.getRoutePrefixes(component, route.layout(), RouteUtil.resolve(context, component));
        return parentRoutePrefixes.stream().collect(Collectors.joining("/"));
    }

    public static String getRouteAliasPath(Class<?> component, RouteAlias alias) {
        if (alias.absolute()) {
            return alias.value();
        }
        List<String> parentRoutePrefixes = RouteUtil.getRoutePrefixes(component, alias.layout(), alias.value());
        return parentRoutePrefixes.stream().collect(Collectors.joining("/"));
    }

    private static List<String> getRoutePrefixes(Class<?> component, Class<? extends RouterLayout> layout, String value) {
        List<String> parentRoutePrefixes = RouteUtil.getParentRoutePrefixes(component, () -> layout);
        Collections.reverse(parentRoutePrefixes);
        if (value != null && !value.isEmpty()) {
            parentRoutePrefixes.add(value);
        }
        return parentRoutePrefixes;
    }

    private static List<String> getParentRoutePrefixes(Class<?> component, Supplier<Class<? extends RouterLayout>> routerLayoutSupplier) {
        ArrayList<String> list = new ArrayList<String>();
        Optional<ParentLayout> parentLayout = AnnotationReader.getAnnotationFor(component, ParentLayout.class);
        Optional<RoutePrefix> routePrefix = AnnotationReader.getAnnotationFor(component, RoutePrefix.class);
        routePrefix.ifPresent(prefix -> list.add(prefix.value()));
        if (routePrefix.isPresent() && routePrefix.get().absolute()) {
            return list;
        }
        Class<? extends RouterLayout> routerLayout = routerLayoutSupplier.get();
        if (routerLayout != null && !routerLayout.equals(UI.class)) {
            list.addAll(RouteUtil.getParentRoutePrefixes(routerLayout, () -> null));
        } else if (parentLayout.isPresent()) {
            list.addAll(RouteUtil.getParentRoutePrefixes(parentLayout.get().value(), () -> null));
        }
        return list;
    }

    static Optional<RouteAlias> getMatchingRouteAlias(Class<?> component, String path, List<RouteAlias> routeAliases) {
        return routeAliases.stream().filter(alias -> path.equals(RouteUtil.getRouteAliasPath(component, alias)) && !alias.layout().equals(UI.class)).findFirst();
    }

    static List<Class<? extends RouterLayout>> collectRouteParentLayouts(Class<? extends RouterLayout> layout) {
        ArrayList<Class<? extends RouterLayout>> layouts = new ArrayList<Class<? extends RouterLayout>>();
        layouts.add(layout);
        Optional<ParentLayout> parentLayout = AnnotationReader.getAnnotationFor(layout, ParentLayout.class);
        if (parentLayout.isPresent()) {
            layouts.addAll(RouteUtil.collectRouteParentLayouts(parentLayout.get().value()));
        }
        return layouts;
    }

    public static List<Class<? extends RouterLayout>> getParentLayoutsForNonRouteTarget(Class<?> navigationTarget) {
        ArrayList<Class<? extends RouterLayout>> layouts = new ArrayList<Class<? extends RouterLayout>>();
        Optional<ParentLayout> parentLayout = AnnotationReader.getAnnotationFor(navigationTarget, ParentLayout.class);
        if (parentLayout.isPresent()) {
            layouts.addAll(RouteUtil.collectRouteParentLayouts(parentLayout.get().value()));
        }
        return layouts;
    }

    public static Class<? extends RouterLayout> getTopParentLayout(VaadinContext context, Class<?> component, String path) {
        if (path == null) {
            Optional<ParentLayout> parentLayout = AnnotationReader.getAnnotationFor(component, ParentLayout.class);
            if (parentLayout.isPresent()) {
                return RouteUtil.recurseToTopLayout(parentLayout.get().value());
            }
            return null;
        }
        Optional<Route> route = AnnotationReader.getAnnotationFor(component, Route.class);
        List<RouteAlias> routeAliases = AnnotationReader.getAnnotationsFor(component, RouteAlias.class);
        if (route.isPresent() && path.equals(RouteUtil.getRoutePath(context, component)) && !route.get().layout().equals(UI.class)) {
            return RouteUtil.recurseToTopLayout(route.get().layout());
        }
        Optional<RouteAlias> matchingRoute = RouteUtil.getMatchingRouteAlias(component, path, routeAliases);
        if (matchingRoute.isPresent()) {
            return RouteUtil.recurseToTopLayout(matchingRoute.get().layout());
        }
        return null;
    }

    private static Class<? extends RouterLayout> recurseToTopLayout(Class<? extends RouterLayout> layout) {
        Optional<ParentLayout> parentLayout = AnnotationReader.getAnnotationFor(layout, ParentLayout.class);
        if (parentLayout.isPresent()) {
            return RouteUtil.recurseToTopLayout(parentLayout.get().value());
        }
        return layout;
    }

    public static String resolve(VaadinContext context, Class<?> component) {
        Lookup lookup = context.getAttribute(Lookup.class);
        RoutePathProvider provider = lookup.lookup(RoutePathProvider.class);
        assert (provider != null);
        return provider.getRoutePath(component);
    }

    public static void updateRouteRegistry(RouteRegistry registry, Set<Class<?>> addedClasses, Set<Class<?>> modifiedClasses, Set<Class<?>> deletedClasses) {
        RouteConfiguration routeConf = RouteConfiguration.forRegistry(registry);
        Logger logger = LoggerFactory.getLogger(RouteUtil.class);
        registry.update(() -> {
            Stream.concat(deletedClasses.stream(), modifiedClasses.stream().filter(clazz -> !clazz.isAnnotationPresent(Route.class))).filter(Component.class::isAssignableFrom).forEach(clazz -> {
                Class componentClass = clazz;
                logger.debug("Removing route to {}", (Object)componentClass);
                routeConf.removeRoute(componentClass);
            });
            Stream.concat(addedClasses.stream(), modifiedClasses.stream()).distinct().filter(Component.class::isAssignableFrom).filter(clazz -> clazz.isAnnotationPresent(Route.class)).forEach(clazz -> {
                Class componentClass = clazz;
                logger.debug("Updating route {} to {}", (Object)componentClass.getAnnotation(Route.class).value(), clazz);
                routeConf.removeRoute(componentClass);
                routeConf.setAnnotatedRoute(componentClass);
            });
        });
    }
}

