/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.internal.hilla.EndpointRequestUtil;
import com.vaadin.flow.server.Mode;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Paths;
import org.slf4j.LoggerFactory;

public interface AbstractConfiguration
extends Serializable {
    public boolean isProductionMode();

    @Deprecated
    default public boolean frontendHotdeploy() {
        if (this.isProductionMode()) {
            return false;
        }
        return this.getBooleanProperty("frontend.hotdeploy", EndpointRequestUtil.isHillaAvailable());
    }

    default public Mode getMode() {
        if (this.isProductionMode()) {
            return Mode.PRODUCTION;
        }
        if (this.frontendHotdeploy()) {
            return Mode.DEVELOPMENT_FRONTEND_LIVERELOAD;
        }
        return Mode.DEVELOPMENT_BUNDLE;
    }

    default public boolean reuseDevServer() {
        return this.getBooleanProperty("reuseDevServer", true);
    }

    public String getStringProperty(String var1, String var2);

    public boolean getBooleanProperty(String var1, boolean var2);

    default public boolean isPnpmEnabled() {
        return this.getBooleanProperty("pnpm.enable", false);
    }

    default public boolean isGlobalPnpm() {
        return this.getBooleanProperty("pnpm.global", false);
    }

    default public boolean isUsageStatisticsEnabled() {
        return !this.isProductionMode() && this.getBooleanProperty("devmode.usageStatistics.enabled", true);
    }

    default public boolean isXsrfProtectionEnabled() {
        return !this.getBooleanProperty("disable-xsrf-protection", false);
    }

    default public String getBuildFolder() {
        return this.getStringProperty("build.folder", "target");
    }

    default public File getProjectFolder() {
        Object path;
        if (this.isProductionMode()) {
            return null;
        }
        String folder = this.getStringProperty("project.basedir", null);
        if (folder == null) {
            try {
                URL url = this.getClass().getClassLoader().getResource(".");
                if (url != null && url.getProtocol().equals("file") && ((String)(path = url.toURI().getPath())).endsWith("/target/classes/")) {
                    folder = ((String)path).replaceFirst("/target/classes/$", "");
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).warn("Unable to determine project folder using classpath", (Throwable)e);
            }
        }
        if (folder == null) {
            String baseDirCandidate = System.getProperty("user.dir", ".");
            path = Paths.get(baseDirCandidate, new String[0]);
            if (path.toFile().isDirectory() && (path.resolve("pom.xml").toFile().exists() || path.resolve("build.gradle").toFile().exists())) {
                return path.toAbsolutePath().toFile();
            }
            throw new IllegalStateException(String.format("Failed to determine project directory for dev mode. Directory '%s' does not look like a Maven or Gradle project. Ensure that you have run the prepare-frontend Maven goal, which generates 'flow-build-info.json', prior to deploying your application", path.toString()));
        }
        return new File(folder);
    }

    default public File getJavaResourceFolder() {
        return new File(this.getStringProperty("javaResourceFolder", "src/main/resources"));
    }

    default public File getJavaSourceFolder() {
        return new File(this.getStringProperty("connect.javaSourceFolder", "src/main/java")).getAbsoluteFile();
    }
}

