/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.theme.ThemeDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public class TaskGenerateBootstrap
extends AbstractTaskClientGenerator {
    static final String DEV_TOOLS_IMPORT = String.format("import '%svaadin-dev-tools.js';%n", "Frontend/generated/jar-resources/vaadin-dev-tools/");
    private final FrontendDependenciesScanner frontDeps;
    private final Options options;

    TaskGenerateBootstrap(FrontendDependenciesScanner frontDeps, Options options) {
        this.frontDeps = frontDeps;
        this.options = options;
    }

    @Override
    protected String getFileContent() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(String.format("import './%s';%n", "vaadin-featureflags.ts"));
        lines.add(String.format("import '%s';%n", this.getIndexTsEntryPath()));
        if (!this.options.isProductionMode()) {
            lines.add(DEV_TOOLS_IMPORT);
        }
        lines.addAll(this.getThemeLines());
        return String.join((CharSequence)System.lineSeparator(), lines);
    }

    @Override
    protected File getGeneratedFile() {
        File frontendGeneratedDirectory = new File(this.options.getFrontendDirectory(), "generated/");
        return new File(frontendGeneratedDirectory, "vaadin.ts");
    }

    @Override
    protected boolean shouldGenerate() {
        return this.frontDeps != null;
    }

    private String getIndexTsEntryPath() {
        boolean hasCustomIndexFile;
        File frontendDirectory = this.options.getFrontendDirectory();
        boolean bl = hasCustomIndexFile = new File(frontendDirectory, "index.ts").exists() || new File(frontendDirectory, "index.js").exists() || new File(frontendDirectory, "index.tsx").exists();
        if (hasCustomIndexFile) {
            return "../index";
        }
        return "./index";
    }

    private Collection<String> getThemeLines() {
        ArrayList<String> lines = new ArrayList<String>();
        if (this.shouldApplyAppTheme()) {
            lines.add("import { applyTheme } from './theme.js';");
            lines.add("applyTheme(document);");
            lines.add("");
        }
        return lines;
    }

    private boolean shouldApplyAppTheme() {
        ThemeDefinition themeDef = this.frontDeps.getThemeDefinition();
        return themeDef != null && !"".equals(themeDef.getName());
    }
}

