/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.DeploymentConfigurationFactory;
import com.vaadin.flow.server.VaadinConfig;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletConfig;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRegistration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletDeployer
implements ServletContextListener {
    private static final String SKIPPING_AUTOMATIC_SERVLET_REGISTRATION_BECAUSE = "Skipping automatic servlet registration because";
    private String servletCreationMessage;

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        Collection<DeploymentConfiguration> servletConfigurations = this.getServletConfigurations(context);
        VaadinServletContext vaadinContext = new VaadinServletContext(context);
        ApplicationConfiguration config = ApplicationConfiguration.get(vaadinContext);
        boolean enableServlets = !config.disableAutomaticServletRegistration();
        boolean productionMode = false;
        for (DeploymentConfiguration configuration : servletConfigurations) {
            productionMode = productionMode || configuration.isProductionMode();
        }
        VaadinServletCreation servletCreation = enableServlets ? this.createAppServlet(context) : null;
        this.logServletCreation(servletCreation, context, productionMode);
    }

    private void logServletCreation(VaadinServletCreation servletCreation, ServletContext servletContext, boolean productionMode) {
        Logger logger = ServletDeployer.getLogger();
        if (servletCreation == null || productionMode) {
            if (this.servletCreationMessage != null) {
                logger.info(this.servletCreationMessage);
            }
        } else if (servletCreation == VaadinServletCreation.NO_CREATION) {
            logger.warn(this.servletCreationMessage);
        } else {
            logger.info(this.servletCreationMessage);
            ServletRegistration vaadinServlet = this.findVaadinServlet(servletContext);
            ServletDeployer.logAppStartupToConsole(servletContext, servletCreation == VaadinServletCreation.SERVLET_CREATED || vaadinServlet != null && "com.vaadin.cdi.CdiServletDeployer".equals(vaadinServlet.getName()));
        }
    }

    public static void logAppStartupToConsole(ServletContext servletContext, boolean servletAutomaticallyCreated) {
        if (servletAutomaticallyCreated) {
            String contextPath = servletContext.getContextPath();
            contextPath = contextPath.isEmpty() ? "/" : contextPath;
            FrontendUtils.console("\u001b[94m%s\u001b[0m", String.format("Vaadin application has been deployed and started to the context path \"%s\".%n", contextPath));
        } else {
            FrontendUtils.console("\u001b[94m%s\u001b[0m", String.format("Vaadin application has been deployed and started.%n", new Object[0]));
        }
    }

    private Collection<DeploymentConfiguration> getServletConfigurations(ServletContext context) {
        Collection registrations = context.getServletRegistrations().values();
        ArrayList<DeploymentConfiguration> result = new ArrayList<DeploymentConfiguration>(registrations.size());
        for (ServletRegistration registration : registrations) {
            this.loadClass(context.getClassLoader(), registration.getClassName()).ifPresent(servletClass -> result.add(StubServletConfig.createDeploymentConfiguration(context, registration, servletClass)));
        }
        return result;
    }

    private VaadinServletCreation createAppServlet(ServletContext servletContext) {
        ServletRegistration vaadinServlet = this.findVaadinServlet(servletContext);
        if (vaadinServlet != null) {
            this.servletCreationMessage = String.format("%s there is already a Vaadin servlet with the name %s", SKIPPING_AUTOMATIC_SERVLET_REGISTRATION_BECAUSE, vaadinServlet.getName());
            return VaadinServletCreation.SERVLET_EXISTS;
        }
        return this.createServletIfNotExists(servletContext, this.getClass().getName(), VaadinServlet.class, "/*");
    }

    private VaadinServletCreation createServletIfNotExists(ServletContext context, String name, Class<? extends Servlet> servletClass, String path) {
        return this.createServletIfNotExists(context, name, servletClass, path, null);
    }

    private VaadinServletCreation createServletIfNotExists(ServletContext context, String name, Class<? extends Servlet> servletClass, String path, Map<String, String> initParams) {
        ServletRegistration existingServlet = this.findServletByPathPart(context, path);
        if (existingServlet != null) {
            this.servletCreationMessage = String.format("%s there is already a %s servlet with the name %s for path %s given", SKIPPING_AUTOMATIC_SERVLET_REGISTRATION_BECAUSE, existingServlet, existingServlet.getName(), path);
            return VaadinServletCreation.SERVLET_EXISTS;
        }
        ServletRegistration.Dynamic registration = context.addServlet(name, servletClass);
        if (initParams != null) {
            registration.setInitParameters(initParams);
        }
        if (registration == null) {
            this.servletCreationMessage = String.format("%s there is already a servlet with the name %s", SKIPPING_AUTOMATIC_SERVLET_REGISTRATION_BECAUSE, name);
            return VaadinServletCreation.NO_CREATION;
        }
        this.servletCreationMessage = String.format("Automatically deploying Vaadin servlet with name %s to %s", name, path);
        registration.setAsyncSupported(true);
        registration.addMapping(new String[]{path});
        registration.setLoadOnStartup(1);
        return VaadinServletCreation.SERVLET_CREATED;
    }

    private ServletRegistration findServletByPathPart(ServletContext context, String path) {
        return context.getServletRegistrations().values().stream().filter(registration -> registration.getMappings().contains(path)).findAny().orElse(null);
    }

    private ServletRegistration findVaadinServlet(ServletContext context) {
        return context.getServletRegistrations().values().stream().filter(registration -> this.isVaadinServlet(context.getClassLoader(), registration.getClassName())).findAny().orElse(null);
    }

    private boolean isVaadinServlet(ClassLoader classLoader, String className) {
        return this.loadClass(classLoader, className).map(VaadinServlet.class::isAssignableFrom).orElse(false);
    }

    private Optional<Class<?>> loadClass(ClassLoader classLoader, String className) {
        try {
            return Optional.of(classLoader.loadClass(className));
        }
        catch (ClassNotFoundException e) {
            ServletDeployer.getLogger().warn("Failed to load class {}, ignoring it when deploying Vaadin servlets", (Object)className, (Object)e);
            return Optional.empty();
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)ServletDeployer.class.getName());
    }

    private static enum VaadinServletCreation {
        NO_CREATION,
        SERVLET_EXISTS,
        SERVLET_CREATED;

    }

    private static class StubServletConfig
    implements ServletConfig {
        private final ServletContext context;
        private final ServletRegistration registration;

        public StubServletConfig(ServletContext context, ServletRegistration registration) {
            this.context = context;
            this.registration = registration;
        }

        public String getServletName() {
            return this.registration.getName();
        }

        public ServletContext getServletContext() {
            return this.context;
        }

        public String getInitParameter(String name) {
            return (String)this.registration.getInitParameters().get(name);
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(this.registration.getInitParameters().keySet());
        }

        public static DeploymentConfiguration createDeploymentConfiguration(ServletContext context, ServletRegistration registration, Class<?> servletClass) {
            StubServletConfig servletConfig = new StubServletConfig(context, registration);
            return new DeploymentConfigurationFactory().createPropertyDeploymentConfiguration(servletClass, new VaadinServletConfig(servletConfig));
        }
    }

    private static class VaadinServletContextConfig
    implements VaadinConfig {
        private transient ServletContext servletContext;

        private VaadinServletContextConfig(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        private void ensureServletContext() {
            if (this.servletContext == null && VaadinService.getCurrent() instanceof VaadinServletService) {
                this.servletContext = ((VaadinServletService)VaadinService.getCurrent()).getServlet().getServletContext();
            } else if (this.servletContext == null) {
                throw new IllegalStateException("The underlying ServletContext of VaadinServletContext is null and there is no VaadinServletService to obtain it from.");
            }
        }

        @Override
        public VaadinContext getVaadinContext() {
            this.ensureServletContext();
            return new VaadinServletContext(this.servletContext);
        }

        @Override
        public Enumeration<String> getConfigParameterNames() {
            return Collections.emptyEnumeration();
        }

        @Override
        public String getConfigParameter(String name) {
            return null;
        }
    }
}

