/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.internal.UrlUtil;
import com.vaadin.flow.server.frontend.BundleUtils;
import com.vaadin.flow.server.frontend.FileIOUtils;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.ImportExtractor;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.scanner.ChunkInfo;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.CssData;
import com.vaadin.flow.server.frontend.scanner.EntryPointType;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.theme.AbstractTheme;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;

abstract class AbstractUpdateImports
implements Runnable {
    private static final String CSS_PREPARE = "function addCssBlock(block) {\n const tpl = document.createElement('template');\n tpl.innerHTML = block;\n document.head.appendChild(tpl.content);\n}";
    private static final String IMPORT_INJECT = "import { injectGlobalCss } from 'Frontend/generated/jar-resources/theme-util.js';\n";
    private static final String CSS_IMPORT = "import $cssFromFile_%d from '%s';%n";
    private static final String CSS_IMPORT_AND_MAKE_LIT_CSS = "import $cssFromFile_%d from '%s';%nconst $css_%1$d = typeof $cssFromFile_%1$d  === 'string' ? unsafeCSS($cssFromFile_%1$d) : $cssFromFile_%1$d;";
    private static final String CSS_PRE = "import $cssFromFile_%d from '%s';%nconst $css_%1$d = typeof $cssFromFile_%1$d  === 'string' ? unsafeCSS($cssFromFile_%1$d) : $cssFromFile_%1$d;%naddCssBlock(`";
    private static final String CSS_POST = "`);";
    private static final String CSS_BASIC_TPL = "import $cssFromFile_%d from '%s';%nconst $css_%1$d = typeof $cssFromFile_%1$d  === 'string' ? unsafeCSS($cssFromFile_%1$d) : $cssFromFile_%1$d;%naddCssBlock(`<style%s>${$css_%1$d}</style>`);";
    private static final String INJECT_CSS = "import $cssFromFile_%d from '%s';%n%ninjectGlobalCss($cssFromFile_%1$d.toString(), 'CSSImport end', document);%n";
    private static final String THEMABLE_MIXIN_IMPORT = "import { css, unsafeCSS, registerStyles } from '@vaadin/vaadin-themable-mixin';";
    private static final String REGISTER_STYLES_FOR_TEMPLATE = "import $cssFromFile_%d from '%s';%nconst $css_%1$d = typeof $cssFromFile_%1$d  === 'string' ? unsafeCSS($cssFromFile_%1$d) : $cssFromFile_%1$d;%nregisterStyles('%s', $css_%1$d%s);";
    private static final String IMPORT_TEMPLATE = "import '%s';";
    final Options options;
    private FrontendDependenciesScanner scanner;
    private ClassFinder classFinder;
    private final File generatedFlowImports;
    private final File generatedFlowDefinitions;
    private File chunkFolder;

    AbstractUpdateImports(Options options, FrontendDependenciesScanner scanner, ClassFinder classFinder) {
        this.options = options;
        this.scanner = scanner;
        this.classFinder = classFinder;
        this.generatedFlowImports = FrontendUtils.getFlowGeneratedImports(options.getFrontendDirectory());
        this.generatedFlowDefinitions = new File(this.generatedFlowImports.getParentFile(), "generated-flow-imports.d.ts");
        this.chunkFolder = new File(this.generatedFlowImports.getParentFile(), "chunks");
    }

    @Override
    public void run() {
        this.getLogger().debug("Start updating imports file and chunk files.");
        long start = System.nanoTime();
        Map<ChunkInfo, List<CssData>> css = this.scanner.getCss();
        Map<ChunkInfo, List<String>> modules = this.scanner.getModules();
        Map<ChunkInfo, List<String>> scripts = this.scanner.getScripts();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Found {} modules, {} scripts and {} css.", new Object[]{modules.size(), scripts.size(), css.size()});
        }
        Map<ChunkInfo, List<String>> javascript = this.mergeJavascript(modules, scripts);
        Map<File, List<String>> output = this.process(css, javascript);
        this.writeOutput(output);
        this.getLogger().debug("Imports and chunks update took {} ms.", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    protected void writeOutput(Map<File, List<String>> outputFiles) {
        try {
            for (Map.Entry<File, List<String>> output : outputFiles.entrySet()) {
                FileIOUtils.writeIfChanged(output.getKey(), output.getValue());
            }
            if (this.chunkFolder.exists() && this.chunkFolder.isDirectory()) {
                for (File existingChunk : this.chunkFolder.listFiles()) {
                    if (outputFiles.containsKey(existingChunk)) continue;
                    existingChunk.delete();
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to update the generated Flow imports", e);
        }
    }

    private Map<File, List<String>> process(Map<ChunkInfo, List<CssData>> css, Map<ChunkInfo, List<String>> javascript) {
        this.getLogger().debug("Start sorting imports to lazy and eager.");
        long start = System.nanoTime();
        HashMap<File, List<String>> files = new HashMap<File, List<String>>();
        LinkedHashMap<ChunkInfo, List<String>> lazyJavascript = new LinkedHashMap<ChunkInfo, List<String>>();
        ArrayList<String> eagerJavascript = new ArrayList<String>();
        LinkedHashMap<ChunkInfo, List<String>> lazyCss = new LinkedHashMap<ChunkInfo, List<String>>();
        ArrayList<CssData> eagerCssData = new ArrayList<CssData>();
        for (Map.Entry<ChunkInfo, List<String>> entry : javascript.entrySet()) {
            if (this.isLazyRoute(entry.getKey())) {
                lazyJavascript.put(entry.getKey(), entry.getValue());
                continue;
            }
            eagerJavascript.addAll((Collection)entry.getValue());
        }
        for (Map.Entry<ChunkInfo, List<Object>> entry : css.entrySet()) {
            boolean hasThemeFor = entry.getValue().stream().anyMatch(cssData -> cssData.getThemefor() != null);
            if (this.isLazyRoute(entry.getKey()) && !hasThemeFor) {
                List<String> cssLines = this.getCssLines(entry.getValue());
                if (cssLines.isEmpty()) continue;
                lazyCss.put(entry.getKey(), cssLines);
                continue;
            }
            eagerCssData.addAll((Collection)entry.getValue());
        }
        this.getLogger().debug("Imports sorting took {} ms.", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
        ArrayList<String> chunkLoader = new ArrayList<String>();
        if (!lazyJavascript.isEmpty() || !lazyCss.isEmpty()) {
            this.getLogger().debug("Start generating lazy loaded chunks.");
            start = System.nanoTime();
            chunkLoader.add("");
            chunkLoader.add("const loadOnDemand = (key) => {");
            chunkLoader.add("  const pending = [];");
            Set<ChunkInfo> set = this.merge(lazyJavascript.keySet(), lazyCss.keySet());
            HashSet<String> processedChunkHashes = new HashSet<String>(set.size());
            for (ChunkInfo chunkInfo : set) {
                ArrayList<String> chunkLines = new ArrayList<String>();
                if (lazyJavascript.containsKey(chunkInfo)) {
                    chunkLines.addAll(this.getModuleLines((Collection)lazyJavascript.get(chunkInfo)));
                }
                if (lazyCss.containsKey(chunkInfo)) {
                    chunkLines.add(IMPORT_INJECT);
                    chunkLines.add(THEMABLE_MIXIN_IMPORT);
                    chunkLines.addAll((Collection)lazyCss.get(chunkInfo));
                }
                if (chunkLines.isEmpty()) continue;
                Collections.sort(chunkLines);
                String chunkContentHash = BundleUtils.getChunkHash(chunkLines);
                String chunkFilename = "chunk-" + chunkContentHash + ".js";
                String ifClauses = chunkInfo.getDependencyTriggers().stream().map(BundleUtils::getChunkId).map(hash -> String.format("key === '%s'", hash)).collect(Collectors.joining(" || "));
                chunkLoader.add(String.format("  if (%s) {", ifClauses));
                chunkLoader.add(String.format("    pending.push(import('./chunks/%s'));", chunkFilename));
                chunkLoader.add("  }");
                boolean chunkNotExist = processedChunkHashes.add(chunkContentHash);
                if (!chunkNotExist) continue;
                File chunkFile = new File(this.chunkFolder, chunkFilename);
                files.put(chunkFile, chunkLines);
            }
            chunkLoader.add("  return Promise.all(pending);");
            chunkLoader.add("}");
            chunkLoader.add("");
            this.getLogger().debug("Lazy chunks generation took {} ms.", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
        } else {
            chunkLoader.add("const loadOnDemand = (key) => { return Promise.resolve(0); }");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> mainCssLines = this.getCssLines(eagerCssData);
        if (!mainCssLines.isEmpty()) {
            arrayList.add(IMPORT_INJECT);
            arrayList.add(THEMABLE_MIXIN_IMPORT);
            arrayList.addAll(mainCssLines);
        }
        arrayList.addAll(this.getModuleLines(eagerJavascript));
        arrayList.addAll(chunkLoader);
        arrayList.add("window.Vaadin = window.Vaadin || {};");
        arrayList.add("window.Vaadin.Flow = window.Vaadin.Flow || {};");
        arrayList.add("window.Vaadin.Flow.loadOnDemand = loadOnDemand;");
        files.put(this.generatedFlowImports, arrayList);
        files.put(this.generatedFlowDefinitions, Collections.singletonList("export {}"));
        return files;
    }

    private boolean isLazyRoute(ChunkInfo key) {
        if (key.getType() != EntryPointType.ROUTE) {
            return false;
        }
        return !key.isEager();
    }

    private URL getResource(String name) {
        return this.classFinder.getResource(name);
    }

    Collection<String> getGeneratedModules() {
        return NodeUpdater.getGeneratedModules(this.options.getFrontendDirectory());
    }

    protected abstract Logger getLogger();

    List<String> resolveModules(Collection<String> modules) {
        return modules.stream().filter(module -> !module.startsWith("context://") && !module.startsWith("base://")).filter(module -> !UrlUtil.isExternal(module)).map(module -> this.resolveResource((String)module)).collect(Collectors.toList());
    }

    private Collection<? extends String> resolveGeneratedModules(Collection<String> generatedModules) {
        return generatedModules.stream().map(module -> this.resolveGeneratedModule((String)module)).collect(Collectors.toList());
    }

    String resolveGeneratedModule(String module) {
        return "Frontend/generated/flow/" + module;
    }

    protected List<String> getCssLines(List<CssData> css) {
        ArrayList<String> lines = new ArrayList<String>();
        HashSet<String> cssNotFound = new HashSet<String>();
        LinkedHashSet<CssData> allCss = new LinkedHashSet<CssData>(css);
        int i = 0;
        for (CssData cssData : allCss) {
            if (!this.addCssLines(lines, cssData, i)) {
                cssNotFound.add(cssData.getValue());
            }
            ++i;
        }
        if (!cssNotFound.isEmpty()) {
            String prefix = String.format("Failed to find the following css files in the `node_modules` or `%s` directory tree:", this.options.getFrontendDirectory().getPath());
            String suffix = this.options.getTokenFile() == null && !this.options.getFrontendDirectory().exists() ? "Unable to locate frontend resources and missing token file. Please run the `prepare-frontend` Vaadin plugin goal before deploying the application" : String.format("Check that they exist or are installed. If you use a custom directory for your resource files instead of the default `frontend` folder then make sure it's correctly configured (e.g. set '%s' property)", "vaadin.frontend.frontend.folder");
            throw new IllegalStateException(this.notFoundMessage(cssNotFound, prefix, suffix));
        }
        return lines;
    }

    protected String resolveResource(String importPath) {
        String resource;
        Object resolved = importPath;
        if (!importPath.startsWith("@") && this.hasMetaInfResource(resource = ((String)resolved).replaceFirst("^\\./+", ""))) {
            if (!((String)resolved).startsWith("./")) {
                this.getLogger().warn("Use the './' prefix for files in JAR files: '{}', please update your component.", (Object)importPath);
            }
            resolved = FrontendUtils.JAR_RESOURCES_IMPORT_FRONTEND_RELATIVE + resource;
        }
        return resolved;
    }

    protected void addLines(Collection<String> lines, String content) {
        lines.addAll(Arrays.asList(content.split("\\R")));
    }

    protected String getThemeIdPrefix() {
        return "flow_css_mod";
    }

    protected abstract String getImportsNotFoundMessage();

    private Map<ChunkInfo, List<String>> mergeJavascript(Map<ChunkInfo, List<String>> modules, Map<ChunkInfo, List<String>> scripts) {
        this.getLogger().debug("Start collecting scanned JS modules and scripts.");
        long start = System.nanoTime();
        LinkedHashMap<ChunkInfo, List<String>> result = new LinkedHashMap<ChunkInfo, List<String>>();
        Collection<? extends String> generated = this.resolveGeneratedModules(this.getGeneratedModules());
        for (Map.Entry<ChunkInfo, List<String>> entry : modules.entrySet()) {
            result.computeIfAbsent(entry.getKey(), e -> new ArrayList()).addAll(this.resolveModules((Collection<String>)entry.getValue()));
        }
        for (Map.Entry<ChunkInfo, List<String>> entry : scripts.entrySet()) {
            result.computeIfAbsent(entry.getKey(), e -> new ArrayList()).addAll(this.resolveModules((Collection<String>)entry.getValue()));
        }
        result.computeIfAbsent(ChunkInfo.GLOBAL, e -> new ArrayList()).addAll(generated);
        this.getLogger().debug("JS modules and scripts collected in {} ms.", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
        return result;
    }

    protected <T> List<String> merge(Map<T, List<String>> css) {
        ArrayList<String> result = new ArrayList<String>();
        css.forEach((key, value) -> result.addAll((Collection<String>)value));
        return result;
    }

    private Set<ChunkInfo> merge(Set<ChunkInfo> set1, Set<ChunkInfo> set2) {
        HashSet<ChunkInfo> set = new HashSet<ChunkInfo>(set1);
        set.addAll(set2);
        return set;
    }

    private Set<String> getUniqueEs6ImportPaths(Collection<String> modules) {
        boolean needsNodeModules;
        HashSet<String> npmNotFound = new HashSet<String>();
        HashSet<String> resourceNotFound = new HashSet<String>();
        LinkedHashSet<String> es6ImportPaths = new LinkedHashSet<String>();
        AbstractTheme theme = this.scanner.getTheme();
        HashSet<String> visited = new HashSet<String>();
        Iterator<String> iterator = modules.iterator();
        while (iterator.hasNext()) {
            String originalModulePath;
            String translatedModulePath = originalModulePath = iterator.next();
            String localModulePath = null;
            if (theme != null && translatedModulePath.contains(theme.getBaseUrl())) {
                translatedModulePath = theme.translateUrl(translatedModulePath);
                String themePath = theme.getThemeUrl();
                localModulePath = translatedModulePath.replaceFirst("@.+" + themePath, themePath);
            }
            if (localModulePath != null && this.frontendFileExists(localModulePath)) {
                es6ImportPaths.add(this.toValidBrowserImport(localModulePath));
            } else if (this.isGeneratedFlowFile(translatedModulePath)) {
                es6ImportPaths.add(translatedModulePath);
            } else if (this.importedFileExists(translatedModulePath)) {
                es6ImportPaths.add(this.toValidBrowserImport(translatedModulePath));
            } else if (this.importedFileExists(originalModulePath)) {
                es6ImportPaths.add(this.toValidBrowserImport(originalModulePath));
            } else if (originalModulePath.startsWith("./")) {
                resourceNotFound.add(originalModulePath);
            } else {
                npmNotFound.add(originalModulePath);
                es6ImportPaths.add(originalModulePath);
            }
            if (theme == null) continue;
            this.handleImports(originalModulePath, theme, es6ImportPaths, visited);
        }
        if (!resourceNotFound.isEmpty()) {
            String prefix = "Failed to find the following files: ";
            String suffix = this.options.getTokenFile() == null && !this.options.getFrontendDirectory().exists() ? "Unable to locate frontend resources and missing token file. Please run the `prepare-frontend` Vaadin plugin goal before deploying the application" : String.format("%n  Locations searched were:%n      - `%s` in this project%n      - `%s` in included JARs%n      - `%s` in included JARs%n%n  Please, double check that those files exist. If you use a custom directory for your resource files instead of default `frontend` folder then make sure you it's correctly configured (e.g. set '%s' property)", this.options.getFrontendDirectory().getPath(), "META-INF/frontend", "META-INF/resources/frontend", "vaadin.frontend.frontend.folder");
            if (this.inMemoryCollection()) {
                es6ImportPaths.addAll(resourceNotFound);
                return es6ImportPaths;
            }
            throw new IllegalStateException(this.notFoundMessage(resourceNotFound, prefix, suffix));
        }
        boolean bl = needsNodeModules = this.options.isFrontendHotdeploy() || this.options.isBundleBuild();
        if (!npmNotFound.isEmpty() && this.getLogger().isInfoEnabled() && needsNodeModules) {
            this.getLogger().info(this.notFoundMessage(npmNotFound, "Failed to find the following imports in the `node_modules` tree:", this.getImportsNotFoundMessage()));
        }
        return es6ImportPaths;
    }

    private boolean isGeneratedFlowFile(String localModulePath) {
        return localModulePath.startsWith("Frontend/generated/flow/");
    }

    protected boolean inMemoryCollection() {
        return false;
    }

    private List<String> getModuleLines(Collection<String> modules) {
        return this.getUniqueEs6ImportPaths(modules).stream().map(path -> String.format(IMPORT_TEMPLATE, path)).collect(Collectors.toList());
    }

    private boolean frontendFileExists(String jsImport) {
        File file = this.getFile(this.options.getFrontendDirectory(), jsImport);
        return file.exists();
    }

    protected boolean importedFileExists(String importName) {
        File file = this.getImportedFrontendFile(importName);
        if (file != null) {
            return true;
        }
        boolean found = this.isFile(this.options.getNodeModulesFolder(), importName);
        if (importName.toLowerCase().endsWith(".css")) {
            return found;
        }
        found = found || this.isFile(this.options.getNodeModulesFolder(), importName + ".js");
        found = found || this.isFile(this.options.getNodeModulesFolder(), importName, "package.json");
        return found;
    }

    private File getImportedFrontendFile(String jsImport) {
        File file = this.getJsImportFile(this.options.getFrontendDirectory(), jsImport);
        if (file.exists()) {
            return file;
        }
        file = this.getJsImportFile(this.getJarResourcesFolder(), jsImport);
        return file.exists() ? file : null;
    }

    private File getJarResourcesFolder() {
        return new File(this.options.getFrontendGeneratedFolder(), "jar-resources");
    }

    private File getJsImportFile(File base, String path) {
        File file = this.getFile(base, path);
        if (file.isDirectory()) {
            file = new File(file, "index.js");
        }
        return file;
    }

    private File getFile(File base, String ... path) {
        return new File(base, String.join((CharSequence)"/", path));
    }

    private boolean isFile(File base, String ... path) {
        return this.getFile(base, path).isFile();
    }

    private boolean isFileOrDirectory(File base, String ... path) {
        File file = this.getFile(base, path);
        return file.isFile() || file.isDirectory();
    }

    protected boolean addCssLines(Collection<String> lines, CssData cssData, int i) {
        String cssFile = this.resolveResource(cssData.getValue());
        boolean found = this.importedFileExists(cssFile);
        Object cssImport = this.toValidBrowserImport(cssFile);
        cssImport = (String)cssImport + "?inline";
        LinkedHashMap<String, Object> optionalsMap = new LinkedHashMap<String, Object>();
        if (cssData.getInclude() != null) {
            optionalsMap.put("include", cssData.getInclude());
        }
        if (cssData.getId() != null && cssData.getThemefor() != null) {
            throw new IllegalStateException("provide either id or themeFor for @CssImport of resource " + cssData.getValue() + ", not both");
        }
        if (cssData.getId() != null) {
            optionalsMap.put("moduleId", cssData.getId());
        } else if (cssData.getThemefor() != null) {
            optionalsMap.put("moduleId", this.getThemeIdPrefix() + "_" + i);
        }
        Object optionals = "";
        if (!optionalsMap.isEmpty()) {
            optionals = ", " + optionalsMap.keySet().stream().map(k -> k + ": '" + (String)optionalsMap.get(k) + "'").collect(Collectors.joining(", ", "{", "}"));
        }
        if (cssData.getThemefor() != null || cssData.getId() != null) {
            String themeFor = cssData.getThemefor() != null ? cssData.getThemefor() : "";
            this.addLines(lines, String.format(REGISTER_STYLES_FOR_TEMPLATE, i, cssImport, themeFor, optionals));
        } else if (cssData.getInclude() != null) {
            if (!lines.contains("function addCssBlock(block) {")) {
                this.addLines(lines, CSS_PREPARE);
            }
            String include = cssData.getInclude() != null ? " include=\"" + cssData.getInclude() + "\"" : "";
            this.addLines(lines, String.format(CSS_BASIC_TPL, i, cssImport, include));
        } else {
            this.addLines(lines, String.format(INJECT_CSS, i, cssImport));
        }
        return found || !this.options.isBundleBuild();
    }

    private String notFoundMessage(Set<String> files, String prefix, String suffix) {
        return String.format("%n%n  %s%n      - %s%n  %s%n%n", prefix, String.join((CharSequence)"\n      - ", files), suffix);
    }

    private boolean hasMetaInfResource(String resource) {
        return this.getResource("META-INF/frontend/" + resource) != null || this.getResource("META-INF/resources/frontend/" + resource) != null;
    }

    private String toValidBrowserImport(String jsImport) {
        if (this.isFileOrDirectory(this.options.getFrontendDirectory(), jsImport)) {
            if (!jsImport.startsWith("./")) {
                this.getLogger().warn("Use the './' prefix for files in the '{}' folder: '{}', please update your annotations.", (Object)this.options.getFrontendDirectory(), (Object)jsImport);
            }
            return "Frontend/" + jsImport.replaceFirst("^\\./", "");
        }
        return jsImport;
    }

    private void visitImportsRecursively(Path filePath, String path, AbstractTheme theme, Collection<String> imports, Set<String> visitedImports) throws IOException {
        String content = null;
        try (Stream<String> contentStream = Files.lines(filePath, StandardCharsets.UTF_8);){
            content = contentStream.collect(Collectors.joining("\n"));
        }
        catch (UncheckedIOException ioe) {
            if (ioe.getCause() instanceof MalformedInputException) {
                this.getLogger().trace("Failed to read file '{}' found from Es6 import statements. This is probably due to it being a binary file, in which case it doesn't matter as imports are only in js/ts files.", (Object)filePath.toString(), (Object)ioe);
                return;
            }
            throw ioe;
        }
        ImportExtractor extractor = new ImportExtractor(content);
        List<String> importedPaths = extractor.getImportedPaths();
        for (String importedPath : importedPaths) {
            String translatedPath;
            String resolvedPath = this.resolve(importedPath = StringUtil.stripSuffix(importedPath, "?inline"), filePath, path);
            File file = this.getImportedFrontendFile(resolvedPath);
            if (file == null && !importedPath.startsWith("./")) {
                file = this.getFile(this.options.getNodeModulesFolder(), importedPath);
                if (!file.exists()) {
                    file = null;
                }
                resolvedPath = importedPath;
            }
            if (file == null) continue;
            if ((resolvedPath = this.normalizePath(resolvedPath)).contains(theme.getBaseUrl()) && !visitedImports.contains(translatedPath = theme.translateUrl(resolvedPath)) && this.importedFileExists(translatedPath)) {
                visitedImports.add(translatedPath);
                imports.add(this.normalizeImportPath(translatedPath));
            }
            this.handleImports(resolvedPath, theme, imports, visitedImports);
        }
    }

    void handleImports(String path, AbstractTheme theme, Collection<String> imports, Set<String> visitedImports) {
        if (visitedImports.contains(path)) {
            return;
        }
        File file = this.getImportedFrontendFile(path);
        if (file == null) {
            return;
        }
        Path filePath = file.toPath();
        String normalizedPath = filePath.normalize().toString().replace("\\", "/");
        if (!visitedImports.add(normalizedPath)) {
            return;
        }
        try {
            this.visitImportsRecursively(filePath, path, theme, imports, visitedImports);
        }
        catch (IOException exception) {
            this.getLogger().warn("Could not read file {}. Skipping applying theme for its imports", (Object)file.getPath(), (Object)exception);
        }
    }

    private String resolve(String importedPath, Path moduleFile, String path) {
        String pathPrefix = moduleFile.toString();
        int pathLength = path.length();
        if (!moduleFile.endsWith(path) && moduleFile.endsWith("index.js")) {
            pathLength += 9;
        }
        pathPrefix = pathPrefix.substring(0, pathPrefix.length() - pathLength);
        try {
            String resolvedPath = moduleFile.getParent().resolve(importedPath).toString();
            if (resolvedPath.startsWith(pathPrefix)) {
                resolvedPath = resolvedPath.substring(pathPrefix.length());
            }
            return resolvedPath;
        }
        catch (InvalidPathException ipe) {
            this.getLogger().error("Invalid import '{}' in file '{}'", (Object)importedPath, (Object)moduleFile);
            this.getLogger().debug("Failed to resolve path.", (Throwable)ipe);
            return importedPath;
        }
    }

    private String normalizePath(String path) {
        File file = new File(path);
        return file.toPath().normalize().toString().replace("\\", "/");
    }

    private String normalizeImportPath(String path) {
        return this.toValidBrowserImport(this.normalizePath(path));
    }
}

