/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.JarContentsManager;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskCopyLocalFrontendFiles;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCopyFrontendFiles
implements FallibleCommand {
    private static final String[] WILDCARD_INCLUSIONS = new String[]{"**/*.js", "**/*.js.map", "**/*.css", "**/*.css.map", "**/*.ts", "**/*.ts.map", "**/*.tsx", "**/*.tsx.map"};
    private static final String WILDCARD_INCLUSION_APP_THEME_JAR = "**/themes/**/*";
    private final Options options;
    private Set<File> resourceLocations = null;

    TaskCopyFrontendFiles(Options options) {
        this.options = options;
        this.resourceLocations = options.getJarFiles().stream().filter(File::exists).collect(Collectors.toSet());
    }

    @Override
    public void execute() {
        Set<String> existingFiles;
        long start = System.nanoTime();
        this.log().info("Copying frontend resources from jar files ...");
        File targetDirectory = this.options.getJarFrontendResourcesFolder();
        TaskCopyLocalFrontendFiles.createTargetFolder(targetDirectory);
        try {
            existingFiles = TaskCopyFrontendFiles.getFilesInDirectory(targetDirectory, new String[0]);
        }
        catch (IOException e) {
            existingFiles = new HashSet<String>();
            this.log().error("Unable to list contents of the directory " + targetDirectory.getAbsolutePath());
        }
        JarContentsManager jarContentsManager = new JarContentsManager();
        HashSet<String> handledFiles = new HashSet<String>();
        for (File location : this.resourceLocations) {
            if (location.isDirectory()) {
                handledFiles.addAll(TaskCopyLocalFrontendFiles.copyLocalResources(new File(location, "META-INF/frontend"), targetDirectory, new String[0]));
                handledFiles.addAll(TaskCopyLocalFrontendFiles.copyLocalResources(new File(location, "META-INF/resources/frontend"), targetDirectory, new String[0]));
                handledFiles.addAll(TaskCopyLocalFrontendFiles.copyLocalResources(new File(location, "META-INF/resources/"), targetDirectory, "frontend/"));
                continue;
            }
            handledFiles.addAll(jarContentsManager.copyIncludedFilesFromJarTrimmingBasePath(location, "META-INF/frontend", targetDirectory, WILDCARD_INCLUSIONS));
            handledFiles.addAll(jarContentsManager.copyIncludedFilesFromJarTrimmingBasePath(location, "META-INF/resources/frontend", targetDirectory, WILDCARD_INCLUSIONS));
            handledFiles.addAll(jarContentsManager.copyIncludedFilesFromJarTrimmingBasePath(location, "META-INF/resources/", targetDirectory, WILDCARD_INCLUSION_APP_THEME_JAR));
        }
        existingFiles.removeAll(handledFiles);
        existingFiles.forEach(filename -> new File(targetDirectory, (String)filename).delete());
        long ms = (System.nanoTime() - start) / 1000000L;
        this.log().info("Visited {} resources. Took {} ms.", (Object)this.resourceLocations.size(), (Object)ms);
    }

    static Set<String> getFilesInDirectory(File targetDirectory, String ... relativePathExclusions) throws IOException {
        try (Stream<Path> stream = Files.walk(targetDirectory.toPath(), new FileVisitOption[0]);){
            Set<String> set = stream.filter(path -> path.toFile().isFile() && TaskCopyLocalFrontendFiles.keepFile(targetDirectory, relativePathExclusions, path.toFile())).map(path -> targetDirectory.toPath().relativize((Path)path).toString().replaceAll("\\\\", "/")).collect(Collectors.toSet());
            return set;
        }
    }

    private Logger log() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

