/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssBundler {
    private static final String WHITE_SPACE = "\\s*";
    private static final String STRING = "(.*?)";
    private static final String CSS_STRING = "('(.*?)'|\"(.*?)\"|(.*?))";
    private static final String QUOTED_CSS_STRING = "('(.*?)'|\"(.*?)\")";
    private static final String URL = "url\\s*\\(\\s*('(.*?)'|\"(.*?)\"|(.*?))\\s*\\)";
    private static final String URL_OR_STRING = "(url\\s*\\(\\s*('(.*?)'|\"(.*?)\"|(.*?))\\s*\\)|('(.*?)'|\"(.*?)\"))";
    private static final String LAYER = "(layer|layer\\s*\\((.*?)\\))";
    private static final String MEDIA_QUERY = "(\\s+[a-zA-Z].*)?";
    private static final String MAYBE_LAYER_OR_MEDIA_QUERY = "((layer|layer\\s*\\((.*?)\\))|(\\s+[a-zA-Z].*)?)";
    private static Pattern importPattern = Pattern.compile("@import\\s*(url\\s*\\(\\s*('(.*?)'|\"(.*?)\"|(.*?))\\s*\\)|('(.*?)'|\"(.*?)\"))((layer|layer\\s*\\((.*?)\\))|(\\s+[a-zA-Z].*)?)\\s*;");
    private static Pattern urlPattern = Pattern.compile("url\\s*\\(\\s*('(.*?)'|\"(.*?)\"|(.*?))\\s*\\)");

    public static String inlineImports(File themeFolder, File cssFile) throws IOException {
        String content = FileUtils.readFileToString((File)cssFile, (Charset)StandardCharsets.UTF_8);
        Matcher urlMatcher = urlPattern.matcher(content);
        content = urlMatcher.replaceAll(result -> {
            String url = CssBundler.getNonNullGroup(result, 2, 3);
            if (url == null || url.trim().endsWith(".css")) {
                return Matcher.quoteReplacement(urlMatcher.group());
            }
            File potentialFile = new File(cssFile.getParentFile(), url.trim());
            if (potentialFile.exists()) {
                String relativePath = themeFolder.getParentFile().toPath().relativize(potentialFile.toPath()).toString().replaceAll("\\\\", "/");
                return Matcher.quoteReplacement("url('VAADIN/themes/" + relativePath + "')");
            }
            return Matcher.quoteReplacement(urlMatcher.group());
        });
        Matcher importMatcher = importPattern.matcher(content);
        content = importMatcher.replaceAll(result -> {
            String layerOrMediaQueryInfo = result.group(9);
            if (layerOrMediaQueryInfo != null && !layerOrMediaQueryInfo.isBlank()) {
                return Matcher.quoteReplacement(result.group());
            }
            String url = CssBundler.getNonNullGroup(result, 3, 4, 5, 7, 8);
            if (url == null || !url.trim().endsWith(".css")) {
                return Matcher.quoteReplacement(result.group());
            }
            File potentialFile = new File(cssFile.getParentFile(), url.trim());
            if (potentialFile.exists()) {
                try {
                    return Matcher.quoteReplacement(CssBundler.inlineImports(themeFolder, potentialFile));
                }
                catch (IOException e) {
                    CssBundler.getLogger().warn("Unable to inline import: " + result.group());
                }
            }
            return Matcher.quoteReplacement(result.group());
        });
        return content;
    }

    private static String getNonNullGroup(MatchResult result, int ... groupId) {
        for (int i : groupId) {
            String res = result.group(i);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(CssBundler.class);
    }
}

