/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.server.communication.rpc.RpcInvocationHandler;
import elemental.json.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRpcInvocationHandler
implements RpcInvocationHandler {
    @Override
    public Optional<Runnable> handle(UI ui, JsonObject invocationJson) {
        assert (invocationJson.hasKey("node"));
        StateNode node = ui.getInternals().getStateTree().getNodeById(AbstractRpcInvocationHandler.getNodeId(invocationJson));
        if (node == null) {
            AbstractRpcInvocationHandler.getLogger().debug("Ignoring RPC for non-existent node: {}", (Object)AbstractRpcInvocationHandler.getNodeId(invocationJson));
            return Optional.empty();
        }
        if (!node.isAttached()) {
            AbstractRpcInvocationHandler.getLogger().debug("Ignoring RPC for detached node: {}", (Object)AbstractRpcInvocationHandler.getNodeId(invocationJson));
            return Optional.empty();
        }
        if (node.isInactive()) {
            AbstractRpcInvocationHandler.getLogger().info("Ignored RPC for invocation handler '{}' from the client side for an inactive (disabled or invisible) node id='{}'", (Object)this.getClass().getName(), (Object)node.getId());
            return Optional.empty();
        }
        if (!this.allowInert(ui, invocationJson) && node.isInert()) {
            AbstractRpcInvocationHandler.getLogger().info("Ignored RPC for invocation handler '{}' from the client side for an inert node id='{}'", (Object)this.getClass().getName(), (Object)node.getId());
            return Optional.empty();
        }
        return this.handleNode(node, invocationJson);
    }

    private boolean isValidPollInvocation(UI ui, JsonObject invocationJson) {
        if (!this.isPollEventInvocation(invocationJson)) {
            return false;
        }
        if (!this.isPollingEnabledForUI(ui)) {
            AbstractRpcInvocationHandler.getLogger().warn("Ignoring Poll RPC for UI that does not have polling enabled.");
            AbstractRpcInvocationHandler.getLogger().debug("Ignored payload:\n{}", (Object)invocationJson);
            return false;
        }
        if (!this.isLegitimatePollEventInvocation(ui, invocationJson)) {
            AbstractRpcInvocationHandler.getLogger().warn("Ignoring Poll RPC for illegitimate invocation payload.");
            AbstractRpcInvocationHandler.getLogger().debug("Ignored payload:\n{}", (Object)invocationJson);
            return false;
        }
        return true;
    }

    private boolean isPollEventInvocation(JsonObject invocationJson) {
        return invocationJson.hasKey("event") && "ui-poll".equalsIgnoreCase(invocationJson.getString("event"));
    }

    private boolean isPollingEnabledForUI(UI ui) {
        return ui.getPollInterval() > 0;
    }

    private boolean isLegitimatePollEventInvocation(UI ui, JsonObject invocationJson) {
        List<String> invocationKeys;
        List<String> allowedKeys = Arrays.asList("type", "node", "event");
        if (!allowedKeys.containsAll(invocationKeys = Arrays.asList(invocationJson.keys()))) {
            return false;
        }
        if (!invocationJson.hasKey("type")) {
            return false;
        }
        if (!"event".equals(invocationJson.getString("type"))) {
            return false;
        }
        StateNode node = ui.getInternals().getStateTree().getNodeById(AbstractRpcInvocationHandler.getNodeId(invocationJson));
        return node.equals(ui.getElement().getNode());
    }

    protected boolean allowInert(UI ui, JsonObject invocationJson) {
        return this.isValidPollInvocation(ui, invocationJson);
    }

    protected abstract Optional<Runnable> handleNode(StateNode var1, JsonObject var2);

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)AbstractRpcInvocationHandler.class.getName());
    }

    protected static int getNodeId(JsonObject invocationJson) {
        return (int)invocationJson.getNumber("node");
    }
}

