/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.VaadinConfig;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinServletService;
import jakarta.servlet.ServletConfig;
import java.util.Enumeration;
import java.util.Objects;

public class VaadinServletConfig
implements VaadinConfig {
    private transient ServletConfig config;

    public VaadinServletConfig(ServletConfig config) {
        Objects.requireNonNull(config, "VaadinServletConfig requires the ServletConfig object");
        this.config = config;
    }

    private void ensureServletConfig() {
        if (this.config == null && VaadinService.getCurrent() instanceof VaadinServletService) {
            this.config = ((VaadinServletService)VaadinService.getCurrent()).getServlet().getServletConfig();
        } else if (this.config == null) {
            throw new IllegalStateException("The underlying ServletContext of VaadinServletContext is null and there is no VaadinServletService to obtain it from.");
        }
    }

    @Override
    public VaadinContext getVaadinContext() {
        this.ensureServletConfig();
        return new VaadinServletContext(this.config.getServletContext());
    }

    @Override
    public Enumeration<String> getConfigParameterNames() {
        this.ensureServletConfig();
        return this.config.getInitParameterNames();
    }

    @Override
    public String getConfigParameter(String name) {
        this.ensureServletConfig();
        return this.config.getInitParameter(name);
    }
}

