/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssBundler {
    private static final String WHITE_SPACE = "\\s*";
    private static final String STRING = "(.*?)";
    private static final String CSS_STRING = "('(.*?)'|\"(.*?)\"|(.*?))";
    private static final String QUOTED_CSS_STRING = "('(.*?)'|\"(.*?)\")";
    private static final String URL = "url\\s*\\(\\s*('(.*?)'|\"(.*?)\"|(.*?))\\s*\\)";
    private static final String URL_OR_STRING = "(url\\s*\\(\\s*('(.*?)'|\"(.*?)\"|(.*?))\\s*\\)|('(.*?)'|\"(.*?)\"))";
    private static final String LAYER = "(layer|layer\\s*\\((.*?)\\))";
    private static final String MEDIA_QUERY = "(\\s+[a-zA-Z].*)?";
    private static final String MAYBE_LAYER_OR_MEDIA_QUERY = "((layer|layer\\s*\\((.*?)\\))|(\\s+[a-zA-Z].*)?)";
    private static Pattern importPattern = Pattern.compile("@import\\s*(url\\s*\\(\\s*('(.*?)'|\"(.*?)\"|(.*?))\\s*\\)|('(.*?)'|\"(.*?)\"))((layer|layer\\s*\\((.*?)\\))|(\\s+[a-zA-Z].*)?)\\s*;");
    private static Pattern urlPattern = Pattern.compile("url\\s*\\(\\s*('(.*?)'|\"(.*?)\"|(.*?))\\s*\\)");

    @Deprecated
    public static String inlineImports(File themeFolder, File cssFile) throws IOException {
        return CssBundler.inlineImports(themeFolder, cssFile, Set.of());
    }

    public static String inlineImports(File themeFolder, File cssFile, JsonObject themeJson) throws IOException {
        return CssBundler.inlineImports(themeFolder, cssFile, CssBundler.getThemeAssetsAliases(themeJson));
    }

    private static String inlineImports(File themeFolder, File cssFile, Set<String> assetAliases) throws IOException {
        Object content = FileUtils.readFileToString((File)cssFile, (Charset)StandardCharsets.UTF_8);
        Matcher urlMatcher = urlPattern.matcher((CharSequence)content);
        content = urlMatcher.replaceAll(result -> {
            String url = CssBundler.getNonNullGroup(result, 2, 3, 4);
            if (url == null || url.trim().endsWith(".css")) {
                return Matcher.quoteReplacement(urlMatcher.group());
            }
            File potentialFile = new File(cssFile.getParentFile(), url.trim());
            if (potentialFile.exists()) {
                String relativePath = themeFolder.getParentFile().toPath().relativize(potentialFile.toPath()).toString().replaceAll("\\\\", "/");
                return Matcher.quoteReplacement("url('VAADIN/themes/" + relativePath + "')");
            }
            if (CssBundler.isPotentialThemeAsset(themeFolder, assetAliases, potentialFile)) {
                String relativePath = themeFolder.getParentFile().toPath().relativize(potentialFile.toPath()).toString().replaceAll("\\\\", "/");
                return Matcher.quoteReplacement("url('VAADIN/themes/" + relativePath + "')");
            }
            return Matcher.quoteReplacement(urlMatcher.group());
        });
        ArrayList unhandledImports = new ArrayList();
        Matcher importMatcher = importPattern.matcher((CharSequence)content);
        content = importMatcher.replaceAll(result -> {
            File potentialFile;
            String layerOrMediaQueryInfo = result.group(9);
            if (layerOrMediaQueryInfo != null && !layerOrMediaQueryInfo.isBlank()) {
                unhandledImports.add(result.group());
                return "";
            }
            String url = CssBundler.getNonNullGroup(result, 3, 4, 5, 7, 8);
            String sanitizedUrl = CssBundler.sanitizeUrl(url);
            if (sanitizedUrl != null && sanitizedUrl.endsWith(".css") && (potentialFile = new File(cssFile.getParentFile(), sanitizedUrl)).exists()) {
                try {
                    return Matcher.quoteReplacement(CssBundler.inlineImports(themeFolder, potentialFile, assetAliases));
                }
                catch (IOException e) {
                    CssBundler.getLogger().warn("Unable to inline import: " + result.group());
                }
            }
            unhandledImports.add(result.group());
            return "";
        });
        if (!unhandledImports.isEmpty()) {
            content = String.join((CharSequence)"\n", unhandledImports) + (String)(((String)content).isEmpty() ? "" : "\n" + (String)content);
        }
        return content;
    }

    private static boolean isPotentialThemeAsset(File themeFolder, Set<String> assetAliases, File potentialFile) {
        Path themeFolderPath;
        Path normalized;
        boolean potentialAsset = false;
        if (!assetAliases.isEmpty() && (normalized = (themeFolderPath = themeFolder.toPath().normalize()).resolve(potentialFile.toPath()).normalize()).startsWith(themeFolderPath)) {
            String relativePath = themeFolderPath.relativize(normalized).toString().replaceAll("\\\\", "/");
            potentialAsset = assetAliases.stream().anyMatch(relativePath::startsWith);
            if (potentialAsset) {
                CssBundler.getLogger().debug("Considering '{}' a potential asset of theme '{}'", (Object)relativePath, (Object)themeFolder.getName());
            }
        }
        return potentialAsset;
    }

    private static Set<String> getThemeAssetsAliases(JsonObject themeJson) {
        JsonObject assets = themeJson != null && themeJson.hasKey("assets") ? themeJson.getObject("assets") : null;
        HashSet<String> aliases = new HashSet<String>();
        if (assets != null) {
            for (String nmpPackage : assets.keys()) {
                JsonObject packageAliases = assets.getObject(nmpPackage);
                for (String path : packageAliases.keys()) {
                    aliases.add(packageAliases.getString(path) + "/");
                }
            }
        }
        return aliases;
    }

    private static String getNonNullGroup(MatchResult result, int ... groupId) {
        for (int i : groupId) {
            String res = result.group(i);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private static String sanitizeUrl(String url) {
        if (url == null) {
            return null;
        }
        return url.trim().split("\\?")[0];
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(CssBundler.class);
    }
}

