/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.PWA;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PwaConfiguration
implements Serializable {
    public static final String DEFAULT_PATH = "manifest.webmanifest";
    public static final String DEFAULT_ICON = "icons/icon.png";
    public static final String DEFAULT_NAME = "Vaadin Flow Application";
    public static final String DEFAULT_THEME_COLOR = "#ffffff";
    public static final String DEFAULT_BACKGROUND_COLOR = "#f2f2f2";
    public static final String DEFAULT_DISPLAY = "standalone";
    public static final String DEFAULT_OFFLINE_PATH = "offline.html";
    public static final String DEFAULT_START_URL = ".";
    private final String appName;
    private final String shortName;
    private final String description;
    private final String backgroundColor;
    private final String themeColor;
    private final String iconPath;
    private final String manifestPath;
    private final String offlinePath;
    private final String serviceWorkerPath = "sw.js";
    private final String display;
    private final String startPath;
    private final boolean enabled;
    private final List<String> offlineResources;
    private final boolean offlineEnabled;

    public PwaConfiguration() {
        this(false, DEFAULT_NAME, "Flow PWA", "", DEFAULT_BACKGROUND_COLOR, DEFAULT_THEME_COLOR, DEFAULT_ICON, DEFAULT_PATH, DEFAULT_OFFLINE_PATH, DEFAULT_DISPLAY, DEFAULT_START_URL, new String[0], false);
    }

    public PwaConfiguration(PWA pwa) {
        this(true, pwa.name(), pwa.shortName(), pwa.description(), pwa.backgroundColor(), pwa.themeColor(), pwa.iconPath(), pwa.manifestPath(), pwa.offlinePath(), pwa.display(), pwa.startPath(), pwa.offlineResources(), pwa.offline());
    }

    public PwaConfiguration(boolean enabled, String name, String shortName, String description, String backgroundColor, String themeColor, String iconPath, String manifestPath, String offlinePath, String display, String startPath, String[] offlineResources, boolean offlineEnabled) {
        this.appName = name;
        this.shortName = shortName.substring(0, Math.min(shortName.length(), 12));
        this.description = description;
        this.backgroundColor = backgroundColor;
        this.themeColor = themeColor;
        this.iconPath = iconPath;
        this.manifestPath = manifestPath;
        this.offlinePath = offlinePath;
        this.display = display;
        this.startPath = startPath;
        this.enabled = enabled;
        this.offlineResources = Arrays.asList(offlineResources);
        this.offlineEnabled = offlineEnabled;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public String getThemeColor() {
        return this.themeColor;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String relIconPath() {
        return "/" + this.iconPath;
    }

    public String getManifestPath() {
        return this.manifestPath;
    }

    public String relManifestPath() {
        return "/" + this.manifestPath;
    }

    public String getOfflinePath() {
        return this.offlinePath;
    }

    public String relOfflinePath() {
        return "/" + this.offlinePath;
    }

    public String getServiceWorkerPath() {
        return "sw.js";
    }

    public String relServiceWorkerPath() {
        return "/sw.js";
    }

    public List<String> getOfflineResources() {
        return Collections.unmodifiableList(this.offlineResources);
    }

    public boolean isOfflineEnabled() {
        return this.offlineEnabled;
    }

    public String getDisplay() {
        return this.display;
    }

    public String getStartUrl() {
        return this.startPath;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isOfflinePathEnabled() {
        return !this.offlinePath.isEmpty();
    }
}

