/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.experimental;

import com.vaadin.experimental.Feature;
import com.vaadin.experimental.UnknownFeatureException;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureFlags
implements Serializable {
    public static final String PROPERTIES_FILENAME = "vaadin-featureflags.properties";
    @Deprecated
    public static final String SYSTEM_PROPERTY_PREFIX = "vaadin.";
    public static final String SYSTEM_PROPERTY_PREFIX_EXPERIMENTAL = "vaadin.experimental.";
    public static final Feature EXAMPLE = new Feature("Example feature. Will be removed once the first real feature flag is added", "exampleFeatureFlag", "https://github.com/vaadin/flow/pull/12004", false, "com.vaadin.flow.server.frontend.NodeTestComponents$ExampleExperimentalComponent");
    public static final Feature COLLABORATION_ENGINE_BACKEND = new Feature("Collaboration Kit backend for clustering support", "collaborationEngineBackend", "https://github.com/vaadin/platform/issues/1988", true, null);
    public static final Feature FORM_FILLER_ADDON = new Feature("Form Filler Add-on", "formFillerAddon", "https://github.com/vaadin/form-filler-addon", true, "com.vaadin.flow.ai.formfiller.FormFiller");
    public static final Feature HILLA_I18N = new Feature("Hilla I18n API", "hillaI18n", "https://github.com/vaadin/hilla/tree/main/packages/ts/react-i18n", true, null);
    public static final Feature COPILOT_EXPERIMENTAL = new Feature("Copilot experimental features", "copilotExperimentalFeatures", "https://vaadin.com/docs/latest/tools", false, null);
    public static final Feature HILLA_FULLSTACK_SIGNALS = new Feature("Hilla Full-stack Signals", "fullstackSignals", "https://github.com/vaadin/hilla/discussions/1902", true, null);
    public static final Feature DASHBOARD_COMPONENT = new Feature("Dashboard component (Pro)", "dashboardComponent", "https://github.com/vaadin/platform/issues/6626", true, "com.vaadin.flow.component.dashboard.Dashboard");
    private List<Feature> features = new ArrayList<Feature>();
    File propertiesFolder = null;
    private final Lookup lookup;
    private ApplicationConfiguration configuration;
    private boolean isPropertiesFileChecked = false;
    private boolean isSystemPropertiesChecked = false;

    public FeatureFlags(Lookup lookup) {
        this.lookup = lookup;
        this.features.add(new Feature(EXAMPLE));
        this.features.add(new Feature(COLLABORATION_ENGINE_BACKEND));
        this.features.add(new Feature(FORM_FILLER_ADDON));
        this.features.add(new Feature(HILLA_I18N));
        this.features.add(new Feature(HILLA_FULLSTACK_SIGNALS));
        this.features.add(new Feature(COPILOT_EXPERIMENTAL));
        this.features.add(new Feature(DASHBOARD_COMPONENT));
        this.loadProperties();
    }

    public static FeatureFlags get(VaadinContext context) {
        assert (context != null);
        FeatureFlagsWrapper attribute = context.getAttribute(FeatureFlagsWrapper.class, () -> {
            FeatureFlags featureFlags = new FeatureFlags(context.getAttribute(Lookup.class));
            featureFlags.configuration = ApplicationConfiguration.get(context);
            featureFlags.loadProperties();
            return new FeatureFlagsWrapper(featureFlags);
        });
        return attribute.getFeatureFlags();
    }

    public void setPropertiesLocation(File propertiesFolder) {
        this.propertiesFolder = propertiesFolder;
        this.loadProperties();
    }

    public void loadProperties() {
        URL applicationResource;
        ResourceProvider resourceProvider = this.lookup.lookup(ResourceProvider.class);
        if (resourceProvider != null && (applicationResource = resourceProvider.getApplicationResource(PROPERTIES_FILENAME)) != null) {
            this.getLogger().debug("Properties loaded from classpath.");
            try (InputStream propertiesStream = applicationResource.openStream();){
                this.loadProperties(propertiesStream);
                return;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read properties file from classpath", e);
            }
        }
        File featureFlagFile = this.getFeatureFlagFile();
        if (featureFlagFile == null || !featureFlagFile.exists()) {
            this.checkForUnsupportedSystemProperties();
            for (Feature f : this.features) {
                f.setEnabled(Boolean.getBoolean(SYSTEM_PROPERTY_PREFIX + f.getId()) || Boolean.getBoolean(SYSTEM_PROPERTY_PREFIX_EXPERIMENTAL + f.getId()));
            }
        } else {
            try (FileInputStream propertiesStream = new FileInputStream(featureFlagFile);){
                this.getLogger().debug("Loading properties from file '{}'", (Object)featureFlagFile);
                this.loadProperties(propertiesStream);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read properties file from filesystem", e);
            }
        }
    }

    void loadProperties(InputStream propertiesStream) {
        try {
            Properties props = new Properties();
            if (propertiesStream != null) {
                props.load(propertiesStream);
                this.checkForUnsupportedFileProperties(props);
            }
            this.checkForUnsupportedSystemProperties();
            for (Feature f : this.features) {
                String propertyValue = System.getProperty(SYSTEM_PROPERTY_PREFIX_EXPERIMENTAL + f.getId(), System.getProperty(SYSTEM_PROPERTY_PREFIX + f.getId(), props.getProperty(this.getFilePropertyName(f.getId()))));
                f.setEnabled(Boolean.parseBoolean(propertyValue));
            }
        }
        catch (IOException e) {
            this.getLogger().error("Unable to read feature flags", (Throwable)e);
        }
    }

    private void saveProperties() {
        File featureFlagFile = this.getFeatureFlagFile();
        if (featureFlagFile == null) {
            throw new IllegalStateException("Unable to determine feature flag file location");
        }
        StringBuilder properties = new StringBuilder();
        for (Feature feature : this.features) {
            if (!feature.isEnabled()) continue;
            properties.append("# ").append(feature.getTitle()).append("\n");
            properties.append(this.getFilePropertyName(feature.getId())).append("=true\n");
        }
        if (!featureFlagFile.getParentFile().exists()) {
            featureFlagFile.getParentFile().mkdirs();
        }
        try {
            FileUtils.write((File)featureFlagFile, (CharSequence)properties.toString(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.getLogger().error("Unable to store feature flags", (Throwable)e);
        }
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public boolean isEnabled(Feature feature) {
        return this.getFeature(feature.getId()).orElseThrow(() -> new UnknownFeatureException(feature.getTitle())).isEnabled();
    }

    public boolean isEnabled(String featureId) {
        return this.getFeature(featureId).map(Feature::isEnabled).orElse(false);
    }

    private Optional<Feature> getFeature(String featureId) {
        return this.features.stream().filter(feature -> feature.getId().equals(featureId)).findFirst();
    }

    private String getFilePropertyName(String featureId) {
        return "com.vaadin.experimental." + featureId;
    }

    private String getSystemPropertyName(String featureId) {
        return SYSTEM_PROPERTY_PREFIX_EXPERIMENTAL + featureId;
    }

    public void setEnabled(String featureId, boolean enabled) {
        if (!this.isDevelopmentMode()) {
            throw new IllegalStateException("Feature flags can only be toggled when in development mode");
        }
        Optional<Feature> maybeFeature = this.getFeature(featureId);
        if (!maybeFeature.isPresent()) {
            throw new IllegalArgumentException("Unknown feature " + featureId);
        }
        Feature feature = maybeFeature.get();
        if (feature.isEnabled() == enabled) {
            return;
        }
        maybeFeature.get().setEnabled(enabled);
        this.saveProperties();
        this.getLogger().info("Set feature {} to {}", (Object)featureId, (Object)enabled);
    }

    private File getFeatureFlagFile() {
        if (this.propertiesFolder == null) {
            if (this.configuration == null) {
                return null;
            }
            this.propertiesFolder = this.configuration.getJavaResourceFolder();
        }
        return new File(this.propertiesFolder, PROPERTIES_FILENAME);
    }

    private boolean isDevelopmentMode() {
        return this.configuration != null && !this.configuration.isProductionMode();
    }

    public String getEnableHelperMessage(Feature feature) {
        return feature.getTitle() + " is not enabled. Enable it in the debug window or by adding " + this.getFilePropertyName(feature.getId()) + "=true to src/main/resources/vaadin-featureflags.properties";
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(FeatureFlags.class);
    }

    private void checkForUnsupportedFileProperties(Properties fileProps) {
        if (!this.isPropertiesFileChecked) {
            this.checkForUnsupportedFeatureFlags(fileProps, this::getFilePropertyName);
            this.isPropertiesFileChecked = true;
        }
    }

    private void checkForUnsupportedSystemProperties() {
        if (!this.isSystemPropertiesChecked) {
            Properties filteredSystemProps = new Properties();
            System.getProperties().entrySet().stream().filter(property -> property.getKey().toString().startsWith(SYSTEM_PROPERTY_PREFIX_EXPERIMENTAL)).forEach(property -> filteredSystemProps.put(property.getKey(), property.getValue()));
            this.checkForUnsupportedFeatureFlags(filteredSystemProps, this::getSystemPropertyName);
            this.isSystemPropertiesChecked = true;
        }
    }

    private void checkForUnsupportedFeatureFlags(Properties props, Function<String, String> propertyWithPrefix) {
        for (Object property : props.keySet()) {
            if (!this.features.stream().noneMatch(feature -> ((String)propertyWithPrefix.apply(feature.getId())).equals(property))) continue;
            this.getLogger().warn("Unsupported feature flag is present: {}", property);
        }
    }

    protected static class FeatureFlagsWrapper
    implements Serializable {
        private final FeatureFlags featureFlags;

        public FeatureFlagsWrapper(FeatureFlags featureFlags) {
            this.featureFlags = featureFlags;
        }

        public FeatureFlags getFeatureFlags() {
            return this.featureFlags;
        }
    }
}

