/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HeartbeatEvent;
import com.vaadin.flow.component.HeartbeatListener;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.ComponentMetaData;
import com.vaadin.flow.component.internal.DependencyList;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.component.internal.UIInternalUpdater;
import com.vaadin.flow.component.page.ExtendedClientDetails;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementUtil;
import com.vaadin.flow.dom.impl.BasicElementStateProvider;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.ConstantPool;
import com.vaadin.flow.internal.JsonCodec;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.UrlUtil;
import com.vaadin.flow.internal.nodefeature.LoadingIndicatorConfigurationMap;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.PollConfigurationMap;
import com.vaadin.flow.internal.nodefeature.PushConfigurationMap;
import com.vaadin.flow.internal.nodefeature.ReconnectDialogConfigurationMap;
import com.vaadin.flow.router.AfterNavigationListener;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.BeforeLeaveEvent;
import com.vaadin.flow.router.BeforeLeaveListener;
import com.vaadin.flow.router.ListenerPriority;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.AfterNavigationHandler;
import com.vaadin.flow.router.internal.BeforeEnterHandler;
import com.vaadin.flow.router.internal.BeforeLeaveHandler;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.PushConnection;
import com.vaadin.flow.server.frontend.BundleUtils;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.shared.communication.PushMode;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIInternals
implements Serializable {
    private static final Pattern APP_ID_REPLACE_PATTERN = Pattern.compile("-\\d+$");
    private static final Set<Class<? extends Component>> warnedAboutDeps = ConcurrentHashMap.newKeySet();
    private static Set<String> bundledImports = BundleUtils.loadBundleImports();
    private int lastProcessedClientToServerId = -1;
    private int serverSyncId = 0;
    private final StateTree stateTree;
    private PushConnection pushConnection = null;
    private long lastHeartbeatTimestamp = System.currentTimeMillis();
    private List<PendingJavaScriptInvocation> pendingJsInvocations = new ArrayList<PendingJavaScriptInvocation>();
    private final HashMap<StateNode, PendingJavaScriptInvocationDetachListener> pendingJsInvocationDetachListeners = new HashMap();
    private final UI ui;
    private final UIInternalUpdater internalsHandler;
    private String title;
    private String appShellTitle;
    private PendingJavaScriptInvocation pendingTitleUpdateCanceler;
    private Location viewLocation = new Location("");
    private ArrayList<HasElement> routerTargetChain = new ArrayList();
    private HashMap<Class<?>, List<?>> listeners = new HashMap();
    private Location lastHandledNavigation = null;
    private Location locationForRefresh = null;
    private BeforeLeaveEvent.ContinueNavigationAction continueNavigationAction = null;
    private volatile VaadinSession session;
    private final DependencyList dependencyList = new DependencyList();
    private final ConstantPool constantPool = new ConstantPool();
    private byte[] lastProcessedMessageHash = null;
    private String contextRootRelativePath;
    private String appId;
    private String fullAppId;
    private Component activeDragSourceComponent;
    private ExtendedClientDetails extendedClientDetails = null;
    private ArrayDeque<Component> modalComponentStack;

    public UIInternals(UI ui) {
        this(ui, new UIInternalUpdater(){});
    }

    public UIInternals(UI ui, UIInternalUpdater internalsHandler) {
        this.internalsHandler = internalsHandler;
        this.ui = ui;
        this.stateTree = new StateTree(this, UIInternals.getRootNodeFeatures());
    }

    public StateTree getStateTree() {
        return this.stateTree;
    }

    public int getLastProcessedClientToServerId() {
        return this.lastProcessedClientToServerId;
    }

    public byte[] getLastProcessedMessageHash() {
        return this.lastProcessedMessageHash;
    }

    public void setLastProcessedClientToServerId(int lastProcessedClientToServerId, byte[] lastProcessedMessageHash) {
        this.lastProcessedClientToServerId = lastProcessedClientToServerId;
        this.lastProcessedMessageHash = lastProcessedMessageHash;
    }

    public int getServerSyncId() {
        return this.serverSyncId;
    }

    public void incrementServerId() {
        ++this.serverSyncId;
        if (UIInternals.getLogger().isTraceEnabled()) {
            UIInternals.getLogger().trace("Increment syncId {} -> {}:\n{}", new Object[]{this.serverSyncId - 1, this.serverSyncId, Arrays.stream(Thread.currentThread().getStackTrace()).skip(1L).map(String::valueOf).collect(Collectors.joining(System.lineSeparator()))});
        }
    }

    public long getLastHeartbeatTimestamp() {
        return this.lastHeartbeatTimestamp;
    }

    public void setLastHeartbeatTimestamp(long lastHeartbeat) {
        this.lastHeartbeatTimestamp = lastHeartbeat;
        HeartbeatEvent heartbeatEvent = new HeartbeatEvent(this.ui, lastHeartbeat);
        this.getListeners(HeartbeatListener.class).forEach(listener -> listener.heartbeat(heartbeatEvent));
    }

    private static Class<? extends NodeFeature>[] getRootNodeFeatures() {
        ArrayList<Class<? extends NodeFeature>> features = new ArrayList<Class<? extends NodeFeature>>(BasicElementStateProvider.getFeatures());
        features.add(PushConfigurationMap.class);
        features.add(PollConfigurationMap.class);
        features.add(ReconnectDialogConfigurationMap.class);
        features.add(LoadingIndicatorConfigurationMap.class);
        assert (features.size() == new HashSet<Class<? extends NodeFeature>>(features).size()) : "There are duplicates";
        return features.toArray(new Class[0]);
    }

    private static String getSessionDetails(VaadinSession session) {
        if (session == null) {
            return null;
        }
        return session + " for " + session.getService().getServiceName();
    }

    public void setSession(VaadinSession session) {
        if (session == null && this.session == null) {
            throw new IllegalStateException("Session should never be set to null when UI.session is already null");
        }
        if (session != null && this.session != null) {
            throw new IllegalStateException("Session has already been set. Old session: " + UIInternals.getSessionDetails(this.session) + ". New session: " + UIInternals.getSessionDetails(session) + ".");
        }
        if (session == null) {
            this.ui.getElement().getNode().setParent(null);
            this.ui.getPushConfiguration().setPushMode(PushMode.DISABLED);
            this.setPushConnection(null);
        }
        this.session = session;
        if (session != null) {
            ComponentUtil.onComponentAttach(this.ui, true);
        }
    }

    public PushConnection getPushConnection() {
        assert (!this.ui.getPushConfiguration().getPushMode().isEnabled() || this.pushConnection != null);
        return this.pushConnection;
    }

    public void setPushConnection(PushConnection pushConnection) {
        assert (pushConnection == null ^ this.ui.getPushConfiguration().getPushMode().isEnabled());
        if (pushConnection == this.pushConnection) {
            return;
        }
        if (this.pushConnection != null && this.pushConnection.isConnected()) {
            this.pushConnection.disconnect();
        }
        this.pushConnection = pushConnection;
    }

    public Registration addBeforeEnterListener(BeforeEnterListener listener) {
        return this.addListener(BeforeEnterHandler.class, listener);
    }

    public Registration addBeforeLeaveListener(BeforeLeaveListener listener) {
        return this.addListener(BeforeLeaveHandler.class, listener);
    }

    public Registration addAfterNavigationListener(AfterNavigationListener listener) {
        return this.addListener(AfterNavigationHandler.class, listener);
    }

    public Registration addHeartbeatListener(HeartbeatListener listener) {
        return this.addListener(HeartbeatListener.class, listener);
    }

    private <E> Registration addListener(Class<E> handler, E listener) {
        this.session.checkHasLock();
        List list = this.listeners.computeIfAbsent(handler, key -> new ArrayList());
        list.add(listener);
        list.sort((o1, o2) -> {
            Class<?> o1Class = o1.getClass();
            Class<?> o2Class = o2.getClass();
            ListenerPriority listenerPriority1 = o1Class.getAnnotation(ListenerPriority.class);
            ListenerPriority listenerPriority2 = o2Class.getAnnotation(ListenerPriority.class);
            int priority1 = listenerPriority1 != null ? listenerPriority1.value() : 0;
            int priority2 = listenerPriority2 != null ? listenerPriority2.value() : 0;
            return Integer.compare(priority2, priority1);
        });
        return () -> list.remove(listener);
    }

    public <E> List<E> getListeners(Class<E> handler) {
        List registeredListeners = this.listeners.computeIfAbsent(handler, key -> new ArrayList());
        return Collections.unmodifiableList(new ArrayList(registeredListeners));
    }

    public void addJavaScriptInvocation(PendingJavaScriptInvocation invocation) {
        this.session.checkHasLock();
        this.pendingJsInvocations.add(invocation);
    }

    public List<PendingJavaScriptInvocation> dumpPendingJavaScriptInvocations() {
        this.pendingTitleUpdateCanceler = null;
        if (this.pendingJsInvocations.isEmpty()) {
            return Collections.emptyList();
        }
        Map<Boolean, List<PendingJavaScriptInvocation>> partition = this.getPendingJavaScriptInvocations().collect(Collectors.partitioningBy(invocation -> invocation.getOwner().isVisible()));
        List<PendingJavaScriptInvocation> readyToSend = partition.get(true);
        readyToSend.forEach(PendingJavaScriptInvocation::setSentToBrowser);
        this.pendingJsInvocations = new ArrayList<PendingJavaScriptInvocation>((Collection)partition.get(false));
        this.pendingJsInvocations.forEach(this::registerDetachListenerForPendingInvocation);
        return readyToSend;
    }

    private void registerDetachListenerForPendingInvocation(PendingJavaScriptInvocation invocation) {
        PendingJavaScriptInvocationDetachListener listener = this.pendingJsInvocationDetachListeners.computeIfAbsent(invocation.getOwner(), node -> {
            PendingJavaScriptInvocationDetachListener detachListener = new PendingJavaScriptInvocationDetachListener();
            detachListener.registration = Registration.combine(() -> this.pendingJsInvocationDetachListeners.remove(node), node.addDetachListener(detachListener));
            return detachListener;
        });
        if (listener.invocationList.add(invocation)) {
            SerializableConsumer callback = unused -> listener.onInvocationCompleted(invocation);
            invocation.then(callback, callback);
        }
    }

    Stream<PendingJavaScriptInvocation> getPendingJavaScriptInvocations() {
        return this.pendingJsInvocations.stream().filter(invocation -> !invocation.isCanceled());
    }

    public boolean containsPendingJavascript(String containsFilter) {
        return this.getPendingJavaScriptInvocations().anyMatch(js -> js.getInvocation().getExpression().contains(containsFilter));
    }

    public void setTitle(String title) {
        assert (title != null);
        JavaScriptInvocation invocation = new JavaScriptInvocation(this.generateTitleScript().stripIndent(), new Serializable[]{title});
        this.pendingTitleUpdateCanceler = new PendingJavaScriptInvocation(this.getStateTree().getRootNode(), invocation);
        this.addJavaScriptInvocation(this.pendingTitleUpdateCanceler);
        this.title = title;
    }

    private String generateTitleScript() {
        String setTitleScript = "    document.title = $0;\n    if(window?.Vaadin?.documentTitleSignal) {\n        window.Vaadin.documentTitleSignal.value = $0;\n    }\n";
        if (this.getSession().getConfiguration().isReactEnabled()) {
            setTitleScript = String.format("if(window.Vaadin.Flow.navigation) { window.addEventListener('vaadin-navigated', function(event) {%s}, {once:true}); }  else { %1$s }", setTitleScript);
        }
        return setTitleScript;
    }

    public void setAppShellTitle(String appShellTitle) {
        this.appShellTitle = appShellTitle;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAppShellTitle() {
        return this.appShellTitle;
    }

    public boolean cancelPendingTitleUpdate() {
        if (this.pendingTitleUpdateCanceler == null) {
            return false;
        }
        boolean result = this.pendingTitleUpdateCanceler.cancelExecution();
        this.pendingTitleUpdateCanceler = null;
        return result;
    }

    public void showRouteTarget(Location viewLocation, Component target, List<RouterLayout> layouts) {
        HasElement root;
        assert (target != null);
        assert (viewLocation != null);
        HasElement oldRoot = null;
        if (!this.routerTargetChain.isEmpty()) {
            oldRoot = this.routerTargetChain.get(this.routerTargetChain.size() - 1);
        }
        this.viewLocation = viewLocation;
        IdentityHashMap<RouterLayout, HasElement> oldChildren = new IdentityHashMap<RouterLayout, HasElement>();
        for (int i = 0; i < this.routerTargetChain.size() - 1; ++i) {
            HasElement child = this.routerTargetChain.get(i);
            RouterLayout parent = (RouterLayout)this.routerTargetChain.get(i + 1);
            oldChildren.put(parent, child);
        }
        this.routerTargetChain = new ArrayList();
        this.routerTargetChain.add(target);
        if (layouts != null) {
            this.routerTargetChain.addAll(layouts);
        }
        if (oldRoot != null && !this.routerTargetChain.contains(oldRoot)) {
            oldChildren.forEach(RouterLayout::removeRouterLayoutContent);
        }
        HasElement previous = null;
        for (HasElement current : this.routerTargetChain) {
            if (previous != null || oldChildren.containsKey(current)) {
                HasElement newContent;
                assert (current instanceof RouterLayout) : "All parts of the chain except the first must implement " + RouterLayout.class.getSimpleName();
                HasElement oldContent = (HasElement)oldChildren.get(current);
                if (oldContent != (newContent = previous)) {
                    RouterLayout layout = (RouterLayout)current;
                    this.removeChildrenContentFromRouterLayout(layout, oldChildren);
                    layout.showRouterLayoutContent(newContent);
                }
            }
            previous = current;
        }
        if (this.getSession().getService().getDeploymentConfiguration().isReactEnabled() && this.getRouter().getRegistry().getNavigationTarget(viewLocation.getPath()).isEmpty() && target instanceof RouterLayout) {
            try {
                Object reactOutlet = Instantiator.get(this.ui).createComponent(this.getClass().getClassLoader().loadClass("com.vaadin.flow.component.react.ReactRouterOutlet"));
                RouterLayout layout = (RouterLayout)((Object)target);
                layout.getElement().getChildren().filter(element -> element.getTag().equals(reactOutlet.getClass().getAnnotation(Tag.class).value())).forEach(Element::removeFromParent);
                layout.showRouterLayoutContent((HasElement)reactOutlet);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("No ReactRouterOutlet available on classpath", e);
            }
        }
        if ((root = previous) == null) {
            throw new IllegalArgumentException("Root can't be null here since we know there's at least one item in the chain");
        }
        this.internalsHandler.updateRoot(this.ui, oldRoot, root);
    }

    public void moveElementsFrom(UI otherUI) {
        this.internalsHandler.moveToNewUI(otherUI, this.ui);
    }

    public List<HasElement> getActiveRouterTargetsChain() {
        return Collections.unmodifiableList(this.routerTargetChain);
    }

    public Location getActiveViewLocation() {
        return this.viewLocation;
    }

    public VaadinSession getSession() {
        return this.session;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)UIInternals.class.getName());
    }

    public DependencyList getDependencyList() {
        return this.dependencyList;
    }

    public void addComponentDependencies(Class<? extends Component> componentClass) {
        Page page = this.ui.getPage();
        ComponentMetaData.DependencyInfo dependencies = ComponentUtil.getDependencies(this.session.getService(), componentClass);
        this.addExternalDependencies(dependencies);
        if (this.mightHaveChunk(componentClass, dependencies)) {
            this.triggerChunkLoading(componentClass);
        }
        dependencies.getStyleSheets().forEach(styleSheet -> page.addStyleSheet(styleSheet.value(), styleSheet.loadMode()));
        this.warnForUnavailableBundledDependencies(componentClass, dependencies);
    }

    private boolean mightHaveChunk(Class<? extends Component> componentClass, ComponentMetaData.DependencyInfo dependencies) {
        if (!dependencies.isEmpty()) {
            return true;
        }
        return componentClass.getAnnotation(Route.class) != null;
    }

    private void triggerChunkLoading(Class<? extends Component> componentClass) {
        boolean isProductionMode = this.ui.getSession() != null && this.ui.getSession().getConfiguration().isProductionMode();
        ArrayList<String> chunkIds = new ArrayList<String>();
        chunkIds.add(BundleUtils.getChunkId(componentClass));
        if (isProductionMode) {
            for (Class<? extends Component> clazz = componentClass.getSuperclass(); clazz != Component.class; clazz = clazz.getSuperclass()) {
                chunkIds.add(BundleUtils.getChunkId(clazz.getName()));
            }
        }
        chunkIds.forEach(chunkId -> this.ui.getPage().addDynamicImport("return window.Vaadin.Flow.loadOnDemand('" + chunkId + "');"));
    }

    private void warnForUnavailableBundledDependencies(Class<? extends Component> componentClass, ComponentMetaData.DependencyInfo dependencies) {
        if (this.ui.getSession() == null || !this.ui.getSession().getConfiguration().isProductionMode()) {
            return;
        }
        ArrayList<String> jsDeps = new ArrayList<String>();
        jsDeps.addAll(dependencies.getJavaScripts().stream().map(dep -> dep.value()).filter(src -> !UrlUtil.isExternal(src)).collect(Collectors.toList()));
        jsDeps.addAll(dependencies.getJsModules().stream().map(dep -> dep.value()).filter(src -> !UrlUtil.isExternal(src)).collect(Collectors.toList()));
        if (!jsDeps.isEmpty()) {
            this.maybeWarnAboutDependencies(componentClass, jsDeps);
        }
    }

    private void maybeWarnAboutDependencies(Class<? extends Component> componentClass, List<String> jsDeps) {
        if (warnedAboutDeps.add(componentClass)) {
            for (String jsDep : jsDeps) {
                if (bundledImports == null || bundledImports.contains(jsDep)) continue;
                UIInternals.getLogger().error("The component class " + componentClass.getName() + " includes '" + jsDep + "' but this file was not included when creating the production bundle. The component will not work properly. Check that you have a reference to the component and that you are not using it only through reflection. If needed add a @Uses(" + componentClass.getSimpleName() + ".class) where it is used.");
                return;
            }
        }
    }

    private void addExternalDependencies(ComponentMetaData.DependencyInfo dependency) {
        Page page = this.ui.getPage();
        dependency.getJavaScripts().stream().filter(js -> UrlUtil.isExternal(js.value())).forEach(js -> page.addJavaScript(js.value(), js.loadMode()));
        dependency.getJsModules().stream().filter(js -> UrlUtil.isExternal(js.value())).forEach(js -> page.addJsModule(js.value()));
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public Location getLastHandledLocation() {
        return this.lastHandledNavigation;
    }

    public void setLastHandledNavigation(Location location) {
        this.lastHandledNavigation = location;
        if (location != null) {
            this.locationForRefresh = location;
        }
    }

    public void refreshCurrentRoute(boolean refreshRouteChain) {
        if (this.locationForRefresh == null) {
            UIInternals.getLogger().warn("Latest navigation location is not set. Unable to refresh the current route.");
        } else {
            this.getRouter().navigate(this.ui, this.locationForRefresh, NavigationTrigger.REFRESH_ROUTE, null, true, refreshRouteChain || this.hasModalComponent());
        }
    }

    public boolean hasLastHandledLocation() {
        return this.lastHandledNavigation != null;
    }

    public void clearLastHandledNavigation() {
        this.setLastHandledNavigation(null);
    }

    public BeforeLeaveEvent.ContinueNavigationAction getContinueNavigationAction() {
        return this.continueNavigationAction;
    }

    public void setContinueNavigationAction(BeforeLeaveEvent.ContinueNavigationAction continueNavigationAction) {
        this.continueNavigationAction = continueNavigationAction;
    }

    public void setFullAppId(String fullAppId) {
        this.fullAppId = fullAppId;
        this.appId = APP_ID_REPLACE_PATTERN.matcher(fullAppId).replaceAll("");
    }

    public String getAppId() {
        return this.appId;
    }

    public String getFullAppId() {
        return this.fullAppId;
    }

    public Router getRouter() {
        return this.ui.isNavigationSupported() ? this.getSession().getService().getRouter() : null;
    }

    public boolean isDirty() {
        return this.getStateTree().isDirty() || this.getPendingJavaScriptInvocations().anyMatch(invocation -> invocation.getOwner().isVisible());
    }

    public void setContextRoot(String contextRootRelativePath) {
        this.contextRootRelativePath = contextRootRelativePath;
    }

    public String getContextRootRelativePath() {
        return this.contextRootRelativePath;
    }

    public void setActiveDragSourceComponent(Component activeDragSourceComponent) {
        this.activeDragSourceComponent = activeDragSourceComponent;
    }

    public Component getActiveDragSourceComponent() {
        return this.activeDragSourceComponent;
    }

    public UI getUI() {
        return this.ui;
    }

    public ExtendedClientDetails getExtendedClientDetails() {
        return this.extendedClientDetails;
    }

    public void setExtendedClientDetails(ExtendedClientDetails details) {
        this.extendedClientDetails = details;
    }

    public boolean hasModalComponent() {
        return this.modalComponentStack != null && !this.modalComponentStack.isEmpty();
    }

    public Component getActiveModalComponent() {
        if (this.hasModalComponent()) {
            return this.modalComponentStack.peek();
        }
        return null;
    }

    public void setChildModal(Component child) {
        if (this.modalComponentStack == null) {
            this.modalComponentStack = new ArrayDeque();
        } else if (this.isTopMostModal(child)) {
            return;
        }
        ElementUtil.setIgnoreParentInert(child.getElement(), true);
        if (this.modalComponentStack.isEmpty()) {
            ElementUtil.setInert(this.ui.getElement(), true);
        } else {
            ElementUtil.setIgnoreParentInert(this.modalComponentStack.peek().getElement(), false);
        }
        boolean needsListener = !this.modalComponentStack.remove(child);
        this.modalComponentStack.push(child);
        if (needsListener) {
            AtomicReference<Registration> registrationCombination = new AtomicReference<Registration>();
            Registration componentRemoval = () -> this.setChildModeless(child);
            Registration listenerRegistration = child.getElement().addDetachListener(event -> ((Registration)registrationCombination.get()).remove());
            registrationCombination.set(Registration.combine(componentRemoval, listenerRegistration));
        }
    }

    public void setChildModeless(Component child) {
        if (this.modalComponentStack == null) {
            return;
        }
        boolean isTopmostModal = this.isTopMostModal(child);
        if (this.modalComponentStack.remove(child) && isTopmostModal) {
            ElementUtil.setIgnoreParentInert(child.getElement(), false);
            if (this.modalComponentStack.isEmpty()) {
                ElementUtil.setInert(this.ui.getElement(), false);
            } else {
                ElementUtil.setIgnoreParentInert(this.modalComponentStack.peek().getElement(), true);
            }
        }
    }

    private boolean isTopMostModal(Component child) {
        return !this.modalComponentStack.isEmpty() && this.modalComponentStack.peek() == child;
    }

    private void removeChildrenContentFromRouterLayout(RouterLayout targetRouterLayout, Map<RouterLayout, HasElement> oldChildren) {
        HasElement oldContent = oldChildren.get(targetRouterLayout);
        RouterLayout removeFrom = targetRouterLayout;
        while (oldContent != null) {
            removeFrom.removeRouterLayoutContent(oldContent);
            if (oldContent instanceof RouterLayout) {
                removeFrom = (RouterLayout)oldContent;
            }
            oldContent = oldChildren.get(oldContent);
        }
    }

    public String getContainerTag() {
        return "flow-container-" + this.getFullAppId().toLowerCase(Locale.ENGLISH);
    }

    private class PendingJavaScriptInvocationDetachListener
    implements Command {
        private final Set<PendingJavaScriptInvocation> invocationList = new HashSet<PendingJavaScriptInvocation>();
        private Registration registration;

        private PendingJavaScriptInvocationDetachListener() {
        }

        @Override
        public void execute() {
            if (!this.invocationList.isEmpty()) {
                ArrayList<PendingJavaScriptInvocation> copy = new ArrayList<PendingJavaScriptInvocation>(this.invocationList);
                this.invocationList.clear();
                copy.forEach(this::removePendingInvocation);
            }
        }

        private void removePendingInvocation(PendingJavaScriptInvocation invocation) {
            UIInternals.this.pendingJsInvocations.removeIf(pendingInvocation -> pendingInvocation.equals(invocation));
            if (this.invocationList.isEmpty() && this.registration != null) {
                this.registration.remove();
                this.registration = null;
            }
        }

        void onInvocationCompleted(PendingJavaScriptInvocation invocation) {
            this.invocationList.remove(invocation);
            this.removePendingInvocation(invocation);
        }
    }

    public static class JavaScriptInvocation
    implements Serializable {
        private final String expression;
        private final List<Serializable> parameters = new ArrayList<Serializable>();

        public JavaScriptInvocation(String expression, Serializable ... parameters) {
            for (Serializable argument : parameters) {
                JsonCodec.encodeWithTypeInfo(argument);
            }
            this.expression = expression;
            Collections.addAll(this.parameters, parameters);
        }

        public String getExpression() {
            return this.expression;
        }

        public List<Object> getParameters() {
            return Collections.unmodifiableList(this.parameters);
        }
    }
}

