/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.shared.BrowserDetails;
import java.io.Serializable;
import java.util.Locale;
import org.slf4j.LoggerFactory;

public class WebBrowser
implements Serializable {
    private String browserApplication = null;
    private Locale locale = null;
    private String address = null;
    private boolean secureConnection = false;
    private BrowserDetails browserDetails = null;

    WebBrowser() {
    }

    WebBrowser(VaadinRequest request) {
        this.locale = request.getLocale();
        this.address = request.getRemoteAddr();
        this.secureConnection = request.isSecure();
        String agent = request.getHeader("User-Agent");
        if (agent != null) {
            this.browserApplication = agent;
            this.browserDetails = new BrowserDetails(agent){

                @Override
                protected void log(String error, Exception e) {
                    LoggerFactory.getLogger(BrowserDetails.class).error(error, (Throwable)e);
                }
            };
        }
    }

    public String getBrowserApplication() {
        return this.browserApplication;
    }

    public String getAddress() {
        return this.address;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isSecureConnection() {
        return this.secureConnection;
    }

    public boolean isFirefox() {
        if (this.browserDetails == null) {
            return false;
        }
        return this.browserDetails.isFirefox();
    }

    public boolean isIE() {
        if (this.browserDetails == null) {
            return false;
        }
        return this.browserDetails.isIE();
    }

    public boolean isEdge() {
        if (this.browserDetails == null) {
            return false;
        }
        return this.browserDetails.isEdge();
    }

    public boolean isSafari() {
        if (this.browserDetails == null) {
            return false;
        }
        return this.browserDetails.isSafari();
    }

    public boolean isOpera() {
        if (this.browserDetails == null) {
            return false;
        }
        return this.browserDetails.isOpera();
    }

    public boolean isChrome() {
        if (this.browserDetails == null) {
            return false;
        }
        return this.browserDetails.isChrome();
    }

    public int getBrowserMajorVersion() {
        if (this.browserDetails == null) {
            return -1;
        }
        return this.browserDetails.getBrowserMajorVersion();
    }

    public int getBrowserMinorVersion() {
        if (this.browserDetails == null) {
            return -1;
        }
        return this.browserDetails.getBrowserMinorVersion();
    }

    public boolean isLinux() {
        if (this.browserDetails == null) {
            return false;
        }
        return this.browserDetails.isLinux();
    }

    public boolean isMacOSX() {
        if (this.browserDetails == null) {
            return false;
        }
        return this.browserDetails.isMacOSX();
    }

    public boolean isWindows() {
        if (this.browserDetails == null) {
            return false;
        }
        return this.browserDetails.isWindows();
    }

    public boolean isWindowsPhone() {
        if (this.browserDetails == null) {
            return false;
        }
        return this.browserDetails.isWindowsPhone();
    }

    public boolean isAndroid() {
        if (this.browserDetails == null) {
            return false;
        }
        return this.browserDetails.isAndroid();
    }

    public boolean isIPhone() {
        if (this.browserDetails == null) {
            return false;
        }
        return this.browserDetails.isIPhone();
    }

    public boolean isChromeOS() {
        if (this.browserDetails == null) {
            return false;
        }
        return this.browserDetails.isChromeOS();
    }
}

