/*
 * Copyright 2000-2024 Vaadin Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.flow.dom;

/**
 * Constants for common element attribute, property, style names.
 *
 * @author Vaadin Ltd
 * @since 1.0
 */
public class ElementConstants {

    /**
     * The style property for width.
     */
    public static final String STYLE_WIDTH = "width";
    /**
     * The style property for min-width.
     */
    public static final String STYLE_MIN_WIDTH = "min-width";
    /**
     * The style property for max-width.
     */
    public static final String STYLE_MAX_WIDTH = "max-width";
    /**
     * The style property for height.
     */
    public static final String STYLE_HEIGHT = "height";
    /**
     * The style property for min-height.
     */
    public static final String STYLE_MIN_HEIGHT = "min-height";
    /**
     * The style property for max-height.
     */
    public static final String STYLE_MAX_HEIGHT = "max-height";
    /**
     * The style property for background.
     */
    public static final String STYLE_BACKGROUND = "background";
    /**
     * The style property for background-color.
     */
    public static final String STYLE_BACKGROUND_COLOR = "background-color";
    /**
     * The style property for background-image.
     */
    public static final String STYLE_BACKGROUND_IMAGE = "background-image";
    /**
     * The style property for color.
     */
    public static final String STYLE_COLOR = "color";
    /**
     * The style property for border.
     */
    public static final String STYLE_BORDER = "border";
    /**
     * The style property for border-left.
     */
    public static final String STYLE_BORDER_LEFT = "border-left";
    /**
     * The style property for border-right.
     */
    public static final String STYLE_BORDER_RIGHT = "border-right";
    /**
     * The style property for border-top.
     */
    public static final String STYLE_BORDER_TOP = "border-top";
    /**
     * The style property for border-bottom.
     */
    public static final String STYLE_BORDER_BOTTOM = "border-bottom";
    /**
     * The style property for border-radius.
     */
    public static final String STYLE_BORDER_RADIUS = "border-radius";
    /**
     * The style property for box-sizing.
     */
    public static final String STYLE_BOX_SIZING = "box-sizing";
    /**
     * The style property for box-shadow.
     */
    public static final String STYLE_BOX_SHADOW = "box-shadow";
    /**
     * The style property for clear.
     */
    public static final String STYLE_CLEAR = "clear";
    /**
     * The style property for cursor.
     */
    public static final String STYLE_CURSOR = "cursor";
    /**
     * The style property for display.
     */
    public static final String STYLE_DISPLAY = "display";
    /**
     * The style property for float.
     */
    public static final String STYLE_FLOAT = "float";
    /**
     * The style property for font.
     */
    public static final String STYLE_FONT = "font";
    /**
     * The style property for margin.
     */
    public static final String STYLE_MARGIN = "margin";
    /**
     * The style property for margin-left.
     */
    public static final String STYLE_MARGIN_LEFT = "margin-left";
    /**
     * The style property for margin-right.
     */
    public static final String STYLE_MARGIN_RIGHT = "margin-right";
    /**
     * The style property for margin-top.
     */
    public static final String STYLE_MARGIN_TOP = "margin-top";
    /**
     * The style property for margin-bottom.
     */
    public static final String STYLE_MARGIN_BOTTOM = "margin-bottom";
    /**
     * The style property for margin-inline-start.
     */
    public static final String STYLE_MARGIN_INLINE_START = "margin-inline-start";
    /**
     * The style property for margin-inline-end.
     */
    public static final String STYLE_MARGIN_INLINE_END = "margin-inline-end";
    /**
     * The style property for outline.
     */
    public static final String STYLE_OUTLINE = "outline";
    /**
     * The style property for opacity.
     */
    public static final String STYLE_OPACITY = "opacity";
    /**
     * The style property for overflow.
     */
    public static final String STYLE_OVERFLOW = "overflow";
    /**
     * The style property for padding.
     */
    public static final String STYLE_PADDING = "padding";
    /**
     * The style property for padding-left.
     */
    public static final String STYLE_PADDING_LEFT = "padding-left";
    /**
     * The style property for padding-right.
     */
    public static final String STYLE_PADDING_RIGHT = "padding-right";
    /**
     * The style property for padding-top.
     */
    public static final String STYLE_PADDING_TOP = "padding-top";
    /**
     * The style property for padding-bottom.
     */
    public static final String STYLE_PADDING_BOTTOM = "padding-bottom";
    /**
     * The style property for position.
     */
    public static final String STYLE_POSITION = "position";
    /**
     * The style property for scale.
     */
    public static final String STYLE_SCALE = "scale";
    /**
     * The style property for text-align.
     */
    public static final String STYLE_TEXT_ALIGN = "text-align";
    /**
     * The style property for text-decoration.
     */
    public static final String STYLE_TEXT_DECORATION = "text-decoration";
    /**
     * The style property for transform.
     */
    public static final String STYLE_TRANSFORM = "transform";
    /**
     * The style property for transform-origin.
     */
    public static final String STYLE_TRANSFORM_ORIGIN = "transform-origin";
    /**
     * The style property for transition.
     */
    public static final String STYLE_TRANSITION = "transition";
    /**
     * The style property for visibility.
     */
    public static final String STYLE_VISIBILITY = "visibility";
    /**
     * The style property for white-space.
     */
    public static final String STYLE_WHITE_SPACE = "white-space";
    /**
     * The style property for left.
     */
    public static final String STYLE_LEFT = "left";
    /**
     * The style property for right.
     */
    public static final String STYLE_RIGHT = "right";
    /**
     * The style property for top.
     */
    public static final String STYLE_TOP = "top";
    /**
     * The style property for bottom.
     */
    public static final String STYLE_BOTTOM = "bottom";
    /**
     * The style property for z-index.
     */
    public static final String STYLE_Z_INDEX = "z-index";
    /**
     * The style property for font-weight.
     */
    public static final String STYLE_FONT_WEIGHT = "font-weight";
    /**
     * The style property for font-size.
     */
    public static final String STYLE_FONT_SIZE = "font-size";
    /**
     * The style property for line-height.
     */
    public static final String STYLE_LINE_HEIGHT = "line-height";
    /**
     * The style property for align-items.
     */
    public static final String STYLE_ALIGN_ITEMS = "align-items";
    /**
     * The style property for align-self.
     */
    public static final String STYLE_ALIGN_SELF = "align-self";
    /**
     * The style property for flex-wrap.
     */
    public static final String STYLE_FLEX_WRAP = "flex-wrap";
    /**
     * The style property for flex-grow.
     */
    public static final String STYLE_FLEX_GROW = "flex-grow";
    /**
     * The style property for flex-shrink.
     */
    public static final String STYLE_FLEX_SHRINK = "flex-shrink";
    /**
     * The style property for justify-content.
     */
    public static final String STYLE_JUSTIFY_CONTENT = "justify-content";
    /**
     * The style property for flex-direction.
     */
    public static final String STYLE_FLEX_DIRECTION = "flex-direction";
    /**
     * The style property for flex-basis.
     */
    public static final String STYLE_FLEX_BASIS = "flex-basis";

    /**
     * The label property.
     */
    public static final String LABEL_PROPERTY_NAME = "label";
    /**
     * The aria-label property.
     *
     * @deprecated use {@link #ARIA_LABEL_ATTRIBUTE_NAME} instead
     */
    public static final String ARIA_LABEL_PROPERTY_NAME = "aria-label";
    /**
     * The aria-label attribute.
     */
    public static final String ARIA_LABEL_ATTRIBUTE_NAME = "aria-label";
    /**
     * The aria-labelledby attribute.
     */
    public static final String ARIA_LABELLEDBY_ATTRIBUTE_NAME = "aria-labelledby";

    private ElementConstants() {
        // Constants only
    }

}
