/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.PushConfiguration;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.JavaScriptBootstrapUI;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.BootstrapHandler;
import com.vaadin.flow.server.DevModeHandler;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinSession;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.function.Function;

public class JavaScriptBootstrapHandler
extends BootstrapHandler {
    public JavaScriptBootstrapHandler() {
        super(context -> null);
    }

    @Override
    protected boolean canHandleRequest(VaadinRequest request) {
        return HandlerHelper.isRequestType(request, HandlerHelper.RequestType.INIT);
    }

    protected String getRequestUrl(VaadinRequest request) {
        return ((VaadinServletRequest)request).getRequestURL().toString();
    }

    @Override
    protected BootstrapHandler.BootstrapContext createAndInitUI(Class<? extends UI> uiClass, VaadinRequest request, VaadinResponse response, VaadinSession session) {
        BootstrapHandler.BootstrapContext context = super.createAndInitUI(JavaScriptBootstrapUI.class, request, response, session);
        JsonObject config = context.getApplicationParameters();
        String requestURL = this.getRequestUrl(request);
        String serviceUrl = JavaScriptBootstrapHandler.getServiceUrl(request);
        String pushURL = context.getSession().getConfiguration().getPushURL();
        if (pushURL == null) {
            pushURL = serviceUrl;
        } else {
            try {
                URI uri = new URI(serviceUrl);
                pushURL = uri.resolve(new URI(pushURL)).toASCIIString();
            }
            catch (URISyntaxException exception) {
                throw new IllegalStateException(String.format("Can't resolve pushURL '%s' based on the service URL '%s'", pushURL, serviceUrl), exception);
            }
        }
        PushConfiguration pushConfiguration = context.getUI().getPushConfiguration();
        pushConfiguration.setPushUrl(pushURL);
        AppShellRegistry registry = AppShellRegistry.getInstance(session.getService().getContext());
        registry.modifyPushConfiguration(pushConfiguration);
        config.put("requestURL", requestURL);
        return context;
    }

    @Override
    protected void initializeUIWithRouter(VaadinRequest request, UI ui) {
        String route = request.getParameter("location");
        if (route != null) {
            try {
                route = URLDecoder.decode(route, "UTF-8").replaceFirst("^/+", "");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
            Location location = new Location(route);
            ui.getSession().setAttribute("clientRoutingMode", Boolean.TRUE);
            ui.getRouter().initializeUI(ui, location);
        }
    }

    @Override
    protected BootstrapHandler.BootstrapContext createBootstrapContext(VaadinRequest request, VaadinResponse response, UI ui, Function<VaadinRequest, String> callback) {
        return new JavaScriptBootstrapContext(request, response, ui, callback);
    }

    @Override
    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        HandlerHelper.setResponseNoCacheHeaders(response::setHeader, response::setDateHeader);
        this.writeResponse(response, this.getInitialJson(request, response, session));
        return true;
    }

    protected static String getServiceUrl(VaadinRequest vaadinRequest) {
        String pathInfo = vaadinRequest.getPathInfo();
        if (pathInfo == null) {
            return ".";
        }
        return HandlerHelper.getCancelingRelativePath(pathInfo);
    }

    private JsonObject getStats() {
        JsonObject stats = Json.createObject();
        UsageStatistics.getEntries().forEach(entry -> {
            String name = entry.getName();
            String version = entry.getVersion();
            JsonObject json = Json.createObject();
            json.put("is", name);
            json.put("version", version);
            String escapedName = Json.create((String)name).toJson();
            stats.put(escapedName, (JsonValue)json);
        });
        return stats;
    }

    private JsonValue getErrors() {
        String errorMsg;
        JsonObject errors = Json.createObject();
        DevModeHandler devMode = DevModeHandler.getDevModeHandler();
        if (devMode != null && (errorMsg = devMode.getFailedOutput()) != null) {
            errors.put("webpack-dev-server", errorMsg);
        }
        return errors.keys().length > 0 ? errors : Json.createNull();
    }

    private void writeResponse(VaadinResponse response, JsonObject json) throws IOException {
        response.setContentType("application/json");
        response.setStatus(200);
        response.getOutputStream().write(JsonUtil.stringify((JsonValue)json).getBytes("UTF-8"));
    }

    protected JsonObject getInitialJson(VaadinRequest request, VaadinResponse response, VaadinSession session) {
        BootstrapHandler.BootstrapContext context = this.createAndInitUI(JavaScriptBootstrapUI.class, request, response, session);
        JsonObject initial = Json.createObject();
        boolean productionMode = context.getSession().getConfiguration().isProductionMode();
        JsonObject appConfig = context.getApplicationParameters();
        appConfig.put("productionMode", (JsonValue)Json.create((boolean)productionMode));
        appConfig.put("appId", context.getAppId());
        appConfig.put("uidl", (JsonValue)JavaScriptBootstrapHandler.getInitialUidl(context.getUI()));
        initial.put("appConfig", (JsonValue)appConfig);
        if (context.getPushMode().isEnabled()) {
            initial.put("pushScript", JavaScriptBootstrapHandler.getPushScript(context));
        }
        if (!session.getConfiguration().isProductionMode()) {
            initial.put("stats", (JsonValue)this.getStats());
        }
        initial.put("errors", this.getErrors());
        return initial;
    }

    private static class JavaScriptBootstrapContext
    extends BootstrapHandler.BootstrapContext {
        private JavaScriptBootstrapContext(VaadinRequest request, VaadinResponse response, UI ui, Function<VaadinRequest, String> callback) {
            super(request, response, ui.getInternals().getSession(), ui, callback);
        }
    }
}

