/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.server.DevModeHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DevServerWatchDog {
    private final WatchDogServer watchDogServer = new WatchDogServer();

    DevServerWatchDog() {
        Thread serverThread = new Thread(this.watchDogServer);
        serverThread.setDaemon(true);
        serverThread.start();
    }

    int getWatchDogPort() {
        return this.watchDogServer.server.getLocalPort();
    }

    void stop() {
        this.watchDogServer.stop();
    }

    private static class WatchDogServer
    implements Runnable {
        private final ServerSocket server;

        WatchDogServer() {
            try {
                this.server = new ServerSocket(0);
                this.server.setSoTimeout(0);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Watchdog server has started on port {}", (Object)this.server.getLocalPort());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not open a server socket", e);
            }
        }

        @Override
        public void run() {
            while (!this.server.isClosed()) {
                try {
                    Socket accept = this.server.accept();
                    accept.setSoTimeout(0);
                    this.enterReloadMessageReadLoop(accept);
                }
                catch (IOException e) {
                    this.getLogger().debug("Error occurred during accept a connection", (Throwable)e);
                }
            }
        }

        void stop() {
            if (this.server != null) {
                try {
                    this.server.close();
                }
                catch (IOException e) {
                    this.getLogger().debug("Error occurred during close the server socket", (Throwable)e);
                }
            }
        }

        private Logger getLogger() {
            return LoggerFactory.getLogger(WatchDogServer.class);
        }

        private void enterReloadMessageReadLoop(Socket accept) throws IOException {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(accept.getInputStream()));
            while ((line = in.readLine()) != null) {
                BrowserLiveReload liveReload;
                if (!"reload".equals(line) || (liveReload = DevModeHandler.getDevModeHandler().getLiveReload()) == null) continue;
                liveReload.reload();
            }
        }
    }
}

