/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;

public class TaskUpdatePackages
extends NodeUpdater {
    private static final String VERSION = "version";
    private static final String SHRINK_WRAP = "@vaadin/vaadin-shrinkwrap";
    protected static final String VAADIN_APP_PACKAGE_HASH = "vaadinAppPackageHash";
    private final boolean forceCleanUp;
    private final boolean enablePnpm;

    TaskUpdatePackages(ClassFinder finder, FrontendDependenciesScanner frontendDependencies, File npmFolder, File generatedPath, File flowResourcesPath, boolean forceCleanUp, boolean enablePnpm) {
        super(finder, frontendDependencies, npmFolder, generatedPath, flowResourcesPath);
        this.forceCleanUp = forceCleanUp;
        this.enablePnpm = enablePnpm;
    }

    @Override
    public void execute() {
        try {
            Map<String, String> deps = this.frontDeps.getPackages();
            JsonObject packageJson = this.getPackageJson();
            this.modified = this.updatePackageJsonDependencies(packageJson, deps);
            if (this.modified) {
                this.writePackageFile(packageJson);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean updatePackageJsonDependencies(JsonObject packageJson, Map<String, String> deps) throws IOException {
        int added = 0;
        JsonObject dependencies = packageJson.getObject("dependencies");
        this.updateFlowFrontendDependencies(dependencies);
        for (Map.Entry<String, String> dep : deps.entrySet()) {
            added += this.addDependency(packageJson, "dependencies", dep.getKey(), dep.getValue());
        }
        if (added > 0) {
            this.log().info("Added {} dependencies to main package.json", (Object)added);
        }
        List dependencyCollection = Stream.concat(deps.entrySet().stream(), TaskUpdatePackages.getDefaultDependencies().entrySet().stream()).map(Map.Entry::getKey).collect(Collectors.toList());
        JsonObject vaadinDependencies = packageJson.getObject("vaadin").getObject("dependencies");
        boolean doCleanUp = this.forceCleanUp;
        int removed = this.removeLegacyProperties(packageJson);
        if (dependencies != null) {
            for (String key : dependencies.keys()) {
                if (dependencyCollection.contains(key) || !vaadinDependencies.hasKey(key)) continue;
                dependencies.remove(key);
                this.log().debug("Removed \"{}\".", (Object)key);
                ++removed;
            }
            boolean bl = doCleanUp = doCleanUp || !this.enablePnpm && !this.ensureReleaseVersion(dependencies);
        }
        if (removed > 0) {
            this.log().info("Removed {} dependencies", (Object)removed);
        }
        if (doCleanUp) {
            this.cleanUp();
        }
        String oldHash = packageJson.getObject("vaadin").getString("hash");
        String newHash = TaskUpdatePackages.generatePackageJsonHash(packageJson);
        packageJson.getObject("vaadin").put("hash", newHash);
        return added > 0 || removed > 0 || !oldHash.equals(newHash);
    }

    private int updateFlowFrontendDependencies(JsonObject json) {
        return this.updateNpmLocalDependency(json, "@vaadin/flow-frontend", this.flowResourcesFolder) + this.updateNpmLocalDependency(json, "@vaadin/form", this.formResourcesFolder);
    }

    private int updateNpmLocalDependency(JsonObject json, String packageName, File folder) {
        if (folder != null) {
            String depsPkg = "./" + FrontendUtils.getUnixRelativePath(this.npmFolder.getAbsoluteFile().toPath(), folder.getAbsoluteFile().toPath());
            if (!json.hasKey(packageName) || !depsPkg.equals(json.getString(packageName))) {
                json.put(packageName, depsPkg);
                return 1;
            }
        } else if (json.hasKey(packageName)) {
            json.remove(packageName);
            return 1;
        }
        return 0;
    }

    private boolean ensureReleaseVersion(JsonObject dependencies) throws IOException {
        String shrinkWrapVersion = null;
        if (dependencies.hasKey(SHRINK_WRAP)) {
            shrinkWrapVersion = dependencies.getString(SHRINK_WRAP);
        }
        return Objects.equals(shrinkWrapVersion, this.getCurrentShrinkWrapVersion());
    }

    private int removeLegacyProperties(JsonObject packageJson) throws IOException {
        JsonObject object;
        int result = 0;
        if (packageJson.hasKey("dependencies") && (object = packageJson.getObject("dependencies")).hasKey("@vaadin/flow-deps")) {
            object.remove("@vaadin/flow-deps");
            this.log().debug("Removed \"{}\" as it's not generated anymore.", (Object)"@vaadin/flow-deps");
            ++result;
        }
        if (packageJson.hasKey(VAADIN_APP_PACKAGE_HASH)) {
            packageJson.remove(VAADIN_APP_PACKAGE_HASH);
            this.log().debug("Removed \"{}\" as it's not used.", (Object)VAADIN_APP_PACKAGE_HASH);
            ++result;
        }
        if (!this.enablePnpm) {
            return result;
        }
        File packageLockFile = this.getPackageLockFile();
        if (packageLockFile.exists()) {
            FileUtils.forceDelete((File)this.getPackageLockFile());
        }
        return result;
    }

    private void cleanUp() throws IOException {
        File generatedNodeModules;
        File packageLock = this.getPackageLockFile();
        if (packageLock.exists() && !packageLock.delete()) {
            throw new IOException("Could not remove " + packageLock.getPath() + " file. This file has been generated with a different platform version. Try to remove it manually.");
        }
        this.removeDir(this.nodeModulesFolder);
        if (this.flowResourcesFolder != null && this.flowResourcesFolder.exists()) {
            for (File file : this.flowResourcesFolder.listFiles()) {
                if (file.getName().equals("package.json")) continue;
                file.delete();
            }
        }
        if ((generatedNodeModules = new File(this.generatedFolder, "node_modules/")).exists()) {
            this.removeDir(generatedNodeModules);
        }
    }

    private void removeDir(File folder) throws IOException {
        FileUtils.deleteDirectory((File)folder);
    }

    private String getCurrentShrinkWrapVersion() throws IOException {
        String shrinkWrapVersion = this.getShrinkWrapVersion(this.getPackageJson());
        if (shrinkWrapVersion != null) {
            return shrinkWrapVersion;
        }
        shrinkWrapVersion = this.getPackageLockShrinkWrapVersion();
        return shrinkWrapVersion;
    }

    private String getPackageLockShrinkWrapVersion() throws IOException {
        JsonObject dependencies = this.getPackageLockDependencies();
        if (dependencies == null) {
            return null;
        }
        if (!dependencies.hasKey(SHRINK_WRAP)) {
            return null;
        }
        JsonObject shrinkWrap = dependencies.getObject(SHRINK_WRAP);
        if (shrinkWrap.hasKey(VERSION)) {
            return shrinkWrap.get(VERSION).asString();
        }
        return null;
    }

    private JsonObject getPackageLockDependencies() throws IOException {
        File packageLock = this.getPackageLockFile();
        if (!packageLock.exists()) {
            return null;
        }
        JsonObject packageLockJson = TaskUpdatePackages.getJsonFileContent(packageLock);
        if (packageLockJson == null) {
            return null;
        }
        if (!packageLockJson.hasKey("dependencies")) {
            return null;
        }
        JsonObject dependencies = packageLockJson.getObject("dependencies");
        return dependencies;
    }

    private File getPackageLockFile() {
        return new File(this.npmFolder, "package-lock.json");
    }

    private String getShrinkWrapVersion(JsonObject packageJson) {
        JsonObject dependencies;
        if (packageJson == null) {
            return null;
        }
        if (packageJson.hasKey("dependencies") && (dependencies = packageJson.getObject("dependencies")).hasKey(SHRINK_WRAP)) {
            JsonValue value = dependencies.get(SHRINK_WRAP);
            return value.asString();
        }
        return null;
    }

    static String generatePackageJsonHash(JsonObject packageJson) {
        StringBuilder hashContent = new StringBuilder();
        if (packageJson.hasKey("dependencies")) {
            JsonObject dependencies = packageJson.getObject("dependencies");
            hashContent.append("\"dependencies\": {");
            String sortedDependencies = Arrays.stream(dependencies.keys()).sorted(String::compareToIgnoreCase).map(key -> String.format("\"%s\": \"%s\"", key, dependencies.getString(key))).collect(Collectors.joining(",\n  "));
            hashContent.append(sortedDependencies);
            hashContent.append("}");
        }
        if (packageJson.hasKey("devDependencies")) {
            if (hashContent.length() > 0) {
                hashContent.append(",\n");
            }
            JsonObject devDependencies = packageJson.getObject("devDependencies");
            hashContent.append("\"devDependencies\": {");
            String sortedDevDependencies = Arrays.stream(devDependencies.keys()).sorted(String::compareToIgnoreCase).map(key -> String.format("\"%s\": \"%s\"", key, devDependencies.getString(key))).collect(Collectors.joining(",\n  "));
            hashContent.append(sortedDevDependencies);
            hashContent.append("}");
        }
        return TaskUpdatePackages.getHash(hashContent.toString());
    }

    private static String getHash(String content) {
        if (content.isEmpty()) {
            return content;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return TaskUpdatePackages.bytesToHex(digest.digest(content.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to find a provider for SHA-256 algorithm", e);
        }
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder result = new StringBuilder();
        for (byte bit : hash) {
            String hex = Integer.toHexString(0xFF & bit);
            if (hex.length() == 1) {
                result.append('0');
            }
            result.append(hex);
        }
        return result.toString();
    }
}

