/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.PushConfiguration;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.component.page.BodySize;
import com.vaadin.flow.component.page.Inline;
import com.vaadin.flow.component.page.Meta;
import com.vaadin.flow.component.page.Push;
import com.vaadin.flow.component.page.TargetElement;
import com.vaadin.flow.component.page.Viewport;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.server.AppShellSettings;
import com.vaadin.flow.server.InvalidApplicationConfigurationException;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.startup.AbstractAnnotationValidator;
import com.vaadin.flow.server.startup.AppShellPredicate;
import com.vaadin.flow.server.startup.VaadinAppShellInitializer;
import com.vaadin.flow.theme.Theme;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class AppShellRegistry
implements Serializable {
    public static final String ERROR_HEADER_NO_SHELL = "%n%nFound app shell configuration annotations in non `AppShellConfigurator` classes.%nPlease create a custom class implementing `AppShellConfigurator` and move the following annotations to it:%n  %s%n";
    public static final String ERROR_HEADER_OFFENDING_PWA = "%n%nWe changed the way you configure PWAs, please see this link for more info:%nhttps://vaadin.com/docs/v15/flow/advanced/tutorial-modifying-the-bootstrap-page.html%n";
    public static final String ERROR_HEADER_NO_APP_CONFIGURATOR = "%n%nThe `PageConfigurator` interface is deprecated since Vaadin 15 and has no effect.%nPlease, create a class implementing `AppShellConfigurator`, and remove `PageConfigurator` from: %n  - %s%n";
    public static final String ERROR_HEADER_OFFENDING_CONFIGURATOR = "%n%nThe `PageConfigurator` interface is deprecated since Vaadin 15 and has no effect.%nPlease, configure the page in %s, and remove the `PageConfigurator` from: %n - %s%n";
    private static final String ERROR_LINE = "  - %s from %s";
    private static final String ERROR_MULTIPLE_SHELL = "%n%nUnable to find a single class implementing `AppShellConfigurator` from the following candidates:%n  %s%n  %s%n";
    private static final String ERROR_MULTIPLE_ANNOTATION = "%n%s is not a repeatable annotation type.%n";
    private static final String[] UNIQUE_ELEMENTS = new String[]{"meta[name=viewport]", "meta[name=description]", "title", "base"};
    private Class<? extends AppShellConfigurator> appShellClass;
    private final Lookup lookup;

    private AppShellRegistry(VaadinContext context) {
        this.lookup = context.getAttribute(Lookup.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AppShellRegistry getInstance(VaadinContext context) {
        VaadinContext vaadinContext = context;
        synchronized (vaadinContext) {
            AppShellRegistryWrapper attribute = context.getAttribute(AppShellRegistryWrapper.class);
            if (attribute == null) {
                attribute = new AppShellRegistryWrapper(new AppShellRegistry(context));
                context.setAttribute(attribute);
            }
            return attribute.registry;
        }
    }

    public void reset() {
        this.appShellClass = null;
    }

    public void setShell(Class<? extends AppShellConfigurator> shell) {
        if (this.appShellClass != null && shell != null) {
            throw new InvalidApplicationConfigurationException(String.format(ERROR_MULTIPLE_SHELL, this.appShellClass.getName(), shell.getName()));
        }
        this.appShellClass = shell;
    }

    public Class<? extends AppShellConfigurator> getShell() {
        return this.appShellClass;
    }

    @Deprecated
    public boolean isShell(Class<?> clz) {
        assert (clz != null);
        AppShellPredicate predicate = this.lookup.lookup(AppShellPredicate.class);
        return predicate.isShell(clz);
    }

    public String validateClass(Class<?> clz) {
        String offending;
        String error = null;
        List<Class<?>> validOnlyForAppShell = VaadinAppShellInitializer.getValidAnnotations();
        validOnlyForAppShell.remove(PageTitle.class);
        if (WebComponentExporter.class.isAssignableFrom(clz)) {
            validOnlyForAppShell.remove(Theme.class);
            validOnlyForAppShell.remove(Push.class);
        }
        if (!(offending = AbstractAnnotationValidator.getClassAnnotations(clz, validOnlyForAppShell)).isEmpty()) {
            error = String.format(ERROR_LINE, offending, clz.getName());
        }
        return error;
    }

    private AppShellSettings createSettings() {
        List<PageTitle> pageTitles;
        List<BodySize> bodySizes;
        AppShellSettings settings = new AppShellSettings();
        this.getAnnotations(Meta.class).forEach(meta -> settings.addMetaTag(meta.name(), meta.content()));
        List<Viewport> viewPorts = this.getAnnotations(Viewport.class);
        if (viewPorts.size() > 1) {
            throw new InvalidApplicationConfigurationException(String.format(ERROR_MULTIPLE_ANNOTATION, Viewport.class.getSimpleName()));
        }
        if (!viewPorts.isEmpty()) {
            settings.setViewport(viewPorts.get(0).value());
        }
        if ((bodySizes = this.getAnnotations(BodySize.class)).size() > 1) {
            throw new InvalidApplicationConfigurationException(String.format(ERROR_MULTIPLE_ANNOTATION, BodySize.class.getSimpleName()));
        }
        if (!bodySizes.isEmpty()) {
            settings.setBodySize(bodySizes.get(0).width(), bodySizes.get(0).height());
        }
        if ((pageTitles = this.getAnnotations(PageTitle.class)).size() > 1) {
            throw new InvalidApplicationConfigurationException(String.format(ERROR_MULTIPLE_ANNOTATION, PageTitle.class.getSimpleName()));
        }
        if (!pageTitles.isEmpty()) {
            settings.setPageTitle(pageTitles.get(0).value());
        }
        this.getAnnotations(Inline.class).forEach(settings::addInline);
        return settings;
    }

    public void modifyIndexHtml(Document document, VaadinRequest request) {
        AppShellSettings settings = this.createSettings();
        if (this.appShellClass != null) {
            VaadinService.getCurrent().getInstantiator().getOrCreate(this.appShellClass).configurePage(settings);
        }
        settings.getHeadElements(Inline.Position.PREPEND).forEach(elm -> this.insertElement((Element)elm, arg_0 -> ((Element)document.head()).prependChild(arg_0)));
        settings.getHeadElements(Inline.Position.APPEND).forEach(elm -> this.insertElement((Element)elm, arg_0 -> ((Element)document.head()).appendChild(arg_0)));
        settings.getInlineElements(request, TargetElement.HEAD, Inline.Position.PREPEND).forEach(elm -> this.insertInlineElement((Element)elm, arg_0 -> ((Element)document.head()).prependChild(arg_0)));
        settings.getInlineElements(request, TargetElement.HEAD, Inline.Position.APPEND).forEach(elm -> this.insertInlineElement((Element)elm, arg_0 -> ((Element)document.head()).appendChild(arg_0)));
        settings.getInlineElements(request, TargetElement.BODY, Inline.Position.PREPEND).forEach(elm -> this.insertInlineElement((Element)elm, arg_0 -> ((Element)document.body()).prependChild(arg_0)));
        settings.getInlineElements(request, TargetElement.BODY, Inline.Position.APPEND).forEach(elm -> this.insertInlineElement((Element)elm, arg_0 -> ((Element)document.body()).appendChild(arg_0)));
    }

    public void modifyPushConfiguration(PushConfiguration pushConfiguration) {
        List<Push> pushAnnotations = this.getAnnotations(Push.class);
        if (pushAnnotations.size() > 1) {
            throw new InvalidApplicationConfigurationException(String.format(ERROR_MULTIPLE_ANNOTATION, Push.class.getSimpleName()));
        }
        if (!pushAnnotations.isEmpty()) {
            Push push = pushAnnotations.get(0);
            pushConfiguration.setPushMode(push.value());
            pushConfiguration.setTransport(push.transport());
        }
    }

    private void insertElement(Element elm, Consumer<Element> action) {
        action.accept(elm);
        for (String cssQuery : UNIQUE_ELEMENTS) {
            if (!elm.is(cssQuery)) continue;
            Element first = elm.parent().selectFirst(cssQuery);
            if (first == elm || first == null) break;
            first.replaceWith((Node)elm);
            break;
        }
    }

    private void insertInlineElement(Element elm, Consumer<Element> action) {
        if (elm instanceof Document) {
            elm.getAllElements().stream().filter(item -> !(item instanceof Document) && elm.equals((Object)item.parent())).forEach(action::accept);
        } else if (elm != null) {
            action.accept(elm);
        }
    }

    public String toString() {
        return "Shell: " + this.appShellClass + " metas: " + this.getAnnotations(Meta.class);
    }

    private <T extends Annotation> List<T> getAnnotations(Class<T> annotation) {
        assert (VaadinAppShellInitializer.getValidAnnotations().contains(annotation));
        return this.appShellClass == null ? Collections.emptyList() : Arrays.asList(this.appShellClass.getAnnotationsByType(annotation));
    }

    public static class AppShellRegistryWrapper
    implements Serializable {
        private final AppShellRegistry registry;

        public AppShellRegistryWrapper(AppShellRegistry registry) {
            this.registry = registry;
        }
    }
}

