/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FrontendVersion
implements Serializable,
Comparable<FrontendVersion> {
    private final Pattern buildIdentifierParser;
    private final String version;
    private final int majorVersion;
    private final int minorVersion;
    private final int revision;
    private final String buildIdentifier;

    public FrontendVersion(int major, int minor) {
        this(major, minor, 0);
    }

    public FrontendVersion(int major, int minor, int revision) {
        this(major, minor, revision, "");
    }

    public FrontendVersion(int major, int minor, int revision, String build) {
        this.buildIdentifierParser = Pattern.compile("(\\D*)(\\d*)");
        this.version = build.isEmpty() ? major + "." + minor + "." + revision : major + "." + minor + "." + revision + "." + build;
        this.majorVersion = major;
        this.minorVersion = minor;
        this.revision = revision;
        this.buildIdentifier = build;
    }

    public FrontendVersion(String version) {
        this(null, version);
    }

    public FrontendVersion(String name, String version) {
        int revisionNumber;
        String build;
        block10: {
            this.buildIdentifierParser = Pattern.compile("(\\D*)(\\d*)");
            Objects.requireNonNull(version);
            if (version.isEmpty()) {
                throw new NumberFormatException(this.getInvalidVersionMessage(name, version));
            }
            this.version = !Character.isDigit(version.charAt(0)) ? version.substring(1).trim() : version.trim();
            String[] digits = this.version.split("[-.]", 4);
            try {
                this.majorVersion = Integer.parseInt(digits[0]);
            }
            catch (NumberFormatException nfe) {
                throw new NumberFormatException(this.getInvalidVersionMessage(name, version));
            }
            if (digits.length >= 2) {
                try {
                    this.minorVersion = Integer.parseInt(digits[1]);
                }
                catch (NumberFormatException nfe) {
                    throw new NumberFormatException(this.getInvalidVersionMessage(name, version));
                }
            } else {
                this.minorVersion = 0;
            }
            build = "";
            try {
                int n = revisionNumber = digits.length >= 3 ? Integer.parseInt(digits[2]) : 0;
                if (digits.length == 4) {
                    build = digits[3];
                }
            }
            catch (NumberFormatException e) {
                revisionNumber = 0;
                if (digits.length < 3) break block10;
                build = digits[2];
            }
        }
        this.revision = revisionNumber;
        this.buildIdentifier = build;
    }

    public String getFullVersion() {
        return this.version;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getBuildIdentifier() {
        return this.buildIdentifier;
    }

    public boolean isOlderThan(FrontendVersion otherVersion) {
        return this.compareTo(otherVersion) < 0;
    }

    public boolean isNewerThan(FrontendVersion otherVersion) {
        return this.compareTo(otherVersion) > 0;
    }

    public boolean isEqualTo(FrontendVersion otherVersion) {
        return this.compareTo(otherVersion) == 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FrontendVersion) {
            FrontendVersion other = (FrontendVersion)obj;
            return this.majorVersion == other.getMajorVersion() && this.minorVersion == other.getMinorVersion() && this.revision == other.getRevision() && this.buildIdentifier.equals(other.getBuildIdentifier());
        }
        return false;
    }

    public int hashCode() {
        return (this.majorVersion + "." + this.minorVersion + "." + this.revision + "." + this.buildIdentifier).hashCode();
    }

    @Override
    public int compareTo(FrontendVersion other) {
        if (this.majorVersion != other.majorVersion) {
            return Integer.compare(this.majorVersion, other.majorVersion);
        }
        if (this.minorVersion != other.minorVersion) {
            return Integer.compare(this.minorVersion, other.minorVersion);
        }
        if (this.revision != other.revision) {
            return Integer.compare(this.revision, other.revision);
        }
        if (this.buildIdentifier != other.buildIdentifier) {
            if (this.buildIdentifier.isEmpty() && !other.buildIdentifier.isEmpty()) {
                return 1;
            }
            if (!this.buildIdentifier.isEmpty() && other.buildIdentifier.isEmpty()) {
                return -1;
            }
            return this.compareBuildIdentifier(other);
        }
        return 0;
    }

    private int compareBuildIdentifier(FrontendVersion other) {
        Matcher thisMatcher = this.buildIdentifierParser.matcher(this.buildIdentifier);
        Matcher otherMatcher = this.buildIdentifierParser.matcher(other.buildIdentifier);
        if (thisMatcher.find() && otherMatcher.find()) {
            if (thisMatcher.group(1).compareToIgnoreCase(otherMatcher.group(1)) != 0) {
                if (thisMatcher.group(1).isEmpty()) {
                    return 1;
                }
                if (otherMatcher.group(1).isEmpty()) {
                    return -1;
                }
                return thisMatcher.group(1).compareToIgnoreCase(otherMatcher.group(1));
            }
            if (thisMatcher.group(2).isEmpty() || otherMatcher.group(2).isEmpty()) {
                return this.buildIdentifier.compareToIgnoreCase(other.buildIdentifier);
            }
            return Integer.parseInt(thisMatcher.group(2)) - Integer.parseInt(otherMatcher.group(2));
        }
        return this.buildIdentifier.compareToIgnoreCase(other.buildIdentifier);
    }

    private String getInvalidVersionMessage(String name, String version) {
        if (name != null) {
            return String.format("'%s' is not a valid version for '%s'!", version, name);
        }
        return String.format("'%s' is not a valid version!", version);
    }
}

