/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.RouteBaseData;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.RoutesChangedEvent;
import com.vaadin.flow.router.RoutesChangedListener;
import com.vaadin.flow.router.internal.AbstractRouteRegistry;
import com.vaadin.flow.router.internal.ConfiguredRoutes;
import com.vaadin.flow.router.internal.NavigationRouteTarget;
import com.vaadin.flow.router.internal.PathUtil;
import com.vaadin.flow.router.internal.RouteTarget;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class SessionRouteRegistry
extends AbstractRouteRegistry {
    private final VaadinSession session;

    SessionRouteRegistry(VaadinSession session) {
        this.session = session;
    }

    public static RouteRegistry getSessionRegistry(VaadinSession session) {
        Objects.requireNonNull(session, "Null session is not supported for session route registry");
        SessionRouteRegistry registry = session.getAttribute(SessionRouteRegistry.class);
        if (registry == null) {
            registry = new SessionRouteRegistry(session);
            session.setAttribute(SessionRouteRegistry.class, registry);
        }
        if (!registry.session.equals(session)) {
            throw new IllegalStateException("Session has as the attribute a route registered to another session");
        }
        return registry;
    }

    @Override
    public List<RouteData> getRegisteredRoutes() {
        ArrayList<RouteData> routes = new ArrayList<RouteData>(super.getRegisteredRoutes());
        List<RouteData> registeredRoutes = this.getParentRegistry().getRegisteredRoutes();
        if (!registeredRoutes.isEmpty()) {
            Set collect = routes.stream().map(RouteBaseData::getTemplate).collect(Collectors.toSet());
            registeredRoutes.stream().filter(data -> !collect.contains(data.getTemplate())).forEach(routes::add);
        }
        return routes;
    }

    @Override
    public Registration addRoutesChangeListener(RoutesChangedListener listener) {
        Registration parentRegistration = this.getParentRegistry().addRoutesChangeListener(event -> {
            ConfiguredRoutes configuration = this.getConfiguration();
            List<RouteBaseData<?>> addedVisible = event.getAddedRoutes().stream().filter(routeData -> !configuration.hasTemplate(routeData.getTemplate())).collect(Collectors.toList());
            List<RouteBaseData<?>> removedVisible = event.getRemovedRoutes().stream().filter(routeData -> !configuration.hasTemplate(routeData.getTemplate())).collect(Collectors.toList());
            if (!addedVisible.isEmpty() || !removedVisible.isEmpty()) {
                this.fireEvent(new RoutesChangedEvent(event.getSource(), addedVisible, removedVisible));
            }
        });
        Registration registration = super.addRoutesChangeListener(listener);
        return () -> {
            registration.remove();
            parentRegistration.remove();
        };
    }

    @Override
    public NavigationRouteTarget getNavigationRouteTarget(String url) {
        NavigationRouteTarget navigationRouteTarget = this.getConfiguration().getNavigationRouteTarget(url);
        if (navigationRouteTarget.hasTarget()) {
            return navigationRouteTarget;
        }
        return this.getParentRegistry().getNavigationRouteTarget(url);
    }

    @Override
    public RouteTarget getRouteTarget(Class<? extends Component> target, RouteParameters parameters) {
        RouteTarget routeTarget = this.getConfiguration().getRouteTarget(target, parameters);
        if (routeTarget != null) {
            return routeTarget;
        }
        return this.getParentRegistry().getRouteTarget(target, parameters);
    }

    @Override
    public Optional<Class<? extends Component>> getNavigationTarget(String url) {
        Objects.requireNonNull(url, "pathString must not be null.");
        Optional<Class<? extends Component>> target = this.getConfiguration().getTarget(url);
        if (target.isPresent()) {
            return target;
        }
        return this.getParentRegistry().getNavigationTarget(url);
    }

    @Override
    public Optional<Class<? extends Component>> getNavigationTarget(String url, List<String> segments) {
        Objects.requireNonNull(url, "url must not be null.");
        Optional<Class<? extends Component>> target = this.getConfiguration().getTarget(PathUtil.getPath(url, segments));
        if (target.isPresent()) {
            return target;
        }
        return this.getParentRegistry().getNavigationTarget(url, segments);
    }

    @Override
    public Optional<String> getTargetUrl(Class<? extends Component> navigationTarget) {
        Optional<String> targetUrl = super.getTargetUrl(navigationTarget);
        if (targetUrl.isPresent()) {
            return targetUrl;
        }
        return this.getParentRegistry().getTargetUrl(navigationTarget);
    }

    @Override
    public Optional<String> getTargetUrl(Class<? extends Component> navigationTarget, RouteParameters parameters) {
        Optional<String> targetUrl = super.getTargetUrl(navigationTarget, parameters);
        if (targetUrl.isPresent()) {
            return targetUrl;
        }
        return this.getParentRegistry().getTargetUrl(navigationTarget, parameters);
    }

    @Override
    public Optional<String> getTemplate(Class<? extends Component> navigationTarget) {
        Optional<String> targetRoute = super.getTemplate(navigationTarget);
        if (targetRoute.isPresent()) {
            return targetRoute;
        }
        return this.getParentRegistry().getTemplate(navigationTarget);
    }

    @Override
    public VaadinContext getContext() {
        return this.session.getService().getContext();
    }

    @Override
    @Deprecated
    public List<Class<? extends RouterLayout>> getRouteLayouts(String path, Class<? extends Component> navigationTarget) {
        NavigationRouteTarget navigationRouteTarget = this.getConfiguration().getNavigationRouteTarget(path);
        if (navigationRouteTarget.hasTarget()) {
            return navigationRouteTarget.getRouteTarget().getParentLayouts();
        }
        return this.getParentRegistry().getRouteLayouts(path, navigationTarget);
    }

    private RouteRegistry getParentRegistry() {
        return this.session.getService().getRouteRegistry();
    }
}

